/* window.c generated by valac 0.46.3, the Vala compiler
 * generated from window.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <../config.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

typedef enum  {
	PASANG_MODE_USER_VS_AI,
	PASANG_MODE_USER_VS_USER,
	PASANG_MODE_AI_VS_AI,
	PASANG_MODE_NETWORK
} PasangMode;

#define PASANG_TYPE_MODE (pasang_mode_get_type ())

#define PASANG_TYPE_WINDOW (pasang_window_get_type ())
#define PASANG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_WINDOW, PasangWindow))
#define PASANG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_WINDOW, PasangWindowClass))
#define PASANG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_WINDOW))
#define PASANG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_WINDOW))
#define PASANG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_WINDOW, PasangWindowClass))

typedef struct _PasangWindow PasangWindow;
typedef struct _PasangWindowClass PasangWindowClass;
typedef struct _PasangWindowPrivate PasangWindowPrivate;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;

#define PASANG_TYPE_GAME_SERIES (pasang_game_series_get_type ())
#define PASANG_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeries))
#define PASANG_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))
#define PASANG_IS_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_SERIES))
#define PASANG_IS_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_SERIES))
#define PASANG_GAME_SERIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))

typedef struct _PasangGameSeries PasangGameSeries;
typedef struct _PasangGameSeriesClass PasangGameSeriesClass;

#define PASANG_TYPE_GAME_MENU (pasang_game_menu_get_type ())
#define PASANG_GAME_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_MENU, PasangGameMenu))
#define PASANG_GAME_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_MENU, PasangGameMenuClass))
#define PASANG_IS_GAME_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_MENU))
#define PASANG_IS_GAME_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_MENU))
#define PASANG_GAME_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_MENU, PasangGameMenuClass))

typedef struct _PasangGameMenu PasangGameMenu;
typedef struct _PasangGameMenuClass PasangGameMenuClass;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;

#define PASANG_TYPE_PATTERN_SELECTOR (pasang_pattern_selector_get_type ())
#define PASANG_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelector))
#define PASANG_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))
#define PASANG_IS_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_IS_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_PATTERN_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))

typedef struct _PasangPatternSelector PasangPatternSelector;
typedef struct _PasangPatternSelectorClass PasangPatternSelectorClass;

#define PASANG_TYPE_PATTERN_EDITOR (pasang_pattern_editor_get_type ())
#define PASANG_PATTERN_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditor))
#define PASANG_PATTERN_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditorClass))
#define PASANG_IS_PATTERN_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN_EDITOR))
#define PASANG_IS_PATTERN_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN_EDITOR))
#define PASANG_PATTERN_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditorClass))

typedef struct _PasangPatternEditor PasangPatternEditor;
typedef struct _PasangPatternEditorClass PasangPatternEditorClass;

#define PASANG_TYPE_BRAIN (pasang_brain_get_type ())
#define PASANG_BRAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_BRAIN, PasangBrain))
#define PASANG_BRAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_BRAIN, PasangBrainClass))
#define PASANG_IS_BRAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_BRAIN))
#define PASANG_IS_BRAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_BRAIN))
#define PASANG_BRAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_BRAIN, PasangBrainClass))

typedef struct _PasangBrain PasangBrain;
typedef struct _PasangBrainClass PasangBrainClass;

#define PASANG_TYPE_CLIENT (pasang_client_get_type ())
#define PASANG_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CLIENT, PasangClient))
#define PASANG_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CLIENT, PasangClientClass))
#define PASANG_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CLIENT))
#define PASANG_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CLIENT))
#define PASANG_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CLIENT, PasangClientClass))

typedef struct _PasangClient PasangClient;
typedef struct _PasangClientClass PasangClientClass;

#define PASANG_TYPE_BRAIN_SPEC (pasang_brain_spec_get_type ())
typedef struct _PasangBrainSpec PasangBrainSpec;
enum  {
	PASANG_WINDOW_0_PROPERTY,
	PASANG_WINDOW_MODE_PROPERTY,
	PASANG_WINDOW_NUM_PROPERTIES
};
static GParamSpec* pasang_window_properties[PASANG_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
typedef struct _Block9Data Block9Data;
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())
typedef enum  {
	PASANG_PLAYER_AI,
	PASANG_PLAYER_HUMAN,
	PASANG_PLAYER_REMOTE
} PasangPlayer;

#define PASANG_TYPE_PLAYER (pasang_player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PasangGameMenuPrivate PasangGameMenuPrivate;

#define PASANG_TYPE_BRAIN_SETTER (pasang_brain_setter_get_type ())
#define PASANG_BRAIN_SETTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_BRAIN_SETTER, PasangBrainSetter))
#define PASANG_BRAIN_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_BRAIN_SETTER, PasangBrainSetterClass))
#define PASANG_IS_BRAIN_SETTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_BRAIN_SETTER))
#define PASANG_IS_BRAIN_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_BRAIN_SETTER))
#define PASANG_BRAIN_SETTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_BRAIN_SETTER, PasangBrainSetterClass))

typedef struct _PasangBrainSetter PasangBrainSetter;
typedef struct _PasangBrainSetterClass PasangBrainSetterClass;
typedef struct _PasangBrainSetterPrivate PasangBrainSetterPrivate;
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
typedef struct _PasangGameSeriesPrivate PasangGameSeriesPrivate;

#define PASANG_TYPE_THEME_SWITCH (pasang_theme_switch_get_type ())
#define PASANG_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch))
#define PASANG_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))
#define PASANG_IS_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME_SWITCH))
#define PASANG_IS_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME_SWITCH))
#define PASANG_THEME_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))

typedef struct _PasangThemeSwitch PasangThemeSwitch;
typedef struct _PasangThemeSwitchClass PasangThemeSwitchClass;
typedef struct _PasangWindowStartDemoRoundData PasangWindowStartDemoRoundData;
typedef struct _PasangWindowEndDemoRoundData PasangWindowEndDemoRoundData;

#define PASANG_TYPE_MENU_MAKER (pasang_menu_maker_get_type ())
#define PASANG_MENU_MAKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MENU_MAKER, PasangMenuMaker))
#define PASANG_MENU_MAKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MENU_MAKER, PasangMenuMakerClass))
#define PASANG_IS_MENU_MAKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MENU_MAKER))
#define PASANG_IS_MENU_MAKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MENU_MAKER))
#define PASANG_MENU_MAKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MENU_MAKER, PasangMenuMakerClass))

typedef struct _PasangMenuMaker PasangMenuMaker;
typedef struct _PasangMenuMakerClass PasangMenuMakerClass;
typedef void (*PasangMenuMakerActivateFunc) (gpointer user_data);
#define _pasang_menu_maker_unref0(var) ((var == NULL) ? NULL : (var = (pasang_menu_maker_unref (var), NULL)))
typedef struct _PasangClientPrivate PasangClientPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PasangWindow {
	GtkStack parent_instance;
	PasangWindowPrivate * priv;
};

struct _PasangWindowClass {
	GtkStackClass parent_class;
};

struct _PasangBrainSpec {
	gint thinking_time;
	gint thinking_depth;
	gint discernment;
};

struct _PasangWindowPrivate {
	GtkApplicationWindow* main_window;
	GtkHeaderBar* header_bar;
	GtkWidget* theme_menu_button;
	GtkWidget* go_back_button;
	GtkWidget* pattern_go_back_button;
	PasangGameSeries* game;
	PasangGameMenu* game_menu;
	PasangGameView* game_view;
	PasangPatternSelector* pattern_selector;
	PasangPatternEditor* pattern_editor;
	PasangBrain* brain;
	PasangClient* client;
	PasangMode _mode;
	PasangBrainSpec demo_player;
	glong request_ticket;
	gint demo_ticket;
};

struct _Block9Data {
	int _ref_count_;
	PasangWindow* self;
	glong response_ticket;
	PasangMove* response;
};

struct _PasangGameMenu {
	GtkScrolledWindow parent_instance;
	PasangGameMenuPrivate * priv;
	PasangBrainSetter* brain_setter;
};

struct _PasangGameMenuClass {
	GtkScrolledWindowClass parent_class;
};

struct _PasangBrainSetter {
	GtkGrid parent_instance;
	PasangBrainSetterPrivate * priv;
	PasangBrainSpec brain_spec;
};

struct _PasangBrainSetterClass {
	GtkGridClass parent_class;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGameSeries {
	PasangGame parent_instance;
	PasangGameSeriesPrivate * priv;
	gboolean rotated;
	gint num_wins[2];
	gint num_rounds;
};

struct _PasangGameSeriesClass {
	PasangGameClass parent_class;
};

struct _PasangWindowStartDemoRoundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangWindow* self;
	gint my_demo_ticket;
	PasangGameView* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangPatternSelector* _tmp2_;
	PasangPatternSelector* _tmp3_;
	PasangPatternSelector* _tmp4_;
	gboolean _tmp5_;
	PasangMode _tmp6_;
	PasangPatternSelector* _tmp7_;
	gboolean _tmp8_;
	PasangMode _tmp9_;
	PasangGameView* _tmp10_;
	PasangThemeSwitch* _tmp11_;
	PasangThemeSwitch* _tmp12_;
	PasangGameView* _tmp13_;
	gboolean _tmp14_;
	PasangMode _tmp15_;
};

struct _PasangWindowEndDemoRoundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangWindow* self;
	gint my_demo_ticket;
	gboolean _tmp0_;
	PasangMode _tmp1_;
};

struct _PasangClient {
	GObject parent_instance;
	PasangClientPrivate * priv;
	GtkWidget* menu;
	gchar* opponent_name;
};

struct _PasangClientClass {
	GObjectClass parent_class;
};

static gint PasangWindow_private_offset;
static gpointer pasang_window_parent_class = NULL;
extern gchar* pasang_reloc_flash_dir;

GType pasang_mode_get_type (void) G_GNUC_CONST;
GType pasang_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangWindow, g_object_unref)
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_game_series_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameSeries, g_object_unref)
GType pasang_game_menu_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameMenu, g_object_unref)
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_pattern_selector_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPatternSelector, g_object_unref)
GType pasang_pattern_editor_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPatternEditor, g_object_unref)
GType pasang_brain_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangBrain, g_object_unref)
GType pasang_client_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangClient, g_object_unref)
GType pasang_brain_spec_get_type (void) G_GNUC_CONST;
PasangBrainSpec* pasang_brain_spec_dup (const PasangBrainSpec* self);
void pasang_brain_spec_free (PasangBrainSpec* self);
PasangGameSeries* pasang_game_series_new (void);
PasangGameSeries* pasang_game_series_construct (GType object_type);
PasangPatternSelector* pasang_pattern_selector_new (void);
PasangPatternSelector* pasang_pattern_selector_construct (GType object_type);
PasangBrain* pasang_brain_new (void);
PasangBrain* pasang_brain_construct (GType object_type);
void pasang_brain_spec_init (PasangBrainSpec *self);
PasangWindow* pasang_window_new (GtkApplicationWindow* main_window);
PasangWindow* pasang_window_construct (GType object_type,
                                       GtkApplicationWindow* main_window);
static gboolean __lambda31_ (PasangWindow* self);
static void pasang_window_on_quit (PasangWindow* self);
static gboolean ___lambda31__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
PasangGameView* pasang_game_view_new (PasangGameSeries* game);
PasangGameView* pasang_game_view_construct (GType object_type,
                                            PasangGameSeries* game);
PasangClient* pasang_client_new (GtkWindow* window);
PasangClient* pasang_client_construct (GType object_type,
                                       GtkWindow* window);
PasangGameMenu* pasang_game_menu_new (PasangClient* client);
PasangGameMenu* pasang_game_menu_construct (GType object_type,
                                            PasangClient* client);
static void pasang_window_create_header_bar (PasangWindow* self);
PasangPatternEditor* pasang_pattern_editor_new (PasangPatternSelector* ps);
PasangPatternEditor* pasang_pattern_editor_construct (GType object_type,
                                                      PasangPatternSelector* ps);
static void __lambda32_ (PasangWindow* self,
                  GtkWidget* s);
void pasang_window_on_pattern_changed (PasangWindow* self,
                                       const gchar* starting_pattern);
static void _pasang_window_on_pattern_changed_pasang_pattern_selector_pattern_changed_signal (PasangPatternSelector* _sender,
                                                                                       const gchar* move,
                                                                                       gpointer self);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
static void __lambda33_ (PasangWindow* self,
                  glong response_ticket,
                  PasangMove* response);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean __lambda34_ (Block9Data* _data9_);
void pasang_game_view_simulate (PasangGameView* self,
                                PasangMove* move);
static gboolean ___lambda34__gsource_func (gpointer self);
static void ___lambda33__pasang_brain_got_move_signal (PasangBrain* _sender,
                                                glong ticket,
                                                PasangMove* move,
                                                gpointer self);
static void __lambda35_ (PasangWindow* self,
                  PasangGameView* s,
                  PasangMove* move);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
static void pasang_window_stop_thinking (PasangWindow* self);
GType pasang_player_get_type (void) G_GNUC_CONST;
void pasang_game_view_set_turn (PasangGameView* self,
                                PasangPlayer top_player,
                                PasangPlayer bottom_player,
                                gint first_player);
static void pasang_window_prepare_for_next_move (PasangWindow* self,
                                          gboolean next_round);
static void ___lambda35__pasang_game_view_next_move_signal (PasangGameView* _sender,
                                                     PasangMove* move,
                                                     gpointer self);
static void pasang_window_show_game_menu (PasangWindow* self);
static void pasang_window_on_status_changed (PasangWindow* self);
void pasang_client_update_status (PasangClient* self);
static void ___lambda32__gtk_widget_realize (GtkWidget* _sender,
                                      gpointer self);
static void _pasang_window_on_status_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void pasang_window_join_network_game (PasangWindow* self);
static void _pasang_window_join_network_game_pasang_client_on_join_game (PasangClient* _sender,
                                                                  gpointer self);
static void pasang_window_leave_network_game (PasangWindow* self);
static void _pasang_window_leave_network_game_pasang_client_on_leave_game (PasangClient* _sender,
                                                                    gpointer self);
static void pasang_window_receive_network_move (PasangWindow* self,
                                         gint seq,
                                         const gchar* move_notation);
static void _pasang_window_receive_network_move_pasang_client_on_move_received (PasangClient* _sender,
                                                                         gint move_sequence_num,
                                                                         const gchar* move_notation,
                                                                         gpointer self);
static void pasang_window_send_network_move (PasangWindow* self,
                                      PasangMove* move);
static void _pasang_window_send_network_move_pasang_game_view_next_move_signal (PasangGameView* _sender,
                                                                         PasangMove* move,
                                                                         gpointer self);
static void __lambda36_ (PasangWindow* self,
                  gint n);
static void pasang_window_on_newgame_ai (PasangWindow* self);
static void pasang_window_on_newgame_2p (PasangWindow* self);
static void pasang_window_on_demo (PasangWindow* self);
static void ___lambda36__pasang_game_menu_activated (PasangGameMenu* _sender,
                                              gint row,
                                              gpointer self);
void pasang_window_set_mode (PasangWindow* self,
                             PasangMode value);
void pasang_game_series_start_new_series (PasangGameSeries* self);
void pasang_pattern_selector_set_sensitive (PasangPatternSelector* self,
                                            gboolean b);
PasangMode pasang_window_get_mode (PasangWindow* self);
PasangPlayer pasang_game_view_get_player_type (PasangGameView* self);
gchar* pasang_game_series_starting_pattern (PasangGameSeries* self);
void pasang_client_send_move (PasangClient* self,
                              gint seq,
                              const gchar* move_notation);
gint pasang_game_get_seq (PasangGame* self);
const gchar* pasang_move_get_notation (PasangMove* self);
gboolean pasang_game_is_valid_pattern (const gchar* pattern);
void pasang_pattern_selector_find_and_click (PasangPatternSelector* self,
                                             const gchar* dots);
PasangMove* pasang_game_get_move (PasangGame* self,
                                  const gchar* move_notation);
void pasang_brain_request_stop (PasangBrain* self);
void pasang_game_series_update_num_wins (PasangGameSeries* self);
void pasang_pattern_selector_unselect (PasangPatternSelector* self);
static void pasang_window_end_demo_round (PasangWindow* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void pasang_window_end_demo_round_finish (PasangWindow* self,
                                          GAsyncResult* _res_);
GType pasang_brain_setter_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangBrainSetter, g_object_unref)
void pasang_brain_request_think (PasangBrain* self,
                                 PasangGame* game,
                                 PasangBrainSpec* spec,
                                 glong* issued_ticked);
void pasang_game_view_start_game (PasangGameView* self,
                                  const gchar* starting_pattern);
static void pasang_window_start_demo_round_data_free (gpointer _data);
static void pasang_window_start_demo_round (PasangWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void pasang_window_start_demo_round_finish (PasangWindow* self,
                                            GAsyncResult* _res_);
static gboolean pasang_window_start_demo_round_co (PasangWindowStartDemoRoundData* _data_);
GType pasang_piece_get_type (void) G_GNUC_CONST;
void pasang_pattern_selector_random (PasangPatternSelector* self);
void pasang_util_wait_async (gint millisecs,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
void pasang_util_wait_finish (GAsyncResult* _res_);
static void pasang_window_start_demo_round_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
void pasang_pattern_selector_highlight_selected (PasangPatternSelector* self);
GType pasang_theme_switch_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangThemeSwitch, g_object_unref)
PasangThemeSwitch* pasang_game_view_get_theme_switch (PasangGameView* self);
void pasang_theme_switch_random (PasangThemeSwitch* self);
static void pasang_window_end_demo_round_data_free (gpointer _data);
static gboolean pasang_window_end_demo_round_co (PasangWindowEndDemoRoundData* _data_);
static void pasang_window_end_demo_round_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static GtkWidget* pasang_window_create_primary_menu (PasangWindow* self);
static GtkWidget* pasang_window_create_theme_menu_button (PasangWindow* self);
static GtkWidget* pasang_window_create_pattern_go_back_button (PasangWindow* self);
static GtkWidget* pasang_window_create_go_back_button (PasangWindow* self);
PasangMenuMaker* pasang_menu_maker_new (GActionMap* action_map);
PasangMenuMaker* pasang_menu_maker_construct (GType object_type,
                                              GActionMap* action_map);
gpointer pasang_menu_maker_ref (gpointer instance);
void pasang_menu_maker_unref (gpointer instance);
GParamSpec* pasang_param_spec_menu_maker (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void pasang_value_set_menu_maker (GValue* value,
                                  gpointer v_object);
void pasang_value_take_menu_maker (GValue* value,
                                   gpointer v_object);
gpointer pasang_value_get_menu_maker (const GValue* value);
GType pasang_menu_maker_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMenuMaker, pasang_menu_maker_unref)
PasangMenuMaker* pasang_menu_maker_add (PasangMenuMaker* self,
                                        const gchar* name,
                                        const gchar* label,
                                        PasangMenuMakerActivateFunc func,
                                        gpointer func_target,
                                        const gchar* accel);
static void pasang_window_on_help (PasangWindow* self);
static void _pasang_window_on_help_pasang_menu_maker_activate_func (gpointer self);
static void pasang_window_on_about (PasangWindow* self);
static void _pasang_window_on_about_pasang_menu_maker_activate_func (gpointer self);
GMenuModel* pasang_menu_maker_end (PasangMenuMaker* self);
static void pasang_window_on_undo_pattern (PasangWindow* self);
static void _pasang_window_on_undo_pattern_pasang_menu_maker_activate_func (gpointer self);
static void pasang_window_on_save_pattern (PasangWindow* self);
static void _pasang_window_on_save_pattern_pasang_menu_maker_activate_func (gpointer self);
static void pasang_window_on_undo (PasangWindow* self);
static void _pasang_window_on_undo_pasang_menu_maker_activate_func (gpointer self);
static void pasang_window_on_retreat (PasangWindow* self);
static void _pasang_window_on_retreat_pasang_menu_maker_activate_func (gpointer self);
static void pasang_window_set_action_enabled (PasangWindow* self,
                                       const gchar* action,
                                       gboolean enabled);
void pasang_game_view_stop_simulation (PasangGameView* self);
static void pasang_window_init_game (PasangWindow* self);
gint pasang_game_get_player (PasangGame* self);
void pasang_game_series_undo (PasangGameSeries* self);
void pasang_game_view_hang_message (PasangGameView* self);
void pasang_client_request_retreat (PasangClient* self);
void pasang_pattern_editor_apply (PasangPatternEditor* self,
                                  gboolean must_save);
void pasang_client_request_logout (PasangClient* self);
static void pasang_window_finalize (GObject * obj);
static void _vala_pasang_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_pasang_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

GType
pasang_mode_get_type (void)
{
	static volatile gsize pasang_mode_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_MODE_USER_VS_AI, "PASANG_MODE_USER_VS_AI", "user-vs-ai"}, {PASANG_MODE_USER_VS_USER, "PASANG_MODE_USER_VS_USER", "user-vs-user"}, {PASANG_MODE_AI_VS_AI, "PASANG_MODE_AI_VS_AI", "ai-vs-ai"}, {PASANG_MODE_NETWORK, "PASANG_MODE_NETWORK", "network"}, {0, NULL, NULL}};
		GType pasang_mode_type_id;
		pasang_mode_type_id = g_enum_register_static ("PasangMode", values);
		g_once_init_leave (&pasang_mode_type_id__volatile, pasang_mode_type_id);
	}
	return pasang_mode_type_id__volatile;
}

static inline gpointer
pasang_window_get_instance_private (PasangWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PasangWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 67 "window.vala"
	return self ? g_object_ref (self) : NULL;
#line 645 "window.c"
}

static gboolean
__lambda31_ (PasangWindow* self)
{
	gboolean result = FALSE;
#line 69 "window.vala"
	pasang_window_on_quit (self);
#line 70 "window.vala"
	result = FALSE;
#line 70 "window.vala"
	return result;
#line 658 "window.c"
}

static gboolean
___lambda31__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda31_ ((PasangWindow*) self);
#line 68 "window.vala"
	return result;
#line 670 "window.c"
}

static void
_pasang_window_on_pattern_changed_pasang_pattern_selector_pattern_changed_signal (PasangPatternSelector* _sender,
                                                                                  const gchar* move,
                                                                                  gpointer self)
{
#line 90 "window.vala"
	pasang_window_on_pattern_changed ((PasangWindow*) self, move);
#line 680 "window.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 91 "window.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 91 "window.vala"
	return _data9_;
#line 690 "window.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 91 "window.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 700 "window.c"
		PasangWindow* self;
#line 91 "window.vala"
		self = _data9_->self;
#line 91 "window.vala"
		_g_object_unref0 (_data9_->response);
#line 91 "window.vala"
		_g_object_unref0 (self);
#line 91 "window.vala"
		g_slice_free (Block9Data, _data9_);
#line 710 "window.c"
	}
}

static gboolean
__lambda34_ (Block9Data* _data9_)
{
	PasangWindow* self;
	gboolean result = FALSE;
#line 92 "window.vala"
	self = _data9_->self;
#line 93 "window.vala"
	if (self->priv->request_ticket == _data9_->response_ticket) {
#line 723 "window.c"
		PasangGameView* _tmp0_;
#line 94 "window.vala"
		_tmp0_ = self->priv->game_view;
#line 94 "window.vala"
		pasang_game_view_simulate (_tmp0_, _data9_->response);
#line 729 "window.c"
	}
#line 95 "window.vala"
	result = FALSE;
#line 95 "window.vala"
	return result;
#line 735 "window.c"
}

static gboolean
___lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda34_ (self);
#line 92 "window.vala"
	return result;
#line 745 "window.c"
}

static void
__lambda33_ (PasangWindow* self,
             glong response_ticket,
             PasangMove* response)
{
	Block9Data* _data9_;
	PasangMove* _tmp0_;
#line 91 "window.vala"
	g_return_if_fail (response != NULL);
#line 91 "window.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 91 "window.vala"
	_data9_->_ref_count_ = 1;
#line 91 "window.vala"
	_data9_->self = g_object_ref (self);
#line 91 "window.vala"
	_data9_->response_ticket = response_ticket;
#line 91 "window.vala"
	_tmp0_ = _g_object_ref0 (response);
#line 91 "window.vala"
	_g_object_unref0 (_data9_->response);
#line 91 "window.vala"
	_data9_->response = _tmp0_;
#line 92 "window.vala"
	g_idle_add_full (G_PRIORITY_HIGH, ___lambda34__gsource_func, block9_data_ref (_data9_), block9_data_unref);
#line 91 "window.vala"
	block9_data_unref (_data9_);
#line 91 "window.vala"
	_data9_ = NULL;
#line 777 "window.c"
}

static void
___lambda33__pasang_brain_got_move_signal (PasangBrain* _sender,
                                           glong ticket,
                                           PasangMove* move,
                                           gpointer self)
{
#line 91 "window.vala"
	__lambda33_ ((PasangWindow*) self, ticket, move);
#line 788 "window.c"
}

static void
__lambda35_ (PasangWindow* self,
             PasangGameView* s,
             PasangMove* move)
{
	gboolean _tmp0_ = FALSE;
	PasangGameSeries* _tmp1_;
	PasangStage _tmp2_;
	PasangStage _tmp3_;
	gboolean _tmp5_ = FALSE;
	PasangGameSeries* _tmp6_;
	PasangStage _tmp7_;
	PasangStage _tmp8_;
#line 98 "window.vala"
	g_return_if_fail (s != NULL);
#line 99 "window.vala"
	_tmp1_ = self->priv->game;
#line 99 "window.vala"
	_tmp2_ = pasang_game_get_stage ((PasangGame*) _tmp1_);
#line 99 "window.vala"
	_tmp3_ = _tmp2_;
#line 99 "window.vala"
	if (_tmp3_ == PASANG_STAGE_OPENING) {
#line 99 "window.vala"
		_tmp0_ = move == NULL;
#line 816 "window.c"
	} else {
#line 99 "window.vala"
		_tmp0_ = FALSE;
#line 820 "window.c"
	}
#line 99 "window.vala"
	if (_tmp0_) {
#line 824 "window.c"
		PasangGameView* _tmp4_;
#line 101 "window.vala"
		pasang_window_stop_thinking (self);
#line 102 "window.vala"
		_tmp4_ = self->priv->game_view;
#line 102 "window.vala"
		pasang_game_view_set_turn (_tmp4_, PASANG_PLAYER_AI, PASANG_PLAYER_HUMAN, 0);
#line 832 "window.c"
	}
#line 106 "window.vala"
	_tmp6_ = self->priv->game;
#line 106 "window.vala"
	_tmp7_ = pasang_game_get_stage ((PasangGame*) _tmp6_);
#line 106 "window.vala"
	_tmp8_ = _tmp7_;
#line 106 "window.vala"
	if (_tmp8_ == PASANG_STAGE_GAME_OVER) {
#line 106 "window.vala"
		_tmp5_ = move == NULL;
#line 844 "window.c"
	} else {
#line 106 "window.vala"
		_tmp5_ = FALSE;
#line 848 "window.c"
	}
#line 106 "window.vala"
	pasang_window_prepare_for_next_move (self, _tmp5_);
#line 852 "window.c"
}

static void
___lambda35__pasang_game_view_next_move_signal (PasangGameView* _sender,
                                                PasangMove* move,
                                                gpointer self)
{
#line 98 "window.vala"
	__lambda35_ ((PasangWindow*) self, _sender, move);
#line 862 "window.c"
}

static void
__lambda32_ (PasangWindow* self,
             GtkWidget* s)
{
	PasangPatternSelector* _tmp0_;
	PasangBrain* _tmp1_;
	PasangGameView* _tmp2_;
	PasangClient* _tmp3_;
#line 88 "window.vala"
	g_return_if_fail (s != NULL);
#line 90 "window.vala"
	_tmp0_ = self->priv->pattern_selector;
#line 90 "window.vala"
	g_signal_connect_object (_tmp0_, "pattern-changed-signal", (GCallback) _pasang_window_on_pattern_changed_pasang_pattern_selector_pattern_changed_signal, self, 0);
#line 91 "window.vala"
	_tmp1_ = self->priv->brain;
#line 91 "window.vala"
	g_signal_connect_object (_tmp1_, "got-move-signal", (GCallback) ___lambda33__pasang_brain_got_move_signal, self, 0);
#line 98 "window.vala"
	_tmp2_ = self->priv->game_view;
#line 98 "window.vala"
	g_signal_connect_object (_tmp2_, "next-move-signal", (GCallback) ___lambda35__pasang_game_view_next_move_signal, self, 0);
#line 110 "window.vala"
	pasang_window_show_game_menu (self);
#line 111 "window.vala"
	pasang_window_on_status_changed (self);
#line 112 "window.vala"
	_tmp3_ = self->priv->client;
#line 112 "window.vala"
	pasang_client_update_status (_tmp3_);
#line 895 "window.c"
}

static void
___lambda32__gtk_widget_realize (GtkWidget* _sender,
                                 gpointer self)
{
#line 88 "window.vala"
	__lambda32_ ((PasangWindow*) self, _sender);
#line 904 "window.c"
}

static void
_pasang_window_on_status_changed_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
#line 117 "window.vala"
	pasang_window_on_status_changed ((PasangWindow*) self);
#line 914 "window.c"
}

static void
_pasang_window_join_network_game_pasang_client_on_join_game (PasangClient* _sender,
                                                             gpointer self)
{
#line 121 "window.vala"
	pasang_window_join_network_game ((PasangWindow*) self);
#line 923 "window.c"
}

static void
_pasang_window_leave_network_game_pasang_client_on_leave_game (PasangClient* _sender,
                                                               gpointer self)
{
#line 122 "window.vala"
	pasang_window_leave_network_game ((PasangWindow*) self);
#line 932 "window.c"
}

static void
_pasang_window_receive_network_move_pasang_client_on_move_received (PasangClient* _sender,
                                                                    gint move_sequence_num,
                                                                    const gchar* move_notation,
                                                                    gpointer self)
{
#line 123 "window.vala"
	pasang_window_receive_network_move ((PasangWindow*) self, move_sequence_num, move_notation);
#line 943 "window.c"
}

static void
_pasang_window_send_network_move_pasang_game_view_next_move_signal (PasangGameView* _sender,
                                                                    PasangMove* move,
                                                                    gpointer self)
{
#line 124 "window.vala"
	pasang_window_send_network_move ((PasangWindow*) self, move);
#line 953 "window.c"
}

static void
__lambda36_ (PasangWindow* self,
             gint n)
{
#line 128 "window.vala"
	if (n == 0) {
#line 128 "window.vala"
		pasang_window_on_newgame_ai (self);
#line 964 "window.c"
	} else {
#line 129 "window.vala"
		if (n == 1) {
#line 129 "window.vala"
			pasang_window_on_newgame_2p (self);
#line 970 "window.c"
		} else {
#line 130 "window.vala"
			if (n == 2) {
#line 130 "window.vala"
				pasang_window_on_demo (self);
#line 976 "window.c"
			}
		}
	}
}

static void
___lambda36__pasang_game_menu_activated (PasangGameMenu* _sender,
                                         gint row,
                                         gpointer self)
{
#line 127 "window.vala"
	__lambda36_ ((PasangWindow*) self, row);
#line 989 "window.c"
}

PasangWindow*
pasang_window_construct (GType object_type,
                         GtkApplicationWindow* main_window)
{
	PasangWindow * self = NULL;
	GtkApplicationWindow* _tmp0_;
	PasangGameSeries* _tmp1_;
	PasangGameView* _tmp2_;
	PasangClient* _tmp3_;
	PasangClient* _tmp4_;
	PasangGameMenu* _tmp5_;
	PasangPatternSelector* _tmp6_;
	PasangPatternEditor* _tmp7_;
	PasangGameMenu* _tmp8_;
	PasangPatternSelector* _tmp9_;
	PasangPatternEditor* _tmp10_;
	PasangGameView* _tmp11_;
	PasangGameView* _tmp12_;
	PasangGameView* _tmp13_;
	PasangClient* _tmp14_;
	PasangClient* _tmp15_;
	PasangClient* _tmp16_;
	PasangGameView* _tmp17_;
	PasangGameMenu* _tmp18_;
#line 66 "window.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 66 "window.vala"
	self = (PasangWindow*) g_object_new (object_type, NULL);
#line 67 "window.vala"
	_tmp0_ = _g_object_ref0 (main_window);
#line 67 "window.vala"
	_g_object_unref0 (self->priv->main_window);
#line 67 "window.vala"
	self->priv->main_window = _tmp0_;
#line 68 "window.vala"
	g_signal_connect_object ((GtkWidget*) main_window, "delete-event", (GCallback) ___lambda31__gtk_widget_delete_event, self, 0);
#line 72 "window.vala"
	_tmp1_ = self->priv->game;
#line 72 "window.vala"
	_tmp2_ = pasang_game_view_new (_tmp1_);
#line 72 "window.vala"
	g_object_ref_sink (_tmp2_);
#line 72 "window.vala"
	_g_object_unref0 (self->priv->game_view);
#line 72 "window.vala"
	self->priv->game_view = _tmp2_;
#line 73 "window.vala"
	_tmp3_ = pasang_client_new ((GtkWindow*) main_window);
#line 73 "window.vala"
	_g_object_unref0 (self->priv->client);
#line 73 "window.vala"
	self->priv->client = _tmp3_;
#line 74 "window.vala"
	_tmp4_ = self->priv->client;
#line 74 "window.vala"
	_tmp5_ = pasang_game_menu_new (_tmp4_);
#line 74 "window.vala"
	g_object_ref_sink (_tmp5_);
#line 74 "window.vala"
	_g_object_unref0 (self->priv->game_menu);
#line 74 "window.vala"
	self->priv->game_menu = _tmp5_;
#line 75 "window.vala"
	pasang_window_create_header_bar (self);
#line 76 "window.vala"
	_tmp6_ = self->priv->pattern_selector;
#line 76 "window.vala"
	_tmp7_ = pasang_pattern_editor_new (_tmp6_);
#line 76 "window.vala"
	g_object_ref_sink (_tmp7_);
#line 76 "window.vala"
	_g_object_unref0 (self->priv->pattern_editor);
#line 76 "window.vala"
	self->priv->pattern_editor = _tmp7_;
#line 79 "window.vala"
	gtk_stack_set_transition_type ((GtkStack*) self, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 80 "window.vala"
	gtk_stack_set_transition_duration ((GtkStack*) self, (guint) 500);
#line 81 "window.vala"
	_tmp8_ = self->priv->game_menu;
#line 81 "window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
#line 82 "window.vala"
	_tmp9_ = self->priv->pattern_selector;
#line 82 "window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp9_);
#line 83 "window.vala"
	_tmp10_ = self->priv->pattern_editor;
#line 83 "window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
#line 84 "window.vala"
	_tmp11_ = self->priv->game_view;
#line 84 "window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
#line 85 "window.vala"
	_tmp12_ = self->priv->game_view;
#line 85 "window.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
#line 86 "window.vala"
	_tmp13_ = self->priv->game_view;
#line 86 "window.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
#line 88 "window.vala"
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) ___lambda32__gtk_widget_realize, self, 0);
#line 117 "window.vala"
	g_signal_connect_object ((GObject*) self, "notify::visible-child", (GCallback) _pasang_window_on_status_changed_g_object_notify, self, 0);
#line 118 "window.vala"
	g_signal_connect_object ((GObject*) self, "notify::mode", (GCallback) _pasang_window_on_status_changed_g_object_notify, self, 0);
#line 121 "window.vala"
	_tmp14_ = self->priv->client;
#line 121 "window.vala"
	g_signal_connect_object (_tmp14_, "on-join-game", (GCallback) _pasang_window_join_network_game_pasang_client_on_join_game, self, 0);
#line 122 "window.vala"
	_tmp15_ = self->priv->client;
#line 122 "window.vala"
	g_signal_connect_object (_tmp15_, "on-leave-game", (GCallback) _pasang_window_leave_network_game_pasang_client_on_leave_game, self, 0);
#line 123 "window.vala"
	_tmp16_ = self->priv->client;
#line 123 "window.vala"
	g_signal_connect_object (_tmp16_, "on-move-received", (GCallback) _pasang_window_receive_network_move_pasang_client_on_move_received, self, 0);
#line 124 "window.vala"
	_tmp17_ = self->priv->game_view;
#line 124 "window.vala"
	g_signal_connect_object (_tmp17_, "next-move-signal", (GCallback) _pasang_window_send_network_move_pasang_game_view_next_move_signal, self, 0);
#line 127 "window.vala"
	_tmp18_ = self->priv->game_menu;
#line 127 "window.vala"
	g_signal_connect_object (_tmp18_, "activated", (GCallback) ___lambda36__pasang_game_menu_activated, self, 0);
#line 66 "window.vala"
	return self;
#line 1122 "window.c"
}

PasangWindow*
pasang_window_new (GtkApplicationWindow* main_window)
{
#line 66 "window.vala"
	return pasang_window_construct (PASANG_TYPE_WINDOW, main_window);
#line 1130 "window.c"
}

/**
     * Join network game
     */
static void
pasang_window_join_network_game (PasangWindow* self)
{
	PasangGameSeries* _tmp0_;
	PasangPatternSelector* _tmp1_;
	PasangPatternSelector* _tmp2_;
#line 137 "window.vala"
	g_return_if_fail (self != NULL);
#line 138 "window.vala"
	pasang_window_set_mode (self, PASANG_MODE_NETWORK);
#line 139 "window.vala"
	_tmp0_ = self->priv->game;
#line 139 "window.vala"
	pasang_game_series_start_new_series (_tmp0_);
#line 140 "window.vala"
	pasang_window_stop_thinking (self);
#line 141 "window.vala"
	_tmp1_ = self->priv->pattern_selector;
#line 141 "window.vala"
	pasang_pattern_selector_set_sensitive (_tmp1_, TRUE);
#line 142 "window.vala"
	_tmp2_ = self->priv->pattern_selector;
#line 142 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp2_);
#line 1160 "window.c"
}

/**
     * Leave network game
     */
static void
pasang_window_leave_network_game (PasangWindow* self)
{
	PasangMode _tmp0_;
#line 148 "window.vala"
	g_return_if_fail (self != NULL);
#line 149 "window.vala"
	_tmp0_ = self->priv->_mode;
#line 149 "window.vala"
	if (_tmp0_ == PASANG_MODE_NETWORK) {
#line 149 "window.vala"
		pasang_window_show_game_menu (self);
#line 1178 "window.c"
	}
}

/**
     * Send move to server, if appropriate
     */
static void
pasang_window_send_network_move (PasangWindow* self,
                                 PasangMove* move)
{
	gboolean _tmp0_ = FALSE;
	PasangMode _tmp1_;
#line 155 "window.vala"
	g_return_if_fail (self != NULL);
#line 156 "window.vala"
	if (move == NULL) {
#line 156 "window.vala"
		return;
#line 1197 "window.c"
	}
#line 157 "window.vala"
	_tmp1_ = self->priv->_mode;
#line 157 "window.vala"
	if (_tmp1_ == PASANG_MODE_NETWORK) {
#line 1203 "window.c"
		PasangGameView* _tmp2_;
		PasangPlayer _tmp3_;
		PasangPlayer _tmp4_;
#line 157 "window.vala"
		_tmp2_ = self->priv->game_view;
#line 157 "window.vala"
		_tmp3_ = pasang_game_view_get_player_type (_tmp2_);
#line 157 "window.vala"
		_tmp4_ = _tmp3_;
#line 157 "window.vala"
		_tmp0_ = _tmp4_ == PASANG_PLAYER_REMOTE;
#line 1215 "window.c"
	} else {
#line 157 "window.vala"
		_tmp0_ = FALSE;
#line 1219 "window.c"
	}
#line 157 "window.vala"
	if (_tmp0_) {
#line 1223 "window.c"
		PasangGameSeries* _tmp5_;
		PasangStage _tmp6_;
		PasangStage _tmp7_;
		PasangClient* _tmp12_;
		PasangGameSeries* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
#line 160 "window.vala"
		_tmp5_ = self->priv->game;
#line 160 "window.vala"
		_tmp6_ = pasang_game_get_stage ((PasangGame*) _tmp5_);
#line 160 "window.vala"
		_tmp7_ = _tmp6_;
#line 160 "window.vala"
		if (_tmp7_ == PASANG_STAGE_OPENING) {
#line 1241 "window.c"
			gchar* starting_pattern = NULL;
			PasangGameSeries* _tmp8_;
			gchar* _tmp9_;
			PasangClient* _tmp10_;
			const gchar* _tmp11_;
#line 161 "window.vala"
			_tmp8_ = self->priv->game;
#line 161 "window.vala"
			_tmp9_ = pasang_game_series_starting_pattern (_tmp8_);
#line 161 "window.vala"
			starting_pattern = _tmp9_;
#line 162 "window.vala"
			_tmp10_ = self->priv->client;
#line 162 "window.vala"
			_tmp11_ = starting_pattern;
#line 162 "window.vala"
			pasang_client_send_move (_tmp10_, 0, _tmp11_);
#line 160 "window.vala"
			_g_free0 (starting_pattern);
#line 1261 "window.c"
		}
#line 164 "window.vala"
		_tmp12_ = self->priv->client;
#line 164 "window.vala"
		_tmp13_ = self->priv->game;
#line 164 "window.vala"
		_tmp14_ = pasang_game_get_seq ((PasangGame*) _tmp13_);
#line 164 "window.vala"
		_tmp15_ = _tmp14_;
#line 164 "window.vala"
		_tmp16_ = pasang_move_get_notation (move);
#line 164 "window.vala"
		_tmp17_ = _tmp16_;
#line 164 "window.vala"
		pasang_client_send_move (_tmp12_, _tmp15_, _tmp17_);
#line 1277 "window.c"
	}
}

/**
     * Receive move from remote opponent
     */
static void
pasang_window_receive_network_move (PasangWindow* self,
                                    gint seq,
                                    const gchar* move_notation)
{
#line 171 "window.vala"
	g_return_if_fail (self != NULL);
#line 171 "window.vala"
	g_return_if_fail (move_notation != NULL);
#line 172 "window.vala"
	if (seq == 0) {
#line 173 "window.vala"
		if (pasang_game_is_valid_pattern (move_notation)) {
#line 1297 "window.c"
			PasangPatternSelector* _tmp0_;
			PasangPatternSelector* _tmp1_;
#line 174 "window.vala"
			_tmp0_ = self->priv->pattern_selector;
#line 174 "window.vala"
			pasang_pattern_selector_find_and_click (_tmp0_, move_notation);
#line 175 "window.vala"
			_tmp1_ = self->priv->pattern_selector;
#line 175 "window.vala"
			pasang_pattern_selector_set_sensitive (_tmp1_, FALSE);
#line 1308 "window.c"
		} else {
#line 178 "window.vala"
			g_message ("window.vala:178: Invalid pattern received: %s", move_notation);
#line 1312 "window.c"
		}
	} else {
		PasangGameSeries* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		PasangGameSeries* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		PasangMove* move = NULL;
		PasangGameSeries* _tmp12_;
		PasangMove* _tmp13_;
		PasangMove* _tmp14_;
		PasangGameView* _tmp15_;
		PasangMove* _tmp16_;
#line 183 "window.vala"
		_tmp2_ = self->priv->game;
#line 183 "window.vala"
		_tmp3_ = pasang_game_get_seq ((PasangGame*) _tmp2_);
#line 183 "window.vala"
		_tmp4_ = _tmp3_;
#line 183 "window.vala"
		if (seq != (_tmp4_ + 1)) {
#line 1335 "window.c"
			PasangGameSeries* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
#line 184 "window.vala"
			_tmp5_ = self->priv->game;
#line 184 "window.vala"
			_tmp6_ = pasang_game_get_seq ((PasangGame*) _tmp5_);
#line 184 "window.vala"
			_tmp7_ = _tmp6_;
#line 184 "window.vala"
			g_message ("window.vala:184: Invalid move sequence number: %d. Expected: %d", seq, _tmp7_ + 1);
#line 185 "window.vala"
			return;
#line 1349 "window.c"
		}
#line 188 "window.vala"
		_tmp8_ = self->priv->game;
#line 188 "window.vala"
		_tmp9_ = pasang_game_get_seq ((PasangGame*) _tmp8_);
#line 188 "window.vala"
		_tmp10_ = _tmp9_;
#line 188 "window.vala"
		if (_tmp10_ == 0) {
#line 1359 "window.c"
			PasangGameView* _tmp11_;
#line 189 "window.vala"
			_tmp11_ = self->priv->game_view;
#line 189 "window.vala"
			pasang_game_view_set_turn (_tmp11_, PASANG_PLAYER_REMOTE, PASANG_PLAYER_HUMAN, 0);
#line 190 "window.vala"
			pasang_window_prepare_for_next_move (self, FALSE);
#line 1367 "window.c"
		}
#line 193 "window.vala"
		_tmp12_ = self->priv->game;
#line 193 "window.vala"
		_tmp13_ = pasang_game_get_move ((PasangGame*) _tmp12_, move_notation);
#line 193 "window.vala"
		move = _tmp13_;
#line 194 "window.vala"
		_tmp14_ = move;
#line 194 "window.vala"
		if (_tmp14_ == NULL) {
#line 195 "window.vala"
			g_message ("window.vala:195: Invalid move received: %s", move_notation);
#line 196 "window.vala"
			_g_object_unref0 (move);
#line 196 "window.vala"
			return;
#line 1385 "window.c"
		}
#line 198 "window.vala"
		_tmp15_ = self->priv->game_view;
#line 198 "window.vala"
		_tmp16_ = move;
#line 198 "window.vala"
		pasang_game_view_simulate (_tmp15_, _tmp16_);
#line 172 "window.vala"
		_g_object_unref0 (move);
#line 1395 "window.c"
	}
}

/**
     * Abort any current thinking and ensure that result from aborted
     * thinking is dismissed (by setting request_ticket to an impossible value).
     */
static void
pasang_window_stop_thinking (PasangWindow* self)
{
	PasangBrain* _tmp0_;
#line 206 "window.vala"
	g_return_if_fail (self != NULL);
#line 207 "window.vala"
	self->priv->request_ticket = (glong) -1;
#line 208 "window.vala"
	_tmp0_ = self->priv->brain;
#line 208 "window.vala"
	pasang_brain_request_stop (_tmp0_);
#line 1415 "window.c"
}

static void
pasang_window_prepare_for_next_move (PasangWindow* self,
                                     gboolean next_round)
{
	PasangStage stage = 0;
	PasangGameSeries* _tmp0_;
	PasangStage _tmp1_;
	PasangStage _tmp2_;
	PasangStage _tmp6_;
	PasangGameView* _tmp11_;
	PasangPlayer _tmp12_;
	PasangPlayer _tmp13_;
#line 211 "window.vala"
	g_return_if_fail (self != NULL);
#line 212 "window.vala"
	_tmp0_ = self->priv->game;
#line 212 "window.vala"
	_tmp1_ = pasang_game_get_stage ((PasangGame*) _tmp0_);
#line 212 "window.vala"
	_tmp2_ = _tmp1_;
#line 212 "window.vala"
	stage = _tmp2_;
#line 213 "window.vala"
	if (next_round) {
#line 1442 "window.c"
		PasangPatternSelector* _tmp3_;
#line 214 "window.vala"
		_tmp3_ = self->priv->pattern_selector;
#line 214 "window.vala"
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp3_);
#line 1448 "window.c"
	} else {
		PasangGameSeries* _tmp4_;
		PasangGameView* _tmp5_;
#line 217 "window.vala"
		_tmp4_ = self->priv->game;
#line 217 "window.vala"
		pasang_game_series_update_num_wins (_tmp4_);
#line 218 "window.vala"
		_tmp5_ = self->priv->game_view;
#line 218 "window.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp5_);
#line 1460 "window.c"
	}
#line 221 "window.vala"
	_tmp6_ = stage;
#line 221 "window.vala"
	if (_tmp6_ == PASANG_STAGE_GAME_OVER) {
#line 1466 "window.c"
		PasangPatternSelector* _tmp7_;
		PasangMode _tmp8_;
		PasangPatternSelector* _tmp9_;
		PasangMode _tmp10_;
#line 222 "window.vala"
		_tmp7_ = self->priv->pattern_selector;
#line 222 "window.vala"
		_tmp8_ = self->priv->_mode;
#line 222 "window.vala"
		pasang_pattern_selector_set_sensitive (_tmp7_, _tmp8_ != PASANG_MODE_AI_VS_AI);
#line 223 "window.vala"
		_tmp9_ = self->priv->pattern_selector;
#line 223 "window.vala"
		pasang_pattern_selector_unselect (_tmp9_);
#line 224 "window.vala"
		_tmp10_ = self->priv->_mode;
#line 224 "window.vala"
		if (_tmp10_ == PASANG_MODE_AI_VS_AI) {
#line 225 "window.vala"
			pasang_window_end_demo_round (self, NULL, NULL);
#line 1487 "window.c"
		}
#line 227 "window.vala"
		return;
#line 1491 "window.c"
	}
#line 229 "window.vala"
	_tmp11_ = self->priv->game_view;
#line 229 "window.vala"
	_tmp12_ = pasang_game_view_get_player_type (_tmp11_);
#line 229 "window.vala"
	_tmp13_ = _tmp12_;
#line 229 "window.vala"
	if (_tmp13_ == PASANG_PLAYER_AI) {
#line 1501 "window.c"
		PasangBrainSpec _tmp14_ = {0};
		PasangMode _tmp15_;
		PasangBrain* _tmp20_;
		PasangGameSeries* _tmp21_;
		glong _tmp22_ = 0L;
#line 233 "window.vala"
		_tmp15_ = self->priv->_mode;
#line 233 "window.vala"
		if (_tmp15_ == PASANG_MODE_AI_VS_AI) {
#line 1511 "window.c"
			PasangBrainSpec _tmp16_;
#line 233 "window.vala"
			_tmp16_ = self->priv->demo_player;
#line 233 "window.vala"
			_tmp14_ = _tmp16_;
#line 1517 "window.c"
		} else {
			PasangGameMenu* _tmp17_;
			PasangBrainSetter* _tmp18_;
			PasangBrainSpec _tmp19_;
#line 233 "window.vala"
			_tmp17_ = self->priv->game_menu;
#line 233 "window.vala"
			_tmp18_ = _tmp17_->brain_setter;
#line 233 "window.vala"
			_tmp19_ = _tmp18_->brain_spec;
#line 233 "window.vala"
			_tmp14_ = _tmp19_;
#line 1530 "window.c"
		}
#line 231 "window.vala"
		_tmp20_ = self->priv->brain;
#line 231 "window.vala"
		_tmp21_ = self->priv->game;
#line 231 "window.vala"
		pasang_brain_request_think (_tmp20_, (PasangGame*) _tmp21_, &_tmp14_, &_tmp22_);
#line 231 "window.vala"
		self->priv->request_ticket = _tmp22_;
#line 1540 "window.c"
	}
}

void
pasang_window_on_pattern_changed (PasangWindow* self,
                                  const gchar* starting_pattern)
{
	PasangMode _tmp1_;
	PasangMode _tmp3_;
	PasangGameView* _tmp7_;
	PasangMode _tmp8_;
#line 238 "window.vala"
	g_return_if_fail (self != NULL);
#line 239 "window.vala"
	if (starting_pattern == NULL) {
#line 1556 "window.c"
		PasangPatternEditor* _tmp0_;
#line 240 "window.vala"
		_tmp0_ = self->priv->pattern_editor;
#line 240 "window.vala"
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
#line 241 "window.vala"
		return;
#line 1564 "window.c"
	}
#line 243 "window.vala"
	_tmp1_ = self->priv->_mode;
#line 243 "window.vala"
	if (_tmp1_ == PASANG_MODE_USER_VS_AI) {
#line 1570 "window.c"
		PasangGameView* _tmp2_;
#line 244 "window.vala"
		_tmp2_ = self->priv->game_view;
#line 244 "window.vala"
		pasang_game_view_set_turn (_tmp2_, PASANG_PLAYER_AI, PASANG_PLAYER_HUMAN, 1);
#line 1576 "window.c"
	}
#line 246 "window.vala"
	_tmp3_ = self->priv->_mode;
#line 246 "window.vala"
	if (_tmp3_ == PASANG_MODE_USER_VS_USER) {
#line 1582 "window.c"
		PasangGameView* _tmp4_;
#line 247 "window.vala"
		_tmp4_ = self->priv->game_view;
#line 247 "window.vala"
		pasang_game_view_set_turn (_tmp4_, PASANG_PLAYER_HUMAN, PASANG_PLAYER_HUMAN, 1);
#line 1588 "window.c"
	} else {
		PasangMode _tmp5_;
#line 249 "window.vala"
		_tmp5_ = self->priv->_mode;
#line 249 "window.vala"
		if (_tmp5_ == PASANG_MODE_NETWORK) {
#line 1595 "window.c"
			PasangGameView* _tmp6_;
#line 250 "window.vala"
			_tmp6_ = self->priv->game_view;
#line 250 "window.vala"
			pasang_game_view_set_turn (_tmp6_, PASANG_PLAYER_REMOTE, PASANG_PLAYER_HUMAN, 1);
#line 1601 "window.c"
		}
	}
#line 252 "window.vala"
	pasang_window_stop_thinking (self);
#line 253 "window.vala"
	_tmp7_ = self->priv->game_view;
#line 253 "window.vala"
	pasang_game_view_start_game (_tmp7_, starting_pattern);
#line 254 "window.vala"
	_tmp8_ = self->priv->_mode;
#line 254 "window.vala"
	if (_tmp8_ != PASANG_MODE_AI_VS_AI) {
#line 1614 "window.c"
		PasangGameView* _tmp9_;
#line 256 "window.vala"
		_tmp9_ = self->priv->game_view;
#line 256 "window.vala"
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp9_);
#line 257 "window.vala"
		pasang_window_prepare_for_next_move (self, FALSE);
#line 1622 "window.c"
	}
}

static void
pasang_window_start_demo_round_data_free (gpointer _data)
{
	PasangWindowStartDemoRoundData* _data_;
	_data_ = _data;
#line 31 "window.vala"
	_g_object_unref0 (_data_->self);
#line 31 "window.vala"
	g_slice_free (PasangWindowStartDemoRoundData, _data_);
#line 1635 "window.c"
}

static void
pasang_window_start_demo_round (PasangWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	PasangWindowStartDemoRoundData* _data_;
	PasangWindow* _tmp0_;
#line 31 "window.vala"
	_data_ = g_slice_new0 (PasangWindowStartDemoRoundData);
#line 31 "window.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 31 "window.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_window_start_demo_round_data_free);
#line 31 "window.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "window.vala"
	_data_->self = _tmp0_;
#line 31 "window.vala"
	pasang_window_start_demo_round_co (_data_);
#line 1657 "window.c"
}

static void
pasang_window_start_demo_round_finish (PasangWindow* self,
                                       GAsyncResult* _res_)
{
	PasangWindowStartDemoRoundData* _data_;
#line 31 "window.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1667 "window.c"
}

/**
     * Do the following, aborting whenever the ticket becomes invalid
     * or the play mode changes to non-demo :
     *      Get a ticket
     *      Show patterns
     *      Wait
     *      Show selected pattern
     *      Wait
     *      Show initial game board
     *      Wait
     *      Really start
     */
static void
pasang_window_start_demo_round_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	PasangWindowStartDemoRoundData* _data_;
#line 280 "window.vala"
	_data_ = _user_data_;
#line 280 "window.vala"
	_data_->_source_object_ = source_object;
#line 280 "window.vala"
	_data_->_res_ = _res_;
#line 280 "window.vala"
	pasang_window_start_demo_round_co (_data_);
#line 1696 "window.c"
}

static gboolean
pasang_window_start_demo_round_co (PasangWindowStartDemoRoundData* _data_)
{
#line 273 "window.vala"
	switch (_data_->_state_) {
#line 273 "window.vala"
		case 0:
#line 1706 "window.c"
		goto _state_0;
#line 273 "window.vala"
		case 1:
#line 1710 "window.c"
		goto _state_1;
#line 273 "window.vala"
		case 2:
#line 1714 "window.c"
		goto _state_2;
#line 273 "window.vala"
		case 3:
#line 1718 "window.c"
		goto _state_3;
		default:
#line 273 "window.vala"
		g_assert_not_reached ();
#line 1723 "window.c"
	}
	_state_0:
#line 274 "window.vala"
	_data_->self->priv->demo_ticket = _data_->self->priv->demo_ticket + 1;
#line 274 "window.vala"
	_data_->my_demo_ticket = _data_->self->priv->demo_ticket;
#line 275 "window.vala"
	_data_->_tmp0_ = _data_->self->priv->game_view;
#line 275 "window.vala"
	_data_->_tmp1_ = _data_->self->priv->game;
#line 275 "window.vala"
	pasang_game_view_set_turn (_data_->_tmp0_, PASANG_PLAYER_AI, PASANG_PLAYER_AI, _data_->_tmp1_->num_rounds % 2);
#line 276 "window.vala"
	_data_->_tmp2_ = _data_->self->priv->pattern_selector;
#line 276 "window.vala"
	pasang_pattern_selector_set_sensitive (_data_->_tmp2_, FALSE);
#line 277 "window.vala"
	_data_->_tmp3_ = _data_->self->priv->pattern_selector;
#line 277 "window.vala"
	pasang_pattern_selector_random (_data_->_tmp3_);
#line 278 "window.vala"
	_data_->_tmp4_ = _data_->self->priv->pattern_selector;
#line 278 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) _data_->self, (GtkWidget*) _data_->_tmp4_);
#line 280 "window.vala"
	_data_->_state_ = 1;
#line 280 "window.vala"
	pasang_util_wait_async (1000, pasang_window_start_demo_round_ready, _data_);
#line 280 "window.vala"
	return FALSE;
#line 1754 "window.c"
	_state_1:
#line 280 "window.vala"
	pasang_util_wait_finish (_data_->_res_);
#line 281 "window.vala"
	if (_data_->my_demo_ticket != _data_->self->priv->demo_ticket) {
#line 281 "window.vala"
		_data_->_tmp5_ = TRUE;
#line 1762 "window.c"
	} else {
#line 281 "window.vala"
		_data_->_tmp6_ = _data_->self->priv->_mode;
#line 281 "window.vala"
		_data_->_tmp5_ = _data_->_tmp6_ != PASANG_MODE_AI_VS_AI;
#line 1768 "window.c"
	}
#line 281 "window.vala"
	if (_data_->_tmp5_) {
#line 281 "window.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 281 "window.vala"
		if (_data_->_state_ != 0) {
#line 281 "window.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 281 "window.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1780 "window.c"
			}
		}
#line 281 "window.vala"
		g_object_unref (_data_->_async_result);
#line 281 "window.vala"
		return FALSE;
#line 1787 "window.c"
	}
#line 283 "window.vala"
	_data_->_tmp7_ = _data_->self->priv->pattern_selector;
#line 283 "window.vala"
	pasang_pattern_selector_highlight_selected (_data_->_tmp7_);
#line 285 "window.vala"
	_data_->_state_ = 2;
#line 285 "window.vala"
	pasang_util_wait_async (3000, pasang_window_start_demo_round_ready, _data_);
#line 285 "window.vala"
	return FALSE;
#line 1799 "window.c"
	_state_2:
#line 285 "window.vala"
	pasang_util_wait_finish (_data_->_res_);
#line 286 "window.vala"
	if (_data_->my_demo_ticket != _data_->self->priv->demo_ticket) {
#line 286 "window.vala"
		_data_->_tmp8_ = TRUE;
#line 1807 "window.c"
	} else {
#line 286 "window.vala"
		_data_->_tmp9_ = _data_->self->priv->_mode;
#line 286 "window.vala"
		_data_->_tmp8_ = _data_->_tmp9_ != PASANG_MODE_AI_VS_AI;
#line 1813 "window.c"
	}
#line 286 "window.vala"
	if (_data_->_tmp8_) {
#line 286 "window.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 286 "window.vala"
		if (_data_->_state_ != 0) {
#line 286 "window.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 286 "window.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1825 "window.c"
			}
		}
#line 286 "window.vala"
		g_object_unref (_data_->_async_result);
#line 286 "window.vala"
		return FALSE;
#line 1832 "window.c"
	}
#line 289 "window.vala"
	_data_->_tmp10_ = _data_->self->priv->game_view;
#line 289 "window.vala"
	_data_->_tmp11_ = pasang_game_view_get_theme_switch (_data_->_tmp10_);
#line 289 "window.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 289 "window.vala"
	pasang_theme_switch_random (_data_->_tmp12_);
#line 290 "window.vala"
	_data_->_tmp13_ = _data_->self->priv->game_view;
#line 290 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) _data_->self, (GtkWidget*) _data_->_tmp13_);
#line 292 "window.vala"
	_data_->_state_ = 3;
#line 292 "window.vala"
	pasang_util_wait_async (4000, pasang_window_start_demo_round_ready, _data_);
#line 292 "window.vala"
	return FALSE;
#line 1852 "window.c"
	_state_3:
#line 292 "window.vala"
	pasang_util_wait_finish (_data_->_res_);
#line 293 "window.vala"
	if (_data_->my_demo_ticket != _data_->self->priv->demo_ticket) {
#line 293 "window.vala"
		_data_->_tmp14_ = TRUE;
#line 1860 "window.c"
	} else {
#line 293 "window.vala"
		_data_->_tmp15_ = _data_->self->priv->_mode;
#line 293 "window.vala"
		_data_->_tmp14_ = _data_->_tmp15_ != PASANG_MODE_AI_VS_AI;
#line 1866 "window.c"
	}
#line 293 "window.vala"
	if (_data_->_tmp14_) {
#line 293 "window.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 293 "window.vala"
		if (_data_->_state_ != 0) {
#line 293 "window.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 293 "window.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1878 "window.c"
			}
		}
#line 293 "window.vala"
		g_object_unref (_data_->_async_result);
#line 293 "window.vala"
		return FALSE;
#line 1885 "window.c"
	}
#line 295 "window.vala"
	pasang_window_prepare_for_next_move (_data_->self, FALSE);
#line 273 "window.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 273 "window.vala"
	if (_data_->_state_ != 0) {
#line 273 "window.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 273 "window.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1897 "window.c"
		}
	}
#line 273 "window.vala"
	g_object_unref (_data_->_async_result);
#line 273 "window.vala"
	return FALSE;
#line 1904 "window.c"
}

static void
pasang_window_end_demo_round_data_free (gpointer _data)
{
	PasangWindowEndDemoRoundData* _data_;
	_data_ = _data;
#line 31 "window.vala"
	_g_object_unref0 (_data_->self);
#line 31 "window.vala"
	g_slice_free (PasangWindowEndDemoRoundData, _data_);
#line 1916 "window.c"
}

static void
pasang_window_end_demo_round (PasangWindow* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	PasangWindowEndDemoRoundData* _data_;
	PasangWindow* _tmp0_;
#line 31 "window.vala"
	_data_ = g_slice_new0 (PasangWindowEndDemoRoundData);
#line 31 "window.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 31 "window.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_window_end_demo_round_data_free);
#line 31 "window.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "window.vala"
	_data_->self = _tmp0_;
#line 31 "window.vala"
	pasang_window_end_demo_round_co (_data_);
#line 1938 "window.c"
}

static void
pasang_window_end_demo_round_finish (PasangWindow* self,
                                     GAsyncResult* _res_)
{
	PasangWindowEndDemoRoundData* _data_;
#line 31 "window.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1948 "window.c"
}

static void
pasang_window_end_demo_round_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	PasangWindowEndDemoRoundData* _data_;
#line 300 "window.vala"
	_data_ = _user_data_;
#line 300 "window.vala"
	_data_->_source_object_ = source_object;
#line 300 "window.vala"
	_data_->_res_ = _res_;
#line 300 "window.vala"
	pasang_window_end_demo_round_co (_data_);
#line 1965 "window.c"
}

static gboolean
pasang_window_end_demo_round_co (PasangWindowEndDemoRoundData* _data_)
{
#line 298 "window.vala"
	switch (_data_->_state_) {
#line 298 "window.vala"
		case 0:
#line 1975 "window.c"
		goto _state_0;
#line 298 "window.vala"
		case 1:
#line 1979 "window.c"
		goto _state_1;
#line 298 "window.vala"
		case 2:
#line 1983 "window.c"
		goto _state_2;
		default:
#line 298 "window.vala"
		g_assert_not_reached ();
#line 1988 "window.c"
	}
	_state_0:
#line 299 "window.vala"
	_data_->self->priv->demo_ticket = _data_->self->priv->demo_ticket + 1;
#line 299 "window.vala"
	_data_->my_demo_ticket = _data_->self->priv->demo_ticket;
#line 300 "window.vala"
	_data_->_state_ = 1;
#line 300 "window.vala"
	pasang_util_wait_async (4000, pasang_window_end_demo_round_ready, _data_);
#line 300 "window.vala"
	return FALSE;
#line 2001 "window.c"
	_state_1:
#line 300 "window.vala"
	pasang_util_wait_finish (_data_->_res_);
#line 301 "window.vala"
	if (_data_->my_demo_ticket != _data_->self->priv->demo_ticket) {
#line 301 "window.vala"
		_data_->_tmp0_ = TRUE;
#line 2009 "window.c"
	} else {
#line 301 "window.vala"
		_data_->_tmp1_ = _data_->self->priv->_mode;
#line 301 "window.vala"
		_data_->_tmp0_ = _data_->_tmp1_ != PASANG_MODE_AI_VS_AI;
#line 2015 "window.c"
	}
#line 301 "window.vala"
	if (_data_->_tmp0_) {
#line 301 "window.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 301 "window.vala"
		if (_data_->_state_ != 0) {
#line 301 "window.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 301 "window.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2027 "window.c"
			}
		}
#line 301 "window.vala"
		g_object_unref (_data_->_async_result);
#line 301 "window.vala"
		return FALSE;
#line 2034 "window.c"
	}
#line 302 "window.vala"
	_data_->_state_ = 2;
#line 302 "window.vala"
	pasang_window_start_demo_round (_data_->self, pasang_window_end_demo_round_ready, _data_);
#line 302 "window.vala"
	return FALSE;
#line 2042 "window.c"
	_state_2:
#line 302 "window.vala"
	pasang_window_start_demo_round_finish (_data_->self, _data_->_res_);
#line 298 "window.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 298 "window.vala"
	if (_data_->_state_ != 0) {
#line 298 "window.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 298 "window.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2054 "window.c"
		}
	}
#line 298 "window.vala"
	g_object_unref (_data_->_async_result);
#line 298 "window.vala"
	return FALSE;
#line 2061 "window.c"
}

/**
     * Create and populate a header bar
     */
static void
pasang_window_create_header_bar (PasangWindow* self)
{
	GtkHeaderBar* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkHeaderBar* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkHeaderBar* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkHeaderBar* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkHeaderBar* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
#line 308 "window.vala"
	g_return_if_fail (self != NULL);
#line 309 "window.vala"
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 309 "window.vala"
	g_object_ref_sink (_tmp0_);
#line 309 "window.vala"
	_g_object_unref0 (self->priv->header_bar);
#line 309 "window.vala"
	self->priv->header_bar = _tmp0_;
#line 310 "window.vala"
	_tmp1_ = self->priv->main_window;
#line 310 "window.vala"
	_tmp2_ = self->priv->header_bar;
#line 310 "window.vala"
	gtk_window_set_titlebar ((GtkWindow*) _tmp1_, (GtkWidget*) _tmp2_);
#line 311 "window.vala"
	_tmp3_ = self->priv->header_bar;
#line 311 "window.vala"
	gtk_header_bar_set_show_close_button (_tmp3_, TRUE);
#line 312 "window.vala"
	_tmp4_ = self->priv->header_bar;
#line 312 "window.vala"
	_tmp5_ = pasang_window_create_primary_menu (self);
#line 312 "window.vala"
	_tmp6_ = _tmp5_;
#line 312 "window.vala"
	gtk_header_bar_pack_end (_tmp4_, _tmp6_);
#line 312 "window.vala"
	_g_object_unref0 (_tmp6_);
#line 313 "window.vala"
	_tmp7_ = self->priv->header_bar;
#line 313 "window.vala"
	_tmp8_ = pasang_window_create_theme_menu_button (self);
#line 313 "window.vala"
	_tmp9_ = _tmp8_;
#line 313 "window.vala"
	gtk_header_bar_pack_end (_tmp7_, _tmp9_);
#line 313 "window.vala"
	_g_object_unref0 (_tmp9_);
#line 314 "window.vala"
	_tmp10_ = self->priv->header_bar;
#line 314 "window.vala"
	_tmp11_ = pasang_window_create_pattern_go_back_button (self);
#line 314 "window.vala"
	_tmp12_ = _tmp11_;
#line 314 "window.vala"
	gtk_header_bar_pack_start (_tmp10_, _tmp12_);
#line 314 "window.vala"
	_g_object_unref0 (_tmp12_);
#line 315 "window.vala"
	_tmp13_ = self->priv->header_bar;
#line 315 "window.vala"
	_tmp14_ = pasang_window_create_go_back_button (self);
#line 315 "window.vala"
	_tmp15_ = _tmp14_;
#line 315 "window.vala"
	gtk_header_bar_pack_start (_tmp13_, _tmp15_);
#line 315 "window.vala"
	_g_object_unref0 (_tmp15_);
#line 2146 "window.c"
}

/**
     * Create primary menu
     */
static void
_pasang_window_on_help_pasang_menu_maker_activate_func (gpointer self)
{
#line 325 "window.vala"
	pasang_window_on_help ((PasangWindow*) self);
#line 2157 "window.c"
}

static void
_pasang_window_on_about_pasang_menu_maker_activate_func (gpointer self)
{
#line 325 "window.vala"
	pasang_window_on_about ((PasangWindow*) self);
#line 2165 "window.c"
}

static GtkWidget*
pasang_window_create_primary_menu (PasangWindow* self)
{
	GtkMenuButton* button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	PasangMenuMaker* _tmp4_;
	PasangMenuMaker* _tmp5_;
	PasangMenuMaker* _tmp6_;
	PasangMenuMaker* _tmp7_;
	PasangMenuMaker* _tmp8_;
	PasangMenuMaker* _tmp9_;
	GMenuModel* _tmp10_;
	GMenuModel* _tmp11_;
	GtkWidget* result = NULL;
#line 321 "window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 322 "window.vala"
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 322 "window.vala"
	g_object_ref_sink (_tmp0_);
#line 322 "window.vala"
	button = _tmp0_;
#line 323 "window.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 323 "window.vala"
	g_object_ref_sink (_tmp1_);
#line 323 "window.vala"
	_tmp2_ = _tmp1_;
#line 323 "window.vala"
	gtk_button_set_image ((GtkButton*) button, (GtkWidget*) _tmp2_);
#line 323 "window.vala"
	_g_object_unref0 (_tmp2_);
#line 324 "window.vala"
	gtk_button_set_relief ((GtkButton*) button, GTK_RELIEF_NONE);
#line 325 "window.vala"
	_tmp3_ = self->priv->main_window;
#line 325 "window.vala"
	_tmp4_ = pasang_menu_maker_new ((GActionMap*) _tmp3_);
#line 325 "window.vala"
	_tmp5_ = _tmp4_;
#line 325 "window.vala"
	_tmp6_ = pasang_menu_maker_add (_tmp5_, "Help", _ ("_Help"), _pasang_window_on_help_pasang_menu_maker_activate_func, self, "F1");
#line 325 "window.vala"
	_tmp7_ = _tmp6_;
#line 325 "window.vala"
	_tmp8_ = pasang_menu_maker_add (_tmp7_, "About", _ ("_About Pasang Emas"), _pasang_window_on_about_pasang_menu_maker_activate_func, self, NULL);
#line 325 "window.vala"
	_tmp9_ = _tmp8_;
#line 325 "window.vala"
	_tmp10_ = pasang_menu_maker_end (_tmp9_);
#line 325 "window.vala"
	_tmp11_ = _tmp10_;
#line 325 "window.vala"
	gtk_menu_button_set_menu_model (button, _tmp11_);
#line 325 "window.vala"
	_g_object_unref0 (_tmp11_);
#line 325 "window.vala"
	_pasang_menu_maker_unref0 (_tmp9_);
#line 325 "window.vala"
	_pasang_menu_maker_unref0 (_tmp7_);
#line 325 "window.vala"
	_pasang_menu_maker_unref0 (_tmp5_);
#line 329 "window.vala"
	result = (GtkWidget*) button;
#line 329 "window.vala"
	return result;
#line 2237 "window.c"
}

/**
     * Attach theme_switch to a MenuButton
     */
static GtkWidget*
pasang_window_create_theme_menu_button (PasangWindow* self)
{
	GtkMenuButton* button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkPopover* popover = NULL;
	GtkPopover* _tmp3_;
	PasangGameView* _tmp4_;
	PasangThemeSwitch* _tmp5_;
	PasangThemeSwitch* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* result = NULL;
#line 335 "window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 336 "window.vala"
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 336 "window.vala"
	g_object_ref_sink (_tmp0_);
#line 336 "window.vala"
	button = _tmp0_;
#line 339 "window.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("preferences-color", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 339 "window.vala"
	g_object_ref_sink (_tmp1_);
#line 339 "window.vala"
	_tmp2_ = _tmp1_;
#line 339 "window.vala"
	gtk_button_set_image ((GtkButton*) button, (GtkWidget*) _tmp2_);
#line 339 "window.vala"
	_g_object_unref0 (_tmp2_);
#line 340 "window.vala"
	gtk_button_set_relief ((GtkButton*) button, GTK_RELIEF_NONE);
#line 341 "window.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Choose theme"));
#line 342 "window.vala"
	_tmp3_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) button);
#line 342 "window.vala"
	g_object_ref_sink (_tmp3_);
#line 342 "window.vala"
	popover = _tmp3_;
#line 343 "window.vala"
	_tmp4_ = self->priv->game_view;
#line 343 "window.vala"
	_tmp5_ = pasang_game_view_get_theme_switch (_tmp4_);
#line 343 "window.vala"
	_tmp6_ = _tmp5_;
#line 343 "window.vala"
	gtk_container_add ((GtkContainer*) popover, (GtkWidget*) _tmp6_);
#line 344 "window.vala"
	gtk_menu_button_set_popover (button, popover);
#line 345 "window.vala"
	_tmp7_ = _g_object_ref0 ((GtkWidget*) button);
#line 345 "window.vala"
	_g_object_unref0 (self->priv->theme_menu_button);
#line 345 "window.vala"
	self->priv->theme_menu_button = _tmp7_;
#line 345 "window.vala"
	_tmp8_ = self->priv->theme_menu_button;
#line 345 "window.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 345 "window.vala"
	result = _tmp9_;
#line 345 "window.vala"
	_g_object_unref0 (popover);
#line 345 "window.vala"
	_g_object_unref0 (button);
#line 345 "window.vala"
	return result;
#line 2315 "window.c"
}

/**
     * Create a go-back button to apply or ignore pattern edit
     */
static void
_pasang_window_on_undo_pattern_pasang_menu_maker_activate_func (gpointer self)
{
#line 355 "window.vala"
	pasang_window_on_undo_pattern ((PasangWindow*) self);
#line 2326 "window.c"
}

static void
_pasang_window_on_save_pattern_pasang_menu_maker_activate_func (gpointer self)
{
#line 355 "window.vala"
	pasang_window_on_save_pattern ((PasangWindow*) self);
#line 2334 "window.c"
}

static GtkWidget*
pasang_window_create_pattern_go_back_button (PasangWindow* self)
{
	GtkMenuButton* button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	PasangMenuMaker* _tmp4_;
	PasangMenuMaker* _tmp5_;
	PasangMenuMaker* _tmp6_;
	PasangMenuMaker* _tmp7_;
	PasangMenuMaker* _tmp8_;
	PasangMenuMaker* _tmp9_;
	GMenuModel* _tmp10_;
	GMenuModel* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* result = NULL;
#line 351 "window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 352 "window.vala"
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 352 "window.vala"
	g_object_ref_sink (_tmp0_);
#line 352 "window.vala"
	button = _tmp0_;
#line 353 "window.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 353 "window.vala"
	g_object_ref_sink (_tmp1_);
#line 353 "window.vala"
	_tmp2_ = _tmp1_;
#line 353 "window.vala"
	gtk_button_set_image ((GtkButton*) button, (GtkWidget*) _tmp2_);
#line 353 "window.vala"
	_g_object_unref0 (_tmp2_);
#line 354 "window.vala"
	gtk_button_set_relief ((GtkButton*) button, GTK_RELIEF_NONE);
#line 355 "window.vala"
	_tmp3_ = self->priv->main_window;
#line 355 "window.vala"
	_tmp4_ = pasang_menu_maker_new ((GActionMap*) _tmp3_);
#line 355 "window.vala"
	_tmp5_ = _tmp4_;
#line 355 "window.vala"
	_tmp6_ = pasang_menu_maker_add (_tmp5_, "UndoPattern", _ ("Ignore Changes"), _pasang_window_on_undo_pattern_pasang_menu_maker_activate_func, self, NULL);
#line 355 "window.vala"
	_tmp7_ = _tmp6_;
#line 355 "window.vala"
	_tmp8_ = pasang_menu_maker_add (_tmp7_, "SavePattern", _ ("Apply Changes"), _pasang_window_on_save_pattern_pasang_menu_maker_activate_func, self, NULL);
#line 355 "window.vala"
	_tmp9_ = _tmp8_;
#line 355 "window.vala"
	_tmp10_ = pasang_menu_maker_end (_tmp9_);
#line 355 "window.vala"
	_tmp11_ = _tmp10_;
#line 355 "window.vala"
	gtk_menu_button_set_menu_model (button, _tmp11_);
#line 355 "window.vala"
	_g_object_unref0 (_tmp11_);
#line 355 "window.vala"
	_pasang_menu_maker_unref0 (_tmp9_);
#line 355 "window.vala"
	_pasang_menu_maker_unref0 (_tmp7_);
#line 355 "window.vala"
	_pasang_menu_maker_unref0 (_tmp5_);
#line 359 "window.vala"
	_tmp12_ = _g_object_ref0 ((GtkWidget*) button);
#line 359 "window.vala"
	_g_object_unref0 (self->priv->pattern_go_back_button);
#line 359 "window.vala"
	self->priv->pattern_go_back_button = _tmp12_;
#line 359 "window.vala"
	_tmp13_ = self->priv->pattern_go_back_button;
#line 359 "window.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 359 "window.vala"
	result = _tmp14_;
#line 359 "window.vala"
	_g_object_unref0 (button);
#line 359 "window.vala"
	return result;
#line 2421 "window.c"
}

/**
     * Create a go-back button
     */
static void
_pasang_window_on_undo_pasang_menu_maker_activate_func (gpointer self)
{
#line 369 "window.vala"
	pasang_window_on_undo ((PasangWindow*) self);
#line 2432 "window.c"
}

static void
_pasang_window_on_retreat_pasang_menu_maker_activate_func (gpointer self)
{
#line 369 "window.vala"
	pasang_window_on_retreat ((PasangWindow*) self);
#line 2440 "window.c"
}

static GtkWidget*
pasang_window_create_go_back_button (PasangWindow* self)
{
	GtkMenuButton* button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	PasangMenuMaker* _tmp4_;
	PasangMenuMaker* _tmp5_;
	PasangMenuMaker* _tmp6_;
	PasangMenuMaker* _tmp7_;
	PasangMenuMaker* _tmp8_;
	PasangMenuMaker* _tmp9_;
	GMenuModel* _tmp10_;
	GMenuModel* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* result = NULL;
#line 365 "window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 366 "window.vala"
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 366 "window.vala"
	g_object_ref_sink (_tmp0_);
#line 366 "window.vala"
	button = _tmp0_;
#line 367 "window.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 367 "window.vala"
	g_object_ref_sink (_tmp1_);
#line 367 "window.vala"
	_tmp2_ = _tmp1_;
#line 367 "window.vala"
	gtk_button_set_image ((GtkButton*) button, (GtkWidget*) _tmp2_);
#line 367 "window.vala"
	_g_object_unref0 (_tmp2_);
#line 368 "window.vala"
	gtk_button_set_relief ((GtkButton*) button, GTK_RELIEF_NONE);
#line 369 "window.vala"
	_tmp3_ = self->priv->main_window;
#line 369 "window.vala"
	_tmp4_ = pasang_menu_maker_new ((GActionMap*) _tmp3_);
#line 369 "window.vala"
	_tmp5_ = _tmp4_;
#line 369 "window.vala"
	_tmp6_ = pasang_menu_maker_add (_tmp5_, "Undo", _ ("_Undo Move"), _pasang_window_on_undo_pasang_menu_maker_activate_func, self, "<control>Z");
#line 369 "window.vala"
	_tmp7_ = _tmp6_;
#line 369 "window.vala"
	_tmp8_ = pasang_menu_maker_add (_tmp7_, "Retreat", _ ("Back to Menu"), _pasang_window_on_retreat_pasang_menu_maker_activate_func, self, NULL);
#line 369 "window.vala"
	_tmp9_ = _tmp8_;
#line 369 "window.vala"
	_tmp10_ = pasang_menu_maker_end (_tmp9_);
#line 369 "window.vala"
	_tmp11_ = _tmp10_;
#line 369 "window.vala"
	gtk_menu_button_set_menu_model (button, _tmp11_);
#line 369 "window.vala"
	_g_object_unref0 (_tmp11_);
#line 369 "window.vala"
	_pasang_menu_maker_unref0 (_tmp9_);
#line 369 "window.vala"
	_pasang_menu_maker_unref0 (_tmp7_);
#line 369 "window.vala"
	_pasang_menu_maker_unref0 (_tmp5_);
#line 373 "window.vala"
	_tmp12_ = _g_object_ref0 ((GtkWidget*) button);
#line 373 "window.vala"
	_g_object_unref0 (self->priv->go_back_button);
#line 373 "window.vala"
	self->priv->go_back_button = _tmp12_;
#line 373 "window.vala"
	_tmp13_ = self->priv->go_back_button;
#line 373 "window.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 373 "window.vala"
	result = _tmp14_;
#line 373 "window.vala"
	_g_object_unref0 (button);
#line 373 "window.vala"
	return result;
#line 2527 "window.c"
}

/**
     * Things to do when visible_child changes, or game mode changes
     */
static void
pasang_window_on_status_changed (PasangWindow* self)
{
	gboolean _tmp0_ = FALSE;
	PasangMode _tmp1_;
	const gchar* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	PasangGameMenu* _tmp8_;
	GtkHeaderBar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	PasangMode _tmp19_;
	GtkHeaderBar* _tmp22_;
	GtkWidget* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	PasangGameView* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GtkWidget* _tmp28_;
	GtkWidget* _tmp29_;
	PasangGameMenu* _tmp30_;
	GtkWidget* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp37_;
	PasangPatternEditor* _tmp38_;
#line 379 "window.vala"
	g_return_if_fail (self != NULL);
#line 381 "window.vala"
	_tmp1_ = self->priv->_mode;
#line 381 "window.vala"
	if (_tmp1_ == PASANG_MODE_USER_VS_AI) {
#line 2565 "window.c"
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		PasangGameView* _tmp4_;
#line 381 "window.vala"
		_tmp2_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 381 "window.vala"
		_tmp3_ = _tmp2_;
#line 381 "window.vala"
		_tmp4_ = self->priv->game_view;
#line 381 "window.vala"
		_tmp0_ = _tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget);
#line 2577 "window.c"
	} else {
#line 381 "window.vala"
		_tmp0_ = FALSE;
#line 2581 "window.c"
	}
#line 381 "window.vala"
	pasang_window_set_action_enabled (self, "Undo", _tmp0_);
#line 384 "window.vala"
	_tmp6_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 384 "window.vala"
	_tmp7_ = _tmp6_;
#line 384 "window.vala"
	_tmp8_ = self->priv->game_menu;
#line 384 "window.vala"
	if (_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget)) {
#line 384 "window.vala"
		_tmp5_ = _ (PACKAGE_NAME);
#line 2595 "window.c"
	} else {
		const gchar* _tmp9_ = NULL;
		PasangMode _tmp10_;
#line 385 "window.vala"
		_tmp10_ = self->priv->_mode;
#line 385 "window.vala"
		if (_tmp10_ == PASANG_MODE_USER_VS_AI) {
#line 385 "window.vala"
			_tmp9_ = _ ("Playing Against Machine");
#line 2605 "window.c"
		} else {
			const gchar* _tmp11_ = NULL;
			PasangMode _tmp12_;
#line 386 "window.vala"
			_tmp12_ = self->priv->_mode;
#line 386 "window.vala"
			if (_tmp12_ == PASANG_MODE_USER_VS_USER) {
#line 386 "window.vala"
				_tmp11_ = _ ("Playing Face to Face");
#line 2615 "window.c"
			} else {
				const gchar* _tmp13_ = NULL;
				PasangMode _tmp14_;
#line 387 "window.vala"
				_tmp14_ = self->priv->_mode;
#line 387 "window.vala"
				if (_tmp14_ == PASANG_MODE_AI_VS_AI) {
#line 387 "window.vala"
					_tmp13_ = _ ("Demo");
#line 2625 "window.c"
				} else {
					const gchar* _tmp15_ = NULL;
					PasangMode _tmp16_;
#line 388 "window.vala"
					_tmp16_ = self->priv->_mode;
#line 388 "window.vala"
					if (_tmp16_ == PASANG_MODE_NETWORK) {
#line 388 "window.vala"
						_tmp15_ = _ ("Playing Online");
#line 2635 "window.c"
					} else {
#line 388 "window.vala"
						_tmp15_ = "?? if you see this, complain ???";
#line 2639 "window.c"
					}
#line 388 "window.vala"
					_tmp13_ = _tmp15_;
#line 2643 "window.c"
				}
#line 387 "window.vala"
				_tmp11_ = _tmp13_;
#line 2647 "window.c"
			}
#line 386 "window.vala"
			_tmp9_ = _tmp11_;
#line 2651 "window.c"
		}
#line 385 "window.vala"
		_tmp5_ = _tmp9_;
#line 2655 "window.c"
	}
#line 383 "window.vala"
	_tmp17_ = self->priv->header_bar;
#line 383 "window.vala"
	gtk_header_bar_set_title (_tmp17_, _tmp5_);
#line 389 "window.vala"
	_tmp19_ = self->priv->_mode;
#line 389 "window.vala"
	if (_tmp19_ == PASANG_MODE_NETWORK) {
#line 2665 "window.c"
		PasangClient* _tmp20_;
		const gchar* _tmp21_;
#line 389 "window.vala"
		_tmp20_ = self->priv->client;
#line 389 "window.vala"
		_tmp21_ = _tmp20_->opponent_name;
#line 389 "window.vala"
		_tmp18_ = _tmp21_;
#line 2674 "window.c"
	} else {
#line 389 "window.vala"
		_tmp18_ = NULL;
#line 2678 "window.c"
	}
#line 389 "window.vala"
	_tmp22_ = self->priv->header_bar;
#line 389 "window.vala"
	gtk_header_bar_set_subtitle (_tmp22_, _tmp18_);
#line 391 "window.vala"
	_tmp23_ = self->priv->theme_menu_button;
#line 391 "window.vala"
	_tmp24_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 391 "window.vala"
	_tmp25_ = _tmp24_;
#line 391 "window.vala"
	_tmp26_ = self->priv->game_view;
#line 391 "window.vala"
	gtk_widget_set_visible (_tmp23_, _tmp25_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
#line 392 "window.vala"
	_tmp28_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 392 "window.vala"
	_tmp29_ = _tmp28_;
#line 392 "window.vala"
	_tmp30_ = self->priv->game_menu;
#line 392 "window.vala"
	if (_tmp29_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget)) {
#line 2702 "window.c"
		GtkWidget* _tmp31_;
		GtkWidget* _tmp32_;
		PasangPatternEditor* _tmp33_;
#line 392 "window.vala"
		_tmp31_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 392 "window.vala"
		_tmp32_ = _tmp31_;
#line 392 "window.vala"
		_tmp33_ = self->priv->pattern_editor;
#line 392 "window.vala"
		_tmp27_ = _tmp32_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget);
#line 2714 "window.c"
	} else {
#line 392 "window.vala"
		_tmp27_ = FALSE;
#line 2718 "window.c"
	}
#line 392 "window.vala"
	_tmp34_ = self->priv->go_back_button;
#line 392 "window.vala"
	gtk_widget_set_visible (_tmp34_, _tmp27_);
#line 393 "window.vala"
	_tmp35_ = self->priv->pattern_go_back_button;
#line 393 "window.vala"
	_tmp36_ = gtk_stack_get_visible_child ((GtkStack*) self);
#line 393 "window.vala"
	_tmp37_ = _tmp36_;
#line 393 "window.vala"
	_tmp38_ = self->priv->pattern_editor;
#line 393 "window.vala"
	gtk_widget_set_visible (_tmp35_, _tmp37_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
#line 2734 "window.c"
}

/**
     * Functions performed when some user Action is triggered
     */
static void
pasang_window_show_game_menu (PasangWindow* self)
{
	PasangGameMenu* _tmp0_;
	PasangGameView* _tmp1_;
#line 399 "window.vala"
	g_return_if_fail (self != NULL);
#line 400 "window.vala"
	_tmp0_ = self->priv->game_menu;
#line 400 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
#line 401 "window.vala"
	pasang_window_stop_thinking (self);
#line 402 "window.vala"
	_tmp1_ = self->priv->game_view;
#line 402 "window.vala"
	pasang_game_view_stop_simulation (_tmp1_);
#line 404 "window.vala"
	pasang_window_set_mode (self, PASANG_MODE_USER_VS_USER);
#line 2759 "window.c"
}

static void
pasang_window_on_newgame_ai (PasangWindow* self)
{
#line 407 "window.vala"
	g_return_if_fail (self != NULL);
#line 408 "window.vala"
	pasang_window_set_mode (self, PASANG_MODE_USER_VS_AI);
#line 409 "window.vala"
	pasang_window_init_game (self);
#line 2771 "window.c"
}

static void
pasang_window_on_newgame_2p (PasangWindow* self)
{
#line 412 "window.vala"
	g_return_if_fail (self != NULL);
#line 413 "window.vala"
	pasang_window_set_mode (self, PASANG_MODE_USER_VS_USER);
#line 414 "window.vala"
	pasang_window_init_game (self);
#line 2783 "window.c"
}

static void
pasang_window_init_game (PasangWindow* self)
{
	PasangGameSeries* _tmp0_;
	PasangPatternSelector* _tmp1_;
	PasangPatternSelector* _tmp2_;
#line 417 "window.vala"
	g_return_if_fail (self != NULL);
#line 418 "window.vala"
	_tmp0_ = self->priv->game;
#line 418 "window.vala"
	pasang_game_series_start_new_series (_tmp0_);
#line 419 "window.vala"
	pasang_window_stop_thinking (self);
#line 420 "window.vala"
	_tmp1_ = self->priv->pattern_selector;
#line 420 "window.vala"
	pasang_pattern_selector_set_sensitive (_tmp1_, TRUE);
#line 421 "window.vala"
	_tmp2_ = self->priv->pattern_selector;
#line 421 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp2_);
#line 2808 "window.c"
}

static void
pasang_window_on_demo (PasangWindow* self)
{
	PasangGameSeries* _tmp0_;
	PasangGameView* _tmp1_;
#line 424 "window.vala"
	g_return_if_fail (self != NULL);
#line 425 "window.vala"
	_tmp0_ = self->priv->game;
#line 425 "window.vala"
	pasang_game_series_start_new_series (_tmp0_);
#line 426 "window.vala"
	pasang_window_stop_thinking (self);
#line 427 "window.vala"
	_tmp1_ = self->priv->game_view;
#line 427 "window.vala"
	pasang_game_view_stop_simulation (_tmp1_);
#line 428 "window.vala"
	pasang_window_set_mode (self, PASANG_MODE_AI_VS_AI);
#line 429 "window.vala"
	pasang_window_start_demo_round (self, NULL, NULL);
#line 2832 "window.c"
}

static void
pasang_window_on_undo (PasangWindow* self)
{
	PasangMode _tmp0_;
	PasangGameView* _tmp2_;
	gboolean _tmp3_ = FALSE;
	PasangGameSeries* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 432 "window.vala"
	g_return_if_fail (self != NULL);
#line 433 "window.vala"
	pasang_window_stop_thinking (self);
#line 434 "window.vala"
	_tmp0_ = self->priv->_mode;
#line 434 "window.vala"
	if (_tmp0_ != PASANG_MODE_USER_VS_AI) {
#line 2852 "window.c"
		FILE* _tmp1_;
#line 435 "window.vala"
		_tmp1_ = stderr;
#line 435 "window.vala"
		fprintf (_tmp1_, "Unexpected event: 'Undo'\n");
#line 436 "window.vala"
		return;
#line 2860 "window.c"
	}
#line 438 "window.vala"
	_tmp2_ = self->priv->game_view;
#line 438 "window.vala"
	pasang_game_view_stop_simulation (_tmp2_);
#line 439 "window.vala"
	_tmp4_ = self->priv->game;
#line 439 "window.vala"
	_tmp5_ = pasang_game_get_player ((PasangGame*) _tmp4_);
#line 439 "window.vala"
	_tmp6_ = _tmp5_;
#line 439 "window.vala"
	if (_tmp6_ == 0) {
#line 2874 "window.c"
		PasangGameSeries* _tmp7_;
		PasangStage _tmp8_;
		PasangStage _tmp9_;
#line 439 "window.vala"
		_tmp7_ = self->priv->game;
#line 439 "window.vala"
		_tmp8_ = pasang_game_get_stage ((PasangGame*) _tmp7_);
#line 439 "window.vala"
		_tmp9_ = _tmp8_;
#line 439 "window.vala"
		_tmp3_ = _tmp9_ == PASANG_STAGE_OPENING;
#line 2886 "window.c"
	} else {
#line 439 "window.vala"
		_tmp3_ = FALSE;
#line 2890 "window.c"
	}
#line 439 "window.vala"
	if (_tmp3_) {
#line 2894 "window.c"
		PasangGameView* _tmp10_;
		PasangPatternSelector* _tmp11_;
		PasangPatternSelector* _tmp12_;
#line 441 "window.vala"
		_tmp10_ = self->priv->game_view;
#line 441 "window.vala"
		pasang_game_view_set_turn (_tmp10_, PASANG_PLAYER_AI, PASANG_PLAYER_HUMAN, 1);
#line 442 "window.vala"
		_tmp11_ = self->priv->pattern_selector;
#line 442 "window.vala"
		pasang_pattern_selector_set_sensitive (_tmp11_, TRUE);
#line 443 "window.vala"
		_tmp12_ = self->priv->pattern_selector;
#line 443 "window.vala"
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp12_);
#line 2910 "window.c"
	} else {
		PasangGameSeries* _tmp13_;
		PasangGameView* _tmp14_;
		PasangPlayer _tmp15_;
		PasangPlayer _tmp16_;
		PasangGameView* _tmp18_;
#line 446 "window.vala"
		_tmp13_ = self->priv->game;
#line 446 "window.vala"
		pasang_game_series_undo (_tmp13_);
#line 447 "window.vala"
		_tmp14_ = self->priv->game_view;
#line 447 "window.vala"
		_tmp15_ = pasang_game_view_get_player_type (_tmp14_);
#line 447 "window.vala"
		_tmp16_ = _tmp15_;
#line 447 "window.vala"
		if (_tmp16_ == PASANG_PLAYER_AI) {
#line 2929 "window.c"
			PasangGameSeries* _tmp17_;
#line 447 "window.vala"
			_tmp17_ = self->priv->game;
#line 447 "window.vala"
			pasang_game_series_undo (_tmp17_);
#line 2935 "window.c"
		}
#line 448 "window.vala"
		_tmp18_ = self->priv->game_view;
#line 448 "window.vala"
		pasang_game_view_hang_message (_tmp18_);
#line 449 "window.vala"
		pasang_window_prepare_for_next_move (self, FALSE);
#line 2943 "window.c"
	}
}

static void
pasang_window_on_retreat (PasangWindow* self)
{
	PasangMode _tmp0_;
#line 453 "window.vala"
	g_return_if_fail (self != NULL);
#line 454 "window.vala"
	_tmp0_ = self->priv->_mode;
#line 454 "window.vala"
	if (_tmp0_ == PASANG_MODE_NETWORK) {
#line 2957 "window.c"
		PasangClient* _tmp1_;
#line 455 "window.vala"
		_tmp1_ = self->priv->client;
#line 455 "window.vala"
		pasang_client_request_retreat (_tmp1_);
#line 2963 "window.c"
	}
#line 457 "window.vala"
	pasang_window_show_game_menu (self);
#line 2967 "window.c"
}

static void
pasang_window_on_undo_pattern (PasangWindow* self)
{
	PasangPatternSelector* _tmp0_;
#line 460 "window.vala"
	g_return_if_fail (self != NULL);
#line 461 "window.vala"
	_tmp0_ = self->priv->pattern_selector;
#line 461 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
#line 2980 "window.c"
}

static void
pasang_window_on_save_pattern (PasangWindow* self)
{
	PasangPatternEditor* _tmp0_;
	PasangPatternSelector* _tmp1_;
#line 464 "window.vala"
	g_return_if_fail (self != NULL);
#line 465 "window.vala"
	_tmp0_ = self->priv->pattern_editor;
#line 465 "window.vala"
	pasang_pattern_editor_apply (_tmp0_, TRUE);
#line 466 "window.vala"
	_tmp1_ = self->priv->pattern_selector;
#line 466 "window.vala"
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp1_);
#line 2998 "window.c"
}

static void
pasang_window_on_quit (PasangWindow* self)
{
	PasangClient* _tmp0_;
	GtkApplicationWindow* _tmp1_;
	GtkApplicationWindow* _tmp2_;
#line 469 "window.vala"
	g_return_if_fail (self != NULL);
#line 470 "window.vala"
	_tmp0_ = self->priv->client;
#line 470 "window.vala"
	pasang_client_request_logout (_tmp0_);
#line 471 "window.vala"
	pasang_window_stop_thinking (self);
#line 472 "window.vala"
	_tmp1_ = self->priv->main_window;
#line 472 "window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 473 "window.vala"
	_tmp2_ = self->priv->main_window;
#line 473 "window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 3023 "window.c"
}

static void
pasang_window_on_help (PasangWindow* self)
{
	GAppInfo* app = NULL;
	GAppInfo* _tmp0_;
	gchar* uri = NULL;
	gchar* _tmp1_;
	GAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 476 "window.vala"
	g_return_if_fail (self != NULL);
#line 481 "window.vala"
	_tmp0_ = g_app_info_get_default_for_uri_scheme ("help");
#line 481 "window.vala"
	app = _tmp0_;
#line 482 "window.vala"
	_tmp1_ = g_strdup ("help:pasang-emas");
#line 482 "window.vala"
	uri = _tmp1_;
#line 483 "window.vala"
	_tmp2_ = app;
#line 483 "window.vala"
	if (_tmp2_ == NULL) {
#line 3049 "window.c"
		GAppInfo* _tmp3_;
		gchar* _tmp4_;
#line 484 "window.vala"
		g_print ("No support for \"help\" uri. Falling back to \"http\".\n");
#line 485 "window.vala"
		_tmp3_ = g_app_info_get_default_for_uri_scheme ("http");
#line 485 "window.vala"
		_g_object_unref0 (app);
#line 485 "window.vala"
		app = _tmp3_;
#line 486 "window.vala"
		_tmp4_ = g_strdup ("http://pasang-emas.sourceforge.net/how-to-play/index.xhtml");
#line 486 "window.vala"
		_g_free0 (uri);
#line 486 "window.vala"
		uri = _tmp4_;
#line 3066 "window.c"
	}
	{
		GAppInfo* _tmp5_;
		const gchar* _tmp6_;
		GtkApplicationWindow* _tmp7_;
		const gchar* _tmp8_;
#line 489 "window.vala"
		_tmp5_ = app;
#line 489 "window.vala"
		_tmp6_ = g_app_info_get_commandline (_tmp5_);
#line 489 "window.vala"
		g_print ("Showing help using %s\n", _tmp6_);
#line 490 "window.vala"
		_tmp7_ = self->priv->main_window;
#line 490 "window.vala"
		_tmp8_ = uri;
#line 490 "window.vala"
		gtk_show_uri_on_window ((GtkWindow*) _tmp7_, _tmp8_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 490 "window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3087 "window.c"
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		FILE* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 488 "window.vala"
		e = _inner_error0_;
#line 488 "window.vala"
		_inner_error0_ = NULL;
#line 493 "window.vala"
		_tmp9_ = stderr;
#line 493 "window.vala"
		_tmp10_ = e;
#line 493 "window.vala"
		_tmp11_ = _tmp10_->message;
#line 493 "window.vala"
		fprintf (_tmp9_, "Error: %s \n", _tmp11_);
#line 488 "window.vala"
		_g_error_free0 (e);
#line 3112 "window.c"
	}
	__finally23:
#line 488 "window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 488 "window.vala"
		_g_free0 (uri);
#line 488 "window.vala"
		_g_object_unref0 (app);
#line 488 "window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 488 "window.vala"
		g_clear_error (&_inner_error0_);
#line 488 "window.vala"
		return;
#line 3127 "window.c"
	}
#line 476 "window.vala"
	_g_free0 (uri);
#line 476 "window.vala"
	_g_object_unref0 (app);
#line 3133 "window.c"
}

static void
pasang_window_on_about (PasangWindow* self)
{
	GdkPixbuf* logo = NULL;
	GtkApplicationWindow* _tmp8_;
	GdkPixbuf* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
#line 497 "window.vala"
	g_return_if_fail (self != NULL);
#line 498 "window.vala"
	logo = NULL;
#line 3156 "window.c"
	{
		gchar* file = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 500 "window.vala"
		_tmp0_ = pasang_reloc_flash_dir;
#line 500 "window.vala"
		_tmp1_ = g_strconcat (_tmp0_, "/pasang-emas-flash.png", NULL);
#line 500 "window.vala"
		file = _tmp1_;
#line 501 "window.vala"
		_tmp3_ = gdk_pixbuf_new_from_file (file, &_inner_error0_);
#line 501 "window.vala"
		_tmp2_ = _tmp3_;
#line 501 "window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 501 "window.vala"
			_g_free0 (file);
#line 3178 "window.c"
			goto __catch24_g_error;
		}
#line 501 "window.vala"
		_tmp4_ = _tmp2_;
#line 501 "window.vala"
		_tmp2_ = NULL;
#line 501 "window.vala"
		_g_object_unref0 (logo);
#line 501 "window.vala"
		logo = _tmp4_;
#line 499 "window.vala"
		_g_object_unref0 (_tmp2_);
#line 499 "window.vala"
		_g_free0 (file);
#line 3193 "window.c"
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 499 "window.vala"
		e = _inner_error0_;
#line 499 "window.vala"
		_inner_error0_ = NULL;
#line 504 "window.vala"
		_tmp5_ = stderr;
#line 504 "window.vala"
		_tmp6_ = e;
#line 504 "window.vala"
		_tmp7_ = _tmp6_->message;
#line 504 "window.vala"
		fprintf (_tmp5_, "Cannot load logo: %s\n", _tmp7_);
#line 499 "window.vala"
		_g_error_free0 (e);
#line 3216 "window.c"
	}
	__finally24:
#line 499 "window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 499 "window.vala"
		_g_object_unref0 (logo);
#line 499 "window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 499 "window.vala"
		g_clear_error (&_inner_error0_);
#line 499 "window.vala"
		return;
#line 3229 "window.c"
	}
#line 506 "window.vala"
	_tmp8_ = self->priv->main_window;
#line 506 "window.vala"
	_tmp9_ = logo;
#line 506 "window.vala"
	_tmp10_ = g_strdup ("Nor Jaidi Tuah <norjaidi.tuah@ubd.edu.bn> (programmer)");
#line 506 "window.vala"
	_tmp11_ = g_strdup ("Mohd Abdoh bin Haji Awang Damit (initiator)");
#line 506 "window.vala"
	_tmp12_ = g_new0 (gchar*, 3 + 1);
#line 506 "window.vala"
	_tmp12_[0] = _tmp10_;
#line 506 "window.vala"
	_tmp12_[1] = _tmp11_;
#line 506 "window.vala"
	_tmp12_[2] = NULL;
#line 506 "window.vala"
	_tmp13_ = _tmp12_;
#line 506 "window.vala"
	_tmp13__length1 = 3;
#line 506 "window.vala"
	_tmp14_ = g_strdup ("Nor Jaidi Tuah <norjaidi.tuah@ubd.edu.bn>");
#line 506 "window.vala"
	_tmp15_ = g_new0 (gchar*, 2 + 1);
#line 506 "window.vala"
	_tmp15_[0] = _tmp14_;
#line 506 "window.vala"
	_tmp15_[1] = NULL;
#line 506 "window.vala"
	_tmp16_ = _tmp15_;
#line 506 "window.vala"
	_tmp16__length1 = 2;
#line 506 "window.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp8_, "program-name", _ (PACKAGE_NAME), "version", PACKAGE_VERSION, "comments", _ ("A traditional board game of Brunei"), "copyright", "Copyright (C) 2008-2019 Nor Jaidi Tuah", "logo", _tmp9_, "authors", _tmp13_, "artists", _tmp16_, "translator_credits", _ ("translator_credits"), "license-type", GTK_LICENSE_GPL_3_0, "website", "http://pasang-emas.sourceforge.net/", "website-label", "pasang-emas.sourceforge.net", NULL);
#line 506 "window.vala"
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
#line 506 "window.vala"
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
#line 497 "window.vala"
	_g_object_unref0 (logo);
#line 3271 "window.c"
}

/**
     * A helper method to call GLib.SimpleAction.set_enabled
     */
static void
pasang_window_set_action_enabled (PasangWindow* self,
                                  const gchar* action,
                                  gboolean enabled)
{
	GSimpleAction* simple_action = NULL;
	GtkApplicationWindow* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
#line 526 "window.vala"
	g_return_if_fail (self != NULL);
#line 526 "window.vala"
	g_return_if_fail (action != NULL);
#line 527 "window.vala"
	_tmp0_ = self->priv->main_window;
#line 527 "window.vala"
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, action);
#line 527 "window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp1_) : NULL);
#line 527 "window.vala"
	simple_action = _tmp2_;
#line 528 "window.vala"
	_tmp3_ = simple_action;
#line 528 "window.vala"
	if (_tmp3_ != NULL) {
#line 3303 "window.c"
		GSimpleAction* _tmp4_;
#line 528 "window.vala"
		_tmp4_ = simple_action;
#line 528 "window.vala"
		g_simple_action_set_enabled (_tmp4_, enabled);
#line 3309 "window.c"
	}
#line 526 "window.vala"
	_g_object_unref0 (simple_action);
#line 3313 "window.c"
}

PasangMode
pasang_window_get_mode (PasangWindow* self)
{
	PasangMode result;
	PasangMode _tmp0_;
#line 48 "window.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "window.vala"
	_tmp0_ = self->priv->_mode;
#line 48 "window.vala"
	result = _tmp0_;
#line 48 "window.vala"
	return result;
#line 3329 "window.c"
}

void
pasang_window_set_mode (PasangWindow* self,
                        PasangMode value)
{
#line 48 "window.vala"
	g_return_if_fail (self != NULL);
#line 48 "window.vala"
	if (pasang_window_get_mode (self) != value) {
#line 48 "window.vala"
		self->priv->_mode = value;
#line 48 "window.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_window_properties[PASANG_WINDOW_MODE_PROPERTY]);
#line 3344 "window.c"
	}
}

static void
pasang_window_class_init (PasangWindowClass * klass,
                          gpointer klass_data)
{
#line 31 "window.vala"
	pasang_window_parent_class = g_type_class_peek_parent (klass);
#line 31 "window.vala"
	g_type_class_adjust_private_offset (klass, &PasangWindow_private_offset);
#line 31 "window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_window_get_property;
#line 31 "window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_window_set_property;
#line 31 "window.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_window_finalize;
#line 3362 "window.c"
	/**
	     * mode is public to enable notify
	     */
#line 31 "window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_WINDOW_MODE_PROPERTY, pasang_window_properties[PASANG_WINDOW_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", PASANG_TYPE_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3368 "window.c"
}

static void
pasang_window_instance_init (PasangWindow * self,
                             gpointer klass)
{
	PasangGameSeries* _tmp0_;
	PasangPatternSelector* _tmp1_;
	PasangBrain* _tmp2_;
#line 31 "window.vala"
	self->priv = pasang_window_get_instance_private (self);
#line 37 "window.vala"
	_tmp0_ = pasang_game_series_new ();
#line 37 "window.vala"
	self->priv->game = _tmp0_;
#line 40 "window.vala"
	_tmp1_ = pasang_pattern_selector_new ();
#line 40 "window.vala"
	g_object_ref_sink (_tmp1_);
#line 40 "window.vala"
	self->priv->pattern_selector = _tmp1_;
#line 42 "window.vala"
	_tmp2_ = pasang_brain_new ();
#line 42 "window.vala"
	self->priv->brain = _tmp2_;
#line 53 "window.vala"
	pasang_brain_spec_init (&self->priv->demo_player);
#line 64 "window.vala"
	self->priv->demo_ticket = 0;
#line 3398 "window.c"
}

static void
pasang_window_finalize (GObject * obj)
{
	PasangWindow * self;
#line 31 "window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_WINDOW, PasangWindow);
#line 32 "window.vala"
	_g_object_unref0 (self->priv->main_window);
#line 33 "window.vala"
	_g_object_unref0 (self->priv->header_bar);
#line 34 "window.vala"
	_g_object_unref0 (self->priv->theme_menu_button);
#line 35 "window.vala"
	_g_object_unref0 (self->priv->go_back_button);
#line 36 "window.vala"
	_g_object_unref0 (self->priv->pattern_go_back_button);
#line 37 "window.vala"
	_g_object_unref0 (self->priv->game);
#line 38 "window.vala"
	_g_object_unref0 (self->priv->game_menu);
#line 39 "window.vala"
	_g_object_unref0 (self->priv->game_view);
#line 40 "window.vala"
	_g_object_unref0 (self->priv->pattern_selector);
#line 41 "window.vala"
	_g_object_unref0 (self->priv->pattern_editor);
#line 42 "window.vala"
	_g_object_unref0 (self->priv->brain);
#line 43 "window.vala"
	_g_object_unref0 (self->priv->client);
#line 31 "window.vala"
	G_OBJECT_CLASS (pasang_window_parent_class)->finalize (obj);
#line 3433 "window.c"
}

/**
 * This is the main content of the window rather than the window.
 */
GType
pasang_window_get_type (void)
{
	static volatile gsize pasang_window_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangWindow), 0, (GInstanceInitFunc) pasang_window_instance_init, NULL };
		GType pasang_window_type_id;
		pasang_window_type_id = g_type_register_static (gtk_stack_get_type (), "PasangWindow", &g_define_type_info, 0);
		PasangWindow_private_offset = g_type_add_instance_private (pasang_window_type_id, sizeof (PasangWindowPrivate));
		g_once_init_leave (&pasang_window_type_id__volatile, pasang_window_type_id);
	}
	return pasang_window_type_id__volatile;
}

static void
_vala_pasang_window_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	PasangWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_WINDOW, PasangWindow);
#line 31 "window.vala"
	switch (property_id) {
#line 31 "window.vala"
		case PASANG_WINDOW_MODE_PROPERTY:
#line 31 "window.vala"
		g_value_set_enum (value, pasang_window_get_mode (self));
#line 31 "window.vala"
		break;
#line 3469 "window.c"
		default:
#line 31 "window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "window.vala"
		break;
#line 3475 "window.c"
	}
}

static void
_vala_pasang_window_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	PasangWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_WINDOW, PasangWindow);
#line 31 "window.vala"
	switch (property_id) {
#line 31 "window.vala"
		case PASANG_WINDOW_MODE_PROPERTY:
#line 31 "window.vala"
		pasang_window_set_mode (self, g_value_get_enum (value));
#line 31 "window.vala"
		break;
#line 3495 "window.c"
		default:
#line 31 "window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "window.vala"
		break;
#line 3501 "window.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

