      program create_examples
c
c Creation of various files of the directory Examples
c in the xd3d distribution tree.
c
      parameter(nxm=500,nym=500)
      real*4 x(nxm),y(nxm),z(nxm,nym)
c
c number of points in the x,y directions
c
      nx = 51
      ny = 51
c
c Irregular grid in x between -1 and 0.5
c
      do i=1,nx
        x(i) = -1. + 1.5*(real(i-1)/real(nx-1))**1.5
      enddo
c
c Regular grid in y between 0 and 1
c
      do i=1,ny
        y(i) = real(i-1)/real(ny-1)
      enddo
c
c A nice function
c
      do j=1,ny
        do i=1,nx
          z(i,j) = sin(4.*x(i)) * sin(3.*y(j))
        enddo
      enddo
c
c Here is the format of c3d files (binary file) 
c in cartesian coordinates: z = f(x,y)
c
      open(1,file='example_cartesian.c3d',form='unformatted')
      write(1) 0,0
      write(1) nx,ny
      write(1) (x(i),i=1,nx),(y(j),j=1,ny)
      write(1) ((z(i,j),i=1,nx),j=1,ny)
      close(1)
c
c-----------------------------------------------------
c Cylindrical coordinates: r=f(theta,z)
c ("x" = theta, "y" = z, "z" = r)
c
c Regular grid in theta between 0 and 2*pi
c
      pi = 3.141592654
      do i=1,nx
        x(i) = 2.*pi*(real(i-1)/real(nx-1))
      enddo
c
c Regular grid in z between 0 and 3
c
      do i=1,ny
        y(i) = 3.*real(i-1)/real(ny-1)
      enddo
c
c A nice function
c
      do j=1,ny
        do i=1,nx
          z(i,j) = 3. + 0.4*sin(2.*x(i)) * sin(y(j))
        enddo
      enddo
c
c Here is the format of c3d files (binary files) 
c in cylindrical coordinates: r=f(theta,z)
c
      open(1,file='example_cyl.c3d',form='unformatted')
c
c the "1" means "cylindrical coordinates"
c
      write(1) 0,1
      write(1) nx,ny
      write(1) (x(i),i=1,nx),(y(j),j=1,ny)
      write(1) ((z(i,j),i=1,nx),j=1,ny)
      close(1)
c
c-----------------------------------------------------
c Spherical coordinates: r=f(theta,phi)
c ("x" = theta, "y" = phi, "z" = r)
c
c Regular grid in theta between -pi/2 and pi/2
c
      pi = 3.141592654
      do i=1,nx
        x(i) = -pi/2 + pi*(real(i-1)/real(nx-1))
      enddo
c
c Regular grid in phi between -pi and pi
c
      do i=1,ny
        y(i) = -pi + 2.*pi*(real(i-1)/real(ny-1))
      enddo
c
c A nice function
c
      do j=1,ny
        do i=1,nx
          z(i,j) = 3. + 0.4*sin(2.*x(i)) * 4.*sin(y(j))
        enddo
      enddo
c
c Here is the format of c3d files (binary files) 
c in cylindrical coordinates: r=f(theta,z)
c
      open(1,file='example_sph.c3d',form='unformatted')
c
c the "1" means "spherical coordinates"
c
      write(1) 0,2
      write(1) nx,ny
      write(1) (x(i),i=1,nx),(y(j),j=1,ny)
      write(1) ((z(i,j),i=1,nx),j=1,ny)
      close(1)
c
c-----------------------------------------------------
c
c And now a .xyz file (ascii file)
c
c Irregular grid in x between -1 and 0.5
c
      do i=1,nx
        x(i) = -1. + 1.5*(real(i-1)/real(nx-1))**1.5
      enddo
c
c Regular grid in y between 0 and 1
c
      do i=1,ny
        y(i) = real(i-1)/real(nx-1)
      enddo
c
c A nice function
c
      do j=1,ny
        do i=1,nx
          z(i,j) = sin(4.*x(i)) * sin(3.*y(j))
        enddo
      enddo
      open(1,file='example.xyz')
      do i=1,nx
        do j=1,ny
          write(1,*) x(i),y(j),z(i,j)
        enddo
      enddo
      close(1)
      end
      
      
      
