#!/usr/bin/perl
#########################################################################################################################
#########################################################################################################################
##########                                      UgLy game search engine v rc10                                 ##########   
##########                                      Written for the valhalla Lan                                   ##########
##########                                      To be used whith many programs eg,                             ##########
##########                              Gametrakker, Serverquery or any qstat backing prog                     ##########
##########                                      Contact uglygs@uglypunk.com                                    ##########
#########################################################################################################################
#########################################################################################################################
require 'uglygs.conf';

$VERSION = "rc10";

if ($runmode eq "loop"){
 print  "UgLy game search engine\n";
 print  "Look at http://uglygs.uglypunk.com/ for updates\n";
 print  "Version $VERSION\n";
}
################################### Start checks ####################################


if (!-f $qstat) { die "Sorry the Qstat file doesn't exist, you may no have compiled it yet"};
if (!-d  $data) { die "Sorry the data directory doesn't exist, it should be located here:  $data"};
if (!-d  $tmp)  { die "Sorry the temp directory doesn't exist, it should be located here:  $tmp"};
if (!-d  "./templates/$template") { die "Sorry the templates/template directory doesnt exist, it should be located here:  templates/$template"};

if ($html eq "y"){
        if (!-f $rrdtool) { die "Sorry the rrdtool file doesn't exist, Please install RRDTOOL"};
        if (!-d  $htmldir) { die "Sorry the HTML directory doesn't exist, it should be located here:  $htmldir" };
        if (!-d  "$htmldir/servers" ) {
         mkdir ("$htmldir/servers",755) || die "Sorry the HTML servers directory could not be created:  $htmldir/servers";
        }
        if (!-d  "$data/graphs" ) {
         mkdir ("$data/graphs",755) || die "Sorry the HTML servers directory could not be created:  $data/graphs";
        }
}
############################# Creating qstat command line ###########################


if ($doscan eq "y"){
if ($amar eq "y")                       {       $amarp =~s/ //g;                $amarp =~s/\,/ -aas +$netmaskbc:/g;             $qstatcom = "$qstatcom -aas +$netmaskbc:$amarp";  }
if ($avpII eq "y")                      {       $avpIIp =~s/ //g;               $avpIIp =~s/\,/ -ap2s +$netmaskbc:/g;           $qstatcom = "$qstatcom -ap2s +$netmaskbc:$avpIIp";   }
if ($battlefield eq "y")                {       $battlefieldp =~s/ //g;         $battlefieldp =~s/\,/ -bfs +$netmaskbc:/g;     $qstatcom = "$qstatcom -bfs +$netmaskbc:$battlefieldp";   }
if ($battlefieldl eq "y")               {       $battlefieldlp =~s/ //g;        $battlefieldlp =~s/\,/ -bfl +$netmaskbc:/g;    $qstatcom = "$qstatcom -bfl +$netmaskbc:$battlefieldlp";   }
if ($descentIII eq "y")                 {       $descentIIIp =~s/ //g;          $descentIIIp =~s/\,/ -d3s +$netmaskbc:/g;       $qstatcom = "$qstatcom -d3s +$netmaskbc:$descentIIIp";      }
if ($globalops eq "y")                  {       $globalopsp =~s/ //g;           $globalopsp =~s/\,/ -gos +$netmaskbc:/g;        $qstatcom = "$qstatcom -gos +$netmaskbc:$globalopsp";     }
if ($gore eq "y")                       {       $gorep =~s/ //g;                $gorep =~s/\,/ -gres +$netmaskbc:/g;             $qstatcom = "$qstatcom -gres +$netmaskbc:$gorep";   }
if ($halflife eq "y")                   {       $halflifep =~s/ //g;            $halflifep =~s/\,/ -hls +$netmaskbc:/g;         $qstatcom = "$qstatcom -hls +$netmaskbc:$halflifep";        }
if ($hereticII eq "y" or $sof eq "y")   {       $hereticIIp =~s/ //g;           $hereticIIp =~s/\,/ -hrs +$netmaskbc:/g;$qstatcom = "$qstatcom -hrs +$netmaskbc:$hereticIIp";   }
if ($hexenII eq "y")                    {       $hexenIIp =~s/ //g;             $hexenIIp =~s/\,/ -h2s +$netmaskbc:/g;          $qstatcom = "$qstatcom -h2s +$netmaskbc:$hexenIIp";         }
if ($hexenWorld eq "y")                 {       $hexenWorldp =~s/ //g;          $hexenWorldp =~s/\,/ -hws +$netmaskbc:/g;       $qstatcom = "$qstatcom -hws +$netmaskbc:$hexenWorldp";      }
if ($igi2 eq "y")                       {       $igi2p =~s/ //g;                $igi2p =~s/\,/ -igis +$netmaskbc:/g;             $qstatcom = "$qstatcom -igis +$netmaskbc:$igi2p";    }
if ($jkII eq "y")                       {       $jkIIp =~s/ //g;                $jkIIp =~s/\,/ -j2s +$netmaskbc:/g;             $qstatcom = "$qstatcom -j2s +$netmaskbc:$jkIIp";    }
if ($kingpin eq "y")                    {       $kingpinp =~s/ //g;             $kingpinp =~s/\,/ -kps +$netmaskbc:/g;          $qstatcom = "$qstatcom -kps +$netmaskbc:$kingpinp";         }
if ($mohaa eq "y")                      {       $mohaap =~s/ //g;               $mohaap =~s/\,/ -mhs +$netmaskbc:/g;            $qstatcom = "$qstatcom -mhs +$netmaskbc:$mohaap"; }
if ($nwn eq "y")                        {       $nwnp =~s/ //g;                 $nwnp =~s/\,/ -nws +$netmaskbc:/g;            $qstatcom = "$qstatcom -nws +$netmaskbc:$nwnp";   }
if ($quake eq "y")                      {       $quakep =~s/ //g;               $quakep =~s/\,/ -qs +$netmaskbc:/g;             $qstatcom = "$qstatcom -qs +$netmaskbc:$quakep";    }
if ($quakeII eq "y")                    {       $quakeIIp =~s/ //g;             $quakeIIp =~s/\,/ -q2s +$netmaskbc:/g;          $qstatcom = "$qstatcom -q2s +$netmaskbc:$quakeIIp";         }
if ($quakeIII eq "y")                   {       $quakeIIIp =~s/ //g;            $quakeIIIp =~s/\,/ -q3s +$netmaskbc:/g;         $qstatcom = "$qstatcom -q3s +$netmaskbc:$quakeIIIp";        }
if ($quakeWorld eq "y")                 {       $quakeWorldp =~s/ //g;          $quakeWorldp =~s/\,/ -qws +$netmaskbc:/g;       $qstatcom = "$qstatcom -qws +$netmaskbc:$quakeWorldp";      }
if ($rallymas eq "y")                   {       $rallymasp =~s/ //g;            $rallymasp =~s/\,/ -rms +$netmaskbc:/g;         $qstatcom = "$qstatcom -rms +$netmaskbc:$rallymasp";   }
if ($renegade eq "y")                   {       $renegadep =~s/ //g;            $renegadep =~s/\,/ -rgs +$netmaskbc:/g;         $qstatcom = "$qstatcom -rgs +$netmaskbc:$renegadep";   }
if ($sin eq "y")                        {       $sinp =~s/ //g;                 $sinp =~s/\,/ -sns +$netmaskbc:/g;              $qstatcom = "$qstatcom -sns +$netmaskbc:$sinp";     }
if ($sms eq "y")                        {       $smsp =~s/ //g;                 $smsp =~s/\,/ -sms +$netmaskbc:/g;              $qstatcom = "$qstatcom -sms +$netmaskbc:$smsp";		}
if ($sds eq "y")                        {       $sdsp =~s/ //g;                 $sdsp =~s/\,/ -sds +$netmaskbc:/g;              $qstatcom = "$qstatcom -sds +$netmaskbc:$sdsp";		}
if ($sofII eq "y")                      {       $sofIIp =~s/ //g;               $sofIIp =~s/\,/ -sf2s +$netmaskbc:/g;            $qstatcom = "$qstatcom -sf2s +$netmaskbc:$sofIIp";   }
if ($tribes eq "y")                     {       $tribesp =~s/ //g;              $tribesp =~s/\,/ -tbs +$netmaskbc:/g;           $qstatcom = "$qstatcom -tbs +$netmaskbc:$tribesp";  }
if ($tribesII eq "y")                   {       $tribesIIp =~s/ //g;            $tribesIIp =~s/\,/ -t2s +$netmaskbc:/g;         $qstatcom = "$qstatcom -t2s +$netmaskbc:$tribesIIp";        }
if ($unreal eq "y")                     {       $unrealp =~s/ //g;              $unrealp =~s/\,/ -uns +$netmaskbc:/g;           $qstatcom = "$qstatcom -uns +$netmaskbc:$unrealp";  }
if ($unreal2 eq "y")                    {       $unreal2p =~s/ //g;             $unrealp =~s/\,/ -ut2s +$netmaskbc:/g;           $qstatcom = "$qstatcom -ut2s +$netmaskbc:$unreal2p";  }
if ($v8c eq "y")                        {       $v8cp =~s/ //g;                 $v8cp =~s/\,/ -vcs +$netmaskbc:/g;           $qstatcom = "$qstatcom -vcs +$netmaskbc:$v8cp";  }
if ($vcg eq "y")                        {       $vcgp =~s/ //g;                 $vcgp =~s/\,/ -vcg +$netmaskbc:/g;           $qstatcom = "$qstatcom -vcg +$netmaskbc:$vcgp";  }
}


############################## The Main Search process ##############################
                        


START:

$time = time;
$timehours = $time - 43200;
$timeday = $time - 86400;
$timeweek = $time - 604800;
$timemonth = $time - 2592000;
$timeyear = $time - 31536000;
system(`rm $tmp/*.tmp`);
require "templates/$template/graphs.conf";


################################# Seach everything VERY MESSY #########################

if ($doscan eq "y"){


 	open(QSTAT, "|$qstat -cfg qstat/qstat.cfg -maxsim 60 -timeout 8 -Ts ./templates/qstat $qstatcom $addports >> $tmp/serversannounce.tmp" );
 	close(QSTAT);

	if (-s "$tmp/serversannounce.tmp"){
		open (CAT, "|$cat $tmp/serversannounce.tmp >> $tmp/servers.tmp");
		close(CAT);
 	}
}



#####################################################################################

############################## Output to Server.cfg File ############################

# a little RTCW Fix and unreal fix 


open (FIX, "> $tmp/fix.tmp");
open (QSTATCONFIG,"< $tmp/servers.tmp");
while( $line = <QSTATCONFIG>){
  my @tabledata = split(/[ :]/,$line );
  $defport = $tabledata[2];
  $defport =~ s/\n//;
  if ($tabledata[0] eq "Q3S") {
    open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -q3s $tabledata[1]:$defport|");
    @qstatoutput = <QSTAT>;
    $qstatoutput = $qstatoutput[1];
    if ($qstatoutput =~m/version=Wolf / or $qstatoutput =~m/version=ET /) {
      print FIX "RWS $tabledata[1]:$defport\n";
    } elsif ($qstatoutput =~m/version=ST:V HM/) {
      print FIX "EFS $tabledata[1]:$defport\n";
    } else {
      print FIX "$tabledata[0] $tabledata[1]:$defport\n";
    }
    close(QSTAT);
 } else {
        if ($tabledata[0] ne ""){
      print FIX "$tabledata[0] $tabledata[1]:$defport\n";
        }
    close(QSTAT);

  }
}                                           

close (FIX); 
close (QSTATCONFIG);

if (-s "$staticcfgfile"){
        open (CAT, "|$cat $staticcfgfile >> $tmp/fix.tmp");
        close(CAT);
}





open (COUNTSTAT, "< $tmp/fix.tmp");
@name = <COUNTSTAT>;
close (COUNTSTAT);
open (PROCESS, "> $configfile");
foreach (sort {$a cmp $b} @name) {
  print PROCESS "$_";
}       
close (PROCESS);




#####################################################################################




############################# SERVER QUERY PROCESSING ###############################

system( "$qstat -cfg qstat/qstat.cfg -maxsim 60 -timeout 8 -Ts ./templates/sqdata -of $tmp/sqservers.tmp -f $configfile" );
    
open (PROCESS, "< $tmp/sqservers.tmp");
@name = <PROCESS>;
close (PROCESS);
    
open (PROCESS, "> $tmp/sqservers.tmp");
foreach (sort {$a cmp $b} @name) {
  print PROCESS "$_";
}
close (PROCESS);


if ($serverquery eq "y"){
        open (QSTATCONFIG,"$tmp/sqservers.tmp");
        open (SERVERQUERY, "> $serverqueryfile");

        while( $line = <QSTATCONFIG>){
                my @tabledata = split(/[ :]/,$line );
                $defport = $tabledata[2];
                $defport =~ s/\n//;
                if ($tabledata[0] eq "GPS") {
                        open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -gps $tabledata[1]:$defport|");
                        @qstatoutput = <QSTAT>;
                        $qstatoutput = $qstatoutput[1];

                        if ($qstatoutput =~m/gamename=rune,/) {
                                print SERVERQUERY "RNS $tabledata[1]:$defport\n";
                        } else {
                                print SERVERQUERY "$tabledata[0] $tabledata[1]:$defport\n";
                        }
                        close(QSTAT);

                } elsif ($tabledata[0] eq "RWS") {
                        open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -rws $tabledata[1]:$defport|");
                        @qstatoutput = <QSTAT>;
                        $qstatoutput = $qstatoutput[1];
                                if ($qstatoutput =~m/protocol=17,/) {
                                        print SERVERQUERY "RWD $tabledata[1]:$defport\n";
                                } else {
                                        print SERVERQUERY "RWS $tabledata[1]:$defport\n";
                                }
                        close(QSTAT);

                        
                 } elsif ($tabledata[0] eq "RGS") {
                         open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -rgs $tabledata[1]:$defport|");
                         @qstatoutput = <QSTAT>;
                         $qstatoutput = $qstatoutput[1];

                                if ($qstatoutput =~m/gamever=756,/) {
                                        print SERVERQUERY "RGD $tabledata[1]:$defport\n";
                        } 
                          else {
                                        print SERVERQUERY "RGS $tabledata[1]:$defport\n";
                        }
                        close(QSTAT);

                 } elsif ($tabledata[0] eq "SMS") {
                         open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -sms $tabledata[1]:$defport|");
                         @qstatoutput = <QSTAT>;
                         $qstatoutput = $qstatoutput[1];

                        if ($qstatoutput =~m/gamename=serioussamsed,/) {
                                print SERVERQUERY "S2D $tabledata[1]:$defport\n";
                        }
                        elsif ($qstatoutput =~m/gamename=serioussamse,/) {
                                print SERVERQUERY "S2S $tabledata[1]:$defport\n";
                        } else {
                                print SERVERQUERY "SMS $tabledata[1]:$defport\n";
                        }
                        close(QSTAT);


                 } elsif ($tabledata[0] eq "GOS") {
                         open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -gos $tabledata[1]:$defport|");
                         @qstatoutput = <QSTAT>;
                         $qstatoutput = $qstatoutput[1];

                                if ($qstatoutput =~m/gamename=globalopspb,/) {
                                        print SERVERQUERY "GOD $tabledata[1]:$defport\n";
                        } 
                          else {
                                        print SERVERQUERY "GOS $tabledata[1]:$defport\n";
                        }
                        close(QSTAT);


                 } elsif ($tabledata[0] eq "SF2S") {
                         open (QSTAT, "$qstat -cfg qstat/qstat.cfg -nh -R -sf2s $tabledata[1]:$defport|");
                         @qstatoutput = <QSTAT>;
                         $qstatoutput = $qstatoutput[1];
                                if ($qstatoutput =~m/version=SOF2MP V1.02t/) {
                                        print SERVERQUERY "SF2D $tabledata[1]:$defport\n";
                        }
                          else {
                                        print SERVERQUERY "SF2S $tabledata[1]:$defport\n";
                        } 
                        close(QSTAT);

		 } elsif ($tabledata[0] eq "BDS") {
		        	print SERVERQUERY "BFS $tabledata[1]:$defport\n";


		 } elsif ($tabledata[0] eq "BDL") {
		        	print SERVERQUERY "BFL $tabledata[1]:$defport\n";
                                       
                
                } else {
                        print SERVERQUERY "$tabledata[0] $tabledata[1]:$defport\n";
                }
                close(QSTAT);
                
        }
  close(QSTATFILE);
  close(SERVERQUERY);

}

#####################################################################################



############################### HTML Output #########################################

####### TOTAL FILE #########


if ($html eq "y"){
  open(TOTALOUT, "$qstat -cfg qstat/qstat.cfg -R -sort $htmlgame  -maxsim 60 -timeout 4 -Th ./templates/$template/header.html -Tt ./templates/$template/footer.html -Ts ./templates/$template/data.html -f $configfile 2> /dev/null |");
  while( $totalline = <TOTALOUT> ){
    my @totaldata = split(/ /,$totalline);
     if ($totaldata[0] eq "<!--" and $totaldata[1] eq "gamedetails"){
      $totalplayers=$totaldata[2];
    }
    push(@totalproc,$totalline);
  }
  close (TOTALOUT);

  open (COUNT ,"< $data/maxplayers.dat");
  my @data = split(/,/, <COUNT> );

  open (COUNT ,"> $data/maxplayers.dat");
  if ($totalplayers >= $data[1]) {
        $maxplayers = $totalplayers;
        $peaktime = $time;
        print COUNT "$totalplayers,$totalplayers,$time,";
  } else {
        print COUNT "$totalplayers,$data[1],$data[2],";
        $maxplayers = $data[1];
        $peaktime = $data[2];
  }
  close (COUNT);

  $outputtime = localtime($peaktime);

  foreach $line (@totalproc){
	  $line =~ s/<!--total->/$maxplayers player peak reached on $outputtime/g;
	  $line =~ s/<!--version->/$VERSION/g;
	  $line =~ s/<!-- htmlext -->/$htmlext/g;
	  $line =~ s/<!--htmlext->/$htmlext/g;
	  push(@totalend,$line);
  }

  open ("TOTALOUT","> $htmldir/$htmlfile.$htmlext");
  print TOTALOUT (@totalend);
  close (TOTALOUT);
  undef (@totalproc);
  undef (@totalend);



  $rrdcolor = "-c BACK$rrdback -c CANVAS$rrdcanvas -c GRID$rrdgrid -c SHADEA$rrdshadea -c SHADEB$rrdshadeb -c GRID$rrdgrid -c MGRID$rrdmgrid -c FONT$rrdfont -c FRAME$rrdframe -c ARROW$rrdarrow";
 if (!-e "$data/graphs/total.rrd"){
      	open(RRD, "| $rrdtool create $data/graphs/total.rrd --start $time DS:speed:GAUGE:300:U:U RRA:AVERAGE:0.5:1:288 RRA:AVERAGE:0.5:6:336 RRA:AVERAGE:0.5:24:372 RRA:AVERAGE:0.5:288:351");
      	close(RRD); 
 } else {
	system(" $rrdtool update $data/graphs/total.rrd $time:$totalplayers");
 }
 system(" $rrdtool graph $htmldir/servers/images/totals_day.png --lazy --units-exponent 0 -a PNG  --no-legend --alt-y-mrtg  -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/total.rrd:speed:AVERAGE AREA:players$rrdbar > /dev/null");
 system(" $rrdtool graph $htmldir/servers/images/totals_week.png --lazy --units-exponent 0 --start $timeweek -a PNG --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/total.rrd:speed:AVERAGE AREA:players$rrdbar > /dev/null");
 system(" $rrdtool graph $htmldir/servers/images/totals_month.png --lazy --units-exponent 0 --start $timemonth -a PNG --no-legend --alt-y-mrtg  -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/total.rrd:speed:AVERAGE AREA:players$rrdbar > /dev/null");
 system(" $rrdtool graph $htmldir/servers/images/totals_year.png --lazy --units-exponent 0 --start $timeyear -a PNG --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/total.rrd:speed:AVERAGE AREA:players$rrdbar > /dev/null");


################## Server Proc ################################
      


  open (QSTATCONFIG,"$configfile");
  while( $line = <QSTATCONFIG>){
    my @tabledata = split(/[ :]/,$line );
    $gametype = lc($tabledata[0]);
    $port = $tabledata[2];
    $port =~ s/\n//;
    $port =~ s/\r//;
    $file = "$tabledata[0]$tabledata[1]:$port";
    $graph = "$tabledata[0]$tabledata[1]$port";

      
    open(QSTAT, "$qstat -cfg qstat/qstat.cfg -R -P -sort $htmlplayer -maxsim 60 -timeout 4 -Th ./templates/$template/gameheader.html -Tt ./templates/$template/gamefooter.html -Ts ./templates/$template/gamedata.html -Tp ./templates/$template/gameplayer.html -$gametype $tabledata[1]:$port | "); 
     while($serverline = <QSTAT>){
     my @data = split(/ /,$serverline);
     if ($data[0] eq "<!--" and $data[1] eq "gamedetails"){
         $map = $data[4];
       	 $players=$data[2];
     }

     if ($data[0] eq "<!--" and $data[1] eq "image"){
        if (-f "$htmldir/images/$gametype/$map.jpg"){
         $serverline =~ s/<!-- image -->/<IMG SRC=\"$htmlalias\/images\/$gametype\/$map.jpg\" ALT=\"$map\" Border=0 Height=180 Width=240>/;
         $serverline =~ s/<!--image->/<IMG SRC=\"$htmlalias\/images\/$gametype\/$map.jpg\" ALT=\"$map\" Border=0 Height=180 Width=240>/;
        } else {
         $serverline =~ s/<!-- image -->/<IMG SRC=\"$htmlalias\/images\/default.gif\" ALT=\"$map\" Border=0 Height=180 Width=240>/;
         $serverline =~ s/<!--image->/<IMG SRC=\"$htmlalias\/images\/default.gif\" ALT=\"$map\" Border=0 Height=180 Width=240>/;
        }
    }
    	push(@proc,$serverline);
    }
    close (QSTAT);     

    open ("OUT","> $htmldir/servers/$file.$htmlext");
    print OUT (@proc);
    close (OUT);
    undef (@proc);

      if (!-e "$data/graphs/$graph.rrd"){
        open(RRD, "| $rrdtool create $data/graphs/$graph.rrd --start $time DS:speed:GAUGE:300:U:U RRA:AVERAGE:0.5:1:288 RRA:AVERAGE:0.5:6:336 RRA:AVERAGE:0.5:24:372 RRA:AVERAGE:0.5:288:351");
        close(RRD); 
      } else {
      	system(" $rrdtool update $data/graphs/$graph.rrd $time:$players 2>/dev/null");
      }

      system(" $rrdtool graph $htmldir/servers/images/$file\_day.png  --lazy -a PNG --units-exponent 0 --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/$graph.rrd:speed:AVERAGE AREA:players$rrdbar >> /dev/null");
      system(" $rrdtool graph $htmldir/servers/images/$file\_week.png --lazy -a PNG --units-exponent 0 --start $timeweek --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/$graph.rrd:speed:AVERAGE AREA:players$rrdbar >> /dev/null");
      system(" $rrdtool graph $htmldir/servers/images/$file\_month.png --lazy -a PNG --units-exponent 0 --start $timemonth --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/$graph.rrd:speed:AVERAGE AREA:players$rrdbar >> /dev/null");
      system(" $rrdtool graph $htmldir/servers/images/$file\_year.png --lazy -a PNG --units-exponent 0 --start $timeyear --no-legend --alt-y-mrtg -w 225 -h 65 $rrdcolor --vertical-label Players DEF:players=$data/graphs/$graph.rrd:speed:AVERAGE AREA:players$rrdbar >> /dev/null");



  }
  close(QSTATCONFIG);


}

#####################################################################################


if ($runmode eq "loop"){
       sleep $refresh;
       goto START;
  }


