/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.Apriori;
import weka.associations.Associator;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleAssociatorEnhancer
extends AbstractAssociator
implements OptionHandler {
    private static final long serialVersionUID = -3665885256363525164L;
    protected Associator m_Associator = new Apriori();

    protected String defaultAssociatorString() {
        return Apriori.class.getName();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull name of base associator.\n\t(default: " + this.defaultAssociatorString() + ")", "W", 1, "-W"));
        result.addAll(Collections.list(super.listOptions()));
        if (this.m_Associator instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to associator " + this.m_Associator.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_Associator)).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            this.setAssociator(AbstractAssociator.forName(tmpStr, null));
            this.setAssociator(AbstractAssociator.forName(tmpStr, Utils.partitionOptions(options)));
        } else {
            this.setAssociator(AbstractAssociator.forName(this.defaultAssociatorString(), null));
            this.setAssociator(AbstractAssociator.forName(this.defaultAssociatorString(), Utils.partitionOptions(options)));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add(this.getAssociator().getClass().getName());
        Collections.addAll(result, super.getOptions());
        if (this.getAssociator() instanceof OptionHandler) {
            String[] options = ((OptionHandler)((Object)this.getAssociator())).getOptions();
            result.add("--");
            for (int i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String associatorTipText() {
        return "The base associator to be used.";
    }

    public void setAssociator(Associator value) {
        this.m_Associator = value;
    }

    public Associator getAssociator() {
        return this.m_Associator;
    }

    protected String getAssociatorSpec() {
        Associator c = this.getAssociator();
        return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getAssociator() != null ? this.getAssociator().getCapabilities() : new Capabilities(this);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        result.setOwner(this);
        return result;
    }
}

