/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import java.util.HashMap;
import java.util.Map;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Macro;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;

public class MathFunctions
implements MacroDeclarations {
    private static Map<String, Macro> macros = new HashMap<String, Macro>();

    @Override
    public boolean hasMacro(String name) {
        return macros.containsKey(name);
    }

    @Override
    public Macro getMacro(String name) {
        if (macros.containsKey(name)) {
            return macros.get(name);
        }
        throw new RuntimeException("Macro '" + name + "' undefined!");
    }

    static {
        macros.put("abs", new DoubleUnaryMacro(AbsFunction.class));
        macros.put("sqrt", new DoubleUnaryMacro(SqrtFunction.class));
        macros.put("log", new DoubleUnaryMacro(LogFunction.class));
        macros.put("exp", new DoubleUnaryMacro(ExpFunction.class));
        macros.put("sin", new DoubleUnaryMacro(SinFunction.class));
        macros.put("cos", new DoubleUnaryMacro(CosFunction.class));
        macros.put("tan", new DoubleUnaryMacro(TanFunction.class));
        macros.put("rint", new DoubleUnaryMacro(RintFunction.class));
        macros.put("floor", new DoubleUnaryMacro(FloorFunction.class));
        macros.put("ceil", new DoubleUnaryMacro(CeilFunction.class));
        macros.put("pow", new PowMacro());
    }

    private static class DoubleUnaryMacro
    implements Macro {
        private final Class<? extends DoubleUnaryFunction> func;

        public DoubleUnaryMacro(Class<? extends DoubleUnaryFunction> func) {
            this.func = func;
        }

        private String name() {
            return this.func.getSimpleName();
        }

        @Override
        public Node evaluate(Node ... params) throws SemanticException {
            if (params.length != 1) {
                throw new SemanticException("'" + this.name() + "' takes exactly one argument!");
            }
            if (!(params[0] instanceof Primitives.DoubleExpression)) {
                throw new SemanticException("'" + this.name() + "'s first argument must be double!");
            }
            try {
                Node node = this.func.getConstructor(Primitives.DoubleExpression.class).newInstance(params[0]);
                return node;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate '" + this.name() + "'!", e);
            }
        }
    }

    private static class AbsFunction
    extends DoubleUnaryFunction {
        public AbsFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.abs(this.expr.evaluate());
        }
    }

    private static class SqrtFunction
    extends DoubleUnaryFunction {
        public SqrtFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.sqrt(this.expr.evaluate());
        }
    }

    private static class LogFunction
    extends DoubleUnaryFunction {
        public LogFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.log(this.expr.evaluate());
        }
    }

    private static class ExpFunction
    extends DoubleUnaryFunction {
        public ExpFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.exp(this.expr.evaluate());
        }
    }

    private static class SinFunction
    extends DoubleUnaryFunction {
        public SinFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.sin(this.expr.evaluate());
        }
    }

    private static class CosFunction
    extends DoubleUnaryFunction {
        public CosFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.cos(this.expr.evaluate());
        }
    }

    private static class TanFunction
    extends DoubleUnaryFunction {
        public TanFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.tan(this.expr.evaluate());
        }
    }

    private static class RintFunction
    extends DoubleUnaryFunction {
        public RintFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.rint(this.expr.evaluate());
        }
    }

    private static class FloorFunction
    extends DoubleUnaryFunction {
        public FloorFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.floor(this.expr.evaluate());
        }
    }

    private static class CeilFunction
    extends DoubleUnaryFunction {
        public CeilFunction(Primitives.DoubleExpression expr) {
            super(expr);
        }

        @Override
        public double evaluate() {
            return Math.ceil(this.expr.evaluate());
        }
    }

    private static class PowMacro
    implements Macro {
        private PowMacro() {
        }

        @Override
        public Node evaluate(Node ... params) throws SemanticException {
            if (params.length != 2) {
                throw new SemanticException("pow takes exactly two arguments!");
            }
            if (!(params[0] instanceof Primitives.DoubleExpression)) {
                throw new SemanticException("pow's first argument must be double!");
            }
            if (!(params[1] instanceof Primitives.DoubleExpression)) {
                throw new SemanticException("pow's second argument must be double!");
            }
            return new PowFunction((Primitives.DoubleExpression)params[0], (Primitives.DoubleExpression)params[1]);
        }
    }

    private static class PowFunction
    implements Primitives.DoubleExpression {
        private final Primitives.DoubleExpression base;
        private final Primitives.DoubleExpression exponent;

        public PowFunction(Primitives.DoubleExpression base, Primitives.DoubleExpression exponent) {
            this.base = base;
            this.exponent = exponent;
        }

        @Override
        public double evaluate() {
            return Math.pow(this.base.evaluate(), this.exponent.evaluate());
        }
    }

    private static abstract class DoubleUnaryFunction
    implements Primitives.DoubleExpression {
        final Primitives.DoubleExpression expr;

        DoubleUnaryFunction(Primitives.DoubleExpression expr) {
            this.expr = expr;
        }
    }
}

