package testpkg

import "fmt"

func fn() {
	a := 1
	b := 2
	c := 3
	a = 4
	b = 3

	_, _, _ = a, b, c
}

func fn2() {
	a := 1
	b := 2
	fmt.Println("") // want `missing whitespace above this line \(no shared variables above expr\)`
	c := 3          // want `missing whitespace above this line \(invalid statement above assign\)`
	d := 4

	_, _, _, _ = a, b, c, d
}

func fn3() {
	a := 1
	b := 2
	fmt.Println(b)
	c := 3 // want `missing whitespace above this line \(invalid statement above assign\)`
	d := 4

	_, _, _, _ = a, b, c, d
}

func fn4(ch chan struct{}) {
	b := 2
	<-ch // want `missing whitespace above this line \(no shared variables above expr\)`

	_, _ = b, ch
}

func fn5() {
	s := []string{
		func() string { // want +1 `unnecessary whitespace \(leading-whitespace\)`

			return "a"
		}(),
		"b",
	}

	_ = s
}

func Up(_ bool)  {}
func Down(_ int) {}

func issue153(autoheight int, b bool) {
	for i := 0; i < 4; i++ {
		fmt.Println()
	}
	Up(true) // want `missing whitespace above this line \(invalid statement above expr\)`

	if autoheight != 3 {
		fmt.Printf("height should be 3 but is %d", autoheight)
	}
	Down(3) // want `missing whitespace above this line \(invalid statement above expr\)`

	if b {
		fmt.Println()
	}
	Up(b) // want `missing whitespace above this line \(invalid statement above expr\)`
}
