/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef HEIGHTMAP_H
#define HEIGHTMAP_H

#define DEFAULT_HEIGHT 5

typedef struct heightmap_s heightmap_t;

int heightmap_init(int sizex, int sizey, heightmap_t **map);

int heightmap_getsize_x(heightmap_t *map);
int heightmap_getsize_y(heightmap_t *map);


typedef struct heightsquare_dirs_s {
    int topleft;
    int topright;
    int botright;
    int botleft;
} heightsquare_dirs_t;

typedef union heightsquare_s {
    
    heightsquare_dirs_t dir;
    int index[4];

} heightsquare_t;

int heightmap_getheight(heightmap_t *map, int x, int y, int dirview, 
			heightsquare_t *square);
int heightmap_get(heightmap_t *map, int x, int y);

/* NOTE: x and y are the intersetion point here */
int heightmap_raise(heightmap_t *map, int x, int y);
int heightmap_lower(heightmap_t *map, int x, int y);
int heightmap_setheight(heightmap_t *map, int x, int y, int isinit, int height);
int heightmap_can_changeheight(heightmap_t *map, int x, int y, int change);

int heightmap_islevel(heightsquare_t *square);
int heightmap_islevel_spot(heightmap_t *map, int x, int y);

#endif /* HEIGHTMAP_H */
