/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PLAYER_H
#define PLAYER_H

typedef struct player_s player_t;

#define MAX_NUM_PLAYERS 5

typedef enum {
    INCOME_INTEREST,
    INCOME_RENT,
    INCOME_REVENUE,
    INCOME_LAND,
    INCOME_TAX,
    BORROW,
    

    COST_LAND,
    COST_BUILD,
    COST_UPKEEP,
    COST_SALARY,
    COST_DEBT,

    /* add new ones above this line */
    INCOME_NUMTYPES
} income_types;

struct balance_item {
    int type;
    char *string;
    int is_one_time;
};

extern struct balance_item balance_sheet_items[];


typedef enum {
    RANGE_CURRENT_MONTH,
    RANGE_LAST_MONTH,
    RANGE_CURRENT_YEAR,
    RANGE_LAST_YEAR,
    RANGE_ALLTIME,

    /* add new ones above this line */
    RANGE_NUMRANGES
} income_range_t;

int player_new(char *name, player_t **player);

void player_delete(player_t *player);

int player_getnum(player_t *player);

void player_setnumber(player_t *player, int number);

int player_isactive(int number);

player_t *player_get(int number);

void player_setmoney(player_t *player, int number);

int player_getmoney(player_t *player);

int player_canafford(player_t *player, int amount);

void player_reducemoney(player_t *player, income_types type, float amount);
void player_reducemoney_num(int playernum, income_types type, float amount);

void player_addmoney(player_t *player, income_types type, float amount);
void player_addmoney_num(int playernum, income_types type, float amount);

int player_setopennumber(player_t *player);

int player_getincometype(player_t *player, income_range_t range, income_types type);

void players_clearout_month(void);
void players_clearout_year(void);

void player_addloan(player_t *player, int amount, int term, float rate);
int player_total_borrowed(player_t *);

void player_servicedebt(player_t *);

int is_one_time(char *str);

typedef void player_loan_iterate_callback(player_t *player, int num, int amount,
					  int term, int payments_made, float rate,
					  void *rock);

void player_loans_enumerate(player_t *player, player_loan_iterate_callback *cb, void *rock);

extern int player_payoff_loan(player_t *player, int num);

char *player_getname(int num);

int player_lastmonth_profit(player_t *player);

#endif /* PLAYER_H */
