/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <locale.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

GtkWidget *window1;

char *server = NULL;
char *username = NULL;
char *game = NULL;
char *locale = NULL;
int debug = 0;

/*struct poptOption options[] = {
  {
    "server",
    's',
    POPT_ARG_STRING,
    &server,
    0,
    N_("Server"),
    N_("SERVER")
  },
  {
    "username",
    'u',
    POPT_ARG_STRING,
    &username,
    0,
    N_("Username"),
    N_("USERNAME")
  },
  {
    "game",
    'g',
    POPT_ARG_STRING,
    &game,
    0,
    N_("Game"),
    N_("GAME")
  },
  {
    "debug",
    'd',
    POPT_ARG_NONE,
    &debug,
    0,
    N_("Debug"),
    N_("DEBUG")
  },
  {
    "locale",
    'l',
    POPT_ARG_STRING,
    &locale,
    0,
    N_("Locale"),
    N_("LOCALE")
  },
  {
    NULL,
    '\0',
    0,
    NULL,
    0,
    NULL,
    NULL
  }
};
*/


int
main (int argc, char *argv[])
{
    char c;
    int startserver = 0;

    setlocale (LC_CTYPE, "");
    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE_NAME, LOCALEDIR);
    textdomain (PACKAGE_NAME);

    /*gnome_init_with_popt_table("senken", "1", argc, argv, options, 0, NULL); FRED FIX*/
    gtk_init( &argc, &argv ); /* FRED FIX */

    while ((c = getopt(argc, argv, "ls:u:g:d")) != -1)
	switch (c) {
        case 'l':
	    server = "localhost";
	    username = "local";
	    startserver = 1;
	    break;
        case 's':
	    server = strdup(optarg);
	    break;
        case 'u':
	    username = strdup(optarg);
	    break;
        case 'g':
	    game = strdup(optarg);
	    break;
        case 'd':
	    debug = 1;
	    break;	
    }

    /*
     * The following code was added by Glade to create one of each component
     * (except popup menus), just so that you see something after building
     * the project. Delete any components that you don't want shown initially.
     */
    window1 = create_window1 ();
    gtk_widget_show (window1);

    /*
     * Get rid of bogus signal handlers gtk sets up
     */
    signal(SIGHUP, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGBUS, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    signal(SIGPIPE, SIG_DFL);
    signal(SIGTERM, SIG_DFL);
    
    if (locale) {
	char *loc;
	setlocale(LC_CTYPE, locale);
	loc = setlocale(LC_MESSAGES, locale);
	if (!loc) {
	    printf("Error changing locale to %s\n", locale);
	}
    }
    
    /*
     * Show new game window
     */
    if (server) {
	if (startserver) {
	    start_local_server();
	    sleep(1);
	}
	server_connect(username, server);
	
	if (game) {
	    select_game(game);
	} else {
	    show_select_game();
	}
	
    } else {
	on_new1_activate(NULL, NULL);
    }
    
    gtk_main ();
    return 0;
}

