/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class CircleEnd
implements UDrawable {
    private static final int SIZE = 22;
    private final ISkinParam skinParam;
    private final Style style;
    private final Colors colors;

    public CircleEnd(ISkinParam skinParam, Style style, Colors colors) {
        this.style = style;
        this.colors = colors;
        this.skinParam = skinParam;
    }

    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = UEllipse.build(22.0, 22.0);
        HColor backColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (this.colors.getColor(ColorType.BACK) != null) {
            lineColor = this.colors.getColor(ColorType.BACK);
            backColor = this.colors.getColor(ColorType.BACK);
        }
        double shadowing = this.style.getShadowing();
        circle.setDeltaShadow(shadowing);
        ug.apply(HColors.none().bg()).apply(lineColor).draw(circle);
        double delta = 5.0;
        UEllipse circleSmall = UEllipse.build(12.0, 12.0);
        if (lineColor.equals(backColor)) {
            HColor middle = HColors.middle(lineColor, backColor);
            ug = ug.apply(backColor.bg());
            ug = ug.apply(middle);
        } else {
            ug = ug.apply(backColor.bg());
            ug = ug.apply(lineColor);
        }
        ug.apply(new UTranslate(5.0, 5.0)).draw(circleSmall);
    }
}

