# 7.0 Changelog

## [7.0.13] - 2022-10-20

### Engine Updates and Fixes

- Stop sending telemetry about `ApplicationType` (#18265)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 3.1.424 (#18272)</p>

</summary>

<ul>
<li>Update Wix file for new assemblies (Internal 22873)</li>
<li>Update the <code>cgmanifest.json</code> for <code>v7.0.13</code> (#18318)</li>
<li>Update <code>Newtonsoft.Json</code> version for 7.0.13 release (#18259)</li>
<li>Fix <code>build.psm1</code> to not specify both version and quality for <code>dotnet-install</code> (#18267)</li>
<li>Update list of PowerShell team members in release tools(#18266)</li>
<li>Move <code>cgmanifest</code> generation to daily (#18268)</li>
<li>Disable static analysis CI on 7.0 (#18269)</li>
</ul>

</details>

[7.0.13]: https://github.com/PowerShell/PowerShell/compare/v7.0.12...v7.0.13


## [7.0.12] - 2022-08-11

### General Cmdlet Updates and Fixes

- Fix `Export-PSSession` to not throw error when a rooted path is specified for `-OutputModule` (#17671)

### Tests

- Enable more tests to be run in a container. (#17294)
- Switch to using GitHub action to verify markdown links for PRs (#17281)
- Add `win-x86` test package to the build (#15517)

### Build and Packaging Improvements

<details>

<summary>
<p>Bump .NET 3.1 SDK to <code>3.1.28</code></p>
</summary>

<ul>
<li>Update wix file</li>
<li>Add a finalize template which causes jobs with issues to fail (#17314)</li>
<li>Make sure we execute tests on LTS package for older LTS releases (#17326)</li>
<li>Update <code>AzureFileCopy</code> task and fix the syntax for specifying <code>pool</code> (#17013)</li>
</ul>

</details>

[7.0.12]: https://github.com/PowerShell/PowerShell/compare/v7.0.11...v7.0.12

## [7.0.11] - 2022-05-13

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET SDK to 3.1.419</p>

</summary>

<ul>
<li>Add explicit job name for approval tasks in Snap stage (#16579)</li>
<li>Update to use <code>mcr.microsoft.com</code> (#17272)</li>
<li>Update <code>global.json</code> and wix</li>
<li>Put Secure supply chain analysis at correct place (#17273)</li>
<li>Partial back-port of: Update a few tests to make them more stable in CI (#16944) (Internal 20648)</li>
<li>Replace <code>.</code> in notices container name (#17292)</li>
<li>Add an approval for releasing build-info json (#16351)</li>
<li>Release build info json when it is preview (#16335)</li>
<li>Add a major-minor build info JSON file (#16301)</li>
<li>Update release instructions with link to new build (#17256)</li>
<li>Add condition to generate release file in local dev build only (#17255)</li>
<li>Removed old not-used-anymore docker-based tests for PS release packages (#16224)</li>
<li>Publish global tool package for stable releases (#15961)</li>
<li>Update to use <code>windows-latest</code> as the build agent image (#16831)</li>
<li>Don't upload <code>dep</code> or <code>tar.gz</code> for <code>RPM</code> build because there are none. (#17224)</li>
<li>Update to <code>vPack</code> task version 12 (#17225)</li>
<li>Make RPM license recognized (#17223)</li>
<li>Ensure <code>psoptions.json</code> and <code>manifest.spdx.json</code> files always exist in packages (#17226)</li>
</ul>

</details>

[7.0.11]: https://github.com/PowerShell/PowerShell/compare/v7.0.10...v7.0.11

## [7.0.10] - 2022-04-26

### Engine Updates and Fixes

- Fix for partial PowerShell module search paths, that can be resolved to CWD locations
- Do not include node names when sending telemetry. (#16981) to v7.0.10 (Internal 20186,Internal 20261)

### Tests

- Re-enable `PowerShellGet` tests targeting PowerShell gallery (#17062)
- Skip failing scriptblock tests (#17093)

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET SDK to 3.1.418</p>

</summary>

<ul>
<li>Fixed package names verification to support multi-digit versions (Internal 20363)</li>
<li>Fix build failure in `generate checksum file for packages` step - v7.0.10 (Internal 20275)</li>
<li>Updated files.wxs for 7.0.10 (Internal 20208)</li>
<li>Updated to .NET 3.1.24 / SDK 3.1.418 (Internal 20133)</li>
<li>Disable broken macOS CI job, which is unused (Internal 20189)</li>
<li>Update Ubuntu images to use Ubuntu 20.04 (#15906)</li>
<li>Update dotnet-install script download link (Internal 19949)</li>
<li>Create checksum file for global tools (Internal 19934)</li>
<li>Make sure global tool packages are published in stable build (Internal 19623)</li>
</ul>

</details>

[7.0.10]: https://github.com/PowerShell/PowerShell/compare/v7.0.9...v7.0.10

## [7.0.9] - 2022-03-16

### Build and Packaging Improvements

<details>

<summary>

<p>Update .NET SDK to 3.1.417</p>

</summary>

<ul>
<li>Fix the NuGet SDK package creation (Internal 19569)</li>
<li>Fix NuGet package compliance issues (#13045)</li>
<li>Fix issues in release build (#16332)</li>
<li>Enable ARM64 packaging for macOS (#15768)</li>
<li>Update feed and analyzer dependency (#16327)</li>
<li>Only upload stable <code>buildinfo</code> for stable releases (#16251)</li>
<li>Opt-in to build security monitoring (#16911)</li>
<li>Update experimental feature json files (#16838) (Thanks @!)</li>
<li>Ensure alpine and arm SKUs have the PowerShell configuration file with experimental features enabled (#16823)</li>
<li>Remove WiX install (#16834)</li>
<li>Add Linux package dependencies for packaging (#16807)</li>
<li>Switch to our custom images for build and release (#16801)</li>
<li>Remove all references to <code>cmake</code> for the builds in this repo (#16578)</li>
<li>Register NuGet source when generating <code>CGManifest</code> (#16570)</li>
<li>Update Images used for release (#16580)</li>
<li>Add Software Bill of Materials to the main packages (#16202, #16641, #16711)</li>
<li>Add GitHub Workflow to keep notices up to date (#16284)</li>
<li>Update the <code>vmImage</code> and PowerShell root directory for macOS builds (#16611)</li>
<li>Update macOS build image and root folder for build (#16609)</li>
<li>Add checkout to build json stage to get <code>ci.psm1</code> (#16399)</li>
<li>Move mapping file into product repo and add Debian 11  (#16316)</li>
</ul>

</details>

[7.0.9]: https://github.com/PowerShell/PowerShell/compare/v7.0.8...v7.0.9

## [7.0.8] - 2021-10-14

### Engine Updates and Fixes

- Handle error from unauthorized access when removing `AppLocker` test files (#15881)
- Handle error when the telemetry mutex cannot be created (#15574) (Thanks @gukoff!)
- Configure `ApplicationInsights` to not send cloud role name (Internal 17099)
- Disallow `Add-Type` in NoLanguage mode on a locked down machine (Internal 17521)

### Tools

- Add `.stylecop` to `filetypexml` and format it (#16025)

### Build and Packaging Improvements

<details>

<summary>
<p>Bump .NET SDK to 3.1.414</p>
</summary>

<ul>
<li>Update the nuget.config file used for building NuGet packages (Internal 17547)</li>
<li>Sign the .NET <code>createdump</code> executable (#16229)</li>
<li>Upgrade <code>set-value</code> package for markdown test (#16196)</li>
<li>Move vPack build to 1ES Pool (#16169)</li>
<li>Update to .NET SDK 3.1.414 (Internal 17532)</li>
<li>Fix the macOS build by updating the pool image name (#16010)</li>
<li>Move from PkgES hosted agents to 1ES hosted agents (#16023)</li>
<li>Use Alpine 3.12 for building PowerShell for Alpine Linux (#16008)</li>
</ul>

</details>

### Documentation and Help Content

- Fix example nuget.config (#14349)

[7.0.8]: https://github.com/PowerShell/PowerShell/compare/v7.0.7...v7.0.8

## [7.0.7] - 2021-08-12

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to 3.1.412
</summary>

<ul>
<li>Remove cat file from <code>PSDesiredStateConfiguration</code> module (Internal 16722)</li>
<li>Update .NET SDK to <code>3.1.412</code> (Internal 16717)</li>
</ul>

</details>

[7.0.7]: https://github.com/PowerShell/PowerShell/compare/v7.0.6...v7.0.7

## [7.0.6] - 2021-03-11

### General Cmdlet Updates and Fixes

- Fix web cmdlets to properly construct URI from body when using `-NoProxy` (#14673)
- Fix `PromptForCredential()` to add `targetName` as domain (#14504)
- Clean up the IPC named pipe on PowerShell exit (#12187)

### Tests

- Update markdown test packages with security fixes (#13730, #14145, #14454)

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to version <code>3.1.407</code>
</summary>

<ul>
<li>Bump .NET to version 3.1.407 (Internal 14783)</li>
<li>Fix the miscellaneous analysis CI build (#14971, #14974, #14975)</li>
<li>Declare which variable group is used for checking the blob in the release build (#14970)</li>
<li>Use template that disables component governance for CI (#14938)</li>
<li>Suppress the warning for having multiple nuget feeds (#14893)</li>
<li>Disable codesign validation where the file type is not supported (#14885)</li>
<li>Make universal Deb package based on deb package spec (#14681)</li>
<li>Add manual release automation steps and improve changelog script (#14445)</li>
<li>Fix a typo in the <code>Get-ChangeLog</code> function (#14129)</li>
<li>Add validation and dependencies for <code>Ubuntu 20.04</code> distribution to packaging script (#13993)</li>
<li>Add comment in release-BuildJson.yml for date formatting</li>
<li>Install wget on centos-7 docker image</li>
<li>Fix install-dotnet download (#14856)</li>
<li>Fix release build to upload global tool packages to artifacts (#14620)</li>
<li>Fixes to release pipeline for GA release (#14034)</li>
<li>Add checkout step to release build templates (#13840)</li>
<li>Add flag to make Linux script publish to production repo (#13714)</li>
<li>Use new release script for Linux packages (#13705)</li>
<li>Change stage dependency for docker release stage in release pipeline (#13512)</li>
<li>Create the folder before copying the global tools (#13476)</li>
<li>A few fixes to the release pipeline (#13473)</li>
<li>Change the variable group name (Internal 12339)</li>
<li>Create release pipeline as a yaml pipeline (#13394)</li>
</ul>

</details>

[7.0.6]: https://github.com/PowerShell/PowerShell/compare/v7.0.5...v7.0.6

## [7.0.5] - 2021-02-11

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to version <code>3.1.406</code>
</summary>

<ul>
<li>Fix third party signing for files in sub-folders (#14751)</li>
<li>Bump .NET SDK to 3.1.12 (Internal 14462)</li>
</ul>

</details>

[7.0.5]: https://github.com/PowerShell/PowerShell/compare/v7.0.4...v7.0.5

## [7.0.4] - 2021-01-19

### Build and Packaging Improvements

<details>

<summary>
Bump .NET SDK to version <code>3.1.405</code>
</summary>

<ul>
<li>Remove MyGet feeds from test nuget.config (Internal 14147)</li>
<li>Update WXS file for 7.0.4 (Internal 14122)</li>
<li>Update .NET dependencies for 7.0.4 (Internal 14104)</li>
<li>Fix 7.0.4 `Get-Module` test failure (Internal 13946)</li>
<li>Fix directory creation failure (Internal 13904)</li>
<li>Disable WMF link invocation test (#13479)</li>
<li>Use PowerShell Core for build and test of package in CI build (#13223)</li>
<li>Disable libmi dependent tests for macOS. (#14446)</li>
<li>Use one feed in each nuget.config in official builds (#14363)</li>
<li>Fix path signed RPMs are uploaded from in release build (#14424)</li>
<li>Fix syntax error in Windows packaging script (#14377)</li>
<li>Make AppLocker Enforce mode take precedence over UMCI Audit mode (#14353)</li>
<li>Fix issue with unsigned build (#14367)</li>
<li>Move macOS and NuGet to ESRP signing (#14324)</li>
<li>Move Windows package signing to use ESRP (#14060)</li>
<li>Move Linux to ESRP signing (#14210)</li>
<li>Migrate 3rd party signing to ESRP (#14010)</li>
<li>Don't do a shallow checkout (#13992)</li>
<li>Move to ESRP signing for Windows files (#13988)</li>
<li>Fix breaks in packages daily build due to macOS signing changes (#13421)</li>
<li>Sign individual files in package (#13392)</li>
<li>Use Authenticode certificate for MSIX signing (#13330)</li>
<li>Sign the MSIX files for the store (#12582)</li>
<li>Use temporary personal path at runspace startup when <code>$env:HOME</code> not defined (#13239)</li>
<li>Fix MSIX packaging to determine if a preview release by inspecting the semantic version string (#11991)</li>
<li>Add default help content to the assets folder (#13257)</li>
</ul>

</details>

[7.0.4]: https://github.com/PowerShell/PowerShell/compare/v7.0.3...v7.0.4

## [7.0.3] - 2020-07-16

### Tests

- Remove dependency on DNS for `Test-Connection` tests on macOS (#12943)

### Build and Packaging Improvements

<details>

<ul>
<li>Fix Azure file copy issues in release build by fixing the path to upload directory content (#13182)</li>
<li>Update .NET Core to 3.1.6 (Internal 12005)</li>
<li>Fix Azure file copy break in AzDevOps by updating task version to latest (#13173)</li>
</ul>

</details>

[7.0.3]: https://github.com/PowerShell/PowerShell/compare/v7.0.2...v7.0.3

## [7.0.2] - 2020-06-11

### Engine Updates and Fixes

- Ensure null-coalescing LHS is evaluated only once (#12667)
- Restrict loading of `amsi.dll` to `system32` folder (#12730)

### General Cmdlet Updates and Fixes

- Change `Get-FileHash` to close file handles before writing output (#12474) (Thanks @iSazonov!)

### Tools

- Update the PowerShell team list to correct changelog generation (#12927)

### Tests

- Pin major Pester version to 4 to prevent breaking changes caused by upcoming release of `v5` (#12262) (Thanks @bergmeister!)

### Build and Packaging Improvements

<details>

<summary>

<p>Update to .NET Core 3.1.5</p>

</summary>

<ul>
<li>Bump to .NET 3.1.5 and update dependencies (Internal 11699)</li>
<li>Check if Azure Blob exists before overwriting (#12921)</li>
<li>Upgrade <code>APIScan</code> version (#12876)</li>
<li>Fix break in package build by pinning <code>ffi</code> version to <code>1.12</code> (#12889)</li>
<li>Update the build to sign any unsigned files as 3rd party Dlls (#12581)</li>
</ul>

</details>

## [7.0.1] - 2020-05-14

### Engine Updates and Fixes

- Discover assemblies loaded by `Assembly.Load(byte[])` and `Assembly.LoadFile` (#12203)
- Allow case insensitive paths for determining `PSModulePath` (#12192)

### General Cmdlet Updates and Fixes

- Add `null` check for Windows PowerShell install path (#12296)
- Fix Null Reference error in CSV commands (#12281) (Thanks @iSazonov!)
- Fix `WinCompat` module loading to treat Core edition modules higher priority (#12269)
- Fix `<img />` detection regex in web cmdlets (#12099) (Thanks @vexx32!)
- Miscellaneous minor updates to `WinCompat` (#11980)
- Fix `ConciseView` where error message is wider than window width and doesn't have whitespace (#11880, #11746)
- Make `Test-Connection` always use the default synchronization context for sending ping requests (#11517)

### Tests

- Fix CIM tab complete test failure (#12636)

### Build and Packaging Improvements

<details>

<summary>
Move to .NET Core 3.1.202 SDK and update packages.
</summary>

<ul>
<li>Use dotnet core 3.1.202 (Internal 11551)</li>
<li>Bump PowerShellGet from 2.2.3 to 2.2.4 (#12342)</li>
<li>Move to standard internal pool for building (#12119)</li>
<li>Bump <code>NJsonSchema</code> from <code>10.1.5</code> to <code>10.1.7</code> (#12050)</li>
</ul>

</details>

### Documentation and Help Content

- Remove the version number of PowerShell from `LICENSE` (#12019)

## [7.0.0] - 2020-03-04

### General Cmdlet Updates and Fixes

- Enable `Ctrl+C` to work for global tool (#11959)
- Fix `ConciseView` to not show the line information within the error messages (#11952)

### Build and Packaging Improvements

- Publish PowerShell into the Windows engineering system package format (#11960)
- Bump .NET core framework to `3.1.2` (#11963)
- Ensure the man page `gzip` has the correct name for LTS release (#11956)
- Bump `Microsoft.ApplicationInsights` from `2.13.0` to `2.13.1` (#11925)

## [7.0.0-rc.3] - 2020-02-21

### Breaking Changes

- Fix `Invoke-Command` missing error on session termination (#11586)

### Engine Updates and Fixes

- Update the map between console color to `VT` sequences (#11891)
- Fix SSH remoting error on Windows platform (#11907)
- Restore the `PowerShellStreamType` `enum` with an `ObsoleteAttribute` (#11836)
- Handle cases where `CustomEvent` was not initially sent (#11807)
- Fix how COM objects are enumerated (#11795)
- Fix `NativeDllHandler` to not throw when file is not found (#11787)
- Restore `SetBreakpoints` API (#11622)
- Do not needlessly pass `-l login_name` or `-p port` to `ssh` (#11518) (Thanks @LucaFilipozzi!)
- Fix for `JEA` user role in virtual account (#11668)
- Do not resolve types from assemblies that are loaded in separate `AssemblyLoadContext` (#11088)

### General Cmdlet Updates and Fixes

- Sync current directory in `WinCompat` remote session (#11809)
- Add `WinCompat` deny list support using a setting in `powershell.config.json` (#11726)
- Fix unnecessary trimming of line resulting in incorrect index with `ConciseView` (#11670)

### Code Cleanup

- Change name of `ClrVersion` parameter back to revert change in capitalization (#11623)

### Tools

- Update changelog generation script (#11736) (Thanks @xtqqczze!)
- Update to `CredScan v2` (#11765)

### Tests

- Make sure to test whether we skip a test using consistent logic (#11892)
- Skip directory creation at root test on macOS (#11878)
- Update `Get-PlatformInfo` helper and tests for Debian 10, 11 and CentOS 8 (#11842)
- Ensure correct `pwsh` is used for test runs (#11486) (Thanks @iSazonov!)

### Build and Packaging Improvements

- Add `LTSRelease` value from `metadata.json` to `release.json` (#11897)
- Bump `Microsoft.ApplicationInsights` from `2.12.1` to `2.13.0` (#11894)
- Make LTS package always not a preview (#11895)
- Bump `System.Data.SqlClient` from `4.8.0` to `4.8.1` (#11879)
- Change `LTSRelease` value in `metadata.json` to true for `RC.3` release (Internal 10960)
- Update `LTS` logic to depend on `metadata.json` (#11877)
- Set default value of `LTSRelease` to false (#11874)
- Refactor packaging pipeline (#11852)
- Make sure `LTS` packages have symbolic links for `pwsh` and `pwsh-lts` (#11843)
- Bump `Microsoft.PowerShell.Native` from `7.0.0-rc.2` to `7.0.0` (#11839)
- Update the NuGet package generation to include `cimcmdlet.dll` and most of the built-in modules (#11832)
- Bump `Microsoft.PowerShell.Archive` from `1.2.4.0` to `1.2.5` (#11833)
- Bump `PSReadLine` from `2.0.0-rc2` to `2.0.0` (#11831)
- Add trace source and serialization primitives to the allowed assembly list (Internal 10911)
- Update the `NextReleaseTag` to be v7.0.0-preview.7 (#11372)
- Change packaging to produce `LTS` packages (#11772)
- Build tar packages only when building on Ubuntu (#11766)
- Bump `NJsonSchema` from `10.1.4` to `10.1.5` (#11730)
- Fix symbolic link creation in `packaging.psm1` (#11723)
- Bump `Microsoft.ApplicationInsights` from `2.12.0` to `2.12.1` (#11708)
- Bump `NJsonSchema` from `10.1.3` to `10.1.4` (#11620)
- Move to latest Azure DevOps agent images (#11704)
- Bump `Markdig.Signed` from `0.18.0` to `0.18.1` (#11641)

### Documentation and Help Content

- Add links to diffs on Github in changelog (#11652) (Thanks @xtqqczze!)
- Fix markdown-link test failure (#11653) (Thanks @xtqqczze!)

## [7.0.0-rc.2] - 2020-01-16

### Breaking Changes
- Use `ISOWeek` for week numbers in `Get-Date` accounting for leap years #11536 (Thanks @paalbra!)

### Engine Updates and Fixes
- Revert the PRs that made `DBNull.Value` and `NullString.Value` treated as `$null` (#11584)
- Support expanding `~` in `$env:PATH` when doing command discovery (#11552)
- Skip null data in output data received handler to fix a `NullReferenceException` (#11448) (Thanks @iSazonov!)
- Add `ssh` parameter sets for the parameter `-JobName` in `Invoke-Command` (#11444)
- Adding `PowerShell Editor Services` and `PSScriptAnalyzer` to tracked modules (#11514)
- Fix condition when key exchange stops responding with `SecureString` for the `OutOfProc` transports (#11380, #11406)
- Add setting to disable the implicit `WinPS` module loading (#11332)

### General Cmdlet Updates and Fixes
- Fix `NullReferenceException` in `ConciseView` (#11435) (Thanks @iSazonov!)
- Remove the default value of `$true` for the parameter `-RequireLicenseAcceptance` in `New-ModuleManifest` (#11512) (Thanks @ThomasNieto!)
- Make Web Cmdlets skip processing the content headers with a null or empty value for backward compatibility (#11421) (Thanks @spongemike2!)
- Don't format exceptions that are not `ErrorRecord` objects (#11415)
- Mark `InitialSessionState.ImportPSSnapIn` as Obsolete (#11399)
- Use `PositionMessage` for the line context information for `ConciseView` (#11398)
- Add trailing line number to `filename` for `ConciseView` (#11391)
- Update `HelpInfoUri` for all modules in PowerShell 7.0 (#11389)
- Remove unnecessary newline in `ConciseView` (#11383)
- Move `Set-StrictMode` to the outer script block for `ErrorView` (#11381)
- Remove the declaration of `Get-Error` experimental feature from module manifest (#11369)
- Update error message if `Update-Help` fails for the current `UICulture` (#11356)
- `Test-Connection`: Fallback to hop IP Address on `-Traceroute` without `-ResolveDestination` (#11335) (Thanks @vexx32!)
- Add null host name check in `WSMan` (#11288) (Thanks @iSazonov!)
- Add `Type` member to exceptions containing type of exception for `Get-Error` (#11076)
- Write an error if argument is a directory in `Get-FileHash` cmdlet (#11114) (Thanks @iSazonov!)
- Update `Get-Error` to not modify the original `$Error` object (#11125)

### Code Cleanup
- Use .NET code to check for processor architecture instead of P/Invoke (#11046) (Thanks @iSazonov!)

### Tests
- Test fixes for various platforms (#11579, #11541)
- Various test fixes for debugger and remoting  (#11528)
- `DSC` test fixes for `Alpine` and `Raspbian` (#11508)
- Normalize line endings before comparing string in tests (#11499)
- Fix `ssh` remoting test to work on all platforms (#11500)
- Build test artifacts for `Alpine` (#11483)
- Make null member access tests as string to avoid parsing errors (#11385)
- Fix test failing when `UnixStat` feature is disabled (#11370)
- Update hosting tests to use the SDK version from the build property (#11368)
- Add retry to `Enter-PSHostProcess` test (#11360)

### Build and Packaging Improvements
- Bump `Microsoft.PowerShell.Native` from `7.0.0-rc.1` to `7.0.0.rc.2` (#11583)
- Update .NET SDK version to 3.1.101 (#11582)
- Bump `PSReadLine` from `2.0.0-rc1` to `2.0.0-rc2` (#11581)
- Bump `NJsonSchema` from `10.0.28` to `10.1.3` (#11382, #11573)
- Generate the correct reference assembly for `Microsoft.PowerShell.ConsoleHost` NuGet package (#11545)
- Update building of `MSIX` for `RC` to use 100 range revision (#11526)
- Fix symbolic links on Debian 10 packages (#11474)
- Bump `Microsoft.PowerShell.Archive` from `1.2.3.0` to `1.2.4.0` (#11502)
- Add script to rebuild `WIX` component references (#11485)
- Bump `PackageManagement` from `1.4.5` to `1.4.6` (#11427)
- Bump `PowerShellGet` from `2.2.2` to `2.2.3` (#11426)
- Bump `ThreadJob` from `2.0.2` to `2.0.3` (#11416)
- Fix symbolic links to `libs` on Debian 10 (#11390)
- Improve Ubuntu detection for Ubuntu derivatives like `GalliumOS` etc (#11155)

### Documentation and Help Content
- Fix broken link in debugging `README.md` (#11503)

## [7.0.0-rc.1] - 2019-12-16

### Breaking Changes
- Make update notification support `LTS` and default channels (#11132)

### Engine Updates and Fixes
- Improvements in breakpoint APIs for remote scenarios (#11312)
- Fix PowerShell class definition leaking into another Runspace (#11273)
- Fix a regression in formatting caused by the `FirstOrDefault` primitive added in `7.0.0-Preview1` (#11258)
- Additional Microsoft Modules to track in `PS7` Telemetry (#10751)
- Make approved features non-experimental (#11303)
- Update `ConciseView` to use `TargetObject` if applicable (#11075)
- Fix `NullReferenceException` in `CompletionCompleters` public methods (#11274)
- Fix apartment thread state check on non-Windows platforms (#11301)
- Update setting `PSModulePath` to concatenate the process and machine environment variables (#11276)
- Bump `.NET Core` to `3.1.0` (#11260)
- Fix detection of `$PSHOME` in front of `$env:PATH` (#11141)

### General Cmdlet Updates and Fixes
- Fix for issue on Raspbian for setting date of file changes in `UnixStat` Experimental Feature (#11313)
- Add `-AsPlainText` to `ConvertFrom-SecureString` (#11142)
- Added `WindowsPS` version check for `WinCompat` (#11148)
- Fix error-reporting in some `WinCompat` scenarios (#11259)
- Add native binary resolver (#11032) (Thanks @iSazonov!)
- Update calculation of char width to respect `CJK` chars correctly (#11262)
- Add `Unblock-File` for macOS (#11137)
- Fix regression in `Get-PSCallStack` (#11210) (Thanks @iSazonov!)
- Avoid automatically loading the `ScheduledJob` module when using Job cmdlets (#11194)
- Add `OutputType` to `Get-Error` cmdlet and preserve original `TypeNames` (#10856)
- Fix null reference in `SupportsVirtualTerminal` property (#11105)

### Code Cleanup
- Change comment and element text to meet Microsoft standards (#11304)

### Tests
- Make unreliable `DSC` test pending (#11131)

### Build and Packaging Improvements
- Fix Nuget package signing for Coordinated Package build (#11316)
- Update dependencies from PowerShell Gallery and NuGet (#11323)
- Bump `Microsoft.ApplicationInsights` from `2.11.0` to `2.12.0` (#11305)
- Bump `Microsoft.CodeAnalysis.CSharp` from `3.3.1` to `3.4.0` (#11265)
- Updates packages for Debian 10 and 11 (#11236)
- Only enable experimental features prior to `RC` (#11162)
- Update macOS minimum version (#11163)
- Bump `NJsonSchema` from `10.0.27` to `10.0.28` (#11170)

### Documentation and Help Content
- Refactor change logs into one log per release (#11165)
- Fix `FWLinks` for PowerShell 7 online help documents (#11071)

## [7.0.0-preview.6] - 2019-11-21

### Breaking Changes

- Update `Test-Connection` to work more like the one in Windows PowerShell (#10697) (Thanks @vexx32!)
- Preserve `$?` for `ParenExpression`, `SubExpression` and `ArrayExpression` (#11040)
- Set working directory to current directory in `Start-Job` (#10920) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Allow `pwsh` to inherit `$env:PSModulePath` and enable `powershell.exe` to start correctly (#11057)

### Experimental Features

- Provide Unix stat information in filesystem output (#11042)
- Support null-conditional operators `?.` and `?[]` in PowerShell language (#10960)
- Support using non-compatible Windows PowerShell modules in PowerShell Core (#10973)

### Performance

- Avoid using closure in `Parser.SaveError` (#11006)
- Improve the caching when creating new `Regex` instances (#10657) (Thanks @iSazonov!)
- Improve processing of the PowerShell built-in type data from `types.ps1xml`, `typesV3.ps1xml` and `GetEvent.types.ps1xml` (#10898)
- Update `PSConfiguration.ReadValueFromFile` to make it faster and more memory efficient (#10839)

### General Cmdlet Updates and Fixes

- Add limit check in `Get-WinEvent` (#10648) (Thanks @iSazonov!)
- Fix command runtime so `StopUpstreamCommandsException` doesn't get populated in `-ErrorVariable` (#10840)
- Set the output encoding to `[Console]::OutputEncoding` for native commands (#10824)
- Support multi-line code blocks in examples (#10776) (Thanks @Greg-Smulko!)
- Add Culture parameter to `Select-String` cmdlet (#10943) (Thanks @iSazonov!)
- Fix `Start-Job` working directory path with trailing backslash (#11041)
- `ConvertFrom-Json`: Unwrap collections by default (#10861) (Thanks @danstur!)
- Use case-sensitive Hashtable for `Group-Object` cmdlet with `-CaseSensitive` and `-AsHashtable` switches (#11030) (Thanks @vexx32!)
- Handle exception if enumerating files fails when rebuilding path to have correct casing (#11014)
- Fix `ConciseView` to show `Activity` instead of `myCommand` (#11007)
- Allow web cmdlets to ignore HTTP error statuses (#10466) (Thanks @vdamewood!)
- Fix piping of more than one `CommandInfo` to `Get-Command` (#10929)
- Add back `Get-Counter` cmdlet for Windows (#10933)
- Make `ConvertTo-Json` treat `[AutomationNull]::Value` and `[NullString]::Value` as `$null` (#10957)
- Remove brackets from `ipv6` address for SSH remoting (#10968)
- Fix crash if command sent to pwsh is just whitespace (#10977)
- Added cross-platform `Get-Clipboard` and `Set-Clipboard` (#10340)
- Fix setting original path of filesystem object to not have extra trailing slash (#10959)
- Support `$null` for `ConvertTo-Json` (#10947)
- Add back `Out-Printer` command on Windows (#10906)
- Fix `Start-Job -WorkingDirectory` with whitespace (#10951)
- Return default value when getting `null` for a setting in `PSConfiguration.cs` (#10963) (Thanks @iSazonov!)
- Handle IO exception as non-terminating (#10950)
- Add `GraphicalHost` assembly to enable `Out-GridView`, `Show-Command`, and `Get-Help -ShowWindow` (#10899)
- Take `ComputerName` via pipeline in `Get-HotFix` (#10852) (Thanks @kvprasoon!)
- Fix tab completion for parameters so that it shows common parameters as available (#10850)
- Fix `GetCorrectCasedPath()` to first check if any system file entries is returned before calling `First()` (#10930)
- Set working directory to current directory in `Start-Job` (#10920) (Thanks @iSazonov!)
- Change `TabExpansion2` to not require `-CursorColumn` and treat as `$InputScript.Length` (#10849)
- Handle case where Host may not return Rows or Columns of screen (#10938)
- Fix use of accent colors for hosts that don't support them (#10937)
- Add back `Update-List` command (#10922)
- Update `FWLink` Id for `Clear-RecycleBin` (#10925)
- During tab completion, skip file if can't read file attributes (#10910)
- Add back `Clear-RecycleBin` for Windows (#10909)
- Add `$env:__SuppressAnsiEscapeSequences` to control whether to have VT escape sequence in output (#10814)

### Code Cleanup

- Cleanup style issues in `Compiler.cs` (#10368) (Thanks @iSazonov!)
- Remove the unused type converter for `CommaDelimitedStringCollection` (#11000) (Thanks @iSazonov!)
- Cleanup style in `InitialSessionState.cs` (#10865) (Thanks @iSazonov!)
- Code clean up for `PSSession` class (#11001)
- Remove the not-working 'run `Update-Help` from `Get-Help` when `Get-Help` runs for the first time' feature (#10974)
- Fix style issues (#10998) (Thanks @iSazonov!)
- Cleanup: use the built-in type alias (#10882) (Thanks @iSazonov!)
- Remove the unused setting key `ConsolePrompting` and avoid unnecessary string creation when querying `ExecutionPolicy` setting (#10985)
- Disable update notification check for daily builds (#10903) (Thanks @bergmeister!)
- Reinstate debugging API lost in #10338 (#10808)

### Tools

- Add default setting for the `SDKToUse` property so that it builds in VS (#11085)
- `Install-Powershell.ps1`: Add parameter to use MSI installation (#10921) (Thanks @MJECloud!)
- Add basic examples for `install-powershell.ps1` (#10914) (Thanks @kilasuit!)

### Tests

- Fix `stringdata` test to correctly validate keys of hashtables (#10810)
- Unload test modules (#11061) (Thanks @iSazonov!)
- Increase time between retries of testing URL (#11015)
- Update tests to accurately describe test actions. (#10928) (Thanks @romero126!)

### Build and Packaging Improvements

- Updating links in `README.md` and `metadata.json` for Preview.5 (#10854)
- Select the files for compliance tests which are owned by PowerShell (#10837)
- Allow `win7x86` `msix` package to build. (Internal 10515)
- Allow semantic versions to be passed to `NormalizeVersion` function (#11087)
- Bump .NET core framework to `3.1-preview.3` (#11079)
- Bump `PSReadLine` from `2.0.0-beta5` to `2.0.0-beta6` in /src/Modules (#11078)
- Bump `Newtonsoft.Json` from `12.0.2` to `12.0.3` (#11037) (#11038)
- Add Debian 10, 11 and CentOS 8 packages (#11028)
- Upload `Build-Info` Json file with the `ReleaseDate` field (#10986)
- Bump .NET core framework to `3.1-preview.2` (#10993)
- Enable build of x86 MSIX package (#10934)
- Update the dotnet SDK install script URL in `build.psm1` (#10927)
- Bump `Markdig.Signed` from `0.17.1` to `0.18.0` (#10887)
- Bump `ThreadJob` from `2.0.1` to `2.0.2` (#10886)
- Update `AppX` Manifest and Packaging module to conform to MS Store requirements (#10878)

### Documentation and Help Content

- Update `CONTRIBUTING.md` (#11096) (Thanks @mklement0!)
- Fix installation doc links in `README.md` (#11083)
- Adds examples to `install-powershell.ps1` script (#11024) (Thanks @kilasuit!)
- Fix to `Select-String` emphasis and `Import-DscResource` in CHANGELOG.md (#10890)
- Remove the stale link from `powershell-beginners-guide.md` (#10926)

## [7.0.0-preview.5] - 2019-10-23

### Breaking Changes

- Make `$PSCulture` consistently reflect in-session culture changes (#10138) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Move to `.NET Core 3.1 preview 1` (#10798)
- Refactor reparse tag checks in file system provider (#10431) (Thanks @iSazonov!)
- Replace `CR` and new line with a `0x23CE` character in script logging (#10616)
- Fix a resource leak by unregistering the event handler from `AppDomain.CurrentDomain.ProcessExit` (#10626)

### Experimental Features

- Implement `Get-Error` cmdlet as Experimental Feature (#10727,#10800)
- Add `ConciseView` for `$ErrorView` and update it to remove unnecessary text and not color entire line in red (#10641,#10724)
- Support the pipeline chain operators `&&` and `||` in PowerShell language (#9849,#10825,#10836)
- Implement null coalescing (`??`) and null coalescing assignment (`??=`) operators (#10636)
- Support notification on `pwsh` startup when a new release is available and update notification message (#10689,#10777)

### General Cmdlet Updates and Fixes

- Add emphasis to `Select-String` output (with `-NoEmphasis` parameter to opt-out) (#8963) (Thanks @derek-xia!)
- Add back `Get-HotFix` cmdlet (#10740)
- Make `Add-Type` usable in applications that host `PowerShell` (#10587)
- Use more effective evaluation order in `LanguagePrimitives.IsNullLike()` (#10781) (Thanks @vexx32!)
- Improve handling of mixed-collection piped input and piped streams of input in `Format-Hex` (#8674) (Thanks @vexx32!)
- Use type conversion in `SSHConnection` hashtables when value doesn't match expected type (#10720) (Thanks @SeeminglyScience!)
- Fix `Get-Content -ReadCount 0` behavior when `-TotalCount` is set (#10749) (Thanks @eugenesmlv!)
- Reword access denied error message in `Get-WinEvent` (#10639) (Thanks @iSazonov!)
- Enable tab completion for variable assignment that is enum or type constrained (#10646)
- Remove unused `SourceLength` remoting property causing formatting issues (#10765)
- Add `-Delimiter` parameter to `ConvertFrom-StringData` (#10665) (Thanks @steviecoaster!)
- Add positional parameter for `ScriptBlock` when using `Invoke-Command` with `SSH` (#10721) (Thanks @machgo!)
- Show line context information if multiple lines but no script name for `ConciseView` (#10746)
- Add support for `\\wsl$\` paths to file system provider (#10674)
- Add the missing token text for `TokenKind.QuestionMark` in parser (#10706)
- Set current working directory of each `ForEach-Object -Parallel` running script to the same location as the calling script. (#10672)
- Replace `api-ms-win-core-file-l1-2-2.dll` with `Kernell32.dll` for `FindFirstStreamW` and `FindNextStreamW` APIs (#10680) (Thanks @iSazonov!)
- Tweak help formatting script to be more `StrictMode` tolerant (#10563)
- Add `-SecurityDescriptorSDDL` parameter to `New-Service` (#10483) (Thanks @kvprasoon!)
- Remove informational output, consolidate ping usage in `Test-Connection` (#10478) (Thanks @vexx32!)
- Read special reparse points without accessing them (#10662) (Thanks @iSazonov!)
- Direct `Clear-Host` output to terminal (#10681) (Thanks @iSazonov!)
- Add back newline for grouping with `Format-Table` and `-Property` (#10653)
- Remove [ValidateNotNullOrEmpty] from `-InputObject` on `Get-Random` to allow empty string (#10644)
- Make suggestion system string distance algorithm case-insensitive (#10549) (Thanks @iSazonov!)
- Fix null reference exception in `ForEach-Object -Parallel` input processing (#10577)

### Code Cleanup

- Remove `WorkflowJobSourceAdapter` reference that is no longer used (#10326) (Thanks @KirkMunro!)
- Cleanup `COM` interfaces in jump list code by fixing `PreserveSig` attributes (#9899) (Thanks @weltkante!)
- Add a comment describing why `-ia` is not the alias for `-InformationAction` common parameter (#10703) (Thanks @KirkMunro!)
- Rename `InvokeCommandCmdlet.cs` to `InvokeExpressionCommand.cs` (#10659) (Thanks @kilasuit!)
- Add minor code cleanups related to update notifications (#10698)
- Remove deprecated workflow logic from the remoting setup scripts (#10320) (Thanks @KirkMunro!)
- Update help format to use proper case (#10678) (Thanks @tnieto88!)
- Clean up `CodeFactor` style issues coming in commits for the last month (#10591) (Thanks @iSazonov!)
- Fix typo in description of `PSTernaryOperator` experimental feature (#10586) (Thanks @bergmeister!)

### Performance

- Add minor performance improvements for runspace initialization (#10569) (Thanks @iSazonov!)

### Tools

- Make `Install-PowerShellRemoting.ps1` handle empty string in `PowerShellHome` parameter (#10526) (Thanks @Orca88!)
- Switch from `/etc/lsb-release` to `/etc/os-release` in `install-powershell.sh` (#10773) (Thanks @Himura2la!)
- Check `pwsh.exe` and `pwsh` in daily version on Windows (#10738) (Thanks @centreboard!)
- Remove unneeded tap in `installpsh-osx.sh` (#10752)

### Tests

- Temporary skip the flaky test `TestAppDomainProcessExitEvenHandlerNotLeaking` (#10827)
- Make the event handler leaking test stable (#10790)
- Sync capitalization in `CI` `YAML` (#10767) (Thanks @RDIL!)
- Add test for the event handler leaking fix (#10768)
- Add `Get-ChildItem` test (#10507) (Thanks @iSazonov!)
- Replace ambiguous language for tests from `switch` to `parameter` for accuracy (#10666) (Thanks @romero126!)

### Build and Packaging Improvements

- Update package reference for `PowerShell SDK` to `preview.5` (Internal 10295)
- Update `ThirdPartyNotices.txt` (#10834)
- Bump `Microsoft.PowerShell.Native` to `7.0.0-preview.3` (#10826)
- Bump `Microsoft.ApplicationInsights` from `2.10.0` to `2.11.0` (#10608)
- Bump `NJsonSchema` from `10.0.24` to `10.0.27` (#10756)
- Add `MacPorts` support to the build system (#10736) (Thanks @Lucius-Q-User!)
- Bump `PackageManagement` from `1.4.4` to `1.4.5` (#10728)
- Bump `NJsonSchema` from `10.0.23` to `10.0.24` (#10635)
- Add environment variable to differentiate client/server telemetry in `MSI` (#10612)
- Bump `PSDesiredStateConfiguration` from `2.0.3` to `2.0.4` (#10603)
- Bump `Microsoft.CodeAnalysis.CSharp` from `3.2.1` to `3.3.1` (#10607)
- Update to `.Net Core 3.0 RTM` (#10604) (Thanks @bergmeister!)
- Update `MSIX` packaging so the version to `Windows Store` requirements (#10588)

### Documentation and Help Content

- Merge stable and servicing change logs (#10527)
- Update used `.NET` version in build docs (#10775) (Thanks @Greg-Smulko!)
- Replace links from `MSDN` to `docs.microsoft.com` in `powershell-beginners-guide.md` (#10778) (Thanks @iSazonov!)
- Fix broken `DSC` overview link (#10702)
- Update `Support_Question.md` to link to `Stack Overflow` as another community resource (#10638) (Thanks @mklement0!)
- Add processor architecture to distribution request template (#10661)
- Add new PowerShell MoL book to learning PowerShell docs (#10602)

## [7.0.0-preview.4] - 2019-09-19

### Engine Updates and Fixes

- Add support to `ActionPreference.Break` to break into debugger when `Debug`, `Error`, `Information`, `Progress`, `Verbose` or `Warning` messages are generated (#8205) (Thanks @KirkMunro!)
- Enable starting control panel add-ins within PowerShell Core without specifying `.CPL` extension. (#9828)

### Performance

- Make `ForEach-Object` faster for its commonly used scenarios (#10454) and fix `ForEach-Object -Parallel` performance problem with many runspaces (#10455)

### Experimental Features

- Update `PSDesiredStateConfiguration` module version to `2.0.3` and bring new tests; enable compilation to MOF on non-Windows and use of Invoke-DSCResource without LCM (#10516)
- Add APIs for breakpoint management in runspaces and enable attach to process without `BreakAll` for PowerShell Editor Services (#10338) (Thanks @KirkMunro!)
- Support [ternary operator](https://github.com/PowerShell/PowerShell-RFC/pull/218) in PowerShell language (#10367)

### General Cmdlet Updates and Fixes

- Add PowerShell Core group policy definitions (#10468)
- Update console host to support `XTPUSHSGR`/`XTPOPSGR` VT control sequences that are used in [composability scenarios](https://github.com/microsoft/terminal/issues/1796). (#10208)
- Add `WorkingDirectory` parameter to `Start-Job` (#10324) (Thanks @davinci26!)
- Remove the event handler that was causing breakpoint changes to be erroneously replicated to the host runspace debugger (#10503) (Thanks @KirkMunro!)
- Replace `api-ms-win-core-job-12-1-0.dll` with `Kernell32.dll` in `Microsoft.PowerShell.Commands.NativeMethods` P/Invoke API(#10417) (Thanks @iSazonov!)
- Fix wrong output for `New-Service` in variable assignment and `-OutVariable` (#10444) (Thanks @kvprasoon!)
- Fix global tool issues around exit code, command line parameters and path with spaces (#10461)
- Fix recursion into OneDrive - change `FindFirstFileEx()` to use `SafeFindHandle` type (#10405)
- Skip auto-loading `PSReadLine` on Windows if the [NVDA screen reader](https://www.nvaccess.org/about-nvda/) is active (#10385)
- Increase built-with-PowerShell module versions to `7.0.0.0` (#10356)
- Add throwing an error in `Add-Type` if a type with the same name already exists (#9609) (Thanks @iSazonov!)

### Code Cleanup

- Convert `ActionPreference.Suspend` enumeration value into a non-supported, reserved state, and remove restriction on using `ActionPreference.Ignore` in preference variables (#10317) (Thanks @KirkMunro!)
- Replace `ArrayList` with `List<T>` to get more readable and reliable code without changing functionality (#10333) (Thanks @iSazonov!)
- Make code style fixes to `TestConnectionCommand` (#10439) (Thanks @vexx32!)
- Cleanup `AutomationEngine` and remove extra `SetSessionStateDrive` method call (#10416) (Thanks @iSazonov!)
- Rename default `ParameterSetName` back to `Delimiter` for `ConvertTo-Csv` and `ConvertFrom-Csv` (#10425)

### Tools

- Update `install-powershell.ps1` to check for already installed daily build (#10489)

### Tests

- Add experimental check to `ForEach-Object -Parallel` tests (#10354) (Thanks @KirkMunro!)
- Update tests for Alpine validation (#10428)

### Build and Packaging Improvements

- Bump `PowerShellGet` version from `2.2` to `2.2.1` (#10382)
- Bump `PackageManagement` version from `1.4.3` to `1.4.4` (#10383)
- Update `README.md` and `metadata.json` for `7.0.0-preview.4` (Internal 10011)
- Upgrade `.Net Core 3.0` version from `Preview 9` to `RC1` (#10552) (Thanks @bergmeister!)
- Fix `ExperimentalFeature` list generation (Internal 9996)
- Bump `PSReadLine` version from `2.0.0-beta4` to `2.0.0-beta5` (#10536)
- Fix release build script to set release tag
- Update version of `Microsoft.PowerShell.Native` to `7.0.0-preview.2` (#10519)
- Upgrade to `Netcoreapp3.0 preview9` (#10484) (Thanks @bergmeister!)
- Make sure the daily coordinated build, knows it is a daily build (#10464)
- Update the combined package build to release the daily builds (#10449)
- Remove appveyor reference (#10445) (Thanks @RDIL!)
- Bump `NJsonSchema` version from `10.0.22` to `10.0.23` (#10421)
- Remove the deletion of `linux-x64` build folder because some dependencies for Alpine need it (#10407)

### Documentation and Help Content

- Update `README.md` and metadata for `v6.1.6` and `v6.2.3` releases (#10523)
- Fix a typo in `README.md` (#10465) (Thanks @vedhasp!)
- Add a reference to `PSKoans` module to Learning Resources documentation (#10369) (Thanks @vexx32!)
- Update `README.md` and `metadata.json` for `7.0.0-preview.3` (#10393)

## [7.0.0-preview.3] - 2019-08-20

### Breaking Changes

- Remove `kill` alias for `Stop-Process` cmdlet on Unix (#10098) (Thanks @iSazonov!)
- Support for starting PowerShell as a login shell (`pwsh -Login` / `pwsh -l`) support (#10050)

### Engine Updates and Fixes

- Additional Telemetry - implementation of [`RFC0036`](https://github.com/PowerShell/PowerShell-RFC/pull/158) (#10336)
- Implement `ForEach-Object -Parallel` as an experimental feature (#10229)
- Skip `JumpList` on `NanoServer` and `IoT` (#10164)
- Make `Get-DscResource` work with class based resources (#10350)
- Fix `#requires -version` for `pwsh` 7 to include `6.1` and `6.2` in `PSCompatibleVersions` (#9943) (Thanks @bgelens!)
- Add dispose of `_runspaceDebugCompleteEvent` event object. (#10323)
- Fix performance regression from disabling debugger in system lockdown mode (#10269)
- Special case the `posix` locale in `WildcardPattern` (#10186)
- Use `Platform.IsWindowsDesktop` instead of checking both NanoServer and IoT (#10205)

### General Cmdlet Updates and Fixes

- Enable Experimental Features by default on Preview builds (#10228)
- Enable `-sta` and `-mta` switches for `pwsh` (`-sta` is required for `GUIs`) (#10061)
- Make breakpoints display better over PowerShell remoting (#10339) (Thanks @KirkMunro!)
- Add support for `AppX` reparse points (#10331)
- Make module name matching for `get-module -FullyQualifiedName` case insensitive (#10329)
- Expose `PreRelease` label in `PSModuleInfo` formatter (#10316)
- Add `-Raw` switch to `Select-String` which allows returning only the string that was matched (#9901) (Thanks @Jawz84!)

- ### Performance

- Reduce allocations in `MakePath()` method (#10027) (Thanks @iSazonov!)
- Remove extra check that the system dll exists (#10244) (Thanks @iSazonov!)
- Avoid boxing when passing value type arguments to `PSTraceSource.WriteLine` (#10052) (Thanks @iSazonov!)
- Reduce allocations in `Escape()` and `Unescape()` (#10041) (Thanks @iSazonov!)

### Code Cleanup

- Add the license header to `nanoserver.tests.ps1` (#10171)
- Mark `-parallel` and `-throttlelimit` reserved for `foreach` and `switch` statements (#10328) (Thanks @KirkMunro!)
- Deprecate workflow debugging code (#10321) (Thanks @KirkMunro!)
- Fix style issues in `InternalCommands.cs` (#10352) (Thanks @iSazonov!)
- Deprecate internal `HelpCategory.Workflow` enumeration (#10319) (Thanks @KirkMunro!)
- Update `Microsoft.PowerShell.CoreCLR.Eventing` to resolve conflict with `System.Diagnostics.EventLog` (#10305)
- Don't collect process start time as it's not being used on `consolehost` startup (#10294)
- .NET Core 3.0 now aborts the thread for us. Remove the `ThreadAbortException` code (#10230) (Thanks @iSazonov!)
- Use `nameof()` in `LocationGlobber` and `PathInfo` (#10200) (Thanks @iSazonov!)

### Tools

- Fix Hungarian prefix `my` (#9976) (Thanks @RDIL!)
- Fix spelling error in issue template (#10256)
- Quote arguments in `.vscode/tasks.json` in case of spaces (#10204) (Thanks @msftrncs!)

### Tests

- Remove `markdownlint` tests due to security issues (#10163)
- Add tests for `WildcardPattern.Escape()` and `Unescape()` (#10090) (Thanks @iSazonov!)
- Cleanup Docker release testing (#10310) (Thanks @RDIL!)

### Build and Packaging Improvements

- Update `Microsoft.Management.Infrastructure` version to `2.0.0-preview.2` (#10366)
- Move to `.NET Core 3.0 preview.8` (#10351) (#10227) (Thanks @bergmeister!)
- Bump `NJsonSchema` from `10.0.21` to `10.0.22` (#10364)
- Add `Microsoft.PowerShell.CoreCLR.Eventing.dll` to exception list for build fix (#10337)
- Bump `Microsoft.CodeAnalysis.CSharp` from `3.1.0` to `3.2.1` (#10273) (#10330)
- Revert the temporary AzDevOps artifact workaround (#10260)
- Fix macOS build break (#10207)

### Documentation and Help Content

- Update docs for `7.0.0-preview.2` release (#10160) (#10176)
- `PSSA` also includes formatting (#10172)
- Refactor security policy documentation so that they appear in the Security policy tab of GitHub (#9905) (Thanks @bergmeister!)
- Add tooling section to PR template (#10144)
- Update `README.md` and `metadata.json` for next releases (#10087)
- Update DotNet Support links (#10145)
- Update our language on our policy applying to security issues (#10304)
- Update dead links from `powershell.com` (#10297)
- Create `Distribution_Request` issue template (#10253)
- Fix: Removed dependency file with `Dependabot` (#10212) (Thanks @RDIL!)

## [7.0.0-preview.2] - 2019-07-17

### Breaking Changes

- Cleanup workflow - remove `PSProxyJob` (#10083) (Thanks @iSazonov!)
- Disable `Enter-PSHostProcess` cmdlet when system in lock down mode (Internal 9168)

### Engine Updates and Fixes

- Consider `DBNull.Value` and `NullString.Value` the same as `$null` when comparing with `$null` and casting to bool (#9794) (Thanks @vexx32!)
- Allow methods to be named after keywords (#9812) (Thanks @vexx32!)
- Create `JumpList` in `STA` thread as some `COM` `APIs` are strictly `STA` only to avoid sporadic `CLR` crashes (#9928) (#10057) (Thanks @bergmeister!)
- Skip `JumpList` on `NanoServer` and `IoT` (#10164)
- Display `COM` method signature with argument names (#9858) (Thanks @nbkalex!)
- Use the original precision (prior-dotnet-core-3) for double/float-to-string conversion (#9893)
- `Import-DscResource` can now clobber built-in DSC resource names (#9879)
- Add ability to pass `InitialSessionState` to the `ConsoleShell.Start` (#9802) (Thanks @asrosent!)
- Have console host not enter command prompt mode when using `Read-Host -Prompt` (#9743)
- Fix use of `Start-Process http://bing.com` (#9793)
- Support negative numbers in `-split` operator (#8960) (Thanks @ece-jacob-scott!)

### General Cmdlet Updates and Fixes

- Support DSC compilation on Linux. (#9834)
- Add alias for Service `StartType` (#9940) (Thanks @NeoBeum!)
- Add `-SecurityDescriptorSddl` parameter to `Set-Service` (#8626) (Thanks @kvprasoon!)
- Fix auto-download of files when enumerating files from a `OneDrive` folder (#9895)
- Set request headers when request body is empty in Web Cmdlets (#10034) (Thanks @markekraus!)
- Fix wrong comparison in `CertificateProvider` (#9987) (Thanks @iSazonov!)
- Sync docs changes into the embedded help for `pwsh` (#9952)
- Display Duration when displaying `HistoryInfo` (#9751) (Thanks @rkeithhill!)
- Update console startup and help `url` for PowerShell docs (#9775)
- Make `UseAbbreviationExpansion` and `TempDrive` official features (#9872)
- Fix `Get-ChildItem -Path` with wildcard `char` (#9257) (Thanks @kwkam!)

### Performance

- Add another fast path to `WildcardPattern.IsMatch` for patterns that only have an asterisk in the end (#10054) (Thanks @iSazonov!)
- Move some of the creations of `WildcardPattern` in outer loop to avoid unnecessary allocation (#10053) (Thanks @iSazonov!)
- Make `Foreach-Object` 2 times faster by reducing unnecessary allocations and boxing (#10047)
- Use a static cache for `PSVersionInfo.PSVersion` to avoid casting `SemanticVersion` to `Version` every time accessing that property (#10028)
- Reduce allocations in `NavigationCmdletProvider.NormalizePath()` (#10038) (Thanks @iSazonov!)
- Add fast path for wildcard patterns that contains no wildcard characters (#10020)
- Avoid `Assembly.GetName()` in `ClrFacade.GetAssemblies(string)` to reduce allocations of `CultureInfo` objects (#10024) (Thanks @iSazonov!)
- Avoid the `int[]` and `int[,]` allocation when tokenizing line comments and matching wildcard pattern (#10009)

### Tools

- Update change log generation tool to deal with private commits (#10096)
- Update `Start-PSBuild -Clean` logic of `git clean` to ignore locked files from `VS2019` (#10071) (Thanks @bergmeister!)
- Indent fix in `markdown-link.tests.ps1` (#10049) (Thanks @RDIL!)
- `Start-PSBuild -Clean`  does not remove all untracked files (#10022) (Thanks @vexx32!)
- Add module to support Pester tests for automating debugger commands (`stepInto`, `stepOut`, etc.), along with basic tests (#9825) (Thanks @KirkMunro!)
- Remove `markdownlint` tests due to security issues (#10163)

### Code Cleanup

- Cleanup `CompiledScriptBlock.cs` (#9735) (Thanks @vexx32!)
- Cleanup workflow code (#9638) (Thanks @iSazonov!)
- Use `AddOrUpdate()` instead of `Remove` then `Add` to register runspace (#10007) (Thanks @iSazonov!)
- Suppress `PossibleIncorrectUsageOfAssignmentOperator` rule violation by adding extra parenthesis (#9460) (Thanks @xtqqczze!)
- Use `AddRange` in `GetModules()` (#9975) (Thanks @iSazonov!)
- Code cleanup: use `IndexOf(char)` overload (#9722) (Thanks @iSazonov!)
- Move `consts` and methods to single `CharExtensions` class (#9992) (Thanks @iSazonov!)
- Cleanup: Use `EndsWith(char)` and `StartsWith(char)` (#9994) (Thanks @iSazonov!)
- Remove `LCIDToLocaleName` `P/Invoke` from `GetComputerInfoCommand` (#9716) (Thanks @iSazonov!)
- Cleanup Parser tests (#9792) (Thanks @vexx32!)
- Remove `EtwActivity` empty constructor and make minor style fixes (#9958) (Thanks @RDIL!)
- Fix style issues from last commits (#9937) (Thanks @iSazonov!)
- Remove dead code about `IsTransparentProxy` (#9966)
- Fix minor typos in code comments (#9917) (Thanks @RDIL!)
- Style fixes for `CimAsyncOperations` (#9945) (Thanks @RDIL!)
- Fix minor `CodeFactor` style issues in `ModuleCmdletBase` (#9915) (Thanks @RDIL!)
- Clean up the use of `SetProfileRoot` and `StartProfile` in ConsoleHost (#9931)
- Fix minor style issues come from last commits (#9640) (Thanks @iSazonov!)
- Improve whitespace for Parser tests (#9806) (Thanks @vexx32!)
- Use new `string.ConCat()` in `Process.cs` (#9720) (Thanks @iSazonov!)
- Code Cleanup: Tidy up `scriptblock.cs` (#9732) (Thanks @vexx32!)

### Tests

- Mark `Set-Service` tests with password as `Pending` (#10146)
- Fix test password generation rule to meet Windows complexity requirements (#10143)
- Add test for `New-Item -Force` (#9971) (Thanks @robdy!)
- Fix gulp versions (#9916) (Thanks @RDIL!)
- Indentation fixes in `ci.psm1` (#9947) (Thanks @RDIL!)
- Remove some `Travis-CI` references (#9919) (Thanks @RDIL!)
- Improve release testing Docker images (#9942) (Thanks @RDIL!)
- Use `yarn` to install global tools (#9904) (Thanks @RDIL!)
- Attempt to work around the zip download issue in Azure DevOps Windows CI (#9911)
- Update PowerShell SDK version for hosting tests (Internal 9185)

### Build and Packaging Improvements

- Update the target framework for reference assemblies to `netcoreapp3.0` (#9747)
- Pin version of `netDumbster` to `2.0.0.4` (#9748)
- Fix daily `CodeCoverageAndTest` build by explicitly calling `Start-PSBootStrap` (#9724)
- Split the `fxdependent` package on Windows into two packages (#10134)
- Bump `System.Data.SqlClient` (#10109)
- Bump `System.Security.AccessControl` (#10100)
- Add performance tag to change log command (Internal)
- Upgrade .Net Core 3 SDK from `preview5` to `preview6` and related out of band `Nuget` packages from `2.1` to `3.0-preview6` (#9888) (Thanks @bergmeister!)
- Add to `/etc/shells` on macOS (#10066)
- Bump `Markdig.Signed` from `0.17.0` to `0.17.1` (#10062)
- Update copyright symbol for `NuGet` packages (#9936)
- Download latest version `(6.2.0)` of `PSDesiredStateConfiguration` `nuget` package. (#9932)
- Add automated `RPM` signing to release build (#10013)
- Bump `ThreadJob` from `1.1.2` to `2.0.1` in `/src/Modules` (#10003)
- Bump `PowerShellGet` from `2.1.4` to `2.2` in /src/Modules (#9933) (#10085)
- Bump `PackageManagement` from `1.4` to `1.4.3` in `/src/Modules` (#9820) (#9918) (#10084)
- Update to use `TSAv2` (#9914)
- Bump `NJsonSchema` from `9.14.1` to `10.0.21` (#9805) (#9843) (#9854) (#9862) (#9875) (#9885) (#9954) (#10017)
- Bump `System.Net.Http.WinHttpHandler` from `4.5.3` to `4.5.4` (#9786)
- Bump `Microsoft.ApplicationInsights` from `2.9.1` to `2.10.0` (#9757)
- Increase timeout of NuGet job to workaround build timeout (#9772)

### Documentation and Help Content

- Change log `6.1.4` (#9759)
- Change log for release `6.2.1` (#9760)
- Add quick steps for adding docs to cmdlets (#9978)
- Update readme `gitter` badge (#9920) (Thanks @RDIL!)
- Update `README` and `metadata.json` for `7.0.0-preview.1` release (#9767)

## [7.0.0-preview.1] - 2019-05-30

### Breaking Changes

- Disable the debugger when in system lock-down mode (#9645)
- Fix `Get-Module -FullyQualifiedName` option to work with paths (#9101) (Thanks @pougetat!)
- Fix `-NoEnumerate` behavior in `Write-Output` (#9069) (Thanks @vexx32!)
- Make command searcher treat wildcard as literal if target exists for execution (#9202)

### Engine Updates and Fixes

- Port PowerShell to .NET Core 3.0 (#9597)
- Make sure we always return an object in command searcher (#9623)
- Support line continuance with pipe at the start of a line (#8938) (Thanks @KirkMunro!)
- Add support for `ValidateRangeKind` to `ParameterMetadata.GetProxyAttributeData` (#9059) (Thanks @indented-automation!)
- Allow passing just a dash as an argument to a file via pwsh (#9479)
- Fix tab completion for functions (#9383)
- Reduce string allocation in console output code (#6882) (Thanks @iSazonov!)
- Fixing test run crash by not passing script block to the callback (#9298)
- Add Binary Parsing Support & Refactor `TryGetNumberValue` & `ScanNumberHelper` (#7993) (Thanks @vexx32!)
- Add PowerShell remoting enable/disable cmdlet warning messages (#9203)
- Add `xsd` for `cdxml` (#9177)
- Improve formatting performance by having better primitives on `PSObject` (#8785) (Thanks @powercode!)
- Improve type inference of array literals and foreach statement variables (#8100) (Thanks @SeeminglyScience!)
- Fix for `FormatTable` remote deserialization regression (#9116)
- Get `MethodInfo` from .NET public type with explicit parameter types (#9029) (Thanks @iSazonov!)
- Add retry logic to the operation that updates `powershell.config.json` (#8779) (Thanks @iSazonov!)
- Update the task-based `async` APIs added to PowerShell to return a Task object directly (#9079)
- Add 5 `InvokeAsync` overloads and `StopAsync` to the `PowerShell` type (#8056) (Thanks @KirkMunro!)
- Remove unused cached types (#9015)

### General Cmdlet Updates and Fixes

- Fix use of unicode ellipsis in `XML` for truncating error messages (#9589)
- Improve error message in FileSystemProvider when removing a folder containing hidden or read only files (#9551) (Thanks @iSazonov!)
- Enable recursion into `OneDrive` by not treating placeholders as symlinks (#9509)
- Change `MatchType` for `EnumerationOptions` to be `Win32` making this consistent with Windows PowerShell (#9529)
- Add Support for null Usernames in Web Cmdlet Basic Auth (#9536) (Thanks @markekraus!)
- Fix null reference when `Microsoft.PowerShell.Utility` is loaded as a `snapin` in hosting scenarios (#9404)
- Update width of `DateTime` to accommodate change in Japan `DateTime` format with new era starting 5/1/19 (#9503)
- Fix `Get-Runspace` runspace object format Type column (#9438)
- Return correct casing of filesystem path during normalization (#9250)
- Move warning message to `EndProcessing` so it only shows up once (#9385)
- Fix the platform check in `CimDSCParser.cs` (#9338)
- New `New-PSBreakpoint` cmdlet & new `-Breakpoint` parameter for `Debug-Runspace` (#8923)
- Fix help paging issues on macOS/Linux and with custom pager that takes arguments (#9033) (Thanks @rkeithhill!)
- Add `QuoteFields` parameter to `ConvertTo-Csv` and `Export-Csv` (#9132) (Thanks @iSazonov!)
- Fix progress for Get-ComputerInfo (#9236) (Thanks @powercode!)
- Add `ItemSeparator` and `AltItemSeparator` properties in `ProviderInfo` (#8587) (Thanks @renehernandez!)
- Add timestamp to `pshost` trace listener (#9230)
- Implement `Get-Random -Count` without specifying an `InputObject` list (#9111) (Thanks @pougetat!)
- Enable `SecureString` cmdlets for non-Windows (#9199)
- Add Obsolete message to `Send-MailMessage` (#9178)
- Fix `Restart-Computer` to work on `localhost` when WinRM is not present (#9160)
- Make `Start-Job` throw terminating exception when `-RunAs32` is specified in 64-bit pwsh (#9143)
- Make `Start-Job` throw terminating error when PowerShell is being hosted (#9128)
- Made `-Subject` parameter of `Send-MailMessage` command no longer mandatory. (#8961) (Thanks @ece-jacob-scott!)
- Make `New-ModuleManifest` consistent with `Update-ModuleManifest` (#9104) (Thanks @pougetat!)
- Add support for empty `NoteProperty` in `Group-Object` (#9109) (Thanks @iSazonov!)
- Remove `Hardlink` from `Mode` property in default file system format (#8789) (Thanks @powercode!)
- Fixing issue with help progress with `Get-Help` not calling `Completed` (#8788) (Thanks @powercode!)
- Allow `Test-ModuleManifest` to work when `RootModule` has no file extension (#8687) (Thanks @pougetat!)
- Add `UseQuotes` parameter to `Export-Csv` and `ConvertTo-Csv` cmdlets (#8951) (Thanks @iSazonov!)
- Update version for `PowerShell.Native` and hosting tests (#8983)
- Refactor shuffle in `Get-Random` to save a full iteration of the objects. (#8969) (Thanks @st0le!)
- Suggest `-Id pid` for `Get-Process pid` (#8959) (Thanks @MohiTheFish!)

### Code Cleanup

- `Attributes.cs` - Style / Formatting Fixes (#9625) (Thanks @vexx32!)
- Remove Workflow from `PSSessionType` (#9618) (Thanks @iSazonov!)
- Update use of "PowerShell Core" to just "PowerShell" (#9513)
- Use `IPGlobalProperties` on all platforms for getting host name (#9530) (Thanks @iSazonov!)
- Remove `IsSymLink()` P/Invoke on Unix (#9534) (Thanks @iSazonov!)
- Cleanup unused P/Invokes on Unix (#9531) (Thanks @iSazonov!)
- Update use of `Windows PowerShell` to just `PowerShell` (#9508)
- Cleanup: sort `usings` (#9490) (Thanks @iSazonov!)
- Cleanup `Export-Command` from `AssemblyInfo` (#9455) (Thanks @iSazonov!)
- Run CodeFormatter for `System.Management.Automation` (#9402) (Thanks @iSazonov!)
- Run CodeFormatter with `BraceNewLine`,`UsingLocation`,`FormatDocument`,`NewLineAbove` rules (#9393) (Thanks @iSazonov!)
- Run CodeFormatter for `WSMan.Management` (#9400) (Thanks @iSazonov!)
- Run CodeFormatter for `WSMan.Runtime` (#9401) (Thanks @iSazonov!)
- Run CodeFormatter for `Security` module (#9399) (Thanks @iSazonov!)
- Run CodeFormatter for `MarkdownRender` (#9398) (Thanks @iSazonov!)
- Run CodeFormatter for `Eventing` (#9394) (Thanks @iSazonov!)
- Use `Environment.NewLine` for new lines in `ConsoleHost` code (#9392) (Thanks @iSazonov!)
- Run CodeFormatter for Diagnostics module (#9378) (Thanks @iSazonov!)
- Run CodeFormatter for `Microsoft.PowerShell.Commands.Management` (#9377) (Thanks @iSazonov!)
- Run CodeFormatter for Utility module (#9376) (Thanks @iSazonov!)
- Style: Match file name casings of C# source files for Utility commands (#9329) (Thanks @ThreeFive-O!)
- Update repo for Ubuntu 14.04 EOL (#9324)
- Cleanup: sort `usings` (#9283) (Thanks @iSazonov!)
- Fix StyleCop Hungarian Notation (#9281) (Thanks @iSazonov!)
- Style: Update StyleCop rules (#8500)
- Enhance the P/Invoke code for `LookupAccountSid` in `Process.cs`  (#9197) (Thanks @iSazonov!)
- Fix coding style for `NewModuleManifestCommand` (#9134) (Thanks @pougetat!)
- Remove unused method `CredUIPromptForCredential` from `HostUtilities.cs` (#9220) (Thanks @iSazonov!)
- Remove non-existent paths from `.csproj` files (#9214) (Thanks @ThreeFive-O!)
- Typo in new parameter set (#9205)
- Minor `FileSystemProvider` cleanup (#9182) (Thanks @RDIL!)
- Cleanup style issues in `CoreAdapter` and `MshObject` (#9190) (Thanks @iSazonov!)
- Minor cleanups in `Process.cs` (#9195) (Thanks @iSazonov!)
- Refactor `ReadConsole` P/Invoke in `ConsoleHost` (#9165) (Thanks @iSazonov!)
- Clean up `Get-Random` cmdlet (#9133) (Thanks @pougetat!)
- Fix to not pass `StringBuilder` by reference (`out` or `ref`) in P/Invoke (#9066) (Thanks @iSazonov!)
- Update AppVeyor comments in `Implicit.Remoting.Tests.ps1` (#9020) (Thanks @RDIL!)
- Remove AppImage from tools (#9100) (Thanks @Geweldig!)
- Using supported syntax for restoring warnings - Visual Studio 2019 complains about enable. (#9107) (Thanks @powercode!)
- Use `Type.EmptyTypes` and `Array.Empty<T>()` to replace our custom code of the same functionality (#9042) (Thanks @iSazonov!)
- Rename private methods in `MshCommandRuntime.cs` (#9074) (Thanks @vexx32!)
- Cleanup & update `ErrorRecord` class code style (#9021) (Thanks @vexx32!)
- Remove unused cached types from `CachedReflectionInfo` (#9019) (Thanks @iSazonov!)
- Fix CodeFactor brace style issues in `FileSystemProvider` (#8992) (Thanks @RDIL!)
- Use `List.AddRange` to optimize `-Split` (#9001) (Thanks @iSazonov!)
- Remove Arch Linux Dockerfile (#8990) (Thanks @RDIL!)
- Cleanup `dllimport` (#8847) (Thanks @iSazonov!)

### Tools

- Convert custom attribute `ValidatePathNotInSettings` to function (#9406)
- Create `DependaBot` `config.yml` (#9368)
- Add more users to failures detection and fix alias for static analysis (#9292)
- Make `install-powershell.ps1` work on Windows Server 2012 R2 (#9271)
- Enable `PoshChan` for getting and automatic retrieval of test failures for a PR (#9232)
- Fix capitalization cases for `PoshChan` (#9188) (Thanks @RDIL!)
- Update to new format for `PoshChan` settings and allow all users access to reminders (#9198)
- Fix settings to use dashes instead of underscore (#9167)
- Fix `AzDevOps` context names and add all PowerShell team members (#9164)
- Add settings for `PoshChan` (#9162)
- Adding `CmdletsToExport` and `AliasesToExport` to test module manifests. (#9108) (Thanks @powercode!)
- Delete Docker manifest creation script (#9076) (Thanks @RDIL!)
- Make install scripts more consistent over different operating systems (#9071) (Thanks @Geweldig!)
- Comment cleanup in `releaseTools.psm1` (#9064) (Thanks @RDIL!)
- Fix duplicate recommendation of Azure DevOps extension for Visual Studio Code (#9032) (Thanks @ThreeFive-O!)
- Code coverage artifacts (#8993)

### Tests

- Update version tests to use `NextReleaseVersion` from `metadata.json` (#9646)
- Convert Windows CI to stages (#9607)
- Multiple test fixes and improved logging for fragile tests (#9569)
- Add unit and feature tests for `Send-MailMessage` (#9213) (Thanks @ThreeFive-O!)
- Update to Pester `4.8.0` (#9510)
- Ensure `Wait-UntilTrue` returns `$true` in Pester tests (#9458) (Thanks @xtqqczze!)
- Adding tests for `Remove-Module` (#9276) (Thanks @pougetat!)
- Allow CI to run on branches with this name pattern: `feature*` (#9415)
- Mark tests in macOS CI which use `AppleScript` as pending/inconclusive (#9352)
- Reduce time for stack overflow test (#9302)
- Added more tests for `Import-Alias` by file regarding parsing difficult aliases strings (#9247) (Thanks @SytzeAndr!)
- Move from `npm` to `Yarn` for markdown tests (#9312) (Thanks @RDIL!)
- Only search for functions in Constrained Language help tests (#9301)
- Fix skipping of tests in `RemoteSession.Basic.Tests.ps1` (#9304)
- Make sure non-Windows CI fails when a test fails (#9303)
- Update tests to account for when `$PSHOME` is read only (#9279)
- Add tests for command globbing (#9180)
- Fix tab completion test to handle multiple matches (#8891)
- Refactor macOS CI so that tests run in parallel (#9056)
- Fix `Enter-PSHostProcess` tests flakiness (#9007)
- Add source for `Install-Package` to install `netDumbster` (#9081)
- Style fixes for `Select-Xml` tests (#9037) (Thanks @ThreeFive-O!)
- Enable cross-platform `Send-MailMessage` tests for CI (#8859) (Thanks @ThreeFive-O!)
- Added `RequireSudoOnUnix` tags to `PowerShellGet` tests and remove pending parameter (#8954) (Thanks @RDIL!)
- Style fixes for `ConvertTo-Xml` tests (#9036) (Thanks @ThreeFive-O!)
- Align name schemes for test files (#9034) (Thanks @ThreeFive-O!)
- Pending `NamedPipeConnectionInfo` test (#9003) (Thanks @iSazonov!)
- Add test for `-WhatIf` for `New-FileCatalog` (#8966) (Thanks @mjanko5!)

### Build and Packaging Improvements

- Fix the PowerShell version number in MSI packages (Internal 8547)
- Add cleanup before building test package (Internal 8529)
- Update version for SDK tests and `Microsoft.PowerShell.Native` package (Internal 8512)
- Update the target framework for reference assemblies to `netcoreapp3.0`  (Internal 8510)
- Fix syncing modules from PowerShell gallery by normalizing version numbers  (Internal 8504)
- Add `tsaVersion` property as `TsaV1` for compliance build phase (#9176)
- Add ability to cross compile (#9374)
- Add `AcessToken` variable to jobs that perform signing (#9351)
- Add CI for `install-powershell.sh` and Amazon Linux (#9314)
- Add component detection to all jobs (#8964)
- Add Preview assets for `MSIX` (#9375)
- Add secret scanning to CI (#9249)
- Build test packages for `windows`, `linux-x64`, `linux-arm`, `linux-arm64` and `macOS` (#9476)
- Bump `gulp` from `4.0.0` to `4.0.2` (#9441, #9544)
- Bump `Markdig.Signed` from `0.15.7` to `0.17.0` (#8981, #9579)
- Bump `Microsoft.CodeAnalysis.CSharp` from `2.10.0` to `3.1.0` (#9277, 9653)
- Bump `Microsoft.PowerShell.Native` from `6.2.0-rc.1` to `6.2.0` (#9200)
- Bump `Microsoft.Windows.Compatibility` from `2.0.1` to `2.1.1` (#9605)
- Bump `Newtonsoft.Json` from `12.0.1` to `12.0.2` (#9431, #9434)
- Bump `NJsonSchema` from `9.13.19` to `9.14.1` (#9044, #9136, #9166, #9172, #9184, #9196, #9265, #9349, #9388, #9421, #9429, #9478, #9523, #9616)
- Bump `PackageManagement` from `1.3.1` to `1.4` (#9567, #9650)
- Bump `PowerShellGet` from `2.0.4` to `2.1.4` in /src/Modules (#9110, #9145, #9600, #9691)
- Bump `PSReadLine` from `2.0.0-beta3` to `2.0.0-beta4` (#9554)
- Bump `SelfSignedCertificate` (#9055)
- Bump `System.Data.SqlClient` from `4.6.0` to `4.6.1` (#9601)
- Bump `System.Net.Http.WinHttpHandler` from `4.5.2` to `4.5.3` (#9333)
- Bump `Microsoft.PowerShell.Archive` from `1.2.2.0` to `1.2.3.0` (#9593)
- Check to be sure that the test result file has actual results before uploading (#9253)
- Clean up static analysis config (#9113) (Thanks @RDIL!)
- Create `codecoverage` and test packages for non-Windows (#9373)
- Create test package for macOS on release builds (#9344)
- Disable Homebrew analytics in macOS Azure DevOps builds (#9130) (Thanks @RDIL!)
- Enable building of `MSIX` package (#9289)
- Enable building on Kali Linux (#9471)
- Fix artifact Download issue in release build (#9095)
- Fix build order in `windows-daily` build (#9275)
- Fix dependencies of NuGet build to wait on `DEB` uploads to finish (#9118)
- Fix `MSI` Upgrade failure for preview builds (#9013)
- Fix publishing daily `nupkg` to MyGet (#9269)
- Fix the failed test and update `Publish-TestResults` to make Azure DevOps fail the task when any tests failed (#9457)
- Fix variable name in `windows-daily.yml` (#9274)
- Fixed Dockerfile syntax highlighting (#8991) (Thanks @RDIL!)
- Make `CodeCoverage` configuration build portable symbol files (#9346)
- Make Linux CI parallel (#9209)
- Move artifacts to artifact staging directory before uploading (#9273)
- Performance improvements for release build (#9179)
- Preserve user shortcuts pinned to TaskBar during MSI upgrade (#9305) (Thanks @bergmeister!)
- Publish global tool packages to `pwshtool` blob and bug fixes (#9163)
- Publish test package on release builds (#9063)
- Publish windows daily build to MyGet (#9288)
- Remove appveyor references from packaging tools (#9117) (Thanks @RDIL!)
- Remove code from `CI.psm1` to optionally run Feature tests (#9212) (Thanks @RDIL!)
- Remove duplicate `PoliCheck` task and pin to specific version (#9297)
- Run `Start-PSBootStrap` in Code Coverage build to install .NET SDK (#9690)
- Switch from `BMP` to `PNG` for graphical `MSI` installer assets (#9606)
- Translate Skipped  the test results into something Azure DevOps does NOT understand (#9124)
- Update Markdown test dependencies (#9075) (Thanks @RDIL!)
- Update UML to represent SDK and Global tool builds (#8997)
- Use IL assemblies for NuGet packages to reduce size (#9171)

### Documentation and Help Content

- Add checkbox to PR checklist for experimental feature use (#9619) (Thanks @KirkMunro!)
- Updating committee membership (#9577) (Thanks @HemantMahawar!)
- Update `CODEOWNERS` file to reduce noise (#9547)
- add download link to `raspbian64` to readme (#9520)
- Update `Support_Question.md` (#9218) (Thanks @vexx32!)
- Fix version of `PowerShellGet` in changelog (#9335)
- Update release process template to clarify that most tasks are coordinated by the release pipeline (#9238)
- Fix several problems in `WritingPesterTests` guideline (#9078) (Thanks @ThreeFive-O!)
- Update `ChangeLog` for `6.2.0` (#9245)
- Update docs for `v6.2.0` (#9229)
- Update `feature-request` issue template to move instructions into comments. (#9187) (Thanks @mklement0!)
- Update link to Contributing guide to new `PowerShell-Doc` repo (#9090) (Thanks @iSazonov!)
- Correct punctuation in `README.md` (#9045) (Thanks @yashrajbharti!)
- Update Docker `README.md` (#9010) (Thanks @RDIL!)
- Update release process issue template (#9051) (Thanks @RDIL!)
- Documentation Cleanup (#8851) (Thanks @RDIL!)
- Update docs for `6.2.0-rc.1` release (#9022)
- Update release template (#8996)

[7.0.3]: https://github.com/PowerShell/PowerShell/compare/v7.0.2...v7.0.3
[7.0.2]: https://github.com/PowerShell/PowerShell/compare/v7.0.1...v7.0.2
[7.0.1]: https://github.com/PowerShell/PowerShell/compare/v7.0.0...v7.0.1
[7.0.0]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-rc.3...v7.0.0
[7.0.0-rc.3]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-rc.2...v7.0.0-rc.3
[7.0.0-rc.2]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-rc.1...v7.0.0-rc.2
[7.0.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.6...v7.0.0-rc.1
[7.0.0-preview.6]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.5...v7.0.0-preview.6
[7.0.0-preview.5]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.4...v7.0.0-preview.5
[7.0.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.3...v7.0.0-preview.4
[7.0.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.2...v7.0.0-preview.3
[7.0.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v7.0.0-preview.1...v7.0.0-preview.2
[7.0.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-rc.1...v7.0.0-preview.1
