/* File:      mysqlembedded_driver_config.P -- loader for the MySQL Embedded Server driver
** Author:    Hui Wan
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 2002-2016
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**      http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
*/

:- compiler_options([xpp_on]).
#include "extensions_xsb.h"

:- import xsb_running_under/1, force_rename_file/2 from packaging.
:- import slash/1, str_cat/3 from machine.
:- import fmt_write_string/3, file_time/2 from file_io.
:- import search_module/6 from consult.
:- import xsb_configuration/2 from xsb_configuration.
:- import mysqlembedded_info/2 from mysqlembedded_init.
:- import compile_so/3, runtime_loader_flag/3 from foreign.
:- import path_sysop/3, path_sysop/2 from file_io.

make_mysqlembedded_driverH(CC, CC_opts) :-
        slash(Slash),
        xsb_configuration(configuration, XSBconfiguration),
        xsb_configuration(config_libdir, ConfigLibDir),
        mysqlembedded_info(libdir, EmbedMySQL_libdir),
        (EmbedMySQL_libdir == '' -> EmbedMySQL_libdir_flag = ''
        ;  str_cat('-L', EmbedMySQL_libdir, EmbedMySQL_libdir_flag)
        ),
        package_configuration(dir(mysqlembedded_driver), EmbedMySQLDriverDir),
        %% Creates something like -Wl,-rpath,<libdir>
        runtime_loader_flag(CC, EmbedMySQL_libdir, EmbedMySQLRunpathFlag),
        (xsb_running_under(cygwin) -> %% cygwin specific stuff
            xsb_configuration(config_bindir, ConfigBinDir),
            fmt_write_string(LD_flags,
                             ' %s %s%sdriver_manager.dll -lmysqld -lWS2_32 -s -lz -lm -lcrypt -lpthread ',
                             f(EmbedMySQL_libdir_flag, ConfigBinDir, Slash))
        ; %% windows specific stuff
            xsb_running_under(windows) -> true
        ; %% MacOS
            xsb_running_under(darwin) -> 
            fmt_write_string(LD_flags,
                             ' %s %s -L%s -lmysqld -s -lz -lm -lcrypt -lpthread ',
                             f(EmbedMySQLRunpathFlag,EmbedMySQL_libdir_flag, 
                               ConfigLibDir))
        ; %% other unixes
            fmt_write_string(LD_flags,
                             ' %s %s -L%s -lmysqld -s -lz -lm -lcrypt -lpthread %s%sdriver_manager.so ',
                             f(EmbedMySQLRunpathFlag, EmbedMySQL_libdir_flag, 
                               ConfigLibDir,ConfigLibDir,Slash))
        ),
        fmt_write_string(LD_directives_file,
                         '%s%scc%smysqlembedded_driver.H',
                         f(EmbedMySQLDriverDir, Slash, Slash)),
        telling(OldTell),
        tell(LD_directives_file),
        writeln('%% This file is generated on-the-fly by mysqlembedded_driver_config.P'),
        writeln('%% Do not edit--any changes will be written over.'),
        write('%% XSB config:    '), writeln(XSBconfiguration),
        write('%% XSB CC:        '), writeln(CC),
        write('%% CC:       '), writeln(CC),
        write('%% CC Opts: '), writeln(CC_opts), 
        writeln(':- export driverMySQLEmbedded_register/0.'),
        writeln(':- export driverMySQLEmbedded_initialise/0.'),
        writeln(':- export driverMySQLEmbedded_lib_init/0.'),
        writeln(':- export driverMySQLEmbedded_lib_end/0.'),
        write(':- ldoption('''),
        write(LD_flags),
        writeln(''').'),
        told,
        tell(OldTell).


:-  package_configuration(dir(mysqlembedded_driver), EmbedMySQLDriverDir),
        slash(Slash),
        Basename = mysqlembedded_driver,
        fmt_write_string(Module,
                         '%s%scc%s%s',
                         f(EmbedMySQLDriverDir, Slash, Slash, Basename)),
        xsb_configuration(compiler, CC),
        xsb_configuration(config_dir, ConfigDir),
        xsb_configuration(config_bindir, ConfigBinDir),
        xsb_configuration(config_libdir, ConfigLibDir),
        xsb_configuration(packagesdir, PackagesDir),
        str_cat(Module, XSB_OBJ_EXTENSION_ATOM, ObjfileX),
        fmt_write_string(LibObjFileX,
                         '%s%s%s%s',
                         args(ConfigLibDir,Slash,Basename,XSB_OBJ_EXTENSION_ATOM)),
        mysqlembedded_info(ccflags, CCflags),
        mysqlembedded_info(ldflags, LDflags),

        (xsb_running_under(windows64) -> PkgDlls = 'cc\windows64'
        ; PkgDlls = 'cc\windows'
        ),

        ((xsb_running_under(windows) ; xsb_running_under(cygwin)) ->
            fmt_write_string(WindSavedDll,
                             '%s%s%s%s%s.dll',
                             f(EmbedMySQLDriverDir,Slash,PkgDlls,Slash,Basename)),
            fmt_write_string(WindSavedLib,
                             '%s%s%s%s%s.lib',
                             f(EmbedMySQLDriverDir,Slash,PkgDlls,Slash,Basename)),
            fmt_write_string(ConfigSharedMod,
                             '%s%s%s.dll',
                             f(ConfigBinDir, Slash, Basename))
        ; xsb_running_under(darwin) ->
            fmt_write_string(ConfigSharedMod,
                             '%s%s%s.dylib',
                             f(ConfigLibDir, Slash, Basename))
        ;
            fmt_write_string(ConfigSharedMod,
                             '%s%s%s.so',
                             f(ConfigLibDir, Slash, Basename))
        ),  
        ( %% avoid recompilation: check if mysqlembedded_driver.xwam exists and 
            %% is newer than mysqlembedded_driver.c.
            search_module(Basename,Dir,_Mod,_Ext,_BaseDir,ModuleO),
            str_cat(Module, '.c', ModuleSourceFile),
            path_sysop(newerthan,ModuleO,ModuleSourceFile),
            path_sysop(newerthan,ConfigSharedMod,ModuleSourceFile)
        %% module compiled and is current, so just load
        -> [Basename]
        ;
            %% Cygwin isn't supported: XSB's C interface no longer works with it
            (xsb_running_under(cygwin) -> %% cygwin specific stuff
                fmt_write_string(DBDriversDir,
                                 '%s%sdbdrivers%scc', 
                                 f(PackagesDir, Slash, Slash)),
                fmt_write_string(CC_opts,
                                 ' %s -I %s -I %s',
                                 f(CCflags, ConfigDir, DBDriversDir)),
                shell(['copy /B /Y ', '"', WindSavedDll, '"', ' ', '"', ConfigBinDir, '"']),
                shell(['copy /B /Y ', '"', WindSavedLib, '"', ' ', '"', ConfigBinDir, '"']),
                make_mysqlembedded_driverH(CC, CC_opts),
                consult(Module, [cc(CC), cc_opts(CC_opts)]),
                force_rename_file(ObjfileX, LibObjFileX),
                str_cat(Module, '.o', ObjfileO),
                fmt_write_string(LibObjFileO,
                                 '%s%s%s.o',
                                 f(ConfigBinDir, Slash, Basename)),
                force_rename_file(ObjfileO, LibObjFileO),
                str_cat(Module, '.a', ObjfileA),
                fmt_write_string(LibObjFileA,
                                 '%s%s%s.a',
                                 f(ConfigBinDir, Slash, Basename)),
                force_rename_file(ObjfileA, LibObjFileA),
                str_cat(Module, '.def', ObjfileDef),
                fmt_write_string(LibObjFileDef,
                                 '%s%s%s.def',
                                 f(ConfigBinDir, Slash, Basename)),
                force_rename_file(ObjfileDef, LibObjFileDef)

        ; %% windows - don't compile; supposed to be compiled already
                xsb_running_under(windows) ->
                shell(['copy /B /Y ', '"', WindSavedDll, '"', ' ', '"', ConfigBinDir, '"']),
                shell(['copy /B /Y ', '"', WindSavedLib, '"', ' ', '"', ConfigBinDir, '"']),
                make_mysqlembedded_driverH(CC, ''),
                [Basename],
                (path_sysop(exists,ObjfileX) ->
                    force_rename_file(ObjfileX, LibObjFileX)
                ; true
                )
        ; %% unix and the module isn't compiled or is old -- recompile
                fmt_write_string(DBDriversDir,
                                 '%s%sdbdrivers%scc',
                                 f(PackagesDir, Slash, Slash)),
                fmt_write_string(CC_opts,
                                 ' %s -I %s -I %s',
                                 f(CCflags, ConfigDir, DBDriversDir)),
                (xsb_running_under(darwin) -> LibrarySuffix='.dylib'
                ;  LibrarySuffix='.so'
                ),

                str_cat(Module, LibrarySuffix, SharedLib),
                %% this is needed because compile_so above creates a shared lib
                %% and we need to move it to where XSB can find it.
                make_mysqlembedded_driverH(CC, CC_opts),
                %% this will regenerate SharedLib in cc/ - needed by Mac
                consult(Module, [cc(CC), cc_opts(CC_opts)]),
                force_rename_file(SharedLib, ConfigSharedMod),
                force_rename_file(ObjfileX, LibObjFileX)
            )
        ).

