/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard;", "", "cacheDir", "", "(Ljava/lang/String;)V", "cacheRoot", "Ljava/io/File;", "guardFile", "acquire", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard$AcquireStatus;", "release", "", "tryAcquire", "AcquireStatus", "backend.js"})
public final class IncrementalCacheGuard {
    @NotNull
    private final File cacheRoot;
    @NotNull
    private final File guardFile;

    public IncrementalCacheGuard(@NotNull String cacheDir) {
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.cacheRoot = new File(cacheDir);
        this.guardFile = FilesKt.resolve((File)this.cacheRoot, (String)"cache.guard");
    }

    @NotNull
    public final AcquireStatus acquire() {
        boolean cacheCleared = this.guardFile.exists();
        if (cacheCleared) {
            FilesKt.deleteRecursively((File)this.cacheRoot);
        }
        this.tryAcquire();
        return cacheCleared ? AcquireStatus.CACHE_CLEARED : AcquireStatus.OK;
    }

    public final void tryAcquire() {
        this.cacheRoot.mkdirs();
        this.guardFile.createNewFile();
    }

    public final void release() {
        this.guardFile.delete();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard$AcquireStatus;", "", "(Ljava/lang/String;I)V", "OK", "CACHE_CLEARED", "backend.js"})
    public static final class AcquireStatus
    extends Enum<AcquireStatus> {
        public static final /* enum */ AcquireStatus OK = new AcquireStatus();
        public static final /* enum */ AcquireStatus CACHE_CLEARED = new AcquireStatus();
        private static final /* synthetic */ AcquireStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AcquireStatus[] values() {
            return (AcquireStatus[])$VALUES.clone();
        }

        public static AcquireStatus valueOf(String value2) {
            return Enum.valueOf(AcquireStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<AcquireStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = acquireStatusArray = new AcquireStatus[]{AcquireStatus.OK, AcquireStatus.CACHE_CLEARED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

