/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;

public class LatestVersionMatcher
extends AbstractVersionMatcher {
    public LatestVersionMatcher() {
        super("latest");
    }

    @Override
    public boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        return moduleRevisionId.getRevision().startsWith("latest.");
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        return true;
    }

    @Override
    public boolean needModuleDescriptor(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        List list = StatusManager.getCurrent().getStatuses();
        Status status = (Status)list.get(list.size() - 1);
        String string = "latest." + status.getName();
        return !string.equals(moduleRevisionId.getRevision());
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) {
        String string = moduleRevisionId.getRevision().substring("latest.".length());
        return StatusManager.getCurrent().getPriority(string) >= StatusManager.getCurrent().getPriority(moduleDescriptor.getStatus());
    }

    @Override
    public int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        return this.needModuleDescriptor(moduleRevisionId, moduleRevisionId2) ? 0 : 1;
    }
}

