/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "interpolation.h"

void bilinear_interpolation (SDL_Surface *src, SDL_Surface *dst)
{
  if (SDL_MUSTLOCK(src))
    SDL_LockSurface (src);
  if (SDL_MUSTLOCK(dst))
    SDL_LockSurface (dst);
  
  Uint32 *pix = (Uint32 *) src->pixels;
  Uint32 *dpix = (Uint32 *) dst->pixels;
  int w = src->w;
  int h = src->h;
  
  assert (w == dst->w && h == dst->h);
  
  for (int y=0;y<h;y++)
    for (int x=0;x<w;x++)
      {
	int count = 0;
	int r=0, g=0, b=0, a=0;
	int tr, tg, tb, ta;

	Uint32 tmp = pix[y*w+x];
	pix_compext(tmp,tr,tg,tb,ta);
	count++;
	r += tr;
	g += tg;
	b += tb;
	a += ta;	

	if (y != 0)
	  {
	    Uint32 tmp = pix[(y-1)*w+x];
	    pix_compext(tmp, tr,tg,tb,ta);
	    count++;
	    r += tr;
	    g += tg;
	    b += tb;
	    a += ta;
	  }
	if (y != h-1)
	  {
	    Uint32 tmp = pix[(y+1)*w+x];
	    pix_compext(tmp, tr,tg,tb,ta);
	    count++;
	    r += tr;
	    g += tg;
	    b += tb;
	    a += ta;
	  }
	if (x != 0)
	  {
	    Uint32 tmp = pix[y*w+x-1];
	    pix_compext(tmp, tr,tg,tb,ta);
	    count++;
	    r += tr;
	    g += tg;
	    b += tb;
	    a += ta;
	  }
	if (x != w-1)
	  {
	    Uint32 tmp = pix[y*w+x+1];
	    pix_compext(tmp, tr,tg,tb,ta);
	    count++;
	    r += tr;
	    g += tg;
	    b += tb;
	    a += ta;
	  }
	
	r /= count;
	g /= count;
	b /= count;
	a /= count;

	dpix[y*w+x] = pix_pack(r, g, b, a);
      }
  
  if (SDL_MUSTLOCK(src))
    SDL_UnlockSurface(src);
  
  if (SDL_MUSTLOCK(dst))
    SDL_UnlockSurface(dst);


}

