/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __LOOKUP_H
#define __LOOKUP_H

#include <math.h>

#define PI 3.141592654

class lookup
{
 protected:
  float _sin[360];
  float _cos[360];

 public:
  lookup()
	{
	  for (int i=0;i<360;i++)
		{
		  _sin[i] = (float) ::sin((i/360.0)*2.0*PI);
		  _cos[i] = (float) ::cos((i/360.0)*2.0*PI);
		}
	}
  
  /**
   * gives sin of x degrees
   */
  inline float sin(int x) const
	{ return _sin[x % 360]; }

  /**
   * gives cos of x degrees
   */
  inline float cos(int x) const
	{ return _cos[x % 360]; }	
};


#endif
