// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             (unknown)
// source: buf/alpha/registry/v1alpha1/reference.proto

package registryv1alpha1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// ReferenceServiceClient is the client API for ReferenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReferenceServiceClient interface {
	// GetReferenceByName takes a reference name and returns the
	// reference either as a tag, branch, track or commit.
	GetReferenceByName(ctx context.Context, in *GetReferenceByNameRequest, opts ...grpc.CallOption) (*GetReferenceByNameResponse, error)
}

type referenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReferenceServiceClient(cc grpc.ClientConnInterface) ReferenceServiceClient {
	return &referenceServiceClient{cc}
}

func (c *referenceServiceClient) GetReferenceByName(ctx context.Context, in *GetReferenceByNameRequest, opts ...grpc.CallOption) (*GetReferenceByNameResponse, error) {
	out := new(GetReferenceByNameResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.ReferenceService/GetReferenceByName", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReferenceServiceServer is the server API for ReferenceService service.
// All implementations should embed UnimplementedReferenceServiceServer
// for forward compatibility
type ReferenceServiceServer interface {
	// GetReferenceByName takes a reference name and returns the
	// reference either as a tag, branch, track or commit.
	GetReferenceByName(context.Context, *GetReferenceByNameRequest) (*GetReferenceByNameResponse, error)
}

// UnimplementedReferenceServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReferenceServiceServer struct {
}

func (UnimplementedReferenceServiceServer) GetReferenceByName(context.Context, *GetReferenceByNameRequest) (*GetReferenceByNameResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReferenceByName not implemented")
}

// UnsafeReferenceServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReferenceServiceServer will
// result in compilation errors.
type UnsafeReferenceServiceServer interface {
	mustEmbedUnimplementedReferenceServiceServer()
}

func RegisterReferenceServiceServer(s grpc.ServiceRegistrar, srv ReferenceServiceServer) {
	s.RegisterService(&ReferenceService_ServiceDesc, srv)
}

func _ReferenceService_GetReferenceByName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReferenceByNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReferenceServiceServer).GetReferenceByName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.ReferenceService/GetReferenceByName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReferenceServiceServer).GetReferenceByName(ctx, req.(*GetReferenceByNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReferenceService_ServiceDesc is the grpc.ServiceDesc for ReferenceService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReferenceService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "buf.alpha.registry.v1alpha1.ReferenceService",
	HandlerType: (*ReferenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetReferenceByName",
			Handler:    _ReferenceService_GetReferenceByName_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "buf/alpha/registry/v1alpha1/reference.proto",
}
