/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.core.internal.folder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.model.core.ModelParser;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyService;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(name="org.openhab.core.folder", immediate=true, configurationPid={"org.openhab.folder"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class FolderObserver
implements WatchService.WatchEventListener {
    private final WatchService watchService;
    private final Path watchPath;
    private final Logger logger = LoggerFactory.getLogger(FolderObserver.class);
    private final ModelRepository modelRepository;
    private static final String READYMARKER_TYPE = "dsl";
    private final ReadyService readyService;
    private boolean activated;
    private final Map<String, Set<String>> folderFileExtMap = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> parsers = new HashSet<String>();
    private final Set<String> missingParsers = new HashSet<String>();
    private final Set<Path> ignoredPaths = new HashSet<Path>();
    private final Map<String, Path> namePathMap = new HashMap<String, Path>();

    @Activate
    public FolderObserver(@Reference ModelRepository modelRepo, @Reference ReadyService readyService, @Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.modelRepository = modelRepo;
        this.readyService = readyService;
        this.watchService = watchService;
        this.watchPath = watchService.getWatchPath();
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void addModelParser(ModelParser modelParser) {
        String extension = modelParser.getExtension();
        this.logger.debug("Adding parser for '{}' extension", (Object)extension);
        this.parsers.add(extension);
        if (this.activated) {
            this.processIgnoredPaths(extension);
            this.readyService.markReady(new ReadyMarker(READYMARKER_TYPE, extension));
            this.logger.debug("Marked extension '{}' as ready", (Object)extension);
        } else {
            this.logger.debug("{} is not yet activated", (Object)FolderObserver.class.getSimpleName());
        }
    }

    protected void removeModelParser(ModelParser modelParser) {
        String extension = modelParser.getExtension();
        this.logger.debug("Removing parser for '{}' extension", (Object)extension);
        this.parsers.remove(extension);
        Set<String> removed = this.modelRepository.removeAllModelsOfType(extension);
        this.ignoredPaths.addAll(removed.stream().map(this.namePathMap::get).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Activate
    public void activate(ComponentContext ctx) {
        this.logger.debug("FolderObserver activate");
        HashSet<String> parsersWithoutFolder = new HashSet<String>();
        Dictionary config = ctx.getProperties();
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            if (!folderName.matches("[A-Za-z0-9_]*")) continue;
            Path folderPath = this.watchPath.resolve(folderName);
            Set<String> validExtensions = Set.of(((String)config.get(folderName)).split(","));
            if (Files.exists(folderPath, new LinkOption[0]) && Files.isDirectory(folderPath, new LinkOption[0])) {
                this.folderFileExtMap.put(folderName, validExtensions);
                continue;
            }
            parsersWithoutFolder.addAll(validExtensions);
            this.logger.warn("Directory '{}' does not exist in '{}'. Please check your configuration settings!", (Object)folderName, (Object)OpenHAB.getConfigFolder());
        }
        this.watchService.registerListener((WatchService.WatchEventListener)this, Path.of("", new String[0]));
        this.addModelsToRepo();
        this.activated = true;
        this.logger.debug("{} has been activated", (Object)FolderObserver.class.getSimpleName());
        this.logger.debug("{} elements in parsersWithoutFolder and {} elements in missingParsers", (Object)parsersWithoutFolder.size(), (Object)this.missingParsers.size());
        for (String extension : parsersWithoutFolder) {
            if (!this.parsers.contains(extension) || this.missingParsers.contains(extension)) continue;
            this.readyService.markReady(new ReadyMarker(READYMARKER_TYPE, extension));
            this.logger.debug("Marked extension '{}' as ready", (Object)extension);
        }
        for (String extension : this.missingParsers) {
            if (!this.parsers.contains(extension)) continue;
            this.processIgnoredPaths(extension);
            this.readyService.markReady(new ReadyMarker(READYMARKER_TYPE, extension));
            this.logger.debug("Marked extension '{}' as ready", (Object)extension);
        }
        this.missingParsers.clear();
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
        this.activated = false;
        this.deleteModelsFromRepo();
        this.ignoredPaths.clear();
        this.folderFileExtMap.clear();
        this.parsers.clear();
        this.namePathMap.clear();
        this.logger.debug("{} has been deactivated", (Object)FolderObserver.class.getSimpleName());
    }

    private void processIgnoredPaths(String extension) {
        this.logger.debug("Processing {} ignored paths for '{}' extension", (Object)this.ignoredPaths.size(), (Object)extension);
        HashSet<Path> clonedSet = new HashSet<Path>(this.ignoredPaths);
        for (Path path : clonedSet) {
            if (!extension.equals(FolderObserver.getExtension(path))) continue;
            this.checkPath(path, WatchService.Kind.CREATE);
            this.ignoredPaths.remove(path);
        }
        this.logger.debug("Finished processing ignored paths for '{}' extension. {} ignored paths remain", (Object)extension, (Object)this.ignoredPaths.size());
    }

    private void addModelsToRepo() {
        for (Map.Entry<String, Set<String>> entry : this.folderFileExtMap.entrySet()) {
            String folderName = entry.getKey();
            Set<String> validExtensions = entry.getValue();
            if (validExtensions.isEmpty()) {
                this.logger.debug("Folder '{}' has no valid extensions", (Object)folderName);
                continue;
            }
            Path folderPath = this.watchPath.resolve(folderName);
            this.logger.debug("Adding files in '{}' to the model", (Object)folderPath);
            try {
                Throwable throwable = null;
                Iterator<String> iterator = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(folderPath, new FileExtensionsFilter(validExtensions));){
                    stream.forEach(path -> this.checkPath((Path)path, WatchService.Kind.CREATE));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to list entries in directory: {}", (Object)folderPath.toAbsolutePath(), (Object)e);
            }
            for (String extension : validExtensions) {
                if (!this.parsers.contains(extension) || this.missingParsers.contains(extension)) continue;
                this.readyService.markReady(new ReadyMarker(READYMARKER_TYPE, extension));
                this.logger.debug("Marked extension '{}' as ready", (Object)extension);
            }
        }
        this.logger.debug("Added {} model files and {} ignored paths remain", (Object)this.namePathMap.size(), (Object)this.ignoredPaths.size());
    }

    private void deleteModelsFromRepo() {
        for (String folder : this.folderFileExtMap.keySet()) {
            Iterable<String> models = this.modelRepository.getAllModelNamesOfType(folder);
            for (String model : models) {
                this.logger.debug("Removing file {} from the model repo.", (Object)model);
                this.modelRepository.removeModel(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPath(Path path, WatchService.Kind kind) {
        String fileName = path.getFileName().toString();
        try {
            if (kind == WatchService.Kind.DELETE) {
                Class<FolderObserver> clazz = FolderObserver.class;
                synchronized (FolderObserver.class) {
                    this.modelRepository.removeModel(fileName);
                    this.namePathMap.remove(fileName);
                    this.logger.debug("Removed '{}' model ", (Object)fileName);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
            if (Files.isHidden(path)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Omitting update of hidden file '{}'", (Object)path.toAbsolutePath());
                }
                return;
            }
            Class<FolderObserver> clazz = FolderObserver.class;
            synchronized (FolderObserver.class) {
                if (kind == WatchService.Kind.CREATE || kind == WatchService.Kind.MODIFY) {
                    String extension = FolderObserver.getExtension(fileName);
                    if (this.parsers.contains(extension)) {
                        try {
                            Throwable throwable = null;
                            Object var7_11 = null;
                            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                                this.namePathMap.put(fileName, path);
                                this.modelRepository.addOrRefreshModel(fileName, inputStream);
                                this.logger.debug("Added/refreshed '{}' model", (Object)fileName);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            this.logger.warn("Error while opening file during update: {}", (Object)path.toAbsolutePath());
                        }
                    } else if (extension != null) {
                        this.ignoredPaths.add(path);
                        if (!this.activated) {
                            this.missingParsers.add(extension);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Missing parser for '{}' extension, added ignored path: {}", (Object)extension, (Object)path.toAbsolutePath());
                        }
                    }
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling update of file '{}': {}.", new Object[]{path.toAbsolutePath(), e.getMessage(), e});
        }
        {
            return;
        }
    }

    private static @Nullable String getExtension(String fileName) {
        return fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : null;
    }

    private static @Nullable String getExtension(Path path) {
        return FolderObserver.getExtension(path.getFileName().toString());
    }

    public void processWatchEvent(WatchService.Kind kind, Path fullPath) {
        Path path = this.watchPath.relativize(fullPath);
        if (path.getNameCount() != 2) {
            this.logger.trace("{} event for {} ignored (only depth 1 allowed)", (Object)kind, (Object)path);
            return;
        }
        String extension = FolderObserver.getExtension(path);
        if (extension == null) {
            this.logger.trace("{} event for {} ignored (extension null)", (Object)kind, (Object)path);
            return;
        }
        String folderName = path.getName(0).toString();
        Set<String> validExtensions = this.folderFileExtMap.get(folderName);
        if (validExtensions == null) {
            this.logger.trace("{} event for {} ignored (folder '{}' extensions null)", new Object[]{kind, path, folderName});
            return;
        }
        if (!validExtensions.contains(extension)) {
            this.logger.trace("{} event for {} ignored ('{}' extension is invalid)", new Object[]{kind, path, extension});
            return;
        }
        this.checkPath(fullPath, kind);
    }

    protected static class FileExtensionsFilter
    implements DirectoryStream.Filter<Path> {
        private final Set<String> validExtensions;

        public FileExtensionsFilter(Set<String> validExtensions) {
            this.validExtensions = validExtensions;
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            String extension = FolderObserver.getExtension(entry);
            return extension != null && this.validExtensions.contains(extension);
        }
    }
}

