/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    public static <T> List<T> init(List<T> values) {
        return ListUtils.init(values, false);
    }

    public static <T> List<T> init(List<T> values, boolean remove) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(values.size());
        result.add(values.get(0));
        if (values.size() > 1) {
            for (int index = 1; index < values.size(); ++index) {
                T item = values.get(index);
                int first = result.indexOf(item);
                if (first < 0) {
                    result.add(item);
                    continue;
                }
                if (remove) continue;
                throw new IllegalArgumentException("Item " + item + "[" + index + "] is already contained at index [" + first + "]!");
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> addIfAbsent(List<T> list, T value) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (value != null && !list.contains(value)) {
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> addIfAbsent(List<T> list, List<T> newValues) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (newValues != null && !newValues.isEmpty()) {
            for (T value : newValues) {
                if (value == null || list.contains(value)) continue;
                list.add(value);
            }
        }
        return list;
    }
}

