/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    public static final String EMULATE_ORACLE = "org.bouncycastle.emulate.oracle";
    private static final ThreadLocal threadProperties = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String string2) {
        try {
            return Properties.isSetTrue(Properties.getPropertyValue(string2));
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean isOverrideSetTo(String string2, boolean bl) {
        try {
            String string3 = Properties.getPropertyValue(string2);
            if (bl) {
                return Properties.isSetTrue(string3);
            }
            return Properties.isSetFalse(string3);
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean setThreadOverride(String string2, boolean bl) {
        boolean bl2 = Properties.isOverrideSet(string2);
        HashMap<String, String> hashMap = (HashMap<String, String>)threadProperties.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            threadProperties.set(hashMap);
        }
        hashMap.put(string2, bl ? "true" : "false");
        return bl2;
    }

    public static boolean removeThreadOverride(String string2) {
        String string3;
        Map map = (Map)threadProperties.get();
        if (map != null && (string3 = (String)map.remove(string2)) != null) {
            if (map.isEmpty()) {
                threadProperties.remove();
            }
            return "true".equals(Strings.toLowerCase(string3));
        }
        return false;
    }

    public static int asInteger(String string2, int n) {
        String string3 = Properties.getPropertyValue(string2);
        if (string3 != null) {
            return Integer.parseInt(string3);
        }
        return n;
    }

    public static BigInteger asBigInteger(String string2) {
        String string3 = Properties.getPropertyValue(string2);
        if (string3 != null) {
            return new BigInteger(string3);
        }
        return null;
    }

    public static Set<String> asKeySet(String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = Properties.getPropertyValue(string2);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static String getPropertyValue(final String string2) {
        String string3;
        String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(string2);
            }
        });
        if (string4 != null) {
            return string4;
        }
        Map map = (Map)threadProperties.get();
        if (map != null && (string3 = (String)map.get(string2)) != null) {
            return string3;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2);
            }
        });
    }

    private static boolean isSetFalse(String string2) {
        if (string2 == null || string2.length() != 5) {
            return false;
        }
        return !(string2.charAt(0) != 'f' && string2.charAt(0) != 'F' || string2.charAt(1) != 'a' && string2.charAt(1) != 'A' || string2.charAt(2) != 'l' && string2.charAt(2) != 'L' || string2.charAt(3) != 's' && string2.charAt(3) != 'S' || string2.charAt(4) != 'e' && string2.charAt(4) != 'E');
    }

    private static boolean isSetTrue(String string2) {
        if (string2 == null || string2.length() != 4) {
            return false;
        }
        return !(string2.charAt(0) != 't' && string2.charAt(0) != 'T' || string2.charAt(1) != 'r' && string2.charAt(1) != 'R' || string2.charAt(2) != 'u' && string2.charAt(2) != 'U' || string2.charAt(3) != 'e' && string2.charAt(3) != 'E');
    }
}

