/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jivesoftware.smack.proxy.ProxySocketConnection;

public class ProxyInfo {
    private String proxyAddress;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private ProxyType proxyType;
    private final ProxySocketConnection proxySocketConnection;

    public ProxyInfo(ProxyType pType, String pHost, int pPort, String pUser, String pPass) {
        this.proxyType = pType;
        this.proxyAddress = pHost;
        this.proxyPort = pPort;
        this.proxyUsername = pUser;
        this.proxyPassword = pPass;
        this.proxySocketConnection = ProxySocketConnection.forProxyType(this.proxyType).apply(this);
    }

    public static ProxyInfo forHttpProxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.HTTP, pHost, pPort, pUser, pPass);
    }

    public static ProxyInfo forSocks4Proxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.SOCKS4, pHost, pPort, pUser, pPass);
    }

    public static ProxyInfo forSocks5Proxy(String pHost, int pPort, String pUser, String pPass) {
        return new ProxyInfo(ProxyType.SOCKS5, pHost, pPort, pUser, pPass);
    }

    public Proxy.Type getJavaProxyType() {
        switch (this.proxyType) {
            case HTTP: {
                return Proxy.Type.HTTP;
            }
            case SOCKS4: 
            case SOCKS5: {
                return Proxy.Type.SOCKS;
            }
        }
        throw new AssertionError((Object)("Invalid proxy type: " + String.valueOf((Object)this.proxyType)));
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public ProxySocketConnection getProxySocketConnection() {
        return this.proxySocketConnection;
    }

    public Proxy toJavaProxy() {
        InetSocketAddress proxySocketAddress = new InetSocketAddress(this.proxyAddress, this.proxyPort);
        Proxy.Type type = this.getJavaProxyType();
        return new Proxy(type, proxySocketAddress);
    }

    public static enum ProxyType {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

