/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.rce;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.InsecureWebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.SecureWebSocketRemoteConnectionEndpoint;

public abstract class WebSocketRemoteConnectionEndpoint
implements RemoteConnectionEndpoint {
    public static final String INSECURE_WEB_SOCKET_SCHEME = "ws";
    public static final String SECURE_WEB_SOCKET_SCHEME = "wss";
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final URI uri;
    private final UInt16 port;
    private List<? extends InetAddress> inetAddresses;

    protected WebSocketRemoteConnectionEndpoint(URI uri) {
        this.uri = uri;
        int portInt = uri.getPort();
        this.port = portInt >= 0 ? UInt16.from(portInt) : null;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Override
    public final String getHost() {
        return this.uri.getHost();
    }

    @Override
    public UInt16 getPort() {
        return this.port;
    }

    public abstract boolean isSecureEndpoint();

    private void resolveInetAddressesIfRequired() {
        InetAddress[] addresses;
        if (this.inetAddresses != null) {
            return;
        }
        String host = this.getHost();
        try {
            addresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.WARNING, "Could not resolve IP addresses of " + host, e);
            return;
        }
        this.inetAddresses = Arrays.asList(addresses);
    }

    @Override
    public Collection<? extends InetAddress> getInetAddresses() {
        this.resolveInetAddressesIfRequired();
        return this.inetAddresses;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public String toString() {
        return this.uri.toString();
    }

    public static WebSocketRemoteConnectionEndpoint from(CharSequence uriCharSequence) throws URISyntaxException {
        String uriString = uriCharSequence.toString();
        URI uri = URI.create(uriString);
        return WebSocketRemoteConnectionEndpoint.from(uri);
    }

    public static WebSocketRemoteConnectionEndpoint from(URI uri) {
        String scheme;
        switch (scheme = uri.getScheme()) {
            case "ws": {
                return new InsecureWebSocketRemoteConnectionEndpoint(uri);
            }
            case "wss": {
                return new SecureWebSocketRemoteConnectionEndpoint(uri);
            }
        }
        throw new IllegalArgumentException("Only allowed protocols are ws and wss");
    }
}

