/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.localization.Localizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInstanceResolver<T>
extends InstanceResolver<T> {
    AbstractInstanceResolver() {
    }

    protected static ResourceInjector getResourceInjector(WSEndpoint endpoint) {
        ResourceInjector ri = endpoint.getContainer().getSPI(ResourceInjector.class);
        if (ri == null) {
            ri = ResourceInjector.STANDALONE;
        }
        return ri;
    }

    protected static void invokeMethod(final @Nullable Method method, final Object instance, final Object ... args) {
        if (method == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(instance, args);
                }
                catch (IllegalAccessException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
                catch (InvocationTargetException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
                return null;
            }
        });
    }

    @Nullable
    protected final Method findAnnotatedMethod(Class clazz, Class<? extends Annotation> annType) {
        boolean once = false;
        Method r = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            if (once) {
                throw new ServerRtException(ServerMessages.ANNOTATION_ONLY_ONCE(annType), new Object[0]);
            }
            if (method.getParameterTypes().length != 0) {
                throw new ServerRtException(ServerMessages.NOT_ZERO_PARAMETERS(method), new Object[0]);
            }
            r = method;
            once = true;
        }
        return r;
    }

    protected static <T, R> InjectionPlan<T, R> buildInjectionPlan(Class<? extends T> clazz, Class<R> resourceType, boolean isStatic) {
        Resource resource;
        Class<T> cl;
        ArrayList plan = new ArrayList();
        for (cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            for (AccessibleObject accessibleObject : cl.getDeclaredFields()) {
                resource = ((Field)accessibleObject).getAnnotation(Resource.class);
                if (resource == null || !AbstractInstanceResolver.isInjectionPoint(resource, ((Field)accessibleObject).getType(), ServerMessages.localizableWRONG_FIELD_TYPE(((Field)accessibleObject).getName()), resourceType)) continue;
                if (isStatic && !Modifier.isStatic(((Field)accessibleObject).getModifiers())) {
                    throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(resourceType, accessibleObject));
                }
                plan.add(new FieldInjectionPlan((Field)accessibleObject));
            }
        }
        for (cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
                resource = ((Method)accessibleObject).getAnnotation(Resource.class);
                if (resource == null) continue;
                Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
                if (paramTypes.length != 1) {
                    throw new ServerRtException(ServerMessages.WRONG_NO_PARAMETERS(accessibleObject), new Object[0]);
                }
                if (!AbstractInstanceResolver.isInjectionPoint(resource, paramTypes[0], ServerMessages.localizableWRONG_PARAMETER_TYPE(((Method)accessibleObject).getName()), resourceType)) continue;
                if (isStatic && !Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new WebServiceException(ServerMessages.STATIC_RESOURCE_INJECTION_ONLY(resourceType, accessibleObject));
                }
                plan.add(new MethodInjectionPlan((Method)accessibleObject));
            }
        }
        return new Compositor(plan);
    }

    private static boolean isInjectionPoint(Resource resource, Class fieldType, Localizable errorMessage, Class resourceType) {
        Class t = resource.type();
        if (t.equals(Object.class)) {
            return fieldType.equals(resourceType);
        }
        if (t.equals(resourceType)) {
            if (fieldType.isAssignableFrom(resourceType)) {
                return true;
            }
            throw new ServerRtException(errorMessage);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Compositor<T, R>
    implements InjectionPlan<T, R> {
        private final InjectionPlan<T, R>[] children;

        public Compositor(Collection<InjectionPlan<T, R>> children) {
            this.children = children.toArray(new InjectionPlan[children.size()]);
        }

        @Override
        public void inject(T instance, R res) {
            for (InjectionPlan<T, R> plan : this.children) {
                plan.inject(instance, res);
            }
        }

        @Override
        public int count() {
            int r = 0;
            for (InjectionPlan<T, R> plan : this.children) {
                r += plan.count();
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodInjectionPlan<T, R>
    implements InjectionPlan<T, R> {
        private final Method method;

        public MethodInjectionPlan(Method method) {
            this.method = method;
        }

        @Override
        public void inject(T instance, R resource) {
            AbstractInstanceResolver.invokeMethod(this.method, instance, resource);
        }

        @Override
        public int count() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldInjectionPlan<T, R>
    implements InjectionPlan<T, R> {
        private final Field field;

        public FieldInjectionPlan(Field field) {
            this.field = field;
        }

        @Override
        public void inject(final T instance, final R resource) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (!FieldInjectionPlan.this.field.isAccessible()) {
                            FieldInjectionPlan.this.field.setAccessible(true);
                        }
                        FieldInjectionPlan.this.field.set(instance, resource);
                        return null;
                    }
                    catch (IllegalAccessException e) {
                        throw new ServerRtException("server.rt.err", new Object[]{e});
                    }
                }
            });
        }

        @Override
        public int count() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InjectionPlan<T, R> {
        public void inject(T var1, R var2);

        public int count();
    }
}

