/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.providersupport.internal.ProviderRegistry;
import org.openhab.core.automation.module.script.providersupport.shared.ScriptedThingProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;

@NonNullByDefault
public class ProviderThingRegistryDelegate
implements ThingRegistry,
ProviderRegistry {
    private final ThingRegistry thingRegistry;
    private final Set<ThingUID> things = new HashSet<ThingUID>();
    private final ScriptedThingProvider scriptedProvider;

    public ProviderThingRegistryDelegate(ThingRegistry thingRegistry, ScriptedThingProvider scriptedProvider) {
        this.thingRegistry = thingRegistry;
        this.scriptedProvider = scriptedProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<Thing> listener) {
        this.thingRegistry.addRegistryChangeListener(listener);
    }

    public Collection<Thing> getAll() {
        return this.thingRegistry.getAll();
    }

    public Stream<Thing> stream() {
        return this.thingRegistry.stream();
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Thing> listener) {
        this.thingRegistry.removeRegistryChangeListener(listener);
    }

    public Thing add(Thing element) {
        ThingUID thingUID = element.getUID();
        if (this.get(thingUID) != null) {
            throw new IllegalArgumentException("Cannot add Thing, because a Thing with same UID (" + String.valueOf(thingUID) + ") already exists.");
        }
        this.scriptedProvider.add(element);
        this.things.add(thingUID);
        return element;
    }

    public Thing addPermanent(Thing element) {
        return (Thing)this.thingRegistry.add((Identifiable)element);
    }

    public @Nullable Thing update(Thing element) {
        if (this.things.contains(element.getUID())) {
            return this.scriptedProvider.update(element);
        }
        return (Thing)this.thingRegistry.update((Identifiable)element);
    }

    public @Nullable Thing get(ThingUID uid) {
        return this.thingRegistry.get(uid);
    }

    public @Nullable Channel getChannel(ChannelUID channelUID) {
        return this.thingRegistry.getChannel(channelUID);
    }

    public void updateConfiguration(ThingUID thingUID, Map<String, Object> configurationParameters) {
        this.thingRegistry.updateConfiguration(thingUID, configurationParameters);
    }

    public @Nullable Thing remove(ThingUID thingUID) {
        return this.thingRegistry.remove(thingUID);
    }

    @Override
    public void removeAllAddedByScript() {
        for (ThingUID thing : this.things) {
            this.scriptedProvider.remove(thing);
        }
        this.things.clear();
    }

    public @Nullable Thing forceRemove(ThingUID thingUID) {
        if (this.things.remove(thingUID)) {
            return this.scriptedProvider.remove(thingUID);
        }
        return this.thingRegistry.forceRemove(thingUID);
    }

    public @Nullable Thing createThingOfType(ThingTypeUID thingTypeUID, @Nullable ThingUID thingUID, @Nullable ThingUID bridgeUID, @Nullable String label, Configuration configuration) {
        return this.thingRegistry.createThingOfType(thingTypeUID, thingUID, bridgeUID, label, configuration);
    }
}

