import { QueryParamConfig, QueryParamConfigMap } from 'serialize-query-params';
import { QueryParamOptions } from './options';
import { QueryParamConfigMapWithInherit } from './types';
/**
 * Convert inherit strings from a query param config to actual
 * parameters based on predefined ('inherited') mappings.
 * Defaults to StringParam.
 */
export declare function convertInheritedParamStringsToParams(paramConfigMapWithInherit: QueryParamConfigMapWithInherit, options: QueryParamOptions): QueryParamConfigMap;
/**
 * Extends a config to include params for all specified keys,
 * defaulting to StringParam if not found in the inheritedParams
 * map.
 */
export declare function extendParamConfigForKeys(baseParamConfigMap: QueryParamConfigMap, paramKeys: string[], inheritedParams?: QueryParamOptions['params'] | undefined, defaultParam?: QueryParamConfig<any> | undefined): QueryParamConfigMap;
