'use client';
import { jsx } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import '../../CloseButton/CloseIcon.mjs';
import { CloseButton } from '../../CloseButton/CloseButton.mjs';

const ComboboxClearButton = forwardRef(
  ({ size, onMouseDown, onClick, onClear, ...others }, ref) => /* @__PURE__ */ jsx(
    CloseButton,
    {
      ref,
      size: size || "sm",
      variant: "transparent",
      tabIndex: -1,
      "aria-hidden": true,
      ...others,
      onMouseDown: (event) => {
        event.preventDefault();
        onMouseDown?.(event);
      },
      onClick: (event) => {
        onClear();
        onClick?.(event);
      }
    }
  )
);
ComboboxClearButton.displayName = "@mantine/core/ComboboxClearButton";

export { ComboboxClearButton };
//# sourceMappingURL=ComboboxClearButton.mjs.map
