/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib;

import java.util.Set;
import java.util.logging.Logger;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.Index;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.TrackData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CueSheetSerializer {
    private String indentationValue = "  ";
    private static final Logger logger = Logger.getLogger(CueSheetSerializer.class.getCanonicalName());

    public CueSheetSerializer() {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "CueSheetSerializer()");
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "CueSheetSerializer()");
    }

    public CueSheetSerializer(String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "CueSheetSerializer(String)", string);
        logger.config("Setting CueSheetSerializer indentation value to: '" + string + "'");
        this.indentationValue = string;
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "CueSheetSerializer(String)");
    }

    public String serializeCueSheet(CueSheet cueSheet) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet)", cueSheet);
        StringBuilder stringBuilder = new StringBuilder();
        this.serializeCueSheet(stringBuilder, cueSheet, "");
        String string = stringBuilder.toString();
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeCueSheet(CueSheet)", string);
        return string;
    }

    private void serializeCueSheet(StringBuilder stringBuilder, CueSheet cueSheet, String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeCueSheet(StringBuilder,CueSheet,String)", new Object[]{stringBuilder, cueSheet, string});
        logger.fine("Serializing cue sheet to cue format.");
        this.addField(stringBuilder, "REM GENRE", string, cueSheet.getGenre());
        this.addField(stringBuilder, "REM DATE", string, cueSheet.getYear());
        this.addField(stringBuilder, "REM DISCID", string, cueSheet.getDiscid());
        this.addField(stringBuilder, "REM COMMENT", string, cueSheet.getComment());
        this.addField(stringBuilder, "CATALOG", string, cueSheet.getCatalog());
        this.addField(stringBuilder, "PERFORMER", string, cueSheet.getPerformer());
        this.addField(stringBuilder, "TITLE", string, cueSheet.getTitle());
        this.addField(stringBuilder, "SONGWRITER", string, cueSheet.getSongwriter());
        this.addField(stringBuilder, "CDTEXTFILE", string, cueSheet.getCdTextFile());
        for (FileData fileData : cueSheet.getFileData()) {
            this.serializeFileData(stringBuilder, fileData, string);
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeCueSheet(StringBuilder,CueSheet,String)");
    }

    private void serializeFileData(StringBuilder stringBuilder, FileData fileData, String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeFileData(StringBuilder,FileData,String)", new Object[]{stringBuilder, fileData, string});
        stringBuilder.append(string).append("FILE");
        if (fileData.getFile() != null) {
            stringBuilder.append(' ').append(this.quoteIfNecessary(fileData.getFile()));
        }
        if (fileData.getFileType() != null) {
            stringBuilder.append(' ').append(this.quoteIfNecessary(fileData.getFileType()));
        }
        stringBuilder.append('\n');
        for (TrackData trackData : fileData.getTrackData()) {
            this.serializeTrackData(stringBuilder, trackData, string + this.getIndentationValue());
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeFileData(StringBuilder,FileData,String)");
    }

    private void serializeTrackData(StringBuilder stringBuilder, TrackData trackData, String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeTrackData(StringBuilder,TrackData,String)", new Object[]{stringBuilder, trackData, string});
        stringBuilder.append(string).append("TRACK");
        if (trackData.getNumber() > -1) {
            stringBuilder.append(' ').append(String.format("%1$02d", trackData.getNumber()));
        }
        if (trackData.getDataType() != null) {
            stringBuilder.append(' ').append(this.quoteIfNecessary(trackData.getDataType()));
        }
        stringBuilder.append('\n');
        String string2 = string + this.getIndentationValue();
        this.addField(stringBuilder, "ISRC", string2, trackData.getIsrcCode());
        this.addField(stringBuilder, "PERFORMER", string2, trackData.getPerformer());
        this.addField(stringBuilder, "TITLE", string2, trackData.getTitle());
        this.addField(stringBuilder, "SONGWRITER", string2, trackData.getSongwriter());
        this.addField(stringBuilder, "PREGAP", string2, trackData.getPregap());
        this.addField(stringBuilder, "POSTGAP", string2, trackData.getPostgap());
        if (trackData.getFlags().size() > 0) {
            this.serializeFlags(stringBuilder, trackData.getFlags(), string2);
        }
        for (Index index : trackData.getIndices()) {
            this.serializeIndex(stringBuilder, index, string2);
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeTrackData(StringBuilder,TrackData,String)");
    }

    private void serializeFlags(StringBuilder stringBuilder, Set<String> set, String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeFlags(StringBuilder,Set<String>,String)", new Object[]{stringBuilder, set, string});
        stringBuilder.append(string).append("FLAGS");
        for (String string2 : set) {
            stringBuilder.append(' ').append(this.quoteIfNecessary(string2));
        }
        stringBuilder.append('\n');
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeFlags(StringBuilder,Set<String>,String)");
    }

    private void serializeIndex(StringBuilder stringBuilder, Index index, String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "serializeIndex(StringBuilder,Index,String)", new Object[]{stringBuilder, index, string});
        stringBuilder.append(string).append("INDEX");
        if (index.getNumber() > -1) {
            stringBuilder.append(' ').append(String.format("%1$02d", index.getNumber()));
        }
        if (index.getPosition() != null) {
            stringBuilder.append(' ').append(this.formatPosition(index.getPosition()));
        }
        stringBuilder.append('\n');
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "serializeIndex(StringBuilder,Index,String)");
    }

    private String formatPosition(Position position) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "formatPosition(Position)", position);
        String string = String.format("%1$02d:%2$02d:%3$02d", position.getMinutes(), position.getSeconds(), position.getFrames());
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "formatPosition(Position)", string);
        return string;
    }

    private void addField(StringBuilder stringBuilder, String string, String string2, Position position) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,Position)", new Object[]{stringBuilder, string, string2, position});
        if (position != null) {
            stringBuilder.append(string2).append(string).append(' ').append(this.formatPosition(position)).append('\n');
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,Position)");
    }

    private void addField(StringBuilder stringBuilder, String string, String string2, String string3) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,String)", new Object[]{stringBuilder, string, string2, string3});
        if (string3 != null) {
            stringBuilder.append(string2).append(string).append(' ').append(this.quoteIfNecessary(string3)).append('\n');
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,String)");
    }

    private void addField(StringBuilder stringBuilder, String string, String string2, int n) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,int)", new Object[]{stringBuilder, string, string2, n});
        if (n > -1) {
            stringBuilder.append(string2).append(string).append(' ').append("" + n).append('\n');
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "addField(StringBuilder,String,String,int)");
    }

    private String quoteIfNecessary(String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "quoteIfNecessary(String)", string);
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            String string2 = '\"' + string + '\"';
            logger.exiting(CueSheetSerializer.class.getCanonicalName(), "quoteIfNecessary(String)", string2);
            return string2;
        }
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "quoteIfNecessary(String)", string);
        return string;
    }

    public String getIndentationValue() {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "getIndentationValue()");
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "getIndentationValue()", this.indentationValue);
        return this.indentationValue;
    }

    public void setIndentationValue(String string) {
        logger.entering(CueSheetSerializer.class.getCanonicalName(), "setIndentationValue(String)", string);
        this.indentationValue = string;
        logger.exiting(CueSheetSerializer.class.getCanonicalName(), "setIndentationValue()");
    }
}

