/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.Index;
import jwbroek.cuelib.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackData {
    private static final Logger logger = Logger.getLogger(TrackData.class.getCanonicalName());
    private final List<Index> indices = new ArrayList<Index>();
    private final Set<String> flags = new TreeSet<String>();
    private int number = -1;
    private String dataType = null;
    private String isrcCode = null;
    private String performer = null;
    private String title = null;
    private Position pregap = null;
    private Position postgap = null;
    private String songwriter = null;
    private FileData parent;

    public TrackData(FileData fileData) {
        logger.entering(TrackData.class.getCanonicalName(), "TrackData(FileData)", fileData);
        this.parent = fileData;
        logger.exiting(TrackData.class.getCanonicalName(), "TrackData(FileData)");
    }

    public TrackData(FileData fileData, int n, String string) {
        logger.entering(TrackData.class.getCanonicalName(), "TrackData(FileData,int,String)", new Object[]{fileData, n, string});
        this.parent = fileData;
        this.number = n;
        this.dataType = string;
        logger.exiting(TrackData.class.getCanonicalName(), "TrackData(FileData,int,String)");
    }

    public String getMetaData(CueSheet.MetaDataField metaDataField) throws IllegalArgumentException {
        String string;
        logger.entering(TrackData.class.getCanonicalName(), "getMetaData(MetaDataField)", (Object)metaDataField);
        switch (metaDataField) {
            case ISRCCODE: {
                string = this.getIsrcCode() == null ? "" : this.getIsrcCode();
                break;
            }
            case PERFORMER: {
                string = this.getPerformer() == null ? this.getParent().getParent().getPerformer() : this.getPerformer();
                break;
            }
            case TRACKPERFORMER: {
                string = this.getPerformer() == null ? "" : this.getPerformer();
                break;
            }
            case SONGWRITER: {
                string = this.getSongwriter() == null ? this.getParent().getParent().getSongwriter() : this.getSongwriter();
                break;
            }
            case TRACKSONGWRITER: {
                string = this.getSongwriter();
                break;
            }
            case TITLE: {
                string = this.getTitle() == null ? this.getParent().getParent().getTitle() : this.getTitle();
                break;
            }
            case TRACKTITLE: {
                string = this.getTitle();
                break;
            }
            case TRACKNUMBER: {
                string = Integer.toString(this.getNumber());
                break;
            }
            default: {
                string = this.getParent().getParent().getMetaData(metaDataField);
            }
        }
        logger.exiting(TrackData.class.getCanonicalName(), "getMetaData()", string);
        return string;
    }

    public String getDataType() {
        logger.entering(TrackData.class.getCanonicalName(), "getDataType()");
        logger.exiting(TrackData.class.getCanonicalName(), "getDataType()", this.dataType);
        return this.dataType;
    }

    public void setDataType(String string) {
        logger.entering(TrackData.class.getCanonicalName(), "setDataType(String)", string);
        this.dataType = string;
        logger.exiting(TrackData.class.getCanonicalName(), "setDataType(String)");
    }

    public String getIsrcCode() {
        logger.entering(TrackData.class.getCanonicalName(), "getIsrcCode()");
        logger.exiting(TrackData.class.getCanonicalName(), "getIsrcCode()", this.isrcCode);
        return this.isrcCode;
    }

    public void setIsrcCode(String string) {
        logger.entering(TrackData.class.getCanonicalName(), "setIsrcCode(String)", string);
        this.isrcCode = string;
        logger.exiting(TrackData.class.getCanonicalName(), "setIsrcCode(String)");
    }

    public int getNumber() {
        logger.entering(TrackData.class.getCanonicalName(), "getNumber()");
        logger.exiting(TrackData.class.getCanonicalName(), "getNumber()", this.number);
        return this.number;
    }

    public void setNumber(int n) {
        logger.entering(TrackData.class.getCanonicalName(), "setNumber(int)", n);
        this.number = n;
        logger.exiting(TrackData.class.getCanonicalName(), "setNumber(int)");
    }

    public String getPerformer() {
        logger.entering(TrackData.class.getCanonicalName(), "getPerformer()");
        logger.exiting(TrackData.class.getCanonicalName(), "getPerformer()", this.performer);
        return this.performer;
    }

    public void setPerformer(String string) {
        logger.entering(TrackData.class.getCanonicalName(), "setPerformer(String)", string);
        this.performer = string;
        logger.exiting(TrackData.class.getCanonicalName(), "setPerformer(String)");
    }

    public Position getPostgap() {
        logger.entering(TrackData.class.getCanonicalName(), "getPostgap()");
        logger.exiting(TrackData.class.getCanonicalName(), "getPostgap()", this.postgap);
        return this.postgap;
    }

    public void setPostgap(Position position) {
        logger.entering(TrackData.class.getCanonicalName(), "setPostgap(Position)", position);
        this.postgap = position;
        logger.exiting(TrackData.class.getCanonicalName(), "setPostgap(Position)");
    }

    public Position getPregap() {
        logger.entering(TrackData.class.getCanonicalName(), "getPregap()");
        logger.exiting(TrackData.class.getCanonicalName(), "getPregap()", this.pregap);
        return this.pregap;
    }

    public void setPregap(Position position) {
        logger.entering(TrackData.class.getCanonicalName(), "setPregap(Position)", position);
        this.pregap = position;
        logger.exiting(TrackData.class.getCanonicalName(), "setPregap(Position)");
    }

    public String getSongwriter() {
        logger.entering(TrackData.class.getCanonicalName(), "getSongwriter()");
        logger.exiting(TrackData.class.getCanonicalName(), "getSongwriter()", this.songwriter);
        return this.songwriter;
    }

    public void setSongwriter(String string) {
        logger.entering(TrackData.class.getCanonicalName(), "setSongwriter(String)", string);
        this.songwriter = string;
        logger.exiting(TrackData.class.getCanonicalName(), "setSongwriter(String)");
    }

    public String getTitle() {
        logger.entering(TrackData.class.getCanonicalName(), "getTitle()");
        logger.exiting(TrackData.class.getCanonicalName(), "getTitle()", this.title);
        return this.title;
    }

    public void setTitle(String string) {
        logger.entering(TrackData.class.getCanonicalName(), "setTitle(String)", string);
        this.title = string;
        logger.exiting(TrackData.class.getCanonicalName(), "setTitle(String)");
    }

    public Index getIndex(int n) {
        logger.entering(TrackData.class.getCanonicalName(), "getIndex(int)");
        Index index = null;
        for (Index index2 : this.indices) {
            if (index2.getNumber() != n) continue;
            index = index2;
            break;
        }
        logger.exiting(TrackData.class.getCanonicalName(), "getIndex(int)", index);
        return index;
    }

    public List<Index> getIndices() {
        logger.entering(TrackData.class.getCanonicalName(), "getIndices()");
        logger.exiting(TrackData.class.getCanonicalName(), "getIndices()", this.indices);
        return this.indices;
    }

    public Set<String> getFlags() {
        logger.entering(TrackData.class.getCanonicalName(), "getFlags()");
        logger.exiting(TrackData.class.getCanonicalName(), "getFlags()", this.flags);
        return this.flags;
    }

    public FileData getParent() {
        logger.entering(TrackData.class.getCanonicalName(), "getParent()");
        logger.exiting(TrackData.class.getCanonicalName(), "getParent()", this.parent);
        return this.parent;
    }

    public void setParent(FileData fileData) {
        logger.entering(TrackData.class.getCanonicalName(), "setParent(FileData)", fileData);
        this.parent = fileData;
        logger.exiting(TrackData.class.getCanonicalName(), "setParent(FileData)");
    }
}

