/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mediautil.gen.FileFormatException;
import mediautil.gen.Rational;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.IFD;
import mediautil.image.jpeg.LLJTran;

public class TiffExif
extends Exif {
    static final int FAKE_JPEG_OFFSET = 7;

    public TiffExif(InputStream inputStream, byte[] byArray, int n, String string, boolean bl, LLJTran lLJTran) throws FileFormatException {
        this.intel = bl;
        this.motorola = !bl;
        this.is = inputStream;
        this.data = byArray;
        this.offset = n;
        this.name = string;
        this.format = lLJTran;
        this.readInfo();
    }

    public void readInfo() {
        Entry entry;
        this.ifds = new IFD[2];
        this.processAllIFDs();
        if (this.getTagValue(new Integer(514), 0, false) == null && (entry = this.getTagValue(273, true)) != null) {
            this.setTagValue(514, 0, new Entry(4, new Object[]{new Integer((Integer)entry.getValue(0) - this.getThumbnailOffset() + 12)}), false);
        }
        if (this.getTagValue(new Integer(513), 0, false) == null) {
            this.setTagValue(513, 0, new Entry(4, new Object[]{new Integer(this.offset - 6)}), false);
        }
        this.offset = 0;
    }

    public void writeInfo(OutputStream outputStream, int n, String string) throws IOException {
        throw new RuntimeException("writeInfo not supported for TIFF EXIF");
    }

    protected int firstIFD() {
        return this.s2n(2, 4) - this.offset + 7;
    }

    protected int nextIFD(int n) {
        return this.s2n(this.data.length - 4, 4) - this.offset + 7;
    }

    protected void storeIFD(int n, IFD iFD) {
        int n2 = 0;
        try {
            TiffExif.skip(this.is, n - 7);
            this.offset += n - 7;
            this.data = new byte[2];
            this.offset += this.is.read(this.data);
            n2 = this.s2n(0, 2);
            byte[] byArray = new byte[12 * n2 + 4];
            TiffExif.read(this.is, byArray);
            this.offset += byArray.length;
            this.data = byArray;
            byte[] byArray2 = new byte[this.getExifSize(0, n2) - this.offset];
            TiffExif.read(this.is, byArray2);
            this.offset += byArray2.length;
            this.data = byArray;
            for (int i = 0; i < n2; ++i) {
                int n3 = 12 * i;
                int n4 = this.s2n(n3, 2);
                int n5 = this.s2n(n3 + 2, 2);
                if (n5 < 1 || n5 > 10) continue;
                int n6 = TYPELENGTH[n5 - 1];
                int n7 = this.s2n(n3 + 4, 4);
                int n8 = n3 + 8;
                if (n7 * n6 > 4) {
                    n8 = this.s2n(n8, 4) - (this.offset - byArray2.length);
                    this.data = byArray2;
                }
                if (n5 == 2) {
                    try {
                        iFD.addEntry(n4, new Entry(n5, new String(this.data, n8, n7 - 1, "Default")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else {
                    Object[] objectArray = new Object[n7];
                    boolean bl = true;
                    for (int j = 0; j < n7; ++j) {
                        objectArray[j] = n5 % 5 != 0 ? new Integer(this.s2n(n8, n6, bl)) : new Rational(this.s2n(n8, 4, bl), this.s2n(n8 + 4, 4, bl));
                        n8 += n6;
                        if (n4 == 34665 && j == 0 && (Integer)objectArray[0] > 0) {
                            IFD iFD2 = new IFD(n4, n5);
                            this.storeIFD((Integer)objectArray[0] - this.offset + 7, iFD2);
                            iFD.addIFD(iFD2);
                            continue;
                        }
                        iFD.addEntry(n4, new Entry(n5, objectArray));
                    }
                }
                this.data = byArray;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getExifSize(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 12 * i + n;
            if (TYPELENGTH[this.s2n(n5 + 2, 2) - 1] * this.s2n(n5 + 4, 4) <= 4 || n3 >= this.s2n(n5 + 8, 4)) continue;
            n3 = this.s2n(n5 + 8, 4);
            n4 = TYPELENGTH[this.s2n(n5 + 2, 2) - 1] * this.s2n(n5 + 4, 4);
        }
        return n3 + n4;
    }
}

