/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationReader.class);
    private Map<String, Object> logMap = new HashMap<String, Object>();
    private final Configuration configuration;
    private final boolean logOverrides;

    ConfigurationReader(Configuration configuration) {
        this(configuration, false);
    }

    ConfigurationReader(Configuration configuration, boolean logOverrides) {
        this.configuration = configuration;
        this.logOverrides = logOverrides;
    }

    private String quote(Object value) {
        if (value != null && value instanceof String) {
            String s = (String)value;
            return String.format("\"%s\"", s.replace("\"", "\\\""));
        }
        return String.valueOf(value);
    }

    private <T> void log(String key, T value, T def) {
        Object oldValue;
        boolean initialised = false;
        if (!this.logOverrides) {
            return;
        }
        if (!this.logMap.containsKey(key)) {
            this.logMap.put(key, def);
            initialised = true;
        }
        if (ObjectUtils.notEqual(oldValue = this.logMap.get(key), value)) {
            this.logMap.put(key, value);
            if (initialised) {
                logger.debug("Reading {}: default: {}, current: {}", key, this.quote(oldValue), this.quote(value));
            } else {
                logger.debug("Reading {}: default: {}, previous: {}, current: {}", key, this.quote(def), this.quote(oldValue), this.quote(value));
            }
        }
    }

    int getInt(String key, int def) {
        int value;
        try {
            value = this.configuration.getInt(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    long getLong(String key, int def) {
        long value;
        try {
            value = this.configuration.getLong(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    boolean getBoolean(String key, boolean def) {
        boolean value;
        try {
            value = this.configuration.getBoolean(key, def);
        }
        catch (ConversionException e) {
            value = def;
        }
        this.log(key, value, def);
        return value;
    }

    String getString(String key, String def) {
        return this.getNonBlankConfigurationString(key, def);
    }

    List<String> getStringList(String key, String def) {
        List<String> value;
        String stringValue = this.getString(key, def);
        if (stringValue != null) {
            String[] array = stringValue.split(",");
            ArrayList<String> result = new ArrayList<String>(array.length);
            for (String s : array) {
                if (s.trim().length() <= 0) continue;
                result.add(s.trim());
            }
            value = result;
        } else {
            value = Collections.emptyList();
        }
        this.log(key, stringValue, def);
        return value;
    }

    Object getCustomProperty(String property) {
        Object value = this.configuration.getProperty(property);
        this.log(property, value, null);
        return value;
    }

    String getNonBlankConfigurationString(String key, String def) {
        String s = this.configuration.getString(key);
        String value = StringUtils.isNotBlank(s) ? s.trim() : (def != null ? def.trim() : def);
        this.log(key, value, def);
        return value;
    }

    String getPossiblyBlankConfigurationString(String key, String def) {
        String s = this.configuration.getString(key, def);
        String value = s != null ? s.trim() : s;
        this.log(key, value, def);
        return value;
    }
}

