/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jwbroek.cuelib.CueParser;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.TrackData;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.Range;
import net.pms.dlna.RealFile;
import net.pms.encoders.FFmpegAudio;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.Player;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CueFolder
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(CueFolder.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private File playlistfile;
    private boolean valid = true;

    public File getPlaylistfile() {
        return this.playlistfile;
    }

    public CueFolder(File f) {
        this.playlistfile = f;
        this.setLastModified(this.playlistfile.lastModified());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this.playlistfile.getName();
    }

    @Override
    public String getSystemName() {
        return this.playlistfile.getName();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    protected void resolveOnce() {
        if (this.playlistfile.length() < 10000000L) {
            List<FileData> files;
            CueSheet sheet;
            try {
                sheet = CueParser.parse(this.playlistfile);
            }
            catch (IOException e) {
                logger.info("Error in parsing cue: " + e.getMessage());
                return;
            }
            if (sheet != null && (files = sheet.getFileData()).size() > 0) {
                FileData f = files.get(0);
                List<TrackData> tracks = f.getTrackData();
                Player defaultPlayer = null;
                DLNAMediaInfo originalMedia = null;
                ArrayList<RealFile> addedResources = new ArrayList<RealFile>();
                for (int i = 0; i < tracks.size(); ++i) {
                    TrackData track = tracks.get(i);
                    if (i > 0) {
                        double end = this.getTime(track.getIndices().get(0).getPosition());
                        if (addedResources.isEmpty()) {
                            return;
                        }
                        DLNAResource prec = (DLNAResource)addedResources.get(i - 1);
                        int count = 0;
                        while (prec.isFolder() && i + count < addedResources.size()) {
                            prec = (DLNAResource)addedResources.get(i + count);
                            ++count;
                        }
                        prec.getSplitRange().setEnd(end);
                        prec.getMedia().setDuration(prec.getSplitRange().getDuration());
                        logger.debug("Track #" + i + " split range: " + prec.getSplitRange().getStartOrZero() + " - " + prec.getSplitRange().getDuration());
                    }
                    Position start = track.getIndices().get(0).getPosition();
                    RealFile realFile = new RealFile(new File(this.playlistfile.getParentFile(), f.getFile()));
                    this.addChild(realFile);
                    addedResources.add(realFile);
                    if (i > 0 && realFile.getMedia() == null) {
                        realFile.setMedia(new DLNAMediaInfo());
                        realFile.getMedia().setMediaparsed(true);
                    }
                    realFile.resolve();
                    if (i == 0) {
                        originalMedia = realFile.getMedia();
                    }
                    realFile.getSplitRange().setStart(this.getTime(start));
                    realFile.setSplitTrack(i + 1);
                    if (realFile.getPlayer() == null) {
                        if (defaultPlayer == null) {
                            if (realFile.getFormat() == null) {
                                logger.error("No file format known for file \"{}\", assuming it is a video for now.", (Object)realFile.getName());
                                defaultPlayer = new MEncoderVideo(configuration);
                            } else {
                                defaultPlayer = realFile.getFormat().isAudio() ? new FFmpegAudio(configuration) : new MEncoderVideo(configuration);
                            }
                        }
                        realFile.setPlayer(defaultPlayer);
                    }
                    if (realFile.getMedia() == null) continue;
                    try {
                        realFile.setMedia((DLNAMediaInfo)originalMedia.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        logger.info("Error in cloning media info: " + e.getMessage());
                    }
                    if (realFile.getMedia() == null || realFile.getMedia().getFirstAudioTrack() == null) continue;
                    if (realFile.getFormat().isAudio()) {
                        realFile.getMedia().getFirstAudioTrack().setSongname(track.getTitle());
                    } else {
                        realFile.getMedia().getFirstAudioTrack().setSongname("Chapter #" + (i + 1));
                    }
                    realFile.getMedia().getFirstAudioTrack().setTrack(i + 1);
                    realFile.getMedia().setSize(-1L);
                    if (StringUtils.isNotBlank(sheet.getTitle())) {
                        realFile.getMedia().getFirstAudioTrack().setAlbum(sheet.getTitle());
                    }
                    if (StringUtils.isNotBlank(sheet.getPerformer())) {
                        realFile.getMedia().getFirstAudioTrack().setArtist(sheet.getPerformer());
                    }
                    if (!StringUtils.isNotBlank(track.getPerformer())) continue;
                    realFile.getMedia().getFirstAudioTrack().setArtist(track.getPerformer());
                }
                if (tracks.size() > 0 && addedResources.size() > 0) {
                    DLNAResource lastTrack = (DLNAResource)addedResources.get(addedResources.size() - 1);
                    Range.Time lastTrackSplitRange = lastTrack.getSplitRange();
                    DLNAMediaInfo lastTrackMedia = lastTrack.getMedia();
                    if (lastTrackSplitRange != null && lastTrackMedia != null) {
                        lastTrackSplitRange.setEnd(lastTrackMedia.getDurationInSeconds());
                        lastTrackMedia.setDuration(lastTrackSplitRange.getDuration());
                        logger.debug("Track #" + this.childrenNumber() + " split range: " + lastTrackSplitRange.getStartOrZero() + " - " + lastTrackSplitRange.getDuration());
                    }
                }
                PMS.get().storeFileInCache(this.playlistfile, 16);
            }
        }
    }

    private double getTime(Position p) {
        return (double)(p.getMinutes() * 60 + p.getSeconds()) + (double)p.getFrames() / 100.0;
    }
}

