/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import net.pms.dlna.DLNAMediaLang;
import net.pms.formats.v2.AudioProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAMediaAudio
extends DLNAMediaLang
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DLNAMediaAudio.class);
    private AudioProperties audioProperties = new AudioProperties();
    @Deprecated
    public int bitsperSample;
    private int bitRate;
    @Deprecated
    public String sampleFrequency;
    @Deprecated
    public int nrAudioChannels;
    @Deprecated
    public String codecA;
    @Deprecated
    public String album;
    @Deprecated
    public String artist;
    @Deprecated
    public String songname;
    @Deprecated
    public String genre;
    @Deprecated
    public int year;
    @Deprecated
    public int track;
    @Deprecated
    public int delay;
    @Deprecated
    public String flavor;
    @Deprecated
    public String muxingModeAudio;

    public DLNAMediaAudio() {
        this.setBitsperSample(16);
    }

    public int getSampleRate() {
        int sr = 0;
        if (this.getSampleFrequency() != null && this.getSampleFrequency().length() > 0) {
            try {
                sr = Integer.parseInt(this.getSampleFrequency());
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse sample rate from \"" + this.getSampleFrequency() + "\"");
            }
        }
        return sr;
    }

    public boolean isAC3() {
        return this.getCodecA() != null && (this.getCodecA().equalsIgnoreCase("ac3") || this.getCodecA().equalsIgnoreCase("a52") || this.getCodecA().equalsIgnoreCase("liba52"));
    }

    public boolean isTrueHD() {
        return this.getCodecA() != null && this.getCodecA().equalsIgnoreCase("truehd");
    }

    public boolean isDTS() {
        return this.getCodecA() != null && (this.getCodecA().startsWith("dts") || this.getCodecA().equalsIgnoreCase("dca") || this.getCodecA().equalsIgnoreCase("dca (dts)"));
    }

    public boolean isNonPCMEncodedAudio() {
        return this.isAC3() || this.isDTS() || this.isTrueHD();
    }

    public boolean isMP3() {
        return this.getCodecA() != null && this.getCodecA().equalsIgnoreCase("mp3");
    }

    public boolean isAAC() {
        return this.getCodecA() != null && this.getCodecA().equalsIgnoreCase("aac");
    }

    public boolean isVorbis() {
        return this.getCodecA() != null && this.getCodecA().equalsIgnoreCase("vorbis");
    }

    public boolean isWMA() {
        return this.getCodecA() != null && this.getCodecA().startsWith("wm");
    }

    public boolean isMpegAudio() {
        return this.getCodecA() != null && this.getCodecA().equalsIgnoreCase("mp2");
    }

    public boolean isPCM() {
        return this.getCodecA() != null && (this.getCodecA().startsWith("pcm") || this.getCodecA().equals("LPCM"));
    }

    public boolean isLossless() {
        return this.getCodecA() != null && (this.isPCM() || this.getCodecA().startsWith("fla") || this.getCodecA().equals("mlp") || this.getCodecA().equals("wv"));
    }

    public String getAudioCodec() {
        if (this.isAC3()) {
            return "AC3";
        }
        if (this.isDTS()) {
            return "DTS";
        }
        if (this.isTrueHD()) {
            return "TrueHD";
        }
        if (this.isPCM()) {
            return "LPCM";
        }
        if (this.getCodecA() != null && this.getCodecA().equals("vorbis")) {
            return "OGG";
        }
        if (this.getCodecA() != null && this.getCodecA().equals("aac")) {
            return "AAC";
        }
        if (this.getCodecA() != null && this.getCodecA().equals("mp3")) {
            return "MP3";
        }
        if (this.getCodecA() != null && this.getCodecA().startsWith("wm")) {
            return "WMA";
        }
        if (this.getCodecA() != null && this.getCodecA().equals("mp2")) {
            return "Mpeg Audio";
        }
        return this.getCodecA() != null ? this.getCodecA() : "-";
    }

    public String toString() {
        return "Audio: " + this.getAudioCodec() + " / lang: " + this.getLang() + " / flavor: " + this.getFlavor() + " / ID: " + this.getId();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getBitsperSample() {
        return this.bitsperSample;
    }

    public void setBitsperSample(int bitsperSample) {
        this.bitsperSample = bitsperSample;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int bitRate) {
        this.bitRate = bitRate;
    }

    public String getSampleFrequency() {
        return this.sampleFrequency;
    }

    public void setSampleFrequency(String sampleFrequency) {
        this.sampleFrequency = sampleFrequency;
    }

    @Deprecated
    public int getNrAudioChannels() {
        return this.audioProperties.getNumberOfChannels();
    }

    @Deprecated
    public void setNrAudioChannels(int numberOfChannels) {
        this.nrAudioChannels = numberOfChannels;
        this.audioProperties.setNumberOfChannels(numberOfChannels);
    }

    public String getCodecA() {
        return this.codecA;
    }

    public void setCodecA(String codecA) {
        this.codecA = codecA;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getSongname() {
        return this.songname;
    }

    public void setSongname(String songname) {
        this.songname = songname;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int track) {
        this.track = track;
    }

    @Deprecated
    public int getDelay() {
        return this.audioProperties.getAudioDelay();
    }

    @Deprecated
    public void setDelay(int audioDelay) {
        this.delay = audioDelay;
        this.audioProperties.setAudioDelay(audioDelay);
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public String getMuxingModeAudio() {
        return this.muxingModeAudio;
    }

    public void setMuxingModeAudio(String muxingModeAudio) {
        this.muxingModeAudio = muxingModeAudio;
    }

    public AudioProperties getAudioProperties() {
        return this.audioProperties;
    }

    public void setAudioProperties(AudioProperties audioProperties) {
        if (audioProperties == null) {
            throw new IllegalArgumentException("Can't set null AudioProperties.");
        }
        this.audioProperties = audioProperties;
    }
}

