/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.floreysoft.jmte.Engine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DVDISOFile;
import net.pms.dlna.FileTranscodeVirtualFolder;
import net.pms.dlna.IPushOutput;
import net.pms.dlna.InputFile;
import net.pms.dlna.Range;
import net.pms.dlna.RealFile;
import net.pms.dlna.virtual.TranscodeVirtualFolder;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerFactory;
import net.pms.external.AdditionalResourceFolderListener;
import net.pms.external.ExternalFactory;
import net.pms.external.ExternalListener;
import net.pms.external.StartStopListener;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.SizeLimitInputStream;
import net.pms.network.HTTPResource;
import net.pms.util.ImagesUtil;
import net.pms.util.Iso639;
import net.pms.util.MpegUtil;
import net.pms.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DLNAResource
extends HTTPResource
implements Cloneable,
Runnable {
    private final Map<String, Integer> requestIdToRefcount = new HashMap<String, Integer>();
    private boolean resolved;
    private static final int STOP_PLAYING_DELAY = 4000;
    private static final Logger logger = LoggerFactory.getLogger(DLNAResource.class);
    private static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private static final Engine displayNameTemplateEngine = Engine.createCompilingEngine();
    protected static final int MAX_ARCHIVE_ENTRY_SIZE = 10000000;
    protected static final int MAX_ARCHIVE_SIZE_SEEK = 800000000;
    private String displayName;
    @Deprecated
    protected static final String TRANSCODE_FOLDER;
    @Deprecated
    protected int specificType;
    @Deprecated
    protected String id;
    @Deprecated
    protected DLNAResource parent;
    @Deprecated
    protected Format ext;
    private Format format;
    @Deprecated
    protected DLNAMediaInfo media;
    @Deprecated
    protected DLNAMediaAudio media_audio;
    @Deprecated
    protected DLNAMediaSubtitle media_subtitle;
    @Deprecated
    protected long lastmodified;
    private Player player;
    @Deprecated
    protected boolean discovered = false;
    private ProcessWrapper externalProcess;
    @Deprecated
    protected boolean srtFile;
    @Deprecated
    protected int updateId = 1;
    @Deprecated
    public static int systemUpdateId;
    @Deprecated
    protected boolean noName;
    private int nametruncate;
    private DLNAResource first;
    private DLNAResource second;
    @Deprecated
    protected Range.Time splitRange = new Range.Time();
    @Deprecated
    protected int splitTrack;
    @Deprecated
    protected String fakeParentId;
    @Deprecated
    protected RendererConfiguration defaultRenderer;
    private String dlnaspec;
    @Deprecated
    protected boolean avisynth;
    @Deprecated
    protected boolean skipTranscode = false;
    private boolean allChildrenAreFolders = true;
    private String dlnaOrgOpFlags;
    @Deprecated
    protected List<DLNAResource> children;
    @Deprecated
    protected int lastChildrenId = 0;
    @Deprecated
    protected long lastRefreshTime;

    public DLNAResource getParent() {
        return this.parent;
    }

    public void setParent(DLNAResource parent) {
        this.parent = parent;
    }

    protected String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getResourceId() {
        if (this.getId() == null) {
            return null;
        }
        if (this.getParent() != null) {
            return this.getParent().getResourceId() + '$' + this.getId();
        }
        return this.getId();
    }

    protected void setIndexId(int id) {
        this.setId(Integer.toString(id));
    }

    public String getInternalId() {
        return this.getId();
    }

    public boolean isTranscodeFolderAvailable() {
        return true;
    }

    public abstract String getName();

    public abstract String getSystemName();

    public abstract long length();

    public long length(RendererConfiguration mediaRenderer) {
        return this.length();
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract boolean isFolder();

    public String getDlnaContentFeatures() {
        return (this.dlnaspec != null ? this.dlnaspec + ";" : "") + this.getDlnaOrgOpFlags() + ";DLNA.ORG_CI=0;DLNA.ORG_FLAGS=01700000000000000000000000000000";
    }

    public DLNAResource getPrimaryResource() {
        return this.first;
    }

    public DLNAResource getSecondaryResource() {
        return this.second;
    }

    public String getFakeParentId() {
        return this.fakeParentId;
    }

    public void setFakeParentId(String fakeParentId) {
        this.fakeParentId = fakeParentId;
    }

    public String getParentId() {
        if (this.getFakeParentId() != null) {
            return this.getFakeParentId();
        }
        if (this.getParent() != null) {
            return this.getParent().getResourceId();
        }
        return "-1";
    }

    public DLNAResource() {
        this.setSpecificType(8);
        this.setChildren(new ArrayList<DLNAResource>());
        this.setUpdateId(1);
    }

    public DLNAResource(int specificType) {
        this();
        this.setSpecificType(specificType);
    }

    public DLNAResource searchByName(String name) {
        for (DLNAResource child : this.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean isCompatible(RendererConfiguration renderer) {
        return this.getFormat() == null || this.getFormat().isUnknown() || this.getFormat().isVideo() && renderer.isVideoSupported() || this.getFormat().isAudio() && renderer.isAudioSupported() || this.getFormat().isImage() && renderer.isImageSupported();
    }

    public void addChild(DLNAResource child) {
        if (child == null) {
            logger.error("A plugin has attempted to add a null child to " + this.getName());
            logger.debug("Error info:", new NullPointerException("Invalid DLNA resource"));
            return;
        }
        child.setParent(this);
        if (this.getParent() != null) {
            this.setDefaultRenderer(this.getParent().getDefaultRenderer());
        }
        try {
            if (child.isValid()) {
                boolean parserV2;
                logger.trace("Adding " + child.getName() + " / class: " + child.getClass().getName());
                if (this.allChildrenAreFolders && !child.isFolder()) {
                    this.allChildrenAreFolders = false;
                }
                this.addChildInternal(child);
                boolean forceTranscodeV2 = false;
                boolean bl = parserV2 = child.getMedia() != null && this.getDefaultRenderer() != null && this.getDefaultRenderer().isMediaParserV2();
                if (parserV2) {
                    String mimeType = this.getDefaultRenderer().getFormatConfiguration().match(child.getMedia());
                    if (mimeType != null) {
                        child.getMedia().setMimeType(mimeType.equals("MIMETYPE_AUTO") ? child.getMedia().getMimeType() : mimeType);
                    } else {
                        forceTranscodeV2 = true;
                    }
                }
                if (child.getFormat() != null) {
                    this.setSkipTranscode(child.getFormat().skip(configuration.getDisableTranscodeForExtensions(), this.getDefaultRenderer() != null ? this.getDefaultRenderer().getStreamedExtensions() : null));
                }
                if (child.getFormat() != null && (child.getFormat().transcodable() || parserV2) && (child.getMedia() == null || parserV2)) {
                    if (!parserV2) {
                        child.setMedia(new DLNAMediaInfo());
                    }
                    Player player = null;
                    String name = this.getName();
                    for (Player p : PlayerFactory.getAllPlayers()) {
                        String end = "[" + p.id() + "]";
                        if (name.endsWith(end)) {
                            this.nametruncate = name.lastIndexOf(end);
                            player = p;
                            logger.trace("Selecting player based on name end");
                            break;
                        }
                        if (this.getParent() == null || !this.getParent().getName().endsWith(end)) continue;
                        this.getParent().nametruncate = this.getParent().getName().lastIndexOf(end);
                        player = p;
                        logger.trace("Selecting player based on parent name end");
                        break;
                    }
                    if (player == null) {
                        player = PlayerFactory.getPlayer(child);
                    }
                    if (player != null && !this.allChildrenAreFolders) {
                        TranscodeVirtualFolder transcodeFolder;
                        boolean forceTranscode = false;
                        if (child.getFormat() != null) {
                            forceTranscode = child.getFormat().skip(configuration.getForceTranscodeForExtensions(), this.getDefaultRenderer() != null ? this.getDefaultRenderer().getTranscodedExtensions() : null);
                        }
                        boolean hasEmbeddedSubs = false;
                        if (child.getMedia() != null) {
                            for (DLNAMediaSubtitle s : child.getMedia().getSubtitleTracksList()) {
                                hasEmbeddedSubs = hasEmbeddedSubs || s.isEmbedded();
                            }
                        }
                        boolean hasSubsToTranscode = false;
                        if (!configuration.isDisableSubtitles()) {
                            hasSubsToTranscode = configuration.isAutoloadExternalSubtitles() && child.isSrtFile() || hasEmbeddedSubs;
                        }
                        boolean isIncompatible = false;
                        if (!child.getFormat().isCompatible(child.getMedia(), this.getDefaultRenderer())) {
                            isIncompatible = true;
                        }
                        if (forceTranscode || !this.isSkipTranscode() && (forceTranscodeV2 || isIncompatible || hasSubsToTranscode)) {
                            child.setPlayer(player);
                            logger.trace("Switching " + child.getName() + " to player " + player.toString() + " for transcoding");
                        }
                        if ((child.getFormat().isVideo() || child.getFormat().isAudio()) && child.isTranscodeFolderAvailable() && (transcodeFolder = this.getTranscodeFolder(true)) != null) {
                            FileTranscodeVirtualFolder fileTranscodeFolder = new FileTranscodeVirtualFolder(child.getName(), null);
                            DLNAResource newChild = child.clone();
                            newChild.setPlayer(player);
                            newChild.setMedia(child.getMedia());
                            fileTranscodeFolder.addChildInternal(newChild);
                            logger.trace("Duplicate " + child.getName() + " with player: " + player.toString());
                            transcodeFolder.addChild(fileTranscodeFolder);
                        }
                        for (ExternalListener listener : ExternalFactory.getExternalListeners()) {
                            if (!(listener instanceof AdditionalResourceFolderListener)) continue;
                            try {
                                ((AdditionalResourceFolderListener)listener).addAdditionalFolder(this, child);
                            }
                            catch (Throwable t) {
                                logger.error("Failed to add additional folder for listener of type: {}", (Object)listener.getClass(), (Object)t);
                            }
                        }
                    } else if (!child.getFormat().isCompatible(child.getMedia(), this.getDefaultRenderer()) && !child.isFolder()) {
                        this.getChildren().remove(child);
                    }
                }
                if (child.getFormat() != null && child.getFormat().getSecondaryFormat() != null && child.getMedia() != null && this.getDefaultRenderer() != null && this.getDefaultRenderer().supportsFormat(child.getFormat().getSecondaryFormat())) {
                    DLNAResource newChild = child.clone();
                    newChild.setFormat(newChild.getFormat().getSecondaryFormat());
                    newChild.first = child;
                    child.second = newChild;
                    if (!newChild.getFormat().isCompatible(newChild.getMedia(), this.getDefaultRenderer())) {
                        Player player = PlayerFactory.getPlayer(newChild);
                        newChild.setPlayer(player);
                    }
                    if (child.getMedia() != null && child.getMedia().isSecondaryFormatValid()) {
                        this.addChild(newChild);
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error adding child: {}", (Object)child.getName(), (Object)t);
            child.setParent(null);
            this.getChildren().remove(child);
        }
    }

    TranscodeVirtualFolder getTranscodeFolder(boolean create) {
        if (!this.isTranscodeFolderAvailable()) {
            return null;
        }
        if (configuration.getHideTranscodeEnabled()) {
            return null;
        }
        for (DLNAResource child : this.getChildren()) {
            if (!(child instanceof TranscodeVirtualFolder)) continue;
            return (TranscodeVirtualFolder)child;
        }
        if (create) {
            TranscodeVirtualFolder transcodeFolder = new TranscodeVirtualFolder(null);
            this.addChildInternal(transcodeFolder);
            return transcodeFolder;
        }
        return null;
    }

    protected synchronized void addChildInternal(DLNAResource child) {
        if (child.getInternalId() != null) {
            logger.info("Node ({}) already has an ID ({}), which is overridden now. The previous parent node was: {}", child.getClass().getName(), child.getResourceId(), child.getParent());
        }
        this.getChildren().add(child);
        child.setParent(this);
        this.setLastChildId(this.getLastChildId() + 1);
        child.setIndexId(this.getLastChildId());
    }

    public synchronized List<DLNAResource> getDLNAResources(String objectId, boolean returnChildren, int start, int count, RendererConfiguration renderer) throws IOException {
        ArrayList<DLNAResource> resources = new ArrayList<DLNAResource>();
        DLNAResource dlna = this.search(objectId, count, renderer);
        if (dlna != null) {
            String systemName = dlna.getSystemName();
            dlna.setDefaultRenderer(renderer);
            if (!returnChildren) {
                resources.add(dlna);
                dlna.refreshChildrenIfNeeded();
            } else {
                dlna.discoverWithRenderer(renderer, count, true);
                if (count == 0) {
                    count = dlna.getChildren().size();
                }
                if (count > 0) {
                    ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(count);
                    int nParallelThreads = 3;
                    if (dlna instanceof DVDISOFile) {
                        nParallelThreads = 1;
                    }
                    ThreadPoolExecutor tpe = new ThreadPoolExecutor(Math.min(count, nParallelThreads), count, 20L, TimeUnit.SECONDS, queue);
                    for (int i = start; i < start + count; ++i) {
                        if (i >= dlna.getChildren().size()) continue;
                        DLNAResource child = dlna.getChildren().get(i);
                        if (child != null) {
                            tpe.execute(child);
                            resources.add(child);
                            continue;
                        }
                        logger.warn("null child at index {} in {}", (Object)i, (Object)systemName);
                    }
                    try {
                        tpe.shutdown();
                        tpe.awaitTermination(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.error("error while shutting down thread pool executor for " + systemName, e);
                    }
                    logger.trace("End of analysis for {}", (Object)systemName);
                }
            }
        }
        return resources;
    }

    protected void refreshChildrenIfNeeded() {
        if (this.isDiscovered() && this.isRefreshNeeded()) {
            this.refreshChildren();
            this.notifyRefresh();
        }
    }

    protected void notifyRefresh() {
        this.setLastRefreshTime(System.currentTimeMillis());
        this.setUpdateId(this.getUpdateId() + 1);
        DLNAResource.setSystemUpdateId(DLNAResource.getSystemUpdateId() + 1);
    }

    protected final void discoverWithRenderer(RendererConfiguration renderer, int count, boolean forced) {
        if (!this.isDiscovered()) {
            this.discoverChildren();
            boolean ready = renderer.isMediaParserV2() && renderer.isDLNATreeHack() ? this.analyzeChildren(count) : this.analyzeChildren(-1);
            if (!renderer.isMediaParserV2() || ready) {
                this.setDiscovered(true);
            }
            this.notifyRefresh();
        } else {
            logger.trace("discover {} refresh forced: {}", (Object)this.getResourceId(), (Object)forced);
            if (forced) {
                if (this.refreshChildren()) {
                    this.notifyRefresh();
                }
            } else if (this.isRefreshNeeded()) {
                this.doRefreshChildren();
                this.notifyRefresh();
            }
        }
    }

    @Override
    public void run() {
        if (this.first == null) {
            this.resolve();
            if (this.second != null) {
                this.second.resolve();
            }
        }
    }

    public DLNAResource search(String searchId, int count, RendererConfiguration renderer) {
        if (this.getId() != null && searchId != null) {
            String[] indexPath = searchId.split("\\$", 2);
            if (this.getId().equals(indexPath[0])) {
                if (indexPath.length == 1 || indexPath[1].length() == 0) {
                    return this;
                }
                this.discoverWithRenderer(renderer, count, false);
                for (DLNAResource file : this.getChildren()) {
                    DLNAResource found = file.search(indexPath[1], count, renderer);
                    if (found == null) continue;
                    return found;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    public void discoverChildren() {
    }

    public boolean analyzeChildren(int count) {
        return true;
    }

    public void doRefreshChildren() {
    }

    public boolean isRefreshNeeded() {
        return false;
    }

    public boolean refreshChildren() {
        if (this.isRefreshNeeded()) {
            this.doRefreshChildren();
            return true;
        }
        return false;
    }

    @Deprecated
    protected void checktype() {
        this.resolveFormat();
    }

    protected void resolveFormat() {
        if (this.getFormat() == null) {
            this.setFormat(FormatFactory.getAssociatedFormat(this.getSystemName()));
        }
        if (this.getFormat() != null && this.getFormat().isUnknown()) {
            this.getFormat().setType(this.getSpecificType());
        }
    }

    protected void resolveOnce() {
    }

    public synchronized void resolve() {
        if (!this.resolved) {
            this.resolveOnce();
            this.resolved = true;
        }
    }

    public String getDisplayName() {
        return this.getDisplayName(this.getDefaultRenderer());
    }

    private boolean anyStringIsNotBlank(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isNotBlank(string)) continue;
            return true;
        }
        return false;
    }

    protected void finalizeDisplayNameVars(Map<String, Object> vars) {
    }

    public String getDisplayName(RendererConfiguration renderer) {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.getSplitRange().isEndLimitAvailable()) {
            this.displayName = ">> " + DLNAMediaInfo.getDurationString(this.getSplitRange().getStart());
            return this.displayName;
        }
        if (this.isAvisynth()) {
            this.displayName = (this.getPlayer() != null ? "[" + this.getPlayer().name() : "") + " + AviSynth]";
            return this.displayName;
        }
        String audioLangFullName = "";
        String audioLangShortName = "";
        String audioFlavor = "";
        String audioCodec = "";
        String dvdTrackDuration = "";
        String engineFullName = "";
        String engineShortName = "";
        String filenameWithExtension = "";
        String filenameWithoutExtension = "";
        String subLangFullName = "";
        String subLangShortName = "";
        String subType = "";
        String subFlavor = "";
        String externalSubs = "";
        boolean useShortFormat = this.isNoName();
        String template = renderer != null ? (useShortFormat ? renderer.getShortFilenameFormat() : renderer.getLongFilenameFormat()) : (useShortFormat ? configuration.getShortFilenameFormat() : configuration.getLongFilenameFormat());
        if (!this.isNoName()) {
            filenameWithExtension = this.getName();
            filenameWithoutExtension = FilenameUtils.getBaseName(filenameWithExtension);
            if (this instanceof RealFile && configuration.isHideExtensions() && !this.isFolder()) {
                filenameWithExtension = filenameWithoutExtension;
            }
        }
        if (this.isNoName() || !configuration.isHideEngineNames()) {
            if (this.getPlayer() != null) {
                engineFullName = this.getPlayer().name();
                engineShortName = StringUtil.abbreviate(engineFullName);
            } else if (this.isNoName()) {
                engineFullName = Messages.getString("DLNAResource.1");
                engineShortName = Messages.getString("DLNAResource.2");
            }
        }
        if (renderer != null && renderer.isShowDVDTitleDuration() && this.getMedia() != null && this.getMedia().getDvdtrack() > 0) {
            dvdTrackDuration = this.getMedia().getDurationString();
        }
        if (this.isSrtFile() && this.getMediaAudio() == null && this.getMediaSubtitle() == null && (this.getPlayer() == null || this.getPlayer().isExternalSubtitlesSupported())) {
            externalSubs = Messages.getString("DLNAResource.0");
        }
        if (this.getMediaAudio() != null) {
            audioCodec = this.getMediaAudio().getAudioCodec();
            audioLangFullName = this.getMediaAudio().getLangFullName();
            audioLangShortName = this.getMediaAudio().getLang();
            if (this.getMediaAudio().getFlavor() != null && renderer != null && renderer.isShowAudioMetadata()) {
                audioFlavor = this.getMediaAudio().getFlavor();
            }
        }
        if (this.getMediaSubtitle() != null && this.getMediaSubtitle().getId() != -1) {
            subType = this.getMediaSubtitle().getType().getDescription();
            subLangFullName = this.getMediaSubtitle().getLangFullName();
            subLangShortName = this.getMediaSubtitle().getLang();
            if (this.getMediaSubtitle().getFlavor() != null && renderer != null && renderer.isShowSubMetadata()) {
                subFlavor = this.getMediaSubtitle().getFlavor();
            }
        }
        boolean isFolder = this.isFolder();
        boolean extra = this.anyStringIsNotBlank(dvdTrackDuration, engineShortName, engineFullName, externalSubs, subType);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("lt", "<");
        vars.put("gt", ">");
        vars.put("aLabel", Messages.getString("DLNAResource.3"));
        vars.put("sLabel", Messages.getString("DLNAResource.4"));
        vars.put("aCodec", audioCodec);
        vars.put("aFlavor", audioFlavor);
        vars.put("aFull", audioLangFullName);
        vars.put("aShort", audioLangShortName);
        vars.put("dvdLen", dvdTrackDuration);
        vars.put("eFull", engineFullName);
        vars.put("eShort", engineShortName);
        vars.put("fFull", filenameWithExtension);
        vars.put("fShort", filenameWithoutExtension);
        vars.put("sExt", externalSubs);
        vars.put("sFlavor", subFlavor);
        vars.put("sFull", subLangFullName);
        vars.put("sShort", subLangShortName);
        vars.put("sType", subType);
        vars.put("extra", extra);
        vars.put("isFile", !isFolder);
        vars.put("isFolder", isFolder);
        this.finalizeDisplayNameVars(vars);
        this.displayName = displayNameTemplateEngine.transform(template, vars);
        this.displayName = this.displayName.replaceAll("\\s+", " ");
        this.displayName = this.displayName.trim();
        return this.displayName;
    }

    protected String getFileURL() {
        return this.getURL("");
    }

    protected String getThumbnailURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(PMS.get().getServer().getURL());
        sb.append("/images/");
        String id = null;
        if (this.getMediaAudio() != null) {
            id = this.getMediaAudio().getLang();
        }
        if (this.getMediaSubtitle() != null && this.getMediaSubtitle().getId() != -1) {
            id = this.getMediaSubtitle().getLang();
        }
        if ((this.getMediaSubtitle() != null || this.getMediaAudio() != null) && StringUtils.isBlank(id)) {
            id = "und";
        }
        if (id != null) {
            String code = Iso639.getISO639_2Code(id.toLowerCase());
            sb.append("codes/").append(code).append(".png");
            return sb.toString();
        }
        if (this.isAvisynth()) {
            sb.append("logo-avisynth.png");
            return sb.toString();
        }
        return this.getURL("thumbnail0000");
    }

    protected String getURL(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(PMS.get().getServer().getURL());
        sb.append("/get/");
        sb.append(this.getResourceId());
        sb.append("/");
        sb.append(prefix);
        sb.append(DLNAResource.encode(this.getName()));
        return sb.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Caught exception", e);
            return "";
        }
    }

    public int childrenNumber() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.getChildren().size();
    }

    protected DLNAResource clone() {
        DLNAResource o = null;
        try {
            o = (DLNAResource)super.clone();
            o.setId(null);
            o.displayName = null;
            o.resolved = false;
        }
        catch (CloneNotSupportedException e) {
            logger.error(null, e);
        }
        return o;
    }

    @Deprecated
    public String getFlags() {
        return this.getDlnaOrgOpFlags();
    }

    private String getDlnaOrgOpFlags() {
        return "DLNA.ORG_OP=" + this.dlnaOrgOpFlags;
    }

    public final String toString(RendererConfiguration mediaRenderer) {
        String uclass;
        DLNAMediaAudio firstAudioTrack;
        StringBuilder sb = new StringBuilder();
        if (this.isFolder()) {
            StringUtil.openTag(sb, "container");
        } else {
            StringUtil.openTag(sb, "item");
        }
        StringUtil.addAttribute(sb, "id", this.getResourceId());
        if (this.isFolder()) {
            if (!this.isDiscovered() && this.childrenNumber() == 0) {
                StringUtil.addAttribute(sb, "childCount", 1);
            } else {
                StringUtil.addAttribute(sb, "childCount", this.childrenNumber());
            }
        }
        StringUtil.addAttribute(sb, "parentID", this.getParentId());
        StringUtil.addAttribute(sb, "restricted", "true");
        StringUtil.endTag(sb);
        DLNAMediaAudio dLNAMediaAudio = firstAudioTrack = this.getMedia() != null ? this.getMedia().getFirstAudioTrack() : null;
        if (firstAudioTrack != null && StringUtils.isNotBlank(firstAudioTrack.getSongname())) {
            StringUtil.addXMLTagAndAttribute(sb, "dc:title", StringUtil.encodeXML(firstAudioTrack.getSongname() + (this.getPlayer() != null && !configuration.isHideEngineNames() ? " [" + this.getPlayer().name() + "]" : "")));
        } else {
            StringUtil.addXMLTagAndAttribute(sb, "dc:title", StringUtil.encodeXML(this.isFolder() || this.getPlayer() == null ? this.getDisplayName(mediaRenderer) : mediaRenderer.getUseSameExtension(this.getDisplayName(mediaRenderer))));
        }
        if (firstAudioTrack != null) {
            if (StringUtils.isNotBlank(firstAudioTrack.getAlbum())) {
                StringUtil.addXMLTagAndAttribute(sb, "upnp:album", StringUtil.encodeXML(firstAudioTrack.getAlbum()));
            }
            if (StringUtils.isNotBlank(firstAudioTrack.getArtist())) {
                StringUtil.addXMLTagAndAttribute(sb, "upnp:artist", StringUtil.encodeXML(firstAudioTrack.getArtist()));
                StringUtil.addXMLTagAndAttribute(sb, "dc:creator", StringUtil.encodeXML(firstAudioTrack.getArtist()));
            }
            if (StringUtils.isNotBlank(firstAudioTrack.getGenre())) {
                StringUtil.addXMLTagAndAttribute(sb, "upnp:genre", StringUtil.encodeXML(firstAudioTrack.getGenre()));
            }
            if (firstAudioTrack.getTrack() > 0) {
                StringUtil.addXMLTagAndAttribute(sb, "upnp:originalTrackNumber", "" + firstAudioTrack.getTrack());
            }
        }
        if (!this.isFolder()) {
            int indexCount = 1;
            if (mediaRenderer.isDLNALocalizationRequired()) {
                indexCount = this.getDLNALocalesCount();
            }
            for (int c = 0; c < indexCount; ++c) {
                StringUtil.openTag(sb, "res");
                this.dlnaOrgOpFlags = "01";
                if (mediaRenderer.isSeekByTime() && this.getPlayer() != null && this.getPlayer().isTimeSeekable()) {
                    this.dlnaOrgOpFlags = mediaRenderer.isSeekByTimeExclusive() ? "10" : "11";
                }
                StringUtil.addAttribute(sb, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
                String mime = this.getRendererMimeType(this.mimeType(), mediaRenderer);
                if (mime == null) {
                    mime = "video/mpeg";
                }
                this.dlnaspec = null;
                if (mediaRenderer.isDLNAOrgPNUsed()) {
                    if (mediaRenderer.isPS3()) {
                        if (mime.equals("video/x-divx")) {
                            this.dlnaspec = "DLNA.ORG_PN=AVI";
                        } else if (mime.equals("video/x-ms-wmv") && this.getMedia() != null && this.getMedia().getHeight() > 700) {
                            this.dlnaspec = "DLNA.ORG_PN=WMVHIGH_PRO";
                        }
                    } else if (mime.equals("video/mpeg")) {
                        this.dlnaspec = "DLNA.ORG_PN=" + this.getMPEG_PS_PALLocalizedValue(c);
                        if (this.getPlayer() != null) {
                            boolean mpegTsMux = "tsmuxer".equals(this.getPlayer().id()) || "vlcvideo".equals(this.getPlayer().id());
                            boolean isMuxableResult = this.getMedia().isMuxable(mediaRenderer);
                            if (!mpegTsMux) {
                                boolean bl = mpegTsMux = "mencoder".equals(this.getPlayer().id()) && mediaRenderer.isTranscodeToMPEGTSAC3();
                            }
                            if (mpegTsMux) {
                                this.dlnaspec = "DLNA.ORG_PN=" + this.getMPEG_TS_SD_EU_ISOLocalizedValue(c);
                                if (this.getMedia().isH264() && !"vlcvideo".equals(this.getPlayer().id()) && isMuxableResult) {
                                    this.dlnaspec = "DLNA.ORG_PN=AVC_TS_HD_24_AC3_ISO";
                                }
                            }
                        } else if (this.getMedia() != null && this.getMedia().isMpegTS()) {
                            this.dlnaspec = "DLNA.ORG_PN=" + this.getMPEG_TS_SD_EULocalizedValue(c);
                            if (this.getMedia().isH264()) {
                                this.dlnaspec = "DLNA.ORG_PN=AVC_TS_HD_50_AC3";
                            }
                        }
                    } else if (mime.equals("video/vnd.dlna.mpeg-tts")) {
                        this.dlnaspec = "DLNA.ORG_PN=" + this.getMPEG_TS_SD_EULocalizedValue(c);
                    } else if (mime.equals("image/jpeg")) {
                        this.dlnaspec = "DLNA.ORG_PN=JPEG_LRG";
                    } else if (mime.equals("audio/mpeg")) {
                        this.dlnaspec = "DLNA.ORG_PN=MP3";
                    } else if (mime.substring(0, 9).equals("audio/L16") || mime.equals("audio/wav")) {
                        this.dlnaspec = "DLNA.ORG_PN=LPCM";
                    }
                    if (this.dlnaspec != null) {
                        this.dlnaspec = "DLNA.ORG_PN=" + mediaRenderer.getDLNAPN(this.dlnaspec.substring(12));
                    }
                }
                String tempString = "http-get:*:" + mime + ":" + (this.dlnaspec != null ? this.dlnaspec + ";" : "") + this.getDlnaOrgOpFlags();
                StringUtil.addAttribute(sb, "protocolInfo", tempString);
                if (this.getFormat() != null && this.getFormat().isVideo() && this.getMedia() != null && this.getMedia().isMediaparsed()) {
                    if (this.getPlayer() == null && this.getMedia() != null) {
                        StringUtil.addAttribute(sb, "size", this.getMedia().getSize());
                    } else {
                        long transcoded_size = mediaRenderer.getTranscodedSize();
                        if (transcoded_size != 0L) {
                            StringUtil.addAttribute(sb, "size", transcoded_size);
                        }
                    }
                    if (this.getMedia().getDuration() != null) {
                        if (this.getSplitRange().isEndLimitAvailable()) {
                            StringUtil.addAttribute(sb, "duration", DLNAMediaInfo.getDurationString(this.getSplitRange().getDuration()));
                        } else {
                            StringUtil.addAttribute(sb, "duration", this.getMedia().getDurationString());
                        }
                    }
                    if (this.getMedia().getResolution() != null) {
                        StringUtil.addAttribute(sb, "resolution", this.getMedia().getResolution());
                    }
                    StringUtil.addAttribute(sb, "bitrate", this.getMedia().getRealVideoBitrate());
                    if (firstAudioTrack != null) {
                        if (firstAudioTrack.getAudioProperties().getNumberOfChannels() > 0) {
                            StringUtil.addAttribute(sb, "nrAudioChannels", firstAudioTrack.getAudioProperties().getNumberOfChannels());
                        }
                        if (firstAudioTrack.getSampleFrequency() != null) {
                            StringUtil.addAttribute(sb, "sampleFrequency", firstAudioTrack.getSampleFrequency());
                        }
                    }
                } else if (this.getFormat() != null && this.getFormat().isImage()) {
                    if (this.getMedia() != null && this.getMedia().isMediaparsed()) {
                        StringUtil.addAttribute(sb, "size", this.getMedia().getSize());
                        if (this.getMedia().getResolution() != null) {
                            StringUtil.addAttribute(sb, "resolution", this.getMedia().getResolution());
                        }
                    } else {
                        StringUtil.addAttribute(sb, "size", this.length());
                    }
                } else if (this.getFormat() != null && this.getFormat().isAudio()) {
                    if (this.getMedia() != null && this.getMedia().isMediaparsed()) {
                        StringUtil.addAttribute(sb, "bitrate", this.getMedia().getBitrate());
                        if (this.getMedia().getDuration() != null) {
                            StringUtil.addAttribute(sb, "duration", DLNAMediaInfo.getDurationString(this.getMedia().getDuration()));
                        }
                        if (firstAudioTrack != null && firstAudioTrack.getSampleFrequency() != null) {
                            StringUtil.addAttribute(sb, "sampleFrequency", firstAudioTrack.getSampleFrequency());
                        }
                        if (firstAudioTrack != null) {
                            StringUtil.addAttribute(sb, "nrAudioChannels", firstAudioTrack.getAudioProperties().getNumberOfChannels());
                        }
                        if (this.getPlayer() == null) {
                            StringUtil.addAttribute(sb, "size", this.getMedia().getSize());
                        } else if (firstAudioTrack != null) {
                            int na;
                            int defaultFrequency;
                            int n = defaultFrequency = mediaRenderer.isTranscodeAudioTo441() ? 44100 : 48000;
                            if (!configuration.isAudioResample()) {
                                try {
                                    defaultFrequency = firstAudioTrack.getSampleRate();
                                }
                                catch (Exception e) {
                                    logger.debug("Caught exception", e);
                                }
                            }
                            if ((na = firstAudioTrack.getAudioProperties().getNumberOfChannels()) > 2) {
                                na = 2;
                            }
                            int finalSize = (int)(this.getMedia().getDurationInSeconds() * (double)defaultFrequency * 2.0 * (double)na);
                            logger.trace("Calculated size for {}: {}", (Object)this.getSystemName(), (Object)finalSize);
                            StringUtil.addAttribute(sb, "size", finalSize);
                        }
                    } else {
                        StringUtil.addAttribute(sb, "size", this.length());
                    }
                } else {
                    StringUtil.addAttribute(sb, "size", 0x7FFFFFFF7FFFFFFFL);
                    StringUtil.addAttribute(sb, "duration", "09:59:59");
                    StringUtil.addAttribute(sb, "bitrate", "1000000");
                }
                StringUtil.endTag(sb);
                sb.append(this.getFileURL());
                StringUtil.closeTag(sb, "res");
            }
        }
        this.appendThumbnail(mediaRenderer, sb);
        if (this.getLastModified() > 0L) {
            StringUtil.addXMLTagAndAttribute(sb, "dc:date", sdfDate.format(new Date(this.getLastModified())));
        }
        if (this.first != null && this.getMedia() != null && !this.getMedia().isSecondaryFormatValid()) {
            uclass = "dummy";
        } else if (this.isFolder()) {
            uclass = "object.container.storageFolder";
            boolean xbox = mediaRenderer.isXBOX();
            if (xbox && this.getFakeParentId() != null && this.getFakeParentId().equals("7")) {
                uclass = "object.container.album.musicAlbum";
            } else if (xbox && this.getFakeParentId() != null && this.getFakeParentId().equals("6")) {
                uclass = "object.container.person.musicArtist";
            } else if (xbox && this.getFakeParentId() != null && this.getFakeParentId().equals("5")) {
                uclass = "object.container.genre.musicGenre";
            } else if (xbox && this.getFakeParentId() != null && this.getFakeParentId().equals("F")) {
                uclass = "object.container.playlistContainer";
            }
        } else {
            uclass = this.getFormat() != null && this.getFormat().isVideo() ? "object.item.videoItem" : (this.getFormat() != null && this.getFormat().isImage() ? "object.item.imageItem.photo" : (this.getFormat() != null && this.getFormat().isAudio() ? "object.item.audioItem.musicTrack" : "object.item.videoItem"));
        }
        StringUtil.addXMLTagAndAttribute(sb, "upnp:class", uclass);
        if (this.isFolder()) {
            StringUtil.closeTag(sb, "container");
        } else {
            StringUtil.closeTag(sb, "item");
        }
        return sb.toString();
    }

    private void appendThumbnail(RendererConfiguration mediaRenderer, StringBuilder sb) {
        boolean addThumbnailAsResElement;
        String thumbURL = this.getThumbnailURL();
        boolean bl = addThumbnailAsResElement = this.isFolder() || mediaRenderer.getThumbNailAsResource() || mediaRenderer.isForceJPGThumbnails();
        if (StringUtils.isNotBlank(thumbURL)) {
            if (addThumbnailAsResElement) {
                StringUtil.openTag(sb, "res");
                if (this.getThumbnailContentType().equals("image/png") && !mediaRenderer.isForceJPGThumbnails()) {
                    StringUtil.addAttribute(sb, "protocolInfo", "http-get:*:image/png:DLNA.ORG_PN=PNG_TN");
                } else {
                    StringUtil.addAttribute(sb, "protocolInfo", "http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_TN");
                }
                StringUtil.endTag(sb);
                sb.append(thumbURL);
                StringUtil.closeTag(sb, "res");
            } else {
                StringUtil.openTag(sb, "upnp:albumArtURI");
                StringUtil.addAttribute(sb, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
                if (this.getThumbnailContentType().equals("image/png")) {
                    StringUtil.addAttribute(sb, "dlna:profileID", "PNG_TN");
                } else {
                    StringUtil.addAttribute(sb, "dlna:profileID", "JPEG_TN");
                }
                StringUtil.endTag(sb);
                sb.append(thumbURL);
                StringUtil.closeTag(sb, "upnp:albumArtURI");
            }
        }
    }

    private String getRequestId(String rendererId) {
        return String.format("%s|%x|%s", rendererId, this.hashCode(), this.getSystemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlaying(final String rendererId) {
        String requestId = this.getRequestId(rendererId);
        Map<String, Integer> map = this.requestIdToRefcount;
        synchronized (map) {
            Integer temp = this.requestIdToRefcount.get(requestId);
            if (temp == null) {
                temp = 0;
            }
            Integer refCount = temp;
            this.requestIdToRefcount.put(requestId, refCount + 1);
            if (refCount == 0) {
                final DLNAResource self = this;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InetAddress rendererIpAddress = InetAddress.getByName(rendererId);
                            RendererConfiguration renderer = RendererConfiguration.getRendererConfigurationBySocketAddress(rendererIpAddress);
                            String rendererName = "unknown renderer";
                            try {
                                rendererName = renderer.getRendererName();
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                            logger.info("Started sending {} to {} on {}", DLNAResource.this.getSystemName(), rendererName, rendererId);
                        }
                        catch (UnknownHostException ex) {
                            logger.debug("" + ex);
                        }
                        for (final ExternalListener listener : ExternalFactory.getExternalListeners()) {
                            if (!(listener instanceof StartStopListener)) continue;
                            Runnable fireStartStopEvent = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ((StartStopListener)listener).nowPlaying(DLNAResource.this.getMedia(), self);
                                    }
                                    catch (Throwable t) {
                                        logger.error("Notification of startPlaying event failed for StartStopListener {}", (Object)listener.getClass(), (Object)t);
                                    }
                                }
                            };
                            new Thread(fireStartStopEvent, "StartPlaying Event for " + listener.name()).start();
                        }
                    }
                };
                new Thread(r, "StartPlaying Event").start();
            }
        }
    }

    public void stopPlaying(final String rendererId) {
        final DLNAResource self = this;
        final String requestId = this.getRequestId(rendererId);
        Runnable defer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    logger.error("stopPlaying sleep interrupted", e);
                }
                Map map = DLNAResource.this.requestIdToRefcount;
                synchronized (map) {
                    final Integer refCount = (Integer)DLNAResource.this.requestIdToRefcount.get(requestId);
                    assert (refCount != null);
                    assert (refCount > 0);
                    DLNAResource.this.requestIdToRefcount.put(requestId, refCount - 1);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (refCount == 1) {
                                try {
                                    InetAddress rendererIpAddress = InetAddress.getByName(rendererId);
                                    RendererConfiguration renderer = RendererConfiguration.getRendererConfigurationBySocketAddress(rendererIpAddress);
                                    String rendererName = "unknown renderer";
                                    try {
                                        rendererName = renderer.getRendererName();
                                    }
                                    catch (NullPointerException e) {
                                        // empty catch block
                                    }
                                    logger.info("Stopped sending {} to {} on {}", DLNAResource.this.getSystemName(), rendererName, rendererId);
                                }
                                catch (UnknownHostException ex) {
                                    logger.debug("" + ex);
                                }
                                PMS.get().getFrame().setStatusLine("");
                                for (final ExternalListener listener : ExternalFactory.getExternalListeners()) {
                                    if (!(listener instanceof StartStopListener)) continue;
                                    Runnable fireStartStopEvent = new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                ((StartStopListener)listener).donePlaying(DLNAResource.this.getMedia(), self);
                                            }
                                            catch (Throwable t) {
                                                logger.error("Notification of donePlaying event failed for StartStopListener {}", (Object)listener.getClass(), (Object)t);
                                            }
                                        }
                                    };
                                    new Thread(fireStartStopEvent, "StopPlaying Event for " + listener.name()).start();
                                }
                            }
                        }
                    };
                    new Thread(r, "StopPlaying Event").start();
                }
            }
        };
        new Thread(defer, "StopPlaying Event Deferrer").start();
    }

    public InputStream getInputStream(Range range, RendererConfiguration mediarenderer) throws IOException {
        int used_bit_rated;
        logger.trace("Asked stream chunk : " + range + " of " + this.getName() + " and player " + this.getPlayer());
        boolean timeseek_auto = false;
        int cbr_video_bitrate = mediarenderer.getCBRVideoBitrate();
        long low = range.isByteRange() && range.isStartOffsetAvailable() ? range.asByteRange().getStart() : 0L;
        long high = range.isByteRange() && range.isEndLimitAvailable() ? range.asByteRange().getEnd() : -1L;
        Range.Time timeRange = range.createTimeRange();
        if (this.getPlayer() != null && low > 0L && cbr_video_bitrate > 0 && low > (long)(used_bit_rated = (int)((double)((cbr_video_bitrate + 256) * 1024 / 8) * 1.04))) {
            timeRange.setStart(Double.valueOf(low / (long)used_bit_rated));
            low = 0L;
            if (timeRange.getStartOrZero() > this.getMedia().getDurationInSeconds()) {
                return null;
            }
            int rewind_secs = mediarenderer.getByteToTimeseekRewindSeconds();
            timeRange.rewindStart(rewind_secs);
            timeseek_auto = true;
        }
        if (this.getPlayer() == null) {
            InputStream fis;
            if (this instanceof IPushOutput) {
                PipedOutputStream out = new PipedOutputStream();
                InputStream fis2 = new PipedInputStream(out);
                ((IPushOutput)((Object)this)).push(out);
                if (low > 0L) {
                    fis2.skip(low);
                }
                fis2 = this.wrap(fis2, high, low);
                return fis2;
            }
            if (this.getFormat() != null && this.getFormat().isImage() && this.getMedia() != null && this.getMedia().getOrientation() > 1 && mediarenderer.isAutoRotateBasedOnExif()) {
                fis = ImagesUtil.getAutoRotateInputStreamImage(this.getInputStream(), this.getMedia().getOrientation());
                if (fis == null) {
                    fis = this.getInputStream();
                }
            } else {
                fis = this.getInputStream();
            }
            if (fis != null) {
                if (low > 0L) {
                    fis.skip(low);
                }
                fis = this.wrap(fis, high, low);
                if (timeRange.getStartOrZero() > 0.0 && this instanceof RealFile) {
                    fis.skip(MpegUtil.getPositionForTimeInMpeg(((RealFile)this).getFile(), (int)timeRange.getStartOrZero()));
                }
            }
            return fis;
        }
        OutputParams params = new OutputParams(configuration);
        params.aid = this.getMediaAudio();
        params.sid = this.getMediaSubtitle();
        params.mediaRenderer = mediarenderer;
        timeRange.limit(this.getSplitRange());
        params.timeseek = timeRange.getStartOrZero();
        params.timeend = timeRange.getEndOrZero();
        params.shift_scr = timeseek_auto;
        if (this instanceof IPushOutput) {
            params.stdin = (IPushOutput)((Object)this);
        }
        if (this.externalProcess == null || this.externalProcess.isDestroyed()) {
            logger.info("Starting transcode/remux of " + this.getName());
            this.externalProcess = this.getPlayer().launchTranscode(this, this.getMedia(), params);
            if (params.waitbeforestart > 0) {
                logger.trace("Sleeping for {} milliseconds", (Object)params.waitbeforestart);
                try {
                    Thread.sleep(params.waitbeforestart);
                }
                catch (InterruptedException e) {
                    logger.error(null, e);
                }
                logger.trace("Finished sleeping for " + params.waitbeforestart + " milliseconds");
            }
        } else if (params.timeseek > 0.0 && this.getMedia() != null && this.getMedia().isMediaparsed() && this.getMedia().getDurationInSeconds() > 0.0) {
            logger.debug("Requesting time seek: " + params.timeseek + " seconds");
            params.minBufferSize = 1.0;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DLNAResource.this.externalProcess.stopProcess();
                }
            };
            new Thread(r, "External Process Stopper").start();
            ProcessWrapper newExternalProcess = this.getPlayer().launchTranscode(this, this.getMedia(), params);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(null, e);
            }
            if (newExternalProcess == null) {
                logger.trace("External process instance is null... sounds not good");
            }
            this.externalProcess = newExternalProcess;
        }
        if (this.externalProcess == null) {
            return null;
        }
        InputStream is = null;
        int timer = 0;
        while (is == null && timer < 10) {
            is = this.externalProcess.getInputStream(low);
            ++timer;
            if (is != null) continue;
            logger.warn("External input stream instance is null... sounds not good, waiting 500ms");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (is == null && this.externalProcess != null && !this.externalProcess.isDestroyed()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    logger.error("External input stream instance is null... stopping process");
                    DLNAResource.this.externalProcess.stopProcess();
                }
            };
            new Thread(r, "Hanging External Process Stopper").start();
        }
        return is;
    }

    private InputStream wrap(InputStream input, long high, long low) {
        if (input != null && high > low) {
            long bytes = high - (low < 0L ? 0L : low) + 1L;
            logger.trace("Using size-limiting stream (" + bytes + " bytes)");
            return new SizeLimitInputStream(input, bytes);
        }
        return input;
    }

    public String mimeType() {
        if (this.getPlayer() != null) {
            return this.getPlayer().mimeType();
        }
        if (this.getMedia() != null && this.getMedia().isMediaparsed()) {
            return this.getMedia().getMimeType();
        }
        if (this.getFormat() != null) {
            return this.getFormat().mimeType();
        }
        return DLNAResource.getDefaultMimeType(this.getSpecificType());
    }

    public void checkThumbnail() {
    }

    protected void checkThumbnail(InputFile inputFile) {
        if (this.getMedia() != null && !this.getMedia().isThumbready() && configuration.isThumbnailGenerationEnabled()) {
            this.getMedia().setThumbready(true);
            this.getMedia().generateThumbnail(inputFile, this.getFormat(), this.getType());
            if (this.getMedia().getThumb() != null && configuration.getUseCache() && inputFile.getFile() != null) {
                PMS.get().getDatabase().updateThumbnail(inputFile.getFile().getAbsolutePath(), inputFile.getFile().lastModified(), this.getType(), this.getMedia());
            }
        }
    }

    public InputStream getGenericThumbnailInputStream(String fallback) throws IOException {
        String thumb = fallback;
        if (this.getFormat() != null && this.getFormat().getIcon() != null) {
            thumb = this.getFormat().getIcon();
        }
        if (thumb != null) {
            if (new File(thumb).canRead()) {
                return new FileInputStream(thumb);
            }
            InputStream is = this.getResourceInputStream(thumb);
            if (is != null) {
                return is;
            }
            try {
                return DLNAResource.downloadAndSend(thumb, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.getResourceInputStream("images/thumbnail-video-256.png");
    }

    public InputStream getThumbnailInputStream() throws IOException {
        return this.getGenericThumbnailInputStream(null);
    }

    public String getThumbnailContentType() {
        return "image/jpeg";
    }

    public int getType() {
        if (this.getFormat() != null) {
            return this.getFormat().getType();
        }
        return 8;
    }

    public abstract boolean isValid();

    public boolean allowScan() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.getId() + ", name=" + this.getName() + ", full path=" + this.getResourceId() + ", ext=" + this.getFormat() + ", discovered=" + this.isDiscovered() + "]";
    }

    protected int getSpecificType() {
        return this.specificType;
    }

    protected void setSpecificType(int specificType) {
        this.specificType = specificType;
    }

    public Format getFormat() {
        return this.format;
    }

    protected void setFormat(Format format) {
        this.format = format;
        this.ext = format;
    }

    public DLNAMediaInfo getMedia() {
        return this.media;
    }

    protected void setMedia(DLNAMediaInfo media) {
        this.media = media;
    }

    public DLNAMediaAudio getMediaAudio() {
        return this.media_audio;
    }

    protected void setMediaAudio(DLNAMediaAudio mediaAudio) {
        this.media_audio = mediaAudio;
    }

    public DLNAMediaSubtitle getMediaSubtitle() {
        return this.media_subtitle;
    }

    protected void setMediaSubtitle(DLNAMediaSubtitle mediaSubtitle) {
        this.media_subtitle = mediaSubtitle;
    }

    @Deprecated
    public long getLastmodified() {
        return this.getLastModified();
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    @Deprecated
    protected void setLastmodified(long lastModified) {
        this.setLastModified(lastModified);
    }

    protected void setLastModified(long lastModified) {
        this.lastmodified = lastModified;
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    protected void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    protected boolean isSrtFile() {
        return this.srtFile;
    }

    protected void setSrtFile(boolean srtFile) {
        this.srtFile = srtFile;
    }

    public int getUpdateId() {
        return this.updateId;
    }

    protected void setUpdateId(int updateId) {
        this.updateId = updateId;
    }

    public static int getSystemUpdateId() {
        return systemUpdateId;
    }

    public static void setSystemUpdateId(int systemUpdateId) {
        DLNAResource.systemUpdateId = systemUpdateId;
    }

    public boolean isNoName() {
        return this.noName;
    }

    protected void setNoName(boolean noName) {
        this.noName = noName;
    }

    public Range.Time getSplitRange() {
        return this.splitRange;
    }

    protected void setSplitRange(Range.Time splitRange) {
        this.splitRange = splitRange;
    }

    protected int getSplitTrack() {
        return this.splitTrack;
    }

    protected void setSplitTrack(int splitTrack) {
        this.splitTrack = splitTrack;
    }

    protected RendererConfiguration getDefaultRenderer() {
        return this.defaultRenderer;
    }

    protected void setDefaultRenderer(RendererConfiguration defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    protected boolean isAvisynth() {
        return this.avisynth;
    }

    protected void setAvisynth(boolean avisynth) {
        this.avisynth = avisynth;
    }

    protected boolean isSkipTranscode() {
        return this.skipTranscode;
    }

    protected void setSkipTranscode(boolean skipTranscode) {
        this.skipTranscode = skipTranscode;
    }

    public List<DLNAResource> getChildren() {
        return this.children;
    }

    protected void setChildren(List<DLNAResource> children) {
        this.children = children;
    }

    @Deprecated
    protected int getLastChildrenId() {
        return this.getLastChildId();
    }

    protected int getLastChildId() {
        return this.lastChildrenId;
    }

    @Deprecated
    protected void setLastChildrenId(int lastChildId) {
        this.setLastChildId(lastChildId);
    }

    protected void setLastChildId(int lastChildId) {
        this.lastChildrenId = lastChildId;
    }

    long getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    protected void setLastRefreshTime(long lastRefreshTime) {
        this.lastRefreshTime = lastRefreshTime;
    }

    static {
        displayNameTemplateEngine.setExprStartToken("<");
        displayNameTemplateEngine.setExprEndToken(">");
        TRANSCODE_FOLDER = Messages.getString("TranscodeVirtualFolder.0");
        systemUpdateId = 1;
    }
}

