/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.MapFileConfiguration;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.CueFolder;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.DVDISOFile;
import net.pms.dlna.PlaylistFolder;
import net.pms.dlna.RarredFile;
import net.pms.dlna.RealFile;
import net.pms.dlna.ZippedFile;
import net.pms.dlna.virtual.TranscodeVirtualFolder;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.formats.FormatFactory;
import net.pms.util.NaturalComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFile
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(MapFile.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private List<File> discoverable;
    @Deprecated
    public File potentialCover;
    @Deprecated
    protected MapFileConfiguration conf;
    private static final Collator collator = Collator.getInstance();

    public MapFile() {
        this.setConf(new MapFileConfiguration());
        this.setLastModified(0L);
    }

    public MapFile(MapFileConfiguration conf) {
        this.setConf(conf);
        this.setLastModified(0L);
    }

    private boolean isFileRelevant(File f) {
        String fileName = f.getName().toLowerCase();
        return configuration.isArchiveBrowsing() && (fileName.endsWith(".zip") || fileName.endsWith(".cbz") || fileName.endsWith(".rar") || fileName.endsWith(".cbr")) || fileName.endsWith(".iso") || fileName.endsWith(".img") || fileName.endsWith(".m3u") || fileName.endsWith(".m3u8") || fileName.endsWith(".pls") || fileName.endsWith(".cue");
    }

    private boolean isFolderRelevant(File f) {
        boolean isRelevant = false;
        if (f.isDirectory() && configuration.isHideEmptyFolders()) {
            File[] children = f.listFiles();
            if (children == null) {
                logger.warn("Can't list files in non-readable directory: {}", (Object)f.getAbsolutePath());
            } else {
                for (File child : children) {
                    if (child.isFile()) {
                        if (FormatFactory.getAssociatedFormat(child.getName()) == null && !this.isFileRelevant(child)) continue;
                        isRelevant = true;
                        break;
                    }
                    if (!this.isFolderRelevant(child)) continue;
                    isRelevant = true;
                    break;
                }
            }
        }
        return isRelevant;
    }

    private void manageFile(File f) {
        if (f.isFile() || f.isDirectory()) {
            String lcFilename = f.getName().toLowerCase();
            if (!f.isHidden()) {
                if (configuration.isArchiveBrowsing() && (lcFilename.endsWith(".zip") || lcFilename.endsWith(".cbz"))) {
                    this.addChild(new ZippedFile(f));
                } else if (configuration.isArchiveBrowsing() && (lcFilename.endsWith(".rar") || lcFilename.endsWith(".cbr"))) {
                    this.addChild(new RarredFile(f));
                } else if (lcFilename.endsWith(".iso") || lcFilename.endsWith(".img") || f.isDirectory() && f.getName().toUpperCase().equals("VIDEO_TS")) {
                    this.addChild(new DVDISOFile(f));
                } else if (lcFilename.endsWith(".m3u") || lcFilename.endsWith(".m3u8") || lcFilename.endsWith(".pls")) {
                    this.addChild(new PlaylistFolder(f));
                } else if (lcFilename.endsWith(".cue")) {
                    this.addChild(new CueFolder(f));
                } else if (f.isDirectory() && configuration.isHideEmptyFolders() && !this.isFolderRelevant(f)) {
                    logger.debug("Ignoring empty/non-relevant directory: " + f.getName());
                } else {
                    this.addChild(new RealFile(f));
                }
            }
            if (f.isFile() && (lcFilename.equals("folder.jpg") || lcFilename.equals("folder.png") || lcFilename.contains("albumart") && lcFilename.endsWith(".jpg"))) {
                this.setPotentialCover(f);
            }
        }
    }

    private List<File> getFileList() {
        ArrayList<File> out = new ArrayList<File>();
        for (File file : this.conf.getFiles()) {
            if (file == null || !file.isDirectory()) continue;
            if (file.canRead()) {
                File[] files = file.listFiles();
                if (files == null) {
                    logger.warn("Can't read files from directory: {}", (Object)file.getAbsolutePath());
                    continue;
                }
                out.addAll(Arrays.asList(files));
                continue;
            }
            logger.warn("Can't read directory: {}", (Object)file.getAbsolutePath());
        }
        return out;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean analyzeChildren(int count) {
        int currentChildrenCount = this.getChildren().size();
        int vfolder = 0;
        while (this.getChildren().size() - currentChildrenCount < count || count == -1) {
            if (vfolder < this.getConf().getChildren().size()) {
                this.addChild(new MapFile(this.getConf().getChildren().get(vfolder)));
                ++vfolder;
                continue;
            }
            if (this.discoverable.isEmpty()) break;
            this.manageFile(this.discoverable.remove(0));
        }
        return this.discoverable.isEmpty();
    }

    @Override
    public void discoverChildren() {
        super.discoverChildren();
        if (this.discoverable != null) {
            return;
        }
        this.discoverable = new ArrayList<File>();
        List<File> files = this.getFileList();
        switch (configuration.getSortMethod()) {
            case 4: {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return NaturalComparator.compareNatural(collator, f1.getName(), f2.getName());
                    }
                });
                break;
            }
            case 3: {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getName().compareToIgnoreCase(f2.getName());
                    }
                });
                break;
            }
            case 2: {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    }
                });
                break;
            }
            case 1: {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                    }
                });
                break;
            }
            default: {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return collator.compare(f1.getName(), f2.getName());
                    }
                });
            }
        }
        for (File f : files) {
            if (!f.isDirectory()) continue;
            this.discoverable.add(f);
        }
        for (File f : files) {
            if (!f.isFile()) continue;
            this.discoverable.add(f);
        }
    }

    @Override
    public boolean isRefreshNeeded() {
        long modified = 0L;
        for (File f : this.getConf().getFiles()) {
            if (f == null) continue;
            modified = Math.max(modified, f.lastModified());
        }
        return this.getLastRefreshTime() < modified;
    }

    @Override
    public void doRefreshChildren() {
        List<File> files = this.getFileList();
        ArrayList<File> addedFiles = new ArrayList<File>();
        ArrayList<DLNAResource> removedFiles = new ArrayList<DLNAResource>();
        for (DLNAResource dLNAResource : this.getChildren()) {
            boolean bl = dLNAResource.getClass() != MapFile.class && (!(dLNAResource instanceof VirtualFolder) || dLNAResource instanceof DVDISOFile);
            if (!bl || this.foundInList(files, dLNAResource)) continue;
            removedFiles.add(dLNAResource);
        }
        for (File file : files) {
            if (file.isHidden() || !file.isDirectory() && FormatFactory.getAssociatedFormat(file.getName()) == null) continue;
            addedFiles.add(file);
        }
        for (DLNAResource dLNAResource : removedFiles) {
            logger.debug("File automatically removed: " + dLNAResource.getName());
        }
        for (File file : addedFiles) {
            logger.debug("File automatically added: " + file.getName());
        }
        TranscodeVirtualFolder transcodeFolder = this.getTranscodeFolder(false);
        for (DLNAResource dLNAResource : removedFiles) {
            this.getChildren().remove(dLNAResource);
            if (transcodeFolder == null) continue;
            for (int j = transcodeFolder.getChildren().size() - 1; j >= 0; --j) {
                if (!transcodeFolder.getChildren().get(j).getName().equals(dLNAResource.getName())) continue;
                transcodeFolder.getChildren().remove(j);
            }
        }
        for (File file : addedFiles) {
            this.manageFile(file);
        }
        for (MapFileConfiguration mapFileConfiguration : this.getConf().getChildren()) {
            this.addChild(new MapFile(mapFileConfiguration));
        }
    }

    private boolean foundInList(List<File> files, DLNAResource dlna) {
        for (File file : files) {
            if (file.isHidden() || !this.isNameMatch(dlna, file) || !this.isRealFolder(dlna) && !this.isSameLastModified(dlna, file)) continue;
            files.remove(file);
            return true;
        }
        return false;
    }

    private boolean isSameLastModified(DLNAResource dlna, File file) {
        return dlna.getLastModified() == file.lastModified();
    }

    private boolean isRealFolder(DLNAResource dlna) {
        return dlna instanceof RealFile && dlna.isFolder();
    }

    private boolean isNameMatch(DLNAResource dlna, File file) {
        return dlna.getName().equals(file.getName()) || this.isDVDIsoMatch(dlna, file);
    }

    private boolean isDVDIsoMatch(DLNAResource dlna, File file) {
        if (dlna instanceof DVDISOFile) {
            DVDISOFile dvdISOFile = (DVDISOFile)dlna;
            return dvdISOFile.getFilename().equals(file.getName());
        }
        return false;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public String getThumbnailContentType() {
        String thumbnailIcon = this.getConf().getThumbnailIcon();
        if (thumbnailIcon != null && thumbnailIcon.toLowerCase().endsWith(".png")) {
            return "image/png";
        }
        return super.getThumbnailContentType();
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        return this.getConf().getThumbnailIcon() != null ? this.getResourceInputStream(this.getConf().getThumbnailIcon()) : super.getThumbnailInputStream();
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String getName() {
        return this.getConf().getName();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public boolean allowScan() {
        return this.isFolder();
    }

    @Override
    public String toString() {
        return "MapFile [name=" + this.getName() + ", id=" + this.getResourceId() + ", format=" + this.getFormat() + ", children=" + this.getChildren() + "]";
    }

    protected MapFileConfiguration getConf() {
        return this.conf;
    }

    protected void setConf(MapFileConfiguration conf) {
        this.conf = conf;
    }

    public File getPotentialCover() {
        return this.potentialCover;
    }

    public void setPotentialCover(File potentialCover) {
        this.potentialCover = potentialCover;
    }

    static {
        collator.setStrength(0);
    }
}

