/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaDatabase;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.InputFile;
import net.pms.dlna.MapFile;
import net.pms.formats.FormatFactory;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealFile
extends MapFile {
    private static final Logger logger = LoggerFactory.getLogger(RealFile.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();

    public RealFile(File file) {
        this.getConf().getFiles().add(file);
        this.setLastModified(file.lastModified());
    }

    public RealFile(File file, String name) {
        this.getConf().getFiles().add(file);
        this.getConf().setName(name);
        this.setLastModified(file.lastModified());
    }

    @Override
    public boolean isValid() {
        boolean valid;
        File file = this.getFile();
        this.resolveFormat();
        if (this.getType() == 4 && file.exists() && configuration.isAutoloadExternalSubtitles() && file.getName().length() > 4) {
            this.setSrtFile(FileUtil.isSubtitlesExists(file, null));
        }
        boolean bl = valid = file.exists() && (this.getFormat() != null || file.isDirectory());
        if (valid && this.getParent().getDefaultRenderer() != null && this.getParent().getDefaultRenderer().isMediaParserV2()) {
            this.run();
            if (this.getMedia() != null && this.getMedia().getThumb() == null && this.getType() != 1) {
                this.getMedia().setThumbready(false);
            }
            if (this.getType() != 8 && this.getMedia() != null && (this.getMedia().isEncrypted() || this.getMedia().getContainer() == null || this.getMedia().getContainer().equals("und"))) {
                valid = false;
                if (this.getMedia().isEncrypted()) {
                    logger.info("The file {} is encrypted. It will be hidden", (Object)file.getAbsolutePath());
                } else {
                    logger.info("The file {} could not be parsed. It will be hidden", (Object)file.getAbsolutePath());
                }
            }
            if (this.getParent().getDefaultRenderer().isMediaParserV2ThumbnailGeneration()) {
                this.checkThumbnail();
            }
        }
        return valid;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (FileNotFoundException e) {
            logger.debug("File not found: {}", (Object)this.getFile().getAbsolutePath());
            return null;
        }
    }

    @Override
    public long length() {
        if (this.getPlayer() != null && this.getPlayer().type() != 2) {
            return 0x7FFFFFFF7FFFFFFFL;
        }
        if (this.getMedia() != null && this.getMedia().isMediaparsed()) {
            return this.getMedia().getSize();
        }
        return this.getFile().length();
    }

    @Override
    public boolean isFolder() {
        return this.getFile().isDirectory();
    }

    public File getFile() {
        return this.getConf().getFiles().get(0);
    }

    @Override
    public String getName() {
        if (this.getConf().getName() == null) {
            String name = null;
            File file = this.getFile();
            if (file.getName().trim().isEmpty()) {
                if (Platform.isWindows()) {
                    name = PMS.get().getRegistry().getDiskLabel(file);
                }
                name = name != null && name.length() > 0 ? file.getAbsolutePath().substring(0, 1) + ":\\ [" + name + "]" : file.getAbsolutePath().substring(0, 1);
            } else {
                name = file.getName();
            }
            this.getConf().setName(name);
        }
        return this.getConf().getName();
    }

    @Override
    protected void resolveFormat() {
        if (this.getFormat() == null) {
            this.setFormat(FormatFactory.getAssociatedFormat(this.getFile().getAbsolutePath()));
        }
        super.resolveFormat();
    }

    @Override
    public String getSystemName() {
        return ProcessUtil.getShortFileNameIfWideChars(this.getFile().getAbsolutePath());
    }

    @Override
    public void resolve() {
        File file = this.getFile();
        if (file.isFile() && (this.getMedia() == null || !this.getMedia().isMediaparsed())) {
            ArrayList<DLNAMediaInfo> medias;
            DLNAMediaDatabase database;
            boolean found = false;
            InputFile input = new InputFile();
            input.setFile(file);
            String fileName = file.getAbsolutePath();
            if (this.getSplitTrack() > 0) {
                fileName = fileName + "#SplitTrack" + this.getSplitTrack();
            }
            if (configuration.getUseCache() && (database = PMS.get().getDatabase()) != null && (medias = database.getData(fileName, file.lastModified())) != null && medias.size() == 1) {
                this.setMedia(medias.get(0));
                this.getMedia().finalize(this.getType(), input);
                found = true;
            }
            if (!found) {
                if (this.getMedia() == null) {
                    this.setMedia(new DLNAMediaInfo());
                }
                boolean bl = found = !this.getMedia().isMediaparsed() && !this.getMedia().isParsing();
                if (this.getFormat() != null) {
                    this.getFormat().parse(this.getMedia(), input, this.getType(), this.getParent().getDefaultRenderer());
                } else {
                    this.getMedia().parse(input, this.getFormat(), this.getType(), false);
                }
                if (found && configuration.getUseCache() && (database = PMS.get().getDatabase()) != null) {
                    database.insertData(fileName, file.lastModified(), this.getType(), this.getMedia());
                }
            }
        }
    }

    @Override
    public String getThumbnailContentType() {
        return super.getThumbnailContentType();
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        boolean hasAlreadyEmbeddedCoverArt;
        File file = this.getFile();
        File cachedThumbnail = null;
        if (this.getParent() != null && this.getParent() instanceof RealFile) {
            cachedThumbnail = ((RealFile)this.getParent()).getPotentialCover();
            File thumbFolder = null;
            boolean alternativeCheck = false;
            while (cachedThumbnail == null) {
                if (thumbFolder == null && this.getType() != 2) {
                    thumbFolder = file.getParentFile();
                }
                if ((cachedThumbnail = FileUtil.getFileNameWithNewExtension(thumbFolder, file, "jpg")) == null) {
                    cachedThumbnail = FileUtil.getFileNameWithNewExtension(thumbFolder, file, "png");
                }
                if (cachedThumbnail == null) {
                    cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, file, ".cover.jpg");
                }
                if (cachedThumbnail == null) {
                    cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, file, ".cover.png");
                }
                if (alternativeCheck) break;
                if (StringUtils.isNotBlank(configuration.getAlternateThumbFolder()) && !(thumbFolder = new File(configuration.getAlternateThumbFolder())).isDirectory()) {
                    thumbFolder = null;
                    break;
                }
                alternativeCheck = true;
            }
            if (file.isDirectory() && (cachedThumbnail = FileUtil.getFileNameWithNewExtension(file.getParentFile(), file, "/folder.jpg")) == null) {
                cachedThumbnail = FileUtil.getFileNameWithNewExtension(file.getParentFile(), file, "/folder.png");
            }
        }
        boolean bl = hasAlreadyEmbeddedCoverArt = this.getType() == 1 && this.getMedia() != null && this.getMedia().getThumb() != null;
        if (cachedThumbnail != null && (!hasAlreadyEmbeddedCoverArt || file.isDirectory())) {
            return new FileInputStream(cachedThumbnail);
        }
        if (this.getMedia() != null && this.getMedia().getThumb() != null) {
            return this.getMedia().getThumbnailInputStream();
        }
        return super.getThumbnailInputStream();
    }

    @Override
    public void checkThumbnail() {
        InputFile input = new InputFile();
        input.setFile(this.getFile());
        this.checkThumbnail(input);
    }

    @Override
    protected String getThumbnailURL() {
        if (this.getType() == 2 && !configuration.getImageThumbnailsEnabled()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PMS.get().getServer().getURL());
        sb.append("/");
        if (this.getMedia() != null && this.getMedia().getThumb() != null) {
            return super.getThumbnailURL();
        }
        if (this.getType() == 1) {
            if (this.getParent() != null && this.getParent() instanceof RealFile && ((RealFile)this.getParent()).getPotentialCover() != null) {
                return super.getThumbnailURL();
            }
            return null;
        }
        return super.getThumbnailURL();
    }
}

