/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.formats.FormatFactory;

public abstract class VirtualVideoAction
extends DLNAResource {
    private boolean enabled;
    protected String name;
    private String thumbnailIconOK;
    private String thumbnailIconKO;
    private String thumbnailContentType;
    private String videoOk;
    private String videoKo;
    private long timer1;

    public VirtualVideoAction(String name, boolean enabled) {
        this.name = name;
        this.thumbnailContentType = "image/png";
        this.thumbnailIconOK = "images/apply-256.png";
        this.thumbnailIconKO = "images/button_cancel-256.png";
        this.videoOk = "videos/action_success-512.mpg";
        this.videoKo = "videos/button_cancel-512.mpg";
        this.timer1 = -1L;
        this.enabled = enabled;
        DLNAMediaInfo mediaInfo = new DLNAMediaInfo();
        mediaInfo.setContainer("mpegps");
        ArrayList<DLNAMediaAudio> audioCodes = new ArrayList<DLNAMediaAudio>();
        mediaInfo.setAudioTracksList(audioCodes);
        mediaInfo.setMimeType("video/mpeg");
        mediaInfo.setCodecV("mpeg2");
        mediaInfo.setMediaparsed(true);
        this.setMedia(mediaInfo);
    }

    @Override
    public boolean isTranscodeFolderAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.timer1 == -1L) {
            this.timer1 = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.timer1 < 2000L) {
            this.timer1 = -1L;
        }
        if (this.timer1 != -1L) {
            this.enabled = this.enable();
        }
        return this.getResourceInputStream(this.enabled ? this.videoOk : this.videoKo);
    }

    public abstract boolean enable();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public InputStream getThumbnailInputStream() {
        return this.getResourceInputStream(this.enabled ? this.thumbnailIconOK : this.thumbnailIconKO);
    }

    @Override
    public String getThumbnailContentType() {
        return this.thumbnailContentType;
    }

    @Override
    public boolean isValid() {
        this.setFormat(FormatFactory.getAssociatedFormat("toto.mpg"));
        return true;
    }
}

