/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import bsh.EvalError;
import bsh.Interpreter;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.InputFile;
import net.pms.encoders.FFmpegAviSynthVideo;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.AudioUtils;
import net.pms.formats.v2.SubtitleType;
import net.pms.formats.v2.SubtitleUtils;
import net.pms.io.OutputParams;
import net.pms.io.PipeIPCProcess;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.StreamModifier;
import net.pms.util.CodecUtil;
import net.pms.util.FileUtil;
import net.pms.util.FormLayoutUtil;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MEncoderVideo
extends Player {
    private static final Logger logger = LoggerFactory.getLogger(MEncoderVideo.class);
    private static final String COL_SPEC = "left:pref, 3dlu, p:grow, 3dlu, right:p:grow, 3dlu, p:grow, 3dlu, right:p:grow,3dlu, p:grow, 3dlu, right:p:grow,3dlu, pref:grow";
    private static final String ROW_SPEC = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p";
    private static final String REMOVE_OPTION = "---REMOVE-ME---";
    private JTextField mencoder_noass_scale;
    private JTextField mencoder_noass_subpos;
    private JTextField mencoder_noass_blur;
    private JTextField mencoder_noass_outline;
    private JTextField mencoder_custom_options;
    private JTextField subq;
    private JCheckBox forcefps;
    private JCheckBox yadif;
    private JCheckBox scaler;
    private JTextField scaleX;
    private JTextField scaleY;
    private JCheckBox assdefaultstyle;
    private JCheckBox fc;
    private JCheckBox ass;
    private JCheckBox checkBox;
    private JCheckBox mencodermt;
    private JCheckBox noskip;
    private JCheckBox intelligentsync;
    private JTextField ocw;
    private JTextField och;
    private final PmsConfiguration configuration;
    private static final String[] INVALID_CUSTOM_OPTIONS = new String[]{"-of", "-oac", "-ovc", "-mpegopts"};
    private static final String INVALID_CUSTOM_OPTIONS_LIST = Arrays.toString(INVALID_CUSTOM_OPTIONS);
    public static final String ID = "mencoder";
    @Deprecated
    protected boolean dvd;
    @Deprecated
    protected String[] overriddenMainArgs;
    protected boolean dtsRemux;
    protected boolean pcm;
    protected boolean ovccopy;
    protected boolean ac3Remux;
    protected boolean mpegts;
    protected boolean wmv;
    public static final String DEFAULT_CODEC_CONF_SCRIPT = Messages.getString("MEncoderVideo.68") + Messages.getString("MEncoderVideo.69") + Messages.getString("MEncoderVideo.70") + Messages.getString("MEncoderVideo.71") + Messages.getString("MEncoderVideo.72") + Messages.getString("MEncoderVideo.73") + Messages.getString("MEncoderVideo.75") + Messages.getString("MEncoderVideo.76") + Messages.getString("MEncoderVideo.77") + Messages.getString("MEncoderVideo.78") + Messages.getString("MEncoderVideo.79") + "#\n" + Messages.getString("MEncoderVideo.80") + "container == iso :: -nosync\n" + "(container == avi || container == matroska) && vcodec == mpeg4 && acodec == mp3 :: -mc 0.1\n" + "container == flv :: -mc 0.1\n" + "container == mov :: -mc 0.1\n" + "container == rm  :: -mc 0.1\n" + "container == matroska && framerate == 29.97  :: -nomux -mc 0\n" + "container == mp4 && vcodec == h264 :: -mc 0.1\n" + "\n" + Messages.getString("MEncoderVideo.87") + Messages.getString("MEncoderVideo.88") + Messages.getString("MEncoderVideo.89") + Messages.getString("MEncoderVideo.91");

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public JCheckBox getNoskip() {
        return this.noskip;
    }

    public MEncoderVideo(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public JComponent config() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec(COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        this.checkBox = new JCheckBox(Messages.getString("MEncoderVideo.0"));
        this.checkBox.setContentAreaFilled(false);
        if (this.configuration.getSkipLoopFilterEnabled()) {
            this.checkBox.setSelected(true);
        }
        this.checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setSkipLoopFilterEnabled(e.getStateChange() == 1);
            }
        });
        JComponent cmp = builder.addSeparator(Messages.getString("NetworkTab.5"), FormLayoutUtil.flip(cc.xyw(1, 1, 15), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.mencodermt = new JCheckBox(Messages.getString("MEncoderVideo.35"));
        this.mencodermt.setContentAreaFilled(false);
        if (this.configuration.getMencoderMT()) {
            this.mencodermt.setSelected(true);
        }
        this.mencodermt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MEncoderVideo.this.configuration.setMencoderMT(MEncoderVideo.this.mencodermt.isSelected());
            }
        });
        this.mencodermt.setEnabled(Platform.isWindows() || Platform.isMac());
        builder.add((Component)this.mencodermt, FormLayoutUtil.flip(cc.xy(1, 3), colSpec, orientation));
        builder.add((Component)this.checkBox, FormLayoutUtil.flip(cc.xyw(3, 3, 12), colSpec, orientation));
        this.noskip = new JCheckBox(Messages.getString("MEncoderVideo.2"));
        this.noskip.setContentAreaFilled(false);
        if (this.configuration.isMencoderNoOutOfSync()) {
            this.noskip.setSelected(true);
        }
        this.noskip.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderNoOutOfSync(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.noskip, FormLayoutUtil.flip(cc.xy(1, 5), colSpec, orientation));
        JButton button = new JButton(Messages.getString("MEncoderVideo.29"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel codecPanel = new JPanel(new BorderLayout());
                JTextArea textArea = new JTextArea();
                textArea.setText(MEncoderVideo.this.configuration.getMencoderCodecSpecificConfig());
                textArea.setFont(new Font("Courier", 0, 12));
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setPreferredSize(new Dimension(900, 100));
                final JTextArea textAreaDefault = new JTextArea();
                textAreaDefault.setText(DEFAULT_CODEC_CONF_SCRIPT);
                textAreaDefault.setBackground(Color.WHITE);
                textAreaDefault.setFont(new Font("Courier", 0, 12));
                textAreaDefault.setEditable(false);
                textAreaDefault.setEnabled(MEncoderVideo.this.configuration.isMencoderIntelligentSync());
                JScrollPane scrollPaneDefault = new JScrollPane(textAreaDefault);
                scrollPaneDefault.setPreferredSize(new Dimension(900, 450));
                JPanel customPanel = new JPanel(new BorderLayout());
                MEncoderVideo.this.intelligentsync = new JCheckBox(Messages.getString("MEncoderVideo.3"));
                MEncoderVideo.this.intelligentsync.setContentAreaFilled(false);
                if (MEncoderVideo.this.configuration.isMencoderIntelligentSync()) {
                    MEncoderVideo.this.intelligentsync.setSelected(true);
                }
                MEncoderVideo.this.intelligentsync.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MEncoderVideo.this.configuration.setMencoderIntelligentSync(e.getStateChange() == 1);
                        textAreaDefault.setEnabled(MEncoderVideo.this.configuration.isMencoderIntelligentSync());
                    }
                });
                JLabel label = new JLabel(Messages.getString("MEncoderVideo.33"));
                customPanel.add((Component)label, "North");
                customPanel.add((Component)scrollPane, "South");
                codecPanel.add((Component)MEncoderVideo.this.intelligentsync, "North");
                codecPanel.add((Component)scrollPaneDefault, "Center");
                codecPanel.add((Component)customPanel, "South");
                while (JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), codecPanel, Messages.getString("MEncoderVideo.34"), 2, -1, null, null, null) == 0) {
                    String newCodecparam = textArea.getText();
                    DLNAMediaInfo fakemedia = new DLNAMediaInfo();
                    DLNAMediaAudio audio = new DLNAMediaAudio();
                    audio.setCodecA("ac3");
                    fakemedia.setCodecV("mpeg4");
                    fakemedia.setContainer("matroska");
                    fakemedia.setDuration(2700.0);
                    audio.getAudioProperties().setNumberOfChannels(2);
                    fakemedia.setWidth(1280);
                    fakemedia.setHeight(720);
                    audio.setSampleFrequency("48000");
                    fakemedia.setFrameRate("23.976");
                    fakemedia.getAudioTracksList().add(audio);
                    String[] result = MEncoderVideo.this.getSpecificCodecOptions(newCodecparam, fakemedia, new OutputParams(MEncoderVideo.this.configuration), "dummy.mpg", "dummy.srt", false, true);
                    if (result.length > 0 && result[0].startsWith("@@")) {
                        String errorMessage = result[0].substring(2);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)((Object)PMS.get().getFrame())), errorMessage, Messages.getString("Dialog.Error"), 0);
                        continue;
                    }
                    MEncoderVideo.this.configuration.setMencoderCodecSpecificConfig(newCodecparam);
                    break;
                }
            }
        });
        builder.add((Component)button, FormLayoutUtil.flip(cc.xy(1, 11), colSpec, orientation));
        this.forcefps = new JCheckBox(Messages.getString("MEncoderVideo.4"));
        this.forcefps.setContentAreaFilled(false);
        if (this.configuration.isMencoderForceFps()) {
            this.forcefps.setSelected(true);
        }
        this.forcefps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderForceFps(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.forcefps, FormLayoutUtil.flip(cc.xyw(1, 7, 2), colSpec, orientation));
        this.yadif = new JCheckBox(Messages.getString("MEncoderVideo.26"));
        this.yadif.setContentAreaFilled(false);
        if (this.configuration.isMencoderYadif()) {
            this.yadif.setSelected(true);
        }
        this.yadif.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderYadif(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.yadif, FormLayoutUtil.flip(cc.xyw(3, 7, 7), colSpec, orientation));
        this.scaler = new JCheckBox(Messages.getString("MEncoderVideo.27"));
        this.scaler.setContentAreaFilled(false);
        this.scaler.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderScaler(e.getStateChange() == 1);
                MEncoderVideo.this.scaleX.setEnabled(MEncoderVideo.this.configuration.isMencoderScaler());
                MEncoderVideo.this.scaleY.setEnabled(MEncoderVideo.this.configuration.isMencoderScaler());
            }
        });
        builder.add((Component)this.scaler, FormLayoutUtil.flip(cc.xyw(3, 5, 7), colSpec, orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.28"), FormLayoutUtil.flip(cc.xy(9, 5, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, orientation));
        this.scaleX = new JTextField("" + this.configuration.getMencoderScaleX());
        this.scaleX.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    MEncoderVideo.this.configuration.setMencoderScaleX(Integer.parseInt(MEncoderVideo.this.scaleX.getText()));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse scaleX from \"" + MEncoderVideo.this.scaleX.getText() + "\"");
                }
            }
        });
        builder.add((Component)this.scaleX, FormLayoutUtil.flip(cc.xy(11, 5), colSpec, orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.30"), FormLayoutUtil.flip(cc.xy(13, 5, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, orientation));
        this.scaleY = new JTextField("" + this.configuration.getMencoderScaleY());
        this.scaleY.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    MEncoderVideo.this.configuration.setMencoderScaleY(Integer.parseInt(MEncoderVideo.this.scaleY.getText()));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse scaleY from \"" + MEncoderVideo.this.scaleY.getText() + "\"");
                }
            }
        });
        builder.add((Component)this.scaleY, FormLayoutUtil.flip(cc.xy(15, 5), colSpec, orientation));
        if (this.configuration.isMencoderScaler()) {
            this.scaler.setSelected(true);
        } else {
            this.scaleX.setEnabled(false);
            this.scaleY.setEnabled(false);
        }
        builder.addLabel(Messages.getString("MEncoderVideo.6"), FormLayoutUtil.flip(cc.xy(1, 13), colSpec, orientation));
        this.mencoder_custom_options = new JTextField(this.configuration.getMencoderCustomOptions());
        this.mencoder_custom_options.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderCustomOptions(MEncoderVideo.this.mencoder_custom_options.getText());
            }
        });
        builder.add((Component)this.mencoder_custom_options, FormLayoutUtil.flip(cc.xyw(3, 13, 13), colSpec, orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.93"), FormLayoutUtil.flip(cc.xy(1, 15), colSpec, orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.28") + " (%)", FormLayoutUtil.flip(cc.xy(1, 15, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, orientation));
        this.ocw = new JTextField(this.configuration.getMencoderOverscanCompensationWidth());
        this.ocw.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderOverscanCompensationWidth(MEncoderVideo.this.ocw.getText());
            }
        });
        builder.add((Component)this.ocw, FormLayoutUtil.flip(cc.xy(3, 15), colSpec, orientation));
        builder.addLabel(Messages.getString("MEncoderVideo.30") + " (%)", FormLayoutUtil.flip(cc.xy(5, 15), colSpec, orientation));
        this.och = new JTextField(this.configuration.getMencoderOverscanCompensationHeight());
        this.och.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderOverscanCompensationHeight(MEncoderVideo.this.och.getText());
            }
        });
        builder.add((Component)this.och, FormLayoutUtil.flip(cc.xy(7, 15), colSpec, orientation));
        cmp = builder.addSeparator(Messages.getString("MEncoderVideo.8"), FormLayoutUtil.flip(cc.xyw(1, 17, 15), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.addLabel(Messages.getString("MEncoderVideo.16"), FormLayoutUtil.flip(cc.xy(1, 27, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, orientation));
        this.mencoder_noass_scale = new JTextField(this.configuration.getMencoderNoAssScale());
        this.mencoder_noass_scale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderNoAssScale(MEncoderVideo.this.mencoder_noass_scale.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.17"), FormLayoutUtil.flip(cc.xy(5, 27), colSpec, orientation));
        this.mencoder_noass_outline = new JTextField(this.configuration.getMencoderNoAssOutline());
        this.mencoder_noass_outline.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderNoAssOutline(MEncoderVideo.this.mencoder_noass_outline.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.18"), FormLayoutUtil.flip(cc.xy(9, 27), colSpec, orientation));
        this.mencoder_noass_blur = new JTextField(this.configuration.getMencoderNoAssBlur());
        this.mencoder_noass_blur.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderNoAssBlur(MEncoderVideo.this.mencoder_noass_blur.getText());
            }
        });
        builder.addLabel(Messages.getString("MEncoderVideo.19"), FormLayoutUtil.flip(cc.xy(13, 27), colSpec, orientation));
        this.mencoder_noass_subpos = new JTextField(this.configuration.getMencoderNoAssSubPos());
        this.mencoder_noass_subpos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderNoAssSubPos(MEncoderVideo.this.mencoder_noass_subpos.getText());
            }
        });
        builder.add((Component)this.mencoder_noass_scale, FormLayoutUtil.flip(cc.xy(3, 27), colSpec, orientation));
        builder.add((Component)this.mencoder_noass_outline, FormLayoutUtil.flip(cc.xy(7, 27), colSpec, orientation));
        builder.add((Component)this.mencoder_noass_blur, FormLayoutUtil.flip(cc.xy(11, 27), colSpec, orientation));
        builder.add((Component)this.mencoder_noass_subpos, FormLayoutUtil.flip(cc.xy(15, 27), colSpec, orientation));
        this.ass = new JCheckBox(Messages.getString("MEncoderVideo.20"));
        this.ass.setContentAreaFilled(false);
        this.ass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e != null) {
                    MEncoderVideo.this.configuration.setMencoderAss(e.getStateChange() == 1);
                }
            }
        });
        builder.add((Component)this.ass, FormLayoutUtil.flip(cc.xy(1, 23), colSpec, orientation));
        this.ass.setSelected(this.configuration.isMencoderAss());
        this.ass.getItemListeners()[0].itemStateChanged(null);
        this.fc = new JCheckBox(Messages.getString("MEncoderVideo.21"));
        this.fc.setContentAreaFilled(false);
        this.fc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderFontConfig(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.fc, FormLayoutUtil.flip(cc.xyw(3, 23, 5), colSpec, orientation));
        this.fc.setSelected(this.configuration.isMencoderFontConfig());
        this.assdefaultstyle = new JCheckBox(Messages.getString("MEncoderVideo.36"));
        this.assdefaultstyle.setContentAreaFilled(false);
        this.assdefaultstyle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MEncoderVideo.this.configuration.setMencoderAssDefaultStyle(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.assdefaultstyle, FormLayoutUtil.flip(cc.xyw(8, 23, 4), colSpec, orientation));
        this.assdefaultstyle.setSelected(this.configuration.isMencoderAssDefaultStyle());
        builder.addLabel(Messages.getString("MEncoderVideo.92"), FormLayoutUtil.flip(cc.xy(1, 29), colSpec, orientation));
        this.subq = new JTextField(this.configuration.getMencoderVobsubSubtitleQuality());
        this.subq.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MEncoderVideo.this.configuration.setMencoderVobsubSubtitleQuality(MEncoderVideo.this.subq.getText());
            }
        });
        builder.add((Component)this.subq, FormLayoutUtil.flip(cc.xyw(3, 29, 1), colSpec, orientation));
        this.configuration.addConfigurationListener(new ConfigurationListener(){

            @Override
            public void configurationChanged(ConfigurationEvent event) {
                if (event.getPropertyName() == null) {
                    return;
                }
                if (!event.isBeforeUpdate() && event.getPropertyName().equals("disable_subtitles")) {
                    boolean enabled = !MEncoderVideo.this.configuration.isDisableSubtitles();
                    MEncoderVideo.this.ass.setEnabled(enabled);
                    MEncoderVideo.this.assdefaultstyle.setEnabled(enabled);
                    MEncoderVideo.this.fc.setEnabled(enabled);
                    MEncoderVideo.this.mencoder_noass_scale.setEnabled(enabled);
                    MEncoderVideo.this.mencoder_noass_outline.setEnabled(enabled);
                    MEncoderVideo.this.mencoder_noass_blur.setEnabled(enabled);
                    MEncoderVideo.this.mencoder_noass_subpos.setEnabled(enabled);
                    MEncoderVideo.this.ocw.setEnabled(enabled);
                    MEncoderVideo.this.och.setEnabled(enabled);
                    MEncoderVideo.this.subq.setEnabled(enabled);
                    if (enabled) {
                        MEncoderVideo.this.ass.getItemListeners()[0].itemStateChanged(null);
                    }
                }
            }
        });
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        return panel;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    protected String[] getDefaultArgs() {
        ArrayList<String> defaultArgsList = new ArrayList<String>();
        defaultArgsList.add("-msglevel");
        defaultArgsList.add("statusline=2");
        defaultArgsList.add("-oac");
        defaultArgsList.add(this.ac3Remux || this.dtsRemux ? "copy" : (this.pcm ? "pcm" : "lavc"));
        defaultArgsList.add("-of");
        defaultArgsList.add(this.wmv || this.mpegts ? "lavf" : (this.pcm && this.avisynth() ? "avi" : (this.pcm || this.dtsRemux ? "rawvideo" : "mpeg")));
        if (this.wmv) {
            defaultArgsList.add("-lavfopts");
            defaultArgsList.add("format=asf");
        } else if (this.mpegts) {
            defaultArgsList.add("-lavfopts");
            defaultArgsList.add("format=mpegts");
        }
        defaultArgsList.add("-mpegopts");
        defaultArgsList.add("format=mpeg2:muxrate=500000:vbuf_size=1194:abuf_size=64");
        defaultArgsList.add("-ovc");
        defaultArgsList.add(this.ovccopy ? "copy" : "lavc");
        String[] defaultArgsArray = new String[defaultArgsList.size()];
        defaultArgsList.toArray(defaultArgsArray);
        return defaultArgsArray;
    }

    private String quoteArg(String arg) {
        if (arg != null && arg.indexOf(" ") > -1) {
            return "\"" + arg + "\"";
        }
        return arg;
    }

    private String[] sanitizeArgs(String[] args) {
        ArrayList<String> sanitized = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            String value = null;
            for (String option : INVALID_CUSTOM_OPTIONS) {
                if (!option.equals(name)) continue;
                if (i + 1 < args.length) {
                    value = " " + args[i + 1];
                    ++i;
                } else {
                    value = "";
                }
                logger.warn("Ignoring custom MEncoder option: {}{}; the following options cannot be changed: " + INVALID_CUSTOM_OPTIONS_LIST, (Object)name, (Object)value);
                break;
            }
            if (value != null) continue;
            sanitized.add(args[i]);
        }
        return sanitized.toArray(new String[sanitized.size()]);
    }

    @Override
    public String[] args() {
        String[] args;
        String[] defaultArgs = this.getDefaultArgs();
        if (this.overriddenMainArgs != null) {
            String[] sanitizedCustomArgs = this.sanitizeArgs(this.overriddenMainArgs);
            args = new String[defaultArgs.length + sanitizedCustomArgs.length];
            System.arraycopy(defaultArgs, 0, args, 0, defaultArgs.length);
            System.arraycopy(sanitizedCustomArgs, 0, args, defaultArgs.length, sanitizedCustomArgs.length);
        } else {
            args = defaultArgs;
        }
        return args;
    }

    @Override
    public String executable() {
        return this.configuration.getMencoderPath();
    }

    private int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            try {
                bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf("(") + 1, bitrate.indexOf(")")));
            }
            catch (NumberFormatException e) {
                bitrates[1] = 0;
            }
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf("(")).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        try {
            bitrates[0] = (int)Double.parseDouble(bitrate);
        }
        catch (NumberFormatException e) {
            bitrates[0] = 0;
        }
        return bitrates;
    }

    private String addMaximumBitrateConstraints(String encodeSettings, DLNAMediaInfo media, String quality, RendererConfiguration mediaRenderer, String audioType) {
        int[] defaultMaxBitrates = this.getVideoBitrateConfig(this.configuration.getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        if (mediaRenderer.getMaxVideoBitrate() != null) {
            rendererMaxBitrates = this.getVideoBitrateConfig(mediaRenderer.getMaxVideoBitrate());
        }
        if (rendererMaxBitrates[0] > 0 && (defaultMaxBitrates[0] == 0 || rendererMaxBitrates[0] < defaultMaxBitrates[0])) {
            defaultMaxBitrates = rendererMaxBitrates;
        }
        if (!(mediaRenderer.getCBRVideoBitrate() != 0 || defaultMaxBitrates[0] <= 0 || quality.contains("vrc_buf_size") || quality.contains("vrc_maxrate") || quality.contains("vbitrate"))) {
            defaultMaxBitrates[0] = 1000 * defaultMaxBitrates[0];
            defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
            int bufSize = 1835;
            if (media.isHDVideo()) {
                bufSize = defaultMaxBitrates[0] / 3;
            }
            if (bufSize > 7000) {
                bufSize = 7000;
            }
            if (defaultMaxBitrates[1] > 0) {
                bufSize = defaultMaxBitrates[1];
            }
            if (mediaRenderer.isDefaultVBVSize() && rendererMaxBitrates[1] == 0) {
                bufSize = 1835;
            }
            if ("pcm".equals(audioType)) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] - 4600;
            } else if ("dts".equals(audioType)) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] - 1510;
            } else if ("ac3".equals(audioType)) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] - 640;
            }
            defaultMaxBitrates[0] = defaultMaxBitrates[0] / 1000 * 1000;
            encodeSettings = encodeSettings + ":vrc_maxrate=" + defaultMaxBitrates[0] + ":vrc_buf_size=" + bufSize;
        }
        return encodeSettings;
    }

    private boolean isDisableSubtitles(OutputParams params) {
        return this.configuration.isDisableSubtitles() || params.sid == null || this.avisynth();
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String[] expertOptions;
        boolean scaleBool;
        String framerate;
        String combinedCustomOptions;
        boolean mencoderAC3RemuxAudioDelayBug;
        params.manageFastStart();
        boolean avisynth = this.avisynth();
        String filename = dlna.getSystemName();
        this.setAudioAndSubs(filename, media, params, this.configuration);
        String externalSubtitlesFileName = null;
        if (params.sid != null && params.sid.isExternal()) {
            if (params.sid.isExternalFileUtf16()) {
                File convertedSubtitles = new File(PMS.getConfiguration().getTempFolder(), "utf8_" + params.sid.getExternalFile().getName());
                FileUtil.convertFileFromUtf16ToUtf8(params.sid.getExternalFile(), convertedSubtitles);
                externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(convertedSubtitles.getAbsolutePath());
            } else {
                externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(params.sid.getExternalFile().getAbsolutePath());
            }
        }
        InputFile newInput = new InputFile();
        newInput.setFilename(filename);
        newInput.setPush(params.stdin);
        this.dvd = false;
        if (media != null && media.getDvdtrack() > 0) {
            this.dvd = true;
        }
        this.ovccopy = false;
        this.pcm = false;
        this.ac3Remux = false;
        this.dtsRemux = false;
        this.wmv = false;
        int intOCW = 0;
        int intOCH = 0;
        try {
            intOCW = Integer.parseInt(this.configuration.getMencoderOverscanCompensationWidth());
        }
        catch (NumberFormatException e) {
            logger.error("Cannot parse configured MEncoder overscan compensation width: \"{}\"", (Object)this.configuration.getMencoderOverscanCompensationWidth());
        }
        try {
            intOCH = Integer.parseInt(this.configuration.getMencoderOverscanCompensationHeight());
        }
        catch (NumberFormatException e) {
            logger.error("Cannot parse configured MEncoder overscan compensation height: \"{}\"", (Object)this.configuration.getMencoderOverscanCompensationHeight());
        }
        if (params.sid == null && this.dvd && this.configuration.isMencoderRemuxMPEG2() && params.mediaRenderer.isMpeg2Supported()) {
            String[] expertOptions2 = this.getSpecificCodecOptions(this.configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, this.configuration.isMencoderIntelligentSync(), false);
            boolean nomux = false;
            for (String s : expertOptions2) {
                if (!s.equals("-nomux")) continue;
                nomux = true;
            }
            if (!nomux) {
                this.ovccopy = true;
            }
        }
        String vcodec = "mpeg2video";
        if (params.mediaRenderer.isTranscodeToWMV()) {
            this.wmv = true;
            vcodec = "wmv2";
        }
        this.mpegts = params.mediaRenderer.isTranscodeToMPEGTSAC3();
        boolean ps3_and_stereo_and_384_kbits = false;
        boolean isTSMuxerVideoEngineEnabled = PMS.getConfiguration().getEnginesAsList().contains("tsmuxer");
        boolean bl = mencoderAC3RemuxAudioDelayBug = params.aid != null && params.aid.getAudioProperties().getAudioDelay() != 0 && params.timeseek == 0.0;
        if (!mencoderAC3RemuxAudioDelayBug && this.configuration.isAudioRemuxAC3() && params.aid != null && params.aid.isAC3() && !this.avisynth() && params.mediaRenderer.isTranscodeToAC3()) {
            this.ac3Remux = true;
        } else {
            this.dtsRemux = isTSMuxerVideoEngineEnabled && this.configuration.isAudioEmbedDtsInPcm() && (!this.dvd || this.configuration.isMencoderRemuxMPEG2()) && params.aid != null && params.aid.isDTS() && !this.avisynth() && params.mediaRenderer.isDTSPlayable();
            boolean bl2 = this.pcm = !(!isTSMuxerVideoEngineEnabled || !this.configuration.isAudioUsePCM() || this.dvd && !this.configuration.isMencoderRemuxMPEG2() || media.getContainer().equals("mp4") && !media.getCodecV().equals("h264") || params.aid == null || (!params.aid.isDTS() || params.aid.getAudioProperties().getNumberOfChannels() > 6) && !params.aid.isLossless() && !params.aid.isTrueHD() && (this.configuration.isMencoderUsePcmForHQAudioOnly() || !params.aid.isAC3() && !params.aid.isMP3() && !params.aid.isAAC() && !params.aid.isVorbis() && !params.aid.isMpegAudio()) || !params.mediaRenderer.isLPCMPlayable());
        }
        if (this.dtsRemux || this.pcm) {
            params.losslessaudio = true;
            params.forceFps = media.getValidFps(false);
        }
        this.ovccopy = false;
        if (this.pcm && this.avisynth()) {
            params.avidemux = true;
        }
        int channels = this.ac3Remux ? params.aid.getAudioProperties().getNumberOfChannels() : (this.dtsRemux || this.wmv ? 2 : (this.pcm ? params.aid.getAudioProperties().getNumberOfChannels() : this.configuration.getAudioChannelCount()));
        logger.trace("channels=" + channels);
        String add = "";
        String rendererMencoderOptions = params.mediaRenderer.getCustomMencoderOptions();
        String globalMencoderOptions = this.configuration.getMencoderCustomOptions();
        if (params.mediaRenderer.isPadVideoWithBlackBordersTo169AR()) {
            rendererMencoderOptions = rendererMencoderOptions + " -vf softskip,expand=::::1:16/9:4";
        }
        if (!(combinedCustomOptions = StringUtils.defaultString(globalMencoderOptions) + " " + StringUtils.defaultString(rendererMencoderOptions)).contains("-lavdopts")) {
            add = " -lavdopts debug=0";
        }
        if (StringUtils.isNotBlank(rendererMencoderOptions) && this.dvd && rendererMencoderOptions.contains("expand=")) {
            logger.warn("renderer MEncoder options are incompatible with DVD streaming; ignoring: " + rendererMencoderOptions);
            rendererMencoderOptions = null;
        }
        StringTokenizer st = new StringTokenizer("-channels " + channels + (StringUtils.isNotBlank(globalMencoderOptions) ? " " + globalMencoderOptions : "") + (StringUtils.isNotBlank(rendererMencoderOptions) ? " " + rendererMencoderOptions : "") + add, " ");
        this.overriddenMainArgs = new String[st.countTokens()];
        int nThreads = this.dvd || filename.toLowerCase().endsWith("dvr-ms") ? 1 : this.configuration.getMencoderMaxThreads();
        boolean handleToken = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (handleToken) {
                token = token + ":threads=" + nThreads;
                if (this.configuration.getSkipLoopFilterEnabled() && !this.avisynth()) {
                    token = token + ":skiploopfilter=all";
                }
                handleToken = false;
            }
            if (token.toLowerCase().contains("lavdopts")) {
                handleToken = true;
            }
            this.overriddenMainArgs[i++] = token;
        }
        if (this.configuration.getMPEG2MainSettings() != null) {
            String mpeg2Options = this.configuration.getMPEG2MainSettings();
            String mpeg2OptionsRenderer = params.mediaRenderer.getCustomMEncoderMPEG2Options();
            if (StringUtils.isNotBlank(mpeg2OptionsRenderer)) {
                mpeg2Options = mpeg2OptionsRenderer;
            } else {
                if (mpeg2Options.contains("/*")) {
                    mpeg2Options = mpeg2Options.substring(mpeg2Options.indexOf("/*"));
                }
                int[] defaultMaxBitrates = this.getVideoBitrateConfig(this.configuration.getMaximumBitrate());
                int[] rendererMaxBitrates = new int[2];
                if (params.mediaRenderer.getMaxVideoBitrate() != null) {
                    rendererMaxBitrates = this.getVideoBitrateConfig(params.mediaRenderer.getMaxVideoBitrate());
                }
                if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
                    defaultMaxBitrates = rendererMaxBitrates;
                }
                int maximumBitrate = defaultMaxBitrates[0];
                if (mpeg2Options.contains("Automatic")) {
                    mpeg2Options = "keyint=5:vqscale=1:vqmin=2:vqmax=3";
                    if (params.mediaRenderer.isPS3()) {
                        mpeg2Options = "keyint=25:vqscale=1:vqmin=2:vqmax=3";
                    }
                    if (mpeg2Options.contains("Wireless") || maximumBitrate < 70) {
                        if (media.getWidth() > 1280) {
                            mpeg2Options = "keyint=25:vqmax=7:vqmin=2";
                        } else if (media.getWidth() > 720) {
                            mpeg2Options = "keyint=25:vqmax=5:vqmin=2";
                        }
                    }
                }
            }
            int cbr_bitrate = params.mediaRenderer.getCBRVideoBitrate();
            String cbr_settings = cbr_bitrate > 0 ? ":vrc_buf_size=5000:vrc_minrate=" + cbr_bitrate + ":vrc_maxrate=" + cbr_bitrate + ":vbitrate=" + (cbr_bitrate > 16000 ? cbr_bitrate * 1000 : cbr_bitrate) : "";
            String encodeSettings = "-lavcopts autoaspect=1:vcodec=" + vcodec + (this.wmv && !params.mediaRenderer.isXBOX() ? ":acodec=wmav2:abitrate=448" : cbr_settings + ":acodec=" + (this.configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3") + ":abitrate=" + CodecUtil.getAC3Bitrate(this.configuration, params.aid)) + ":threads=" + (this.wmv && !params.mediaRenderer.isXBOX() ? 1 : this.configuration.getMencoderMaxThreads()) + ("".equals(mpeg2Options) ? "" : ":" + mpeg2Options);
            String audioType = "ac3";
            if (this.dtsRemux) {
                audioType = "dts";
            } else if (this.pcm) {
                audioType = "pcm";
            }
            encodeSettings = this.addMaximumBitrateConstraints(encodeSettings, media, mpeg2Options, params.mediaRenderer, audioType);
            st = new StringTokenizer(encodeSettings, " ");
            int i2 = this.overriddenMainArgs.length;
            this.overriddenMainArgs = Arrays.copyOf(this.overriddenMainArgs, this.overriddenMainArgs.length + st.countTokens());
            while (st.hasMoreTokens()) {
                this.overriddenMainArgs[i2++] = st.nextToken();
            }
        }
        boolean foundNoassParam = false;
        if (media != null) {
            String[] expertOptions3;
            for (String s : expertOptions3 = this.getSpecificCodecOptions(this.configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, this.configuration.isMencoderIntelligentSync(), false)) {
                if (!s.equals("-noass")) continue;
                foundNoassParam = true;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!this.configuration.isDisableSubtitles() && !this.avisynth() && params.sid != null) {
            boolean apply_ass_styling;
            int subtitleMargin = 0;
            int userMargin = 0;
            boolean bl3 = apply_ass_styling = params.sid.getType() != SubtitleType.VOBSUB && params.sid.getType() != SubtitleType.PGS && this.configuration.isMencoderAss() && !foundNoassParam && !this.dvd;
            if (apply_ass_styling) {
                String font;
                boolean override_ass_style;
                sb.append("-ass ");
                boolean bl4 = override_ass_style = !this.configuration.isMencoderAssDefaultStyle() || params.sid.getType() == SubtitleType.SUBRIP || params.sid.getType() == SubtitleType.TX3G;
                if (override_ass_style) {
                    String assSubColor = "ffffff00";
                    if (this.configuration.getSubsColor() != 0 && (assSubColor = Integer.toHexString(this.configuration.getSubsColor())).length() > 2) {
                        assSubColor = assSubColor.substring(2) + "00";
                    }
                    sb.append("-ass-color ").append(assSubColor).append(" -ass-border-color 00000000 -ass-font-scale ").append(this.configuration.getAssScale());
                    if (this.configuration.getFont() != null && this.configuration.getFont().length() > 0) {
                        sb.append(" -font ").append(this.quoteArg(this.configuration.getFont())).append(" ");
                        sb.append(" -ass-force-style FontName=").append(this.quoteArg(this.configuration.getFont())).append(",");
                    } else {
                        String font2 = CodecUtil.getDefaultFontPath();
                        if (StringUtils.isNotBlank(font2)) {
                            sb.append(" -font ").append(this.quoteArg(font2)).append(" ");
                            sb.append(" -ass-force-style FontName=").append(this.quoteArg(font2)).append(",");
                        } else {
                            sb.append(" -font Arial ");
                            sb.append(" -ass-force-style FontName=Arial,");
                        }
                    }
                    if (intOCH > 0) {
                        subtitleMargin = media.getHeight() / 100 * intOCH;
                    }
                    sb.append("Outline=").append(this.configuration.getAssOutline()).append(",Shadow=").append(this.configuration.getAssShadow());
                    try {
                        userMargin = Integer.parseInt(this.configuration.getAssMargin());
                    }
                    catch (NumberFormatException n) {
                        logger.debug("Could not parse SSA margin from \"" + this.configuration.getAssMargin() + "\"");
                    }
                    sb.append(",MarginV=").append(subtitleMargin += userMargin).append(" ");
                } else if (intOCH > 0) {
                    sb.append("-ass-force-style MarginV=").append(subtitleMargin).append(" ");
                }
                if (Platform.isMac() && sb.toString().indexOf(" -font ") < 0 && StringUtils.isNotBlank(font = CodecUtil.getDefaultFontPath())) {
                    sb.append("-font ").append(this.quoteArg(font)).append(" ");
                }
                if (!params.sid.isEmbedded()) {
                    sb.append("-noflip-hebrew ");
                }
            } else {
                if (this.configuration.getFont() != null && this.configuration.getFont().length() > 0) {
                    sb.append(" -font ").append(this.quoteArg(this.configuration.getFont())).append(" ");
                } else {
                    String font = CodecUtil.getDefaultFontPath();
                    if (StringUtils.isNotBlank(font)) {
                        sb.append(" -font ").append(this.quoteArg(font)).append(" ");
                    }
                }
                sb.append(" -subfont-text-scale ").append(this.configuration.getMencoderNoAssScale());
                sb.append(" -subfont-outline ").append(this.configuration.getMencoderNoAssOutline());
                sb.append(" -subfont-blur ").append(this.configuration.getMencoderNoAssBlur());
                if (intOCH > 0) {
                    subtitleMargin = intOCH;
                }
                try {
                    userMargin = Integer.parseInt(this.configuration.getMencoderNoAssSubPos());
                }
                catch (NumberFormatException n) {
                    logger.debug("Could not parse subpos from \"" + this.configuration.getMencoderNoAssSubPos() + "\"");
                }
                sb.append(" -subpos ").append(100 - (subtitleMargin += userMargin)).append(" ");
            }
            if (!Platform.isMac()) {
                sb.append("-").append(this.configuration.isMencoderFontConfig() ? "" : "no").append("fontconfig ");
            }
            if (params.sid.getType() == SubtitleType.VOBSUB && this.configuration.getMencoderVobsubSubtitleQuality() != null) {
                String subtitleQuality = this.configuration.getMencoderVobsubSubtitleQuality();
                sb.append("-spuaa ").append(subtitleQuality).append(" ");
            }
            if (params.sid.isExternal() && !params.sid.isExternalFileUtf()) {
                String subcp = null;
                if (StringUtils.isNotBlank(this.configuration.getSubtitlesCodepage())) {
                    subcp = this.configuration.getSubtitlesCodepage();
                } else if (StringUtils.isNotBlank(SubtitleUtils.getSubCpOptionForMencoder(params.sid))) {
                    subcp = SubtitleUtils.getSubCpOptionForMencoder(params.sid);
                }
                if (StringUtils.isNotBlank(subcp)) {
                    sb.append("-subcp ").append(subcp).append(" ");
                    if (this.configuration.isMencoderSubFribidi()) {
                        sb.append("-fribidi-charset ").append(subcp).append(" ");
                    }
                }
            }
        }
        st = new StringTokenizer(sb.toString(), " ");
        i = this.overriddenMainArgs.length;
        this.overriddenMainArgs = Arrays.copyOf(this.overriddenMainArgs, this.overriddenMainArgs.length + st.countTokens());
        boolean handleToken2 = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (handleToken2) {
                s = "-quiet";
                handleToken2 = false;
            }
            if ((!this.configuration.isMencoderAss() || this.dvd) && s.contains("-ass")) {
                s = "-quiet";
                handleToken2 = true;
            }
            this.overriddenMainArgs[i++] = s;
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.add("-ss");
        cmdList.add(params.timeseek > 0.0 ? "" + params.timeseek : "0");
        if (this.dvd) {
            cmdList.add("-dvd-device");
        }
        if (avisynth && !filename.toLowerCase().endsWith(".iso")) {
            File avsFile = FFmpegAviSynthVideo.getAVSScript(filename, params.sid, params.fromFrame, params.toFrame);
            cmdList.add(ProcessUtil.getShortFileNameIfWideChars(avsFile.getAbsolutePath()));
        } else if (params.stdin != null) {
            cmdList.add("-");
        } else {
            cmdList.add(filename);
        }
        if (this.dvd) {
            cmdList.add("dvd://" + media.getDvdtrack());
        }
        for (String arg : this.args()) {
            if (arg.contains("format=mpeg2") && media.getAspect() != null && media.getValidAspect(true) != null) {
                cmdList.add(arg + ":vaspect=" + media.getValidAspect(true));
                continue;
            }
            cmdList.add(arg);
        }
        if (!(this.dtsRemux || this.pcm || this.avisynth() || params.aid == null || media.getAudioTracksList().size() <= 1)) {
            cmdList.add("-aid");
            boolean lavf = false;
            cmdList.add("" + (lavf ? params.aid.getId() + 1 : params.aid.getId()));
        }
        if (this.isDisableSubtitles(params)) {
            cmdList.add("-nosub");
            cmdList.add("-noautosub");
        } else if (params.sid.isEmbedded()) {
            cmdList.add("-noautosub");
            cmdList.add("-sid");
            cmdList.add("" + params.sid.getId());
        } else if (externalSubtitlesFileName != null) {
            assert (params.sid.isExternal());
            cmdList.add("-nosub");
            if (params.sid.getType() == SubtitleType.VOBSUB) {
                cmdList.add("-vobsub");
                cmdList.add(externalSubtitlesFileName.substring(0, externalSubtitlesFileName.length() - 4));
                cmdList.add("-slang");
                cmdList.add("" + params.sid.getLang());
            } else {
                cmdList.add("-sub");
                cmdList.add(externalSubtitlesFileName.replace(",", "\\,"));
                if (params.sid.isExternalFileUtf()) {
                    cmdList.add("-utf8");
                }
            }
        }
        String validFramerate = media != null ? media.getValidFps(true) : null;
        String ofps = framerate = validFramerate != null ? validFramerate : "24000/1001";
        if (this.configuration.isMencoderForceFps()) {
            if (!this.configuration.isFix25FPSAvMismatch()) {
                cmdList.add("-fps");
                cmdList.add(framerate);
            } else if (validFramerate != null) {
                cmdList.add("-mc");
                cmdList.add("0.005");
                ofps = "25";
            }
        }
        cmdList.add("-ofps");
        cmdList.add(ofps);
        if (!this.configuration.isDisableSubtitles() && !this.avisynth() && params.sid != null && params.sid.isExternal()) {
            if (params.sid.getType() == SubtitleType.VOBSUB) {
                cmdList.add("-vobsub");
                cmdList.add(externalSubtitlesFileName.substring(0, externalSubtitlesFileName.length() - 4));
                cmdList.add("-slang");
                cmdList.add("" + params.sid.getLang());
            } else {
                cmdList.add("-sub");
                cmdList.add(externalSubtitlesFileName.replace(",", "\\,"));
                if (params.sid.isExternalFileUtf()) {
                    cmdList.add("-utf8");
                }
            }
        }
        if (filename.toLowerCase().endsWith(".evo")) {
            cmdList.add("-psprobe");
            cmdList.add("10000");
        }
        boolean deinterlace = this.configuration.isMencoderYadif();
        boolean isResolutionTooHighForRenderer = params.mediaRenderer.isVideoRescale() && media != null && (media.getWidth() > params.mediaRenderer.getMaxVideoWidth() || media.getHeight() > params.mediaRenderer.getMaxVideoHeight());
        boolean bl5 = scaleBool = isResolutionTooHighForRenderer || this.configuration.isMencoderScaler() && (this.configuration.getMencoderScaleX() != 0 || this.configuration.getMencoderScaleY() != 0) || intOCW > 0 || intOCH > 0;
        if ((deinterlace || scaleBool) && !this.avisynth()) {
            String vfValue;
            double rendererAspectRatio;
            StringBuilder vfValueOverscanPrepend = new StringBuilder();
            StringBuilder vfValueOverscanMiddle = new StringBuilder();
            StringBuilder vfValueVS = new StringBuilder();
            StringBuilder vfValueComplete = new StringBuilder();
            String deinterlaceComma = "";
            int scaleWidth = 0;
            int scaleHeight = 0;
            if (media != null && media.getWidth() > 0 && media.getHeight() > 0) {
                scaleWidth = media.getWidth();
                scaleHeight = media.getHeight();
            }
            if (intOCW > 0 || intOCH > 0) {
                int intOCWPixels = media.getWidth() / 100 * intOCW;
                int intOCHPixels = media.getHeight() / 100 * intOCH;
                if (params.mediaRenderer.isVideoRescale() && ((scaleWidth += intOCWPixels) > params.mediaRenderer.getMaxVideoWidth() || (scaleHeight += intOCHPixels) > params.mediaRenderer.getMaxVideoHeight())) {
                    double overscannedAspectRatio = scaleWidth / scaleHeight;
                    rendererAspectRatio = params.mediaRenderer.getMaxVideoWidth() / params.mediaRenderer.getMaxVideoHeight();
                    if (overscannedAspectRatio > rendererAspectRatio) {
                        scaleWidth = params.mediaRenderer.getMaxVideoWidth();
                        scaleHeight = (int)Math.round((double)params.mediaRenderer.getMaxVideoWidth() / overscannedAspectRatio);
                    } else {
                        scaleWidth = (int)Math.round((double)params.mediaRenderer.getMaxVideoHeight() * overscannedAspectRatio);
                        scaleHeight = params.mediaRenderer.getMaxVideoHeight();
                    }
                }
                vfValueOverscanPrepend.append("softskip,expand=-").append(intOCWPixels).append(":-").append(intOCHPixels);
                vfValueOverscanMiddle.append(",scale=").append(scaleWidth).append(":").append(scaleHeight);
            }
            if (this.configuration.isMencoderScaler()) {
                if (this.configuration.getMencoderScaleX() != 0) {
                    scaleWidth = this.configuration.getMencoderScaleX() <= params.mediaRenderer.getMaxVideoWidth() ? this.configuration.getMencoderScaleX() : params.mediaRenderer.getMaxVideoWidth();
                }
                if (this.configuration.getMencoderScaleY() != 0) {
                    scaleHeight = this.configuration.getMencoderScaleY() <= params.mediaRenderer.getMaxVideoHeight() ? this.configuration.getMencoderScaleY() : params.mediaRenderer.getMaxVideoHeight();
                }
                logger.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", your Video Scaler setting");
                vfValueVS.append("scale=").append(scaleWidth).append(":").append(scaleHeight);
            } else if (media != null && media.getWidth() > 0 && media.getHeight() > 0 && (media.getWidth() > params.mediaRenderer.getMaxVideoWidth() || media.getHeight() > params.mediaRenderer.getMaxVideoHeight())) {
                double videoAspectRatio = (double)media.getWidth() / (double)media.getHeight();
                rendererAspectRatio = (double)params.mediaRenderer.getMaxVideoWidth() / (double)params.mediaRenderer.getMaxVideoHeight();
                if (media.getWidth() == 3840 && media.getHeight() == 1080) {
                    scaleWidth = 1920;
                    scaleHeight = 1080;
                } else if (media.getWidth() == 1920 && media.getHeight() == 2160) {
                    scaleWidth = 1920;
                    scaleHeight = 1080;
                } else if (media.getWidth() == 1920 && media.getHeight() == 1088) {
                    scaleWidth = 1920;
                    scaleHeight = 1088;
                } else if (videoAspectRatio > rendererAspectRatio) {
                    scaleWidth = params.mediaRenderer.getMaxVideoWidth();
                    scaleHeight = (int)Math.round((double)params.mediaRenderer.getMaxVideoWidth() / videoAspectRatio);
                } else {
                    scaleWidth = (int)Math.round((double)params.mediaRenderer.getMaxVideoHeight() * videoAspectRatio);
                    scaleHeight = params.mediaRenderer.getMaxVideoHeight();
                }
                logger.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", the maximum your renderer supports");
                vfValueVS.append("scale=").append(scaleWidth).append(":").append(scaleHeight);
            }
            if (intOCW > 0 || intOCH > 0) {
                vfValueComplete.append((CharSequence)vfValueOverscanPrepend).append((CharSequence)vfValueOverscanMiddle).append(",harddup");
                logger.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", to fit your overscan compensation");
            } else {
                vfValueComplete.append((CharSequence)vfValueVS);
            }
            if (deinterlace) {
                deinterlaceComma = ",";
            }
            if (StringUtils.isNotBlank(vfValue = (deinterlace ? "yadif" : "") + (scaleBool ? deinterlaceComma + vfValueComplete : ""))) {
                cmdList.add("-vf");
                cmdList.add(vfValue);
            }
        }
        if (media != null && media.getWidth() % 4 != 0 || media.getHeight() % 4 != 0) {
            int newWidth = media.getWidth() / 4 * 4;
            int newHeight = media.getHeight() / 4 * 4;
            cmdList.add("-vf");
            cmdList.add("softskip,expand=" + newWidth + ":" + newHeight);
        }
        if (this.configuration.getMencoderMT() && !avisynth && !this.dvd && !StringUtils.startsWith(media.getCodecV(), "mpeg2")) {
            cmdList.add("-lavdopts");
            cmdList.add("fast");
        }
        boolean disableMc0AndNoskip = false;
        if (media != null && (expertOptions = this.getSpecificCodecOptions(this.configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, this.configuration.isMencoderIntelligentSync(), false)) != null && expertOptions.length > 0) {
            int i3;
            HashMap<String, Boolean> removeCmdListOption = new HashMap<String, Boolean>();
            HashMap<String, String> mergeCmdListOption = new HashMap<String, String>();
            HashMap<String, Boolean> mergedCmdListOption = new HashMap<String, Boolean>();
            for (int i4 = 0; i4 < expertOptions.length; ++i4) {
                if (expertOptions[i4].equals("-noass")) {
                    removeCmdListOption.put("-ass", false);
                    expertOptions[i4] = REMOVE_OPTION;
                    continue;
                }
                if (expertOptions[i4].equals("-nomux")) {
                    expertOptions[i4] = REMOVE_OPTION;
                    continue;
                }
                if (expertOptions[i4].equals("-mt")) {
                    expertOptions[i4] = REMOVE_OPTION;
                    continue;
                }
                if (expertOptions[i4].equals("-ofps")) {
                    removeCmdListOption.put("-ofps", true);
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-fps")) {
                    removeCmdListOption.put("-fps", true);
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-ovc")) {
                    removeCmdListOption.put("-ovc", true);
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-channels")) {
                    removeCmdListOption.put("-channels", true);
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-oac")) {
                    removeCmdListOption.put("-oac", true);
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-quality")) {
                    String lavcopts = String.format("autoaspect=1:vcodec=%s:acodec=%s:abitrate=%s:threads=%d:%s", vcodec, this.configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3", CodecUtil.getAC3Bitrate(this.configuration, params.aid), this.configuration.getMencoderMaxThreads(), expertOptions[i4 + 1]);
                    lavcopts = this.addMaximumBitrateConstraints(lavcopts, media, lavcopts, params.mediaRenderer, "");
                    mergeCmdListOption.put("-lavcopts", lavcopts.replace("%", "%%"));
                    expertOptions[i4 + 1] = REMOVE_OPTION;
                    expertOptions[i4] = REMOVE_OPTION;
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-mpegopts")) {
                    mergeCmdListOption.put("-mpegopts", "%s:" + expertOptions[i4 + 1].replace("%", "%%"));
                    expertOptions[i4 + 1] = REMOVE_OPTION;
                    expertOptions[i4] = REMOVE_OPTION;
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-vf")) {
                    mergeCmdListOption.put("-vf", "%s," + expertOptions[i4 + 1].replace("%", "%%"));
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-af")) {
                    mergeCmdListOption.put("-af", "%s," + expertOptions[i4 + 1].replace("%", "%%"));
                    ++i4;
                    continue;
                }
                if (expertOptions[i4].equals("-nosync")) {
                    disableMc0AndNoskip = true;
                    expertOptions[i4] = REMOVE_OPTION;
                    continue;
                }
                if (!expertOptions[i4].equals("-mc")) continue;
                disableMc0AndNoskip = true;
            }
            for (String key : mergeCmdListOption.keySet()) {
                mergedCmdListOption.put(key, false);
            }
            ArrayList<String> transformedCmdList = new ArrayList<String>();
            for (i3 = 0; i3 < cmdList.size(); ++i3) {
                String option = (String)cmdList.get(i3);
                if (removeCmdListOption.containsKey(option)) {
                    if (!BooleanUtils.isTrue((Boolean)removeCmdListOption.get(option))) continue;
                    ++i3;
                    continue;
                }
                transformedCmdList.add(option);
                if (!mergeCmdListOption.containsKey(option)) continue;
                String format = (String)mergeCmdListOption.get(option);
                String value = String.format(format, cmdList.get(i3 + 1));
                mergedCmdListOption.put(option, true);
                transformedCmdList.add(value);
                ++i3;
            }
            cmdList = transformedCmdList;
            for (i3 = 0; i3 < expertOptions.length; ++i3) {
                String option = expertOptions[i3];
                if (option == REMOVE_OPTION) continue;
                if (BooleanUtils.isTrue((Boolean)mergedCmdListOption.get(option))) {
                    ++i3;
                    continue;
                }
                cmdList.add(option);
            }
        }
        if (this.pcm || this.dtsRemux || this.ac3Remux || this.configuration.isMencoderNoOutOfSync() && !disableMc0AndNoskip) {
            if (this.configuration.isFix25FPSAvMismatch()) {
                cmdList.add("-mc");
                cmdList.add("0.005");
            } else {
                cmdList.add("-mc");
                cmdList.add("0");
                cmdList.add("-noskip");
            }
        }
        if (params.timeend > 0.0) {
            cmdList.add("-endpos");
            cmdList.add("" + params.timeend);
        }
        String rate = "48000";
        if (params.mediaRenderer.isXBOX()) {
            rate = "44100";
        }
        if (!(media == null || this.pcm || this.dtsRemux || this.ac3Remux)) {
            cmdList.add("-af");
            cmdList.add("lavcresample=" + rate);
            cmdList.add("-srate");
            cmdList.add(rate);
        }
        if (params.stdin != null) {
            cmdList.add("-cache");
            cmdList.add("8192");
        }
        PipeProcess pipe = null;
        ProcessWrapperImpl pw = null;
        if (this.pcm || this.dtsRemux) {
            boolean channels_filter_present = false;
            for (String s : cmdList) {
                if (!StringUtils.isNotBlank(s) || !s.startsWith("channels")) continue;
                channels_filter_present = true;
                break;
            }
            if (params.avidemux) {
                String mixer;
                params.input_pipes[0] = pipe = new PipeProcess(ID + System.currentTimeMillis(), this.pcm || this.dtsRemux || this.ac3Remux ? null : params, new String[0]);
                cmdList.add("-o");
                cmdList.add(pipe.getInputPipe());
                if (this.pcm && !channels_filter_present && params.aid != null && StringUtils.isNotBlank(mixer = AudioUtils.getLPCMChannelMappingForMencoder(params.aid))) {
                    cmdList.add("-af");
                    cmdList.add(mixer);
                }
                String[] cmdArray = new String[cmdList.size()];
                cmdList.toArray(cmdArray);
                pw = new ProcessWrapperImpl(cmdArray, params);
                PipeProcess videoPipe = new PipeProcess("videoPipe" + System.currentTimeMillis(), "out", "reconnect");
                PipeProcess audioPipe = new PipeProcess("audioPipe" + System.currentTimeMillis(), "out", "reconnect");
                ProcessWrapper videoPipeProcess = videoPipe.getPipeProcess();
                ProcessWrapper audioPipeProcess = audioPipe.getPipeProcess();
                params.output_pipes[0] = videoPipe;
                params.output_pipes[1] = audioPipe;
                pw.attachProcess(videoPipeProcess);
                pw.attachProcess(audioPipeProcess);
                videoPipeProcess.runInNewThread();
                audioPipeProcess.runInNewThread();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                videoPipe.deleteLater();
                audioPipe.deleteLater();
            } else {
                ListIterator<String> it = cmdList.listIterator();
                while (it.hasNext()) {
                    String option = (String)it.next();
                    if (!option.equals("-oac")) continue;
                    it.set("-nosound");
                    if (!it.hasNext()) break;
                    it.next();
                    it.remove();
                    break;
                }
                pipe = new PipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
                TsMuxeRVideo ts = new TsMuxeRVideo(this.configuration);
                File f = new File(this.configuration.getTempFolder(), "pms-tsmuxer.meta");
                String[] cmd = new String[]{ts.executable(), f.getAbsolutePath(), pipe.getInputPipe()};
                pw = new ProcessWrapperImpl(cmd, params);
                PipeIPCProcess ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegvideo", System.currentTimeMillis() + "videoout", false, true);
                cmdList.add("-o");
                cmdList.add(ffVideoPipe.getInputPipe());
                OutputParams ffparams = new OutputParams(this.configuration);
                ffparams.maxBufferSize = 1.0;
                ffparams.stdin = params.stdin;
                String[] cmdArray = new String[cmdList.size()];
                cmdList.toArray(cmdArray);
                ProcessWrapperImpl ffVideo = new ProcessWrapperImpl(cmdArray, ffparams);
                ProcessWrapper ff_video_pipe_process = ffVideoPipe.getPipeProcess();
                pw.attachProcess(ff_video_pipe_process);
                ff_video_pipe_process.runInNewThread();
                ffVideoPipe.deleteLater();
                pw.attachProcess(ffVideo);
                ffVideo.runInNewThread();
                String aid = null;
                if (media != null && media.getAudioTracksList().size() > 1 && params.aid != null) {
                    aid = media.getContainer() != null && (media.getContainer().equals("avi") || media.getContainer().equals("flv")) ? "" + (params.aid.getId() + 1) : "" + params.aid.getId();
                }
                PipeIPCProcess ffAudioPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
                StreamModifier sm = new StreamModifier();
                sm.setPcm(this.pcm);
                sm.setDtsEmbed(this.dtsRemux);
                sm.setSampleFrequency(48000);
                sm.setBitsPerSample(16);
                String mixer = null;
                if (this.pcm && !this.dtsRemux) {
                    mixer = AudioUtils.getLPCMChannelMappingForMencoder(params.aid);
                }
                sm.setNbChannels(channels);
                String[] ffmpegLPCMextract = new String[]{this.executable(), "-ss", "0", filename, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + channels, "-ovc", "copy", "-of", "rawaudio", "-mc", this.dtsRemux ? "0.1" : "0", "-noskip", aid == null ? "-quiet" : "-aid", aid == null ? "-quiet" : aid, "-oac", this.ac3Remux || this.dtsRemux ? "copy" : "pcm", StringUtils.isNotBlank(mixer) && !channels_filter_present ? "-af" : "-quiet", StringUtils.isNotBlank(mixer) && !channels_filter_present ? mixer : "-quiet", "-srate", "48000", "-o", ffAudioPipe.getInputPipe()};
                if (!params.mediaRenderer.isMuxDTSToMpeg()) {
                    ffAudioPipe.setModifier(sm);
                }
                if (media != null && media.getDvdtrack() > 0) {
                    ffmpegLPCMextract[3] = "-dvd-device";
                    ffmpegLPCMextract[4] = filename;
                    ffmpegLPCMextract[5] = "dvd://" + media.getDvdtrack();
                } else if (params.stdin != null) {
                    ffmpegLPCMextract[3] = "-";
                }
                if (filename.toLowerCase().endsWith(".evo")) {
                    ffmpegLPCMextract[4] = "-psprobe";
                    ffmpegLPCMextract[5] = "1000000";
                }
                if (params.timeseek > 0.0) {
                    ffmpegLPCMextract[2] = "" + params.timeseek;
                }
                OutputParams ffaudioparams = new OutputParams(this.configuration);
                ffaudioparams.maxBufferSize = 1.0;
                ffaudioparams.stdin = params.stdin;
                ProcessWrapperImpl ffAudio = new ProcessWrapperImpl(ffmpegLPCMextract, ffaudioparams);
                params.stdin = null;
                PrintWriter pwMux = new PrintWriter(f);
                pwMux.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
                String videoType = "V_MPEG-2";
                if (params.no_videoencode && params.forceType != null) {
                    videoType = params.forceType;
                }
                String fps = "";
                if (params.forceFps != null) {
                    fps = "fps=" + params.forceFps + ", ";
                }
                String audioType = this.ac3Remux ? "A_AC3" : (this.dtsRemux ? (params.mediaRenderer.isMuxDTSToMpeg() ? "A_DTS" : "A_LPCM") : "A_LPCM");
                String timeshift = "";
                if (mencoderAC3RemuxAudioDelayBug) {
                    timeshift = "timeshift=" + params.aid.getAudioProperties().getAudioDelay() + "ms, ";
                }
                pwMux.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + fps + "level=4.1, insertSEI, contSPS, track=1");
                pwMux.println(audioType + ", \"" + ffAudioPipe.getOutputPipe() + "\", " + timeshift + "track=2");
                pwMux.close();
                ProcessWrapper pipe_process = pipe.getPipeProcess();
                pw.attachProcess(pipe_process);
                pipe_process.runInNewThread();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                pipe.deleteLater();
                params.input_pipes[0] = pipe;
                ProcessWrapper ff_pipe_process = ffAudioPipe.getPipeProcess();
                pw.attachProcess(ff_pipe_process);
                ff_pipe_process.runInNewThread();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ffAudioPipe.deleteLater();
                pw.attachProcess(ffAudio);
                ffAudio.runInNewThread();
            }
        } else {
            boolean directpipe;
            boolean bl6 = directpipe = Platform.isMac() || Platform.isFreeBSD();
            if (directpipe) {
                cmdList.add("-o");
                cmdList.add("-");
                cmdList.add("-really-quiet");
                cmdList.add("-msglevel");
                cmdList.add("statusline=2");
                params.input_pipes = new PipeProcess[2];
            } else {
                params.input_pipes[0] = pipe = new PipeProcess(ID + System.currentTimeMillis(), this.pcm || this.dtsRemux ? null : params, new String[0]);
                cmdList.add("-o");
                cmdList.add(pipe.getInputPipe());
            }
            String[] cmdArray = new String[cmdList.size()];
            cmdList.toArray(cmdArray);
            cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
            pw = new ProcessWrapperImpl(cmdArray, params);
            if (!directpipe) {
                ProcessWrapper mkfifo_process = pipe.getPipeProcess();
                pw.attachProcess(mkfifo_process);
                mkfifo_process.runInNewThread();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                pipe.deleteLater();
            }
        }
        pw.runInNewThread();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return pw;
    }

    @Override
    public String mimeType() {
        return "video/transcode";
    }

    @Override
    public String name() {
        return "MEncoder Video";
    }

    @Override
    public int type() {
        return 4;
    }

    private String[] getSpecificCodecOptions(String codecParam, DLNAMediaInfo media, OutputParams params, String filename, String externalSubtitlesFileName, boolean enable, boolean verifyOnly) {
        StringBuilder sb = new StringBuilder();
        String codecs = enable ? DEFAULT_CODEC_CONF_SCRIPT : "";
        codecs = codecs + "\n" + codecParam;
        StringTokenizer stLines = new StringTokenizer(codecs, "\n");
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setStrictJava(true);
            ArrayList<String> types = CodecUtil.getPossibleCodecs();
            int rank = 1;
            if (types != null) {
                for (String type : types) {
                    int r = rank++;
                    interpreter.set("" + type, r);
                    String secondaryType = "dummy";
                    if ("matroska".equals(type)) {
                        secondaryType = "mkv";
                        interpreter.set(secondaryType, r);
                    } else if ("rm".equals(type)) {
                        secondaryType = "rmvb";
                        interpreter.set(secondaryType, r);
                    } else if ("mpeg2video".equals(type)) {
                        secondaryType = "mpeg2";
                        interpreter.set(secondaryType, r);
                    } else if ("mpeg1video".equals(type)) {
                        secondaryType = "mpeg1";
                        interpreter.set(secondaryType, r);
                    }
                    if (media.getContainer() != null && (media.getContainer().equals(type) || media.getContainer().equals(secondaryType))) {
                        interpreter.set("container", r);
                        continue;
                    }
                    if (media.getCodecV() != null && (media.getCodecV().equals(type) || media.getCodecV().equals(secondaryType))) {
                        interpreter.set("vcodec", r);
                        continue;
                    }
                    if (params.aid == null || params.aid.getCodecA() == null || !params.aid.getCodecA().equals(type)) continue;
                    interpreter.set("acodec", r);
                }
            } else {
                return null;
            }
            interpreter.set("filename", filename);
            interpreter.set("audio", params.aid != null);
            interpreter.set("subtitles", params.sid != null);
            interpreter.set("srtfile", externalSubtitlesFileName);
            if (params.aid != null) {
                interpreter.set("samplerate", params.aid.getSampleRate());
            }
            String framerate = media.getValidFps(false);
            try {
                if (framerate != null) {
                    interpreter.set("framerate", Double.parseDouble(framerate));
                }
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse framerate from \"" + framerate + "\"");
            }
            interpreter.set("duration", media.getDurationInSeconds());
            if (params.aid != null) {
                interpreter.set("channels", params.aid.getAudioProperties().getNumberOfChannels());
            }
            interpreter.set("height", media.getHeight());
            interpreter.set("width", media.getWidth());
            while (stLines.hasMoreTokens()) {
                String line = stLines.nextToken();
                if (line.startsWith("#") || line.trim().length() <= 0) continue;
                int separator = line.indexOf("::");
                if (separator > -1) {
                    String key = null;
                    try {
                        Object result;
                        key = line.substring(0, separator).trim();
                        String value = line.substring(separator + 2).trim();
                        if (value.length() <= 0) continue;
                        if (key.length() == 0) {
                            key = "1 == 1";
                        }
                        if ((result = interpreter.eval(key)) == null || !(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                        sb.append(" ");
                        sb.append(value);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.debug("Error while executing: " + key + " : " + e.getMessage());
                        if (!verifyOnly) continue;
                        return new String[]{"@@Error while parsing: " + e.getMessage()};
                    }
                }
                if (!verifyOnly) continue;
                return new String[]{"@@Malformatted line: " + line};
            }
        }
        catch (EvalError e) {
            logger.debug("BeanShell error: " + e.getMessage());
        }
        String completeLine = sb.toString();
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(completeLine, " ");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken().trim();
            if (arg.length() <= 0) continue;
            args.add(arg);
        }
        String[] definitiveArgs = new String[args.size()];
        args.toArray(definitiveArgs);
        return definitiveArgs;
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isVideo(resource, Format.Identifier.ISO) || PlayerUtil.isVideo(resource, Format.Identifier.MKV) || PlayerUtil.isVideo(resource, Format.Identifier.MPG);
    }
}

