/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats.v2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum AudioAttribute {
    CHANNELS_NUMBER(AudioAttribute.set("Channel(s)"), true, true, 2, 1),
    DELAY(AudioAttribute.set("Video_Delay"), false, false, 0, null),
    SAMPLE_FREQUENCY(AudioAttribute.set("SamplingRate"), true, true, 48000, 1);

    private final Set<String> libMediaInfoKeys;
    private final boolean multipleValuesPossible;
    private final boolean getLargerValue;
    private final Integer defaultValue;
    private final Integer minimumValue;
    private static final Pattern libMediaInfoKeyPattern;
    private static final Map<String, AudioAttribute> libMediaInfoKeyToAudioAttributeMap;

    private static Set<String> set(String ... args) {
        return new HashSet<String>(Arrays.asList(args));
    }

    private AudioAttribute(Set<String> libMediaInfoKeys, boolean multipleValuesPossible, boolean getLargerValue, Integer defaultValue, Integer minimumValue) {
        this.libMediaInfoKeys = libMediaInfoKeys;
        this.multipleValuesPossible = multipleValuesPossible;
        this.getLargerValue = getLargerValue;
        this.defaultValue = defaultValue;
        this.minimumValue = minimumValue;
    }

    public static AudioAttribute getAudioAttributeByLibMediaInfoKeyValuePair(String keyValuePair) {
        if (StringUtils.isBlank(keyValuePair)) {
            throw new IllegalArgumentException("Empty keyValuePair passed in.");
        }
        Matcher keyMatcher = libMediaInfoKeyPattern.matcher(keyValuePair);
        if (keyMatcher.find()) {
            String key = keyMatcher.group(1);
            AudioAttribute audioAttribute = libMediaInfoKeyToAudioAttributeMap.get(key.toLowerCase());
            if (audioAttribute == null) {
                throw new IllegalArgumentException("Can't find AudioAttribute for key '" + key + "'.");
            }
            return audioAttribute;
        }
        throw new IllegalArgumentException("Can't find key in keyValuePair '" + keyValuePair + "'.");
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGetLargerValue() {
        return this.getLargerValue;
    }

    public boolean isMultipleValuesPossible() {
        return this.multipleValuesPossible;
    }

    public Integer getMinimumValue() {
        return this.minimumValue;
    }

    static {
        libMediaInfoKeyPattern = Pattern.compile("^\\s*(\\S+)\\s*:");
        libMediaInfoKeyToAudioAttributeMap = new HashMap<String, AudioAttribute>();
        for (AudioAttribute audioAttribute : AudioAttribute.values()) {
            for (String libMediaInfoKey : audioAttribute.libMediaInfoKeys) {
                libMediaInfoKeyToAudioAttributeMap.put(libMediaInfoKey.toLowerCase(), audioAttribute);
            }
        }
    }
}

