/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.IPushOutput;
import net.pms.io.PipeProcess;

public class OutputParams {
    @Deprecated
    public File outputFile;
    public File workDir;
    public Map<String, String> env;
    public double minFileSize;
    public double minBufferSize;
    public double maxBufferSize;
    public double timeseek;
    public double timeend;
    public int fromFrame;
    public int toFrame;
    public int waitbeforestart;
    public PipeProcess[] input_pipes = new PipeProcess[2];
    public PipeProcess[] output_pipes = new PipeProcess[2];
    public DLNAMediaAudio aid;
    public DLNAMediaSubtitle sid;
    public int secondread_minsize;
    public boolean noexitcheck;
    public boolean log;
    public boolean lossyaudio;
    public boolean losslessaudio;
    public boolean no_videoencode;
    public String forceFps;
    public String forceType;
    public RendererConfiguration mediaRenderer;
    public boolean hidebuffer;
    public byte[] header;
    public IPushOutput stdin;
    public boolean avidemux;
    public boolean shift_scr;

    public OutputParams(PmsConfiguration configuration) {
        this.waitbeforestart = configuration != null ? configuration.getVideoTranscodeStartDelay() * 1000 : 6000;
        this.fromFrame = -1;
        this.toFrame = -1;
        this.secondread_minsize = 1000000;
        if (configuration != null) {
            this.minFileSize = configuration.getMinStreamBuffer();
            this.minBufferSize = configuration.getMinMemoryBufferSize();
            this.maxBufferSize = configuration.getMaxMemoryBufferSize();
        }
        if (this.maxBufferSize < 100.0) {
            this.maxBufferSize = 100.0;
        }
        this.timeseek = 0.0;
        this.env = null;
    }

    public void manageFastStart() {
        if (this.mediaRenderer != null && this.mediaRenderer.isTranscodeFastStart()) {
            this.waitbeforestart = 0;
            this.minBufferSize = 1.0;
        }
    }

    public String toString() {
        return "OutputParams [aid=" + this.aid + ", avidemux=" + this.avidemux + ", forceFps=" + this.forceFps + ", forceType=" + this.forceType + ", fromFrame=" + this.fromFrame + ", header=" + Arrays.toString(this.header) + ", hidebuffer=" + this.hidebuffer + ", input_pipes=" + Arrays.toString(this.input_pipes) + ", log=" + this.log + ", losslessaudio=" + this.losslessaudio + ", lossyaudio=" + this.lossyaudio + ", maxBufferSize=" + this.maxBufferSize + ", mediaRenderer=" + this.mediaRenderer + ", minBufferSize=" + this.minBufferSize + ", minFileSize=" + this.minFileSize + ", no_videoencode=" + this.no_videoencode + ", noexitcheck=" + this.noexitcheck + ", output_pipes=" + Arrays.toString(this.output_pipes) + ", secondread_minsize=" + this.secondread_minsize + ", shift_scr=" + this.shift_scr + ", sid=" + this.sid + ", stdin=" + this.stdin + ", timeend=" + this.timeend + ", timeseek=" + this.timeseek + ", toFrame=" + this.toFrame + ", waitbeforestart=" + this.waitbeforestart + ", workDir=" + this.workDir + ", env=" + this.env + "]";
    }
}

