/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import net.pms.io.BufferedOutputFile;
import net.pms.io.BufferedOutputFileImpl;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNamedPipe
extends Thread
implements ProcessWrapper {
    private static final Logger logger = LoggerFactory.getLogger(WindowsNamedPipe.class);
    private String path;
    private boolean in;
    private boolean forceReconnect;
    private Pointer handle1;
    private Pointer handle2;
    private OutputStream writable;
    private InputStream readable;
    private Thread forced;
    private boolean b2;
    private FileOutputStream debug;
    private BufferedOutputFile directBuffer;
    @Deprecated
    public static boolean loop = true;
    private static final int BUFSIZE = 500000;

    public String getPipeName() {
        return this.path;
    }

    public OutputStream getWritable() {
        return this.writable;
    }

    public InputStream getReadable() {
        return this.readable;
    }

    public BufferedOutputFile getDirectBuffer() {
        return this.directBuffer;
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        return null;
    }

    public ArrayList<String> getResults() {
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return !this.isAlive();
    }

    @Override
    public void runInNewThread() {
    }

    @Override
    public boolean isReadyToStop() {
        return false;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
    }

    @Override
    public void stopProcess() {
        this.interrupt();
    }

    @Deprecated
    public static void setLoop(boolean value) {
        loop = value;
    }

    public WindowsNamedPipe(String basename, boolean forceReconnect, boolean in, OutputParams params) {
        this.path = "\\\\.\\pipe\\" + basename;
        this.in = in;
        this.forceReconnect = forceReconnect;
        logger.debug("Creating pipe " + this.path);
        try {
            if (Platform.isWindows()) {
                this.handle1 = Kernel32.INSTANCE.CreateNamedPipeA(this.path, 3, 0, 255, 500000, 500000, 0, null);
                if (forceReconnect) {
                    this.handle2 = Kernel32.INSTANCE.CreateNamedPipeA(this.path, 3, 0, 255, 500000, 500000, 0, null);
                }
                if (params != null) {
                    this.directBuffer = new BufferedOutputFileImpl(params);
                } else {
                    this.writable = new PipedOutputStream();
                    this.readable = new PipedInputStream((PipedOutputStream)this.writable, 500000);
                }
                this.start();
                if (forceReconnect) {
                    this.forced = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            WindowsNamedPipe.this.b2 = Kernel32.INSTANCE.ConnectNamedPipe(WindowsNamedPipe.this.handle2, null);
                        }
                    }, "Forced Reconnector");
                    this.forced.start();
                }
            }
        }
        catch (Exception e1) {
            logger.debug("Caught exception", e1);
        }
    }

    @Override
    public void run() {
        block27: {
            logger.debug("Waiting for pipe connection " + this.path);
            boolean b1 = Kernel32.INSTANCE.ConnectNamedPipe(this.handle1, null);
            if (this.forceReconnect) {
                while (this.forced.isAlive()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {}
                }
                logger.debug("Forced reconnection of " + this.path + " with result : " + this.b2);
                this.handle1 = this.handle2;
            }
            logger.debug("Result of " + this.path + " : " + b1);
            try {
                if (!b1) break block27;
                if (this.in) {
                    IntByReference intRef = new IntByReference();
                    Memory buffer = new Memory(500000L);
                    while (loop) {
                        boolean fSuccess = Kernel32.INSTANCE.ReadFile(this.handle1, buffer, 500000, intRef, null);
                        int cbBytesRead = intRef.getValue();
                        if (cbBytesRead == -1) {
                            if (this.directBuffer != null) {
                                this.directBuffer.close();
                            }
                            if (this.writable != null) {
                                this.writable.close();
                            }
                            if (this.debug != null) {
                                this.debug.close();
                            }
                        } else {
                            if (this.directBuffer != null) {
                                this.directBuffer.write(buffer.getByteArray(0L, cbBytesRead));
                            }
                            if (this.writable != null) {
                                this.writable.write(buffer.getByteArray(0L, cbBytesRead));
                            }
                            if (this.debug != null) {
                                this.debug.write(buffer.getByteArray(0L, cbBytesRead));
                            }
                            if (fSuccess && cbBytesRead != 0) continue;
                            if (this.directBuffer != null) {
                                this.directBuffer.close();
                            }
                            if (this.writable != null) {
                                this.writable.close();
                            }
                            if (this.debug != null) {
                                this.debug.close();
                            }
                        }
                        break block27;
                    }
                    break block27;
                }
                byte[] b = new byte[500000];
                IntByReference intRef = new IntByReference();
                Memory buffer = new Memory(500000L);
                while (loop) {
                    int cbBytesRead = this.readable.read(b);
                    if (cbBytesRead == -1) {
                        this.readable.close();
                        if (this.debug != null) {
                            this.debug.close();
                        }
                    } else {
                        buffer.write(0L, b, 0, cbBytesRead);
                        boolean fSuccess = Kernel32.INSTANCE.WriteFile(this.handle1, buffer, cbBytesRead, intRef, null);
                        int cbWritten = intRef.getValue();
                        if (this.debug != null) {
                            this.debug.write(buffer.getByteArray(0L, cbBytesRead));
                        }
                        if (fSuccess && cbWritten != 0) continue;
                        this.readable.close();
                        if (this.debug != null) {
                            this.debug.close();
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                logger.debug("Error: " + e.getMessage());
            }
        }
        if (!this.in) {
            logger.debug("Disconnected pipe: " + this.path);
            Kernel32.INSTANCE.FlushFileBuffers(this.handle1);
            Kernel32.INSTANCE.DisconnectNamedPipe(this.handle1);
        } else {
            Kernel32.INSTANCE.CloseHandle(this.handle1);
        }
    }

    public static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class);
        public static final Kernel32 SYNC_INSTANCE = (Kernel32)Native.synchronizedLibrary(INSTANCE);

        public Pointer CreateNamedPipeA(String var1, int var2, int var3, int var4, int var5, int var6, int var7, SECURITY_ATTRIBUTES var8);

        public boolean ConnectNamedPipe(Pointer var1, LPOVERLAPPED var2);

        public boolean DisconnectNamedPipe(Pointer var1);

        public boolean FlushFileBuffers(Pointer var1);

        public boolean CloseHandle(Pointer var1);

        public boolean ReadFile(Pointer var1, Pointer var2, int var3, IntByReference var4, LPOVERLAPPED var5);

        public boolean WriteFile(Pointer var1, Pointer var2, int var3, IntByReference var4, LPOVERLAPPED var5);

        public static class LPOVERLAPPED
        extends Structure {
        }

        public static class SECURITY_ATTRIBUTES
        extends Structure {
            public int nLength = this.size();
            public Pointer lpSecurityDescriptor;
            public boolean bInheritHandle;
        }
    }
}

