/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.io.WindowsNamedPipe;
import net.pms.newgui.AboutTab;
import net.pms.newgui.GeneralTab;
import net.pms.newgui.HelpTab;
import net.pms.newgui.IFrame;
import net.pms.newgui.NavigationShareTab;
import net.pms.newgui.StatusTab;
import net.pms.newgui.TracesTab;
import net.pms.newgui.TranscodingTab;
import net.pms.newgui.update.AutoUpdateDialog;
import net.pms.update.AutoUpdater;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LooksFrame
extends JFrame
implements IFrame,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(LooksFrame.class);
    private final AutoUpdater autoUpdater;
    private final PmsConfiguration configuration;
    public static final String START_SERVICE = "start.service";
    private static final long serialVersionUID = 8723727186288427690L;
    protected static final Dimension preferredSize = new Dimension(1000, 750);
    protected static final Dimension minimumSize = new Dimension(800, 480);
    protected static final String[] HELP_PAGES = new String[]{"index.html", null, "general_configuration.html", "navigation_share.html", "transcoding.html", null, null};
    private NavigationShareTab ft;
    private StatusTab st;
    private TracesTab tt;
    private TranscodingTab tr;
    private GeneralTab nt;
    private HelpTab ht;
    private AbstractButton reload;
    private JLabel status;
    private static boolean lookAndFeelInitialized = false;

    public TracesTab getTt() {
        return this.tt;
    }

    public NavigationShareTab getFt() {
        return this.ft;
    }

    public TranscodingTab getTr() {
        return this.tr;
    }

    public AbstractButton getReload() {
        return this.reload;
    }

    static void initializeLookAndFeel() {
        if (lookAndFeelInitialized) {
            return;
        }
        LookAndFeel selectedLaf = null;
        if (Platform.isWindows()) {
            try {
                selectedLaf = (LookAndFeel)Class.forName("com.jgoodies.looks.windows.WindowsLookAndFeel").newInstance();
            }
            catch (Exception e) {
                selectedLaf = new PlasticLookAndFeel();
            }
        } else if (System.getProperty("nativelook") == null && !Platform.isMac()) {
            selectedLaf = new PlasticLookAndFeel();
        } else {
            try {
                String systemClassName = UIManager.getSystemLookAndFeelClassName();
                try {
                    String gtkLAF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                    Class.forName(gtkLAF);
                    if (systemClassName.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                        systemClassName = gtkLAF;
                    }
                }
                catch (ClassNotFoundException ce) {
                    logger.error("Error loading GTK look and feel: ", ce);
                }
                logger.trace("Choosing Java look and feel: " + systemClassName);
                UIManager.setLookAndFeel(systemClassName);
            }
            catch (Exception e1) {
                selectedLaf = new PlasticLookAndFeel();
                logger.error("Error while setting native look and feel: ", e1);
            }
        }
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme(PlasticLookAndFeel.createMyDefaultTheme());
            PlasticLookAndFeel.setTabStyle("default");
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled(false);
        } else if (selectedLaf != null && selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        if (selectedLaf != null) {
            try {
                UIManager.setLookAndFeel(selectedLaf);
            }
            catch (UnsupportedLookAndFeelException e) {
                logger.warn("Can't change look and feel", e);
            }
        }
        lookAndFeelInitialized = true;
    }

    public LooksFrame(AutoUpdater autoUpdater, PmsConfiguration configuration) {
        this.autoUpdater = autoUpdater;
        this.configuration = configuration;
        assert (this.configuration != null);
        Options.setDefaultIconSize(new Dimension(18, 18));
        Options.setUseNarrowButtons(true);
        Options.setTabIconsEnabled(true);
        UIManager.put("jgoodies.popupDropShadowEnabled", null);
        LooksFrame.initializeLookAndFeel();
        if (autoUpdater != null) {
            autoUpdater.addObserver(this);
            autoUpdater.pollServer();
        }
        Font sf = null;
        String language = configuration.getLanguage();
        if (language != null && (language.equals("ja") || language.startsWith("zh"))) {
            sf = new Font("Serif", 0, 12);
        }
        if (sf != null) {
            UIManager.put("Button.font", sf);
            UIManager.put("ToggleButton.font", sf);
            UIManager.put("RadioButton.font", sf);
            UIManager.put("CheckBox.font", sf);
            UIManager.put("ColorChooser.font", sf);
            UIManager.put("ToggleButton.font", sf);
            UIManager.put("ComboBox.font", sf);
            UIManager.put("ComboBoxItem.font", sf);
            UIManager.put("InternalFrame.titleFont", sf);
            UIManager.put("Label.font", sf);
            UIManager.put("List.font", sf);
            UIManager.put("MenuBar.font", sf);
            UIManager.put("Menu.font", sf);
            UIManager.put("MenuItem.font", sf);
            UIManager.put("RadioButtonMenuItem.font", sf);
            UIManager.put("CheckBoxMenuItem.font", sf);
            UIManager.put("PopupMenu.font", sf);
            UIManager.put("OptionPane.font", sf);
            UIManager.put("Panel.font", sf);
            UIManager.put("ProgressBar.font", sf);
            UIManager.put("ScrollPane.font", sf);
            UIManager.put("Viewport", sf);
            UIManager.put("TabbedPane.font", sf);
            UIManager.put("TableHeader.font", sf);
            UIManager.put("TextField.font", sf);
            UIManager.put("PasswordFiled.font", sf);
            UIManager.put("TextArea.font", sf);
            UIManager.put("TextPane.font", sf);
            UIManager.put("EditorPane.font", sf);
            UIManager.put("TitledBorder.font", sf);
            UIManager.put("ToolBar.font", sf);
            UIManager.put("ToolTip.font", sf);
            UIManager.put("Tree.font", sf);
        }
        this.setTitle("Test");
        this.setIconImage(LooksFrame.readImageIcon("icon-32.png").getImage());
        this.setDefaultCloseOperation(2);
        JComponent jp = this.buildContent();
        String showScrollbars = System.getProperty("scrollbars", "").toLowerCase();
        if (showScrollbars.equals("true")) {
            this.setContentPane(new JScrollPane(jp, 22, 32));
        } else if (showScrollbars.equals("optional")) {
            this.setContentPane(new JScrollPane(jp, 20, 30));
        } else {
            this.setContentPane(jp);
        }
        String projectName = PropertiesUtil.getProjectProperties().get("project.name");
        String projectVersion = PropertiesUtil.getProjectProperties().get("project.version");
        String title = projectName + " " + projectVersion;
        if (projectVersion.indexOf("-") > -1) {
            title = title + " - " + Messages.getString("LooksFrame.26");
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(1);
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (screenSize.width < LooksFrame.minimumSize.width || screenSize.height < LooksFrame.minimumSize.height) {
            this.setMinimumSize(screenSize);
        } else {
            this.setMinimumSize(minimumSize);
        }
        if (screenSize.width < LooksFrame.preferredSize.width || screenSize.height < LooksFrame.preferredSize.height) {
            this.setSize(screenSize);
        } else {
            this.setSize(preferredSize);
        }
        this.setResizable(true);
        Dimension paneSize = this.getSize();
        this.setLocation(screenSize.width > paneSize.width ? (screenSize.width - paneSize.width) / 2 : 0, screenSize.height > paneSize.height ? (screenSize.height - paneSize.height) / 2 : 0);
        if (!configuration.isMinimized() && System.getProperty(START_SERVICE) == null) {
            this.setVisible(true);
        }
        PMS.get().getRegistry().addSystemTray(this);
    }

    protected static ImageIcon readImageIcon(String filename) {
        URL url = LooksFrame.class.getResource("/resources/images/" + filename);
        return new ImageIcon(url);
    }

    public JComponent buildContent() {
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(new JPanel());
        AbstractButton save = this.createToolBarButton(Messages.getString("LooksFrame.9"), "filesave-48.png", Messages.getString("LooksFrame.9"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMS.get().save();
            }
        });
        toolBar.add(save);
        toolBar.addSeparator();
        this.reload = this.createToolBarButton(Messages.getString("LooksFrame.12"), "reload_page-48.png", Messages.getString("LooksFrame.12"));
        this.reload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMS.get().reset();
            }
        });
        toolBar.add(this.reload);
        toolBar.addSeparator();
        AbstractButton quit = this.createToolBarButton(Messages.getString("LooksFrame.5"), "exit-48.png", Messages.getString("LooksFrame.5"));
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LooksFrame.this.quit();
            }
        });
        toolBar.add(quit);
        if (System.getProperty(START_SERVICE) != null) {
            quit.setEnabled(false);
        }
        toolBar.add(new JPanel());
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        toolBar.applyComponentOrientation(orientation);
        panel.add((Component)toolBar, "North");
        panel.add((Component)this.buildMain(), "Center");
        this.status = new JLabel(" ");
        this.status.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(0, 5, 0, 5)));
        this.status.setComponentOrientation(orientation);
        panel.add((Component)this.status, "South");
        return panel;
    }

    public JComponent buildMain() {
        final JTabbedPane tabbedPane = new JTabbedPane(1);
        this.st = new StatusTab(this.configuration);
        this.tt = new TracesTab(this.configuration);
        this.tr = new TranscodingTab(this.configuration);
        this.nt = new GeneralTab(this.configuration);
        this.ft = new NavigationShareTab(this.configuration);
        this.ht = new HelpTab();
        tabbedPane.addTab(Messages.getString("LooksFrame.18"), this.st.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.19"), this.tt.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.20"), this.nt.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.22"), this.ft.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.21"), this.tr.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.24"), this.ht.build());
        tabbedPane.addTab(Messages.getString("LooksFrame.25"), new AboutTab().build());
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedIndex = tabbedPane.getSelectedIndex();
                if (HELP_PAGES[selectedIndex] != null) {
                    PMS.setHelpPage(HELP_PAGES[selectedIndex]);
                    LooksFrame.this.ht.updateContents();
                }
            }
        });
        tabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        tabbedPane.setComponentOrientation(orientation);
        return tabbedPane;
    }

    protected AbstractButton createToolBarButton(String text, String iconName, String toolTipText) {
        JButton button = new JButton(text, LooksFrame.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public void quit() {
        WindowsNamedPipe.setLoop(false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            logger.error(null, e);
        }
        System.exit(0);
    }

    @Override
    public void append(String msg) {
        this.tt.append(msg);
    }

    @Override
    public void setReadValue(long v, String msg) {
        this.st.setReadValue(v, msg);
    }

    @Override
    public void setStatusCode(int code, String msg, String icon) {
        this.st.getJl().setText(msg);
        try {
            this.st.getImagePanel().set(ImageIO.read(LooksFrame.class.getResourceAsStream("/resources/images/" + icon)));
        }
        catch (IOException e) {
            logger.error(null, e);
        }
    }

    @Override
    public void setValue(int v, String msg) {
        this.st.getJpb().setValue(v);
        this.st.getJpb().setString(msg);
    }

    @Override
    public void setReloadable(boolean bool) {
        if (bool) {
            this.reload.setIcon(LooksFrame.readImageIcon("reload_page_required-48.png"));
            this.reload.setToolTipText(Messages.getString("LooksFrame.13"));
        } else {
            this.reload.setIcon(LooksFrame.readImageIcon("reload_page-48.png"));
            this.reload.setToolTipText(Messages.getString("LooksFrame.12"));
        }
    }

    @Override
    public void addEngines() {
        this.tr.addEngines();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.configuration.isAutoUpdate()) {
            this.checkForUpdates();
        }
    }

    public void checkForUpdates() {
        if (this.autoUpdater != null) {
            try {
                AutoUpdateDialog.showIfNecessary(this, this.autoUpdater);
            }
            catch (NoClassDefFoundError ncdfe) {
                logger.error("Error displaying AutoUpdateDialog", ncdfe);
            }
        }
    }

    @Override
    public void setStatusLine(String line) {
        if (line == null) {
            line = " ";
        }
        this.status.setText(line);
    }

    @Override
    public void addRendererIcon(int code, String msg, String icon) {
        this.st.addRendererIcon(code, msg, icon);
    }

    @Override
    public void serverReady() {
        this.nt.addRenderers();
        this.nt.addPlugins();
    }

    @Override
    public void setScanLibraryEnabled(boolean flag) {
        this.getFt().setScanLibraryEnabled(flag);
    }
}

