window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["what-is-rustdoc.html#what-is-rustdoc","what-is-rustdoc.html#basic-usage","what-is-rustdoc.html#configuring-rustdoc","what-is-rustdoc.html#using-rustdoc-with-cargo","what-is-rustdoc.html#outer-and-inner-documentation","what-is-rustdoc.html#using-standalone-markdown-files","what-is-rustdoc.html#summary","command-line-arguments.html#command-line-arguments","command-line-arguments.html#-h--help-help","command-line-arguments.html#-v--version-version-information","command-line-arguments.html#-v--verbose-more-verbose-output","command-line-arguments.html#-o--out-dir-output-directory-path","command-line-arguments.html#--crate-name-controlling-the-name-of-the-crate","command-line-arguments.html#--document-private-items-show-items-that-are-not-public","command-line-arguments.html#-l--library-path-where-to-look-for-dependencies","command-line-arguments.html#--cfg-passing-configuration-flags","command-line-arguments.html#--check-cfg-check-configuration-flags","command-line-arguments.html#--extern-specify-a-dependencys-location","command-line-arguments.html#-c--codegen-pass-codegen-options-to-rustc","command-line-arguments.html#--test-run-code-examples-as-tests","command-line-arguments.html#--test-args-pass-options-to-test-runner","command-line-arguments.html#--test-run-directory-run-code-examples-in-a-specific-directory","command-line-arguments.html#--test-runtool---test-runtool-arg-program-to-run-tests-with-args-to-pass-to-it","command-line-arguments.html#--target-generate-documentation-for-the-specified-target-triple","command-line-arguments.html#--default-theme-set-the-default-theme","command-line-arguments.html#--markdown-css-include-more-css-files-when-rendering-markdown","command-line-arguments.html#--html-in-header-include-more-html-in-head","command-line-arguments.html#--html-before-content-include-more-html-before-the-content","command-line-arguments.html#--html-after-content-include-more-html-after-the-content","command-line-arguments.html#--markdown-playground-url-control-the-location-of-the-playground","command-line-arguments.html#--markdown-no-toc-dont-generate-a-table-of-contents","command-line-arguments.html#-e--extend-css-extend-rustdocs-css","command-line-arguments.html#--sysroot-override-the-system-root","command-line-arguments.html#--edition-control-the-edition-of-docs-and-doctests","command-line-arguments.html#--theme-add-a-theme-to-the-documentation-output","command-line-arguments.html#--check-theme-verify-custom-themes-against-the-default-theme","command-line-arguments.html#--crate-version-control-the-crate-version","command-line-arguments.html#--load-source-code-from-the-standard-input","command-line-arguments.html#path-load-command-line-flags-from-a-path","command-line-arguments.html#--passes-add-more-rustdoc-passes","command-line-arguments.html#--no-defaults-dont-run-default-passes","command-line-arguments.html#-r--input-format-input-format","how-to-read-rustdoc.html#how-to-read-rustdoc-output","how-to-read-rustdoc.html#structure","how-to-read-rustdoc.html#the-item-documentation","how-to-read-rustdoc.html#sections","how-to-read-rustdoc.html#navigation","how-to-read-rustdoc.html#the-navigation-bar","how-to-read-rustdoc.html#the-theme-picker-and-search-interface","how-to-read-rustdoc.html#shortcuts","read-documentation/in-doc-settings.html#rustdoc-in-doc-settings","read-documentation/in-doc-settings.html#changing-displayed-theme","read-documentation/in-doc-settings.html#auto-hide-item-contents-for-large-items","read-documentation/in-doc-settings.html#auto-hide-item-methods-documentation","read-documentation/in-doc-settings.html#auto-hide-trait-implementation-documentation","read-documentation/in-doc-settings.html#directly-go-to-item-in-search-if-there-is-only-one-result","read-documentation/in-doc-settings.html#show-line-numbers-on-code-examples","read-documentation/in-doc-settings.html#disable-keyboard-shortcuts","read-documentation/search.html#rustdoc-search","read-documentation/search.html#search-by-name","read-documentation/search.html#tabs-in-the-search-by-name-interface","read-documentation/search.html#searching-by-type-signature","read-documentation/search.html#non-functions-in-type-based-search","read-documentation/search.html#how-type-based-search-works","read-documentation/search.html#wrappers-that-can-be-omitted","read-documentation/search.html#primitives-with-special-syntax","read-documentation/search.html#limitations-and-quirks-of-type-based-search","read-documentation/search.html#item-filtering","read-documentation/search.html#search-query-syntax","how-to-write-documentation.html#how-to-write-documentation","how-to-write-documentation.html#getting-started","how-to-write-documentation.html#documenting-components","how-to-write-documentation.html#markdown","how-to-write-documentation.html#strikethrough","how-to-write-documentation.html#footnotes","how-to-write-documentation.html#tables","how-to-write-documentation.html#task-lists","how-to-write-documentation.html#smart-punctuation","how-to-write-documentation.html#adding-a-warning-block","write-documentation/what-to-include.html#what-to-include-and-exclude","write-documentation/what-to-include.html#examples","write-documentation/what-to-include.html#what-to-exclude","write-documentation/what-to-include.html#customizing-the-output","write-documentation/the-doc-attribute.html#the-doc-attribute","write-documentation/the-doc-attribute.html#at-the-crate-level","write-documentation/the-doc-attribute.html#html_favicon_url","write-documentation/the-doc-attribute.html#html_logo_url","write-documentation/the-doc-attribute.html#html_playground_url","write-documentation/the-doc-attribute.html#issue_tracker_base_url","write-documentation/the-doc-attribute.html#html_root_url","write-documentation/the-doc-attribute.html#html_no_source","write-documentation/the-doc-attribute.html#testno_crate_inject","write-documentation/the-doc-attribute.html#at-the-item-level","write-documentation/the-doc-attribute.html#inline-and-no_inline","write-documentation/the-doc-attribute.html#hidden","write-documentation/the-doc-attribute.html#alias","write-documentation/the-doc-attribute.html#testattr","write-documentation/re-exports.html#re-exports","write-documentation/re-exports.html#inlining-rules","write-documentation/re-exports.html#inlining-with-docinline","write-documentation/re-exports.html#preventing-inlining-with-docno_inline","write-documentation/re-exports.html#attributes","write-documentation/linking-to-items-by-name.html#linking-to-items-by-name","write-documentation/linking-to-items-by-name.html#valid-links","write-documentation/linking-to-items-by-name.html#namespaces-and-disambiguators","write-documentation/linking-to-items-by-name.html#warnings-re-exports-and-scoping","write-documentation/linking-to-items-by-name.html#what-happens-in-case-an-intra-doc-link-cannot-be-generated","write-documentation/documentation-tests.html#documentation-tests","write-documentation/documentation-tests.html#passing-or-failing-a-doctest","write-documentation/documentation-tests.html#pre-processing-examples","write-documentation/documentation-tests.html#hiding-portions-of-the-example","write-documentation/documentation-tests.html#using--in-doc-tests","write-documentation/documentation-tests.html#showing-warnings-in-doctests","write-documentation/documentation-tests.html#documenting-macros","write-documentation/documentation-tests.html#attributes","write-documentation/documentation-tests.html#ignoring-targets","write-documentation/documentation-tests.html#custom-css-classes-for-code-blocks","write-documentation/documentation-tests.html#syntax-reference","write-documentation/documentation-tests.html#include-items-only-when-collecting-doctests","write-documentation/documentation-tests.html#controlling-the-compilation-and-run-directories","lints.html#lints","lints.html#broken_intra_doc_links","lints.html#private_intra_doc_links","lints.html#missing_docs","lints.html#missing_crate_level_docs","lints.html#missing_doc_code_examples","lints.html#private_doc_tests","lints.html#invalid_codeblock_attributes","lints.html#invalid_html_tags","lints.html#invalid_rust_codeblocks","lints.html#bare_urls","lints.html#unescaped_backticks","lints.html#redundant_explicit_links","scraped-examples.html#scraped-examples","scraped-examples.html#how-to-use-this-feature","scraped-examples.html#how-it-works","scraped-examples.html#faq","scraped-examples.html#my-example-is-not-showing-up-in-the-documentation","advanced-features.html#advanced-features","advanced-features.html#cfgdoc-documenting-platform-specific-or-feature-specific-information","advanced-features.html#interactions-between-platform-specific-docs","advanced-features.html#add-aliases-for-an-item-in-documentation-search","advanced-features.html#custom-search-engines","advanced-features.html#repr-documenting-the-representation-of-a-type","advanced-features.html#reprtransparent","unstable-features.html#unstable-features","unstable-features.html#nightly-gated-functionality","unstable-features.html#error-numbers-for-compile-fail-doctests","unstable-features.html#missing_doc_code_examples-lint","unstable-features.html#extensions-to-the-doc-attribute","unstable-features.html#adding-your-trait-to-the-notable-traits-dialog","unstable-features.html#exclude-certain-dependencies-from-documentation","unstable-features.html#document-primitives","unstable-features.html#document-keywords","unstable-features.html#document-builtin-attributes","unstable-features.html#use-the-rust-logo-as-the-crate-logo","unstable-features.html#effects-of-other-nightly-features","unstable-features.html#fundamental-types","unstable-features.html#unstable-command-line-arguments","unstable-features.html#--merge---parts-out-dir-and---include-parts-dir","unstable-features.html#--document-hidden-items-show-items-that-are-dochidden","unstable-features.html#--markdown-before-content-include-rendered-markdown-before-the-content","unstable-features.html#--markdown-after-content-include-rendered-markdown-after-the-content","unstable-features.html#--playground-url-control-the-location-of-the-playground","unstable-features.html#--sort-modules-by-appearance-control-how-items-on-module-pages-are-sorted","unstable-features.html#--show-type-layout-add-a-section-to-each-types-docs-describing-its-memory-layout","unstable-features.html#--resource-suffix-modifying-the-name-of-cssjavascript-in-crate-docs","unstable-features.html#--extern-html-root-url-control-how-rustdoc-links-to-non-local-crates","unstable-features.html#-z-force-unstable-if-unmarked","unstable-features.html#--index-page-provide-a-top-level-landing-page-for-docs","unstable-features.html#--enable-index-page-generate-a-default-index-page-for-docs","unstable-features.html#--no-capture-disable-output-capture-for-test","unstable-features.html#--check-only-checks-the-documentation","unstable-features.html#--static-root-path-control-how-static-files-are-loaded-in-html-output","unstable-features.html#--persist-doctests-persist-doctest-executables-after-running","unstable-features.html#--show-coverage-calculate-the-percentage-of-items-with-documentation","unstable-features.html#json-output","unstable-features.html#-w--output-format-output-format","unstable-features.html#json","unstable-features.html#doctest","unstable-features.html#html","unstable-features.html#--with-examples-include-examples-of-uses-of-items-as-documentation","unstable-features.html#--generate-link-to-definition-generate-links-on-types-in-source-code","unstable-features.html#--test-builder-rustc-like-program-to-build-tests","unstable-features.html#--test-builder-wrapper-wrap-calls-to-the-test-builder","unstable-features.html#passing-arguments-to-rustc-when-compiling-doctests","unstable-features.html#--generate-macro-expansion-generate-macros-expansion-toggles-in-source-code","unstable-features.html#doccfg-and-docauto_cfg","unstable-features.html#doccfg","unstable-features.html#docauto_cfghide","unstable-features.html#docauto_cfgshow","unstable-features.html#docauto_cfgdocauto_cfg--truedocauto_cfg--false","unstable-features.html#inheritance","unstable-features.html#re-exports-and-inlining","deprecated-features.html#deprecated-features","deprecated-features.html#passes","references.html#references","references.html#official","references.html#community"],"index":{"documentStore":{"docInfo":{"0":{"body":25,"breadcrumbs":2,"title":1},"1":{"body":71,"breadcrumbs":3,"title":2},"10":{"body":50,"breadcrumbs":8,"title":5},"100":{"body":28,"breadcrumbs":7,"title":3},"101":{"body":116,"breadcrumbs":5,"title":1},"102":{"body":71,"breadcrumbs":8,"title":3},"103":{"body":90,"breadcrumbs":7,"title":2},"104":{"body":132,"breadcrumbs":7,"title":2},"105":{"body":119,"breadcrumbs":9,"title":4},"106":{"body":47,"breadcrumbs":11,"title":6},"107":{"body":66,"breadcrumbs":6,"title":2},"108":{"body":40,"breadcrumbs":7,"title":3},"109":{"body":89,"breadcrumbs":7,"title":3},"11":{"body":27,"breadcrumbs":9,"title":6},"110":{"body":277,"breadcrumbs":7,"title":3},"111":{"body":144,"breadcrumbs":7,"title":3},"112":{"body":46,"breadcrumbs":7,"title":3},"113":{"body":76,"breadcrumbs":6,"title":2},"114":{"body":276,"breadcrumbs":5,"title":1},"115":{"body":84,"breadcrumbs":6,"title":2},"116":{"body":110,"breadcrumbs":9,"title":5},"117":{"body":72,"breadcrumbs":6,"title":2},"118":{"body":164,"breadcrumbs":8,"title":4},"119":{"body":76,"breadcrumbs":8,"title":4},"12":{"body":25,"breadcrumbs":8,"title":5},"120":{"body":43,"breadcrumbs":4,"title":1},"121":{"body":85,"breadcrumbs":4,"title":1},"122":{"body":98,"breadcrumbs":4,"title":1},"123":{"body":35,"breadcrumbs":4,"title":1},"124":{"body":52,"breadcrumbs":4,"title":1},"125":{"body":54,"breadcrumbs":4,"title":1},"126":{"body":37,"breadcrumbs":4,"title":1},"127":{"body":73,"breadcrumbs":4,"title":1},"128":{"body":53,"breadcrumbs":4,"title":1},"129":{"body":67,"breadcrumbs":4,"title":1},"13":{"body":51,"breadcrumbs":9,"title":6},"130":{"body":52,"breadcrumbs":4,"title":1},"131":{"body":72,"breadcrumbs":4,"title":1},"132":{"body":74,"breadcrumbs":4,"title":1},"133":{"body":47,"breadcrumbs":4,"title":2},"134":{"body":30,"breadcrumbs":4,"title":2},"135":{"body":78,"breadcrumbs":3,"title":1},"136":{"body":0,"breadcrumbs":3,"title":1},"137":{"body":13,"breadcrumbs":6,"title":4},"138":{"body":8,"breadcrumbs":4,"title":2},"139":{"body":111,"breadcrumbs":9,"title":7},"14":{"body":34,"breadcrumbs":8,"title":5},"140":{"body":41,"breadcrumbs":7,"title":5},"141":{"body":63,"breadcrumbs":7,"title":5},"142":{"body":70,"breadcrumbs":5,"title":3},"143":{"body":29,"breadcrumbs":6,"title":4},"144":{"body":84,"breadcrumbs":3,"title":1},"145":{"body":44,"breadcrumbs":4,"title":2},"146":{"body":25,"breadcrumbs":5,"title":3},"147":{"body":66,"breadcrumbs":7,"title":5},"148":{"body":32,"breadcrumbs":4,"title":2},"149":{"body":12,"breadcrumbs":5,"title":3},"15":{"body":23,"breadcrumbs":7,"title":4},"150":{"body":90,"breadcrumbs":7,"title":5},"151":{"body":85,"breadcrumbs":6,"title":4},"152":{"body":27,"breadcrumbs":4,"title":2},"153":{"body":27,"breadcrumbs":4,"title":2},"154":{"body":28,"breadcrumbs":5,"title":3},"155":{"body":36,"breadcrumbs":7,"title":5},"156":{"body":9,"breadcrumbs":5,"title":3},"157":{"body":82,"breadcrumbs":4,"title":2},"158":{"body":32,"breadcrumbs":6,"title":4},"159":{"body":113,"breadcrumbs":9,"title":7},"16":{"body":35,"breadcrumbs":8,"title":5},"160":{"body":53,"breadcrumbs":8,"title":6},"161":{"body":56,"breadcrumbs":10,"title":8},"162":{"body":49,"breadcrumbs":8,"title":6},"163":{"body":96,"breadcrumbs":7,"title":5},"164":{"body":37,"breadcrumbs":10,"title":8},"165":{"body":50,"breadcrumbs":13,"title":11},"166":{"body":46,"breadcrumbs":9,"title":7},"167":{"body":112,"breadcrumbs":12,"title":10},"168":{"body":41,"breadcrumbs":6,"title":4},"169":{"body":30,"breadcrumbs":10,"title":8},"17":{"body":28,"breadcrumbs":7,"title":4},"170":{"body":9,"breadcrumbs":10,"title":8},"171":{"body":22,"breadcrumbs":7,"title":5},"172":{"body":20,"breadcrumbs":5,"title":3},"173":{"body":70,"breadcrumbs":11,"title":9},"174":{"body":39,"breadcrumbs":8,"title":6},"175":{"body":154,"breadcrumbs":8,"title":6},"176":{"body":50,"breadcrumbs":4,"title":2},"177":{"body":0,"breadcrumbs":7,"title":5},"178":{"body":51,"breadcrumbs":3,"title":1},"179":{"body":196,"breadcrumbs":3,"title":1},"18":{"body":91,"breadcrumbs":9,"title":6},"180":{"body":14,"breadcrumbs":3,"title":1},"181":{"body":107,"breadcrumbs":8,"title":6},"182":{"body":15,"breadcrumbs":10,"title":8},"183":{"body":22,"breadcrumbs":8,"title":6},"184":{"body":54,"breadcrumbs":9,"title":7},"185":{"body":151,"breadcrumbs":7,"title":5},"186":{"body":10,"breadcrumbs":11,"title":9},"187":{"body":79,"breadcrumbs":4,"title":2},"188":{"body":93,"breadcrumbs":3,"title":1},"189":{"body":200,"breadcrumbs":3,"title":1},"19":{"body":22,"breadcrumbs":8,"title":5},"190":{"body":90,"breadcrumbs":3,"title":1},"191":{"body":78,"breadcrumbs":7,"title":5},"192":{"body":35,"breadcrumbs":3,"title":1},"193":{"body":124,"breadcrumbs":5,"title":3},"194":{"body":0,"breadcrumbs":4,"title":2},"195":{"body":42,"breadcrumbs":3,"title":1},"196":{"body":12,"breadcrumbs":2,"title":1},"197":{"body":17,"breadcrumbs":2,"title":1},"198":{"body":18,"breadcrumbs":2,"title":1},"2":{"body":93,"breadcrumbs":3,"title":2},"20":{"body":24,"breadcrumbs":9,"title":6},"21":{"body":23,"breadcrumbs":11,"title":8},"22":{"body":67,"breadcrumbs":13,"title":10},"23":{"body":28,"breadcrumbs":9,"title":6},"24":{"body":54,"breadcrumbs":8,"title":5},"25":{"body":31,"breadcrumbs":11,"title":8},"26":{"body":22,"breadcrumbs":9,"title":6},"27":{"body":30,"breadcrumbs":11,"title":8},"28":{"body":27,"breadcrumbs":9,"title":6},"29":{"body":23,"breadcrumbs":9,"title":6},"3":{"body":86,"breadcrumbs":4,"title":3},"30":{"body":20,"breadcrumbs":9,"title":6},"31":{"body":20,"breadcrumbs":9,"title":6},"32":{"body":17,"breadcrumbs":7,"title":4},"33":{"body":33,"breadcrumbs":8,"title":5},"34":{"body":47,"breadcrumbs":8,"title":5},"35":{"body":59,"breadcrumbs":11,"title":8},"36":{"body":27,"breadcrumbs":8,"title":5},"37":{"body":20,"breadcrumbs":8,"title":5},"38":{"body":29,"breadcrumbs":9,"title":6},"39":{"body":7,"breadcrumbs":8,"title":5},"4":{"body":55,"breadcrumbs":4,"title":3},"40":{"body":7,"breadcrumbs":8,"title":5},"41":{"body":24,"breadcrumbs":8,"title":5},"42":{"body":26,"breadcrumbs":6,"title":3},"43":{"body":29,"breadcrumbs":4,"title":1},"44":{"body":84,"breadcrumbs":5,"title":2},"45":{"body":34,"breadcrumbs":4,"title":1},"46":{"body":26,"breadcrumbs":4,"title":1},"47":{"body":35,"breadcrumbs":5,"title":2},"48":{"body":35,"breadcrumbs":7,"title":4},"49":{"body":47,"breadcrumbs":4,"title":1},"5":{"body":46,"breadcrumbs":5,"title":4},"50":{"body":17,"breadcrumbs":8,"title":3},"51":{"body":29,"breadcrumbs":8,"title":3},"52":{"body":23,"breadcrumbs":11,"title":6},"53":{"body":16,"breadcrumbs":10,"title":5},"54":{"body":24,"breadcrumbs":10,"title":5},"55":{"body":23,"breadcrumbs":11,"title":6},"56":{"body":13,"breadcrumbs":10,"title":5},"57":{"body":31,"breadcrumbs":8,"title":3},"58":{"body":15,"breadcrumbs":6,"title":2},"59":{"body":96,"breadcrumbs":6,"title":2},"6":{"body":11,"breadcrumbs":2,"title":1},"60":{"body":59,"breadcrumbs":8,"title":4},"61":{"body":85,"breadcrumbs":7,"title":3},"62":{"body":33,"breadcrumbs":9,"title":5},"63":{"body":278,"breadcrumbs":8,"title":4},"64":{"body":7,"breadcrumbs":6,"title":2},"65":{"body":152,"breadcrumbs":7,"title":3},"66":{"body":149,"breadcrumbs":9,"title":5},"67":{"body":43,"breadcrumbs":6,"title":2},"68":{"body":213,"breadcrumbs":7,"title":3},"69":{"body":64,"breadcrumbs":4,"title":2},"7":{"body":5,"breadcrumbs":6,"title":3},"70":{"body":216,"breadcrumbs":4,"title":2},"71":{"body":226,"breadcrumbs":4,"title":2},"72":{"body":25,"breadcrumbs":3,"title":1},"73":{"body":32,"breadcrumbs":3,"title":1},"74":{"body":52,"breadcrumbs":3,"title":1},"75":{"body":36,"breadcrumbs":3,"title":1},"76":{"body":24,"breadcrumbs":4,"title":2},"77":{"body":21,"breadcrumbs":4,"title":2},"78":{"body":52,"breadcrumbs":5,"title":3},"79":{"body":94,"breadcrumbs":6,"title":2},"8":{"body":27,"breadcrumbs":6,"title":3},"80":{"body":117,"breadcrumbs":5,"title":1},"81":{"body":40,"breadcrumbs":5,"title":1},"82":{"body":56,"breadcrumbs":6,"title":2},"83":{"body":137,"breadcrumbs":6,"title":2},"84":{"body":6,"breadcrumbs":6,"title":2},"85":{"body":26,"breadcrumbs":5,"title":1},"86":{"body":29,"breadcrumbs":5,"title":1},"87":{"body":53,"breadcrumbs":5,"title":1},"88":{"body":31,"breadcrumbs":5,"title":1},"89":{"body":53,"breadcrumbs":5,"title":1},"9":{"body":18,"breadcrumbs":7,"title":4},"90":{"body":13,"breadcrumbs":5,"title":1},"91":{"body":15,"breadcrumbs":5,"title":1},"92":{"body":8,"breadcrumbs":6,"title":2},"93":{"body":163,"breadcrumbs":6,"title":2},"94":{"body":17,"breadcrumbs":5,"title":1},"95":{"body":101,"breadcrumbs":5,"title":1},"96":{"body":49,"breadcrumbs":5,"title":1},"97":{"body":110,"breadcrumbs":6,"title":2},"98":{"body":149,"breadcrumbs":6,"title":2},"99":{"body":32,"breadcrumbs":6,"title":2}},"docs":{"0":{"body":"The standard Rust distribution ships with a tool called rustdoc. Its job is\\nto generate documentation for Rust projects. On a fundamental level, Rustdoc\\ntakes as an argument either a crate root or a Markdown file, and produces HTML,\\nCSS, and JavaScript.","breadcrumbs":"What is rustdoc? » What is rustdoc?","id":"0","title":"What is rustdoc?"},"1":{"body":"Let’s give it a try! Create a new project with Cargo: $ cargo new docs --lib\\n$ cd docs In src/lib.rs, Cargo has generated some sample code. Delete\\nit and replace it with this: #![allow(unused)] fn main() {\\n/// foo is a function\\nfn foo() {} } Let’s run rustdoc on our code. To do so, we can call it with the path to\\nour crate root like this: $ rustdoc src/lib.rs This will create a new directory, doc, with a website inside! In our case,\\nthe main page is located in doc/lib/index.html. If you open that up in\\na web browser, you will see a page with a search bar, and “Crate lib” at the\\ntop, with no contents. You can also use cargo doc to generate documentation for the whole project.\\nSee Using rustdoc with Cargo.","breadcrumbs":"What is rustdoc? » Basic usage","id":"1","title":"Basic usage"},"10":{"body":"Using this flag looks like this: $ rustdoc -v src/lib.rs\\n$ rustdoc --verbose src/lib.rs This enables “verbose mode”, which means that more information will be written\\nto standard out. What is written depends on the other flags you’ve passed in.\\nFor example, with --version: $ rustdoc --verbose --version\\nrustdoc 1.17.0 (56124baa9 2017-04-24)\\nbinary: rustdoc\\ncommit-hash: hash\\ncommit-date: date\\nhost: host-tuple\\nrelease: 1.17.0\\nLLVM version: 3.9","breadcrumbs":"Command-line arguments » -v/ --verbose: more verbose output","id":"10","title":"-v/ --verbose: more verbose output"},"100":{"body":"On the opposite of the #[doc(inline)] attribute, if you want to prevent an item from being\\ninlined, you can use #[doc(no_inline)]: mod private_mod { pub struct Public;\\n}\\n#[doc(no_inline)]\\npub use self::private_mod::Public; In the generated documentation, you will see a re-export at the crate root and not the type\\ndirectly.","breadcrumbs":"How to write documentation » Re-exports » Preventing inlining with #[doc(no_inline)]","id":"100","title":"Preventing inlining with #[doc(no_inline)]"},"101":{"body":"When an item is inlined, its doc comments and most of its attributes will be inlined along with it: mod private_mod { /// First #[cfg(a)] pub struct InPrivate; /// Second #[cfg(b)] pub use self::InPrivate as Second;\\n} /// Third\\n#[doc(inline)]\\n#[cfg(c)]\\npub use self::private_mod::Second as Visible; In this case, Visible will have as documentation First Second Third and will also have as cfg: #[cfg(a, b, c)]. Intra-doc links are resolved relative to where the doc comment is\\ndefined. There are a few attributes which are not inlined though: #[doc(alias=\\"\\")] #[doc(inline)] #[doc(no_inline)] #[doc(hidden)] (because the re-export itself and its attributes are ignored). All other attributes are inherited when inlined, so that the documentation matches the behavior if\\nthe inlined item was directly defined at the spot where it’s shown. These rules also apply if the item is inlined with a glob re-export: mod private_mod { /// First #[cfg(a)] pub struct InPrivate;\\n} #[cfg(c)]\\npub use self::private_mod::*; Otherwise, the attributes displayed will be from the re-exported item and the attributes on the\\nre-export itself will be ignored: mod private_mod { /// First #[cfg(a)] pub struct InPrivate;\\n} #[cfg(c)]\\npub use self::private_mod::InPrivate; In the above case, cfg(c) will not be displayed in the docs.","breadcrumbs":"How to write documentation » Re-exports » Attributes","id":"101","title":"Attributes"},"102":{"body":"Rustdoc is capable of directly linking to other rustdoc pages using the path of\\nthe item as a link. This is referred to as an ‘intra-doc link’. For example, in the following code all of the links will link to the rustdoc page for Bar: #![allow(unused)] fn main() {\\n/// This struct is not [Bar]\\npub struct Foo1; /// This struct is also not [bar](Bar)\\npub struct Foo2; /// This struct is also not [bar][b]\\n///\\n/// [b]: Bar\\npub struct Foo3; /// This struct is also not [`Bar`]\\npub struct Foo4; /// This struct *is* [`Bar`]!\\npub struct Bar; } Unlike normal Markdown, [bar][Bar] syntax is also supported without needing a [Bar]: ... reference link. Backticks around the link will be stripped, so [`Option`] will correctly\\nlink to Option.","breadcrumbs":"How to write documentation » Linking to items by name » Linking to items by name","id":"102","title":"Linking to items by name"},"103":{"body":"You can refer to anything in scope, and use paths, including Self, self, super, and crate. Associated items (functions, types, and constants) are supported, but not for blanket\\ntrait implementations. Rustdoc also supports linking to all primitives listed in the standard library documentation. You can also refer to items with generic parameters like Vec<T>. The link will\\nresolve as if you had written [`Vec<T>`](Vec). Fully-qualified syntax (for example, <Vec as IntoIterator>::into_iter()) is not yet supported, however. #![allow(unused)] fn main() {\\nuse std::sync::mpsc::Receiver; /// This is a version of [`Receiver<T>`] with support for [`std::future`].\\n///\\n/// You can obtain a [`std::future::Future`] by calling [`Self::recv()`].\\npub struct AsyncReceiver<T> { sender: Receiver<T>\\n} impl<T> AsyncReceiver<T> { pub async fn recv() -> T { unimplemented!() }\\n} } Rustdoc allows using URL fragment specifiers, just like a normal link: #![allow(unused)] fn main() {\\n/// This is a special implementation of [positional parameters].\\n///\\n/// [positional parameters]: std::fmt#formatting-parameters\\nstruct MySpecialFormatter; }","breadcrumbs":"How to write documentation » Linking to items by name » Valid links","id":"103","title":"Valid links"},"104":{"body":"Paths in Rust have three namespaces: type, value, and macro. Item names must be unique within\\ntheir namespace, but can overlap with items in other namespaces. In case of ambiguity,\\nrustdoc will warn about the ambiguity and suggest a disambiguator. #![allow(unused)] fn main() {\\n/// See also: [`Foo`](struct@Foo)\\nstruct Bar; /// This is different from [`Foo`](fn@Foo)\\nstruct Foo {} fn Foo() {} } These prefixes will be stripped when displayed in the documentation, so [struct@Foo] will be\\nrendered as Foo. The following prefixes are available: struct, enum, trait, union, mod, module, const, constant, fn, function, field, variant, method, derive, type, value, macro, tyalias, typealias, prim or primitive. You can also disambiguate for functions by adding () after the function name,\\nor for macros by adding ! after the macro name. The macro ! can be followed by (), {},\\nor []. Example: #![allow(unused)] fn main() {\\n/// This is different from [`foo!()`].\\nfn foo() {} /// This is different from [`foo()`]\\nmacro_rules! foo { () => {}\\n} } There is one case where the disambiguation will be performed automatically: if an intra doc\\nlink is resolved at the same time as a trait and as a derive proc-macro. In this case, it’ll\\nalways generate a link to the trait and not emit a “missing disambiguation” warning. A good\\nexample of this case is when you link to the Clone trait: there is also a Clone\\nproc-macro but it ignores it in this case. If you want to link to the proc-macro, you can\\nuse the macro@ disambiguator.","breadcrumbs":"How to write documentation » Linking to items by name » Namespaces and Disambiguators","id":"104","title":"Namespaces and Disambiguators"},"105":{"body":"Links are resolved in the scope of the module where the item is defined, even\\nwhen the item is re-exported. If a link from another crate fails to resolve, no\\nwarning is given. #![allow(unused)] fn main() {\\nmod inner { /// Link to [f()] pub struct S; pub fn f() {}\\n}\\npub use inner::S; // the link to `f` will still resolve correctly } When re-exporting an item, rustdoc allows adding additional documentation to it.\\nThat additional documentation will be resolved in the scope of the re-export, not\\nthe original, allowing you to link to items in the new crate. The new links\\nwill still give a warning if they fail to resolve. #![allow(unused)] fn main() {\\n/// See also [foo()]\\npub use std::process::Command; pub fn foo() {} } This is especially useful for proc-macros, which must always be defined in their own dedicated crate. Note: Because of how macro_rules! macros are scoped in Rust, the intra-doc links of a macro_rules! macro will be resolved relative to the crate root, as opposed to the\\nmodule it is defined in. If links do not look ‘sufficiently like’ an intra-doc link, they will be ignored and no warning\\nwill be given, even if the link fails to resolve. For example, any link containing / or []\\ncharacters will be ignored.","breadcrumbs":"How to write documentation » Linking to items by name » Warnings, re-exports, and scoping","id":"105","title":"Warnings, re-exports, and scoping"},"106":{"body":"In some cases (items behind a cfg for example), an intra-doc link cannot be generated to item.\\nThere are different ways to create a link in markdown, and depending on the one you use, it will\\nrender differently in this case: 1. [a]\\n2. [b][c]\\n3. [d](e)\\n4. [f] [f]: g 1. and 2. will be displayed as is in the rendered documentation (ie, [a] and [b][c])\\nwhereas 3. and 4. will be replaced by a link targeting e for [d](e) and g for [f].","breadcrumbs":"How to write documentation » Linking to items by name » What happens in case an intra-doc link cannot be generated","id":"106","title":"What happens in case an intra-doc link cannot be generated"},"107":{"body":"rustdoc supports executing your documentation examples as tests. This makes sure\\nthat examples within your documentation are up to date and working. The basic idea is this: #![allow(unused)] fn main() {\\n/// # Examples\\n///\\n/// ```\\n/// let x = 5;\\n/// ``` fn f() {} } The triple backticks start and end code blocks. If this were in a file named foo.rs,\\nrunning rustdoc --test foo.rs will extract this example, and then run it as a test. Please note that by default, if no language is set for the block code, rustdoc\\nassumes it is Rust code. So the following: ```rust\\nlet x = 5;\\n``` is strictly equivalent to: ```\\nlet x = 5;\\n``` There’s some subtlety though! Read on for more details.","breadcrumbs":"How to write documentation » Documentation tests » Documentation tests","id":"107","title":"Documentation tests"},"108":{"body":"Like regular unit tests, regular doctests are considered to “pass”\\nif they compile and run without panicking.\\nSo if you want to demonstrate that some computation gives a certain result,\\nthe assert! family of macros works the same as other Rust code: #![allow(unused)] fn main() {\\nlet foo = \\"foo\\";\\nassert_eq!(foo, \\"foo\\"); } This way, if the computation ever returns something different,\\nthe code panics and the doctest fails.","breadcrumbs":"How to write documentation » Documentation tests » Passing or failing a doctest","id":"108","title":"Passing or failing a doctest"},"109":{"body":"In the example above, you’ll note something strange: there’s no main\\nfunction! Forcing you to write main for every example, no matter how small,\\nadds friction and clutters the output. So rustdoc processes your examples\\nslightly before running them. Here’s the full algorithm rustdoc uses to\\npreprocess examples: Some common allow attributes are inserted, including unused_variables, unused_assignments, unused_mut, unused_attributes, and dead_code. Small examples often trigger\\nthese lints. Any attributes specified with #![doc(test(attr(...)))] are added. Any leading #![foo] attributes are left intact as crate attributes. If the example does not contain extern crate, and #![doc(test(no_crate_inject))] was not specified, then extern crate <mycrate>; is inserted (note the lack of #[macro_use]). Finally, if the example does not contain fn main, the remainder of the\\ntext is wrapped in fn main() { your_code }. For more about that caveat in rule 4, see “Documenting Macros” below.","breadcrumbs":"How to write documentation » Documentation tests » Pre-processing examples","id":"109","title":"Pre-processing examples"},"11":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -o target/doc\\n$ rustdoc src/lib.rs --out-dir target/doc By default, rustdoc’s output appears in a directory named doc in\\nthe current working directory. With this flag, it will place all output\\ninto the directory you specify.","breadcrumbs":"Command-line arguments » -o/ --out-dir: output directory path","id":"11","title":"-o/ --out-dir: output directory path"},"110":{"body":"Sometimes, you need some setup code, or other things that would distract\\nfrom your example, but are important to make the tests work. Consider\\nan example block that looks like this: #![allow(unused)] fn main() {\\n/// ```\\n/// /// Some documentation.\\n/// # fn foo() {} // this function will be hidden\\n/// println!(\\"Hello, World!\\");\\n/// ``` fn f() {} } It will render like this: #![allow(unused)] fn main() {\\n/// Some documentation. fn foo() {}\\nprintln!(\\"Hello, World!\\"); } Yes, that’s right: you can add lines that start with # , and they will\\nbe hidden from the output, but will be used when compiling your code. You\\ncan use this to your advantage. In this case, documentation comments need\\nto apply to some kind of function, so if I want to show you just a\\ndocumentation comment, I need to add a little function definition below\\nit. At the same time, it’s only there to satisfy the compiler, so hiding\\nit makes the example more clear. You can use this technique to explain\\nlonger examples in detail, while still preserving the testability of your\\ndocumentation. For example, imagine that we wanted to document this code: #![allow(unused)] fn main() {\\nlet x = 5;\\nlet y = 6;\\nprintln!(\\"{}\\", x + y); } We might want the documentation to end up looking like this: First, we set x to five: #![allow(unused)] fn main() {\\nlet x = 5; let y = 6; println!(\\"{}\\", x + y); } Next, we set y to six: #![allow(unused)] fn main() { let x = 5;\\nlet y = 6; println!(\\"{}\\", x + y); } Finally, we print the sum of x and y: #![allow(unused)] fn main() { let x = 5; let y = 6;\\nprintln!(\\"{}\\", x + y); } To keep each code block testable, we want the whole program in each block, but\\nwe don’t want the reader to see every line every time. Here’s what we put in\\nour source code: First, we set `x` to five: ```\\nlet x = 5;\\n# let y = 6;\\n# println!(\\"{}\\", x + y);\\n``` Next, we set `y` to six: ```\\n# let x = 5;\\nlet y = 6;\\n# println!(\\"{}\\", x + y);\\n``` Finally, we print the sum of `x` and `y`: ```\\n# let x = 5;\\n# let y = 6;\\nprintln!(\\"{}\\", x + y);\\n``` By repeating all parts of the example, you can ensure that your example still\\ncompiles, while only showing the parts that are relevant to that part of your\\nexplanation. The #-hiding of lines can be prevented by using two consecutive hashes ##. This only needs to be done with the first # which would’ve\\notherwise caused hiding. If we have a string literal like the following,\\nwhich has a line that starts with a #: #![allow(unused)] fn main() {\\nlet s = \\"foo\\n# bar # baz\\"; } We can document it by escaping the initial #: /// let s = \\"foo\\n/// ## bar # baz\\"; Here is an example with a macro rule which matches on tokens starting with #: #![allow(unused)] fn main() {\\n/// ```\\n/// macro_rules! ignore { (##tag) => {}; }\\n/// ignore! {\\n/// ###tag\\n/// }\\n/// ``` fn f() {} } As you can see, the rule is expecting two #, so when calling it, we need to add an extra #\\nbecause the first one is used as escape.","breadcrumbs":"How to write documentation » Documentation tests » Hiding portions of the example","id":"110","title":"Hiding portions of the example"},"111":{"body":"When writing an example, it is rarely useful to include a complete error\\nhandling, as it would add significant amounts of boilerplate code. Instead, you\\nmay want the following: #![allow(unused)] fn main() {\\n/// ```\\n/// use std::io;\\n/// let mut input = String::new();\\n/// io::stdin().read_line(&mut input)?;\\n/// ``` fn f() {} } The problem is that ? returns a Result<T, E> and test functions don’t\\nreturn anything, so this will give a mismatched types error. You can get around this limitation by manually adding a main that returns Result<T, E>, because Result<T, E> implements the Termination trait: /// A doc test using ?\\n///\\n/// ```\\n/// use std::io;\\n///\\n/// fn main() -> io::Result<()> {\\n/// let mut input = String::new();\\n/// io::stdin().read_line(&mut input)?;\\n/// Ok(())\\n/// }\\n/// ``` fn f() {} Together with the # from the section above, you arrive at a solution that\\nappears to the reader as the initial idea but works with doc tests: /// ```\\n/// use std::io;\\n/// # fn main() -> io::Result<()> {\\n/// let mut input = String::new();\\n/// io::stdin().read_line(&mut input)?;\\n/// # Ok(())\\n/// # }\\n/// ``` fn f() {} As of version 1.34.0, one can also omit the fn main(), but you will have to\\ndisambiguate the error type: #![allow(unused)] fn main() {\\n/// ```\\n/// use std::io;\\n/// let mut input = String::new();\\n/// io::stdin().read_line(&mut input)?;\\n/// # Ok::<(), io::Error>(())\\n/// ``` fn f() {} } This is an unfortunate consequence of the ? operator adding an implicit\\nconversion, so type inference fails because the type is not unique. Please note\\nthat you must write the (()) in one sequence without intermediate whitespace\\nso that rustdoc understands you want an implicit Result-returning function.","breadcrumbs":"How to write documentation » Documentation tests » Using ? in doc tests","id":"111","title":"Using ? in doc tests"},"112":{"body":"You can show warnings in doctests by running rustdoc --test --test-args=--show-output\\n(or, if you’re using cargo, cargo test --doc -- --show-output).\\nBy default, this will still hide unused warnings, since so many examples use private functions;\\nyou can add #![warn(unused)] to the top of your example if you want to see unused variables or dead code warnings.\\nYou can also use #![doc(test(attr(warn(unused))))] in the crate root to enable warnings globally.","breadcrumbs":"How to write documentation » Documentation tests » Showing warnings in doctests","id":"112","title":"Showing warnings in doctests"},"113":{"body":"Here’s an example of documenting a macro: /// Panic with a given message unless an expression evaluates to true.\\n///\\n/// # Examples\\n///\\n/// ```\\n/// # #[macro_use] extern crate foo;\\n/// # fn main() {\\n/// panic_unless!(1 + 1 == 2, “Math is broken.”);\\n/// # }\\n/// ```\\n///\\n/// ```should_panic\\n/// # #[macro_use] extern crate foo;\\n/// # fn main() {\\n/// panic_unless!(true == false, “I’m broken.”);\\n/// # }\\n/// ```\\n#[macro_export]\\nmacro_rules! panic_unless { ($condition:expr, $($rest:expr),+) => ({ if ! $condition { panic!($($rest),+); } });\\n} fn main() {} You’ll note three things: we need to add our own extern crate line, so that\\nwe can add the #[macro_use] attribute. Second, we’ll need to add our own main() as well (for reasons discussed above). Finally, a judicious use of # to comment out those two things, so they don’t show up in the output.","breadcrumbs":"How to write documentation » Documentation tests » Documenting macros","id":"113","title":"Documenting macros"},"114":{"body":"Code blocks can be annotated with attributes that help rustdoc do the right\\nthing when testing your code: The ignore attribute tells Rust to ignore your code. This is almost never\\nwhat you want as it’s the most generic. Instead, consider annotating it\\nwith text if it’s not code or using #s to get a working example that\\nonly shows the part you care about. #![allow(unused)] fn main() {\\n/// ```ignore\\n/// fn foo() {\\n/// ``` fn foo() {} } should_panic tells rustdoc that the code should compile correctly but\\npanic during execution. If the code doesn’t panic, the test will fail. #![allow(unused)] fn main() {\\n/// ```should_panic\\n/// assert!(false);\\n/// ``` fn foo() {} } The no_run attribute will compile your code but not run it. This is\\nimportant for examples such as “Here’s how to retrieve a web page,”\\nwhich you would want to ensure compiles, but might be run in a test\\nenvironment that has no network access. This attribute can also be\\nused to demonstrate code snippets that can cause Undefined Behavior. #![allow(unused)] fn main() {\\n/// ```no_run\\n/// loop {\\n/// println!(\\"Hello, world\\");\\n/// }\\n/// ``` fn foo() {} } compile_fail tells rustdoc that the compilation should fail. If it\\ncompiles, then the test will fail. However, please note that code failing\\nwith the current Rust release may work in a future release, as new features\\nare added. #![allow(unused)] fn main() {\\n/// ```compile_fail\\n/// let x = 5;\\n/// x += 2; // shouldn\'t compile!\\n/// ``` fn foo() {} } edition2015, edition2018, edition2021, and edition2024 tell rustdoc\\nthat the code sample should be compiled using the respective edition of Rust. #![allow(unused)] fn main() {\\n/// Only runs on the 2018 edition.\\n///\\n/// ```edition2018\\n/// let result: Result<i32, ParseIntError> = try {\\n/// \\"1\\".parse::<i32>()?\\n/// + \\"2\\".parse::<i32>()?\\n/// + \\"3\\".parse::<i32>()?\\n/// };\\n/// ``` fn foo() {} } Starting in the 2024 edition 1, compatible doctests are merged as one before being\\nrun. We combine doctests for performance reasons: the slowest part of doctests is to compile them.\\nMerging all of them into one file and compiling this new file, then running the doctests is much\\nfaster. Whether doctests are merged or not, they are run in their own process. An example of time spent when running doctests: sysinfo crate: wall-time duration: 4.59s\\ntotal compile time: 27.067s\\ntotal runtime: 3.969s Rust core library: wall-time duration: 102s\\ntotal compile time: 775.204s\\ntotal runtime: 15.487s In some cases, doctests cannot be merged. For example, if you have: #![allow(unused)] fn main() {\\n//! ```\\n//! let location = std::panic::Location::caller();\\n//! assert_eq!(location.line(), 4);\\n//! ``` } The problem with this code is that, if you change any other doctests, it’ll likely break when\\nrunning rustdoc --test, making it tricky to maintain. This is where the standalone_crate attribute comes in: it tells rustdoc that a doctest\\nshould not be merged with the others. So the previous code should use it: #![allow(unused)] fn main() {\\n//! ```standalone_crate\\n//! let location = std::panic::Location::caller();\\n//! assert_eq!(location.line(), 4);\\n//! ``` } In this case, it means that the line information will not change if you add/remove other\\ndoctests.","breadcrumbs":"How to write documentation » Documentation tests » Attributes","id":"114","title":"Attributes"},"115":{"body":"Attributes starting with ignore- can be used to ignore doctests for specific\\ntargets. For example, ignore-x86_64 will avoid building doctests when the\\ntarget name contains x86_64. #![allow(unused)] fn main() {\\n/// ```ignore-x86_64\\n/// assert!(2 == 2);\\n/// ```\\nstruct Foo; } This doctest will not be built for targets such as x86_64-unknown-linux-gnu. Multiple ignore attributes can be specified to ignore multiple targets: #![allow(unused)] fn main() {\\n/// ```ignore-x86_64,ignore-windows\\n/// assert!(2 == 2);\\n/// ```\\nstruct Foo; } If you want to preserve backwards compatibility for older versions of rustdoc,\\nyou can specify both ignore and ignore-, such as: #![allow(unused)] fn main() {\\n/// ```ignore,ignore-x86_64\\n/// assert!(2 == 2);\\n/// ```\\nstruct Foo; } In older versions, this will be ignored on all targets, but starting with\\nversion 1.88.0, ignore-x86_64 will override ignore.","breadcrumbs":"How to write documentation » Documentation tests » Ignoring targets","id":"115","title":"Ignoring targets"},"116":{"body":"#![allow(unused)] fn main() {\\n/// ```custom,{class=language-c}\\n/// int main(void) { return 0; }\\n/// ```\\npub struct Bar; } The text int main(void) { return 0; } is rendered without highlighting in a code block\\nwith the class language-c. This can be used to highlight other languages through JavaScript\\nlibraries for example. Without the custom attribute, it would be generated as a Rust code example with an additional language-C CSS class. Therefore, if you specifically don’t want it to be a Rust code example,\\ndon’t forget to add the custom attribute. To be noted that you can replace class= with . to achieve the same result: #![allow(unused)] fn main() {\\n/// ```custom,{.language-c}\\n/// int main(void) { return 0; }\\n/// ```\\npub struct Bar; } To be noted, rust and .rust/ class=rust have different effects: rust indicates that this is\\na Rust code block whereas the two others add a “rust” CSS class on the code block. You can also use double quotes: #![allow(unused)] fn main() {\\n/// ```\\"not rust\\" {.\\"hello everyone\\"}\\n/// int main(void) { return 0; }\\n/// ```\\npub struct Bar; }","breadcrumbs":"How to write documentation » Documentation tests » Custom CSS classes for code blocks","id":"116","title":"Custom CSS classes for code blocks"},"117":{"body":"The exact syntax for code blocks, including the edge cases, can be found\\nin the Fenced Code Blocks\\nsection of the CommonMark specification. Rustdoc also accepts indented code blocks as an alternative to fenced\\ncode blocks: instead of surrounding your code with three backticks, you\\ncan indent each line by four or more spaces. let foo = \\"foo\\"; assert_eq!(foo, \\"foo\\"); These, too, are documented in the CommonMark specification, in the Indented Code Blocks\\nsection. However, it’s preferable to use fenced code blocks over indented code blocks.\\nNot only are fenced code blocks considered more idiomatic for Rust code,\\nbut there is no way to use attributes such as ignore or should_panic with\\nindented code blocks.","breadcrumbs":"How to write documentation » Documentation tests » Syntax reference","id":"117","title":"Syntax reference"},"118":{"body":"Rustdoc’s documentation tests can do some things that regular unit tests can’t, so it can\\nsometimes be useful to extend your doctests with samples that wouldn’t otherwise need to be in\\ndocumentation. To this end, Rustdoc allows you to have certain items only appear when it’s\\ncollecting doctests, so you can utilize doctest functionality without forcing the test to appear in\\ndocs, or to find an arbitrary private item to include it on. When compiling a crate for use in doctests (with --test option), rustdoc will set #[cfg(doctest)].\\nNote that they will still link against only the public items of your crate; if you need to test\\nprivate items, you need to write a unit test. In this example, we’re adding doctests that we know won’t compile, to verify that our struct can\\nonly take in valid data: #![allow(unused)] fn main() {\\n/// We have a struct here. Remember it doesn\'t accept negative numbers!\\npub struct MyStruct(pub usize); /// ```compile_fail\\n/// let x = my_crate::MyStruct(-5);\\n/// ```\\n#[cfg(doctest)]\\npub struct MyStructOnlyTakesUsize; } Note that the struct MyStructOnlyTakesUsize here isn’t actually part of your public crate\\nAPI. The use of #[cfg(doctest)] makes sure that this struct only exists while rustdoc is\\ncollecting doctests. This means that its doctest is executed when --test is passed to rustdoc,\\nbut is hidden from the public documentation. Another possible use of #[cfg(doctest)] is to test doctests that are included in your README file\\nwithout including it in your main documentation. For example, you could write this into your lib.rs to test your README as part of your doctests: #![allow(unused)] fn main() {\\n#[doc = include_str!(\\"../README.md\\")]\\n#[cfg(doctest)]\\npub struct ReadmeDoctests; } This will include your README as documentation on the hidden struct ReadmeDoctests, which will\\nthen be tested alongside the rest of your doctests.","breadcrumbs":"How to write documentation » Documentation tests » Include items only when collecting doctests","id":"118","title":"Include items only when collecting doctests"},"119":{"body":"By default, rustdoc --test will compile and run documentation test examples\\nfrom the same working directory.\\nThe compilation directory is being used for compiler diagnostics, the file!() macro and\\nthe output of rustdoc test runner itself, whereas the run directory has an influence on file-system\\noperations within documentation test examples, such as std::fs::read_to_string. The --test-run-directory flag allows controlling the run directory separately from the compilation directory.\\nThis is particularly useful in workspaces, where compiler invocations and thus diagnostics should be\\nrelative to the workspace directory, but documentation test examples should run relative to the crate directory. This is based on the edition of the whole crate, not the edition of the individual\\ntest case that may be specified in its code attribute. ↩","breadcrumbs":"How to write documentation » Documentation tests » Controlling the compilation and run directories","id":"119","title":"Controlling the compilation and run directories"},"12":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-name mycrate By default, rustdoc assumes that the name of your crate is the same name\\nas the .rs file. --crate-name lets you override this assumption with\\nwhatever name you choose.","breadcrumbs":"Command-line arguments » --crate-name: controlling the name of the crate","id":"12","title":"--crate-name: controlling the name of the crate"},"120":{"body":"rustdoc provides lints to help you writing and testing your documentation. You\\ncan use them like any other lints by doing this: #![allow(unused)]\\n#![allow(rustdoc::broken_intra_doc_links)] // allows the lint, no diagnostics will be reported\\n#![warn(rustdoc::broken_intra_doc_links)] // warn if there are broken intra-doc links\\n#![deny(rustdoc::broken_intra_doc_links)] // error if there are broken intra-doc links fn main() { } Note that, except for missing_docs, these lints are only available when running rustdoc, not rustc. Here is the list of the lints provided by rustdoc:","breadcrumbs":"Rustdoc-specific lints » Lints","id":"120","title":"Lints"},"121":{"body":"This lint warns by default. This lint detects when an intra-doc link fails to be resolved. For example: #![allow(unused)] fn main() {\\n/// I want to link to [`Nonexistent`] but it doesn\'t exist!\\npub fn foo() {} } You’ll get a warning saying: warning: unresolved link to `Nonexistent` --> test.rs:1:24 |\\n1 | /// I want to link to [`Nonexistent`] but it doesn\'t exist! | ^^^^^^^^^^^^^ no item named `Nonexistent` in `test` It will also warn when there is an ambiguity and suggest how to disambiguate: #![allow(unused)] fn main() {\\n/// [`Foo`]\\npub fn function() {} pub enum Foo {} pub fn Foo(){} } warning: `Foo` is both an enum and a function --> test.rs:1:6 |\\n1 | /// [`Foo`] | ^^^^^ ambiguous link | = note: `#[warn(rustdoc::broken_intra_doc_links)]` on by default\\nhelp: to link to the enum, prefix with the item type |\\n1 | /// [`enum@Foo`] | ^^^^^^^^^^\\nhelp: to link to the function, add parentheses |\\n1 | /// [`Foo()`] | ^^^^^^^","breadcrumbs":"Rustdoc-specific lints » broken_intra_doc_links","id":"121","title":"broken_intra_doc_links"},"122":{"body":"This lint warns by default. This lint detects when intra-doc links from public to private items.\\nFor example: #![allow(unused)]\\n#![warn(rustdoc::private_intra_doc_links)] // note: unnecessary - warns by default. fn main() {\\n/// [private]\\npub fn public() {}\\nfn private() {} } This gives a warning that the link will be broken when it appears in your documentation: warning: public documentation for `public` links to private item `private` --> priv.rs:1:6 |\\n1 | /// [private] | ^^^^^^^ this item is private | = note: `#[warn(rustdoc::private_intra_doc_links)]` on by default = note: this link will resolve properly if you pass `--document-private-items` Note that this has different behavior depending on whether you pass --document-private-items or not!\\nIf you document private items, then it will still generate a link, despite the warning: warning: public documentation for `public` links to private item `private` --> priv.rs:1:6 |\\n1 | /// [private] | ^^^^^^^ this item is private | = note: `#[warn(rustdoc::private_intra_doc_links)]` on by default = note: this link resolves only because you passed `--document-private-items`, but will break without","breadcrumbs":"Rustdoc-specific lints » private_intra_doc_links","id":"122","title":"private_intra_doc_links"},"123":{"body":"This lint is allowed by default. It detects items missing documentation.\\nFor example: #![warn(missing_docs)] pub fn undocumented() {} fn main() {} The undocumented function will then have the following warning: warning: missing documentation for a function --> your-crate/lib.rs:3:1 | 3 | pub fn undocumented() {} | ^^^^^^^^^^^^^^^^^^^^^ Note that unlike other rustdoc lints, this lint is also available from rustc directly.","breadcrumbs":"Rustdoc-specific lints » missing_docs","id":"123","title":"missing_docs"},"124":{"body":"This lint is allowed by default. It detects if there is no documentation\\nat the crate root. For example: #![allow(unused)]\\n#![warn(rustdoc::missing_crate_level_docs)] fn main() { } This will generate the following warning: warning: no documentation found for this crate\'s top-level module | = help: The following guide may be of use: https://doc.rust-lang.org/nightly/rustdoc/how-to-write-documentation.html This is currently “allow” by default, but it is intended to make this a\\nwarning in the future. This is intended as a means to introduce new users on how to document their crate by pointing them to some instructions on how to\\nget started, without providing overwhelming warnings like missing_docs\\nmight.","breadcrumbs":"Rustdoc-specific lints » missing_crate_level_docs","id":"124","title":"missing_crate_level_docs"},"125":{"body":"This lint is allowed by default and is nightly-only. It detects when a documentation block\\nis missing a code example. For example: #![warn(rustdoc::missing_doc_code_examples)] /// There is no code example!\\npub fn no_code_example() {} fn main() {} The no_code_example function will then have the following warning: warning: Missing code example in this documentation --> your-crate/lib.rs:3:1 |\\nLL | /// There is no code example! | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ To fix the lint, you need to add a code example into the documentation block: #![allow(unused)] fn main() {\\n/// There is no code example!\\n///\\n/// ```\\n/// println!(\\"calling no_code_example...\\");\\n/// no_code_example();\\n/// println!(\\"we called no_code_example!\\");\\n/// ```\\npub fn no_code_example() {} }","breadcrumbs":"Rustdoc-specific lints » missing_doc_code_examples","id":"125","title":"missing_doc_code_examples"},"126":{"body":"This lint is allowed by default. It detects documentation tests when they\\nare on a private item. For example: #![warn(rustdoc::private_doc_tests)] mod foo { /// private doc test /// /// ``` /// assert!(false); /// ``` fn bar() {}\\n} fn main() {} Which will give: warning: Documentation test in private item --> your-crate/lib.rs:4:1 | 4 | / /// private doc test 5 | | /// 6 | | /// ``` 7 | | /// assert!(false); 8 | | /// ``` | |___________^","breadcrumbs":"Rustdoc-specific lints » private_doc_tests","id":"126","title":"private_doc_tests"},"127":{"body":"This lint warns by default. It detects code block attributes in\\ndocumentation examples that have potentially mis-typed values. For example: #![allow(unused)]\\n#![warn(rustdoc::invalid_codeblock_attributes)] // note: unnecessary - warns by default. fn main() {\\n/// Example.\\n///\\n/// ```should-panic\\n/// assert_eq!(1, 2);\\n/// ```\\npub fn foo() {} } Which will give: warning: unknown attribute `should-panic`. Did you mean `should_panic`? --> src/lib.rs:1:1 |\\n1 | / /// Example.\\n2 | | ///\\n3 | | /// ```should-panic\\n4 | | /// assert_eq!(1, 2);\\n5 | | /// ``` | |_______^ | = note: `#[warn(rustdoc::invalid_codeblock_attributes)]` on by default = help: the code block will either not be tested if not marked as a rust one or won\'t fail if it doesn\'t panic when running In the example above, the correct form is should_panic. This helps detect\\ntypo mistakes for some common attributes.","breadcrumbs":"Rustdoc-specific lints » invalid_codeblock_attributes","id":"127","title":"invalid_codeblock_attributes"},"128":{"body":"This lint warns by default. It detects unclosed\\nor invalid HTML tags. For example: #![allow(unused)]\\n#![warn(rustdoc::invalid_html_tags)] fn main() {\\n/// <h1>\\n/// </script>\\npub fn foo() {} } Which will give: warning: unopened HTML tag `script` --> foo.rs:1:1 |\\n1 | / /// <h1>\\n2 | | /// </script> | |_____________^ | note: the lint level is defined here --> foo.rs:1:9 |\\n1 | #![warn(rustdoc::invalid_html_tags)] | ^^^^^^^^^^^^^^^^^^^^^^^^^^ warning: unclosed HTML tag `h1` --> foo.rs:1:1 |\\n1 | / /// <h1>\\n2 | | /// </script> | |_____________^ warning: 2 warnings emitted","breadcrumbs":"Rustdoc-specific lints » invalid_html_tags","id":"128","title":"invalid_html_tags"},"129":{"body":"This lint warns by default. It detects Rust code blocks in documentation\\nexamples that are invalid (e.g. empty, not parsable as Rust). For example: #![allow(unused)] fn main() {\\n/// Empty code blocks (with and without the `rust` marker):\\n///\\n/// ```rust\\n/// ```\\n///\\n/// Invalid syntax in code blocks:\\n///\\n/// ```rust\\n/// \'<\\n/// ```\\npub fn foo() {} } Which will give: warning: Rust code block is empty --> lint.rs:3:5 |\\n3 | /// ```rust | _____^\\n4 | | /// ``` | |_______^ | = note: `#[warn(rustdoc::invalid_rust_codeblocks)]` on by default warning: could not parse code block as Rust code --> lint.rs:8:5 |\\n8 | /// ```rust | _____^\\n9 | | /// \'<\\n10 | | /// ``` | |_______^ | = note: error from rustc: unterminated character literal","breadcrumbs":"Rustdoc-specific lints » invalid_rust_codeblocks","id":"129","title":"invalid_rust_codeblocks"},"13":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --document-private-items By default, rustdoc only documents items that are publicly reachable. #![allow(unused)] fn main() {\\npub fn public() {} // this item is public and will be documented\\nmod private { // this item is private and will not be documented pub fn unreachable() {} // this item is public, but unreachable, so it will not be documented\\n} } --document-private-items includes all non-public items in the generated documentation except for #[doc(hidden)] items. Private items will be shown with a 🔒 icon.","breadcrumbs":"Command-line arguments » --document-private-items: Show items that are not public","id":"13","title":"--document-private-items: Show items that are not public"},"130":{"body":"This lint is warn-by-default. It detects URLs which are not links.\\nFor example: #![allow(unused)]\\n#![warn(rustdoc::bare_urls)] // note: unnecessary - warns by default. fn main() {\\n/// http://example.org\\n/// [http://example.net]\\npub fn foo() {} } Which will give: warning: this URL is not a hyperlink --> links.rs:1:5 |\\n1 | /// http://example.org | ^^^^^^^^^^^^^^^^^^ help: use an automatic link instead: `<http://example.org>` | = note: `#[warn(rustdoc::bare_urls)]` on by default warning: this URL is not a hyperlink --> links.rs:3:6 |\\n3 | /// [http://example.net] | ^^^^^^^^^^^^^^^^^^ help: use an automatic link instead: `<http://example.net>` warning: 2 warnings emitted","breadcrumbs":"Rustdoc-specific lints » bare_urls","id":"130","title":"bare_urls"},"131":{"body":"This lint is allowed by default. It detects backticks (`) that are not escaped.\\nThis usually means broken inline code. For example: #![allow(unused)]\\n#![warn(rustdoc::unescaped_backticks)] fn main() {\\n/// `add(a, b) is the same as `add(b, a)`.\\npub fn add(a: i32, b: i32) -> i32 { a + b } } Which will give: warning: unescaped backtick --> src/lib.rs:3:41 |\\n3 | /// `add(a, b) is the same as `add(b, a)`. | ^ |\\nnote: the lint level is defined here --> src/lib.rs:1:9 |\\n1 | #![warn(rustdoc::unescaped_backticks)] | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\\nhelp: a previous inline code might be longer than expected |\\n3 | /// `add(a, b)` is the same as `add(b, a)`. | +\\nhelp: if you meant to use a literal backtick, escape it |\\n3 | /// `add(a, b) is the same as `add(b, a)\\\\`. | + warning: 1 warning emitted","breadcrumbs":"Rustdoc-specific lints » unescaped_backticks","id":"131","title":"unescaped_backticks"},"132":{"body":"This lint is warn-by-default. It detects explicit links that are the same\\nas computed automatic links.\\nThis usually means the explicit links are removable. For example: #![allow(unused)]\\n#![warn(rustdoc::redundant_explicit_links)] // note: unnecessary - warns by default. fn main() {\\n/// add takes 2 [`usize`](usize) and performs addition\\n/// on them, then returns result.\\npub fn add(left: usize, right: usize) -> usize { left + right\\n} } Which will give: error: redundant explicit rustdoc link --> src/lib.rs:3:27 |\\n3 | /// add takes 2 [`usize`](usize) and performs addition | ^^^^^ | = note: Explicit link does not affect the original link\\nnote: the lint level is defined here --> src/lib.rs:1:9 |\\n1 | #![deny(rustdoc::redundant_explicit_links)] | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ = help: Remove explicit link instead","breadcrumbs":"Rustdoc-specific lints » redundant_explicit_links","id":"132","title":"redundant_explicit_links"},"133":{"body":"Rustdoc has an unstable feature where it can automatically scrape examples of items being documented from the examples/ directory of a Cargo workspace. These examples will be included within the generated documentation for that item. For example, if your library contains a public function: // a_crate/src/lib.rs\\npub fn a_func() {} And you have an example calling this function: // a_crate/examples/ex.rs\\nfn main() { a_crate::a_func();\\n} Then this code snippet will be included in the documentation for a_func. This documentation is inserted by Rustdoc and cannot be manually edited by the crate author.","breadcrumbs":"Scraped examples » Scraped examples","id":"133","title":"Scraped examples"},"134":{"body":"This feature is unstable, so you can enable it by calling Rustdoc with the unstable rustdoc-scrape-examples flag: cargo doc -Zunstable-options -Zrustdoc-scrape-examples To enable this feature on docs.rs, add this to your Cargo.toml: [package.metadata.docs.rs]\\ncargo-args = [\\"-Zunstable-options\\", \\"-Zrustdoc-scrape-examples\\"]","breadcrumbs":"Scraped examples » How to use this feature","id":"134","title":"How to use this feature"},"135":{"body":"When you run cargo doc, Rustdoc will analyze all the crates that match Cargo’s --examples filter for instances of items being documented. Then Rustdoc will include the source code of these instances in the generated documentation. Rustdoc has a few techniques to ensure these examples don’t overwhelm documentation readers, and that it doesn’t blow up the page size: For a given item, a maximum of 5 examples are included in the page. The remaining examples are just links to source code. Only one example is shown by default, and the remaining examples are hidden behind a toggle. For a given file that contains examples, only the item containing the examples will be included in the generated documentation. For a given item, Rustdoc sorts its examples based on the size of the example — smaller ones are shown first.","breadcrumbs":"Scraped examples » How it works","id":"135","title":"How it works"},"136":{"body":"","breadcrumbs":"Scraped examples » FAQ","id":"136","title":"FAQ"},"137":{"body":"This feature uses Cargo’s convention for finding examples. You should ensure that cargo check --examples includes your example file.","breadcrumbs":"Scraped examples » My example is not showing up in the documentation","id":"137","title":"My example is not showing up in the documentation"},"138":{"body":"The features listed on this page fall outside the rest of the main categories.","breadcrumbs":"Advanced features » Advanced features","id":"138","title":"Advanced features"},"139":{"body":"For conditional compilation, Rustdoc treats your crate the same way the compiler does. Only things\\nfrom the host target are available (or from the given --target if present), and everything else is\\n“filtered out” from the crate. This can cause problems if your crate is providing different things\\non different targets and you want your documentation to reflect all the available items you\\nprovide. If you want to make sure an item is seen by Rustdoc regardless of what platform it’s targeting,\\nyou can apply #[cfg(doc)] to it. Rustdoc sets this whenever it’s building documentation, so\\nanything that uses that flag will make it into documentation it generates. To apply this to an item\\nwith other #[cfg] filters on it, you can write something like #[cfg(any(windows, doc))].\\nThis will preserve the item either when built normally on Windows, or when being documented\\nanywhere. Please note that this cfg is not passed to doctests. Example: #![allow(unused)] fn main() {\\n/// Token struct that can only be used on Windows.\\n#[cfg(any(windows, doc))]\\npub struct WindowsToken;\\n/// Token struct that can only be used on Unix.\\n#[cfg(any(unix, doc))]\\npub struct UnixToken; } Here, the respective tokens can only be used by dependent crates on their respective platforms, but\\nthey will both appear in documentation.","breadcrumbs":"Advanced features » #[cfg(doc)]: Documenting platform-specific or feature-specific information","id":"139","title":"#[cfg(doc)]: Documenting platform-specific or feature-specific information"},"14":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -L target/debug/deps\\n$ rustdoc src/lib.rs --library-path target/debug/deps If your crate has dependencies, rustdoc needs to know where to find them.\\nPassing --library-path gives rustdoc a list of places to look for these\\ndependencies. This flag takes any number of directories as its argument, and will use all of\\nthem when searching.","breadcrumbs":"Command-line arguments » -L/ --library-path: where to look for dependencies","id":"14","title":"-L/ --library-path: where to look for dependencies"},"140":{"body":"Rustdoc does not have a magic way to compile documentation ‘as-if’ you’d run it once for each\\nplatform (such a magic wand has been called the ‘holy grail of rustdoc’). Instead,\\nit sees all of your code at once, the same way the Rust compiler would if you passed it --cfg doc. The main difference is that rustdoc doesn’t run all the compiler passes, meaning\\nthat some invalid code won’t emit an error.","breadcrumbs":"Advanced features » Interactions between platform-specific docs","id":"140","title":"Interactions between platform-specific docs"},"141":{"body":"This feature allows you to add alias(es) to an item when using the rustdoc search through the doc(alias) attribute. Example: #![allow(unused)] fn main() {\\n#[doc(alias = \\"x\\")]\\n#[doc(alias = \\"big\\")]\\npub struct BigX; } Then, when looking for it through the rustdoc search, if you enter “x” or\\n“big”, search will show the BigX struct first. There are some limitations on the doc alias names though: they cannot contain quotes ( \', \\")\\nor most whitespace. ASCII space is allowed if it does not start or end the alias. You can add multiple aliases at the same time by using a list: #![allow(unused)] fn main() {\\n#[doc(alias(\\"x\\", \\"big\\"))]\\npub struct BigX; }","breadcrumbs":"Advanced features » Add aliases for an item in documentation search","id":"141","title":"Add aliases for an item in documentation search"},"142":{"body":"If you find yourself often referencing online Rust docs you might enjoy using a custom search\\nengine. This allows you to use the navigation bar directly to search a rustdoc website.\\nMost browsers support this feature by letting you define a URL template containing %s\\nwhich will be substituted for the search term. As an example, for the standard library you could use\\nthis template: https://doc.rust-lang.org/stable/std/?search=%s Note that this will take you to a results page listing all matches. If you want to navigate to the first\\nresult right away (which is often the best match) use the following instead: https://doc.rust-lang.org/stable/std/?search=%s&go_to_first=true This URL adds the go_to_first=true query parameter which can be appended to any rustdoc search URL\\nto automatically go to the first result.","breadcrumbs":"Advanced features » Custom search engines","id":"142","title":"Custom search engines"},"143":{"body":"Generally, rustdoc only displays the representation of a given type if none of its variants are #[doc(hidden)] and if all of its fields are public and not #[doc(hidden)] since it’s likely\\nnot meant to be considered part of the public ABI otherwise. Note that there’s no way to overwrite that heuristic and force rustdoc to show the representation\\nregardless.","breadcrumbs":"Advanced features » #[repr(...)]: Documenting the representation of a type","id":"143","title":"#[repr(...)]: Documenting the representation of a type"},"144":{"body":"You can read more about #[repr(transparent)] itself in the Rust Reference and\\nin the Rustonomicon. Since this representation is only considered part of the public ABI if the single field with non-trivial\\nsize or alignment is public and if the documentation does not state otherwise, rustdoc helpfully displays\\nthe attribute if and only if the non-1-ZST field is public and not #[doc(hidden)] or\\n– in case all fields are 1-ZST fields — at least one field is public and not #[doc(hidden)].\\nThe term 1-ZST refers to types that are one-aligned and zero-sized. It would seem that one can manually hide the attribute with #[cfg_attr(not(doc), repr(transparent))]\\nif one wishes to declare the representation as private even if the non-1-ZST field is public.\\nHowever, due to current limitations, this method is not always guaranteed to work.\\nTherefore, if you would like to do so, you should always write that down in prose independently of whether\\nyou use cfg_attr or not.","breadcrumbs":"Advanced features » #[repr(transparent)]","id":"144","title":"#[repr(transparent)]"},"145":{"body":"Rustdoc is under active development, and like the Rust compiler, some features are only available\\non nightly releases. Some of these features are new and need some more testing before they’re able to be\\nreleased to the world at large, and some of them are tied to features in the Rust compiler that are unstable. Several features here require a matching #![feature(...)] attribute to\\nenable, and thus are more fully documented in the Unstable Book. Those sections will link over\\nthere as necessary.","breadcrumbs":"Unstable features » Unstable features","id":"145","title":"Unstable features"},"146":{"body":"These features just require a nightly build to operate. Unlike the other features on this page,\\nthese don’t need to be “turned on” with a command-line flag or a #![feature(...)] attribute in\\nyour crate. This can give them some subtle fallback modes when used on a stable release, so be\\ncareful!","breadcrumbs":"Unstable features » Nightly-gated functionality","id":"146","title":"Nightly-gated functionality"},"147":{"body":"As detailed in the chapter on documentation tests, you can add a compile_fail attribute to a doctest to state that the test should fail to compile. However, on\\nnightly, you can optionally add an error number to state that a doctest should emit a specific error\\nnumber: ```compile_fail,E0044\\nextern { fn some_func<T>(x: T); }\\n``` This is used by the error index to ensure that the samples that correspond to a given error number\\nproperly emit that error code. However, these error codes aren’t guaranteed to be the only thing\\nthat a piece of code emits from version to version, so this is unlikely to be stabilized in the\\nfuture. Attempting to use these error numbers on stable will result in the code sample being interpreted as\\nplain text.","breadcrumbs":"Unstable features » Error numbers for compile-fail doctests","id":"147","title":"Error numbers for compile-fail doctests"},"148":{"body":"This lint will emit a warning if an item doesn’t have a code example in its documentation.\\nIt can be enabled using: #![deny(rustdoc::missing_doc_code_examples)] It is not emitted for items that cannot be instantiated/called such as fields, variants, modules,\\nassociated trait/impl items, impl blocks, statics and constants.\\nIt is also not emitted for foreign items, aliases, extern crates and imports.","breadcrumbs":"Unstable features » missing_doc_code_examples lint","id":"148","title":"missing_doc_code_examples lint"},"149":{"body":"These features operate by extending the #[doc] attribute, and thus can be caught by the compiler\\nand enabled with a #![feature(...)] attribute in your crate.","breadcrumbs":"Unstable features » Extensions to the #[doc] attribute","id":"149","title":"Extensions to the #[doc] attribute"},"15":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --cfg feature=\\"foo\\" This flag accepts the same values as rustc --cfg, and uses it to configure\\ncompilation. The example above uses feature, but any of the cfg values\\nare acceptable.","breadcrumbs":"Command-line arguments » --cfg: passing configuration flags","id":"15","title":"--cfg: passing configuration flags"},"150":{"body":"Tracking issue: #45040 Rustdoc keeps a list of a few traits that are believed to be “fundamental” to\\ntypes that implement them. These traits are intended to be the primary interface\\nfor their implementers, and are often most of the API available to be documented\\non their types. For this reason, Rustdoc will track when a given type implements\\none of these traits and call special attention to it when a function returns one\\nof these types. This is the “Notable traits” dialog, accessible as a circled i\\nbutton next to the function, which, when clicked, shows the dialog. In the standard library, some of the traits that are part of this list are Iterator, Future, io::Read, and io::Write. However, rather than being\\nimplemented as a hard-coded list, these traits have a special marker attribute\\non them: #[doc(notable_trait)]. This means that you can apply this attribute\\nto your own trait to include it in the “Notable traits” dialog in documentation. The #[doc(notable_trait)] attribute currently requires the #![feature(doc_notable_trait)]\\nfeature gate. For more information, see its chapter in the Unstable Book\\nand its tracking issue.","breadcrumbs":"Unstable features » Adding your trait to the “Notable traits” dialog","id":"150","title":"Adding your trait to the “Notable traits” dialog"},"151":{"body":"Tracking issue: #44027 The standard library uses several dependencies which, in turn, use several types and traits from the\\nstandard library. In addition, there are several compiler-internal crates that are not considered to\\nbe part of the official standard library, and thus would be a distraction to include in\\ndocumentation. It’s not enough to exclude their crate documentation, since information about trait\\nimplementations appears on the pages for both the type and the trait, which can be in different\\ncrates! To prevent internal types from being included in documentation, the standard library adds an\\nattribute to their extern crate declarations: #[doc(masked)]. This causes Rustdoc to “mask out”\\ntypes from these crates when building lists of trait implementations. The #[doc(masked)] attribute is intended to be used internally, and requires the #![feature(doc_masked)] feature gate. For more information, see its chapter in the Unstable\\nBook and its tracking issue.","breadcrumbs":"Unstable features » Exclude certain dependencies from documentation","id":"151","title":"Exclude certain dependencies from documentation"},"152":{"body":"This is for Rust compiler internal use only. Since primitive types are defined in the compiler, there’s no place to attach documentation\\nattributes. The #[rustc_doc_primitive = \\"...\\"] attribute is used by the standard library to\\nprovide a way to generate documentation for primitive types, and requires #![feature(rustc_attrs)]\\nto enable.","breadcrumbs":"Unstable features » Document primitives","id":"152","title":"Document primitives"},"153":{"body":"This is for internal use in the std library. Rust keywords are documented in the standard library (look for match for example). To do so, the #[doc(keyword = \\"...\\")] attribute is used. Example: #![allow(unused)]\\n#![feature(rustdoc_internals)]\\n#![allow(internal_features)] fn main() {\\n/// Some documentation about the keyword.\\n#[doc(keyword = \\"break\\")]\\nmod empty_mod {} }","breadcrumbs":"Unstable features » Document keywords","id":"153","title":"Document keywords"},"154":{"body":"This is for internal use in the std library. Rust builtin attributes are documented in the standard library (look for repr for example). To do so, the #[doc(attribute = \\"...\\")] attribute is used. Example: #![allow(unused)]\\n#![feature(rustdoc_internals)]\\n#![allow(internal_features)] fn main() {\\n/// Some documentation about the attribute.\\n#[doc(attribute = \\"repr\\")]\\nmod empty_mod {} }","breadcrumbs":"Unstable features » Document builtin attributes","id":"154","title":"Document builtin attributes"},"155":{"body":"This is for official Rust project use only. Internal Rustdoc pages like settings.html and scrape-examples-help.html show the Rust logo.\\nThis logo is tracked as a static resource. The attribute #![doc(rust_logo)] makes this same\\nbuilt-in resource act as the main logo. #![allow(unused)]\\n#![feature(rustdoc_internals)]\\n#![allow(internal_features)]\\n#![doc(rust_logo)] fn main() {\\n//! This crate has the Rust(tm) branding on it. }","breadcrumbs":"Unstable features » Use the Rust logo as the crate logo","id":"155","title":"Use the Rust logo as the crate logo"},"156":{"body":"These nightly-only features are not primarily related to Rustdoc,\\nbut have convenient effects on the documentation produced.","breadcrumbs":"Unstable features » Effects of other nightly features","id":"156","title":"Effects of other nightly features"},"157":{"body":"Annotating a type with #[fundamental] primarily influences coherence rules about generic types,\\ni.e., they alter whether other crates can provide implementations for that type.\\nThe unstable book links to further information. For documentation, this has an additional side effect:\\nIf a method is implemented on F<T> (or F<&T>),\\nwhere F is a fundamental type,\\nthen the method is not only documented at the page about F,\\nbut also on the page about T.\\nIn a sense, it makes the type transparent to Rustdoc.\\nThis is especially convenient for types that work as annotated pointers,\\nsuch as Pin<&mut T>,\\nas it ensures that methods only implemented through those annotated pointers\\ncan still be found with the type they act on. If the fundamental feature’s effect on coherence is not intended,\\nsuch a type can be marked as fundamental only for purposes of documentation\\nby introducing a custom feature and\\nlimiting the use of fundamental to when documentation is built.","breadcrumbs":"Unstable features » fundamental types","id":"157","title":"fundamental types"},"158":{"body":"These features are enabled by passing a command-line flag to Rustdoc, but the flags in question are\\nthemselves marked as unstable. To use any of these options, pass -Z unstable-options as well as\\nthe flag in question to Rustdoc on the command-line. To do this from Cargo, you can either use the RUSTDOCFLAGS environment variable or the cargo rustdoc command.","breadcrumbs":"Unstable features » Unstable command-line arguments","id":"158","title":"Unstable command-line arguments"},"159":{"body":"These options control how rustdoc handles files that combine data from multiple crates. By default, they act like --merge=shared is set, and --parts-out-dir and --include-parts-dir\\nare turned off. The --merge=shared mode causes rustdoc to load the existing data in the out-dir,\\ncombine the new crate data into it, and write the result. This is very easy to use in scripts that\\nmanually invoke rustdoc, but it’s also slow, because it performs O(crates) work on\\nevery crate, meaning it performs O(crates 2) work. $ rustdoc crate1.rs --out-dir=doc\\n$ cat doc/search.index/crateNames/*\\nrd_(\\"fcrate1\\")\\n$ rustdoc crate2.rs --out-dir=doc\\n$ cat doc/search.index/crateNames/*\\nrd_(\\"fcrate1fcrate2\\") To delay shared-data merging until the end of a build, so that you only have to perform O(crates)\\nwork, use --merge=none on every crate except the last one, which will use --merge=finalize. $ rustdoc +nightly crate1.rs --merge=none --parts-out-dir=crate1.d -Zunstable-options\\n$ cat doc/search.index/crateNames/*\\ncat: \'doc/search.index/crateNames/*\': No such file or directory\\n$ rustdoc +nightly crate2.rs --merge=finalize --include-parts-dir=crate1.d -Zunstable-options\\n$ cat doc/search.index/crateNames/*\\nrd_(\\"fcrate1fcrate2\\")","breadcrumbs":"Unstable features » --merge, --parts-out-dir, and --include-parts-dir","id":"159","title":"--merge, --parts-out-dir, and --include-parts-dir"},"16":{"body":"This flag accepts the same values as rustc --check-cfg, and uses it to\\ncheck configuration flags. Using this flag looks like this: $ rustdoc src/lib.rs --check-cfg=\'cfg(my_cfg, values(\\"foo\\", \\"bar\\"))\' The example above check every well known names and values ( target_os, doc, test, …)\\nand check the values of my_cfg: foo and bar.","breadcrumbs":"Command-line arguments » --check-cfg: check configuration flags","id":"16","title":"--check-cfg: check configuration flags"},"160":{"body":"By default, rustdoc does not document items that are annotated with #[doc(hidden)]. --document-hidden-items causes all items to be documented as if they did not have #[doc(hidden)], except that hidden items will be shown with a 👻 icon. Here is a table that fully describes which items are documented with each combination of --document-hidden-items and --document-private-items: rustdoc flags items that will be documented neither flag only public items that are not hidden only --document-hidden-items all public items only --document-private-items all items that are not hidden both flags all items","breadcrumbs":"Unstable features » --document-hidden-items: Show items that are #[doc(hidden)]","id":"160","title":"--document-hidden-items: Show items that are #[doc(hidden)]"},"161":{"body":"Tracking issue: #44027 Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-before-content extra.md\\n$ rustdoc README.md -Z unstable-options --markdown-before-content extra.md Just like --html-before-content, this allows you to insert extra content inside the <body> tag\\nbut before the other content rustdoc would normally produce in the rendered documentation.\\nHowever, instead of directly inserting the file verbatim, rustdoc will pass the files through a\\nMarkdown renderer before inserting the result into the file.","breadcrumbs":"Unstable features » --markdown-before-content: include rendered Markdown before the content","id":"161","title":"--markdown-before-content: include rendered Markdown before the content"},"162":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-after-content extra.md\\n$ rustdoc README.md -Z unstable-options --markdown-after-content extra.md Just like --html-after-content, this allows you to insert extra content before the </body> tag\\nbut after the other content rustdoc would normally produce in the rendered documentation.\\nHowever, instead of directly inserting the file verbatim, rustdoc will pass the files through a\\nMarkdown renderer before inserting the result into the file.","breadcrumbs":"Unstable features » --markdown-after-content: include rendered Markdown after the content","id":"162","title":"--markdown-after-content: include rendered Markdown after the content"},"163":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --playground-url https://play.rust-lang.org/ When rendering a crate’s docs, this flag gives the base URL of the Rust Playground, to use for\\ngenerating Run buttons. Unlike --markdown-playground-url, this argument works for standalone\\nMarkdown files and Rust crates. This works the same way as adding #![doc(html_playground_url = \\"url\\")] to your crate root, as mentioned in the chapter about the #[doc]\\nattribute. Please be aware that the official Rust Playground at\\nhttps://play.rust-lang.org does not have every crate available, so if your examples require your\\ncrate, make sure the playground you provide has your crate available. If both --playground-url and --markdown-playground-url are present when rendering a standalone\\nMarkdown file, the URL given to --markdown-playground-url will take precedence. If both --playground-url and #![doc(html_playground_url = \\"url\\")] are present when rendering crate docs,\\nthe attribute will take precedence.","breadcrumbs":"Unstable features » --playground-url: control the location of the playground","id":"163","title":"--playground-url: control the location of the playground"},"164":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --sort-modules-by-appearance Ordinarily, when rustdoc prints items in module pages, it will sort them alphabetically (taking\\nsome consideration for their stability, and names that end in a number). Giving this flag to rustdoc will disable this sorting and instead make it print the items in the order they appear in\\nthe source.","breadcrumbs":"Unstable features » --sort-modules-by-appearance: control how items on module pages are sorted","id":"164","title":"--sort-modules-by-appearance: control how items on module pages are sorted"},"165":{"body":"Tracking issue: #113248 Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --show-type-layout When this flag is passed, rustdoc will add a “Layout” section at the bottom of\\neach type’s docs page that includes a summary of the type’s memory layout as\\ncomputed by rustc. For example, rustdoc will show the size in bytes that a value\\nof that type will take in memory. Note that most layout information is completely unstable and may even differ\\nbetween compilations.","breadcrumbs":"Unstable features » --show-type-layout: add a section to each type’s docs describing its memory layout","id":"165","title":"--show-type-layout: add a section to each type’s docs describing its memory layout"},"166":{"body":"Tracking issue: #54765 Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --resource-suffix suf When rendering docs, rustdoc creates several CSS and JavaScript files as part of the output. Since\\nall these files are linked from every page, changing where they are can be cumbersome if you need to\\nspecially cache them. This flag will rename all these files in the output to include the suffix in\\nthe filename. For example, light.css would become light-suf.css with the above command.","breadcrumbs":"Unstable features » --resource-suffix: modifying the name of CSS/JavaScript in crate docs","id":"166","title":"--resource-suffix: modifying the name of CSS/JavaScript in crate docs"},"167":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --extern-html-root-url some-crate=https://example.com/some-crate/1.0.1 Ordinarily, when rustdoc wants to link to a type from a different crate, it looks in two places:\\ndocs that already exist in the output directory, or the #![doc(doc_html_root)] set in the other\\ncrate. However, if you want to link to docs that exist in neither of those places, you can use these\\nflags to control that behavior. When the --extern-html-root-url flag is given with a name matching\\none of your dependencies, rustdoc use that URL for those docs. Keep in mind that if those docs exist\\nin the output directory, those local docs will still override this flag. The names in this flag are first matched against the names given in the --extern name= flags,\\nwhich allows selecting between multiple crates with the same name (e.g. multiple versions of\\nthe same crate). For transitive dependencies that haven’t been loaded via an --extern flag, matching\\nfalls backs to using crate names only, without ability to distinguish between multiple crates with\\nthe same name.","breadcrumbs":"Unstable features » --extern-html-root-url: control how rustdoc links to non-local crates","id":"167","title":"--extern-html-root-url: control how rustdoc links to non-local crates"},"168":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z force-unstable-if-unmarked This is an internal flag intended for the standard library and compiler that applies an #[unstable] attribute to any dependent crate that doesn’t have another stability attribute. This\\nallows rustdoc to be able to generate documentation for the compiler crates and the standard\\nlibrary, as an equivalent command-line argument is provided to rustc when building those crates.","breadcrumbs":"Unstable features » -Z force-unstable-if-unmarked","id":"168","title":"-Z force-unstable-if-unmarked"},"169":{"body":"This feature allows you to generate an index-page with a given markdown file. A good example of it\\nis the rust documentation index. With this, you’ll have a page which you can customize as much as you want at the top of your crates. Using index-page option enables enable-index-page option as well.","breadcrumbs":"Unstable features » --index-page: provide a top-level landing page for docs","id":"169","title":"--index-page: provide a top-level landing page for docs"},"17":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --extern lazy-static=/path/to/lazy-static Similar to --library-path, --extern is about specifying the location\\nof a dependency. --library-path provides directories to search in, --extern\\ninstead lets you specify exactly which dependency is located where.","breadcrumbs":"Command-line arguments » --extern: specify a dependency’s location","id":"17","title":"--extern: specify a dependency’s location"},"170":{"body":"This feature allows the generation of a default index-page which lists the generated crates.","breadcrumbs":"Unstable features » --enable-index-page: generate a default index page for docs","id":"170","title":"--enable-index-page: generate a default index page for docs"},"171":{"body":"When this flag is used with --test, the output (stdout and stderr) of your tests won’t be\\ncaptured by rustdoc. Instead, the output will be directed to your terminal,\\nas if you had run the test executable manually. This is especially useful\\nfor debugging your tests!","breadcrumbs":"Unstable features » --no-capture: disable output capture for test","id":"171","title":"--no-capture: disable output capture for test"},"172":{"body":"When this flag is supplied, rustdoc will type check and lint your code, but will not generate any\\ndocumentation or run your doctests. Using this flag looks like: rustdoc -Z unstable-options --check src/lib.rs","breadcrumbs":"Unstable features » --check: only checks the documentation","id":"172","title":"--check: only checks the documentation"},"173":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --static-root-path \'/cache/\' This flag controls how rustdoc links to its static files on HTML pages. If you’re hosting a lot of\\ncrates’ docs generated by the same version of rustdoc, you can use this flag to cache rustdoc’s CSS,\\nJavaScript, and font files in a single location, rather than duplicating it once per “doc root”\\n(grouping of crate docs generated into the same output directory, like with cargo doc). Per-crate\\nfiles like the search index will still load from the documentation root, but anything that gets\\nrenamed with --resource-suffix will load from the given path.","breadcrumbs":"Unstable features » --static-root-path: control how static files are loaded in HTML output","id":"173","title":"--static-root-path: control how static files are loaded in HTML output"},"174":{"body":"Tracking issue: #56925 Using this flag looks like this: $ rustdoc src/lib.rs --test -Z unstable-options --persist-doctests target/rustdoctest This flag allows you to keep doctest executables around after they’re compiled or run.\\nUsually, rustdoc will immediately discard a compiled doctest after it’s been tested, but\\nwith this option, you can keep those binaries around for farther testing.","breadcrumbs":"Unstable features » --persist-doctests: persist doctest executables after running","id":"174","title":"--persist-doctests: persist doctest executables after running"},"175":{"body":"Tracking issue: #58154 Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --show-coverage It generates something like this: +-------------------------------------+------------+------------+------------+------------+\\n| File | Documented | Percentage | Examples | Percentage |\\n+-------------------------------------+------------+------------+------------+------------+\\n| lib.rs | 4 | 100.0% | 1 | 25.0% |\\n+-------------------------------------+------------+------------+------------+------------+\\n| Total | 4 | 100.0% | 1 | 25.0% |\\n+-------------------------------------+------------+------------+------------+------------+ If you want to determine how many items in your crate are documented, pass this flag to rustdoc.\\nWhen it receives this flag, it will count the public items in your crate that have documentation,\\nand print out the counts and a percentage instead of generating docs. Some methodology notes about what rustdoc counts in this metric: Rustdoc will only count items from your crate (i.e. items re-exported from other crates don’t\\ncount). Docs written directly onto inherent impl blocks are not counted, even though their doc comments\\nare displayed, because the common pattern in Rust code is to write all inherent methods into the\\nsame impl block. Items in a trait implementation are not counted, as those impls will inherit any docs from the\\ntrait itself. By default, only public items are counted. To count private items as well, pass --document-private-items at the same time. Public items that are not documented can be seen with the built-in missing_docs lint. Private\\nitems that are not documented can be seen with Clippy’s missing_docs_in_private_items lint. Calculating code examples follows these rules: These items aren’t accounted by default: struct/union field enum variant constant static typedef If one of the previously listed items has a code example, then it’ll be counted.","breadcrumbs":"Unstable features » --show-coverage: calculate the percentage of items with documentation","id":"175","title":"--show-coverage: calculate the percentage of items with documentation"},"176":{"body":"When using --output-format json with this option, it will display the coverage information in\\nJSON format. For example, here is the JSON for a file with one documented item and one\\nundocumented item: #![allow(unused)] fn main() {\\n/// This item has documentation\\npub fn foo() {} pub fn no_documentation() {} } {\\"no_std.rs\\":{\\"total\\":3,\\"with_docs\\":1,\\"total_examples\\":3,\\"with_examples\\":0}} Note that the third item is the crate root, which in this case is undocumented. If you want the JSON output to be displayed on stdout instead of having a file generated, you can\\nuse -o -.","breadcrumbs":"Unstable features » JSON output","id":"176","title":"JSON output"},"177":{"body":"","breadcrumbs":"Unstable features » -w/ --output-format: output format","id":"177","title":"-w/ --output-format: output format"},"178":{"body":"Tracking Issue: #76578 --output-format json emits documentation in the experimental JSON format. JSON Output for toolchain crates ( std, alloc, core, test, and proc_macro)\\nis available via the rust-docs-json rustup component. rustup component add --toolchain nightly rust-docs-json Then the json files will be present in the share/doc/rust/json/ directory\\nof the rustup toolchain directory. It can also be used with --show-coverage. Take a look at its documentation for more\\ninformation.","breadcrumbs":"Unstable features » json","id":"178","title":"json"},"179":{"body":"Tracking issue: #134529 --output-format doctest emits JSON on stdout which gives you information about doctests in the\\nprovided crate. You can use this option like this: rustdoc -Zunstable-options --output-format=doctest src/lib.rs For this rust code: #![allow(unused)] fn main() {\\n/// ```\\n/// #![allow(dead_code)]\\n/// let x = 12;\\n/// Ok(())\\n/// ```\\npub trait Trait {} } The generated output (formatted) will look like this: { \\"format_version\\": 2, \\"doctests\\": [ { \\"file\\": \\"src/lib.rs\\", \\"line\\": 1, \\"doctest_attributes\\": { \\"original\\": \\"\\", \\"should_panic\\": false, \\"no_run\\": false, \\"ignore\\": \\"None\\", \\"rust\\": true, \\"test_harness\\": false, \\"compile_fail\\": false, \\"standalone_crate\\": false, \\"error_codes\\": [], \\"edition\\": null, \\"added_css_classes\\": [], \\"unknown\\": [] }, \\"original_code\\": \\"#![allow(dead_code)]\\\\nlet x = 12;\\\\nOk(())\\", \\"doctest_code\\": { \\"crate_level\\": \\"#![allow(unused)]\\\\n#![allow(dead_code)]\\\\n\\\\n\\", \\"code\\": \\"let x = 12;\\\\nOk(())\\", \\"wrapper\\": { \\"before\\": \\"fn main() { fn _inner() -> core::result::Result<(), impl core::fmt::Debug> {\\\\n\\", \\"after\\": \\"\\\\n} _inner().unwrap() }\\", \\"returns_result\\": true } }, \\"name\\": \\"src/lib.rs - (line 1)\\" } ]\\n} format_version gives you the current version of the generated JSON. If we change the output in any way, the number will increase. doctests contains the list of doctests present in the crate. file is the file path where the doctest is located. line is the line where the doctest starts (so where the ``` is located in the current code). doctest_attributes contains computed information about the attributes used on the doctests. For more information about doctest attributes, take a look here. original_code is the code as written in the source code before rustdoc modifies it. doctest_code is the code modified by rustdoc that will be run. If there is a fatal syntax error, this field will not be present. crate_level is the crate level code (like attributes or extern crate) that will be added at the top-level of the generated doctest. code is “naked” doctest without anything from crate_level and wrapper content. wrapper contains extra code that will be added before and after code. returns_result is a boolean. If true, it means that the doctest returns a Result type. name is the name generated by rustdoc which represents this doctest.","breadcrumbs":"Unstable features » doctest","id":"179","title":"doctest"},"18":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -C target_feature=+avx\\n$ rustdoc src/lib.rs --codegen target_feature=+avx $ rustdoc --test src/lib.rs -C target_feature=+avx\\n$ rustdoc --test src/lib.rs --codegen target_feature=+avx $ rustdoc --test README.md -C target_feature=+avx\\n$ rustdoc --test README.md --codegen target_feature=+avx When rustdoc generates documentation, looks for documentation tests, or executes documentation\\ntests, it needs to compile some rust code, at least part-way. This flag allows you to tell rustdoc\\nto provide some extra codegen options to rustc when it runs these compilations. Most of the time,\\nthese options won’t affect a regular documentation run, but if something depends on target features\\nto be enabled, or documentation tests need to use some additional options, this flag allows you to\\naffect that. The arguments to this flag are the same as those for the -C flag on rustc. Run rustc -C help to\\nget the full list.","breadcrumbs":"Command-line arguments » -C/ --codegen: pass codegen options to rustc","id":"18","title":"-C/ --codegen: pass codegen options to rustc"},"180":{"body":"--output-format html has no effect, as the default output is HTML. This is\\naccepted on stable, even though the other options for this flag aren’t.","breadcrumbs":"Unstable features » html","id":"180","title":"html"},"181":{"body":"Tracking issue: #88791 This option, combined with --scrape-examples-target-crate and --scrape-examples-output-path, is used to implement the functionality in RFC\\n#3123. Uses of an item (currently\\nfunctions / call-sites) are found in a crate and its reverse-dependencies, and\\nthen the uses are included as documentation for that item. This feature is\\nintended to be used via cargo doc --scrape-examples, but the rustdoc-only\\nworkflow looks like: $ rustdoc examples/ex.rs -Z unstable-options \\\\ --extern foobar=target/deps/libfoobar.rmeta \\\\ --scrape-examples-target-crate foobar \\\\ --scrape-examples-output-path output.calls\\n$ rustdoc src/lib.rs -Z unstable-options --with-examples output.calls First, the library must be checked to generate an rmeta. Then a\\nreverse-dependency like examples/ex.rs is given to rustdoc with the target\\ncrate being documented ( foobar) and a path to output the calls\\n( output.calls). Then, the generated calls file can be passed via --with-examples to the subsequent documentation of foobar. To scrape examples from test code, e.g. functions marked #[test], then\\nadd the --scrape-tests flag.","breadcrumbs":"Unstable features » --with-examples: include examples of uses of items as documentation","id":"181","title":"--with-examples: include examples of uses of items as documentation"},"182":{"body":"Tracking issue: #89095 This flag enables the generation of links in the source code pages which allow the reader\\nto jump to a type definition.","breadcrumbs":"Unstable features » --generate-link-to-definition: Generate links on types in source code","id":"182","title":"--generate-link-to-definition: Generate links on types in source code"},"183":{"body":"Tracking issue: #102981 Using this flag looks like this: $ rustdoc --test-builder /path/to/rustc src/lib.rs Rustdoc will use the provided program to compile tests instead of the default rustc program from\\nthe sysroot.","breadcrumbs":"Unstable features » --test-builder: rustc-like program to build tests","id":"183","title":"--test-builder: rustc-like program to build tests"},"184":{"body":"Tracking issue: #102981 Using this flag looks like this: $ rustdoc -Zunstable-options --test-builder-wrapper /path/to/rustc-wrapper src/lib.rs\\n$ rustdoc -Zunstable-options \\\\ --test-builder-wrapper rustc-wrapper1 \\\\ --test-builder-wrapper rustc-wrapper2 \\\\ --test-builder rustc \\\\ src/lib.rs Similar to cargo build.rustc-wrapper option, this flag takes a rustc wrapper program.\\nThe first argument to the program will be the test builder program. This flag can be passed multiple times to nest wrappers.","breadcrumbs":"Unstable features » --test-builder-wrapper: wrap calls to the test builder","id":"184","title":"--test-builder-wrapper: wrap calls to the test builder"},"185":{"body":"You can use the --doctest-build-arg flag if you want to add options when compiling the\\ndoctest. For example if you have: #![allow(unused)] fn main() {\\n/// ```\\n/// #![deny(warnings)]\\n/// #![feature(async_await)]\\n///\\n/// let x = 12;\\n/// ```\\npub struct Bar; } And you run rustdoc --test on it, you will get: running 1 test\\ntest foo.rs - Bar (line 1) ... FAILED failures: ---- foo.rs - Bar (line 1) stdout ----\\nerror: the feature `async_await` has been stable since 1.39.0 and no longer requires an attribute to enable --> foo.rs:2:12 |\\n3 | #![feature(async_await)] | ^^^^^^^^^^^ |\\nnote: the lint level is defined here --> foo.rs:1:9 |\\n2 | #![deny(warnings)] | ^^^^^^^^ = note: `#[deny(stable_features)]` implied by `#[deny(warnings)]` error: aborting due to 1 previous error Couldn\'t compile the test. failures: foo.rs - Bar (line 1) test result: FAILED. 0 passed; 1 failed; 0 ignored; 0 measured; 0 filtered out; finished in 0.03s But if you can limit the lint level to warning by using --doctest-build-arg=--cap-lints=warn: $ rustdoc --test --doctest-build-arg=--cap-lints=warn file.rs running 1 test\\ntest tests/rustdoc-ui/doctest/rustflags.rs - Bar (line 5) ... ok test result: ok. 1 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out; finished in 0.06s In order to pass multiple arguments to the underlying compiler,\\npass --doctest-build-arg ARG for each argument ARG.","breadcrumbs":"Unstable features » Passing arguments to rustc when compiling doctests","id":"185","title":"Passing arguments to rustc when compiling doctests"},"186":{"body":"This flag enables the generation of toggles to expand macros in the HTML source code pages.","breadcrumbs":"Unstable features » --generate-macro-expansion: Generate macros expansion toggles in source code","id":"186","title":"--generate-macro-expansion: Generate macros expansion toggles in source code"},"187":{"body":"This feature aims at providing rustdoc users the possibility to add visual markers to the rendered documentation to know under which conditions an item is available (currently possible through the following unstable feature: doc_cfg). It does not aim to allow having a same item with different cfgs to appear more than once in the generated documentation. It does not aim to document items which are inactive under the current configuration (i.e., “ cfged out”). This features adds the following attributes: #[doc(auto_cfg)]/ #[doc(auto_cfg = true)]/ #[doc(auto_cfg = false)] #[doc(cfg(...))] #![doc(auto_cfg(hide(...)))] / #[doc(auto_cfg(show(...)))] All of these attributes can be added to a module or to the crate root, and they will be inherited by the child items unless another attribute overrides it. This is why “opposite” attributes like auto_cfg(hide(...)) and auto_cfg(show(...)) are provided: they allow a child item to override its parent.","breadcrumbs":"Unstable features » #[doc(cfg)] and #[doc(auto_cfg)]","id":"187","title":"#[doc(cfg)] and #[doc(auto_cfg)]"},"188":{"body":"This attribute provides a standardized format to override #[cfg()] attributes to document conditionally available items. Example: // the \\"real\\" cfg condition\\n#[cfg(feature = \\"futures-io\\")]\\n// the `doc(cfg())` so it\'s displayed to the readers\\n#[doc(cfg(feature = \\"futures-io\\"))]\\npub mod futures {} It will display in the documentation for this module: This is supported on feature=\\"futures-io\\" only. You can use it to display information in generated documentation, whether or not there is a #[cfg()] attribute: #[doc(cfg(feature = \\"futures-io\\"))]\\npub mod futures {} It will be displayed exactly the same as the previous code. This attribute has the same syntax as conditional compilation, but it only causes documentation to be added. This means #[doc(cfg(not(windows)))] will not cause your docs to be hidden on non-windows targets, even though #[cfg(not(windows))] does do that. If doc(auto_cfg) is enabled on the item, doc(cfg) will override it anyway so in the two previous examples, even if the doc(auto_cfg) feature was enabled, it would still display the same thing. This attribute works on modules and on items.","breadcrumbs":"Unstable features » #[doc(cfg(...))]","id":"188","title":"#[doc(cfg(...))]"},"189":{"body":"This attribute is used to prevent some cfg to be generated in the visual markers. It only applies to #[doc(auto_cfg = true)], not to #[doc(cfg(...))]. So in the previous example: #[cfg(any(unix, feature = \\"futures-io\\"))]\\npub mod futures {} It currently displays both unix and feature = \\"futures-io\\" into the documentation, which is not great. To prevent the unix cfg to ever be displayed, you can use this attribute at the crate root level: #![doc(auto_cfg(hide(unix)))] Or directly on a given item/module as it covers any of the item’s descendants: #[doc(auto_cfg(hide(unix)))]\\n#[cfg(any(unix, feature = \\"futures-io\\"))]\\npub mod futures { // `futures` and all its descendants won\'t display \\"unix\\" in their cfgs.\\n} Then, the unix cfg will never be displayed into the documentation. Rustdoc currently hides doc and doctest attributes by default and reserves the right to change the list of “hidden by default” attributes. The attribute accepts only a list of identifiers or key/value items. So you can write: #[doc(auto_cfg(hide(unix, doctest, feature = \\"something\\")))]\\n#[doc(auto_cfg(hide()))] But you cannot write: #[doc(auto_cfg(hide(not(unix))))] So if we use doc(auto_cfg(hide(unix))), it means it will hide all mentions of unix: #[cfg(unix)] // nothing displayed\\n#[cfg(any(unix))] // nothing displayed\\n#[cfg(any(unix, windows))] // only `windows` displayed However, it only impacts the unix cfg, not the feature: #[cfg(feature = \\"unix\\")] // `feature = \\"unix\\"` is displayed If cfg_auto(show(...)) and cfg_auto(hide(...)) are used to show/hide a same cfg on a same item, it’ll emit an error. Example: #[doc(auto_cfg(hide(unix)))]\\n#[doc(auto_cfg(show(unix)))] // Error!\\npub fn foo() {} Using this attribute will re-enable auto_cfg if it was disabled at this location: #[doc(auto_cfg = false)] // Disabling `auto_cfg`\\npub fn foo() {} And using doc(auto_cfg) will re-enable it: #[doc(auto_cfg = false)] // Disabling `auto_cfg`\\npub mod module { #[doc(auto_cfg(hide(unix)))] // `auto_cfg` is re-enabled. pub fn foo() {}\\n} However, using doc(auto_cfg = ...) and doc(auto_cfg(...)) on the same item will emit an error: #[doc(auto_cfg = false)]\\n#[doc(auto_cfg(hide(unix)))] // error\\npub fn foo() {} The reason behind this is that doc(auto_cfg = ...) enables or disables the feature, whereas doc(auto_cfg(...)) enables it unconditionally, making the first attribute to appear useless as it will be overidden by the next doc(auto_cfg) attribute.","breadcrumbs":"Unstable features » #[doc(auto_cfg(hide(...)))]","id":"189","title":"#[doc(auto_cfg(hide(...)))]"},"19":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test This flag will run your code examples as tests. For more, see the chapter\\non documentation tests. See also --test-args and --test-run-directory.","breadcrumbs":"Command-line arguments » --test: run code examples as tests","id":"19","title":"--test: run code examples as tests"},"190":{"body":"This attribute does the opposite of #[doc(auto_cfg(hide(...)))]: if you used #[doc(auto_cfg(hide(...)))] and want to revert its effect on an item and its descendants, you can use #[doc(auto_cfg(show(...)))].\\nIt only applies to #[doc(auto_cfg = true)], not to #[doc(cfg(...))]. For example: #[doc(auto_cfg(hide(unix)))]\\n#[cfg(any(unix, feature = \\"futures-io\\"))]\\npub mod futures { // `futures` and all its descendants won\'t display \\"unix\\" in their cfgs. #[doc(auto_cfg(show(unix)))] pub mod child { // `child` and all its descendants will display \\"unix\\" in their cfgs. }\\n} The attribute accepts only a list of identifiers or key/value items. So you can write: #[doc(auto_cfg(show(unix, doctest, feature = \\"something\\")))]\\n#[doc(auto_cfg(show()))] But you cannot write: #[doc(auto_cfg(show(not(unix))))] If auto_cfg(show(...)) and auto_cfg(hide(...)) are used to show/hide a same cfg on a same item, it’ll emit an error. Example: #[doc(auto_cfg(show(unix)))]\\n#[doc(auto_cfg(hide(unix)))] // Error!\\npub fn foo() {} Using this attribute will re-enable auto_cfg if it was disabled at this location: #[doc(auto_cfg = false)] // Disabling `auto_cfg`\\n#[doc(auto_cfg(show(unix)))] // `auto_cfg` is re-enabled.\\npub fn foo() {}","breadcrumbs":"Unstable features » #[doc(auto_cfg(show(...)))]","id":"190","title":"#[doc(auto_cfg(show(...)))]"},"191":{"body":"By default, #[doc(auto_cfg)] is enabled at the crate-level. When it’s enabled, Rustdoc will automatically display cfg(...) compatibility information as-if the same #[doc(cfg(...))] had been specified. This attribute impacts the item on which it is used and its descendants. So if we take back the previous example: #![allow(unused)] fn main() {\\n#[cfg(feature = \\"futures-io\\")]\\npub mod futures {} } There’s no need to “duplicate” the cfg into a doc(cfg()) to make Rustdoc display it. In some situations, the detailed conditional compilation rules used to implement the feature might not serve as good documentation (for example, the list of supported platforms might be very long, and it might be better to document them in one place). To turn it off, add the #[doc(auto_cfg = false)] attribute on the item. If no argument is specified (ie #[doc(auto_cfg)]), it’s the same as writing #[doc(auto_cfg = true)].","breadcrumbs":"Unstable features » #[doc(auto_cfg)/ #[doc(auto_cfg = true)]/ #[doc(auto_cfg = false)]","id":"191","title":"#[doc(auto_cfg)/ #[doc(auto_cfg = true)]/ #[doc(auto_cfg = false)]"},"192":{"body":"Rustdoc merges cfg attributes from parent modules to its children. For example, in this case, the module non_unix will describe the entire compatibility matrix for the module, and not just its directly attached information: #[doc(cfg(any(windows, unix)))]\\npub mod desktop { #[doc(cfg(not(unix)))] pub mod non_unix { // ... }\\n} This code will display: Available on (Windows or Unix) and non-Unix only.","breadcrumbs":"Unstable features » Inheritance","id":"192","title":"Inheritance"},"193":{"body":"cfg attributes of a re-export are never merged with the re-exported item(s) attributes except if the re-export has the #[doc(inline)] attribute. In this case, the cfg of the re-exported item will be merged with the re-export’s. When talking about “attributes merge”, we mean that if the re-export has #[cfg(unix)] and the re-exported item has #[cfg(feature = \\"foo\\")], you will only see cfg(unix) on the re-export and only cfg(feature = \\"foo\\") on the re-exported item, unless the re-export has #[doc(inline)], then you will only see the re-exported item with both cfg(unix) and cfg(feature = \\"foo\\"). Example: #[doc(cfg(any(windows, unix)))]\\npub mod desktop { #[doc(cfg(not(unix)))] pub mod non_unix { // code }\\n} #[doc(cfg(target_os = \\"freebsd\\"))]\\npub use desktop::non_unix as non_unix_desktop;\\n#[doc(cfg(target_os = \\"macos\\"))]\\n#[doc(inline)]\\npub use desktop::non_unix as inlined_non_unix_desktop; In this example, non_unix_desktop will only display cfg(target_os = \\"freeebsd\\") and not display any cfg from desktop::non_unix. On the contrary, inlined_non_unix_desktop will have cfgs from both the re-export and the re-exported item. So that also means that if a crate re-exports a foreign item, unless it has #[doc(inline)], the cfg and doc(cfg) attributes will not be visible: // dep:\\n#[cfg(feature = \\"a\\")]\\npub struct S; // crate using dep: // There will be no mention of `feature = \\"a\\"` in the documentation.\\npub use dep::S as Y;","breadcrumbs":"Unstable features » Re-exports and inlining","id":"193","title":"Re-exports and inlining"},"194":{"body":"","breadcrumbs":"Deprecated features » Deprecated features","id":"194","title":"Deprecated features"},"195":{"body":"Rustdoc has a concept called “passes”. These are transformations that rustdoc runs on your documentation before producing its final output. Customizing passes is deprecated. The available passes are not considered stable and may\\nchange in any release. In the past the most common use case for customizing passes was to omit the strip-private pass.\\nYou can do this more easily, and without risk of the pass being changed, by passing --document-private-items.","breadcrumbs":"Deprecated features » Passes","id":"195","title":"Passes"},"196":{"body":"There are many great rustdoc references out there.\\nIf you know of other great resources, please submit a pull request!","breadcrumbs":"References » References","id":"196","title":"References"},"197":{"body":"Learn Rust Rust By Example Rust Reference RFC 1574: More API Documentation Conventions RFC 1946: Intra Rustdoc Links","breadcrumbs":"References » Official","id":"197","title":"Official"},"198":{"body":"API Guidelines GitHub tagged RFCs GitHub tagged issues RFC (stalled) front page styleguide Guide on how to write documentation for a Rust crate","breadcrumbs":"References » Community","id":"198","title":"Community"},"2":{"body":"There are two problems with this: first, why does it\\nthink that our crate is named “lib”? Second, why does it not have any\\ncontents? The first problem is due to rustdoc trying to be helpful; like rustc,\\nit assumes that our crate’s name is the name of the file for the crate\\nroot. To fix this, we can pass in a command-line flag: $ rustdoc src/lib.rs --crate-name docs Now, doc/docs/index.html will be generated, and the page says “Crate docs.” For the second issue, it is because our function foo is not public; rustdoc\\ndefaults to generating documentation for only public functions. If we change\\nour code… #![allow(unused)] fn main() {\\n/// foo is a function\\npub fn foo() {} } … and then re-run rustdoc: $ rustdoc src/lib.rs --crate-name docs We now have some generated documentation. Open up doc/docs/index.html and\\ncheck it out! It should show a link to the foo function’s page, which\\nis located at doc/docs/fn.foo.html. On that page, you’ll see the “foo is\\na function” we put inside the documentation comment in our crate.","breadcrumbs":"What is rustdoc? » Configuring rustdoc","id":"2","title":"Configuring rustdoc"},"20":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test --test-args ignored This flag will pass options to the test runner when running documentation tests.\\nFor more, see the chapter on documentation tests. See also --test.","breadcrumbs":"Command-line arguments » --test-args: pass options to test runner","id":"20","title":"--test-args: pass options to test runner"},"21":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test --test-run-directory=/path/to/working/directory This flag will run your code examples in the specified working directory.\\nFor more, see the chapter on documentation tests. See also --test.","breadcrumbs":"Command-line arguments » --test-run-directory: run code examples in a specific directory","id":"21","title":"--test-run-directory: run code examples in a specific directory"},"22":{"body":"A doctest wrapper program can be specified with the --test-runtool flag.\\nRustdoc will execute that wrapper instead of the doctest executable when\\nrunning tests. The first arguments to the wrapper will be any arguments\\nspecified with the --test-runtool-arg flag, followed by the path to the\\ndoctest executable to run. Using these options looks like this: $ rustdoc src/lib.rs --test-runtool path/to/runner --test-runtool-arg --do-thing --test-runtool-arg --do-other-thing For example, if you want to run your doctests under valgrind you might run: $ rustdoc src/lib.rs --test-runtool valgrind Another use case would be to run a test inside an emulator, or through a Virtual Machine.","breadcrumbs":"Command-line arguments » --test-runtool, --test-runtool-arg: program to run tests with; args to pass to it","id":"22","title":"--test-runtool, --test-runtool-arg: program to run tests with; args to pass to it"},"23":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --target x86_64-pc-windows-gnu Similar to the --target flag for rustc, this generates documentation\\nfor a target triple that’s different than your host triple. All of the usual caveats of cross-compiling code apply.","breadcrumbs":"Command-line arguments » --target: generate documentation for the specified target triple","id":"23","title":"--target: generate documentation for the specified target triple"},"24":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --default-theme=ayu Sets the default theme (for users whose browser has not remembered a\\nprevious theme selection from the on-page theme picker). The supplied value should be the lowercase version of the theme name.\\nThe set of available themes can be seen in the theme picker in the\\ngenerated output. Note that the set of available themes - and their appearance - is not\\nnecessarily stable from one rustdoc version to the next. If the\\nrequested theme does not exist, the builtin default (currently light) is used instead.","breadcrumbs":"Command-line arguments » --default-theme: set the default theme","id":"24","title":"--default-theme: set the default theme"},"25":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-css foo.css When rendering Markdown files, this will create a <link> element in the <head> section of the generated HTML. For example, with the invocation above, <link rel=\\"stylesheet\\" type=\\"text/css\\" href=\\"foo.css\\"> will be added. When rendering Rust files, this flag is ignored.","breadcrumbs":"Command-line arguments » --markdown-css: include more CSS files when rendering markdown","id":"25","title":"--markdown-css: include more CSS files when rendering markdown"},"26":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-in-header header.html\\n$ rustdoc README.md --html-in-header header.html This flag takes a list of files, and inserts them into the <head> section of\\nthe rendered documentation.","breadcrumbs":"Command-line arguments » --html-in-header: include more HTML in <head>","id":"26","title":"--html-in-header: include more HTML in <head>"},"27":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-before-content extra.html\\n$ rustdoc README.md --html-before-content extra.html This flag takes a list of files, and inserts them inside the <body> tag but\\nbefore the other content rustdoc would normally produce in the rendered\\ndocumentation.","breadcrumbs":"Command-line arguments » --html-before-content: include more HTML before the content","id":"27","title":"--html-before-content: include more HTML before the content"},"28":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-after-content extra.html\\n$ rustdoc README.md --html-after-content extra.html This flag takes a list of files, and inserts them before the </body> tag but\\nafter the other content rustdoc would normally produce in the rendered\\ndocumentation.","breadcrumbs":"Command-line arguments » --html-after-content: include more HTML after the content","id":"28","title":"--html-after-content: include more HTML after the content"},"29":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-playground-url https://play.rust-lang.org/ When rendering a Markdown file, this flag gives the base URL of the Rust\\nPlayground, to use for generating Run buttons.","breadcrumbs":"Command-line arguments » --markdown-playground-url: control the location of the playground","id":"29","title":"--markdown-playground-url: control the location of the playground"},"3":{"body":"Cargo also has integration with rustdoc to make it easier to generate\\ndocs. Instead of the rustdoc command, we could have done this: $ cargo doc If you want cargo to automatically open the generated documentation, you can use: $ cargo doc --open Internally, cargo doc calls out to rustdoc like this: $ rustdoc --crate-name docs src/lib.rs -o <path>/docs/target/doc -L\\ndependency=<path>/docs/target/debug/deps You can see this with cargo doc --verbose. It generates the correct --crate-name for us, as well as pointing to src/lib.rs. But what about those other arguments? -o controls the output of our docs. Instead of a top-level doc directory, notice that Cargo puts generated documentation under target. That is the idiomatic place for generated files in Cargo projects. -L flag helps rustdoc find the dependencies your code relies on.\\nIf our project used dependencies, we would get documentation for them as well!","breadcrumbs":"What is rustdoc? » Using rustdoc with Cargo","id":"3","title":"Using rustdoc with Cargo"},"30":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-no-toc When generating documentation from a Markdown file, by default, rustdoc will\\ngenerate a table of contents. This flag suppresses that, and no TOC will be\\ngenerated.","breadcrumbs":"Command-line arguments » --markdown-no-toc: don’t generate a table of contents","id":"30","title":"--markdown-no-toc: don’t generate a table of contents"},"31":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -e extra.css\\n$ rustdoc src/lib.rs --extend-css extra.css With this flag, the contents of the files you pass are included at the bottom\\nof the theme.css file.","breadcrumbs":"Command-line arguments » -e/ --extend-css: extend rustdoc’s CSS","id":"31","title":"-e/ --extend-css: extend rustdoc’s CSS"},"32":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --sysroot /path/to/sysroot Similar to rustc --sysroot, this lets you change the sysroot rustdoc uses\\nwhen compiling your code.","breadcrumbs":"Command-line arguments » --sysroot: override the system root","id":"32","title":"--sysroot: override the system root"},"33":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --edition 2018\\n$ rustdoc --test src/lib.rs --edition 2018 This flag allows rustdoc to treat your rust code as the given edition. It will compile doctests with\\nthe given edition as well. As with rustc, the default edition that rustdoc will use is 2015\\n(the first edition).","breadcrumbs":"Command-line arguments » --edition: control the edition of docs and doctests","id":"33","title":"--edition: control the edition of docs and doctests"},"34":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --theme /path/to/your/custom-theme.css rustdoc’s default output includes two themes: light (the default) and dark. This flag allows you to add custom themes to the output. Giving a CSS\\nfile to this flag adds it to your documentation as an additional theme choice.\\nThe theme’s name is determined by its filename; a theme file named custom-theme.css will add a theme named custom-theme to the documentation.","breadcrumbs":"Command-line arguments » --theme: add a theme to the documentation output","id":"34","title":"--theme: add a theme to the documentation output"},"35":{"body":"Using this flag looks like this: $ rustdoc --check-theme /path/to/your/custom-theme.css While rustdoc’s HTML output is more-or-less consistent between versions, there\\nis no guarantee that a theme file will have the same effect. The --theme flag\\nwill still allow you to add the theme to your documentation, but to ensure that\\nyour theme works as expected, you can use this flag to verify that it implements\\nthe same CSS rules as the official light theme. --check-theme is a separate mode in rustdoc. When rustdoc sees the --check-theme flag, it discards all other flags and only performs the CSS rule\\ncomparison operation.","breadcrumbs":"Command-line arguments » --check-theme: verify custom themes against the default theme","id":"35","title":"--check-theme: verify custom themes against the default theme"},"36":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-version 1.3.37 When rustdoc receives this flag, it will print an extra “Version (version)” into the sidebar of\\nthe crate root’s docs. You can use this flag to differentiate between different versions of your\\nlibrary’s documentation.","breadcrumbs":"Command-line arguments » --crate-version: control the crate version","id":"36","title":"--crate-version: control the crate version"},"37":{"body":"If you specify - as the INPUT on the command line, then rustdoc will read the\\nsource code from stdin (standard input stream) until the EOF, instead of the file\\nsystem with an otherwise specified path.","breadcrumbs":"Command-line arguments » -: load source code from the standard input","id":"37","title":"-: load source code from the standard input"},"38":{"body":"If you specify @path on the command-line, then it will open path and read\\ncommand line options from it. These options are one per line; a blank line indicates\\nan empty option. The file can use Unix or Windows style line endings, and must be\\nencoded as UTF-8.","breadcrumbs":"Command-line arguments » @path: load command-line flags from a path","id":"38","title":"@path: load command-line flags from a path"},"39":{"body":"This flag is deprecated.\\nFor more details on passes, see the chapter on them.","breadcrumbs":"Command-line arguments » --passes: add more rustdoc passes","id":"39","title":"--passes: add more rustdoc passes"},"4":{"body":"The /// syntax is used to document the item present after it.\\nThat’s why it is called an outer documentation.\\nThere is another syntax: //!, which is used to document the\\nitem it is present inside. It is called an inner documentation.\\nIt is often used when documenting the entire crate,\\nbecause nothing comes before it: it is the root of the crate.\\nSo in order to document an entire crate, you need to use //! syntax.\\nFor example: #![allow(unused)] fn main() {\\n//! This is my first rust crate } When used in the crate root, it documents the item it is inside,\\nwhich is the crate itself. For more information about the //! syntax, see the Book.","breadcrumbs":"What is rustdoc? » Outer and inner documentation","id":"4","title":"Outer and inner documentation"},"40":{"body":"This flag is deprecated.\\nFor more details on passes, see the chapter on them.","breadcrumbs":"Command-line arguments » --no-defaults: don’t run default passes","id":"40","title":"--no-defaults: don’t run default passes"},"41":{"body":"This flag is deprecated and has no effect. Rustdoc only supports Rust source code and Markdown input formats. If the\\nfile ends in .md or .markdown, rustdoc treats it as a Markdown file.\\nOtherwise, it assumes that the input file is Rust.","breadcrumbs":"Command-line arguments » -r/ --input-format: input format","id":"41","title":"-r/ --input-format: input format"},"42":{"body":"Rustdoc’s HTML output includes a friendly and useful navigation interface which\\nmakes it easier for users to navigate and understand your code.\\nThis chapter covers the major features of that interface,\\nand is a great starting point for documentation authors and users alike.","breadcrumbs":"How to read rustdoc output » How to read rustdoc output","id":"42","title":"How to read rustdoc output"},"43":{"body":"The rustdoc output is divided into three sections.\\nAlong the left side of each page is a quick navigation bar,\\nwhich shows contextual information about the current entry.\\nThe rest of the page is taken up by the search interface at the top\\nand the documentation for the current item below that.","breadcrumbs":"How to read rustdoc output » Structure","id":"43","title":"Structure"},"44":{"body":"The majority of the screen is taken up with the documentation text for the item\\ncurrently being viewed.\\nAt the top is some at-a-glance info and controls: the type and name of the item,\\nsuch as “Struct std::time::Duration”, a button to copy the item’s path to the clipboard,\\nwhich is a clipboard item a button to collapse or expand the top-level documentation for that item\\n( [+] or [-]), a link to the source code ( [src]),\\nif configured,\\nand present (the source may not be available if\\nthe documentation was created with cargo doc --no-deps), and the version in which the item became stable,\\nif it’s a stable item in the standard library. Below this is the main documentation for the item,\\nincluding a definition or function signature if appropriate,\\nfollowed by a list of fields or variants for Rust types.\\nFinally, the page lists associated functions and trait implementations,\\nincluding automatic and blanket implementations that rustdoc knows about.","breadcrumbs":"How to read rustdoc output » The Item Documentation","id":"44","title":"The Item Documentation"},"45":{"body":"Aliased Type A type alias is expanded at compile time to its aliased type.\\nThat may involve substituting some or all of the type parameters in the target\\ntype with types provided by the type alias definition. The Aliased Type section\\nshows the result of this expansion, including the types of public fields or\\nvariants, which may depend on those substitutions.","breadcrumbs":"How to read rustdoc output » Sections","id":"45","title":"Sections"},"46":{"body":"Subheadings, variants, fields, and many other things in this documentation\\nare anchors and can be clicked on and deep-linked to,\\nwhich is a great way to communicate exactly what you’re talking about.\\nThe typographical character “§” appears next to lines with anchors on them\\nwhen hovered or given keyboard focus.","breadcrumbs":"How to read rustdoc output » Navigation","id":"46","title":"Navigation"},"47":{"body":"For example, when looking at documentation for the crate root,\\nit shows all the crates documented in the documentation bundle,\\nand quick links to the modules, structs, traits, functions, and macros available\\nfrom the current crate.\\nAt the top, it displays a configurable logo\\nalongside the current crate’s name and version,\\nor the current item whose documentation is being displayed.","breadcrumbs":"How to read rustdoc output » The Navigation Bar","id":"47","title":"The Navigation Bar"},"48":{"body":"When viewing rustdoc’s output in a browser with JavaScript enabled,\\na dynamic interface appears at the top of the page composed of the search\\ninterface, help screen, and options. Paths are supported as well, you can look for Vec::new or Option::Some or\\neven module::module_child::another_child::struct::field. Whitespace characters\\nare considered the same as ::, so if you write Vec new, it will be\\nconsidered the same as Vec::new.","breadcrumbs":"How to read rustdoc output » The Theme Picker and Search Interface","id":"48","title":"The Theme Picker and Search Interface"},"49":{"body":"Pressing S while focused elsewhere on the page will move focus to the\\nsearch bar, and pressing ? shows the help screen,\\nwhich includes all these shortcuts and more. When the search results are focused,\\nthe left and right arrows move between tabs and the up and down arrows move\\namong the results.\\nPressing the enter or return key opens the highlighted result. When looking at the documentation for an item, the plus and minus keys expand\\nand collapse all sections in the document.","breadcrumbs":"How to read rustdoc output » Shortcuts","id":"49","title":"Shortcuts"},"5":{"body":"rustdoc can also generate HTML from standalone Markdown files. Let’ s\\ngive it a try: create a README.md file with these contents: # Docs This is a project to test out `rustdoc`. [Here is a link!](https://www.rust-lang.org) ## Example ```rust\\nfn foo() -> i32 { 1 + 1\\n}\\n``` And call rustdoc on it: $ rustdoc README.md You will find an HTML file in docs/doc/README.html generated from its\\nMarkdown contents. Cargo currently does not understand standalone Markdown files, unfortunately.","breadcrumbs":"What is rustdoc? » Using standalone Markdown files","id":"5","title":"Using standalone Markdown files"},"50":{"body":"Rustdoc’s HTML output includes a settings menu, and this chapter describes what\\neach setting in this menu does. It can be accessed by clicking on the gear button\\n( ) in the upper right.","breadcrumbs":"How to read rustdoc output » In-doc settings » Rustdoc in-doc settings","id":"50","title":"Rustdoc in-doc settings"},"51":{"body":"It is possible to change the theme. If you pick the “system preference”, you\\nwill be able to see two new sub-menus: “Preferred light theme” and “Preferred\\ndark theme”. It means that if your system preference is set to “light”, then\\nrustdoc will use the theme you selected in “Preferred light theme”.","breadcrumbs":"How to read rustdoc output » In-doc settings » Changing displayed theme","id":"51","title":"Changing displayed theme"},"52":{"body":"If the type definition contains more than 12 items, and this setting is enabled,\\nit’ll collapse them by default. You can see them by clicking on the [+] button\\nto expand them. A good example of this setting in use can be seen in the Iterator doc\\npage:","breadcrumbs":"How to read rustdoc output » In-doc settings » Auto-hide item contents for large items","id":"52","title":"Auto-hide item contents for large items"},"53":{"body":"If enabled, this setting will collapse all trait implementations blocks. It is\\nconvenient if you just want an overview of all the methods available. You can\\nstill see a method’s documentation by expanding it.","breadcrumbs":"How to read rustdoc output » In-doc settings » Auto-hide item methods’ documentation","id":"53","title":"Auto-hide item methods’ documentation"},"54":{"body":"If enabled, this setting will collapse all trait implementations blocks (you can\\nsee them in the “Trait Implementations” section). It is convenient if you just\\nwant an overview of all the trait implemented on a type. You can still see\\na trait implementation’s associated items by expanding it. Example:","breadcrumbs":"How to read rustdoc output » In-doc settings » Auto-hide trait implementation documentation","id":"54","title":"Auto-hide trait implementation documentation"},"55":{"body":"If this setting is enabled, you will directly be taken to the result page if\\nyour search only returned one element. Useful if you know exactly what you’re\\nlooking for and want to be taken there directly and not waste time selecting the\\nonly search result.","breadcrumbs":"How to read rustdoc output » In-doc settings » Directly go to item in search if there is only one result","id":"55","title":"Directly go to item in search if there is only one result"},"56":{"body":"If enabled, this setting will add line numbers to the code examples in the\\ndocumentation. It provides a visual aide for the code reading.","breadcrumbs":"How to read rustdoc output » In-doc settings » Show line numbers on code examples","id":"56","title":"Show line numbers on code examples"},"57":{"body":"If this setting is enabled, the keyboard shortcuts will be disabled. It’s useful\\nin case some of these shortcuts are already used by a web extension you’re\\nusing. To see the full list of the rustdoc keyboard shortcuts, you can open the help\\nmenu (the button with the question mark on the left of the setting menu button).","breadcrumbs":"How to read rustdoc output » In-doc settings » Disable keyboard shortcuts","id":"57","title":"Disable keyboard shortcuts"},"58":{"body":"Typing in the search bar instantly searches the available documentation,\\nmatching either the name and path of an item, or a function’s approximate\\ntype signature.","breadcrumbs":"How to read rustdoc output » Search » Rustdoc search","id":"58","title":"Rustdoc search"},"59":{"body":"To search by the name of an item (items include modules, types, traits,\\nfunctions, and macros), write its name or path. As a special case, the parts\\nof a path that normally get divided by :: double colons can instead be\\nseparated by spaces. For example: vec new and vec::new both show the function std::vec::Vec::new\\nas a result. vec, vec vec, std::vec, and std::vec::Vec all include the struct std::vec::Vec itself in the results (and all but the last one also\\ninclude the module in the results). As a quick way to trim down the list of results, there’s a drop-down selector\\nbelow the search input, labeled “Results in [std]”. Clicking it can change\\nwhich crate is being searched. Rustdoc uses a fuzzy matching function that can tolerate typos for this,\\nthough it’s based on the length of the name that’s typed in, so a good example\\nof how this works would be HahsMap. To avoid this, wrap the item in quotes,\\nsearching for \\"HahsMap\\" (in this example, no results will be returned).","breadcrumbs":"How to read rustdoc output » Search » Search By Name","id":"59","title":"Search By Name"},"6":{"body":"This covers the simplest use-cases of rustdoc. The rest of this book will\\nexplain all of the options that rustdoc has, and how to use them.","breadcrumbs":"What is rustdoc? » Summary","id":"6","title":"Summary"},"60":{"body":"In fact, using HahsMap again as the example, it tells you that you’re\\nusing “In Names” by default, but also lists two other tabs below the crate\\ndrop-down: “In Parameters” and “In Return Types”. These two tabs are lists of functions, defined on the closest matching type\\nto the search (for HahsMap, it loudly auto-corrects to hashmap). This\\nauto-correct only kicks in if nothing is found that matches the literal. These tabs are not just methods. For example, searching the alloc crate for Layout also lists functions that accept layouts even though they’re\\nmethods on the allocator or free functions.","breadcrumbs":"How to read rustdoc output » Search » Tabs in the Search By Name interface","id":"60","title":"Tabs in the Search By Name interface"},"61":{"body":"If you know more specifically what the function you want to look at does,\\nor you want to know how to get from one type to another,\\nRustdoc can search by more than one type at once in the parameters and return\\nvalue. Multiple parameters are separated by , commas, and the return value\\nis written with after a -> arrow. Before describing the syntax in more detail, here’s a few sample searches of\\nthe standard library and functions that are included in the results list: Query Results usize -> vec slice::repeat and Vec::with_capacity vec, vec -> bool Vec::eq option<T>, fnonce -> option<U> Option::map and Option::and_then option<T>, (fnonce (T) -> bool) -> option<T> Option::filter option<T>, (T -> bool) -> option<T> Option::filter option -> default Option::unwrap_or_default stdout, [u8] Stdout::write any -> ! panic::panic_any vec::intoiter<T> -> [T] IntoIter::as_slice and IntoIter::next_chunk iterator<T>, fnmut -> T Iterator::reduce and Iterator::find","breadcrumbs":"How to read rustdoc output » Search » Searching By Type Signature","id":"61","title":"Searching By Type Signature"},"62":{"body":"Certain items that are not functions are treated as though they\\nwere a semantically equivalent function. For example, struct fields are treated as though they were getter methods.\\nThis means that a search for CpuidResult -> u32 will show\\nthe CpuidResult::eax field in the results. Additionally, const and static items are treated as nullary functions,\\nso -> u32 will match u32::MAX.","breadcrumbs":"How to read rustdoc output » Search » Non-functions in type-based search","id":"62","title":"Non-functions in type-based search"},"63":{"body":"In a complex type-based search, Rustdoc always treats every item’s name as literal.\\nIf a name is used and nothing in the docs matches the individual item, such as\\na typo-ed uize -> vec search, the item uize is treated as a generic\\ntype parameter (resulting in vec::from and other generic vec constructors). After deciding which items are type parameters and which are actual types, it\\nthen searches by matching up the function parameters (written before the ->)\\nand the return types (written after the ->). Type matching is order-agnostic,\\nand allows items to be left out of the query, but items that are present in the\\nquery must be present in the function for it to match. The self parameter is\\ntreated the same as any other parameter, and Self is resolved to the\\nunderlying type’s name. Function signature searches can query generics, wrapped in angle brackets, and\\ntraits will be normalized like types in the search engine if no type parameters\\nmatch them. For example, a function with the signature fn my_function<I: Iterator<Item=u32>>(input: I) -> usize\\ncan be matched with the following queries: Iterator<Item=u32> -> usize Iterator<u32> -> usize (you can leave out the Item= part) Iterator -> usize (you can leave out iterator’s generic entirely) T -> usize (you can match with a generic parameter) Each of the above queries is progressively looser, except the last one\\nwould not match dyn Iterator, since that’s not a type parameter. If a bound has multiple associated types, specifying the name allows you to\\npick which one gets matched. If no name is specified, then the query will\\nmatch of any of them. For example, #![allow(unused)] fn main() {\\npub trait MyTrait { type First; type Second;\\n} /// This function can be found using the following search queries:\\n///\\n/// MyTrait<First=u8, Second=u32> -> bool\\n/// MyTrait<Second=u32> -> bool\\n///\\n/// The following queries, however, will *not* match it:\\n///\\n/// MyTrait<First=u32> -> bool\\n/// MyTrait<u32, u32> -> bool\\n/// MyTrait<u32, First=u8> -> bool\\n/// MyTrait<u32, u8> -> bool\\npub fn my_fn(x: impl MyTrait<First=u8, Second=u32>) -> bool { true } } Function parameters are order-agnostic, but sensitive to nesting\\nand number of matches. For example, a function with the signature fn read_all(&mut self: impl Read) -> Result<Vec<u8>, Error>\\nwill match these queries: &mut Read -> Result<Vec<u8>, Error> Read -> Result<Vec<u8>, Error> Read -> Result<Vec<u8>> Read -> Vec<u8> But it does not match Result<Vec, u8> or Result<u8<Vec>>,\\nbecause those are nested incorrectly, and it does not match Result<Error, Vec<u8>> or Result<Error>, because those are\\nin the wrong order. It also does not match Read -> u8, because\\nonly certain generic wrapper types can be left out, and Vec isn’t\\none of them. To search for a function that accepts a function as a parameter,\\nlike Iterator::all, wrap the nested signature in parenthesis,\\nas in Iterator<T>, (T -> bool) -> bool.\\nYou can also search for a specific closure trait,\\nsuch as Iterator<T>, (FnMut(T) -> bool) -> bool,\\nbut you need to know which one you want.","breadcrumbs":"How to read rustdoc output » Search » How type-based search works","id":"63","title":"How type-based search works"},"64":{"body":"References Box Rc Arc Option Result From Into Future","breadcrumbs":"How to read rustdoc output » Search » Wrappers that can be omitted","id":"64","title":"Wrappers that can be omitted"},"65":{"body":"Shorthand Explicit names & primitive:reference &T primitive:reference<T> &mut primitive:reference<keyword:mut> &mut T primitive:reference<keyword:mut, T> [] primitive:slice and/or primitive:array [T] primitive:slice<T> and/or primitive:array<T> () primitive:unit and/or primitive:tuple (T) T (T,) primitive:tuple<T> ! primitive:never (T, U -> V, W) fn(T, U) -> (V, W), Fn, FnMut, and FnOnce When searching for [], Rustdoc will return search results with either slices\\nor arrays. If you know which one you want, you can force it to return results\\nfor primitive:slice or primitive:array using the explicit name syntax.\\nEmpty square brackets, [], will match any slice or array regardless of what\\nit contains, or an item type can be provided, such as [u8] or [T], to\\nexplicitly find functions that operate on byte slices or generic slices,\\nrespectively. A single type expression wrapped in parens is the same as that type expression,\\nsince parens act as the grouping operator. If they’re empty, though, they will\\nmatch both unit and tuple, and if there’s more than one type (or a trailing\\nor leading comma) it is the same as primitive:tuple<...>. However, since items can be left out of the query, (T) will still return\\nresults for types that match tuples, even though it also matches the type on\\nits own. That is, (u32) matches (u32,) for the exact same reason that it\\nalso matches Result<u32, Error>. The -> operator has lower precedence than comma. If it’s not wrapped\\nin brackets, it delimits the return value for the function being searched for.\\nTo search for functions that take functions as parameters, use parenthesis.","breadcrumbs":"How to read rustdoc output » Search » Primitives with Special Syntax","id":"65","title":"Primitives with Special Syntax"},"66":{"body":"Type-based search is still a buggy, experimental, work-in-progress feature.\\nMost of these limitations should be addressed in future version of Rustdoc. There’s no way to write trait constraints on generic parameters.\\nYou can name traits directly, and if there’s a type parameter\\nwith that bound, it’ll match, but option<T> -> T where T: Default\\ncannot be precisely searched for (use option<Default> -> Default). Supertraits, type aliases, and Deref are all ignored. Search mostly\\noperates on type signatures as written, and not as they are\\nrepresented within the compiler. Type parameters match type parameters, such that Option<A> matches Option<T>, but never match concrete types in function signatures.\\nA trait named as if it were a type, such as Option<Read>, will match\\na type parameter constrained by that trait, such as Option<T> where T: Read, as well as matching dyn Trait and impl Trait. impl Trait in argument position is treated exactly like a type\\nparameter, but in return position it will not match type parameters. Any type named in a complex type-based search will be assumed to be a\\ntype parameter if nothing matching the name exactly is found. If you\\nwant to force a type parameter, write generic:T and it will be used\\nas a type parameter even if a matching name is found. If you know\\nthat you don’t want a type parameter, you can force it to match\\nsomething else by giving it a different prefix like struct:T. Searching for lifetimes is not supported. It’s impossible to search based on the length of an array.","breadcrumbs":"How to read rustdoc output » Search » Limitations and quirks of type-based search","id":"66","title":"Limitations and quirks of type-based search"},"67":{"body":"Names in the search interface can be prefixed with an item type followed by a\\ncolon (such as mod:) to restrict the results to just that kind of item. Also,\\nsearching for println! will search for a macro named println, just like\\nsearching for macro:println does. The complete list of available filters is\\ngiven under the ? Help area, and in the detailed syntax below. Item filters can be used in both name-based and type signature-based searches.","breadcrumbs":"How to read rustdoc output » Search » Item filtering","id":"67","title":"Item filtering"},"68":{"body":"ident = *(ALPHA / DIGIT / \\"_\\")\\npath = ident *(DOUBLE-COLON ident) [BANG]\\nslice-like = OPEN-SQUARE-BRACKET [ nonempty-arg-list ] CLOSE-SQUARE-BRACKET\\ntuple-like = OPEN-PAREN [ nonempty-arg-list ] CLOSE-PAREN\\nborrow-ref = AMP *WS [MUT] *WS [arg]\\narg = [type-filter *WS COLON *WS] (path [generics] / slice-like / tuple-like / borrow-ref)\\ntype-sep = COMMA/WS *(COMMA/WS)\\nnonempty-arg-list = *(type-sep) arg *(type-sep arg) *(type-sep) [ return-args ]\\ngeneric-arg-list = *(type-sep) arg [ EQUAL arg ] *(type-sep arg [ EQUAL arg ]) *(type-sep)\\nnormal-generics = OPEN-ANGLE-BRACKET [ generic-arg-list ] *(type-sep) CLOSE-ANGLE-BRACKET\\nfn-like-generics = OPEN-PAREN [ nonempty-arg-list ] CLOSE-PAREN [ RETURN-ARROW arg ]\\ngenerics = normal-generics / fn-like-generics\\nreturn-args = RETURN-ARROW *(type-sep) nonempty-arg-list exact-search = [type-filter *WS COLON] [ RETURN-ARROW ] *WS QUOTE ident QUOTE [ generics ]\\ntype-search = [ nonempty-arg-list ] query = *WS (exact-search / type-search) *WS type-filter = ( \\"mod\\" / \\"externcrate\\" / \\"import\\" / \\"struct\\" / \\"enum\\" / \\"fn\\" / \\"type\\" / \\"static\\" / \\"trait\\" / \\"impl\\" / \\"tymethod\\" / \\"method\\" / \\"structfield\\" / \\"variant\\" / \\"macro\\" / \\"primitive\\" / \\"associatedtype\\" / \\"constant\\" / \\"associatedconstant\\" / \\"union\\" / \\"foreigntype\\" / \\"keyword\\" / \\"existential\\" / \\"attr\\" / \\"derive\\" / \\"traitalias\\" / \\"generic\\") OPEN-ANGLE-BRACKET = \\"<\\"\\nCLOSE-ANGLE-BRACKET = \\">\\"\\nOPEN-SQUARE-BRACKET = \\"[\\"\\nCLOSE-SQUARE-BRACKET = \\"]\\"\\nOPEN-PAREN = \\"(\\"\\nCLOSE-PAREN = \\")\\"\\nCOLON = \\":\\"\\nDOUBLE-COLON = \\"::\\"\\nQUOTE = %x22\\nCOMMA = \\",\\"\\nRETURN-ARROW = \\"->\\"\\nEQUAL = \\"=\\"\\nBANG = \\"!\\"\\nAMP = \\"&\\"\\nMUT = \\"mut\\" ALPHA = %x41-5A / %x61-7A ; A-Z / a-z\\nDIGIT = %x30-39\\nWS = %x09 / \\" \\"","breadcrumbs":"How to read rustdoc output » Search » Search query syntax","id":"68","title":"Search query syntax"},"69":{"body":"Good documentation is not natural. There are opposing goals that make writing\\ngood documentation difficult. It requires expertise in the subject but also\\nwriting to a novice perspective. Documentation therefore often glazes over\\nimplementation detail, or leaves readers with unanswered questions. There are a few tenets to Rust documentation that can help guide anyone through\\nthe process of documenting libraries so that everyone has an ample opportunity\\nto use the code. This chapter covers not only how to write documentation but specifically\\nhow to write good documentation. It is important to be as clear\\nas you can, and as complete as possible. As a rule of thumb: the more\\ndocumentation you write for your crate the better. If an item is public\\nthen it should be documented.","breadcrumbs":"How to write documentation » How to write documentation","id":"69","title":"How to write documentation"},"7":{"body":"Here’s the list of arguments you can pass to rustdoc:","breadcrumbs":"Command-line arguments » Command-line arguments","id":"7","title":"Command-line arguments"},"70":{"body":"Documenting a crate should begin with front-page documentation. As an\\nexample, the hashbrown crate level documentation summarizes the role of\\nthe crate, provides links to explain technical details, and explains why you\\nwould want to use the crate. After introducing the crate, it is important that the front-page gives\\nan example of how to use the crate in a real world setting. Stick to the\\nlibrary’s role in the example, but do so without shortcuts to benefit users who\\nmay copy and paste the example to get started. futures uses inline comments to explain line by line\\nthe complexities of using a Future, because a person’s first exposure to\\nrust’s Future may be this example. The backtrace documentation walks through the whole process, explaining\\nchanges made to the Cargo.toml file, passing command line arguments to the\\ncompiler, and shows a quick example of backtrace in the wild. Finally, the front-page can eventually become a comprehensive reference\\nhow to use a crate, like regex. In this front page, all\\nrequirements are outlined, the edge cases shown, and practical examples\\nprovided. The front page goes on to show how to use regular expressions\\nthen concludes with crate features. Don’t worry about comparing your crate, which is just beginning, to other more\\ndeveloped crates. To get the documentation to something more polished, start\\nincrementally and put in an introduction, example, and features. Rome was not\\nbuilt in a day! The first lines within the lib.rs will compose the front-page, and they\\nuse a different convention than the rest of the rustdocs. Lines should\\nstart with //! which indicate module-level or crate-level documentation.\\nHere’s a quick example of the difference: #![allow(unused)] fn main() {\\n//! Fast and easy queue abstraction.\\n//!\\n//! Provides an abstraction over a queue. When the abstraction is used\\n//! there are these advantages:\\n//! - Fast\\n//! - [`Easy`]\\n//!\\n//! [`Easy`]: http://thatwaseasy.example.com /// This module makes it easy.\\npub mod easy { /// Use the abstraction function to do this specific thing. pub fn abstraction() {} } } Ideally, this first line of documentation is a sentence without highly\\ntechnical details, but with a good description of where this crate fits\\nwithin the rust ecosystem. Users should know whether this crate meets their use\\ncase after reading this line.","breadcrumbs":"How to write documentation » Getting Started","id":"70","title":"Getting Started"},"71":{"body":"Whether it is modules, structs, functions, or macros: the public\\nAPI of all code should have documentation. Rarely does anyone\\ncomplain about too much documentation! It is recommended that each item’s documentation follows this basic structure: [short sentence explaining what it is] [more detailed explanation] [at least one code example that users can copy/paste to try it] [even more advanced explanations if necessary] This basic structure should be straightforward to follow when writing your\\ndocumentation; while you might think that a code example is trivial,\\nthe examples are really important because they can help users understand\\nwhat an item is, how it is used, and for what purpose it exists. Let’s see an example coming from the standard library by taking a look at the std::env::args() function: Returns the arguments which this program was started with (normally passed\\nvia the command line). The first element is traditionally the path of the executable, but it can be\\nset to arbitrary text, and may not even exist. This means this property should\\nnot be relied upon for security purposes. On Unix systems shell usually expands unquoted arguments with glob patterns\\n(such as `*` and `?`). On Windows this is not done, and such arguments are\\npassed as-is. # Panics The returned iterator will panic during iteration if any argument to the\\nprocess is not valid unicode. If this is not desired,\\nuse the [`args_os`] function instead. # Examples ```\\nuse std::env; // Prints each argument on a separate line\\nfor argument in env::args() { println!(\\"{argument}\\");\\n}\\n``` [`args_os`]: ./fn.args_os.html Everything before the first empty line will be reused to describe the component\\nin searches and module overviews. For example, the function std::env::args()\\nabove will be shown on the std::env module documentation. It is good\\npractice to keep the summary to one line: concise writing is a goal of good\\ndocumentation. Because the type system does a good job of defining what types a function\\npasses and returns, there is no benefit of explicitly writing it\\ninto the documentation, especially since rustdoc adds hyper links to all types in the function signature. In the example above, a ‘Panics’ section explains when the code might abruptly exit,\\nwhich can help the reader prevent reaching a panic. A panic section is recommended\\nevery time edge cases in your code can be reached if known. As you can see, it follows the structure detailed above: it starts with a short\\nsentence explaining what the functions does, then it provides more information\\nand finally provides a code example.","breadcrumbs":"How to write documentation » Documenting components","id":"71","title":"Documenting components"},"72":{"body":"rustdoc uses the CommonMark Markdown specification. You might be\\ninterested in taking a look at their website to see what’s possible: CommonMark quick reference current spec In addition to the standard CommonMark syntax, rustdoc supports several\\nextensions:","breadcrumbs":"How to write documentation » Markdown","id":"72","title":"Markdown"},"73":{"body":"Text may be rendered with a horizontal line through the center by wrapping the\\ntext with one or two tilde characters on each side: An example of ~~strikethrough text~~. You can also use ~single tildes~. This example will render as: An example of strikethrough text. You can also use single tildes. This follows the GitHub Strikethrough extension.","breadcrumbs":"How to write documentation » Strikethrough","id":"73","title":"Strikethrough"},"74":{"body":"A footnote generates a small numbered link in the text which when clicked\\ntakes the reader to the footnote text at the bottom of the item. The footnote\\nlabel is written similarly to a link reference with a caret at the front. The\\nfootnote text is written like a link reference definition, with the text\\nfollowing the label. Example: This is an example of a footnote[^note]. [^note]: This text is the contents of the footnote, which will be rendered towards the bottom. This example will render as: This is an example of a footnote 1. The footnotes are automatically numbered based on the order the footnotes are\\nwritten.","breadcrumbs":"How to write documentation » Footnotes","id":"74","title":"Footnotes"},"75":{"body":"Tables can be written using pipes and dashes to draw the rows and columns of\\nthe table. These will be translated to HTML table matching the shape. Example: | Header1 | Header2 |\\n|---------|---------|\\n| abc | def | This example will render similarly to this: Header1 Header2 abc def See the specification for the GitHub Tables extension for more\\ndetails on the exact syntax supported.","breadcrumbs":"How to write documentation » Tables","id":"75","title":"Tables"},"76":{"body":"Task lists can be used as a checklist of items that have been completed.\\nExample: - [x] Complete task\\n- [ ] Incomplete task This will render as: Complete task Incomplete task See the specification for the task list extension for more details.","breadcrumbs":"How to write documentation » Task lists","id":"76","title":"Task lists"},"77":{"body":"Some ASCII punctuation sequences will be automatically turned into fancy Unicode\\ncharacters: ASCII sequence Unicode -- – --- — ... … \\" “ or ”, depending on context \' ‘ or ’, depending on context So, no need to manually enter those Unicode characters!","breadcrumbs":"How to write documentation » Smart punctuation","id":"77","title":"Smart punctuation"},"78":{"body":"If you want to make a warning or similar note stand out in the documentation,\\nyou can wrap it like this: /// documentation\\n///\\n/// <div class=\\"warning\\">A big warning!</div>\\n///\\n/// more documentation Please note that if you want to put markdown in the HTML tag and for it to\\nbe interpreted as such, you need to have an empty line between the HTML tags\\nand your markdown content. For example if you want to use a link: /// documentation\\n///\\n/// <div class=\\"warning\\">\\n///\\n/// Go to [this link](https://rust-lang.org)!\\n///\\n/// </div>\\n///\\n/// more documentation This text is the contents of the footnote, which will be rendered\\ntowards the bottom. ↩","breadcrumbs":"How to write documentation » Adding a warning block","id":"78","title":"Adding a warning block"},"79":{"body":"It is easy to say everything must be documented in a project and often times\\nthat is correct, but how can we get there, and are there things that don’t\\nbelong? At the top of the src/lib.rs or main.rs file in your binary project, include\\nthe following attribute: #![allow(unused)]\\n#![warn(missing_docs)] fn main() { } Now run cargo doc and examine the output. Here’s a sample: Documenting docdemo v0.1.0 (/Users/username/docdemo)\\nwarning: missing documentation for the crate --> src/main.rs:1:1 |\\n1 | / #![warn(missing_docs)]\\n2 | |\\n3 | | fn main() {\\n4 | | println!(\\"Hello, world!\\");\\n5 | | } | |_^ |\\nnote: the lint level is defined here --> src/main.rs:1:9 |\\n1 | #![warn(missing_docs)] | ^^^^^^^^^^^^ warning: 1 warning emitted Finished dev [unoptimized + debuginfo] target(s) in 2.96s As a library author, adding the lint #![deny(missing_docs)] is a great way to\\nensure the project does not drift away from being documented well, and #![warn(missing_docs)] is a good way to move towards comprehensive\\ndocumentation. There are more lints in the upcoming chapter Lints.","breadcrumbs":"How to write documentation » What to include (and exclude) » What to include (and exclude)","id":"79","title":"What to include (and exclude)"},"8":{"body":"Using this flag looks like this: $ rustdoc -h\\n$ rustdoc --help This will show rustdoc’s built-in help, which largely consists of\\na list of possible command-line flags. Some of rustdoc’s flags are unstable; this page only shows stable\\noptions, --help will show them all.","breadcrumbs":"Command-line arguments » -h/ --help: help","id":"8","title":"-h/ --help: help"},"80":{"body":"Of course this is contrived to be simple, but part of the power of documentation\\nis showing code that is easy to follow, rather than being realistic. Docs often\\ntake shortcuts with error handling because examples can become complicated to\\nfollow with all the necessary set up required for a simple example. Async is a good example of this. In order to execute an async example, an\\nexecutor needs to be available. Examples will often shortcut this, and leave\\nusers to figure out how to put the async code into their own runtime. It is preferred that unwrap() not be used inside an example, and some of the\\nerror handling components be hidden if they make the example too difficult to\\nfollow. /// Example\\n/// ```rust\\n/// let fourtytwo = \\"42\\".parse::<u32>()?;\\n/// println!(\\"{} + 10 = {}\\", fourtytwo, fourtytwo+10);\\n/// ``` When rustdoc wraps that in a main function, it will fail to compile because the ParseIntError trait is not implemented. In order to help both your audience\\nand your test suite, this example needs some additional code: /// Example\\n/// ```rust\\n/// # fn main() -> Result<(), std::num::ParseIntError> {\\n/// let fortytwo = \\"42\\".parse::<u32>()?;\\n/// println!(\\"{} + 10 = {}\\", fortytwo, fortytwo+10);\\n/// # Ok(())\\n/// # }\\n/// ``` The example is the same on the doc page, but has that extra information\\navailable to anyone trying to use your crate. More about tests in the\\nupcoming Documentation tests chapter.","breadcrumbs":"How to write documentation » What to include (and exclude) » Examples","id":"80","title":"Examples"},"81":{"body":"Certain parts of your public interface may be included by default in the output\\nof rustdoc. The attribute #[doc(hidden)] can hide implementation details\\nto encourage idiomatic use of the crate. For example, an internal macro! that makes the crate easier to implement can\\nbecome a footgun for users when it appears in the public documentation. An\\ninternal Error type may exist, and impl details should be hidden, as\\ndetailed in the API Guidelines.","breadcrumbs":"How to write documentation » What to include (and exclude) » What to Exclude","id":"81","title":"What to Exclude"},"82":{"body":"It is possible to pass a custom css file to rustdoc and style the\\ndocumentation. rustdoc --extend-css custom.css src/lib.rs A good example of using this feature to create a dark theme is documented on\\nthis blog. Just remember, dark theme is already included in the rustdoc output\\nby clicking on the gear icon in the upper right. Adding additional options to the\\nthemes are as easy as creating a custom theme .css file and using the following\\nsyntax: rustdoc --theme awesome.css src/lib.rs Here is an example of a new theme, Ayu.","breadcrumbs":"How to write documentation » What to include (and exclude) » Customizing the output","id":"82","title":"Customizing the output"},"83":{"body":"The #[doc] attribute lets you control various aspects of how rustdoc does\\nits job. The most basic function of #[doc] is to handle the actual documentation\\ntext. That is, /// is syntax sugar for #[doc] (as is //! for #![doc]).\\nThis means that these two are the same: #![allow(unused)] fn main() {\\n/// This is a doc comment.\\n#[doc = r\\" This is a doc comment.\\"] fn f() {} } (Note the leading space and the raw string literal in the attribute version.) In most cases, /// is easier to use than #[doc]. One case where the latter is easier is\\nwhen generating documentation in macros; the collapse-docs pass will combine multiple #[doc] attributes into a single doc comment, letting you generate code like this: #![allow(unused)] fn main() {\\n#[doc = \\"This is\\"]\\n#[doc = \\" a \\"]\\n#[doc = \\"doc comment\\"] fn f() {} } Which can feel more flexible. Note that this would generate this: #![allow(unused)] fn main() {\\n#[doc = \\"This is\\\\n a \\\\ndoc comment\\"] fn f() {} } but given that docs are rendered via Markdown, it will remove these newlines. Another use case is for including external files as documentation: #![allow(unused)] fn main() {\\n#[doc = include_str!(\\"../../README.md\\")] fn f() {} } The doc attribute has more options though! These don’t involve the text of\\nthe output, but instead, various aspects of the presentation of the output.\\nWe’ve split them into two kinds below: attributes that are useful at the\\ncrate level, and ones that are useful at the item level.","breadcrumbs":"How to write documentation » The #[doc] attribute » The #[doc] attribute","id":"83","title":"The #[doc] attribute"},"84":{"body":"These options control how the docs look at a crate level.","breadcrumbs":"How to write documentation » The #[doc] attribute » At the crate level","id":"84","title":"At the crate level"},"85":{"body":"This form of the doc attribute lets you control the favicon of your docs. #![allow(unused)]\\n#![doc(html_favicon_url = \\"https://example.com/favicon.ico\\")] fn main() { } This will put <link rel=\\"icon\\" href=\\"{}\\"> into your docs, where\\nthe string for the attribute goes into the {}. If you don’t use this attribute, a default favicon will be used.","breadcrumbs":"How to write documentation » The #[doc] attribute » html_favicon_url","id":"85","title":"html_favicon_url"},"86":{"body":"This form of the doc attribute lets you control the logo in the upper\\nleft hand side of the docs. #![allow(unused)]\\n#![doc(html_logo_url = \\"https://example.com/logo.jpg\\")] fn main() { } This will put <a href=\'../index.html\'><img src=\'{}\' alt=\'logo\' width=\'100\'></a> into\\nyour docs, where the string for the attribute goes into the {}. If you don’t use this attribute, there will be no logo.","breadcrumbs":"How to write documentation » The #[doc] attribute » html_logo_url","id":"86","title":"html_logo_url"},"87":{"body":"This form of the doc attribute lets you control where the “run” buttons\\non your documentation examples make requests to. #![allow(unused)]\\n#![doc(html_playground_url = \\"https://playground.example.com/\\")] fn main() { } Now, when you press “run”, the button will make a request to this domain. The request\\nURL will contain 3 query parameters: code for the code in the documentation version for the Rust channel, e.g. nightly, which is decided by whether code contain unstable features edition for the Rust edition, e.g. 2024 If you don’t use this attribute, there will be no run buttons.","breadcrumbs":"How to write documentation » The #[doc] attribute » html_playground_url","id":"87","title":"html_playground_url"},"88":{"body":"This form of the doc attribute is mostly only useful for the standard library;\\nWhen a feature is unstable, an issue number for tracking the feature must be\\ngiven. rustdoc uses this number, plus the base URL given here, to link to\\nthe tracking issue. #![allow(unused)]\\n#![doc(issue_tracker_base_url = \\"https://github.com/rust-lang/rust/issues/\\")] fn main() { }","breadcrumbs":"How to write documentation » The #[doc] attribute » issue_tracker_base_url","id":"88","title":"issue_tracker_base_url"},"89":{"body":"The #[doc(html_root_url = \\"…\\")] attribute value indicates the URL for\\ngenerating links to external crates. When rustdoc needs to generate a link to\\nan item in an external crate, it will first check if the extern crate has been\\ndocumented locally on-disk, and if so link directly to it. Failing that, it\\nwill use the URL given by the --extern-html-root-url command-line flag if\\navailable. If that is not available, then it will use the html_root_url\\nvalue in the extern crate if it is available. If that is not available, then\\nthe extern items will not be linked. #![allow(unused)]\\n#![doc(html_root_url = \\"https://docs.rs/serde/1.0\\")] fn main() { }","breadcrumbs":"How to write documentation » The #[doc] attribute » html_root_url","id":"89","title":"html_root_url"},"9":{"body":"Using this flag looks like this: $ rustdoc -V\\n$ rustdoc --version This will show rustdoc’s version, which will look something\\nlike this: rustdoc 1.17.0 (56124baa9 2017-04-24)","breadcrumbs":"Command-line arguments » -V/ --version: version information","id":"9","title":"-V/ --version: version information"},"90":{"body":"By default, rustdoc will include the source code of your program, with links\\nto it in the docs. But if you include this: #![allow(unused)]\\n#![doc(html_no_source)] fn main() { } it will not.","breadcrumbs":"How to write documentation » The #[doc] attribute » html_no_source","id":"90","title":"html_no_source"},"91":{"body":"By default, rustdoc will automatically add a line with extern crate my_crate; into each doctest.\\nBut if you include this: #![allow(unused)]\\n#![doc(test(no_crate_inject))] fn main() { } it will not.","breadcrumbs":"How to write documentation » The #[doc] attribute » test(no_crate_inject)","id":"91","title":"test(no_crate_inject)"},"92":{"body":"These forms of the #[doc] attribute are used on individual items, to control how\\nthey are documented.","breadcrumbs":"How to write documentation » The #[doc] attribute » At the item level","id":"92","title":"At the item level"},"93":{"body":"These attributes are used on use statements, and control where the documentation shows\\nup. For example, consider this Rust code: pub use bar::Bar; /// bar docs\\npub mod bar { /// the docs for Bar pub struct Bar;\\n} fn main() {} The documentation will generate a “Re-exports” section, and say pub use bar::Bar;, where Bar is a link to its page. If we change the use line like this: #[doc(inline)]\\npub use bar::Bar; pub mod bar { pub struct Bar; } fn main() {} Instead, Bar will appear in a Structs section, just like Bar was defined at the\\ntop level, rather than pub use’d. Let’s change our original example, by making bar private: pub use bar::Bar; /// bar docs\\nmod bar { /// the docs for Bar pub struct Bar;\\n} fn main() {} Here, because bar is not public, bar wouldn’t have its own page, so there’s nowhere\\nto link to. rustdoc will inline these definitions, and so we end up in the same case\\nas the #[doc(inline)] above; Bar is in a Structs section, as if it were defined at\\nthe top level. If we add the no_inline form of the attribute: #[doc(no_inline)]\\npub use bar::Bar; /// bar docs\\nmod bar { /// the docs for Bar pub struct Bar;\\n} fn main() {} Now we’ll have a Re-exports line, and Bar will not link to anywhere. One special case: In Rust 2018 and later, if you pub use one of your dependencies, rustdoc will\\nnot eagerly inline it as a module unless you add #[doc(inline)]. If you want to know more about inlining rules, take a look at the re-exports chapter.","breadcrumbs":"How to write documentation » The #[doc] attribute » inline and no_inline","id":"93","title":"inline and no_inline"},"94":{"body":"Any item annotated with #[doc(hidden)] will not appear in the documentation,\\nunless the --document-hidden-items flag is used. You can find more information in the re-exports chapter.","breadcrumbs":"How to write documentation » The #[doc] attribute » hidden","id":"94","title":"hidden"},"95":{"body":"This attribute adds an alias in the search index. Let’s take an example: #![allow(unused)] fn main() {\\n#[doc(alias = \\"TheAlias\\")]\\npub struct SomeType; } So now, if you enter “TheAlias” in the search, it’ll display SomeType.\\nOf course, if you enter SomeType it’ll return SomeType as expected! FFI example This doc attribute is especially useful when writing bindings for a C library.\\nFor example, let’s say we have a C function that looks like this: int lib_name_do_something(Obj *obj); It takes a pointer to an Obj type and returns an integer. In Rust, it might\\nbe written like this: pub struct Obj { inner: *mut ffi::Obj,\\n} impl Obj { pub fn do_something(&mut self) -> i32 { unsafe { ffi::lib_name_do_something(self.inner) } }\\n} The function has been turned into a method to make it more convenient to use.\\nHowever, if you want to look for the Rust equivalent of lib_name_do_something,\\nyou have no way to do so. To get around this limitation, we just add #[doc(alias = \\"lib_name_do_something\\")]\\non the do_something method and then it’s all good!\\nUsers can now look for lib_name_do_something in our crate directly and find Obj::do_something.","breadcrumbs":"How to write documentation » The #[doc] attribute » alias","id":"95","title":"alias"},"96":{"body":"This form of the doc attribute allows you to add arbitrary attributes to all your doctests. For\\nexample, if you want your doctests to fail if they have dead code, you could add this: #![allow(unused)]\\n#![doc(test(attr(deny(dead_code))))] fn main() {\\nmod my_mod { #![doc(test(attr(allow(dead_code))))] // but allow `dead_code` for this module\\n} } test(attr(..)) attributes are appended to the parent module’s, they do not replace the current\\nlist of attributes. In the previous example, both attributes would be present: #![allow(unused)] fn main() {\\n// For every doctest in `my_mod` #![deny(dead_code)] // from the crate-root\\n#![allow(dead_code)] // from `my_mod` }","breadcrumbs":"How to write documentation » The #[doc] attribute » test(attr(...))","id":"96","title":"test(attr(...))"},"97":{"body":"Let’s start by explaining what are re-exports. To do so, we will use an example where we are\\nwriting a library (named lib) with some types dispatched in sub-modules: #![allow(unused)] fn main() {\\npub mod sub_module1 { pub struct Foo;\\n}\\npub mod sub_module2 { pub struct AnotherFoo;\\n} } Users can import them like this: use lib::sub_module1::Foo;\\nuse lib::sub_module2::AnotherFoo; But what if you want the types to be available directly at the crate root or if we don’t want the\\nmodules to be visible for users? That’s where re-exports come in: // `sub_module1` and `sub_module2` are not visible outside.\\nmod sub_module1 { pub struct Foo;\\n}\\nmod sub_module2 { pub struct AnotherFoo;\\n}\\n// We re-export both types:\\npub use crate::sub_module1::Foo;\\npub use crate::sub_module2::AnotherFoo; And now users will be able to do: use lib::{Foo, AnotherFoo}; And since both sub_module1 and sub_module2 are private, users won’t be able to import them. Now what’s interesting is that the generated documentation for this crate will show both Foo and AnotherFoo directly at the crate root, meaning they have been inlined. There are a few rules to\\nknow whether or not a re-exported item will be inlined.","breadcrumbs":"How to write documentation » Re-exports » Re-exports","id":"97","title":"Re-exports"},"98":{"body":"If a public item comes from a private module, it will be inlined: mod private_module { pub struct Public;\\n}\\npub mod public_mod { // `Public` will inlined here since `private_module` is private. pub use super::private_module::Public;\\n}\\n// `Public` will not be inlined here since `public_mod` is public.\\npub use self::public_mod::Public; Likewise, if an item inherits #[doc(hidden)] from any of its ancestors, it will be inlined: #[doc(hidden)]\\npub mod public_mod { pub struct Public;\\n}\\n// `Public` be inlined since its parent (`public_mod`) has `#[doc(hidden)]`.\\npub use self::public_mod::Public; If an item has #[doc(hidden)], it won’t be inlined (nor visible in the generated documentation): // This struct won\'t be visible.\\n#[doc(hidden)]\\npub struct Hidden; // This re-export won\'t be visible.\\npub use self::Hidden as InlinedHidden; However, if you still want the re-export itself to be visible, you can add the #[doc(inline)]\\nattribute on it: // This struct won\'t be visible.\\n#[doc(hidden)]\\npub struct Hidden; #[doc(inline)]\\npub use self::Hidden as InlinedHidden; In this case, you will have pub use self::Hidden as InlinedHidden; in the generated documentation\\nbut no link to the Hidden item. So back to #[doc(hidden)]: if you have multiple re-exports and some of them have #[doc(hidden)], then these ones (and only these) won’t appear in the documentation: mod private_mod { /// First pub struct InPrivate;\\n} /// Second\\n#[doc(hidden)]\\npub use self::private_mod::InPrivate as Hidden;\\n/// Third\\npub use self::Hidden as Visible; In this case, InPrivate will be inlined as Visible. However, its documentation will be First Third and not First Second Third because the re-export with Second as documentation has #[doc(hidden)], therefore, all its attributes are ignored.","breadcrumbs":"How to write documentation » Re-exports » Inlining rules","id":"98","title":"Inlining rules"},"99":{"body":"You can use the #[doc(inline)] attribute if you want to force an item to be inlined: pub mod public_mod { pub struct Public;\\n}\\n#[doc(inline)]\\npub use self::public_mod::Public; With this code, even though public_mod::Public is public and present in the documentation, the Public type will be present both at the crate root and in the public_mod module.","breadcrumbs":"How to write documentation » Re-exports » Inlining with #[doc(inline)]","id":"99","title":"Inlining with #[doc(inline)]"}},"length":199,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{"3":{"df":1,"docs":{"185":{"tf":1.0}}},"6":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":2,"docs":{"116":{"tf":2.0},"185":{"tf":2.8284271247461903}}},"1":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"8":{".":{"0":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{".":{"0":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"9":{"8":{"1":{"df":2,"docs":{"183":{"tf":1.0},"184":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"114":{"tf":1.0}}},"df":2,"docs":{"129":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"1":{"3":{"2":{"4":{"8":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{";":{"\\\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":3,"docs":{"179":{"tf":1.0},"185":{"tf":1.0},"52":{"tf":1.0}}},"3":{"4":{"5":{"2":{"9":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"4":{"8":{"7":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"4":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"6":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"121":{"tf":2.0},"122":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"144":{"tf":2.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"185":{"tf":2.8284271247461903},"5":{"tf":1.4142135623730951},"74":{"tf":1.0},"79":{"tf":1.7320508075688772}}},"2":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"33":{"tf":1.0}}},"7":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"8":{"df":3,"docs":{"114":{"tf":1.0},"33":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"114":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"6":{"7":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"127":{"tf":1.7320508075688772},"128":{"tf":1.7320508075688772},"130":{"tf":1.0},"132":{"tf":1.4142135623730951},"159":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0}}},"3":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"9":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"3":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":10,"docs":{"106":{"tf":1.4142135623730951},"123":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.0}}},"4":{".":{"5":{"9":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"0":{"2":{"7":{"df":2,"docs":{"151":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"4":{"0":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"106":{"tf":1.4142135623730951},"109":{"tf":1.0},"114":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"175":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"5":{"4":{"7":{"6":{"5":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"5":{"df":1,"docs":{"174":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"5":{"4":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":9,"docs":{"107":{"tf":1.7320508075688772},"110":{"tf":2.6457513110645907},"114":{"tf":1.0},"118":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"135":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0}}},"6":{"df":2,"docs":{"110":{"tf":2.6457513110645907},"126":{"tf":1.0}}},"7":{"6":{"5":{"7":{"8":{"df":1,"docs":{"178":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{".":{"2":{"0":{"4":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":1,"docs":{"126":{"tf":1.0}}},"8":{"8":{"7":{"9":{"1":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"9":{"5":{"df":1,"docs":{"182":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"126":{"tf":1.0},"129":{"tf":1.0},"38":{"tf":1.0}}},"9":{"df":1,"docs":{"129":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"127":{"tf":1.0},"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"68":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"179":{"tf":1.0}}}}}}}},"a":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"133":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"b":{"c":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"143":{"tf":1.0},"144":{"tf":1.0}},"l":{"df":1,"docs":{"167":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}},"v":{"df":12,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"127":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"25":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.7320508075688772},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"180":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.0},"150":{"tf":1.0},"50":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"t":{"df":4,"docs":{"155":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"145":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"118":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"a":{"df":1,"docs":{"131":{"tf":2.23606797749979}}},"b":{"df":1,"docs":{"131":{"tf":2.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":30,"docs":{"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"121":{"tf":1.0},"125":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":1.0},"141":{"tf":1.7320508075688772},"142":{"tf":1.0},"147":{"tf":1.4142135623730951},"151":{"tf":1.0},"165":{"tf":1.4142135623730951},"178":{"tf":1.0},"181":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.4142135623730951},"191":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"105":{"tf":1.4142135623730951},"116":{"tf":1.0},"132":{"tf":1.4142135623730951},"151":{"tf":1.0},"157":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":15,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.0},"179":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.0},"25":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"138":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"110":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"132":{"tf":1.0},"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"167":{"tf":1.0},"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"i":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"187":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}}},"i":{"a":{"df":3,"docs":{"141":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"s":{"(":{"df":1,"docs":{"141":{"tf":1.0}}},"df":4,"docs":{"141":{"tf":1.4142135623730951},"148":{"tf":1.0},"45":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.4142135623730951}}}},"k":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"178":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"179":{"tf":1.0},"96":{"tf":1.0}},"e":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":50,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":2.8284271247461903},"111":{"tf":1.4142135623730951},"114":{"tf":2.6457513110645907},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"d":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"#":{"!":{"[":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":28,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"131":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.4142135623730951},"182":{"tf":1.0},"187":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"63":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"101":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"118":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"167":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"144":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.0},"68":{"tf":2.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"157":{"tf":1.7320508075688772},"160":{"tf":1.0},"94":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"168":{"tf":1.0},"187":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":2.0}}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"69":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"103":{"tf":1.0},"111":{"tf":1.0},"139":{"tf":1.0},"173":{"tf":1.0},"179":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"188":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"139":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"118":{"tf":1.0},"150":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":16,"docs":{"11":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"164":{"tf":1.7320508075688772},"187":{"tf":1.0},"189":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"142":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"139":{"tf":1.4142135623730951},"150":{"tf":1.0},"168":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"23":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"118":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"147":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0}}}}}},"g":{"df":7,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"185":{"tf":2.449489742783178},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"68":{"tf":4.358898943540674}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"18":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.7320508075688772},"191":{"tf":1.0},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.449489742783178}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"102":{"tf":1.0},"111":{"tf":1.0},"174":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"111":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0},"68":{"tf":2.0}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":2,"docs":{"141":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"114":{"tf":1.0},"126":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"1":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"108":{"tf":1.0},"117":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"108":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"103":{"tf":1.0},"148":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"107":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.0},"66":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"103":{"tf":1.0},"80":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"152":{"tf":1.0},"192":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}},"r":{"df":1,"docs":{"68":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":47,"docs":{"100":{"tf":1.0},"101":{"tf":2.6457513110645907},"109":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.7320508075688772},"141":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"149":{"tf":1.7320508075688772},"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":2.0},"155":{"tf":1.0},"163":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"187":{"tf":2.0},"188":{"tf":2.23606797749979},"189":{"tf":2.8284271247461903},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":2.23606797749979},"79":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":2.449489742783178},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":2.23606797749979},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"133":{"tf":1.0},"42":{"tf":1.0},"79":{"tf":1.0}}}}},"o":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":1.0}}}}}}},"df":2,"docs":{"189":{"tf":2.0},"190":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"104":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"142":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":21,"docs":{"104":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"139":{"tf":1.4142135623730951},"145":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.4142135623730951},"178":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":2.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"115":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}},"y":{"df":2,"docs":{"142":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.0}}}}},"b":{"]":{"[":{"c":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"167":{"tf":1.0},"191":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"102":{"tf":1.0},"107":{"tf":1.0},"117":{"tf":1.0},"131":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"1":{"tf":1.0},"102":{"tf":2.6457513110645907},"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"126":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.4142135623730951},"185":{"tf":2.23606797749979},"43":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"93":{"tf":4.69041575982343}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"119":{"tf":1.0},"135":{"tf":1.0},"163":{"tf":1.0},"29":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":1.4142135623730951},"74":{"tf":1.0},"88":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"71":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":3,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"131":{"tf":2.449489742783178}},"e":{"c":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"166":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":17,"docs":{"100":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"181":{"tf":1.0},"195":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"145":{"tf":1.0},"161":{"tf":2.6457513110645907},"162":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"195":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"114":{"tf":1.0},"122":{"tf":1.0},"167":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"106":{"tf":1.0},"135":{"tf":1.0},"189":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"150":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}},"w":{"df":8,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"191":{"tf":1.0},"69":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"140":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"49":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"141":{"tf":1.7320508075688772},"78":{"tf":1.0}},"x":{"df":1,"docs":{"141":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"174":{"tf":1.0},"79":{"tf":1.0}}}}},"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"107":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":2.0},"117":{"tf":3.0},"125":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"129":{"tf":2.23606797749979},"148":{"tf":1.0},"175":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}},"w":{"df":1,"docs":{"135":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"145":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}},"l":{"df":2,"docs":{"61":{"tf":1.7320508075688772},"63":{"tf":3.3166247903554}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":15,"docs":{"115":{"tf":1.0},"121":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"189":{"tf":1.0},"193":{"tf":1.4142135623730951},"59":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"165":{"tf":1.0},"31":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"153":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"113":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"131":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"142":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"115":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"168":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"183":{"tf":1.4142135623730951},"184":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.0},"139":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"175":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"154":{"tf":1.4142135623730951},"24":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"150":{"tf":1.0},"163":{"tf":1.0},"29":{"tf":1.0},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"165":{"tf":1.0},"65":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"166":{"tf":1.0},"173":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"125":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"181":{"tf":1.7320508075688772},"184":{"tf":1.0},"195":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"185":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"114":{"tf":1.0},"146":{"tf":1.0}},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"134":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":14,"docs":{"1":{"tf":2.23606797749979},"112":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":1.4142135623730951},"173":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"3":{"tf":3.0},"44":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0}},"’":{"df":2,"docs":{"135":{"tf":1.0},"137":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"101":{"tf":1.4142135623730951},"104":{"tf":2.23606797749979},"106":{"tf":1.7320508075688772},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"144":{"tf":1.0},"176":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"22":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"83":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"159":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"149":{"tf":1.0}}}}},"s":{"df":7,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"188":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":4,"docs":{"101":{"tf":1.0},"116":{"tf":2.0},"18":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"108":{"tf":1.0},"118":{"tf":1.0},"151":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":1,"docs":{"101":{"tf":2.0}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"139":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":1,"docs":{"101":{"tf":1.0}}},"c":{"df":1,"docs":{"101":{"tf":2.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"139":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"188":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":2.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"188":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"193":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":1.0},"193":{"tf":1.7320508075688772}}}}}}},"=":{"\'":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"144":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"189":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.7320508075688772},"189":{"tf":2.449489742783178},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":2.23606797749979}},"e":{"d":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":11,"docs":{"114":{"tf":1.4142135623730951},"166":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.0},"195":{"tf":1.4142135623730951},"2":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":16,"docs":{"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"163":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"129":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"137":{"tf":1.0},"16":{"tf":2.6457513110645907},"172":{"tf":2.0},"181":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":2.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"187":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"192":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"\\"":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\"":{">":{"a":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":1,"docs":{"116":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"150":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"df":0,"docs":{},"’":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":52,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"110":{"tf":2.23606797749979},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":3.4641016151377544},"116":{"tf":2.449489742783178},"117":{"tf":3.3166247903554},"119":{"tf":1.0},"125":{"tf":2.449489742783178},"127":{"tf":1.4142135623730951},"129":{"tf":2.449489742783178},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"147":{"tf":2.0},"148":{"tf":1.0},"150":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.7320508075688772},"179":{"tf":3.1622776601683795},"18":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"188":{"tf":1.0},"19":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"87":{"tf":1.7320508075688772},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":6,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"114":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"181":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"114":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"m":{"a":{"/":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":3,"docs":{"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.0}},"n":{"d":{"df":13,"docs":{"146":{"tf":1.0},"158":{"tf":2.0},"166":{"tf":1.0},"168":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"175":{"tf":1.0},"2":{"tf":1.0},"70":{"tf":1.0},"83":{"tf":2.23606797749979}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"127":{"tf":1.0},"175":{"tf":1.0},"195":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"117":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"198":{"tf":1.0},"46":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"t":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":28,"docs":{"108":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":3.3166247903554},"118":{"tf":1.4142135623730951},"119":{"tf":2.449489742783178},"139":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"149":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"165":{"tf":1.0},"168":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"183":{"tf":1.0},"185":{"tf":2.0},"188":{"tf":1.0},"191":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"147":{"tf":1.0},"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"111":{"tf":1.0},"165":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.7320508075688772}}},"x":{"df":3,"docs":{"63":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"178":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"s":{"df":2,"docs":{"48":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"132":{"tf":1.0},"165":{"tf":1.0},"179":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"195":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"113":{"tf":1.0},"139":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.4142135623730951},"191":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":1,"docs":{"188":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"187":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"111":{"tf":1.0}}}}},"i":{"d":{"df":10,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"151":{"tf":1.0},"195":{"tf":1.0},"48":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"148":{"tf":1.0},"175":{"tf":1.0},"68":{"tf":1.0}}}}},"df":2,"docs":{"104":{"tf":1.0},"62":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"115":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"179":{"tf":1.7320508075688772},"52":{"tf":1.0},"65":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"161":{"tf":2.6457513110645907},"162":{"tf":2.6457513110645907},"179":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":2.23606797749979},"28":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"80":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":19,"docs":{"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"159":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"156":{"tf":1.0},"157":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"95":{"tf":1.0}}},"t":{"df":3,"docs":{"137":{"tf":1.0},"197":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"70":{"tf":1.0}}},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"114":{"tf":1.0},"178":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"127":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.4142135623730951},"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":3.1622776601683795}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"80":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"178":{"tf":1.0}}}},"df":4,"docs":{"189":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"124":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"123":{"tf":1.0},"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"179":{"tf":1.7320508075688772}}}}}}}},"df":61,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.0},"109":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"12":{"tf":2.23606797749979},"124":{"tf":1.4142135623730951},"133":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":2.0},"14":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":2.23606797749979},"155":{"tf":1.4142135623730951},"157":{"tf":1.0},"159":{"tf":2.0},"163":{"tf":2.449489742783178},"166":{"tf":1.0},"167":{"tf":2.6457513110645907},"168":{"tf":1.7320508075688772},"169":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.7320508075688772},"175":{"tf":2.0},"176":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":2.0},"181":{"tf":2.0},"187":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.4142135623730951},"198":{"tf":1.0},"2":{"tf":2.449489742783178},"3":{"tf":1.4142135623730951},"36":{"tf":2.0},"4":{"tf":2.449489742783178},"47":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":3.605551275463989},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":2.0},"91":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}},"’":{"df":3,"docs":{"163":{"tf":1.0},"2":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.0},"166":{"tf":1.0},"25":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":9,"docs":{"0":{"tf":1.0},"116":{"tf":1.7320508075688772},"166":{"tf":1.0},"173":{"tf":1.0},"25":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"166":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"11":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"179":{"tf":1.4142135623730951},"181":{"tf":1.0},"187":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"24":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"5":{"tf":1.0},"72":{"tf":1.0},"96":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{",":{"df":0,"docs":{},"{":{".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":8,"docs":{"116":{"tf":1.7320508075688772},"142":{"tf":1.4142135623730951},"157":{"tf":1.0},"169":{"tf":1.0},"195":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"82":{"tf":1.7320508075688772}}}}}}}},"d":{"]":{"(":{"df":0,"docs":{},"e":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"34":{"tf":1.0},"51":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"118":{"tf":1.0},"159":{"tf":2.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"107":{"tf":1.0}}}},"y":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"109":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"112":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"171":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"63":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"144":{"tf":1.0},"151":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":42,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"135":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"170":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"180":{"tf":1.0},"183":{"tf":1.0},"189":{"tf":1.4142135623730951},"191":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":2.23606797749979},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.4142135623730951},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"81":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":1,"docs":{"75":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"101":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"142":{"tf":1.0},"152":{"tf":1.0},"185":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"110":{"tf":1.0},"182":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"74":{"tf":1.0},"93":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"108":{"tf":1.0},"114":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{":":{":":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"193":{"tf":1.4142135623730951},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"122":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"181":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"45":{"tf":1.0},"77":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":5,"docs":{"194":{"tf":1.0},"195":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"189":{"tf":1.4142135623730951},"190":{"tf":1.7320508075688772},"191":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":6,"docs":{"160":{"tf":1.0},"165":{"tf":1.0},"192":{"tf":1.0},"50":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"193":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"107":{"tf":1.0},"110":{"tf":1.0},"147":{"tf":1.0},"191":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"175":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"145":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"150":{"tf":2.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"104":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"108":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"151":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"r":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{".":{"d":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"159":{"tf":2.23606797749979}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"123":{"tf":1.0},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.0},"55":{"tf":1.7320508075688772},"66":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"1":{"tf":1.0},"11":{"tf":2.0},"119":{"tf":3.0},"133":{"tf":1.0},"14":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.4142135623730951},"17":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.7320508075688772},"3":{"tf":1.0}}},"y":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"164":{"tf":1.0},"171":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"104":{"tf":2.449489742783178},"111":{"tf":1.0},"121":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"174":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":16,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"188":{"tf":2.23606797749979},"189":{"tf":2.8284271247461903},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"167":{"tf":1.0}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"151":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":1,"docs":{"78":{"tf":1.7320508075688772}},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":3,"docs":{"101":{"tf":1.0},"141":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}},"s":{"(":{"\\"":{"df":0,"docs":{},"x":{"df":1,"docs":{"141":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"154":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"187":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"189":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":2.6457513110645907},"190":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"190":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":2.0}}}}}}},"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":1.7320508075688772}}}}}}},"df":5,"docs":{"187":{"tf":2.0},"188":{"tf":1.4142135623730951},"189":{"tf":3.1622776601683795},"190":{"tf":1.4142135623730951},"191":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"188":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"188":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"187":{"tf":1.4142135623730951},"188":{"tf":1.7320508075688772},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"101":{"tf":1.0},"13":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"160":{"tf":1.7320508075688772},"81":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"193":{"tf":2.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"153":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"187":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":56,"docs":{"1":{"tf":2.0},"101":{"tf":2.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"11":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.4142135623730951},"134":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.7320508075688772},"140":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"149":{"tf":1.4142135623730951},"16":{"tf":1.0},"163":{"tf":1.7320508075688772},"165":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"167":{"tf":2.23606797749979},"169":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":2.0},"178":{"tf":1.4142135623730951},"181":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.8284271247461903},"33":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":4.47213595499958},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.449489742783178},"95":{"tf":1.0},"96":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":17,"docs":{"108":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"114":{"tf":3.1622776601683795},"115":{"tf":1.7320508075688772},"118":{"tf":3.3166247903554},"139":{"tf":1.0},"147":{"tf":1.7320508075688772},"172":{"tf":1.0},"174":{"tf":2.23606797749979},"179":{"tf":3.7416573867739413},"185":{"tf":2.449489742783178},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"22":{"tf":2.0},"33":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":103,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":2.8284271247461903},"113":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":2.23606797749979},"119":{"tf":1.7320508075688772},"120":{"tf":1.0},"122":{"tf":2.6457513110645907},"123":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":2.8284271247461903},"133":{"tf":2.0},"135":{"tf":2.0},"137":{"tf":1.0},"139":{"tf":2.449489742783178},"140":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":2.0},"152":{"tf":1.7320508075688772},"153":{"tf":1.7320508075688772},"154":{"tf":1.7320508075688772},"156":{"tf":1.0},"157":{"tf":2.0},"160":{"tf":3.1622776601683795},"161":{"tf":1.0},"162":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.0},"175":{"tf":2.6457513110645907},"176":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"181":{"tf":2.0},"187":{"tf":1.7320508075688772},"188":{"tf":2.0},"189":{"tf":1.4142135623730951},"19":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0},"195":{"tf":1.4142135623730951},"197":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":2.8284271247461903},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"46":{"tf":1.0},"47":{"tf":2.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":3.1622776601683795},"70":{"tf":2.6457513110645907},"71":{"tf":2.8284271247461903},"78":{"tf":2.23606797749979},"79":{"tf":2.23606797749979},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":2.23606797749979},"99":{"tf":1.0}}}}}}}},"df":1,"docs":{"120":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"127":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.0},"168":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.0},"3":{"tf":1.0},"71":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":17,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"135":{"tf":1.0},"146":{"tf":1.0},"175":{"tf":1.0},"30":{"tf":1.0},"40":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.0}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"116":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"144":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"185":{"tf":1.0},"2":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"173":{"tf":1.0},"191":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"114":{"tf":1.0},"71":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"129":{"tf":1.0},"167":{"tf":1.0},"181":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"110":{"tf":1.4142135623730951},"117":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.4142135623730951},"185":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"159":{"tf":1.0},"70":{"tf":2.23606797749979},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"3":{"tf":1.0},"42":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"195":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}},"d":{"df":1,"docs":{"63":{"tf":1.0}},"g":{"df":3,"docs":{"117":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"114":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"133":{"tf":1.0},"179":{"tf":1.0},"33":{"tf":2.8284271247461903},"87":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"114":{"tf":1.0}}},"8":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"114":{"tf":1.0}}},"4":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"116":{"tf":1.0},"156":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"180":{"tf":1.0},"190":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"104":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"178":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"129":{"tf":1.7320508075688772},"38":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"153":{"tf":1.0},"154":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":25,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"134":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"152":{"tf":1.0},"158":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.0},"18":{"tf":1.0},"182":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":2.23606797749979},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"48":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":9,"docs":{"107":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"141":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"142":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"142":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"151":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"147":{"tf":1.0},"157":{"tf":1.0},"35":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"141":{"tf":1.0},"49":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"192":{"tf":1.0},"4":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":4,"docs":{"104":{"tf":1.0},"121":{"tf":1.7320508075688772},"175":{"tf":1.0},"68":{"tf":1.0}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":1.0},"158":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"168":{"tf":1.0},"62":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"111":{"tf":1.7320508075688772},"120":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":2.8284271247461903},"179":{"tf":1.0},"185":{"tf":1.7320508075688772},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"105":{"tf":1.0},"157":{"tf":1.0},"171":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"105":{"tf":1.4142135623730951},"144":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"188":{"tf":1.4142135623730951},"48":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"99":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"139":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"117":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"17":{"tf":1.0},"188":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":86,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":2.0},"109":{"tf":2.8284271247461903},"110":{"tf":3.0},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":2.6457513110645907},"126":{"tf":1.0},"127":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":2.449489742783178},"134":{"tf":1.7320508075688772},"135":{"tf":3.1622776601683795},"137":{"tf":2.0},"139":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"181":{"tf":3.1622776601683795},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"197":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"70":{"tf":3.0},"71":{"tf":2.8284271247461903},"73":{"tf":1.7320508075688772},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":3.4641016151377544},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"120":{"tf":1.0},"13":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"193":{"tf":1.0},"63":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"151":{"tf":1.4142135623730951},"79":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"107":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"18":{"tf":1.0},"22":{"tf":1.7320508075688772},"71":{"tf":1.0},"80":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.7320508075688772},"24":{"tf":1.0},"71":{"tf":1.4142135623730951},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"186":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"186":{"tf":1.4142135623730951},"45":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"35":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"178":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"110":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"n":{"df":2,"docs":{"110":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"132":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"105":{"tf":2.0},"175":{"tf":1.0},"193":{"tf":3.7416573867739413},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.0}},"’":{"df":1,"docs":{"193":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"113":{"tf":1.0},"65":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"118":{"tf":1.0},"149":{"tf":1.0},"31":{"tf":1.7320508075688772},"82":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"149":{"tf":1.0},"57":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":12,"docs":{"109":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"147":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"167":{"tf":2.23606797749979},"17":{"tf":2.0},"179":{"tf":1.0},"181":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":2.449489742783178},"91":{"tf":1.0}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}},"df":7,"docs":{"110":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"105":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"111":{"tf":1.0},"114":{"tf":2.0},"121":{"tf":1.0},"127":{"tf":1.0},"147":{"tf":1.4142135623730951},"185":{"tf":2.0},"80":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"138":{"tf":1.0},"167":{"tf":1.0}}},"s":{"df":6,"docs":{"113":{"tf":1.0},"179":{"tf":2.23606797749979},"187":{"tf":1.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":1,"docs":{"136":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":7,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"157":{"tf":1.4142135623730951},"83":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":35,"docs":{"114":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"137":{"tf":1.0},"138":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"145":{"tf":2.449489742783178},"146":{"tf":1.7320508075688772},"149":{"tf":1.4142135623730951},"15":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"156":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"18":{"tf":1.0},"181":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.7320508075688772},"188":{"tf":1.0},"189":{"tf":2.6457513110645907},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"42":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"82":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"=":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"188":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"157":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"117":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":6,"docs":{"101":{"tf":1.0},"135":{"tf":1.0},"150":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"97":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":10,"docs":{"104":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":2.449489742783178},"148":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":39,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"159":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"166":{"tf":1.7320508075688772},"169":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.7320508075688772},"181":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"5":{"tf":2.23606797749979},"70":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"135":{"tf":1.0},"139":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.7320508075688772}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"195":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}},"d":{"df":9,"docs":{"118":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"142":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"185":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":18,"docs":{"101":{"tf":2.0},"110":{"tf":2.0},"135":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.4142135623730951},"167":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"125":{"tf":1.0},"2":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":63,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"146":{"tf":1.0},"15":{"tf":1.7320508075688772},"158":{"tf":1.7320508075688772},"16":{"tf":2.0},"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"167":{"tf":2.6457513110645907},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.7320508075688772},"185":{"tf":1.0},"186":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"8":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":63,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.23606797749979},"105":{"tf":2.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":3.4641016151377544},"111":{"tf":3.0},"113":{"tf":1.7320508075688772},"114":{"tf":3.605551275463989},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":2.23606797749979},"122":{"tf":1.7320508075688772},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"147":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"176":{"tf":1.7320508075688772},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"83":{"tf":2.8284271247461903},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":21,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"142":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.4142135623730951},"22":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"82":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.0}}}},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"128":{"tf":1.0},"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"2":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},"3":{"df":1,"docs":{"102":{"tf":1.0}}},"4":{"df":1,"docs":{"102":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"181":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":24,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":2.6457513110645907},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":2.449489742783178},"115":{"tf":1.7320508075688772},"117":{"tf":1.7320508075688772},"121":{"tf":2.6457513110645907},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"193":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"97":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":3.0},"78":{"tf":1.0}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":7,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"143":{"tf":1.0},"168":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"148":{"tf":1.0},"193":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"188":{"tf":1.0},"41":{"tf":1.7320508075688772}}}},"df":8,"docs":{"127":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"117":{"tf":1.0},"124":{"tf":1.0},"157":{"tf":1.0},"181":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"117":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"198":{"tf":1.0},"70":{"tf":2.449489742783178},"74":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"109":{"tf":1.0},"18":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":3,"docs":{"103":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":30,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"133":{"tf":1.4142135623730951},"146":{"tf":1.0},"150":{"tf":1.4142135623730951},"181":{"tf":1.7320508075688772},"2":{"tf":2.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":3.0},"65":{"tf":2.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.6457513110645907},"80":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.4142135623730951}},"’":{"df":2,"docs":{"2":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"150":{"tf":1.0},"157":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"114":{"tf":1.0},"124":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"188":{"tf":2.23606797749979},"189":{"tf":2.449489742783178},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772}}}}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"146":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0}}}}},"df":1,"docs":{"106":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"50":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":51,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"139":{"tf":1.0},"143":{"tf":1.0},"152":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.7320508075688772},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":2.0},"18":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.7320508075688772},"186":{"tf":1.7320508075688772},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.23606797749979},"30":{"tf":2.0},"5":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":3.1622776601683795},"74":{"tf":1.0},"83":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"i":{"c":{":":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":3,"docs":{"173":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"198":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"179":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}},"n":{"df":19,"docs":{"105":{"tf":1.4142135623730951},"113":{"tf":1.0},"135":{"tf":1.7320508075688772},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"173":{"tf":1.0},"181":{"tf":1.0},"189":{"tf":1.0},"33":{"tf":1.4142135623730951},"46":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":2,"docs":{"101":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"115":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}},"df":3,"docs":{"142":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":3,"docs":{"70":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"o":{"d":{"df":12,"docs":{"104":{"tf":1.0},"169":{"tf":1.0},"191":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"189":{"tf":1.0},"196":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"173":{"tf":1.0},"65":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"147":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"124":{"tf":1.0},"198":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"198":{"tf":1.0},"81":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"128":{"tf":2.0}}},"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}},"l":{"df":4,"docs":{"111":{"tf":1.0},"159":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"110":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"176":{"tf":1.0},"187":{"tf":1.0}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}}},"df":1,"docs":{"8":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"1":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}},"p":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"155":{"tf":1.0}}}}}}},"df":19,"docs":{"114":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"144":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":18,"docs":{"110":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951}},"’":{"df":8,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"110":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"135":{"tf":1.0},"160":{"tf":2.6457513110645907},"188":{"tf":1.0},"189":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.4142135623730951},"98":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"110":{"tf":2.0},"112":{"tf":1.0},"144":{"tf":1.0},"189":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"140":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"139":{"tf":1.0},"173":{"tf":1.0},"23":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"\'":{".":{".":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"85":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":19,"docs":{"0":{"tf":1.0},"128":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"180":{"tf":1.7320508075688772},"186":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":2.0},"28":{"tf":2.0},"35":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"124":{"tf":1.0},"142":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}}}}}}},"i":{".":{"df":3,"docs":{"157":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0}}},"3":{"2":{"df":3,"docs":{"131":{"tf":1.7320508075688772},"5":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"160":{"tf":1.0},"82":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"107":{"tf":1.0},"111":{"tf":1.0}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"117":{"tf":1.0},"3":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"106":{"tf":1.0},"191":{"tf":1.0}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":3.605551275463989},"117":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"20":{"tf":1.0},"25":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"189":{"tf":1.0},"191":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":8,"docs":{"148":{"tf":1.0},"175":{"tf":1.7320508075688772},"179":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"df":15,"docs":{"103":{"tf":1.4142135623730951},"111":{"tf":1.0},"150":{"tf":2.0},"151":{"tf":1.4142135623730951},"157":{"tf":1.7320508075688772},"175":{"tf":1.0},"181":{"tf":1.0},"191":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":2.0},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"185":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"148":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":36,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.23606797749979},"13":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.7320508075688772},"137":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"181":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"79":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\\"":{".":{".":{"/":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":2.23606797749979}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":5,"docs":{"147":{"tf":1.0},"169":{"tf":2.23606797749979},"170":{"tf":1.7320508075688772},"173":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":4,"docs":{"116":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":3,"docs":{"119":{"tf":1.0},"63":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"119":{"tf":1.0},"157":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"44":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":19,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"157":{"tf":1.0},"165":{"tf":1.0},"176":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.7320508075688772},"188":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"175":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.0},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.449489742783178},"131":{"tf":1.4142135623730951},"193":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.8284271247461903},"99":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"105":{"tf":1.0},"4":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":2.8284271247461903},"37":{"tf":1.7320508075688772},"41":{"tf":2.0},"59":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"133":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"161":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":23,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"183":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"37":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"116":{"tf":2.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"124":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"168":{"tf":1.0},"181":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.0},"97":{"tf":1.0}}}}},"f":{"a":{"c":{"df":7,"docs":{"150":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"60":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":8,"docs":{"151":{"tf":1.7320508075688772},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"168":{"tf":1.0},"3":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"147":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":9,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"197":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"124":{"tf":1.0},"157":{"tf":1.0},"70":{"tf":1.0}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"140":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"119":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"159":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"83":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"188":{"tf":2.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.0}}},"s":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"63":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":16,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"161":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"\'":{"df":1,"docs":{"188":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":1,"docs":{"193":{"tf":1.0}}},"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"189":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":56,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":2.0},"106":{"tf":1.4142135623730951},"118":{"tf":2.23606797749979},"121":{"tf":1.4142135623730951},"122":{"tf":3.0},"123":{"tf":1.0},"126":{"tf":1.4142135623730951},"13":{"tf":3.3166247903554},"133":{"tf":1.4142135623730951},"135":{"tf":2.0},"139":{"tf":2.0},"141":{"tf":1.4142135623730951},"148":{"tf":2.0},"160":{"tf":4.0},"164":{"tf":1.7320508075688772},"175":{"tf":3.605551275463989},"176":{"tf":2.0},"181":{"tf":1.7320508075688772},"187":{"tf":2.23606797749979},"188":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"193":{"tf":2.449489742783178},"195":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":2.8284271247461903},"47":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.4142135623730951},"67":{"tf":2.0},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":1.0}},"’":{"df":4,"docs":{"189":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"’":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":4,"docs":{"150":{"tf":1.0},"52":{"tf":1.0},"63":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"119":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"98":{"tf":1.0}}}}}},"’":{"df":17,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.4142135623730951},"143":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"174":{"tf":1.0},"191":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"116":{"tf":1.0},"166":{"tf":1.0},"173":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"0":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"176":{"tf":2.23606797749979},"178":{"tf":2.6457513110645907},"179":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"182":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"110":{"tf":1.0},"150":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"57":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"153":{"tf":1.7320508075688772},"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"110":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"187":{"tf":1.0},"196":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":2,"docs":{"16":{"tf":1.0},"71":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"/":{"?":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"=":{"%":{"df":1,"docs":{"142":{"tf":1.0}},"s":{"&":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"163":{"tf":1.4142135623730951},"29":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"107":{"tf":1.0},"116":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"145":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"159":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"165":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":2,"docs":{"14":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":3,"docs":{"109":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"197":{"tf":1.0}}}},"v":{"df":3,"docs":{"63":{"tf":1.4142135623730951},"69":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":8,"docs":{"109":{"tf":1.0},"132":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"86":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":8,"docs":{"12":{"tf":1.0},"142":{"tf":1.0},"17":{"tf":1.0},"32":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0}},"’":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"71":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"169":{"tf":1.0},"179":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"189":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"175":{"tf":1.0},"70":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"97":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":22,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"133":{"tf":1.0},"14":{"tf":1.7320508075688772},"142":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"181":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"y":{"df":0,"docs":{},"’":{"df":2,"docs":{"36":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"166":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"166":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"51":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"111":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.0},"185":{"tf":1.0},"66":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":23,"docs":{"110":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"146":{"tf":1.0},"158":{"tf":1.7320508075688772},"168":{"tf":1.0},"179":{"tf":2.0},"185":{"tf":2.0},"2":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.449489742783178},"46":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":2.6457513110645907},"71":{"tf":2.0},"73":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":35,"docs":{"101":{"tf":1.0},"102":{"tf":3.0},"103":{"tf":2.0},"104":{"tf":2.0},"105":{"tf":3.3166247903554},"106":{"tf":2.0},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.6457513110645907},"122":{"tf":2.6457513110645907},"130":{"tf":1.7320508075688772},"132":{"tf":2.6457513110645907},"135":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":1.0},"182":{"tf":1.7320508075688772},"197":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.0},"90":{"tf":1.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"5":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"6":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"5":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"5":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"109":{"tf":1.0},"120":{"tf":2.449489742783178},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"172":{"tf":1.0},"175":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"79":{"tf":2.0}},"s":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"115":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":29,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.7320508075688772},"151":{"tf":1.0},"170":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.8284271247461903},"7":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"110":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"125":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"a":{"d":{"df":5,"docs":{"159":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"t":{"df":10,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"163":{"tf":1.0},"17":{"tf":1.7320508075688772},"173":{"tf":1.0},"179":{"tf":1.4142135623730951},"189":{"tf":1.0},"190":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":3,"docs":{"155":{"tf":2.23606797749979},"47":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"191":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"185":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":61,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"141":{"tf":1.0},"15":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"p":{"df":1,"docs":{"114":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"173":{"tf":1.0}}},"u":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"65":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"o":{"df":1,"docs":{"193":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":4,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"109":{"tf":1.0},"113":{"tf":1.7320508075688772}}}}},"df":15,"docs":{"104":{"tf":3.0},"105":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"119":{"tf":1.0},"186":{"tf":1.7320508075688772},"47":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"140":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"116":{"tf":2.0}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":60,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":2.0},"110":{"tf":2.8284271247461903},"111":{"tf":2.449489742783178},"113":{"tf":2.0},"114":{"tf":2.6457513110645907},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":1.4142135623730951},"185":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":22,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"139":{"tf":1.4142135623730951},"155":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":4,"docs":{"112":{"tf":1.0},"175":{"tf":1.0},"196":{"tf":1.0},"46":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"111":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"159":{"tf":1.0},"171":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":15,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"161":{"tf":2.23606797749979},"162":{"tf":2.23606797749979},"163":{"tf":2.23606797749979},"169":{"tf":1.0},"25":{"tf":2.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"5":{"tf":2.0},"72":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}},"df":5,"docs":{"127":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"181":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"129":{"tf":1.0},"150":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"135":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"153":{"tf":1.0},"167":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":4.0},"65":{"tf":2.449489742783178},"66":{"tf":3.1622776601683795},"75":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"113":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"192":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":19,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":2,"docs":{"131":{"tf":1.0},"143":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"163":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0}}}}}},"u":{"df":3,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"114":{"tf":2.23606797749979},"159":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.7320508075688772}},"e":{"=":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":9,"docs":{"104":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.7320508075688772},"175":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":1.0}}}}}},"’":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":1,"docs":{"127":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":4,"docs":{"104":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"148":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"120":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"175":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{"df":22,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"126":{"tf":1.0},"13":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":1.0}},"e":{"df":4,"docs":{"10":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.0},"35":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"166":{"tf":1.0},"179":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":18,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"124":{"tf":1.0},"148":{"tf":1.0},"164":{"tf":2.0},"187":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"192":{"tf":1.7320508075688772},"47":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"93":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":41,"docs":{"10":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"19":{"tf":1.0},"195":{"tf":1.0},"197":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.7320508075688772},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"66":{"tf":1.0},"88":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"49":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"114":{"tf":1.0},"169":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"115":{"tf":1.4142135623730951},"141":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.7320508075688772},"184":{"tf":1.0},"185":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.0}}}}}}},"t":{"df":5,"docs":{"111":{"tf":2.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"179":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":27,"docs":{"102":{"tf":1.0},"104":{"tf":1.7320508075688772},"107":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":2.6457513110645907},"121":{"tf":1.0},"141":{"tf":1.0},"16":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.6457513110645907},"179":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"44":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"66":{"tf":2.23606797749979},"67":{"tf":1.7320508075688772},"97":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"104":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":5,"docs":{"142":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"179":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"145":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":17,"docs":{"102":{"tf":1.0},"110":{"tf":2.23606797749979},"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"125":{"tf":1.0},"14":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"18":{"tf":1.4142135623730951},"191":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"118":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"184":{"tf":1.0},"63":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0},"66":{"tf":1.0}}}}},"w":{"df":10,"docs":{"1":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"124":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"150":{"tf":1.0},"189":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"125":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.4142135623730951},"147":{"tf":1.0},"156":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"178":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"179":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\"":{":":{"df":0,"docs":{},"{":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\\"":{":":{"3":{",":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\\"":{":":{"1":{",":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\\"":{":":{"3":{",":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\\"":{":":{"0":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"192":{"tf":1.4142135623730951},"193":{"tf":1.0}}}}}}},"df":6,"docs":{"13":{"tf":1.0},"144":{"tf":1.7320508075688772},"167":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.0},"62":{"tf":1.0}},"e":{"df":2,"docs":{"143":{"tf":1.0},"179":{"tf":1.0}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":2.449489742783178}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":2.0}}}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"139":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":30,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":2.449489742783178},"123":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.7320508075688772},"139":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"185":{"tf":1.4142135623730951},"24":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"h":{"df":5,"docs":{"189":{"tf":1.4142135623730951},"4":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":6,"docs":{"2":{"tf":1.4142135623730951},"79":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":1,"docs":{"179":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"147":{"tf":2.23606797749979},"164":{"tf":1.0},"179":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"74":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"o":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"j":{":":{":":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":2.0}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"11":{"tf":1.4142135623730951},"176":{"tf":1.0},"3":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"151":{"tf":1.0},"155":{"tf":1.0},"163":{"tf":1.0},"197":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":4,"docs":{"111":{"tf":1.7320508075688772},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"195":{"tf":1.0},"64":{"tf":1.0}}}}},"n":{"c":{"df":4,"docs":{"140":{"tf":1.4142135623730951},"173":{"tf":1.0},"187":{"tf":1.0},"61":{"tf":1.0}}},"df":26,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"127":{"tf":1.0},"135":{"tf":1.4142135623730951},"144":{"tf":2.0},"150":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"191":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":2.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"142":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"175":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":2.6457513110645907}}},"r":{"df":7,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"35":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"105":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"a":{"df":1,"docs":{"66":{"tf":1.0}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"61":{"tf":2.23606797749979},"66":{"tf":1.7320508075688772}}},"u":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":36,"docs":{"102":{"tf":1.4142135623730951},"118":{"tf":1.0},"134":{"tf":1.4142135623730951},"147":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"175":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":2.0},"180":{"tf":1.0},"181":{"tf":1.7320508075688772},"184":{"tf":1.7320508075688772},"185":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"38":{"tf":1.7320508075688772},"48":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"164":{"tf":1.0},"185":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"105":{"tf":1.0},"132":{"tf":1.0},"179":{"tf":1.0},"93":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":7,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"113":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":2.449489742783178},"175":{"tf":1.0},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"196":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":2.0},"65":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":30,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"119":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"171":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"176":{"tf":1.7320508075688772},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"179":{"tf":2.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.7320508075688772},"195":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"138":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"117":{"tf":1.0},"145":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"189":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"115":{"tf":1.0},"12":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"32":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"135":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"114":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":2.449489742783178},"170":{"tf":1.7320508075688772},"173":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.7320508075688772},"24":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":2.449489742783178},"8":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"df":5,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"127":{"tf":2.0},"71":{"tf":2.23606797749979}},"k":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"103":{"tf":2.0},"142":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":3.1622776601683795},"65":{"tf":1.0},"66":{"tf":3.3166247903554},"87":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"68":{"tf":2.449489742783178}},"t":{"df":4,"docs":{"187":{"tf":1.0},"192":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.0}},"i":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"80":{"tf":1.0}}}}}}}}}}}},"t":{"df":14,"docs":{"110":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":2.449489742783178},"166":{"tf":1.0},"18":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"119":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"10":{"tf":1.0},"108":{"tf":1.4142135623730951},"118":{"tf":1.0},"122":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.4142135623730951},"15":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.4142135623730951},"18":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":2.23606797749979},"195":{"tf":2.8284271247461903},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0}}},"t":{"df":2,"docs":{"195":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":2,"docs":{"183":{"tf":1.0},"184":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"179":{"tf":1.0},"181":{"tf":1.7320508075688772},"22":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.0},"44":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"175":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"173":{"tf":1.4142135623730951},"38":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"132":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"35":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"n":{"<":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.0},"167":{"tf":1.4142135623730951},"191":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"147":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"139":{"tf":1.7320508075688772},"140":{"tf":1.4142135623730951},"191":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"163":{"tf":3.3166247903554},"29":{"tf":2.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"163":{"tf":1.0},"196":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"49":{"tf":1.0},"88":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"157":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"118":{"tf":1.0},"187":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":1,"docs":{"109":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"51":{"tf":2.23606797749979},"80":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"104":{"tf":1.4142135623730951},"121":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"139":{"tf":1.0},"163":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"63":{"tf":1.4142135623730951},"83":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"110":{"tf":1.0},"115":{"tf":1.0},"139":{"tf":1.0}}}}},"s":{"df":2,"docs":{"49":{"tf":1.7320508075688772},"87":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"110":{"tf":1.0},"151":{"tf":1.0},"189":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"114":{"tf":1.0},"131":{"tf":1.0},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"191":{"tf":1.0},"24":{"tf":1.0},"96":{"tf":1.0}},"s":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"150":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"156":{"tf":1.0},"157":{"tf":1.0}}}}}}},"df":1,"docs":{"104":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"152":{"tf":1.7320508075688772},"65":{"tf":1.0},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"175":{"tf":1.0},"36":{"tf":1.0},"71":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"79":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"125":{"tf":1.0}}},"{":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}}}},"v":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"6":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":3.872983346207417},"126":{"tf":2.0},"13":{"tf":2.449489742783178},"144":{"tf":1.0},"160":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"178":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"109":{"tf":1.4142135623730951},"114":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"156":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"195":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"110":{"tf":1.0},"183":{"tf":1.7320508075688772},"184":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"71":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"155":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"122":{"tf":1.0},"147":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"144":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":19,"docs":{"120":{"tf":1.4142135623730951},"124":{"tf":1.0},"139":{"tf":1.4142135623730951},"152":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":38,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.6457513110645907},"102":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"179":{"tf":1.0},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":2.6457513110645907},"190":{"tf":2.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":2.449489742783178},"2":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"93":{"tf":3.605551275463989},"95":{"tf":1.7320508075688772},"97":{"tf":2.8284271247461903},"98":{"tf":3.872983346207417},"99":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"98":{"tf":2.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":17,"docs":{"100":{"tf":1.0},"118":{"tf":1.7320508075688772},"122":{"tf":2.449489742783178},"13":{"tf":2.23606797749979},"133":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":2.23606797749979},"160":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"45":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":2.6457513110645907},"99":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"196":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"157":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}},"t":{"df":8,"docs":{"110":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"142":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":3.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"158":{"tf":1.4142135623730951},"57":{"tf":1.0},"69":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"43":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.0},"141":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"111":{"tf":1.0},"71":{"tf":1.0}}}},"w":{"df":1,"docs":{"83":{"tf":1.0}}}},"c":{"df":1,"docs":{"64":{"tf":1.0}}},"d":{"_":{"(":{"\\"":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"159":{"tf":1.0}},"f":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"2":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.0},"83":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"d":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":2.449489742783178},"66":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"135":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"m":{"df":1,"docs":{"118":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"18":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"188":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"150":{"tf":1.0},"189":{"tf":1.0},"65":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"175":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}}}},"df":12,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"105":{"tf":2.0},"175":{"tf":1.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"193":{"tf":3.872983346207417},"2":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":2.23606797749979},"98":{"tf":2.0}},"f":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"117":{"tf":1.0},"144":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"142":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"139":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"139":{"tf":1.0},"143":{"tf":1.0},"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"118":{"tf":1.0},"18":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\\"":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.0}}}},"df":3,"docs":{"101":{"tf":1.0},"105":{"tf":1.0},"119":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"114":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"195":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"110":{"tf":1.0}}}},"i":{"df":2,"docs":{"3":{"tf":1.0},"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"118":{"tf":1.0},"24":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"173":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"166":{"tf":1.0},"187":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}}},"r":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"144":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"143":{"tf":1.0},"154":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"179":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"143":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"196":{"tf":1.0},"24":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":10,"docs":{"145":{"tf":1.0},"146":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"163":{"tf":1.0},"185":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"189":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":7,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.6457513110645907},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"155":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"173":{"tf":1.0},"196":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.0},"139":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":5,"docs":{"118":{"tf":1.0},"138":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"111":{"tf":1.7320508075688772}}},"u":{"3":{"2":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"8":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"63":{"tf":2.0}}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"df":23,"docs":{"108":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"132":{"tf":1.0},"142":{"tf":1.7320508075688772},"147":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":17,"docs":{"108":{"tf":1.0},"111":{"tf":2.0},"116":{"tf":2.0},"132":{"tf":1.0},"150":{"tf":1.0},"179":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"68":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"190":{"tf":1.0}}}}}}},"f":{"c":{"df":3,"docs":{"181":{"tf":1.0},"197":{"tf":1.4142135623730951},"198":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"132":{"tf":1.4142135623730951},"142":{"tf":1.0},"189":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"195":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":2.0},"176":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}},"’":{"df":1,"docs":{"36":{"tf":1.0}}}}},"w":{"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"df":1,"docs":{"12":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":11,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"157":{"tf":1.0},"175":{"tf":1.0},"191":{"tf":1.0},"35":{"tf":1.4142135623730951},"69":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"df":28,"docs":{"1":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":2.8284271247461903},"119":{"tf":2.449489742783178},"120":{"tf":1.0},"127":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.4142135623730951},"163":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.4142135623730951},"179":{"tf":1.0},"18":{"tf":1.7320508075688772},"185":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"195":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":2.449489742783178},"29":{"tf":1.0},"40":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":2.8284271247461903}}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":1,"docs":{"155":{"tf":1.0}}}}},"c":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"152":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":15,"docs":{"120":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"165":{"tf":1.0},"168":{"tf":1.0},"18":{"tf":2.0},"183":{"tf":1.4142135623730951},"184":{"tf":2.0},"185":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":122,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.7320508075688772},"10":{"tf":2.23606797749979},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"120":{"tf":1.7320508075688772},"123":{"tf":1.0},"13":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"135":{"tf":2.0},"139":{"tf":1.7320508075688772},"14":{"tf":2.0},"140":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"15":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":2.6457513110645907},"16":{"tf":1.0},"160":{"tf":1.4142135623730951},"161":{"tf":2.0},"162":{"tf":2.0},"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":2.0},"179":{"tf":2.0},"18":{"tf":2.8284271247461903},"181":{"tf":2.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"19":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}},"’":{"df":11,"docs":{"11":{"tf":1.0},"118":{"tf":1.0},"173":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":39,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":2.8284271247461903},"117":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":3.0},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"169":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"18":{"tf":1.0},"197":{"tf":1.7320508075688772},"198":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"178":{"tf":1.7320508075688772}}}},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":31,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"131":{"tf":2.0},"132":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"18":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"80":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"147":{"tf":1.4142135623730951},"61":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"121":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"103":{"tf":1.0},"105":{"tf":2.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"133":{"tf":1.4142135623730951},"134":{"tf":1.7320508075688772},"155":{"tf":1.0},"181":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":2.0},"159":{"tf":1.0}}}}}}},"df":7,"docs":{"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"142":{"tf":1.0},"193":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":22,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":2.0},"142":{"tf":2.23606797749979},"17":{"tf":1.0},"173":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":3.0},"65":{"tf":2.0},"66":{"tf":2.6457513110645907},"67":{"tf":2.23606797749979},"68":{"tf":2.23606797749979},"71":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"101":{"tf":1.7320508075688772},"113":{"tf":1.0},"2":{"tf":1.4142135623730951},"63":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":12,"docs":{"111":{"tf":1.0},"117":{"tf":1.4142135623730951},"145":{"tf":1.0},"165":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"49":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":29,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"19":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"m":{"df":1,"docs":{"144":{"tf":1.0}}},"n":{"df":4,"docs":{"139":{"tf":1.0},"175":{"tf":1.4142135623730951},"24":{"tf":1.0},"52":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"167":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"101":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"157":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"119":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}},"df":1,"docs":{"68":{"tf":3.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"111":{"tf":1.0},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"191":{"tf":1.0}}}},"t":{"df":18,"docs":{"107":{"tf":1.0},"110":{"tf":2.0},"118":{"tf":1.0},"139":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"24":{"tf":2.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"155":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"145":{"tf":1.0},"151":{"tf":1.7320508075688772},"166":{"tf":1.0},"72":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"178":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"49":{"tf":1.4142135623730951},"57":{"tf":2.0},"70":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"71":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"127":{"tf":1.4142135623730951},"179":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{}}}},"df":28,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"150":{"tf":1.0},"155":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.7320508075688772},"175":{"tf":1.4142135623730951},"178":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":6,"docs":{"101":{"tf":1.0},"13":{"tf":1.0},"135":{"tf":1.4142135623730951},"160":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"157":{"tf":1.0},"43":{"tf":1.0},"73":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"44":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":2.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.0},"184":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"144":{"tf":1.0},"173":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"181":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"z":{"df":0,"docs":{},"e":{"df":3,"docs":{"135":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"165":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"65":{"tf":2.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"159":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"74":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"133":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"139":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":2.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"135":{"tf":1.0},"164":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":10,"docs":{"110":{"tf":1.0},"135":{"tf":1.4142135623730951},"164":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"117":{"tf":1.0},"141":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"72":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"103":{"tf":1.0},"150":{"tf":1.4142135623730951},"166":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":14,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"147":{"tf":1.0},"21":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"i":{"df":13,"docs":{"103":{"tf":1.0},"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"115":{"tf":1.4142135623730951},"119":{"tf":1.0},"17":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":2.0}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":44,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.7320508075688772},"18":{"tf":2.0},"181":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"127":{"tf":1.0}}},"9":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"2":{"7":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"79":{"tf":1.0}}},"9":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"44":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"147":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0}}}},"l":{"df":8,"docs":{"146":{"tf":1.0},"147":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.0},"44":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"198":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}},"e":{"_":{"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"179":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"d":{"df":17,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"168":{"tf":1.4142135623730951},"188":{"tf":1.0},"37":{"tf":1.4142135623730951},"44":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"107":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"141":{"tf":1.0},"179":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"144":{"tf":1.0},"147":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":7,"docs":{"148":{"tf":1.0},"155":{"tf":1.0},"17":{"tf":1.0},"173":{"tf":2.0},"175":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":2.0}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"178":{"tf":1.0},"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"171":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":15,"docs":{"105":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.0},"188":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":2.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"111":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"110":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"p":{"df":3,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"195":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}},":":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":24,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":3.1622776601683795},"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":2.8284271247461903},"139":{"tf":2.0},"141":{"tf":1.7320508075688772},"185":{"tf":1.0},"193":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"93":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951},"97":{"tf":2.0},"98":{"tf":2.6457513110645907},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"71":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"38":{"tf":1.0},"82":{"tf":1.0}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"198":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"97":{"tf":2.0}}},"2":{"df":1,"docs":{"97":{"tf":2.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"51":{"tf":1.0},"97":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"181":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"142":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"146":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.0},"157":{"tf":1.4142135623730951},"159":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"166":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"166":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":2,"docs":{"166":{"tf":1.7320508075688772},"173":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"121":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"m":{"df":1,"docs":{"110":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"i":{"df":3,"docs":{"165":{"tf":1.0},"6":{"tf":1.0},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"103":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"172":{"tf":1.0},"24":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":2.0},"107":{"tf":1.0},"142":{"tf":1.0},"188":{"tf":1.0},"191":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.0},"163":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":15,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"117":{"tf":1.4142135623730951},"129":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"4":{"tf":2.0},"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"183":{"tf":1.0},"32":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"119":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":2.0}},"l":{"df":3,"docs":{"160":{"tf":1.0},"30":{"tf":1.4142135623730951},"75":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":8,"docs":{"110":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"198":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":22,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"132":{"tf":1.4142135623730951},"14":{"tf":1.0},"142":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"184":{"tf":1.0},"191":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951}},"n":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"193":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"79":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"18":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":9,"docs":{"106":{"tf":1.0},"115":{"tf":2.449489742783178},"139":{"tf":2.0},"18":{"tf":1.0},"181":{"tf":1.7320508075688772},"188":{"tf":1.0},"23":{"tf":2.23606797749979},"3":{"tf":1.0},"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":2.6457513110645907}}}}},"df":7,"docs":{"103":{"tf":1.0},"147":{"tf":1.0},"157":{"tf":1.4142135623730951},"61":{"tf":2.0},"63":{"tf":1.4142135623730951},"65":{"tf":3.1622776601683795},"66":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"110":{"tf":1.0},"135":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":2.23606797749979},"18":{"tf":1.0},"60":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"142":{"tf":1.0},"144":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"111":{"tf":1.0},"171":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"2":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":30,"docs":{"107":{"tf":2.0},"108":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":2.0},"112":{"tf":1.7320508075688772},"114":{"tf":2.23606797749979},"118":{"tf":3.1622776601683795},"119":{"tf":2.6457513110645907},"120":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.4142135623730951},"16":{"tf":1.0},"171":{"tf":2.23606797749979},"174":{"tf":1.7320508075688772},"178":{"tf":1.0},"18":{"tf":2.6457513110645907},"181":{"tf":1.7320508075688772},"183":{"tf":2.0},"184":{"tf":2.6457513110645907},"185":{"tf":3.0},"19":{"tf":2.6457513110645907},"20":{"tf":2.8284271247461903},"21":{"tf":2.23606797749979},"22":{"tf":3.3166247903554},"33":{"tf":1.0},"5":{"tf":1.0},"80":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":10,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"147":{"tf":1.0},"44":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.23606797749979},"78":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"’":{"df":6,"docs":{"110":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"24":{"tf":3.1622776601683795},"34":{"tf":3.0},"35":{"tf":3.3166247903554},"48":{"tf":1.0},"51":{"tf":2.449489742783178},"82":{"tf":2.449489742783178}},"’":{"df":1,"docs":{"34":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"116":{"tf":1.0},"144":{"tf":1.0},"69":{"tf":1.0},"98":{"tf":1.0}}}}},"’":{"df":9,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"143":{"tf":1.0},"152":{"tf":1.0},"191":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"’":{"df":0,"docs":{},"r":{"df":4,"docs":{"145":{"tf":1.0},"174":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":11,"docs":{"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.4142135623730951},"147":{"tf":1.0},"188":{"tf":1.0},"22":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}},"k":{"df":2,"docs":{"2":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"d":{"df":3,"docs":{"101":{"tf":1.4142135623730951},"176":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"113":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":12,"docs":{"101":{"tf":1.0},"107":{"tf":1.0},"141":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"188":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"83":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"104":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":10,"docs":{"116":{"tf":1.0},"141":{"tf":1.4142135623730951},"157":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"187":{"tf":1.0},"22":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}}}}},"u":{"df":4,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"145":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"73":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"141":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"184":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"111":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"135":{"tf":1.0},"186":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"110":{"tf":1.0},"139":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"178":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":12,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.0},"169":{"tf":1.4142135623730951},"179":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":2.0},"175":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"74":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":15,"docs":{"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":16,"docs":{"103":{"tf":1.0},"104":{"tf":2.0},"111":{"tf":1.0},"150":{"tf":3.1622776601683795},"151":{"tf":2.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.23606797749979},"59":{"tf":1.0},"63":{"tf":1.7320508075688772},"66":{"tf":2.6457513110645907},"68":{"tf":1.0},"80":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"195":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"139":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"59":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.0},"23":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"144":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"113":{"tf":1.0},"179":{"tf":1.7320508075688772},"187":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"146":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"191":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":11,"docs":{"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"167":{"tf":1.0},"188":{"tf":1.0},"2":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"e":{"=":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"175":{"tf":1.0}}}}},"df":36,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"111":{"tf":2.0},"121":{"tf":1.0},"127":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"150":{"tf":2.0},"151":{"tf":2.0},"152":{"tf":1.4142135623730951},"157":{"tf":3.0},"165":{"tf":1.7320508075688772},"167":{"tf":1.0},"172":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":3.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":3.7416573867739413},"65":{"tf":2.449489742783178},"66":{"tf":4.242640687119285},"67":{"tf":1.4142135623730951},"68":{"tf":3.872983346207417},"71":{"tf":1.7320508075688772},"81":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}},"’":{"df":2,"docs":{"165":{"tf":1.7320508075688772},"63":{"tf":1.0}}}},"o":{"df":3,"docs":{"127":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"u":{"3":{"2":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}},"df":1,"docs":{"65":{"tf":1.4142135623730951}},"i":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"z":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"189":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"r":{"df":5,"docs":{"145":{"tf":1.0},"187":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"185":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"111":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"123":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"131":{"tf":1.0}},"e":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"111":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"71":{"tf":1.0},"77":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"68":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"104":{"tf":1.0},"111":{"tf":1.0}}}},"t":{"df":3,"docs":{"108":{"tf":1.0},"118":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"x":{"df":7,"docs":{"139":{"tf":1.0},"189":{"tf":2.8284271247461903},"190":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"193":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"139":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"179":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"113":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":5,"docs":{"102":{"tf":1.0},"123":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"122":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"128":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":24,"docs":{"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"145":{"tf":1.7320508075688772},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.4142135623730951},"187":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"159":{"tf":1.0},"37":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.4142135623730951}},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":1.0}}}}},"df":13,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"50":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":9,"docs":{"103":{"tf":1.0},"130":{"tf":1.7320508075688772},"142":{"tf":1.7320508075688772},"163":{"tf":3.3166247903554},"167":{"tf":2.0},"29":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":136,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":2.0},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":2.6457513110645907},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":2.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":2.0},"14":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"142":{"tf":2.0},"144":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"15":{"tf":1.7320508075688772},"151":{"tf":1.7320508075688772},"152":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":2.23606797749979},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":2.6457513110645907},"19":{"tf":1.0},"190":{"tf":2.0},"191":{"tf":1.4142135623730951},"193":{"tf":2.0},"195":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":2.23606797749979},"42":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":3.1622776601683795},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":2.449489742783178},"98":{"tf":2.8284271247461903},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"189":{"tf":1.0}}}}}},"r":{"df":10,"docs":{"124":{"tf":1.0},"187":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":2.0}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"’":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"z":{"df":4,"docs":{"118":{"tf":1.0},"132":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":2.23606797749979}},"e":{"`":{"]":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"132":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"174":{"tf":1.0},"23":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":3,"docs":{"103":{"tf":1.0},"118":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":9,"docs":{"104":{"tf":1.4142135623730951},"127":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"165":{"tf":1.0},"24":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"158":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"104":{"tf":1.0},"143":{"tf":1.0},"148":{"tf":1.0},"175":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"df":3,"docs":{"10":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"c":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"61":{"tf":1.0}}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"`":{"]":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"103":{"tf":1.0}}},"u":{"8":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":5,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"161":{"tf":1.0},"162":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":2.23606797749979},"3":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"191":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"35":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"10":{"tf":1.7320508075688772},"103":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"167":{"tf":1.0},"173":{"tf":1.0},"179":{"tf":1.0},"24":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.449489742783178},"44":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":2.0}}}}}}}},"i":{"a":{"df":5,"docs":{"167":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.4142135623730951},"71":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"193":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"187":{"tf":1.0},"189":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}},"l":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"n":{"d":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":35,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"142":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.7320508075688772},"93":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"123":{"tf":1.0},"79":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"120":{"tf":1.0},"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":20,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":2.0},"112":{"tf":2.23606797749979},"120":{"tf":1.0},"121":{"tf":2.23606797749979},"122":{"tf":2.449489742783178},"123":{"tf":1.4142135623730951},"124":{"tf":2.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"128":{"tf":2.23606797749979},"129":{"tf":1.7320508075688772},"130":{"tf":2.449489742783178},"131":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"148":{"tf":1.0},"185":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"!":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"y":{"df":15,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"117":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"143":{"tf":1.0},"152":{"tf":1.0},"163":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":2,"docs":{"177":{"tf":1.0},"65":{"tf":1.4142135623730951}},"e":{"b":{"df":3,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"57":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"142":{"tf":1.0},"72":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"113":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":1,"docs":{"118":{"tf":1.0}}},"v":{"df":1,"docs":{"83":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"’":{"df":2,"docs":{"72":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"139":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"106":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"189":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.0},"188":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"111":{"tf":1.0},"141":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"119":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"47":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\'":{"1":{"0":{"0":{"\'":{">":{"<":{"/":{"a":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"115":{"tf":1.0},"139":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"192":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"139":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"144":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":12,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"167":{"tf":1.0},"179":{"tf":1.0},"195":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":4,"docs":{"127":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"140":{"tf":1.0},"171":{"tf":1.0},"18":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"k":{"df":18,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"119":{"tf":1.0},"135":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"188":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"133":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"145":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"93":{"tf":1.0}}}}},"’":{"df":0,"docs":{},"v":{"df":1,"docs":{"110":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":8,"docs":{"109":{"tf":1.0},"184":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"184":{"tf":1.0}}},"2":{"df":1,"docs":{"184":{"tf":1.0}}},"df":5,"docs":{"179":{"tf":1.7320508075688772},"184":{"tf":2.8284271247461903},"22":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":20,"docs":{"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.0},"139":{"tf":1.0},"144":{"tf":1.0},"159":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"198":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"95":{"tf":1.0},"97":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"95":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"68":{"tf":3.0}}}},"x":{"0":{"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"2":{"2":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"3":{"0":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"6":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":2,"docs":{"115":{"tf":2.449489742783178},"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"107":{"tf":1.7320508075688772},"110":{"tf":4.242640687119285},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"141":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"76":{"tf":1.0}}},"y":{"df":2,"docs":{"110":{"tf":4.242640687119285},"193":{"tf":1.0}},"e":{"df":1,"docs":{"110":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"142":{"tf":1.0}}}}}}},"’":{"d":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"169":{"tf":1.0},"2":{"tf":1.0}}}},"r":{"df":6,"docs":{"112":{"tf":1.0},"173":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0}}},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"z":{"df":15,"docs":{"158":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"144":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":2.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"134":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"179":{"tf":1.0},"184":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{"3":{"df":1,"docs":{"185":{"tf":1.0}}},"6":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":2,"docs":{"116":{"tf":2.0},"185":{"tf":2.8284271247461903}}},"1":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{".":{"0":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"8":{".":{"0":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{".":{"0":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"9":{"8":{"1":{"df":2,"docs":{"183":{"tf":1.0},"184":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"114":{"tf":1.0}}},"df":2,"docs":{"129":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"1":{"3":{"2":{"4":{"8":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{";":{"\\\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":3,"docs":{"179":{"tf":1.0},"185":{"tf":1.0},"52":{"tf":1.0}}},"3":{"4":{"5":{"2":{"9":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"4":{"8":{"7":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"4":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"6":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"121":{"tf":2.0},"122":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"144":{"tf":2.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"185":{"tf":2.8284271247461903},"5":{"tf":1.4142135623730951},"74":{"tf":1.0},"79":{"tf":1.7320508075688772}}},"2":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"33":{"tf":1.0}}},"7":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"8":{"df":3,"docs":{"114":{"tf":1.0},"33":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"114":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{"6":{"7":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"127":{"tf":1.7320508075688772},"128":{"tf":1.7320508075688772},"130":{"tf":1.0},"132":{"tf":1.4142135623730951},"159":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0}}},"3":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"9":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"1":{"2":{"3":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":10,"docs":{"106":{"tf":1.4142135623730951},"123":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"132":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0},"87":{"tf":1.0}}},"4":{".":{"5":{"9":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"\\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"0":{"2":{"7":{"df":2,"docs":{"151":{"tf":1.0},"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"4":{"0":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"106":{"tf":1.4142135623730951},"109":{"tf":1.0},"114":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"175":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"5":{"4":{"7":{"6":{"5":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"5":{"df":1,"docs":{"174":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"1":{"5":{"4":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":9,"docs":{"107":{"tf":1.7320508075688772},"110":{"tf":2.6457513110645907},"114":{"tf":1.0},"118":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"135":{"tf":1.0},"185":{"tf":1.0},"79":{"tf":1.0}}},"6":{"df":2,"docs":{"110":{"tf":2.6457513110645907},"126":{"tf":1.0}}},"7":{"6":{"5":{"7":{"8":{"df":1,"docs":{"178":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"5":{".":{"2":{"0":{"4":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":1,"docs":{"126":{"tf":1.0}}},"8":{"8":{"7":{"9":{"1":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"0":{"9":{"5":{"df":1,"docs":{"182":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"126":{"tf":1.0},"129":{"tf":1.0},"38":{"tf":1.0}}},"9":{"df":1,"docs":{"129":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"127":{"tf":1.0},"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"68":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"179":{"tf":1.0}}}}}}}},"a":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"133":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"b":{"c":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"143":{"tf":1.0},"144":{"tf":1.0}},"l":{"df":1,"docs":{"167":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}},"v":{"df":12,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"127":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"166":{"tf":1.0},"25":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.7320508075688772},"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"180":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"114":{"tf":1.0},"150":{"tf":1.0},"50":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"t":{"df":4,"docs":{"155":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.0},"65":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"145":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"118":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"(":{"a":{"df":1,"docs":{"131":{"tf":2.23606797749979}}},"b":{"df":1,"docs":{"131":{"tf":2.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":30,"docs":{"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"121":{"tf":1.0},"125":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":1.0},"141":{"tf":2.0},"142":{"tf":1.0},"147":{"tf":1.4142135623730951},"151":{"tf":1.0},"165":{"tf":1.7320508075688772},"178":{"tf":1.0},"181":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.4142135623730951},"191":{"tf":1.0},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"39":{"tf":1.4142135623730951},"56":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"d":{"_":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"105":{"tf":1.4142135623730951},"116":{"tf":1.0},"132":{"tf":1.4142135623730951},"151":{"tf":1.0},"157":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"df":15,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"150":{"tf":1.4142135623730951},"163":{"tf":1.0},"179":{"tf":1.4142135623730951},"187":{"tf":1.0},"188":{"tf":1.0},"25":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":8,"docs":{"138":{"tf":1.7320508075688772},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"110":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"132":{"tf":1.0},"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"167":{"tf":1.0},"35":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"i":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":1,"docs":{"187":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}}},"i":{"a":{"df":3,"docs":{"141":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772}},"s":{"(":{"df":1,"docs":{"141":{"tf":1.0}}},"df":4,"docs":{"141":{"tf":1.7320508075688772},"148":{"tf":1.0},"45":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.4142135623730951}}}},"k":{"df":1,"docs":{"42":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"178":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"179":{"tf":1.0},"96":{"tf":1.0}},"e":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":50,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":2.8284271247461903},"111":{"tf":1.4142135623730951},"114":{"tf":2.6457513110645907},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"d":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"#":{"!":{"[":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{")":{"]":{"\\\\":{"df":0,"docs":{},"n":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":28,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"109":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"131":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"174":{"tf":1.0},"18":{"tf":1.4142135623730951},"182":{"tf":1.0},"187":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"63":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"101":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"118":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"167":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"144":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"63":{"tf":1.0},"68":{"tf":2.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.4142135623730951},"157":{"tf":1.7320508075688772},"160":{"tf":1.0},"94":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"168":{"tf":1.0},"187":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":2.0}}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"69":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"103":{"tf":1.0},"111":{"tf":1.0},"139":{"tf":1.0},"173":{"tf":1.0},"179":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"188":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"139":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"118":{"tf":1.0},"150":{"tf":1.0},"197":{"tf":1.0},"198":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":16,"docs":{"11":{"tf":1.0},"111":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"164":{"tf":2.0},"187":{"tf":1.0},"189":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"81":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"142":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"139":{"tf":1.4142135623730951},"150":{"tf":1.0},"168":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"23":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"118":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"147":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0}}}}}},"g":{"df":7,"docs":{"112":{"tf":1.0},"134":{"tf":1.0},"185":{"tf":2.449489742783178},"19":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":2.6457513110645907},"68":{"tf":4.358898943540674}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":46,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"158":{"tf":1.4142135623730951},"16":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":2.0},"19":{"tf":1.0},"191":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":2.449489742783178},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"102":{"tf":1.0},"111":{"tf":1.0},"174":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"66":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"111":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"49":{"tf":1.4142135623730951},"61":{"tf":1.0},"68":{"tf":2.0}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":2,"docs":{"141":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"114":{"tf":1.0},"126":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"1":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"108":{"tf":1.0},"117":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"108":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"103":{"tf":1.0},"148":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"107":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.0},"66":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"_":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"103":{"tf":1.0},"80":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"152":{"tf":1.0},"192":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"147":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}},"r":{"df":1,"docs":{"68":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":51,"docs":{"100":{"tf":1.0},"101":{"tf":2.8284271247461903},"109":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":2.6457513110645907},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.7320508075688772},"141":{"tf":1.0},"144":{"tf":1.4142135623730951},"145":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"149":{"tf":2.0},"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"152":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":2.23606797749979},"155":{"tf":1.0},"163":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"187":{"tf":2.0},"188":{"tf":2.23606797749979},"189":{"tf":2.8284271247461903},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":2.23606797749979},"79":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":2.8284271247461903},"84":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.7320508075688772},"96":{"tf":2.449489742783178},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"133":{"tf":1.0},"42":{"tf":1.0},"79":{"tf":1.0}}}}},"o":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":1.0}}}}}}},"df":2,"docs":{"189":{"tf":2.0},"190":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":4,"docs":{"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"104":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"142":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":21,"docs":{"104":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"139":{"tf":1.4142135623730951},"145":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.4142135623730951},"178":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.0},"192":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":2.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"115":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"163":{"tf":1.0}}},"y":{"df":2,"docs":{"142":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"82":{"tf":1.0}}}}},"b":{"]":{"[":{"c":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"167":{"tf":1.0},"191":{"tf":1.0},"98":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"102":{"tf":1.0},"107":{"tf":1.0},"117":{"tf":1.0},"131":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":1,"docs":{"102":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":14,"docs":{"1":{"tf":1.0},"102":{"tf":2.6457513110645907},"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"126":{"tf":1.0},"142":{"tf":1.0},"16":{"tf":1.4142135623730951},"185":{"tf":2.23606797749979},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"58":{"tf":1.0},"93":{"tf":4.69041575982343}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"119":{"tf":1.0},"135":{"tf":1.0},"163":{"tf":1.0},"29":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"66":{"tf":2.23606797749979},"67":{"tf":1.4142135623730951},"74":{"tf":1.0},"88":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"107":{"tf":1.0},"71":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":3,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"131":{"tf":2.449489742783178}},"e":{"c":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"166":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}}},"df":17,"docs":{"100":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"181":{"tf":1.0},"195":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"145":{"tf":1.0},"161":{"tf":3.0},"162":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"195":{"tf":1.0},"27":{"tf":2.6457513110645907},"28":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"101":{"tf":1.0},"114":{"tf":1.0},"122":{"tf":1.0},"167":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"106":{"tf":1.0},"135":{"tf":1.0},"189":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"150":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}},"w":{"df":8,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"191":{"tf":1.0},"69":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"140":{"tf":1.4142135623730951},"165":{"tf":1.0},"167":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"49":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"141":{"tf":1.7320508075688772},"78":{"tf":1.0}},"x":{"df":1,"docs":{"141":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"174":{"tf":1.0},"79":{"tf":1.0}}}}},"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":13,"docs":{"107":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":2.23606797749979},"117":{"tf":3.0},"125":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"129":{"tf":2.23606797749979},"148":{"tf":1.0},"175":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}},"w":{"df":1,"docs":{"135":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"145":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}},"l":{"df":2,"docs":{"61":{"tf":1.7320508075688772},"63":{"tf":3.3166247903554}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"h":{"df":15,"docs":{"115":{"tf":1.0},"121":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"160":{"tf":1.0},"163":{"tf":1.4142135623730951},"189":{"tf":1.0},"193":{"tf":1.4142135623730951},"59":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"165":{"tf":1.0},"31":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"64":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"155":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"153":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":4,"docs":{"113":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"131":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"142":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"184":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"115":{"tf":1.0},"139":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"168":{"tf":1.0},"183":{"tf":1.4142135623730951},"185":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"183":{"tf":1.7320508075688772},"184":{"tf":3.0}}}}},"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.0},"139":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.0},"175":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"154":{"tf":1.7320508075688772},"24":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"150":{"tf":1.0},"163":{"tf":1.0},"29":{"tf":1.0},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"165":{"tf":1.0},"65":{"tf":1.0}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"166":{"tf":1.0},"173":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"125":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"181":{"tf":1.7320508075688772},"184":{"tf":1.4142135623730951},"195":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"185":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":2.23606797749979}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"114":{"tf":1.0},"146":{"tf":1.0}},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"134":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":14,"docs":{"1":{"tf":2.23606797749979},"112":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"137":{"tf":1.0},"158":{"tf":1.4142135623730951},"173":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"3":{"tf":3.1622776601683795},"44":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0}},"’":{"df":2,"docs":{"135":{"tf":1.0},"137":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"101":{"tf":1.4142135623730951},"104":{"tf":2.23606797749979},"106":{"tf":2.0},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"144":{"tf":1.0},"176":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"195":{"tf":1.0},"22":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"83":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"159":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"138":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"149":{"tf":1.0}}}}},"s":{"df":7,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"188":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":4,"docs":{"101":{"tf":1.0},"116":{"tf":2.0},"18":{"tf":2.6457513110645907},"95":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"108":{"tf":1.0},"118":{"tf":1.0},"151":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":1,"docs":{"101":{"tf":2.0}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"139":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"139":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":1,"docs":{"101":{"tf":1.0}}},"c":{"df":1,"docs":{"101":{"tf":2.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"139":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"188":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":2.0}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"188":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"193":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":1.0},"193":{"tf":1.7320508075688772}}}}}}},"=":{"\'":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"144":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"189":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"101":{"tf":1.0},"106":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"15":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"187":{"tf":1.0},"188":{"tf":1.7320508075688772},"189":{"tf":2.449489742783178},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":2.23606797749979}},"e":{"d":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":11,"docs":{"114":{"tf":1.4142135623730951},"166":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.0},"195":{"tf":1.4142135623730951},"2":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.7320508075688772},"59":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":16,"docs":{"147":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"163":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"50":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"105":{"tf":1.0},"129":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"137":{"tf":1.0},"16":{"tf":3.0},"172":{"tf":2.449489742783178},"181":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":2.23606797749979},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"187":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"192":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"\\"":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\"":{">":{"a":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":1,"docs":{"116":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"150":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"df":0,"docs":{},"’":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":2.6457513110645907}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":52,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"110":{"tf":2.23606797749979},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":3.4641016151377544},"116":{"tf":2.6457513110645907},"117":{"tf":3.3166247903554},"119":{"tf":1.0},"125":{"tf":2.449489742783178},"127":{"tf":1.4142135623730951},"129":{"tf":2.449489742783178},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"147":{"tf":2.0},"148":{"tf":1.0},"150":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.7320508075688772},"179":{"tf":3.1622776601683795},"18":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.7320508075688772},"186":{"tf":1.7320508075688772},"188":{"tf":1.0},"19":{"tf":1.7320508075688772},"192":{"tf":1.0},"193":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":2.0},"69":{"tf":1.0},"71":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772},"83":{"tf":1.0},"87":{"tf":1.7320508075688772},"90":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":6,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":2.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"114":{"tf":1.0},"159":{"tf":1.4142135623730951},"160":{"tf":1.0},"181":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"114":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}},"m":{"a":{"/":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":3,"docs":{"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.0}},"n":{"d":{"df":44,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"158":{"tf":2.23606797749979},"16":{"tf":1.0},"166":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"175":{"tf":1.0},"2":{"tf":1.0},"70":{"tf":1.0},"83":{"tf":2.23606797749979}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"109":{"tf":1.0},"127":{"tf":1.0},"175":{"tf":1.0},"195":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"117":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"198":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"t":{"df":4,"docs":{"114":{"tf":1.0},"115":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":28,"docs":{"108":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":3.3166247903554},"118":{"tf":1.4142135623730951},"119":{"tf":2.6457513110645907},"139":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"145":{"tf":1.4142135623730951},"147":{"tf":1.7320508075688772},"149":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.4142135623730951},"165":{"tf":1.0},"168":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"183":{"tf":1.0},"185":{"tf":2.23606797749979},"188":{"tf":1.0},"191":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"147":{"tf":1.0},"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"111":{"tf":1.0},"165":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.7320508075688772}}},"x":{"df":3,"docs":{"63":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"178":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"80":{"tf":1.0}}},"s":{"df":2,"docs":{"48":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"132":{"tf":1.0},"165":{"tf":1.0},"179":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"195":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"113":{"tf":1.0},"139":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.4142135623730951},"191":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":1,"docs":{"188":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772},"187":{"tf":1.0},"2":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"111":{"tf":1.0}}}}},"i":{"d":{"df":10,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"151":{"tf":1.0},"195":{"tf":1.0},"48":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"148":{"tf":1.0},"175":{"tf":1.0},"68":{"tf":1.0}}}}},"df":2,"docs":{"104":{"tf":1.0},"62":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"105":{"tf":1.0},"109":{"tf":1.4142135623730951},"115":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"141":{"tf":1.0},"142":{"tf":1.0},"179":{"tf":1.7320508075688772},"52":{"tf":1.0},"65":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"1":{"tf":1.0},"161":{"tf":3.0},"162":{"tf":3.0},"179":{"tf":1.0},"2":{"tf":1.0},"27":{"tf":2.6457513110645907},"28":{"tf":2.6457513110645907},"30":{"tf":1.7320508075688772},"31":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"74":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"193":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"80":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":19,"docs":{"119":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"159":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"173":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"44":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"156":{"tf":1.0},"157":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"95":{"tf":1.0}}},"t":{"df":3,"docs":{"137":{"tf":1.0},"197":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"44":{"tf":1.0},"70":{"tf":1.0}}},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"179":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"114":{"tf":1.0},"178":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"127":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.4142135623730951},"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"114":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":3.1622776601683795}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"80":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"178":{"tf":1.0}}}},"df":4,"docs":{"189":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"124":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"123":{"tf":1.0},"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"126":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"167":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"179":{"tf":1.7320508075688772}}}}}}}},"df":61,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":2.0},"109":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"12":{"tf":2.6457513110645907},"124":{"tf":1.4142135623730951},"133":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":2.0},"14":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":2.23606797749979},"155":{"tf":1.7320508075688772},"157":{"tf":1.0},"159":{"tf":2.0},"163":{"tf":2.449489742783178},"166":{"tf":1.4142135623730951},"167":{"tf":2.8284271247461903},"168":{"tf":1.7320508075688772},"169":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.7320508075688772},"175":{"tf":2.0},"176":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":2.0},"181":{"tf":2.0},"187":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.4142135623730951},"198":{"tf":1.0},"2":{"tf":2.449489742783178},"3":{"tf":1.4142135623730951},"36":{"tf":2.449489742783178},"4":{"tf":2.449489742783178},"47":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":3.605551275463989},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"89":{"tf":2.0},"91":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}},"’":{"df":3,"docs":{"163":{"tf":1.0},"2":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.4142135623730951},"106":{"tf":1.0},"166":{"tf":1.0},"25":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":9,"docs":{"0":{"tf":1.0},"116":{"tf":2.0},"166":{"tf":1.0},"173":{"tf":1.0},"25":{"tf":2.23606797749979},"31":{"tf":2.23606797749979},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"166":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"11":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"179":{"tf":1.4142135623730951},"181":{"tf":1.0},"187":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"24":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.7320508075688772},"5":{"tf":1.0},"72":{"tf":1.0},"96":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{",":{"df":0,"docs":{},"{":{".":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"=":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":8,"docs":{"116":{"tf":2.0},"142":{"tf":1.7320508075688772},"157":{"tf":1.0},"169":{"tf":1.0},"195":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"82":{"tf":2.0}}}}}}}},"d":{"]":{"(":{"df":0,"docs":{},"e":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"34":{"tf":1.0},"51":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"118":{"tf":1.0},"159":{"tf":2.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"107":{"tf":1.0}}}},"y":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"109":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"112":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"171":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"63":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"144":{"tf":1.0},"151":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":42,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"135":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"170":{"tf":1.7320508075688772},"175":{"tf":1.4142135623730951},"180":{"tf":1.0},"183":{"tf":1.0},"189":{"tf":1.4142135623730951},"191":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":2.6457513110645907},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"40":{"tf":2.0},"52":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"81":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":1,"docs":{"75":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"101":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"142":{"tf":1.0},"152":{"tf":1.0},"185":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"110":{"tf":1.0},"182":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"74":{"tf":1.0},"93":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"159":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"108":{"tf":1.0},"114":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"120":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{":":{":":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"193":{"tf":1.4142135623730951},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"10":{"tf":1.0},"106":{"tf":1.0},"122":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":2.0},"151":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"181":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"45":{"tf":1.0},"77":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":5,"docs":{"194":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"66":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"189":{"tf":1.4142135623730951},"190":{"tf":1.7320508075688772},"191":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":6,"docs":{"160":{"tf":1.0},"165":{"tf":1.4142135623730951},"192":{"tf":1.0},"50":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"193":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"107":{"tf":1.0},"110":{"tf":1.0},"147":{"tf":1.0},"191":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":12,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"175":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"145":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"150":{"tf":2.23606797749979}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":15,"docs":{"104":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"108":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"151":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"r":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{".":{"d":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"159":{"tf":2.6457513110645907}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"171":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"123":{"tf":1.0},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.0},"55":{"tf":2.0},"66":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"1":{"tf":1.0},"11":{"tf":2.23606797749979},"119":{"tf":3.1622776601683795},"133":{"tf":1.0},"14":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.4142135623730951},"17":{"tf":1.0},"173":{"tf":1.0},"178":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":2.23606797749979},"3":{"tf":1.0}}},"y":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"164":{"tf":1.0},"171":{"tf":1.4142135623730951},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"104":{"tf":2.6457513110645907},"111":{"tf":1.0},"121":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"174":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":16,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"106":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"188":{"tf":2.23606797749979},"189":{"tf":2.8284271247461903},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"167":{"tf":1.0}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"151":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":1,"docs":{"78":{"tf":1.7320508075688772}},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":3,"docs":{"101":{"tf":1.0},"141":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}},"s":{"(":{"\\"":{"df":0,"docs":{},"x":{"df":1,"docs":{"141":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"154":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"187":{"tf":1.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"189":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":2.6457513110645907},"190":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"190":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":2.0}}}}}}},"df":2,"docs":{"187":{"tf":1.0},"190":{"tf":2.0}}}}}}},"df":5,"docs":{"187":{"tf":2.23606797749979},"188":{"tf":1.4142135623730951},"189":{"tf":3.1622776601683795},"190":{"tf":1.4142135623730951},"191":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"188":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"192":{"tf":1.0},"193":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"188":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"187":{"tf":1.7320508075688772},"188":{"tf":2.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"101":{"tf":1.0},"13":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"160":{"tf":2.0},"81":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"193":{"tf":2.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"153":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":2.0},"101":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"/":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"159":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"187":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":65,"docs":{"1":{"tf":2.0},"101":{"tf":2.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"11":{"tf":1.0},"111":{"tf":2.0},"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.4142135623730951},"134":{"tf":1.0},"135":{"tf":1.0},"139":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"141":{"tf":1.0},"142":{"tf":1.0},"149":{"tf":1.7320508075688772},"16":{"tf":1.0},"163":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"166":{"tf":1.7320508075688772},"167":{"tf":2.23606797749979},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"173":{"tf":2.0},"175":{"tf":2.0},"178":{"tf":1.4142135623730951},"181":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.8284271247461903},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":4.69041575982343},"84":{"tf":1.4142135623730951},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":2.6457513110645907},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":17,"docs":{"108":{"tf":2.0},"112":{"tf":1.7320508075688772},"114":{"tf":3.1622776601683795},"115":{"tf":1.7320508075688772},"118":{"tf":3.4641016151377544},"139":{"tf":1.0},"147":{"tf":2.0},"172":{"tf":1.0},"174":{"tf":2.6457513110645907},"179":{"tf":3.872983346207417},"185":{"tf":2.6457513110645907},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"22":{"tf":2.0},"33":{"tf":1.7320508075688772},"91":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"124":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":124,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1.4142135623730951},"107":{"tf":2.449489742783178},"108":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"110":{"tf":3.1622776601683795},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":2.23606797749979},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"118":{"tf":2.6457513110645907},"119":{"tf":2.23606797749979},"120":{"tf":1.0},"122":{"tf":2.6457513110645907},"123":{"tf":1.4142135623730951},"124":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":3.0},"133":{"tf":2.0},"135":{"tf":2.0},"137":{"tf":1.4142135623730951},"139":{"tf":2.6457513110645907},"140":{"tf":1.0},"141":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":2.23606797749979},"152":{"tf":2.0},"153":{"tf":2.0},"154":{"tf":2.0},"156":{"tf":1.0},"157":{"tf":2.0},"160":{"tf":3.3166247903554},"161":{"tf":1.0},"162":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"172":{"tf":1.7320508075688772},"173":{"tf":1.0},"175":{"tf":2.8284271247461903},"176":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"181":{"tf":2.23606797749979},"187":{"tf":1.7320508075688772},"188":{"tf":2.0},"189":{"tf":1.4142135623730951},"19":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0},"195":{"tf":1.4142135623730951},"197":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":3.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.449489742783178},"46":{"tf":1.0},"47":{"tf":2.0},"49":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":3.4641016151377544},"70":{"tf":2.8284271247461903},"71":{"tf":3.1622776601683795},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.449489742783178},"79":{"tf":2.449489742783178},"80":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":2.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772},"94":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.449489742783178},"99":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"120":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"127":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.0},"168":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"110":{"tf":1.0},"3":{"tf":1.0},"71":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":17,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.0},"116":{"tf":1.4142135623730951},"135":{"tf":1.0},"146":{"tf":1.0},"175":{"tf":1.0},"30":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.0}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"116":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"144":{"tf":1.0},"49":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"185":{"tf":1.0},"2":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"173":{"tf":1.0},"191":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"114":{"tf":1.0},"71":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"129":{"tf":1.0},"167":{"tf":1.0},"181":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"110":{"tf":1.4142135623730951},"117":{"tf":1.0},"140":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.7320508075688772},"185":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"159":{"tf":1.0},"70":{"tf":2.23606797749979},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"3":{"tf":1.0},"42":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"195":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}},"d":{"df":1,"docs":{"63":{"tf":1.0}},"g":{"df":3,"docs":{"117":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"114":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"133":{"tf":1.0},"179":{"tf":1.0},"33":{"tf":3.1622776601683795},"87":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"114":{"tf":1.0}}},"8":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"114":{"tf":1.0}}},"4":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"106":{"tf":1.0},"111":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"116":{"tf":1.0},"156":{"tf":1.7320508075688772},"157":{"tf":1.4142135623730951},"180":{"tf":1.0},"190":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"104":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"178":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"129":{"tf":1.7320508075688772},"38":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.0},"78":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"153":{"tf":1.0},"154":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":25,"docs":{"10":{"tf":1.0},"112":{"tf":1.0},"134":{"tf":1.4142135623730951},"145":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"152":{"tf":1.0},"158":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"18":{"tf":1.0},"182":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":2.23606797749979},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"48":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":9,"docs":{"107":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"141":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"142":{"tf":1.7320508075688772},"63":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"142":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"151":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"147":{"tf":1.0},"157":{"tf":1.0},"35":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"141":{"tf":1.0},"49":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"192":{"tf":1.0},"4":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":4,"docs":{"104":{"tf":1.0},"121":{"tf":1.7320508075688772},"175":{"tf":1.0},"68":{"tf":1.0}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":1.0},"158":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"107":{"tf":1.0},"168":{"tf":1.0},"62":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":14,"docs":{"111":{"tf":1.7320508075688772},"120":{"tf":1.0},"129":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"147":{"tf":3.0},"179":{"tf":1.0},"185":{"tf":1.7320508075688772},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"105":{"tf":1.0},"157":{"tf":1.0},"171":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":12,"docs":{"105":{"tf":1.4142135623730951},"144":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"188":{"tf":1.4142135623730951},"48":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"99":{"tf":1.0}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"116":{"tf":1.0},"69":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"139":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"117":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"75":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"17":{"tf":1.0},"188":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":87,"docs":{"10":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":2.0},"109":{"tf":3.0},"110":{"tf":3.1622776601683795},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":2.6457513110645907},"126":{"tf":1.0},"127":{"tf":2.23606797749979},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":2.8284271247461903},"134":{"tf":2.0},"135":{"tf":3.3166247903554},"136":{"tf":1.0},"137":{"tf":2.449489742783178},"139":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"148":{"tf":1.0},"15":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.7320508075688772},"176":{"tf":1.0},"181":{"tf":3.4641016151377544},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"197":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"70":{"tf":3.0},"71":{"tf":2.8284271247461903},"73":{"tf":1.7320508075688772},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":3.605551275463989},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"120":{"tf":1.0},"13":{"tf":1.0},"159":{"tf":1.0},"160":{"tf":1.0},"193":{"tf":1.0},"63":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"151":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"107":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.7320508075688772},"18":{"tf":1.0},"22":{"tf":1.7320508075688772},"71":{"tf":1.0},"80":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.7320508075688772},"24":{"tf":1.0},"71":{"tf":1.4142135623730951},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":8,"docs":{"186":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"186":{"tf":2.0},"45":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"35":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"178":{"tf":1.0},"66":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"110":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"n":{"df":2,"docs":{"110":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"132":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.23606797749979},"105":{"tf":2.23606797749979},"175":{"tf":1.0},"193":{"tf":3.872983346207417},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":2.6457513110645907},"98":{"tf":2.23606797749979},"99":{"tf":1.0}},"’":{"df":1,"docs":{"193":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"113":{"tf":1.0},"65":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"118":{"tf":1.0},"149":{"tf":1.0},"31":{"tf":2.23606797749979},"82":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"149":{"tf":1.4142135623730951},"57":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":12,"docs":{"109":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"147":{"tf":1.0},"148":{"tf":1.0},"151":{"tf":1.0},"167":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"179":{"tf":1.0},"181":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":2.449489742783178},"91":{"tf":1.0}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}},"df":7,"docs":{"110":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"36":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"105":{"tf":1.7320508075688772},"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"114":{"tf":2.0},"121":{"tf":1.0},"127":{"tf":1.0},"147":{"tf":1.7320508075688772},"185":{"tf":2.0},"80":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"138":{"tf":1.0},"167":{"tf":1.0}}},"s":{"df":6,"docs":{"113":{"tf":1.0},"179":{"tf":2.23606797749979},"187":{"tf":1.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.7320508075688772}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":1,"docs":{"136":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":7,"docs":{"105":{"tf":1.7320508075688772},"106":{"tf":1.7320508075688772},"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"157":{"tf":1.4142135623730951},"83":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":70,"docs":{"114":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":2.0},"137":{"tf":1.0},"138":{"tf":2.0},"139":{"tf":1.7320508075688772},"140":{"tf":1.0},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":2.8284271247461903},"146":{"tf":2.0},"147":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.7320508075688772},"15":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":2.0},"157":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.4142135623730951},"186":{"tf":1.0},"187":{"tf":2.0},"188":{"tf":1.4142135623730951},"189":{"tf":2.8284271247461903},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"193":{"tf":1.4142135623730951},"194":{"tf":1.7320508075688772},"195":{"tf":1.0},"42":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"82":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"(":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"_":{"a":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"=":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"188":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"157":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"117":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":6,"docs":{"101":{"tf":1.0},"135":{"tf":1.0},"150":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"97":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":10,"docs":{"104":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":2.449489742783178},"148":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":39,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"159":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"166":{"tf":1.7320508075688772},"169":{"tf":1.0},"173":{"tf":2.23606797749979},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.7320508075688772},"181":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"70":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"135":{"tf":1.0},"139":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"67":{"tf":2.0},"68":{"tf":1.7320508075688772}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"195":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}},"d":{"df":9,"docs":{"118":{"tf":1.0},"137":{"tf":1.0},"14":{"tf":1.0},"142":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"185":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":18,"docs":{"101":{"tf":2.0},"110":{"tf":2.0},"135":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.4142135623730951},"167":{"tf":1.0},"181":{"tf":1.0},"184":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"89":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"125":{"tf":1.0},"2":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":63,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"134":{"tf":1.0},"139":{"tf":1.0},"14":{"tf":1.4142135623730951},"146":{"tf":1.0},"15":{"tf":2.0},"158":{"tf":1.7320508075688772},"16":{"tf":2.23606797749979},"160":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"166":{"tf":1.4142135623730951},"167":{"tf":2.6457513110645907},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"180":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.7320508075688772},"185":{"tf":1.0},"186":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"8":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":63,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":2.23606797749979},"105":{"tf":2.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":3.4641016151377544},"111":{"tf":3.0},"113":{"tf":1.7320508075688772},"114":{"tf":3.605551275463989},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":2.23606797749979},"122":{"tf":1.7320508075688772},"123":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":2.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"139":{"tf":1.0},"141":{"tf":1.4142135623730951},"147":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"176":{"tf":1.7320508075688772},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"83":{"tf":2.8284271247461903},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":2,"docs":{"61":{"tf":1.0},"65":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}},"s":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":21,"docs":{"102":{"tf":1.0},"104":{"tf":1.4142135623730951},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"142":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.4142135623730951},"22":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"82":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"173":{"tf":1.0}}}},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}},"9":{"df":2,"docs":{"128":{"tf":1.0},"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"2":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"102":{"tf":1.0}}},"2":{"df":1,"docs":{"102":{"tf":1.0}}},"3":{"df":1,"docs":{"102":{"tf":1.0}}},"4":{"df":1,"docs":{"102":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"181":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":24,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":2.6457513110645907},"105":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":2.449489742783178},"115":{"tf":1.7320508075688772},"117":{"tf":1.7320508075688772},"121":{"tf":2.6457513110645907},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":2.0},"190":{"tf":1.4142135623730951},"193":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"97":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":3.1622776601683795},"78":{"tf":1.0}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":7,"docs":{"109":{"tf":1.0},"118":{"tf":1.0},"143":{"tf":1.0},"168":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"148":{"tf":1.0},"193":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"t":{"=":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}}},"df":7,"docs":{"176":{"tf":1.4142135623730951},"177":{"tf":2.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"180":{"tf":1.0},"188":{"tf":1.0},"41":{"tf":2.23606797749979}}}},"df":8,"docs":{"127":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"117":{"tf":1.0},"124":{"tf":1.0},"157":{"tf":1.0},"181":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"117":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"60":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"193":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"198":{"tf":1.0},"70":{"tf":2.449489742783178},"74":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"109":{"tf":1.0},"18":{"tf":1.0},"57":{"tf":1.0}},"i":{"df":3,"docs":{"103":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":30,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"133":{"tf":1.4142135623730951},"146":{"tf":1.4142135623730951},"150":{"tf":1.4142135623730951},"181":{"tf":1.7320508075688772},"2":{"tf":2.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":2.23606797749979},"63":{"tf":3.0},"65":{"tf":2.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.6457513110645907},"80":{"tf":1.0},"83":{"tf":1.0},"95":{"tf":1.4142135623730951}},"’":{"df":2,"docs":{"2":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"150":{"tf":1.0},"157":{"tf":2.6457513110645907}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":11,"docs":{"114":{"tf":1.0},"124":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"188":{"tf":2.23606797749979},"189":{"tf":2.449489742783178},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772}}}}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"146":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0}}}}},"df":1,"docs":{"106":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"50":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":51,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.4142135623730951},"139":{"tf":1.0},"143":{"tf":1.0},"152":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":2.0},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":2.0},"18":{"tf":1.0},"181":{"tf":1.4142135623730951},"182":{"tf":2.23606797749979},"186":{"tf":2.23606797749979},"187":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.23606797749979},"30":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":3.1622776601683795},"74":{"tf":1.0},"83":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"i":{"c":{":":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":3,"docs":{"173":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"198":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"179":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}},"n":{"df":19,"docs":{"105":{"tf":1.4142135623730951},"113":{"tf":1.0},"135":{"tf":1.7320508075688772},"139":{"tf":1.0},"143":{"tf":1.0},"147":{"tf":1.0},"150":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"173":{"tf":1.0},"181":{"tf":1.0},"189":{"tf":1.0},"33":{"tf":1.4142135623730951},"46":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":2,"docs":{"101":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"115":{"tf":1.0},"23":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}},"df":3,"docs":{"142":{"tf":1.0},"55":{"tf":1.4142135623730951},"78":{"tf":1.0}},"e":{"df":3,"docs":{"70":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"o":{"d":{"df":12,"docs":{"104":{"tf":1.0},"169":{"tf":1.0},"191":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"189":{"tf":1.0},"196":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"173":{"tf":1.0},"65":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"144":{"tf":1.0},"147":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"124":{"tf":1.0},"198":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"198":{"tf":1.0},"81":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"128":{"tf":2.0}}},"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}},"l":{"df":4,"docs":{"111":{"tf":1.0},"159":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}}}},"r":{"d":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":2,"docs":{"10":{"tf":1.4142135623730951},"110":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"176":{"tf":1.0},"187":{"tf":1.0}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}}}}}},"df":1,"docs":{"8":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"1":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":1,"docs":{"26":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"116":{"tf":1.0}}}},"p":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"155":{"tf":1.0}}}}}}},"df":19,"docs":{"114":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"127":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"132":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"8":{"tf":2.6457513110645907},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"144":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":18,"docs":{"110":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"160":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"5":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951}},"’":{"df":8,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"110":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"135":{"tf":1.0},"160":{"tf":2.8284271247461903},"188":{"tf":1.0},"189":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.7320508075688772},"98":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"110":{"tf":2.23606797749979},"112":{"tf":1.0},"144":{"tf":1.0},"189":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"140":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"139":{"tf":1.0},"173":{"tf":1.0},"23":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"\'":{".":{".":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"85":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":19,"docs":{"0":{"tf":1.0},"128":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"167":{"tf":2.0},"173":{"tf":1.7320508075688772},"180":{"tf":2.0},"186":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.449489742783178},"27":{"tf":2.449489742783178},"28":{"tf":2.449489742783178},"35":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"124":{"tf":1.0},"142":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}}}}}}},"i":{".":{"df":3,"docs":{"157":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0}}},"3":{"2":{"df":3,"docs":{"131":{"tf":1.7320508075688772},"5":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"160":{"tf":1.0},"82":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"107":{"tf":1.0},"111":{"tf":1.0}},"l":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":2.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"117":{"tf":1.0},"3":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"106":{"tf":1.0},"191":{"tf":1.0}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":13,"docs":{"101":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":3.7416573867739413},"117":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"20":{"tf":1.0},"25":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"189":{"tf":1.0},"191":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":8,"docs":{"148":{"tf":1.0},"175":{"tf":1.7320508075688772},"179":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"df":15,"docs":{"103":{"tf":1.4142135623730951},"111":{"tf":1.0},"150":{"tf":2.0},"151":{"tf":1.4142135623730951},"157":{"tf":1.7320508075688772},"175":{"tf":1.0},"181":{"tf":1.0},"191":{"tf":1.0},"35":{"tf":1.0},"44":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":2.23606797749979},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"185":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"148":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":37,"docs":{"103":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.449489742783178},"13":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.7320508075688772},"137":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"159":{"tf":2.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"165":{"tf":1.0},"166":{"tf":1.0},"181":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\\"":{".":{".":{"/":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":2.23606797749979}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":5,"docs":{"147":{"tf":1.0},"169":{"tf":2.449489742783178},"170":{"tf":2.23606797749979},"173":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":4,"docs":{"116":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":3,"docs":{"119":{"tf":1.0},"63":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"119":{"tf":1.0},"157":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"44":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":19,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.4142135623730951},"157":{"tf":1.0},"165":{"tf":1.0},"176":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.7320508075688772},"188":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"175":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":2.449489742783178},"131":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"70":{"tf":1.0},"93":{"tf":2.23606797749979},"97":{"tf":1.4142135623730951},"98":{"tf":3.0},"99":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"105":{"tf":1.0},"4":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":2.8284271247461903},"37":{"tf":2.0},"41":{"tf":2.449489742783178},"59":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"109":{"tf":1.4142135623730951},"133":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"161":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"/":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":23,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"164":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"183":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"37":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"124":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"116":{"tf":2.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"95":{"tf":1.0}},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"124":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0},"157":{"tf":1.0},"168":{"tf":1.0},"181":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.0},"97":{"tf":1.0}}}}},"f":{"a":{"c":{"df":7,"docs":{"150":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":2.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":8,"docs":{"151":{"tf":1.7320508075688772},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"168":{"tf":1.0},"3":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"147":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":9,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"122":{"tf":1.0},"197":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"124":{"tf":1.0},"157":{"tf":1.0},"70":{"tf":1.0}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"140":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"119":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"159":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"45":{"tf":1.0},"83":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"150":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"188":{"tf":2.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":1.0}}},"s":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"63":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":16,"docs":{"150":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"161":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.0},"88":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"\'":{"df":1,"docs":{"188":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":1,"docs":{"193":{"tf":1.0}}},"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"189":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":56,"docs":{"100":{"tf":1.0},"101":{"tf":2.0},"102":{"tf":2.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"105":{"tf":2.23606797749979},"106":{"tf":1.7320508075688772},"118":{"tf":2.449489742783178},"121":{"tf":1.4142135623730951},"122":{"tf":3.0},"123":{"tf":1.0},"126":{"tf":1.4142135623730951},"13":{"tf":3.605551275463989},"133":{"tf":1.4142135623730951},"135":{"tf":2.0},"139":{"tf":2.0},"141":{"tf":1.7320508075688772},"148":{"tf":2.0},"160":{"tf":4.242640687119285},"164":{"tf":2.0},"175":{"tf":3.7416573867739413},"176":{"tf":2.0},"181":{"tf":2.0},"187":{"tf":2.23606797749979},"188":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"193":{"tf":2.449489742783178},"195":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":3.0},"47":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"65":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":1.0}},"’":{"df":4,"docs":{"189":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"’":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"df":4,"docs":{"150":{"tf":1.0},"52":{"tf":1.0},"63":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"101":{"tf":1.4142135623730951},"119":{"tf":1.0},"144":{"tf":1.0},"175":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"98":{"tf":1.0}}}}}},"’":{"df":17,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.4142135623730951},"143":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"174":{"tf":1.0},"191":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"116":{"tf":1.0},"166":{"tf":1.0},"173":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"0":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"176":{"tf":2.449489742783178},"178":{"tf":2.8284271247461903},"179":{"tf":1.4142135623730951}}}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"182":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"110":{"tf":1.0},"150":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"46":{"tf":1.0},"57":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"153":{"tf":2.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"110":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"187":{"tf":1.0},"196":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":2,"docs":{"16":{"tf":1.0},"71":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"59":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"109":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"124":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"/":{"?":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"=":{"%":{"df":1,"docs":{"142":{"tf":1.0}},"s":{"&":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"163":{"tf":1.4142135623730951},"29":{"tf":1.0},"5":{"tf":1.0},"78":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"107":{"tf":1.0},"116":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"145":{"tf":1.0},"52":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"159":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"165":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":2,"docs":{"14":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":3,"docs":{"109":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"197":{"tf":1.0}}}},"v":{"df":3,"docs":{"63":{"tf":1.4142135623730951},"69":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":8,"docs":{"109":{"tf":1.0},"132":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"86":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":8,"docs":{"12":{"tf":1.0},"142":{"tf":1.0},"17":{"tf":1.0},"32":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0}},"’":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"71":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"169":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"189":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"175":{"tf":1.0},"70":{"tf":1.0}}}},":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"97":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":22,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"133":{"tf":1.0},"14":{"tf":2.0},"142":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"181":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"y":{"df":0,"docs":{},"’":{"df":2,"docs":{"36":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"166":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"166":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"51":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"111":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.0},"185":{"tf":1.0},"66":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":54,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"146":{"tf":1.0},"15":{"tf":1.0},"158":{"tf":2.0},"16":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"179":{"tf":2.0},"18":{"tf":1.0},"185":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":2.8284271247461903},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"70":{"tf":2.6457513110645907},"71":{"tf":2.0},"73":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":35,"docs":{"101":{"tf":1.0},"102":{"tf":3.3166247903554},"103":{"tf":2.449489742783178},"104":{"tf":2.23606797749979},"105":{"tf":3.4641016151377544},"106":{"tf":2.449489742783178},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"121":{"tf":2.6457513110645907},"122":{"tf":2.6457513110645907},"130":{"tf":1.7320508075688772},"132":{"tf":2.6457513110645907},"135":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.0},"173":{"tf":1.0},"182":{"tf":2.23606797749979},"197":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":2.0},"90":{"tf":1.0},"93":{"tf":1.7320508075688772},"98":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"5":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"6":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"5":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"5":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":19,"docs":{"109":{"tf":1.0},"120":{"tf":2.8284271247461903},"121":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"123":{"tf":2.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"172":{"tf":1.0},"175":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"79":{"tf":2.0}},"s":{"=":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"115":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":29,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.7320508075688772},"151":{"tf":1.0},"170":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"191":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.8284271247461903},"7":{"tf":1.0},"76":{"tf":2.0},"8":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"110":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"125":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"a":{"d":{"df":5,"docs":{"159":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"167":{"tf":1.7320508075688772},"89":{"tf":1.0}}},"t":{"df":10,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"17":{"tf":2.0},"173":{"tf":1.0},"179":{"tf":1.4142135623730951},"189":{"tf":1.0},"190":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":3,"docs":{"155":{"tf":2.6457513110645907},"47":{"tf":1.0},"86":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"191":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"185":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":61,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"141":{"tf":1.0},"15":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"p":{"df":1,"docs":{"114":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"173":{"tf":1.0}}},"u":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"65":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}},"o":{"df":1,"docs":{"193":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":4,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"110":{"tf":1.0},"113":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"109":{"tf":1.0},"113":{"tf":1.7320508075688772}}}}},"df":15,"docs":{"104":{"tf":3.0},"105":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.7320508075688772},"119":{"tf":1.0},"186":{"tf":2.23606797749979},"47":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"140":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"116":{"tf":2.0}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":60,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":2.0},"110":{"tf":2.8284271247461903},"111":{"tf":2.449489742783178},"113":{"tf":2.0},"114":{"tf":2.6457513110645907},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.4142135623730951},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":1.4142135623730951},"185":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":22,"docs":{"107":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"139":{"tf":1.4142135623730951},"155":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":4,"docs":{"112":{"tf":1.0},"175":{"tf":1.0},"196":{"tf":1.0},"46":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"111":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"159":{"tf":1.0},"171":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":15,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"161":{"tf":2.6457513110645907},"162":{"tf":2.6457513110645907},"163":{"tf":2.23606797749979},"169":{"tf":1.0},"25":{"tf":2.449489742783178},"29":{"tf":2.0},"30":{"tf":2.0},"41":{"tf":1.7320508075688772},"5":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}},"df":5,"docs":{"127":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.0},"181":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"129":{"tf":1.0},"150":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"151":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"135":{"tf":1.0},"142":{"tf":1.4142135623730951},"145":{"tf":1.0},"153":{"tf":1.0},"167":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":4.0},"65":{"tf":2.449489742783178},"66":{"tf":3.1622776601683795},"75":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"113":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"192":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":19,"docs":{"10":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":2,"docs":{"131":{"tf":1.0},"143":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":2.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"163":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0}}}}}},"u":{"df":3,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"114":{"tf":2.23606797749979},"159":{"tf":1.7320508075688772},"192":{"tf":1.0},"193":{"tf":1.7320508075688772}},"e":{"=":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":9,"docs":{"104":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.7320508075688772},"175":{"tf":1.0},"53":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":1.0}}}}}},"’":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":1,"docs":{"127":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":4,"docs":{"104":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"79":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"124":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"120":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"175":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"175":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{"df":22,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.0},"126":{"tf":1.0},"13":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":1.0}},"e":{"df":4,"docs":{"10":{"tf":1.0},"146":{"tf":1.0},"159":{"tf":1.0},"35":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"166":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":18,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"124":{"tf":1.0},"148":{"tf":1.0},"164":{"tf":2.449489742783178},"187":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"192":{"tf":1.7320508075688772},"47":{"tf":1.0},"59":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"93":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":41,"docs":{"10":{"tf":1.7320508075688772},"107":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"117":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"150":{"tf":1.0},"151":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"19":{"tf":1.0},"195":{"tf":1.0},"197":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.7320508075688772},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"66":{"tf":1.0},"88":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"49":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"114":{"tf":1.0},"169":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"115":{"tf":1.4142135623730951},"141":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.7320508075688772},"184":{"tf":1.0},"185":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"83":{"tf":1.0},"98":{"tf":1.0}}}}}}},"t":{"df":5,"docs":{"111":{"tf":2.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"179":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":30,"docs":{"102":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":2.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":1.0},"12":{"tf":3.0},"121":{"tf":1.0},"141":{"tf":1.0},"16":{"tf":1.0},"164":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":2.6457513110645907},"179":{"tf":1.7320508075688772},"2":{"tf":2.23606797749979},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"44":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"63":{"tf":2.23606797749979},"65":{"tf":1.4142135623730951},"66":{"tf":2.23606797749979},"67":{"tf":1.7320508075688772},"97":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"104":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":5,"docs":{"142":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"179":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"145":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":17,"docs":{"102":{"tf":1.0},"110":{"tf":2.23606797749979},"113":{"tf":1.4142135623730951},"118":{"tf":1.7320508075688772},"125":{"tf":1.0},"14":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.0},"166":{"tf":1.0},"18":{"tf":1.4142135623730951},"191":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"118":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"184":{"tf":1.0},"63":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"114":{"tf":1.0},"189":{"tf":1.0},"193":{"tf":1.0},"66":{"tf":1.0}}}}},"w":{"df":10,"docs":{"1":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"124":{"tf":1.0},"145":{"tf":1.0},"159":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"150":{"tf":1.0},"189":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"125":{"tf":1.0},"145":{"tf":1.0},"146":{"tf":1.7320508075688772},"147":{"tf":1.0},"156":{"tf":1.7320508075688772},"159":{"tf":1.4142135623730951},"178":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"179":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\\"":{":":{"df":0,"docs":{},"{":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\\"":{":":{"3":{",":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\\"":{":":{"1":{",":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\\"":{":":{"3":{",":{"\\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\\"":{":":{"0":{"df":1,"docs":{"176":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"193":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"192":{"tf":1.4142135623730951},"193":{"tf":1.0}}}}}}},"df":6,"docs":{"13":{"tf":1.0},"144":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"188":{"tf":1.0},"192":{"tf":1.0},"62":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"143":{"tf":1.0},"179":{"tf":1.0}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":2.449489742783178}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":2.0}}}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"139":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":30,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":2.449489742783178},"123":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.7320508075688772},"139":{"tf":1.0},"142":{"tf":1.0},"143":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"185":{"tf":1.4142135623730951},"24":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"h":{"df":5,"docs":{"189":{"tf":1.4142135623730951},"4":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":6,"docs":{"2":{"tf":1.4142135623730951},"79":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":1,"docs":{"179":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"147":{"tf":2.449489742783178},"164":{"tf":1.0},"179":{"tf":1.0},"56":{"tf":1.7320508075688772},"63":{"tf":1.0},"74":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"o":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"j":{":":{":":{"d":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"95":{"tf":2.0}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"11":{"tf":1.7320508075688772},"176":{"tf":1.0},"3":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"151":{"tf":1.0},"155":{"tf":1.0},"163":{"tf":1.0},"197":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":4,"docs":{"111":{"tf":1.7320508075688772},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"80":{"tf":1.0}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"195":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":4,"docs":{"140":{"tf":1.4142135623730951},"173":{"tf":1.0},"187":{"tf":1.0},"61":{"tf":1.0}}},"df":26,"docs":{"104":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"127":{"tf":1.0},"135":{"tf":1.4142135623730951},"144":{"tf":2.0},"150":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"191":{"tf":1.0},"24":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.7320508075688772},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":2.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"142":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"175":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":2.6457513110645907}}},"r":{"df":7,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"146":{"tf":1.0},"149":{"tf":1.0},"35":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"105":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"a":{"df":1,"docs":{"66":{"tf":1.0}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"61":{"tf":2.23606797749979},"66":{"tf":1.7320508075688772}}},"u":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":36,"docs":{"102":{"tf":1.4142135623730951},"118":{"tf":1.0},"134":{"tf":1.4142135623730951},"147":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.4142135623730951},"175":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"180":{"tf":1.0},"181":{"tf":1.7320508075688772},"184":{"tf":1.7320508075688772},"185":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.0},"38":{"tf":1.7320508075688772},"48":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"164":{"tf":1.0},"185":{"tf":1.0},"4":{"tf":1.0},"63":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"164":{"tf":1.0},"167":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"105":{"tf":1.0},"132":{"tf":1.0},"179":{"tf":1.0},"93":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"116":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":7,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"118":{"tf":1.0},"143":{"tf":1.0},"144":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"113":{"tf":1.0},"139":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":2.6457513110645907},"175":{"tf":1.0},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"196":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":2.0},"65":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"181":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":53,"docs":{"10":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":2.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"119":{"tf":1.0},"166":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"171":{"tf":2.0},"173":{"tf":1.7320508075688772},"176":{"tf":2.0},"177":{"tf":2.0},"178":{"tf":1.4142135623730951},"179":{"tf":2.0},"180":{"tf":1.4142135623730951},"181":{"tf":1.7320508075688772},"195":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"138":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"117":{"tf":1.0},"145":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"189":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":6,"docs":{"115":{"tf":1.0},"12":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":2,"docs":{"124":{"tf":1.0},"135":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"114":{"tf":1.0},"135":{"tf":1.4142135623730951},"138":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"151":{"tf":1.0},"155":{"tf":1.0},"157":{"tf":1.4142135623730951},"164":{"tf":1.7320508075688772},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":2.8284271247461903},"170":{"tf":2.23606797749979},"173":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.7320508075688772},"24":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":2.449489742783178},"8":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"113":{"tf":1.0}}}}}}}}},"df":5,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"127":{"tf":2.0},"71":{"tf":2.23606797749979}},"k":{"df":1,"docs":{"108":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"103":{"tf":2.0},"142":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":3.1622776601683795},"65":{"tf":1.0},"66":{"tf":3.3166247903554},"87":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"68":{"tf":2.449489742783178}},"t":{"df":4,"docs":{"187":{"tf":1.0},"192":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.0}},"i":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"129":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"80":{"tf":1.0}}}}}}}}}}}},"t":{"df":14,"docs":{"110":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"143":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":2.8284271247461903},"166":{"tf":1.0},"18":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"119":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"10":{"tf":1.0},"108":{"tf":1.7320508075688772},"118":{"tf":1.0},"122":{"tf":1.7320508075688772},"139":{"tf":1.0},"14":{"tf":1.0},"140":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":2.449489742783178},"195":{"tf":3.0},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"31":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0}}},"t":{"df":2,"docs":{"195":{"tf":1.0},"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":2,"docs":{"183":{"tf":1.0},"184":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":2.0},"17":{"tf":1.4142135623730951},"173":{"tf":2.0},"179":{"tf":1.0},"181":{"tf":1.7320508075688772},"22":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.449489742783178},"44":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"175":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"173":{"tf":1.4142135623730951},"38":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":5,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"132":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"35":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":2.23606797749979}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"147":{"tf":1.0}}},"df":0,"docs":{}},"n":{"<":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.0},"167":{"tf":1.4142135623730951},"191":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"147":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"139":{"tf":2.0},"140":{"tf":1.7320508075688772},"191":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"163":{"tf":3.605551275463989},"29":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"163":{"tf":1.0},"196":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"49":{"tf":1.0},"88":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"124":{"tf":1.0},"3":{"tf":1.0},"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"157":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"118":{"tf":1.0},"187":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":1,"docs":{"109":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"51":{"tf":2.23606797749979},"80":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"104":{"tf":1.4142135623730951},"121":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"139":{"tf":1.0},"163":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"63":{"tf":1.4142135623730951},"83":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"110":{"tf":1.0},"115":{"tf":1.0},"139":{"tf":1.0}}}}},"s":{"df":2,"docs":{"49":{"tf":1.7320508075688772},"87":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.7320508075688772},"110":{"tf":1.0},"151":{"tf":1.0},"189":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"114":{"tf":1.0},"131":{"tf":1.0},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":1.0},"191":{"tf":1.0},"24":{"tf":1.0},"96":{"tf":1.0}},"s":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"150":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"156":{"tf":1.0},"157":{"tf":1.0}}}}}}},"df":1,"docs":{"104":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"152":{"tf":2.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"65":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"175":{"tf":1.0},"36":{"tf":1.0},"71":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"79":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"125":{"tf":1.0}}},"{":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"110":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}}}},"v":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"6":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"112":{"tf":1.0},"118":{"tf":1.4142135623730951},"122":{"tf":3.872983346207417},"126":{"tf":2.0},"13":{"tf":2.6457513110645907},"144":{"tf":1.0},"160":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"126":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"98":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"111":{"tf":1.0},"114":{"tf":1.0},"139":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"178":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"109":{"tf":1.7320508075688772},"114":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"156":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"195":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"110":{"tf":1.0},"183":{"tf":2.0},"184":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"71":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"63":{"tf":1.0},"66":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"155":{"tf":1.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"122":{"tf":1.0},"147":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"144":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":19,"docs":{"120":{"tf":1.4142135623730951},"124":{"tf":1.0},"139":{"tf":1.4142135623730951},"152":{"tf":1.0},"157":{"tf":1.0},"163":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"17":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"183":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":38,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.6457513110645907},"102":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"116":{"tf":1.7320508075688772},"118":{"tf":1.7320508075688772},"121":{"tf":2.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"139":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"179":{"tf":1.0},"185":{"tf":1.0},"188":{"tf":1.4142135623730951},"189":{"tf":2.6457513110645907},"190":{"tf":2.0},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"193":{"tf":2.449489742783178},"2":{"tf":1.0},"63":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"93":{"tf":3.605551275463989},"95":{"tf":1.7320508075688772},"97":{"tf":2.8284271247461903},"98":{"tf":3.872983346207417},"99":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"98":{"tf":2.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":17,"docs":{"100":{"tf":1.0},"118":{"tf":1.7320508075688772},"122":{"tf":2.449489742783178},"13":{"tf":2.449489742783178},"133":{"tf":1.0},"143":{"tf":1.4142135623730951},"144":{"tf":2.23606797749979},"160":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"45":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"81":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":2.6457513110645907},"99":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"196":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"157":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}}},"t":{"df":8,"docs":{"110":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"142":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":3.0},"65":{"tf":1.0},"68":{"tf":1.7320508075688772},"87":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"158":{"tf":1.4142135623730951},"57":{"tf":1.0},"69":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"43":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.0},"141":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.7320508075688772}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"111":{"tf":1.0},"71":{"tf":1.0}}}},"w":{"df":1,"docs":{"83":{"tf":1.0}}}},"c":{"df":1,"docs":{"64":{"tf":1.0}}},"d":{"_":{"(":{"\\"":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"159":{"tf":1.0}},"f":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"2":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"41":{"tf":1.4142135623730951},"83":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}},"d":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":32,"docs":{"107":{"tf":1.0},"144":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":2.6457513110645907},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"135":{"tf":1.0},"182":{"tf":1.0},"188":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}},"m":{"df":1,"docs":{"118":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"18":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":2,"docs":{"188":{"tf":1.0},"70":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"150":{"tf":1.0},"189":{"tf":1.0},"65":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"175":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}}}},"df":13,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":2.23606797749979},"105":{"tf":2.23606797749979},"175":{"tf":1.0},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"193":{"tf":4.0},"2":{"tf":1.0},"93":{"tf":1.7320508075688772},"94":{"tf":1.0},"97":{"tf":2.6457513110645907},"98":{"tf":2.23606797749979},"99":{"tf":1.0}},"f":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"196":{"tf":2.0},"197":{"tf":1.4142135623730951},"198":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"142":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"139":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"139":{"tf":1.0},"143":{"tf":1.0},"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"108":{"tf":1.4142135623730951},"118":{"tf":1.0},"18":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\\"":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.0}}}},"df":3,"docs":{"101":{"tf":1.0},"105":{"tf":1.0},"119":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"114":{"tf":1.4142135623730951},"145":{"tf":1.4142135623730951},"146":{"tf":1.0},"195":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"110":{"tf":1.0}}}},"i":{"df":2,"docs":{"3":{"tf":1.0},"71":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"118":{"tf":1.0},"24":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"132":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"166":{"tf":1.0},"173":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"104":{"tf":1.0},"106":{"tf":1.4142135623730951},"110":{"tf":1.0},"116":{"tf":1.0},"161":{"tf":2.0},"162":{"tf":2.0},"163":{"tf":1.7320508075688772},"166":{"tf":1.0},"187":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"1":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}}},"r":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"144":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"143":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"179":{"tf":1.0},"66":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"143":{"tf":2.0},"144":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"196":{"tf":1.0},"24":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"r":{"df":10,"docs":{"145":{"tf":1.0},"146":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"163":{"tf":1.0},"185":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"189":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":7,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.6457513110645907},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"63":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"155":{"tf":1.4142135623730951},"166":{"tf":1.7320508075688772},"173":{"tf":1.0},"196":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":1.0},"139":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":5,"docs":{"118":{"tf":1.0},"138":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}}}},"i":{"3":{"2":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"111":{"tf":1.7320508075688772}}},"u":{"3":{"2":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"8":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"63":{"tf":2.0}}},"df":0,"docs":{}}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}}},"df":23,"docs":{"108":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"132":{"tf":1.0},"142":{"tf":1.7320508075688772},"147":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"55":{"tf":2.0},"59":{"tf":2.449489742783178},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":17,"docs":{"108":{"tf":1.0},"111":{"tf":2.0},"116":{"tf":2.0},"132":{"tf":1.0},"150":{"tf":1.0},"179":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"68":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"181":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"190":{"tf":1.0}}}}}}},"f":{"c":{"df":3,"docs":{"181":{"tf":1.0},"197":{"tf":1.4142135623730951},"198":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"132":{"tf":1.4142135623730951},"142":{"tf":1.0},"189":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"195":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"105":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":2.0},"173":{"tf":2.23606797749979},"176":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0},"2":{"tf":1.0},"32":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"47":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}},"’":{"df":1,"docs":{"36":{"tf":1.0}}}}},"w":{"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"df":1,"docs":{"12":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":11,"docs":{"101":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"157":{"tf":1.0},"175":{"tf":1.0},"191":{"tf":1.0},"35":{"tf":1.4142135623730951},"69":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"n":{"df":28,"docs":{"1":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":2.8284271247461903},"119":{"tf":2.6457513110645907},"120":{"tf":1.0},"127":{"tf":1.0},"135":{"tf":1.0},"140":{"tf":1.4142135623730951},"163":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.7320508075688772},"179":{"tf":1.0},"18":{"tf":1.7320508075688772},"185":{"tf":1.7320508075688772},"19":{"tf":2.0},"195":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":2.6457513110645907},"29":{"tf":1.0},"40":{"tf":1.4142135623730951},"79":{"tf":1.0},"87":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"20":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":3.1622776601683795}}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":1,"docs":{"155":{"tf":1.0}}}}},"c":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"152":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":15,"docs":{"120":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"165":{"tf":1.0},"168":{"tf":1.0},"18":{"tf":2.23606797749979},"183":{"tf":1.7320508075688772},"184":{"tf":2.0},"185":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":148,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.0},"10":{"tf":2.23606797749979},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":2.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"120":{"tf":2.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"135":{"tf":2.0},"139":{"tf":1.7320508075688772},"14":{"tf":2.0},"140":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"144":{"tf":1.0},"145":{"tf":1.0},"15":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"158":{"tf":1.7320508075688772},"159":{"tf":2.6457513110645907},"16":{"tf":1.0},"160":{"tf":1.4142135623730951},"161":{"tf":2.0},"162":{"tf":2.0},"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":2.23606797749979},"168":{"tf":1.4142135623730951},"17":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":2.0},"179":{"tf":2.0},"18":{"tf":2.8284271247461903},"181":{"tf":2.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"19":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.0},"195":{"tf":1.4142135623730951},"196":{"tf":1.0},"197":{"tf":1.0},"2":{"tf":2.8284271247461903},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":2.8284271247461903},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"158":{"tf":1.0}}}},"df":0,"docs":{}}},"’":{"df":11,"docs":{"11":{"tf":1.0},"118":{"tf":1.0},"173":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":39,"docs":{"0":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"114":{"tf":2.0},"116":{"tf":2.8284271247461903},"117":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":3.0},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"145":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":2.0},"163":{"tf":1.7320508075688772},"169":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"18":{"tf":1.0},"197":{"tf":1.7320508075688772},"198":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"144":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"178":{"tf":1.7320508075688772}}}},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":31,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"131":{"tf":2.0},"132":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"15":{"tf":1.0},"155":{"tf":1.0},"16":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.7320508075688772},"173":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"18":{"tf":1.0},"187":{"tf":1.0},"188":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"80":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.0},"147":{"tf":1.4142135623730951},"61":{"tf":1.0},"79":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"121":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"103":{"tf":1.0},"105":{"tf":2.23606797749979}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":7,"docs":{"133":{"tf":2.0},"134":{"tf":2.0},"135":{"tf":1.0},"136":{"tf":1.0},"137":{"tf":1.0},"155":{"tf":1.0},"181":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":2.0},"159":{"tf":1.0}}}}}}},"df":7,"docs":{"105":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"142":{"tf":1.0},"193":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":23,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"141":{"tf":2.23606797749979},"142":{"tf":2.449489742783178},"17":{"tf":1.0},"173":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"55":{"tf":2.0},"58":{"tf":2.23606797749979},"59":{"tf":2.6457513110645907},"60":{"tf":2.23606797749979},"61":{"tf":2.23606797749979},"62":{"tf":2.0},"63":{"tf":3.3166247903554},"64":{"tf":1.0},"65":{"tf":2.23606797749979},"66":{"tf":3.0},"67":{"tf":2.449489742783178},"68":{"tf":2.6457513110645907},"71":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"101":{"tf":1.7320508075688772},"113":{"tf":1.0},"2":{"tf":1.4142135623730951},"63":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":12,"docs":{"111":{"tf":1.0},"117":{"tf":1.4142135623730951},"145":{"tf":1.0},"165":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.7320508075688772},"49":{"tf":1.0},"54":{"tf":1.0},"71":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":29,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"140":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":1.0},"19":{"tf":1.4142135623730951},"193":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"3":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"m":{"df":1,"docs":{"144":{"tf":1.0}}},"n":{"df":4,"docs":{"139":{"tf":1.0},"175":{"tf":1.4142135623730951},"24":{"tf":1.0},"52":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"167":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"101":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"63":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"157":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"119":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}},"df":1,"docs":{"68":{"tf":3.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"111":{"tf":1.0},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"191":{"tf":1.0}}}},"t":{"df":18,"docs":{"107":{"tf":1.0},"110":{"tf":2.0},"118":{"tf":1.0},"139":{"tf":1.0},"159":{"tf":1.0},"167":{"tf":1.0},"24":{"tf":2.23606797749979},"50":{"tf":2.23606797749979},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"155":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"110":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"145":{"tf":1.0},"151":{"tf":1.7320508075688772},"166":{"tf":1.0},"72":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"178":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"159":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"49":{"tf":1.7320508075688772},"57":{"tf":2.23606797749979},"70":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"71":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.0},"127":{"tf":1.4142135623730951},"179":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"189":{"tf":1.0},"190":{"tf":1.0}}},"df":0,"docs":{}}}},"df":28,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":2.23606797749979},"113":{"tf":1.0},"114":{"tf":1.0},"13":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"141":{"tf":1.0},"143":{"tf":1.0},"150":{"tf":1.0},"155":{"tf":1.0},"160":{"tf":1.4142135623730951},"165":{"tf":2.0},"175":{"tf":1.7320508075688772},"178":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":6,"docs":{"101":{"tf":1.0},"13":{"tf":1.0},"135":{"tf":1.4142135623730951},"160":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"157":{"tf":1.0},"43":{"tf":1.0},"73":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"44":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":2.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.0},"184":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"74":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"144":{"tf":1.0},"173":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"181":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"z":{"df":0,"docs":{},"e":{"df":3,"docs":{"135":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"165":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"65":{"tf":2.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"159":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"109":{"tf":1.4142135623730951},"74":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"133":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"147":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":10,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"139":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"110":{"tf":1.0},"118":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":2.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"135":{"tf":1.0},"164":{"tf":2.6457513110645907}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":10,"docs":{"110":{"tf":1.0},"135":{"tf":1.4142135623730951},"164":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.7320508075688772},"186":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"41":{"tf":1.0},"44":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":4,"docs":{"117":{"tf":1.0},"141":{"tf":1.0},"59":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"72":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"103":{"tf":1.0},"150":{"tf":1.4142135623730951},"166":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.4142135623730951},"93":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":27,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"139":{"tf":2.0},"140":{"tf":1.4142135623730951},"147":{"tf":1.0},"21":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"i":{"df":13,"docs":{"103":{"tf":1.0},"109":{"tf":1.4142135623730951},"11":{"tf":1.0},"115":{"tf":1.4142135623730951},"119":{"tf":1.0},"17":{"tf":2.0},"191":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":2.0}}}},"df":0,"docs":{}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":44,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.0},"17":{"tf":1.0},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.7320508075688772},"18":{"tf":2.0},"181":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"127":{"tf":1.0}}},"9":{"df":2,"docs":{"131":{"tf":1.0},"132":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"2":{"7":{"df":1,"docs":{"132":{"tf":1.0}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"79":{"tf":1.0}}},"9":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"44":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"147":{"tf":1.0},"164":{"tf":1.0},"168":{"tf":1.0}}}},"l":{"df":8,"docs":{"146":{"tf":1.0},"147":{"tf":1.0},"180":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"24":{"tf":1.0},"44":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"198":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"5":{"tf":2.0}},"e":{"_":{"c":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"179":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"d":{"df":17,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.0},"142":{"tf":1.0},"150":{"tf":1.0},"151":{"tf":2.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"168":{"tf":1.4142135623730951},"188":{"tf":1.0},"37":{"tf":1.7320508075688772},"44":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"107":{"tf":1.0},"110":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"124":{"tf":1.0},"141":{"tf":1.0},"179":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":2.23606797749979},"71":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"144":{"tf":1.0},"147":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":7,"docs":{"148":{"tf":1.0},"155":{"tf":1.0},"17":{"tf":1.0},"173":{"tf":2.449489742783178},"175":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"111":{"tf":2.0}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":4,"docs":{"153":{"tf":1.0},"154":{"tf":1.0},"178":{"tf":1.0},"59":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"171":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":15,"docs":{"105":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.0},"188":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"98":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":2.23606797749979}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"111":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"110":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"p":{"df":3,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"195":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}},":":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":24,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":3.1622776601683795},"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"118":{"tf":2.8284271247461903},"139":{"tf":2.0},"141":{"tf":1.7320508075688772},"185":{"tf":1.0},"193":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"93":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951},"97":{"tf":2.0},"98":{"tf":2.6457513110645907},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"38":{"tf":1.0},"82":{"tf":1.0}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"198":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"b":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"97":{"tf":2.0}}},"2":{"df":1,"docs":{"97":{"tf":2.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"51":{"tf":1.0},"97":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"181":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"142":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"146":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"107":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":15,"docs":{"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"119":{"tf":1.0},"140":{"tf":1.0},"148":{"tf":1.0},"157":{"tf":1.4142135623730951},"159":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"166":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"166":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":2,"docs":{"166":{"tf":2.0},"173":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"121":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"m":{"df":1,"docs":{"110":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}},"i":{"df":3,"docs":{"165":{"tf":1.0},"6":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"103":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"172":{"tf":1.0},"24":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":2.0},"107":{"tf":1.0},"142":{"tf":1.0},"188":{"tf":1.0},"191":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"107":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.0},"163":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":15,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"117":{"tf":1.7320508075688772},"129":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"4":{"tf":2.0},"61":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"183":{"tf":1.0},"32":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":5,"docs":{"119":{"tf":1.0},"32":{"tf":1.4142135623730951},"37":{"tf":1.0},"51":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":2.23606797749979}},"l":{"df":3,"docs":{"160":{"tf":1.0},"30":{"tf":1.7320508075688772},"75":{"tf":2.449489742783178}}}},"df":0,"docs":{},"g":{"df":8,"docs":{"110":{"tf":1.4142135623730951},"128":{"tf":1.7320508075688772},"161":{"tf":1.0},"162":{"tf":1.0},"198":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"k":{"df":0,"docs":{},"e":{"df":22,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"132":{"tf":1.4142135623730951},"14":{"tf":1.0},"142":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"184":{"tf":1.0},"191":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951}},"n":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"193":{"tf":1.0},"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"79":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"18":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":9,"docs":{"106":{"tf":1.0},"115":{"tf":2.6457513110645907},"139":{"tf":2.0},"18":{"tf":1.0},"181":{"tf":1.7320508075688772},"188":{"tf":1.0},"23":{"tf":2.6457513110645907},"3":{"tf":1.0},"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":2.8284271247461903}}}}},"df":7,"docs":{"103":{"tf":1.0},"147":{"tf":1.0},"157":{"tf":1.4142135623730951},"61":{"tf":2.0},"63":{"tf":1.4142135623730951},"65":{"tf":3.1622776601683795},"66":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"110":{"tf":1.0},"135":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"114":{"tf":2.23606797749979},"18":{"tf":1.0},"60":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"142":{"tf":1.0},"144":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"111":{"tf":1.0},"171":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"2":{"4":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":35,"docs":{"107":{"tf":2.449489742783178},"108":{"tf":1.4142135623730951},"109":{"tf":1.0},"110":{"tf":1.4142135623730951},"111":{"tf":2.449489742783178},"112":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":2.449489742783178},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":3.3166247903554},"119":{"tf":2.8284271247461903},"120":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":2.0},"127":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.4142135623730951},"16":{"tf":1.0},"171":{"tf":2.449489742783178},"174":{"tf":1.7320508075688772},"178":{"tf":1.0},"18":{"tf":2.6457513110645907},"181":{"tf":1.7320508075688772},"183":{"tf":2.449489742783178},"184":{"tf":3.0},"185":{"tf":3.0},"19":{"tf":3.0},"20":{"tf":3.1622776601683795},"21":{"tf":2.449489742783178},"22":{"tf":3.7416573867739413},"33":{"tf":1.0},"5":{"tf":1.0},"80":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":10,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"147":{"tf":1.0},"44":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.23606797749979},"78":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"’":{"df":6,"docs":{"110":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":6,"docs":{"24":{"tf":3.4641016151377544},"34":{"tf":3.3166247903554},"35":{"tf":3.7416573867739413},"48":{"tf":1.4142135623730951},"51":{"tf":2.6457513110645907},"82":{"tf":2.449489742783178}},"’":{"df":1,"docs":{"34":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"158":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"116":{"tf":1.0},"144":{"tf":1.0},"69":{"tf":1.0},"98":{"tf":1.0}}}}},"’":{"df":9,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"143":{"tf":1.0},"152":{"tf":1.0},"191":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"’":{"df":0,"docs":{},"r":{"df":4,"docs":{"145":{"tf":1.0},"174":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":11,"docs":{"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"118":{"tf":1.0},"139":{"tf":1.4142135623730951},"147":{"tf":1.0},"188":{"tf":1.0},"22":{"tf":1.4142135623730951},"46":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}},"k":{"df":2,"docs":{"2":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"d":{"df":3,"docs":{"101":{"tf":1.4142135623730951},"176":{"tf":1.0},"98":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"113":{"tf":1.0},"145":{"tf":1.0},"157":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.4142135623730951},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":12,"docs":{"101":{"tf":1.0},"107":{"tf":1.0},"141":{"tf":1.0},"175":{"tf":1.0},"180":{"tf":1.0},"188":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"83":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"104":{"tf":1.0},"113":{"tf":1.0},"117":{"tf":1.0},"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":10,"docs":{"116":{"tf":1.0},"141":{"tf":1.4142135623730951},"157":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"187":{"tf":1.0},"22":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}}}}},"u":{"df":4,"docs":{"119":{"tf":1.0},"145":{"tf":1.0},"149":{"tf":1.0},"151":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"145":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"73":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":11,"docs":{"104":{"tf":1.0},"110":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"141":{"tf":1.0},"175":{"tf":1.0},"18":{"tf":1.0},"184":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"30":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"111":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"135":{"tf":1.0},"186":{"tf":1.7320508075688772}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"110":{"tf":1.0},"139":{"tf":1.7320508075688772}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"178":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":12,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"124":{"tf":1.0},"169":{"tf":1.7320508075688772},"179":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"114":{"tf":2.0},"175":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"74":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":15,"docs":{"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"155":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"148":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}},"df":16,"docs":{"103":{"tf":1.0},"104":{"tf":2.0},"111":{"tf":1.0},"150":{"tf":3.4641016151377544},"151":{"tf":2.0},"175":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":2.449489742783178},"59":{"tf":1.0},"63":{"tf":1.7320508075688772},"66":{"tf":2.6457513110645907},"68":{"tf":1.0},"80":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"195":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"167":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"157":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"139":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"66":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":6,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"59":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.0},"23":{"tf":2.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"144":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":7,"docs":{"113":{"tf":1.0},"179":{"tf":1.7320508075688772},"187":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.7320508075688772},"63":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"146":{"tf":1.0},"151":{"tf":1.0},"159":{"tf":1.0},"191":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":11,"docs":{"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"116":{"tf":1.0},"167":{"tf":1.0},"188":{"tf":1.0},"2":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.0},"60":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"e":{"=":{"\\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"175":{"tf":1.0}}}}},"df":36,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"111":{"tf":2.0},"121":{"tf":1.0},"127":{"tf":1.0},"143":{"tf":1.7320508075688772},"144":{"tf":1.0},"150":{"tf":2.0},"151":{"tf":2.0},"152":{"tf":1.4142135623730951},"157":{"tf":3.1622776601683795},"165":{"tf":2.0},"167":{"tf":1.0},"172":{"tf":1.0},"179":{"tf":1.0},"182":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":3.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.0},"62":{"tf":1.4142135623730951},"63":{"tf":3.872983346207417},"65":{"tf":2.449489742783178},"66":{"tf":4.358898943540674},"67":{"tf":1.4142135623730951},"68":{"tf":3.872983346207417},"71":{"tf":1.7320508075688772},"81":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}},"’":{"df":2,"docs":{"165":{"tf":2.0},"63":{"tf":1.0}}}},"o":{"df":3,"docs":{"127":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"u":{"3":{"2":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0}}},"df":1,"docs":{"65":{"tf":1.4142135623730951}},"i":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"185":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"z":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"189":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"r":{"df":5,"docs":{"145":{"tf":1.0},"187":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"67":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"185":{"tf":1.0},"63":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"111":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"123":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"131":{"tf":1.0}},"e":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"111":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"71":{"tf":1.0},"77":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"103":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"104":{"tf":1.0},"68":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"104":{"tf":1.0},"111":{"tf":1.0}}}},"t":{"df":3,"docs":{"108":{"tf":1.0},"118":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"x":{"df":7,"docs":{"139":{"tf":1.0},"189":{"tf":2.8284271247461903},"190":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"193":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"139":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"115":{"tf":1.0},"127":{"tf":1.0},"179":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"113":{"tf":1.0},"187":{"tf":1.0},"193":{"tf":1.4142135623730951},"93":{"tf":1.0},"94":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":5,"docs":{"102":{"tf":1.0},"123":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.0},"163":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"122":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"128":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"121":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":54,"docs":{"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"145":{"tf":2.23606797749979},"146":{"tf":1.0},"147":{"tf":1.0},"148":{"tf":1.0},"149":{"tf":1.0},"150":{"tf":1.4142135623730951},"151":{"tf":1.4142135623730951},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.4142135623730951},"158":{"tf":2.23606797749979},"159":{"tf":1.0},"160":{"tf":1.0},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.7320508075688772},"166":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":2.23606797749979},"169":{"tf":1.0},"170":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"176":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"179":{"tf":1.0},"180":{"tf":1.0},"181":{"tf":1.7320508075688772},"182":{"tf":1.0},"183":{"tf":1.0},"184":{"tf":1.0},"185":{"tf":1.0},"186":{"tf":1.0},"187":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"193":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"159":{"tf":1.0},"37":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.4142135623730951}},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"109":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"79":{"tf":1.0},"80":{"tf":1.0}}}}},"df":13,"docs":{"1":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.4142135623730951},"2":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0},"93":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"50":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":9,"docs":{"103":{"tf":1.0},"130":{"tf":1.7320508075688772},"142":{"tf":1.7320508075688772},"163":{"tf":3.4641016151377544},"167":{"tf":2.23606797749979},"29":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":136,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":2.0},"102":{"tf":1.0},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"106":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":2.8284271247461903},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":2.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"137":{"tf":1.0},"139":{"tf":2.0},"14":{"tf":1.4142135623730951},"141":{"tf":1.4142135623730951},"142":{"tf":2.0},"144":{"tf":1.0},"146":{"tf":1.0},"147":{"tf":1.4142135623730951},"148":{"tf":1.0},"15":{"tf":1.7320508075688772},"151":{"tf":1.7320508075688772},"152":{"tf":1.4142135623730951},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"155":{"tf":1.7320508075688772},"157":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"161":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"173":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"178":{"tf":1.0},"179":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"181":{"tf":2.449489742783178},"183":{"tf":1.4142135623730951},"184":{"tf":1.0},"185":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":2.6457513110645907},"19":{"tf":1.0},"190":{"tf":2.0},"191":{"tf":1.4142135623730951},"193":{"tf":2.0},"195":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":2.23606797749979},"42":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":3.1622776601683795},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":3.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":2.449489742783178},"98":{"tf":2.8284271247461903},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"189":{"tf":1.0}}}}}},"r":{"df":10,"docs":{"124":{"tf":1.0},"187":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":2.0}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"’":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"z":{"df":4,"docs":{"118":{"tf":1.0},"132":{"tf":1.7320508075688772},"61":{"tf":1.0},"63":{"tf":2.23606797749979}},"e":{"`":{"]":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"132":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"131":{"tf":1.0},"132":{"tf":1.0},"174":{"tf":1.0},"23":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":3,"docs":{"103":{"tf":1.4142135623730951},"118":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":9,"docs":{"104":{"tf":1.4142135623730951},"127":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"165":{"tf":1.0},"24":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"89":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"112":{"tf":1.0},"158":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"104":{"tf":1.0},"143":{"tf":1.0},"148":{"tf":1.0},"175":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}}},"df":3,"docs":{"10":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}},"e":{"c":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"61":{"tf":1.0}}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"59":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"`":{"]":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"103":{"tf":1.0}}},"u":{"8":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":5,"docs":{"103":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":2.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"161":{"tf":1.0},"162":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":2.6457513110645907},"3":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"159":{"tf":1.0},"191":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"118":{"tf":1.0},"35":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":17,"docs":{"10":{"tf":1.7320508075688772},"103":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.7320508075688772},"147":{"tf":1.4142135623730951},"167":{"tf":1.0},"173":{"tf":1.0},"179":{"tf":1.0},"24":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":2.8284271247461903},"44":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":2.449489742783178}}}}}}}},"i":{"a":{"df":5,"docs":{"167":{"tf":1.0},"178":{"tf":1.0},"181":{"tf":1.4142135623730951},"71":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"44":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"101":{"tf":1.4142135623730951},"193":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"187":{"tf":1.0},"189":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}},"l":{"df":1,"docs":{"114":{"tf":1.4142135623730951}}}},"n":{"d":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":35,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"142":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"185":{"tf":1.0},"190":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.7320508075688772},"93":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"123":{"tf":1.0},"79":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"120":{"tf":1.0},"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"125":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":20,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"112":{"tf":2.449489742783178},"120":{"tf":1.0},"121":{"tf":2.23606797749979},"122":{"tf":2.449489742783178},"123":{"tf":1.4142135623730951},"124":{"tf":2.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":1.7320508075688772},"128":{"tf":2.23606797749979},"129":{"tf":1.7320508075688772},"130":{"tf":2.449489742783178},"131":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"148":{"tf":1.0},"185":{"tf":1.0},"78":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"!":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"y":{"df":15,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"117":{"tf":1.0},"139":{"tf":1.0},"140":{"tf":1.4142135623730951},"143":{"tf":1.0},"152":{"tf":1.0},"163":{"tf":1.0},"179":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":2,"docs":{"177":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951}},"e":{"b":{"df":3,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"57":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"142":{"tf":1.0},"72":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"113":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"48":{"tf":1.0},"66":{"tf":1.0},"79":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":1,"docs":{"118":{"tf":1.0}}},"v":{"df":1,"docs":{"83":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"’":{"df":2,"docs":{"72":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"139":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"106":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"189":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"114":{"tf":1.0},"122":{"tf":1.0},"144":{"tf":1.0},"157":{"tf":1.0},"188":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"111":{"tf":1.0},"141":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"119":{"tf":1.0},"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"47":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"\'":{"1":{"0":{"0":{"\'":{">":{"<":{"/":{"a":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":8,"docs":{"115":{"tf":1.0},"139":{"tf":1.4142135623730951},"188":{"tf":1.0},"189":{"tf":1.4142135623730951},"192":{"tf":1.0},"23":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"139":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"144":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"104":{"tf":1.0},"107":{"tf":1.0},"119":{"tf":1.0},"133":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":12,"docs":{"102":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"167":{"tf":1.0},"179":{"tf":1.0},"195":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":4,"docs":{"127":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":6,"docs":{"118":{"tf":1.0},"140":{"tf":1.0},"171":{"tf":1.0},"18":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"k":{"df":18,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"119":{"tf":1.0},"135":{"tf":1.4142135623730951},"144":{"tf":1.0},"157":{"tf":1.0},"159":{"tf":1.7320508075688772},"163":{"tf":1.4142135623730951},"188":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"181":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"133":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":5,"docs":{"110":{"tf":1.4142135623730951},"114":{"tf":1.0},"145":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"93":{"tf":1.0}}}}},"’":{"df":0,"docs":{},"v":{"df":1,"docs":{"110":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":8,"docs":{"109":{"tf":1.0},"184":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"73":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"184":{"tf":1.0}}},"2":{"df":1,"docs":{"184":{"tf":1.0}}},"df":5,"docs":{"179":{"tf":1.7320508075688772},"184":{"tf":3.0},"22":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":64,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"124":{"tf":1.0},"139":{"tf":1.0},"144":{"tf":1.0},"159":{"tf":1.0},"175":{"tf":1.0},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":1.0},"198":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":2.8284271247461903},"70":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"95":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"68":{"tf":3.0}}}},"x":{"0":{"9":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"2":{"2":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"3":{"0":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"6":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":2,"docs":{"115":{"tf":2.449489742783178},"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"107":{"tf":1.7320508075688772},"110":{"tf":4.242640687119285},"114":{"tf":1.4142135623730951},"118":{"tf":1.0},"141":{"tf":1.4142135623730951},"179":{"tf":1.7320508075688772},"185":{"tf":1.0},"76":{"tf":1.0}}},"y":{"df":2,"docs":{"110":{"tf":4.242640687119285},"193":{"tf":1.0}},"e":{"df":1,"docs":{"110":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"142":{"tf":1.0}}}}}}},"’":{"d":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"109":{"tf":1.0},"113":{"tf":1.0},"121":{"tf":1.0},"169":{"tf":1.0},"2":{"tf":1.0}}}},"r":{"df":6,"docs":{"112":{"tf":1.0},"173":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0}}},"v":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"z":{"df":15,"docs":{"158":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.7320508075688772},"172":{"tf":1.0},"173":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"144":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":2.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"134":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"179":{"tf":1.0},"184":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"title":{"root":{"a":{"d":{"d":{"df":4,"docs":{"141":{"tf":1.0},"165":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0}}},"df":2,"docs":{"150":{"tf":1.0},"78":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"95":{"tf":1.0}},"s":{"df":1,"docs":{"141":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"20":{"tf":1.0},"22":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"158":{"tf":1.0},"185":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"114":{"tf":1.0},"149":{"tf":1.0},"154":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"130":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"140":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"116":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"183":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"183":{"tf":1.0},"184":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"154":{"tf":1.0}}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"184":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"171":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":1,"docs":{"18":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"151":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"139":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":7,"docs":{"116":{"tf":1.0},"182":{"tf":1.0},"186":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"158":{"tf":1.0},"38":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"198":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"119":{"tf":1.0},"147":{"tf":1.0},"185":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"52":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":9,"docs":{"119":{"tf":1.0},"12":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"173":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"12":{"tf":1.4142135623730951},"155":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"36":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"166":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"116":{"tf":1.0},"25":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"116":{"tf":1.0},"142":{"tf":1.0},"35":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"170":{"tf":1.0},"24":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"182":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"14":{"tf":1.0},"151":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"df":0,"docs":{},"’":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"194":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"150":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"159":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"119":{"tf":1.0},"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"171":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"c":{"(":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"190":{"tf":1.0}}}}}}},"df":2,"docs":{"187":{"tf":1.0},"191":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":2,"docs":{"187":{"tf":1.0},"188":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"160":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":11,"docs":{"106":{"tf":1.0},"111":{"tf":1.0},"140":{"tf":1.0},"149":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"169":{"tf":1.0},"170":{"tf":1.0},"33":{"tf":1.0},"50":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"108":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"147":{"tf":1.0},"174":{"tf":1.4142135623730951},"179":{"tf":1.0},"185":{"tf":1.0},"33":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"107":{"tf":1.0},"113":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"151":{"tf":1.0},"152":{"tf":1.0},"153":{"tf":1.0},"154":{"tf":1.0},"160":{"tf":1.0},"172":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"165":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"31":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"156":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"170":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"147":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":9,"docs":{"109":{"tf":1.0},"110":{"tf":1.0},"133":{"tf":1.0},"137":{"tf":1.0},"181":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.0},"56":{"tf":1.0},"80":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"151":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"186":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"105":{"tf":1.0},"193":{"tf":1.0},"97":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"149":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"108":{"tf":1.0},"147":{"tf":1.0}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"191":{"tf":1.0}}}},"q":{"df":1,"docs":{"136":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"134":{"tf":1.0},"138":{"tf":1.0},"139":{"tf":1.0},"145":{"tf":1.0},"156":{"tf":1.0},"194":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"173":{"tf":1.0},"25":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"r":{"c":{"df":1,"docs":{"168":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"177":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"146":{"tf":1.0},"62":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"157":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"146":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"106":{"tf":1.0},"170":{"tf":1.0},"182":{"tf":1.4142135623730951},"186":{"tf":1.4142135623730951},"23":{"tf":1.0},"30":{"tf":1.0}}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":1,"docs":{"55":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"106":{"tf":1.0}}}}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"160":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"110":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":6,"docs":{"167":{"tf":1.0},"173":{"tf":1.0},"180":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":10,"docs":{"118":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"162":{"tf":1.0},"181":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"169":{"tf":1.0},"170":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"139":{"tf":1.0},"9":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"192":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"100":{"tf":1.0},"193":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"129":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":14,"docs":{"102":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.4142135623730951},"141":{"tf":1.0},"160":{"tf":1.4142135623730951},"164":{"tf":1.0},"175":{"tf":1.0},"181":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"67":{"tf":1.0},"92":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"176":{"tf":1.0},"178":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"153":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"165":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"169":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"158":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}},"k":{"df":5,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"167":{"tf":1.0},"182":{"tf":1.4142135623730951}}},"t":{"df":2,"docs":{"120":{"tf":1.0},"148":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}},"o":{"a":{"d":{"df":3,"docs":{"173":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"167":{"tf":1.0}}},"t":{"df":3,"docs":{"163":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"155":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"113":{"tf":1.0},"186":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":7,"docs":{"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"159":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"148":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"166":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"102":{"tf":1.0},"12":{"tf":1.4142135623730951},"166":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"46":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"146":{"tf":1.0},"156":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"167":{"tf":1.0},"62":{"tf":1.0}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"150":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"147":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":1,"docs":{"11":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"197":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"n":{"df":1,"docs":{"55":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"20":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"159":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"171":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"34":{"tf":1.0},"42":{"tf":1.0},"82":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"164":{"tf":1.0},"169":{"tf":1.4142135623730951},"170":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"108":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"185":{"tf":1.0},"195":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"173":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"139":{"tf":1.0},"140":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"163":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"109":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"152":{"tf":1.0},"65":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"126":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"109":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"183":{"tf":1.0},"22":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}}}}},"r":{"df":1,"docs":{"41":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"132":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"105":{"tf":1.0},"193":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"117":{"tf":1.0},"196":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"161":{"tf":1.0},"162":{"tf":1.0},"25":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"143":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"143":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"166":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"167":{"tf":1.0},"173":{"tf":1.0},"32":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.0}}}},"n":{"df":6,"docs":{"119":{"tf":1.0},"174":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"40":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":3,"docs":{"18":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":8,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0}},"’":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"155":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"105":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"133":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"141":{"tf":1.0},"142":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"165":{"tf":1.0},"45":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"50":{"tf":1.0}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":7,"docs":{"112":{"tf":1.0},"13":{"tf":1.0},"137":{"tf":1.0},"160":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"56":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"182":{"tf":1.0},"186":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"139":{"tf":1.4142135623730951},"140":{"tf":1.0},"21":{"tf":1.0}},"i":{"df":2,"docs":{"17":{"tf":1.0},"23":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"173":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"166":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"117":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"60":{"tf":1.0}},"l":{"df":2,"docs":{"30":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.0},"23":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":9,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"171":{"tf":1.0},"183":{"tf":1.4142135623730951},"184":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.7320508075688772}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"48":{"tf":1.0},"51":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"186":{"tf":1.0}}}}},"p":{"df":1,"docs":{"169":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"150":{"tf":1.4142135623730951},"54":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"191":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":8,"docs":{"143":{"tf":1.0},"157":{"tf":1.0},"165":{"tf":1.0},"182":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}},"’":{"df":1,"docs":{"165":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"168":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"145":{"tf":1.0},"158":{"tf":1.0},"168":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":1,"docs":{"137":{"tf":1.0}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"163":{"tf":1.0},"167":{"tf":1.0},"29":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":6,"docs":{"111":{"tf":1.0},"134":{"tf":1.0},"155":{"tf":1.0},"181":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"103":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"105":{"tf":1.0},"112":{"tf":1.0},"78":{"tf":1.0}}}}},"df":1,"docs":{"177":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"135":{"tf":1.0},"63":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"184":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"184":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"168":{"tf":1.0}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}}'));