#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 190
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 59
#define ALIAS_COUNT 0
#define TOKEN_COUNT 33
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_LT = 1,
  anon_sym_GT = 2,
  anon_sym_SLASH_GT = 3,
  anon_sym_LT_SLASH = 4,
  anon_sym_EQ = 5,
  sym_attribute_name = 6,
  sym_attribute_value = 7,
  anon_sym_SQUOTE = 8,
  aux_sym_quoted_attribute_value_token1 = 9,
  anon_sym_DQUOTE = 10,
  aux_sym_quoted_attribute_value_token2 = 11,
  anon_sym_LBRACE_LBRACE = 12,
  anon_sym_RBRACE_RBRACE = 13,
  anon_sym_COLON = 14,
  sym_directive_name = 15,
  sym_directive_shorthand = 16,
  aux_sym_directive_argument_token1 = 17,
  anon_sym_LBRACK = 18,
  anon_sym_RBRACK = 19,
  sym_directive_dynamic_argument_value = 20,
  anon_sym_DOT = 21,
  sym__text_fragment = 22,
  sym__interpolation_text = 23,
  sym__start_tag_name = 24,
  sym__template_start_tag_name = 25,
  sym__script_start_tag_name = 26,
  sym__style_start_tag_name = 27,
  sym__end_tag_name = 28,
  sym_erroneous_end_tag_name = 29,
  sym__implicit_end_tag = 30,
  sym_raw_text = 31,
  sym_comment = 32,
  sym_component = 33,
  sym__node = 34,
  sym_element = 35,
  sym_template_element = 36,
  sym_script_element = 37,
  sym_style_element = 38,
  sym_start_tag = 39,
  sym_template_start_tag = 40,
  sym_script_start_tag = 41,
  sym_style_start_tag = 42,
  sym_self_closing_tag = 43,
  sym_end_tag = 44,
  sym_erroneous_end_tag = 45,
  sym_attribute = 46,
  sym_quoted_attribute_value = 47,
  sym_text = 48,
  sym_interpolation = 49,
  sym_directive_attribute = 50,
  sym_directive_argument = 51,
  sym_directive_dynamic_argument = 52,
  sym_directive_modifiers = 53,
  sym_directive_modifier = 54,
  aux_sym_component_repeat1 = 55,
  aux_sym_element_repeat1 = 56,
  aux_sym_start_tag_repeat1 = 57,
  aux_sym_directive_modifiers_repeat1 = 58,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_COLON] = ":",
  [sym_directive_name] = "directive_name",
  [sym_directive_shorthand] = "directive_name",
  [aux_sym_directive_argument_token1] = "directive_argument_token1",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_directive_dynamic_argument_value] = "directive_dynamic_argument_value",
  [anon_sym_DOT] = ".",
  [sym__text_fragment] = "_text_fragment",
  [sym__interpolation_text] = "raw_text",
  [sym__start_tag_name] = "tag_name",
  [sym__template_start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_comment] = "comment",
  [sym_component] = "component",
  [sym__node] = "_node",
  [sym_element] = "element",
  [sym_template_element] = "template_element",
  [sym_script_element] = "script_element",
  [sym_style_element] = "style_element",
  [sym_start_tag] = "start_tag",
  [sym_template_start_tag] = "start_tag",
  [sym_script_start_tag] = "start_tag",
  [sym_style_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_erroneous_end_tag] = "erroneous_end_tag",
  [sym_attribute] = "attribute",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [sym_text] = "text",
  [sym_interpolation] = "interpolation",
  [sym_directive_attribute] = "directive_attribute",
  [sym_directive_argument] = "directive_argument",
  [sym_directive_dynamic_argument] = "directive_dynamic_argument",
  [sym_directive_modifiers] = "directive_modifiers",
  [sym_directive_modifier] = "directive_modifier",
  [aux_sym_component_repeat1] = "component_repeat1",
  [aux_sym_element_repeat1] = "element_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
  [aux_sym_directive_modifiers_repeat1] = "directive_modifiers_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_directive_name] = sym_directive_name,
  [sym_directive_shorthand] = sym_directive_name,
  [aux_sym_directive_argument_token1] = aux_sym_directive_argument_token1,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_directive_dynamic_argument_value] = sym_directive_dynamic_argument_value,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym__text_fragment] = sym__text_fragment,
  [sym__interpolation_text] = sym_raw_text,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__template_start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_comment] = sym_comment,
  [sym_component] = sym_component,
  [sym__node] = sym__node,
  [sym_element] = sym_element,
  [sym_template_element] = sym_template_element,
  [sym_script_element] = sym_script_element,
  [sym_style_element] = sym_style_element,
  [sym_start_tag] = sym_start_tag,
  [sym_template_start_tag] = sym_start_tag,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_erroneous_end_tag] = sym_erroneous_end_tag,
  [sym_attribute] = sym_attribute,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [sym_text] = sym_text,
  [sym_interpolation] = sym_interpolation,
  [sym_directive_attribute] = sym_directive_attribute,
  [sym_directive_argument] = sym_directive_argument,
  [sym_directive_dynamic_argument] = sym_directive_dynamic_argument,
  [sym_directive_modifiers] = sym_directive_modifiers,
  [sym_directive_modifier] = sym_directive_modifier,
  [aux_sym_component_repeat1] = aux_sym_component_repeat1,
  [aux_sym_element_repeat1] = aux_sym_element_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
  [aux_sym_directive_modifiers_repeat1] = aux_sym_directive_modifiers_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_directive_name] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_shorthand] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_directive_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_directive_dynamic_argument_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym__text_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation_text] = {
    .visible = true,
    .named = true,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__template_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_component] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_template_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_template_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_dynamic_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_directive_modifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_component_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_directive_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_directive_name_character_set_1(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '"' || (c < ':'
      ? (c < '.'
        ? c == '\''
        : c <= '/')
      : (c <= ':' || (c >= '<' && c <= '>')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(16);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '#' ||
          lookahead == '@') ADVANCE(36);
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == ':') ADVANCE(34);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == '[') ADVANCE(38);
      if (lookahead == ']') ADVANCE(39);
      if (lookahead == 'v') ADVANCE(4);
      if (lookahead == '{') ADVANCE(8);
      if (lookahead == '}') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 3:
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(27);
      if (lookahead != 0) ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(13);
      END_STATE();
    case 5:
      if (lookahead == '>') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == '[') ADVANCE(38);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == ']') ADVANCE(39);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == '{') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == '}') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == '#' ||
          lookahead == '@') ADVANCE(36);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == ':') ADVANCE(34);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == '#' ||
          lookahead == ':' ||
          lookahead == '@') ADVANCE(36);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(24);
      END_STATE();
    case 12:
      if (lookahead == '#' ||
          lookahead == ':' ||
          lookahead == '@') ADVANCE(36);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(24);
      END_STATE();
    case 13:
      if (!sym_directive_name_character_set_1(lookahead)) ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(37);
      END_STATE();
    case 15:
      if (eof) ADVANCE(16);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '#' ||
          lookahead == ':' ||
          lookahead == '@') ADVANCE(36);
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(4);
      if (lookahead == '{') ADVANCE(8);
      if (lookahead == '}') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 16:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(20);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(24);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(35);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(25);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(27);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(28);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(31);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_directive_name);
      if (!sym_directive_name_character_set_1(lookahead)) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_directive_shorthand);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(aux_sym_directive_argument_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_directive_dynamic_argument_value);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != ']') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 3},
  [3] = {.lex_state = 0, .external_lex_state = 3},
  [4] = {.lex_state = 0, .external_lex_state = 3},
  [5] = {.lex_state = 0, .external_lex_state = 3},
  [6] = {.lex_state = 0, .external_lex_state = 3},
  [7] = {.lex_state = 0, .external_lex_state = 3},
  [8] = {.lex_state = 0, .external_lex_state = 4},
  [9] = {.lex_state = 0, .external_lex_state = 4},
  [10] = {.lex_state = 0, .external_lex_state = 4},
  [11] = {.lex_state = 0, .external_lex_state = 3},
  [12] = {.lex_state = 0, .external_lex_state = 4},
  [13] = {.lex_state = 0, .external_lex_state = 4},
  [14] = {.lex_state = 0, .external_lex_state = 4},
  [15] = {.lex_state = 0, .external_lex_state = 4},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 0, .external_lex_state = 2},
  [18] = {.lex_state = 10, .external_lex_state = 5},
  [19] = {.lex_state = 10},
  [20] = {.lex_state = 11, .external_lex_state = 5},
  [21] = {.lex_state = 11, .external_lex_state = 5},
  [22] = {.lex_state = 12, .external_lex_state = 5},
  [23] = {.lex_state = 11, .external_lex_state = 5},
  [24] = {.lex_state = 11},
  [25] = {.lex_state = 11, .external_lex_state = 5},
  [26] = {.lex_state = 12, .external_lex_state = 5},
  [27] = {.lex_state = 0, .external_lex_state = 6},
  [28] = {.lex_state = 12, .external_lex_state = 5},
  [29] = {.lex_state = 12, .external_lex_state = 5},
  [30] = {.lex_state = 12, .external_lex_state = 5},
  [31] = {.lex_state = 11},
  [32] = {.lex_state = 12, .external_lex_state = 5},
  [33] = {.lex_state = 12, .external_lex_state = 5},
  [34] = {.lex_state = 12},
  [35] = {.lex_state = 0, .external_lex_state = 7},
  [36] = {.lex_state = 12},
  [37] = {.lex_state = 12},
  [38] = {.lex_state = 12},
  [39] = {.lex_state = 11},
  [40] = {.lex_state = 11, .external_lex_state = 5},
  [41] = {.lex_state = 12},
  [42] = {.lex_state = 11, .external_lex_state = 5},
  [43] = {.lex_state = 11, .external_lex_state = 5},
  [44] = {.lex_state = 11, .external_lex_state = 5},
  [45] = {.lex_state = 11, .external_lex_state = 5},
  [46] = {.lex_state = 12},
  [47] = {.lex_state = 11},
  [48] = {.lex_state = 12},
  [49] = {.lex_state = 0, .external_lex_state = 3},
  [50] = {.lex_state = 0, .external_lex_state = 3},
  [51] = {.lex_state = 0, .external_lex_state = 3},
  [52] = {.lex_state = 12, .external_lex_state = 5},
  [53] = {.lex_state = 0, .external_lex_state = 3},
  [54] = {.lex_state = 11},
  [55] = {.lex_state = 0, .external_lex_state = 3},
  [56] = {.lex_state = 0, .external_lex_state = 3},
  [57] = {.lex_state = 0, .external_lex_state = 3},
  [58] = {.lex_state = 0, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 3},
  [60] = {.lex_state = 0, .external_lex_state = 3},
  [61] = {.lex_state = 0, .external_lex_state = 3},
  [62] = {.lex_state = 0, .external_lex_state = 3},
  [63] = {.lex_state = 0, .external_lex_state = 3},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 3},
  [66] = {.lex_state = 11},
  [67] = {.lex_state = 0, .external_lex_state = 3},
  [68] = {.lex_state = 0, .external_lex_state = 3},
  [69] = {.lex_state = 12, .external_lex_state = 5},
  [70] = {.lex_state = 11},
  [71] = {.lex_state = 11},
  [72] = {.lex_state = 12, .external_lex_state = 5},
  [73] = {.lex_state = 11},
  [74] = {.lex_state = 12, .external_lex_state = 5},
  [75] = {.lex_state = 0, .external_lex_state = 3},
  [76] = {.lex_state = 0, .external_lex_state = 4},
  [77] = {.lex_state = 12},
  [78] = {.lex_state = 0, .external_lex_state = 4},
  [79] = {.lex_state = 12, .external_lex_state = 5},
  [80] = {.lex_state = 0, .external_lex_state = 4},
  [81] = {.lex_state = 0, .external_lex_state = 4},
  [82] = {.lex_state = 12, .external_lex_state = 5},
  [83] = {.lex_state = 0, .external_lex_state = 4},
  [84] = {.lex_state = 0, .external_lex_state = 4},
  [85] = {.lex_state = 0, .external_lex_state = 4},
  [86] = {.lex_state = 12, .external_lex_state = 5},
  [87] = {.lex_state = 12, .external_lex_state = 5},
  [88] = {.lex_state = 12, .external_lex_state = 5},
  [89] = {.lex_state = 0, .external_lex_state = 4},
  [90] = {.lex_state = 12, .external_lex_state = 5},
  [91] = {.lex_state = 0, .external_lex_state = 4},
  [92] = {.lex_state = 0, .external_lex_state = 4},
  [93] = {.lex_state = 12, .external_lex_state = 5},
  [94] = {.lex_state = 0, .external_lex_state = 4},
  [95] = {.lex_state = 0, .external_lex_state = 4},
  [96] = {.lex_state = 0, .external_lex_state = 4},
  [97] = {.lex_state = 12},
  [98] = {.lex_state = 12},
  [99] = {.lex_state = 0, .external_lex_state = 4},
  [100] = {.lex_state = 0, .external_lex_state = 4},
  [101] = {.lex_state = 12},
  [102] = {.lex_state = 0, .external_lex_state = 4},
  [103] = {.lex_state = 0, .external_lex_state = 4},
  [104] = {.lex_state = 0, .external_lex_state = 4},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 0, .external_lex_state = 8},
  [109] = {.lex_state = 0, .external_lex_state = 8},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 12},
  [116] = {.lex_state = 12},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 0, .external_lex_state = 8},
  [123] = {.lex_state = 12},
  [124] = {.lex_state = 12},
  [125] = {.lex_state = 12},
  [126] = {.lex_state = 6},
  [127] = {.lex_state = 12},
  [128] = {.lex_state = 12},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 9},
  [134] = {.lex_state = 0, .external_lex_state = 9},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 9},
  [137] = {.lex_state = 0, .external_lex_state = 9},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 9},
  [145] = {.lex_state = 0, .external_lex_state = 9},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0, .external_lex_state = 10},
  [150] = {.lex_state = 0, .external_lex_state = 10},
  [151] = {.lex_state = 14},
  [152] = {.lex_state = 7},
  [153] = {.lex_state = 0, .external_lex_state = 9},
  [154] = {.lex_state = 0, .external_lex_state = 10},
  [155] = {.lex_state = 0, .external_lex_state = 9},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 10},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0, .external_lex_state = 9},
  [162] = {.lex_state = 7},
  [163] = {.lex_state = 2},
  [164] = {.lex_state = 14},
  [165] = {.lex_state = 0, .external_lex_state = 9},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0, .external_lex_state = 10},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0, .external_lex_state = 10},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0, .external_lex_state = 11},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0, .external_lex_state = 12},
  [184] = {.lex_state = 0, .external_lex_state = 11},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0, .external_lex_state = 12},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0, .external_lex_state = 12},
  [189] = {.lex_state = 0},
};

enum {
  ts_external_token__text_fragment = 0,
  ts_external_token__interpolation_text = 1,
  ts_external_token__start_tag_name = 2,
  ts_external_token__template_start_tag_name = 3,
  ts_external_token__script_start_tag_name = 4,
  ts_external_token__style_start_tag_name = 5,
  ts_external_token__end_tag_name = 6,
  ts_external_token_erroneous_end_tag_name = 7,
  ts_external_token_SLASH_GT = 8,
  ts_external_token__implicit_end_tag = 9,
  ts_external_token_raw_text = 10,
  ts_external_token_comment = 11,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__text_fragment] = sym__text_fragment,
  [ts_external_token__interpolation_text] = sym__interpolation_text,
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__template_start_tag_name] = sym__template_start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_comment] = sym_comment,
};

static bool ts_external_scanner_states[13][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__text_fragment] = true,
    [ts_external_token__interpolation_text] = true,
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__template_start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__text_fragment] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token__text_fragment] = true,
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token_SLASH_GT] = true,
  },
  [6] = {
    [ts_external_token__text_fragment] = true,
    [ts_external_token__interpolation_text] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [7] = {
    [ts_external_token__text_fragment] = true,
    [ts_external_token__interpolation_text] = true,
    [ts_external_token_comment] = true,
  },
  [8] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__template_start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
  },
  [9] = {
    [ts_external_token_raw_text] = true,
  },
  [10] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
  },
  [11] = {
    [ts_external_token_erroneous_end_tag_name] = true,
  },
  [12] = {
    [ts_external_token__end_tag_name] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_directive_name] = ACTIONS(1),
    [sym_directive_shorthand] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym__text_fragment] = ACTIONS(1),
    [sym__interpolation_text] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__template_start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_component] = STATE(179),
    [sym_element] = STATE(16),
    [sym_template_element] = STATE(16),
    [sym_script_element] = STATE(16),
    [sym_style_element] = STATE(16),
    [sym_start_tag] = STATE(2),
    [sym_template_start_tag] = STATE(10),
    [sym_script_start_tag] = STATE(133),
    [sym_style_start_tag] = STATE(134),
    [sym_self_closing_tag] = STATE(129),
    [aux_sym_component_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LT] = ACTIONS(5),
    [sym_comment] = ACTIONS(7),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(17), 1,
      sym__implicit_end_tag,
    ACTIONS(19), 1,
      sym_comment,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(138), 1,
      sym_end_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(7), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [48] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(21), 1,
      anon_sym_LT_SLASH,
    ACTIONS(23), 1,
      sym__implicit_end_tag,
    ACTIONS(25), 1,
      sym_comment,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(84), 1,
      sym_end_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(11), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [96] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(25), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LT_SLASH,
    ACTIONS(29), 1,
      sym__implicit_end_tag,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(55), 1,
      sym_end_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(11), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [144] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(21), 1,
      anon_sym_LT_SLASH,
    ACTIONS(31), 1,
      sym__implicit_end_tag,
    ACTIONS(33), 1,
      sym_comment,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(95), 1,
      sym_end_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(3), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [192] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(27), 1,
      anon_sym_LT_SLASH,
    ACTIONS(35), 1,
      sym__implicit_end_tag,
    ACTIONS(37), 1,
      sym_comment,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(67), 1,
      sym_end_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(4), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [240] = 13,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(15), 1,
      sym__text_fragment,
    ACTIONS(25), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym__implicit_end_tag,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(141), 1,
      sym_end_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(11), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [288] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(49), 1,
      sym_comment,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(50), 1,
      sym_end_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(15), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [333] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(49), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(83), 1,
      sym_end_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(15), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [378] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(53), 1,
      anon_sym_LT_SLASH,
    ACTIONS(55), 1,
      sym_comment,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(146), 1,
      sym_end_tag,
    STATE(13), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [423] = 12,
    ACTIONS(57), 1,
      anon_sym_LT,
    ACTIONS(60), 1,
      anon_sym_LT_SLASH,
    ACTIONS(63), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(66), 1,
      sym__text_fragment,
    ACTIONS(69), 1,
      sym__implicit_end_tag,
    ACTIONS(71), 1,
      sym_comment,
    STATE(6), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_template_start_tag,
    STATE(68), 1,
      sym_self_closing_tag,
    STATE(144), 1,
      sym_script_start_tag,
    STATE(145), 1,
      sym_style_start_tag,
    STATE(11), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [468] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(51), 1,
      anon_sym_LT_SLASH,
    ACTIONS(74), 1,
      sym_comment,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(94), 1,
      sym_end_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(9), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [513] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(49), 1,
      sym_comment,
    ACTIONS(53), 1,
      anon_sym_LT_SLASH,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(139), 1,
      sym_end_tag,
    STATE(15), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [558] = 12,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(45), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(47), 1,
      sym__text_fragment,
    ACTIONS(76), 1,
      sym_comment,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(63), 1,
      sym_end_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(8), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [603] = 11,
    ACTIONS(78), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_LT_SLASH,
    ACTIONS(84), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(87), 1,
      sym__text_fragment,
    ACTIONS(90), 1,
      sym_comment,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_template_start_tag,
    STATE(96), 1,
      sym_self_closing_tag,
    STATE(136), 1,
      sym_style_start_tag,
    STATE(137), 1,
      sym_script_start_tag,
    STATE(15), 9,
      sym__node,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_text,
      sym_interpolation,
      aux_sym_element_repeat1,
  [645] = 9,
    ACTIONS(5), 1,
      anon_sym_LT,
    ACTIONS(93), 1,
      ts_builtin_sym_end,
    ACTIONS(95), 1,
      sym_comment,
    STATE(2), 1,
      sym_start_tag,
    STATE(10), 1,
      sym_template_start_tag,
    STATE(129), 1,
      sym_self_closing_tag,
    STATE(133), 1,
      sym_script_start_tag,
    STATE(134), 1,
      sym_style_start_tag,
    STATE(17), 5,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      aux_sym_component_repeat1,
  [677] = 9,
    ACTIONS(97), 1,
      ts_builtin_sym_end,
    ACTIONS(99), 1,
      anon_sym_LT,
    ACTIONS(102), 1,
      sym_comment,
    STATE(2), 1,
      sym_start_tag,
    STATE(10), 1,
      sym_template_start_tag,
    STATE(129), 1,
      sym_self_closing_tag,
    STATE(133), 1,
      sym_script_start_tag,
    STATE(134), 1,
      sym_style_start_tag,
    STATE(17), 5,
      sym_element,
      sym_template_element,
      sym_script_element,
      sym_style_element,
      aux_sym_component_repeat1,
  [709] = 7,
    ACTIONS(107), 1,
      anon_sym_EQ,
    ACTIONS(111), 1,
      anon_sym_COLON,
    ACTIONS(113), 1,
      anon_sym_DOT,
    STATE(23), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(52), 1,
      sym_directive_modifiers,
    ACTIONS(109), 2,
      sym_attribute_name,
      sym_directive_shorthand,
    ACTIONS(105), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
  [734] = 7,
    ACTIONS(115), 1,
      anon_sym_EQ,
    ACTIONS(117), 1,
      anon_sym_COLON,
    ACTIONS(119), 1,
      anon_sym_DOT,
    STATE(47), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(77), 1,
      sym_directive_modifiers,
    ACTIONS(105), 2,
      anon_sym_GT,
      sym_directive_name,
    ACTIONS(109), 2,
      sym_attribute_name,
      sym_directive_shorthand,
  [758] = 6,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(123), 1,
      anon_sym_EQ,
    ACTIONS(125), 1,
      sym_attribute_name,
    STATE(23), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(69), 1,
      sym_directive_modifiers,
    ACTIONS(121), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [780] = 6,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(129), 1,
      anon_sym_EQ,
    ACTIONS(131), 1,
      sym_attribute_name,
    STATE(23), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(74), 1,
      sym_directive_modifiers,
    ACTIONS(127), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [802] = 6,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(135), 1,
      anon_sym_SLASH_GT,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    STATE(30), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [823] = 4,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(145), 1,
      sym_attribute_name,
    STATE(25), 1,
      aux_sym_directive_modifiers_repeat1,
    ACTIONS(143), 5,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
  [840] = 6,
    ACTIONS(119), 1,
      anon_sym_DOT,
    ACTIONS(125), 1,
      sym_attribute_name,
    ACTIONS(147), 1,
      anon_sym_EQ,
    STATE(47), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(101), 1,
      sym_directive_modifiers,
    ACTIONS(121), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [861] = 4,
    ACTIONS(151), 1,
      sym_attribute_name,
    ACTIONS(153), 1,
      anon_sym_DOT,
    STATE(25), 1,
      aux_sym_directive_modifiers_repeat1,
    ACTIONS(149), 5,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
  [878] = 6,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    ACTIONS(156), 1,
      anon_sym_GT,
    ACTIONS(158), 1,
      anon_sym_SLASH_GT,
    STATE(33), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [899] = 4,
    ACTIONS(160), 1,
      anon_sym_LT,
    ACTIONS(164), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(166), 1,
      sym__interpolation_text,
    ACTIONS(162), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [916] = 6,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    ACTIONS(168), 1,
      anon_sym_SLASH_GT,
    STATE(26), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [937] = 6,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    ACTIONS(170), 1,
      anon_sym_SLASH_GT,
    STATE(32), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [958] = 6,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    ACTIONS(156), 1,
      anon_sym_GT,
    ACTIONS(172), 1,
      anon_sym_SLASH_GT,
    STATE(33), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [979] = 6,
    ACTIONS(119), 1,
      anon_sym_DOT,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(174), 1,
      anon_sym_EQ,
    STATE(47), 1,
      aux_sym_directive_modifiers_repeat1,
    STATE(97), 1,
      sym_directive_modifiers,
    ACTIONS(127), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1000] = 6,
    ACTIONS(137), 1,
      sym_attribute_name,
    ACTIONS(139), 1,
      sym_directive_name,
    ACTIONS(141), 1,
      sym_directive_shorthand,
    ACTIONS(156), 1,
      anon_sym_GT,
    ACTIONS(176), 1,
      anon_sym_SLASH_GT,
    STATE(33), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1021] = 5,
    ACTIONS(180), 1,
      sym_attribute_name,
    ACTIONS(183), 1,
      sym_directive_name,
    ACTIONS(186), 1,
      sym_directive_shorthand,
    ACTIONS(178), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(33), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1040] = 5,
    ACTIONS(189), 1,
      anon_sym_GT,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    STATE(41), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1058] = 4,
    ACTIONS(160), 1,
      anon_sym_LT,
    ACTIONS(197), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(199), 1,
      sym__interpolation_text,
    ACTIONS(162), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1074] = 5,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    ACTIONS(201), 1,
      anon_sym_GT,
    STATE(41), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1092] = 5,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    ACTIONS(203), 1,
      anon_sym_GT,
    STATE(36), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1110] = 5,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    ACTIONS(205), 1,
      anon_sym_GT,
    STATE(41), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1128] = 4,
    ACTIONS(151), 1,
      sym_attribute_name,
    ACTIONS(207), 1,
      anon_sym_DOT,
    STATE(39), 1,
      aux_sym_directive_modifiers_repeat1,
    ACTIONS(149), 4,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
  [1144] = 2,
    ACTIONS(212), 1,
      sym_attribute_name,
    ACTIONS(210), 6,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1156] = 5,
    ACTIONS(178), 1,
      anon_sym_GT,
    ACTIONS(214), 1,
      sym_attribute_name,
    ACTIONS(217), 1,
      sym_directive_name,
    ACTIONS(220), 1,
      sym_directive_shorthand,
    STATE(41), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1174] = 2,
    ACTIONS(225), 1,
      sym_attribute_name,
    ACTIONS(223), 6,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1186] = 2,
    ACTIONS(229), 1,
      sym_attribute_name,
    ACTIONS(227), 6,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1198] = 2,
    ACTIONS(233), 1,
      sym_attribute_name,
    ACTIONS(231), 6,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1210] = 2,
    ACTIONS(151), 1,
      sym_attribute_name,
    ACTIONS(149), 6,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1222] = 5,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    ACTIONS(235), 1,
      anon_sym_GT,
    STATE(38), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1240] = 4,
    ACTIONS(119), 1,
      anon_sym_DOT,
    ACTIONS(145), 1,
      sym_attribute_name,
    STATE(39), 1,
      aux_sym_directive_modifiers_repeat1,
    ACTIONS(143), 4,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
  [1256] = 5,
    ACTIONS(191), 1,
      sym_attribute_name,
    ACTIONS(193), 1,
      sym_directive_name,
    ACTIONS(195), 1,
      sym_directive_shorthand,
    ACTIONS(237), 1,
      anon_sym_GT,
    STATE(34), 3,
      sym_attribute,
      sym_directive_attribute,
      aux_sym_start_tag_repeat1,
  [1274] = 2,
    ACTIONS(239), 1,
      anon_sym_LT,
    ACTIONS(241), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1285] = 2,
    ACTIONS(243), 1,
      anon_sym_LT,
    ACTIONS(245), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1296] = 2,
    ACTIONS(247), 1,
      anon_sym_LT,
    ACTIONS(249), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1307] = 3,
    ACTIONS(123), 1,
      anon_sym_EQ,
    ACTIONS(125), 1,
      sym_attribute_name,
    ACTIONS(121), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1320] = 2,
    ACTIONS(160), 1,
      anon_sym_LT,
    ACTIONS(162), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1331] = 2,
    ACTIONS(229), 1,
      sym_attribute_name,
    ACTIONS(227), 5,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1342] = 2,
    ACTIONS(251), 1,
      anon_sym_LT,
    ACTIONS(253), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1353] = 2,
    ACTIONS(255), 1,
      anon_sym_LT,
    ACTIONS(257), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1364] = 2,
    ACTIONS(259), 1,
      anon_sym_LT,
    ACTIONS(261), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1375] = 2,
    ACTIONS(263), 1,
      anon_sym_LT,
    ACTIONS(265), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1386] = 2,
    ACTIONS(267), 1,
      anon_sym_LT,
    ACTIONS(269), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1397] = 2,
    ACTIONS(271), 1,
      anon_sym_LT,
    ACTIONS(273), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1408] = 2,
    ACTIONS(275), 1,
      anon_sym_LT,
    ACTIONS(277), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1419] = 2,
    ACTIONS(279), 1,
      anon_sym_LT,
    ACTIONS(281), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1430] = 2,
    ACTIONS(283), 1,
      anon_sym_LT,
    ACTIONS(285), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1441] = 2,
    ACTIONS(287), 1,
      anon_sym_LT,
    ACTIONS(289), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1452] = 2,
    ACTIONS(291), 1,
      anon_sym_LT,
    ACTIONS(293), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1463] = 2,
    ACTIONS(233), 1,
      sym_attribute_name,
    ACTIONS(231), 5,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1474] = 2,
    ACTIONS(295), 1,
      anon_sym_LT,
    ACTIONS(297), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1485] = 2,
    ACTIONS(299), 1,
      anon_sym_LT,
    ACTIONS(301), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1496] = 3,
    ACTIONS(129), 1,
      anon_sym_EQ,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(127), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1509] = 2,
    ACTIONS(151), 1,
      sym_attribute_name,
    ACTIONS(149), 5,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1520] = 2,
    ACTIONS(212), 1,
      sym_attribute_name,
    ACTIONS(210), 5,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1531] = 3,
    ACTIONS(305), 1,
      anon_sym_EQ,
    ACTIONS(307), 1,
      sym_attribute_name,
    ACTIONS(303), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1544] = 2,
    ACTIONS(225), 1,
      sym_attribute_name,
    ACTIONS(223), 5,
      anon_sym_GT,
      anon_sym_EQ,
      sym_directive_name,
      sym_directive_shorthand,
      anon_sym_DOT,
  [1555] = 3,
    ACTIONS(311), 1,
      anon_sym_EQ,
    ACTIONS(313), 1,
      sym_attribute_name,
    ACTIONS(309), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1568] = 2,
    ACTIONS(315), 1,
      anon_sym_LT,
    ACTIONS(317), 5,
      sym__text_fragment,
      sym__implicit_end_tag,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1579] = 2,
    ACTIONS(255), 1,
      anon_sym_LT,
    ACTIONS(257), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1589] = 3,
    ACTIONS(125), 1,
      sym_attribute_name,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(121), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1601] = 2,
    ACTIONS(267), 1,
      anon_sym_LT,
    ACTIONS(269), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1611] = 2,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(127), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1621] = 2,
    ACTIONS(239), 1,
      anon_sym_LT,
    ACTIONS(241), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1631] = 2,
    ACTIONS(247), 1,
      anon_sym_LT,
    ACTIONS(249), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1641] = 2,
    ACTIONS(321), 1,
      sym_attribute_name,
    ACTIONS(319), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1651] = 2,
    ACTIONS(243), 1,
      anon_sym_LT,
    ACTIONS(245), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1661] = 2,
    ACTIONS(251), 1,
      anon_sym_LT,
    ACTIONS(253), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1671] = 2,
    ACTIONS(271), 1,
      anon_sym_LT,
    ACTIONS(273), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1681] = 2,
    ACTIONS(313), 1,
      sym_attribute_name,
    ACTIONS(309), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1691] = 2,
    ACTIONS(325), 1,
      sym_attribute_name,
    ACTIONS(323), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1701] = 2,
    ACTIONS(329), 1,
      sym_attribute_name,
    ACTIONS(327), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1711] = 2,
    ACTIONS(275), 1,
      anon_sym_LT,
    ACTIONS(277), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1721] = 2,
    ACTIONS(333), 1,
      sym_attribute_name,
    ACTIONS(331), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1731] = 2,
    ACTIONS(160), 1,
      anon_sym_LT,
    ACTIONS(162), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1741] = 2,
    ACTIONS(279), 1,
      anon_sym_LT,
    ACTIONS(281), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1751] = 2,
    ACTIONS(337), 1,
      sym_attribute_name,
    ACTIONS(335), 4,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1761] = 2,
    ACTIONS(283), 1,
      anon_sym_LT,
    ACTIONS(285), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1771] = 2,
    ACTIONS(295), 1,
      anon_sym_LT,
    ACTIONS(297), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1781] = 2,
    ACTIONS(299), 1,
      anon_sym_LT,
    ACTIONS(301), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1791] = 3,
    ACTIONS(313), 1,
      sym_attribute_name,
    ACTIONS(339), 1,
      anon_sym_EQ,
    ACTIONS(309), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1803] = 3,
    ACTIONS(307), 1,
      sym_attribute_name,
    ACTIONS(341), 1,
      anon_sym_EQ,
    ACTIONS(303), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1815] = 2,
    ACTIONS(343), 1,
      anon_sym_LT,
    ACTIONS(345), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1825] = 2,
    ACTIONS(263), 1,
      anon_sym_LT,
    ACTIONS(265), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1835] = 3,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(174), 1,
      anon_sym_EQ,
    ACTIONS(127), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [1847] = 2,
    ACTIONS(347), 1,
      anon_sym_LT,
    ACTIONS(349), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1857] = 2,
    ACTIONS(291), 1,
      anon_sym_LT,
    ACTIONS(293), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1867] = 2,
    ACTIONS(287), 1,
      anon_sym_LT,
    ACTIONS(289), 4,
      sym__text_fragment,
      sym_comment,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
  [1877] = 3,
    ACTIONS(351), 1,
      aux_sym_directive_argument_token1,
    ACTIONS(353), 1,
      anon_sym_LBRACK,
    STATE(21), 2,
      sym_directive_argument,
      sym_directive_dynamic_argument,
  [1888] = 4,
    ACTIONS(355), 1,
      sym_attribute_value,
    ACTIONS(357), 1,
      anon_sym_SQUOTE,
    ACTIONS(359), 1,
      anon_sym_DQUOTE,
    STATE(124), 1,
      sym_quoted_attribute_value,
  [1901] = 4,
    ACTIONS(361), 1,
      sym_attribute_value,
    ACTIONS(363), 1,
      anon_sym_SQUOTE,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    STATE(93), 1,
      sym_quoted_attribute_value,
  [1914] = 4,
    ACTIONS(367), 1,
      sym__start_tag_name,
    ACTIONS(369), 1,
      sym__template_start_tag_name,
    ACTIONS(371), 1,
      sym__script_start_tag_name,
    ACTIONS(373), 1,
      sym__style_start_tag_name,
  [1927] = 4,
    ACTIONS(369), 1,
      sym__template_start_tag_name,
    ACTIONS(371), 1,
      sym__script_start_tag_name,
    ACTIONS(373), 1,
      sym__style_start_tag_name,
    ACTIONS(375), 1,
      sym__start_tag_name,
  [1940] = 4,
    ACTIONS(363), 1,
      anon_sym_SQUOTE,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      sym_attribute_value,
    STATE(79), 1,
      sym_quoted_attribute_value,
  [1953] = 4,
    ACTIONS(357), 1,
      anon_sym_SQUOTE,
    ACTIONS(359), 1,
      anon_sym_DQUOTE,
    ACTIONS(379), 1,
      sym_attribute_value,
    STATE(128), 1,
      sym_quoted_attribute_value,
  [1966] = 4,
    ACTIONS(357), 1,
      anon_sym_SQUOTE,
    ACTIONS(359), 1,
      anon_sym_DQUOTE,
    ACTIONS(381), 1,
      sym_attribute_value,
    STATE(125), 1,
      sym_quoted_attribute_value,
  [1979] = 3,
    ACTIONS(383), 1,
      aux_sym_directive_argument_token1,
    ACTIONS(385), 1,
      anon_sym_LBRACK,
    STATE(31), 2,
      sym_directive_argument,
      sym_directive_dynamic_argument,
  [1990] = 4,
    ACTIONS(357), 1,
      anon_sym_SQUOTE,
    ACTIONS(359), 1,
      anon_sym_DQUOTE,
    ACTIONS(387), 1,
      sym_attribute_value,
    STATE(116), 1,
      sym_quoted_attribute_value,
  [2003] = 2,
    ACTIONS(337), 1,
      sym_attribute_name,
    ACTIONS(335), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2012] = 2,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(127), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2021] = 4,
    ACTIONS(357), 1,
      anon_sym_SQUOTE,
    ACTIONS(359), 1,
      anon_sym_DQUOTE,
    ACTIONS(389), 1,
      sym_attribute_value,
    STATE(115), 1,
      sym_quoted_attribute_value,
  [2034] = 3,
    ACTIONS(383), 1,
      aux_sym_directive_argument_token1,
    ACTIONS(385), 1,
      anon_sym_LBRACK,
    STATE(24), 2,
      sym_directive_argument,
      sym_directive_dynamic_argument,
  [2045] = 4,
    ACTIONS(363), 1,
      anon_sym_SQUOTE,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_attribute_value,
    STATE(86), 1,
      sym_quoted_attribute_value,
  [2058] = 4,
    ACTIONS(363), 1,
      anon_sym_SQUOTE,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    ACTIONS(393), 1,
      sym_attribute_value,
    STATE(88), 1,
      sym_quoted_attribute_value,
  [2071] = 4,
    ACTIONS(363), 1,
      anon_sym_SQUOTE,
    ACTIONS(365), 1,
      anon_sym_DQUOTE,
    ACTIONS(395), 1,
      sym_attribute_value,
    STATE(90), 1,
      sym_quoted_attribute_value,
  [2084] = 4,
    ACTIONS(369), 1,
      sym__template_start_tag_name,
    ACTIONS(371), 1,
      sym__script_start_tag_name,
    ACTIONS(373), 1,
      sym__style_start_tag_name,
    ACTIONS(397), 1,
      sym__start_tag_name,
  [2097] = 2,
    ACTIONS(321), 1,
      sym_attribute_name,
    ACTIONS(319), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2106] = 2,
    ACTIONS(333), 1,
      sym_attribute_name,
    ACTIONS(331), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2115] = 2,
    ACTIONS(313), 1,
      sym_attribute_name,
    ACTIONS(309), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2124] = 3,
    ACTIONS(351), 1,
      aux_sym_directive_argument_token1,
    ACTIONS(353), 1,
      anon_sym_LBRACK,
    STATE(20), 2,
      sym_directive_argument,
      sym_directive_dynamic_argument,
  [2135] = 2,
    ACTIONS(325), 1,
      sym_attribute_name,
    ACTIONS(323), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2144] = 2,
    ACTIONS(329), 1,
      sym_attribute_name,
    ACTIONS(327), 3,
      anon_sym_GT,
      sym_directive_name,
      sym_directive_shorthand,
  [2153] = 1,
    ACTIONS(301), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2159] = 1,
    ACTIONS(241), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2165] = 1,
    ACTIONS(249), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2171] = 1,
    ACTIONS(269), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2177] = 3,
    ACTIONS(399), 1,
      anon_sym_LT_SLASH,
    ACTIONS(401), 1,
      sym_raw_text,
    STATE(143), 1,
      sym_end_tag,
  [2187] = 3,
    ACTIONS(399), 1,
      anon_sym_LT_SLASH,
    ACTIONS(403), 1,
      sym_raw_text,
    STATE(142), 1,
      sym_end_tag,
  [2197] = 1,
    ACTIONS(257), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2203] = 3,
    ACTIONS(405), 1,
      anon_sym_LT_SLASH,
    ACTIONS(407), 1,
      sym_raw_text,
    STATE(89), 1,
      sym_end_tag,
  [2213] = 3,
    ACTIONS(405), 1,
      anon_sym_LT_SLASH,
    ACTIONS(409), 1,
      sym_raw_text,
    STATE(92), 1,
      sym_end_tag,
  [2223] = 1,
    ACTIONS(297), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2229] = 1,
    ACTIONS(245), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2235] = 1,
    ACTIONS(273), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2241] = 1,
    ACTIONS(253), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2247] = 1,
    ACTIONS(277), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2253] = 1,
    ACTIONS(281), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2259] = 3,
    ACTIONS(411), 1,
      anon_sym_LT_SLASH,
    ACTIONS(413), 1,
      sym_raw_text,
    STATE(62), 1,
      sym_end_tag,
  [2269] = 3,
    ACTIONS(411), 1,
      anon_sym_LT_SLASH,
    ACTIONS(415), 1,
      sym_raw_text,
    STATE(61), 1,
      sym_end_tag,
  [2279] = 1,
    ACTIONS(285), 3,
      sym_comment,
      ts_builtin_sym_end,
      anon_sym_LT,
  [2285] = 2,
    ACTIONS(417), 1,
      anon_sym_SQUOTE,
    ACTIONS(419), 1,
      aux_sym_quoted_attribute_value_token1,
  [2292] = 2,
    ACTIONS(399), 1,
      anon_sym_LT_SLASH,
    STATE(131), 1,
      sym_end_tag,
  [2299] = 2,
    ACTIONS(421), 1,
      sym__end_tag_name,
    ACTIONS(423), 1,
      sym_erroneous_end_tag_name,
  [2306] = 2,
    ACTIONS(421), 1,
      sym__end_tag_name,
    ACTIONS(425), 1,
      sym_erroneous_end_tag_name,
  [2313] = 2,
    ACTIONS(427), 1,
      aux_sym_directive_argument_token1,
    STATE(70), 1,
      sym_directive_modifier,
  [2320] = 2,
    ACTIONS(429), 1,
      anon_sym_RBRACK,
    ACTIONS(431), 1,
      sym_directive_dynamic_argument_value,
  [2327] = 1,
    ACTIONS(433), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [2332] = 2,
    ACTIONS(423), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(435), 1,
      sym__end_tag_name,
  [2339] = 1,
    ACTIONS(437), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [2344] = 2,
    ACTIONS(405), 1,
      anon_sym_LT_SLASH,
    STATE(80), 1,
      sym_end_tag,
  [2351] = 2,
    ACTIONS(439), 1,
      anon_sym_SQUOTE,
    ACTIONS(441), 1,
      aux_sym_quoted_attribute_value_token1,
  [2358] = 2,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    ACTIONS(443), 1,
      aux_sym_quoted_attribute_value_token2,
  [2365] = 2,
    ACTIONS(423), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(445), 1,
      sym__end_tag_name,
  [2372] = 2,
    ACTIONS(405), 1,
      anon_sym_LT_SLASH,
    STATE(81), 1,
      sym_end_tag,
  [2379] = 1,
    ACTIONS(447), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [2384] = 2,
    ACTIONS(449), 1,
      anon_sym_RBRACK,
    ACTIONS(451), 1,
      sym_directive_dynamic_argument_value,
  [2391] = 2,
    ACTIONS(417), 1,
      anon_sym_DQUOTE,
    ACTIONS(453), 1,
      aux_sym_quoted_attribute_value_token2,
  [2398] = 2,
    ACTIONS(455), 1,
      aux_sym_directive_argument_token1,
    STATE(45), 1,
      sym_directive_modifier,
  [2405] = 1,
    ACTIONS(457), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [2410] = 2,
    ACTIONS(411), 1,
      anon_sym_LT_SLASH,
    STATE(51), 1,
      sym_end_tag,
  [2417] = 2,
    ACTIONS(411), 1,
      anon_sym_LT_SLASH,
    STATE(49), 1,
      sym_end_tag,
  [2424] = 2,
    ACTIONS(425), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(445), 1,
      sym__end_tag_name,
  [2431] = 2,
    ACTIONS(399), 1,
      anon_sym_LT_SLASH,
    STATE(130), 1,
      sym_end_tag,
  [2438] = 2,
    ACTIONS(425), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(435), 1,
      sym__end_tag_name,
  [2445] = 1,
    ACTIONS(459), 1,
      anon_sym_SQUOTE,
  [2449] = 1,
    ACTIONS(459), 1,
      anon_sym_DQUOTE,
  [2453] = 1,
    ACTIONS(461), 1,
      anon_sym_RBRACK,
  [2457] = 1,
    ACTIONS(463), 1,
      anon_sym_RBRACE_RBRACE,
  [2461] = 1,
    ACTIONS(465), 1,
      anon_sym_DQUOTE,
  [2465] = 1,
    ACTIONS(425), 1,
      sym_erroneous_end_tag_name,
  [2469] = 1,
    ACTIONS(467), 1,
      anon_sym_RBRACK,
  [2473] = 1,
    ACTIONS(469), 1,
      anon_sym_GT,
  [2477] = 1,
    ACTIONS(471), 1,
      ts_builtin_sym_end,
  [2481] = 1,
    ACTIONS(473), 1,
      anon_sym_GT,
  [2485] = 1,
    ACTIONS(475), 1,
      anon_sym_RBRACE_RBRACE,
  [2489] = 1,
    ACTIONS(477), 1,
      anon_sym_GT,
  [2493] = 1,
    ACTIONS(445), 1,
      sym__end_tag_name,
  [2497] = 1,
    ACTIONS(423), 1,
      sym_erroneous_end_tag_name,
  [2501] = 1,
    ACTIONS(479), 1,
      anon_sym_GT,
  [2505] = 1,
    ACTIONS(421), 1,
      sym__end_tag_name,
  [2509] = 1,
    ACTIONS(481), 1,
      anon_sym_GT,
  [2513] = 1,
    ACTIONS(435), 1,
      sym__end_tag_name,
  [2517] = 1,
    ACTIONS(465), 1,
      anon_sym_SQUOTE,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 48,
  [SMALL_STATE(4)] = 96,
  [SMALL_STATE(5)] = 144,
  [SMALL_STATE(6)] = 192,
  [SMALL_STATE(7)] = 240,
  [SMALL_STATE(8)] = 288,
  [SMALL_STATE(9)] = 333,
  [SMALL_STATE(10)] = 378,
  [SMALL_STATE(11)] = 423,
  [SMALL_STATE(12)] = 468,
  [SMALL_STATE(13)] = 513,
  [SMALL_STATE(14)] = 558,
  [SMALL_STATE(15)] = 603,
  [SMALL_STATE(16)] = 645,
  [SMALL_STATE(17)] = 677,
  [SMALL_STATE(18)] = 709,
  [SMALL_STATE(19)] = 734,
  [SMALL_STATE(20)] = 758,
  [SMALL_STATE(21)] = 780,
  [SMALL_STATE(22)] = 802,
  [SMALL_STATE(23)] = 823,
  [SMALL_STATE(24)] = 840,
  [SMALL_STATE(25)] = 861,
  [SMALL_STATE(26)] = 878,
  [SMALL_STATE(27)] = 899,
  [SMALL_STATE(28)] = 916,
  [SMALL_STATE(29)] = 937,
  [SMALL_STATE(30)] = 958,
  [SMALL_STATE(31)] = 979,
  [SMALL_STATE(32)] = 1000,
  [SMALL_STATE(33)] = 1021,
  [SMALL_STATE(34)] = 1040,
  [SMALL_STATE(35)] = 1058,
  [SMALL_STATE(36)] = 1074,
  [SMALL_STATE(37)] = 1092,
  [SMALL_STATE(38)] = 1110,
  [SMALL_STATE(39)] = 1128,
  [SMALL_STATE(40)] = 1144,
  [SMALL_STATE(41)] = 1156,
  [SMALL_STATE(42)] = 1174,
  [SMALL_STATE(43)] = 1186,
  [SMALL_STATE(44)] = 1198,
  [SMALL_STATE(45)] = 1210,
  [SMALL_STATE(46)] = 1222,
  [SMALL_STATE(47)] = 1240,
  [SMALL_STATE(48)] = 1256,
  [SMALL_STATE(49)] = 1274,
  [SMALL_STATE(50)] = 1285,
  [SMALL_STATE(51)] = 1296,
  [SMALL_STATE(52)] = 1307,
  [SMALL_STATE(53)] = 1320,
  [SMALL_STATE(54)] = 1331,
  [SMALL_STATE(55)] = 1342,
  [SMALL_STATE(56)] = 1353,
  [SMALL_STATE(57)] = 1364,
  [SMALL_STATE(58)] = 1375,
  [SMALL_STATE(59)] = 1386,
  [SMALL_STATE(60)] = 1397,
  [SMALL_STATE(61)] = 1408,
  [SMALL_STATE(62)] = 1419,
  [SMALL_STATE(63)] = 1430,
  [SMALL_STATE(64)] = 1441,
  [SMALL_STATE(65)] = 1452,
  [SMALL_STATE(66)] = 1463,
  [SMALL_STATE(67)] = 1474,
  [SMALL_STATE(68)] = 1485,
  [SMALL_STATE(69)] = 1496,
  [SMALL_STATE(70)] = 1509,
  [SMALL_STATE(71)] = 1520,
  [SMALL_STATE(72)] = 1531,
  [SMALL_STATE(73)] = 1544,
  [SMALL_STATE(74)] = 1555,
  [SMALL_STATE(75)] = 1568,
  [SMALL_STATE(76)] = 1579,
  [SMALL_STATE(77)] = 1589,
  [SMALL_STATE(78)] = 1601,
  [SMALL_STATE(79)] = 1611,
  [SMALL_STATE(80)] = 1621,
  [SMALL_STATE(81)] = 1631,
  [SMALL_STATE(82)] = 1641,
  [SMALL_STATE(83)] = 1651,
  [SMALL_STATE(84)] = 1661,
  [SMALL_STATE(85)] = 1671,
  [SMALL_STATE(86)] = 1681,
  [SMALL_STATE(87)] = 1691,
  [SMALL_STATE(88)] = 1701,
  [SMALL_STATE(89)] = 1711,
  [SMALL_STATE(90)] = 1721,
  [SMALL_STATE(91)] = 1731,
  [SMALL_STATE(92)] = 1741,
  [SMALL_STATE(93)] = 1751,
  [SMALL_STATE(94)] = 1761,
  [SMALL_STATE(95)] = 1771,
  [SMALL_STATE(96)] = 1781,
  [SMALL_STATE(97)] = 1791,
  [SMALL_STATE(98)] = 1803,
  [SMALL_STATE(99)] = 1815,
  [SMALL_STATE(100)] = 1825,
  [SMALL_STATE(101)] = 1835,
  [SMALL_STATE(102)] = 1847,
  [SMALL_STATE(103)] = 1857,
  [SMALL_STATE(104)] = 1867,
  [SMALL_STATE(105)] = 1877,
  [SMALL_STATE(106)] = 1888,
  [SMALL_STATE(107)] = 1901,
  [SMALL_STATE(108)] = 1914,
  [SMALL_STATE(109)] = 1927,
  [SMALL_STATE(110)] = 1940,
  [SMALL_STATE(111)] = 1953,
  [SMALL_STATE(112)] = 1966,
  [SMALL_STATE(113)] = 1979,
  [SMALL_STATE(114)] = 1990,
  [SMALL_STATE(115)] = 2003,
  [SMALL_STATE(116)] = 2012,
  [SMALL_STATE(117)] = 2021,
  [SMALL_STATE(118)] = 2034,
  [SMALL_STATE(119)] = 2045,
  [SMALL_STATE(120)] = 2058,
  [SMALL_STATE(121)] = 2071,
  [SMALL_STATE(122)] = 2084,
  [SMALL_STATE(123)] = 2097,
  [SMALL_STATE(124)] = 2106,
  [SMALL_STATE(125)] = 2115,
  [SMALL_STATE(126)] = 2124,
  [SMALL_STATE(127)] = 2135,
  [SMALL_STATE(128)] = 2144,
  [SMALL_STATE(129)] = 2153,
  [SMALL_STATE(130)] = 2159,
  [SMALL_STATE(131)] = 2165,
  [SMALL_STATE(132)] = 2171,
  [SMALL_STATE(133)] = 2177,
  [SMALL_STATE(134)] = 2187,
  [SMALL_STATE(135)] = 2197,
  [SMALL_STATE(136)] = 2203,
  [SMALL_STATE(137)] = 2213,
  [SMALL_STATE(138)] = 2223,
  [SMALL_STATE(139)] = 2229,
  [SMALL_STATE(140)] = 2235,
  [SMALL_STATE(141)] = 2241,
  [SMALL_STATE(142)] = 2247,
  [SMALL_STATE(143)] = 2253,
  [SMALL_STATE(144)] = 2259,
  [SMALL_STATE(145)] = 2269,
  [SMALL_STATE(146)] = 2279,
  [SMALL_STATE(147)] = 2285,
  [SMALL_STATE(148)] = 2292,
  [SMALL_STATE(149)] = 2299,
  [SMALL_STATE(150)] = 2306,
  [SMALL_STATE(151)] = 2313,
  [SMALL_STATE(152)] = 2320,
  [SMALL_STATE(153)] = 2327,
  [SMALL_STATE(154)] = 2332,
  [SMALL_STATE(155)] = 2339,
  [SMALL_STATE(156)] = 2344,
  [SMALL_STATE(157)] = 2351,
  [SMALL_STATE(158)] = 2358,
  [SMALL_STATE(159)] = 2365,
  [SMALL_STATE(160)] = 2372,
  [SMALL_STATE(161)] = 2379,
  [SMALL_STATE(162)] = 2384,
  [SMALL_STATE(163)] = 2391,
  [SMALL_STATE(164)] = 2398,
  [SMALL_STATE(165)] = 2405,
  [SMALL_STATE(166)] = 2410,
  [SMALL_STATE(167)] = 2417,
  [SMALL_STATE(168)] = 2424,
  [SMALL_STATE(169)] = 2431,
  [SMALL_STATE(170)] = 2438,
  [SMALL_STATE(171)] = 2445,
  [SMALL_STATE(172)] = 2449,
  [SMALL_STATE(173)] = 2453,
  [SMALL_STATE(174)] = 2457,
  [SMALL_STATE(175)] = 2461,
  [SMALL_STATE(176)] = 2465,
  [SMALL_STATE(177)] = 2469,
  [SMALL_STATE(178)] = 2473,
  [SMALL_STATE(179)] = 2477,
  [SMALL_STATE(180)] = 2481,
  [SMALL_STATE(181)] = 2485,
  [SMALL_STATE(182)] = 2489,
  [SMALL_STATE(183)] = 2493,
  [SMALL_STATE(184)] = 2497,
  [SMALL_STATE(185)] = 2501,
  [SMALL_STATE(186)] = 2505,
  [SMALL_STATE(187)] = 2509,
  [SMALL_STATE(188)] = 2513,
  [SMALL_STATE(189)] = 2517,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_component, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [57] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(109),
  [60] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(176),
  [63] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(27),
  [66] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(53),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(11),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [78] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(108),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(184),
  [84] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(35),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(91),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_repeat1, 2), SHIFT_REPEAT(15),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_component, 1),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_component_repeat1, 2),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_component_repeat1, 2), SHIFT_REPEAT(122),
  [102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_component_repeat1, 2), SHIFT_REPEAT(17),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 1),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 1),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 2),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 2),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 3),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 3),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_modifiers, 1),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_modifiers, 1),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_directive_modifiers_repeat1, 2),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_directive_modifiers_repeat1, 2),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_directive_modifiers_repeat1, 2), SHIFT_REPEAT(164),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 1),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 1),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2),
  [180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(72),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(18),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(126),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_directive_modifiers_repeat1, 2), SHIFT_REPEAT(151),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_dynamic_argument, 2),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_dynamic_argument, 2),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(98),
  [217] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(19),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(118),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_dynamic_argument, 3),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_dynamic_argument, 3),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_argument, 1),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_argument, 1),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_modifier, 1),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_modifier, 1),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_element, 3),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_element, 3),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 2),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 2),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_element, 2),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_element, 2),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_erroneous_end_tag, 3),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_erroneous_end_tag, 3),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 1),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 4),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 4),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_attribute_value, 2),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_attribute_value, 3),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 5),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 5),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive_attribute, 6),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_directive_attribute, 6),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 3),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_start_tag, 4),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_start_tag, 4),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_start_tag, 3),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_start_tag, 3),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [383] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [471] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_vue_external_scanner_create(void);
void tree_sitter_vue_external_scanner_destroy(void *);
bool tree_sitter_vue_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_vue_external_scanner_serialize(void *, char *);
void tree_sitter_vue_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_vue(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      (const bool *)ts_external_scanner_states,
      ts_external_scanner_symbol_map,
      tree_sitter_vue_external_scanner_create,
      tree_sitter_vue_external_scanner_destroy,
      tree_sitter_vue_external_scanner_scan,
      tree_sitter_vue_external_scanner_serialize,
      tree_sitter_vue_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
