/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.DPIUtil;

public class GtkDPIUtil {
    static {
        DPIUtil.setUseSmoothScalingByDefaultProvider(() -> DPIUtil.getDeviceZoom() / 100 * 100 != DPIUtil.getDeviceZoom());
    }

    public static ImageData pointToPixel(Device device, ImageData imageData) {
        int imageDataZoomFactor = 100;
        if (DPIUtil.getDeviceZoom() == imageDataZoomFactor || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)DPIUtil.getDeviceZoom() / (float)imageDataZoomFactor;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }
}

