/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentChars;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class PostgreContentJSON
extends JDBCContentChars {
    public PostgreContentJSON(DBCExecutionContext executionContext, String json) {
        super(executionContext, json);
    }

    private PostgreContentJSON(PostgreContentJSON copyFrom) {
        super((JDBCContentChars)copyFrom);
    }

    @NotNull
    public String getContentType() {
        return "text/json";
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            if (this.data != null) {
                preparedStatement.setObject(paramIndex, (Object)this.data, 1111);
            } else {
                preparedStatement.setNull(paramIndex, columnType.getTypeID());
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public String getDisplayString(@NotNull DBDDisplayFormat format) {
        return this.data == null ? null : (format == DBDDisplayFormat.EDIT ? this.data : CommonUtils.compactWhiteSpaces((String)this.data));
    }

    public PostgreContentJSON cloneValue(DBRProgressMonitor monitor) {
        return new PostgreContentJSON(this);
    }
}

