//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssteppertouchbaritem?language=objc)
    #[unsafe(super(NSTouchBarItem, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSTouchBarItem")]
    pub struct NSStepperTouchBarItem;
);

#[cfg(feature = "NSTouchBarItem")]
extern_conformance!(
    unsafe impl NSCoding for NSStepperTouchBarItem {}
);

#[cfg(feature = "NSTouchBarItem")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSStepperTouchBarItem {}
);

#[cfg(feature = "NSTouchBarItem")]
impl NSStepperTouchBarItem {
    extern_methods!(
        /// Creates an `NSStepperTouchBarItem` with a `formatter` to display the stepper's value as text
        ///
        ///
        /// Parameter `formatter`: A formatter used to display a textual representation of the stepper's value
        #[unsafe(method(stepperTouchBarItemWithIdentifier:formatter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stepperTouchBarItemWithIdentifier_formatter(
            identifier: &NSTouchBarItemIdentifier,
            formatter: &NSFormatter,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        /// Creates an `NSStepperTouchBarItem` using the result of `drawingHandler` to display the stepper's value as an image
        ///
        ///
        /// Parameter `drawingHandler`: A block that draws a graphical representation of the stepper's value in the specified rectangle. The coordinates of this rectangle are specified in points.
        #[unsafe(method(stepperTouchBarItemWithIdentifier:drawingHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stepperTouchBarItemWithIdentifier_drawingHandler(
            identifier: &NSTouchBarItemIdentifier,
            drawing_handler: &block2::DynBlock<dyn Fn(NSRect, c_double)>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// The stepper's maximum value. The default is 59.0.
        #[unsafe(method(maxValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn maxValue(&self) -> c_double;

        /// Setter for [`maxValue`][Self::maxValue].
        #[unsafe(method(setMaxValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaxValue(&self, max_value: c_double);

        /// The stepper's minimum value. The default is 0.0.
        #[unsafe(method(minValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn minValue(&self) -> c_double;

        /// Setter for [`minValue`][Self::minValue].
        #[unsafe(method(setMinValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinValue(&self, min_value: c_double);

        /// The stepper's increment value. The default is 1.0.
        #[unsafe(method(increment))]
        #[unsafe(method_family = none)]
        pub unsafe fn increment(&self) -> c_double;

        /// Setter for [`increment`][Self::increment].
        #[unsafe(method(setIncrement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIncrement(&self, increment: c_double);

        /// The current value of the stepper.
        #[unsafe(method(value))]
        #[unsafe(method_family = none)]
        pub unsafe fn value(&self) -> c_double;

        /// Setter for [`value`][Self::value].
        #[unsafe(method(setValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setValue(&self, value: c_double);

        /// The target object that receives action messages from the stepper.
        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub unsafe fn target(&self) -> Option<Retained<AnyObject>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`target`][Self::target].
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        /// The action-message selector associated with the stepper.
        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub unsafe fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        /// The localized string labelling this item during user customization. The default value is empty string.
        #[unsafe(method(customizationLabel))]
        #[unsafe(method_family = none)]
        pub unsafe fn customizationLabel(&self) -> Retained<NSString>;

        /// Setter for [`customizationLabel`][Self::customizationLabel].
        #[unsafe(method(setCustomizationLabel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomizationLabel(&self, customization_label: Option<&NSString>);
    );
}

/// Methods declared on superclass `NSTouchBarItem`.
#[cfg(feature = "NSTouchBarItem")]
impl NSStepperTouchBarItem {
    extern_methods!(
        #[unsafe(method(initWithIdentifier:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIdentifier(
            this: Allocated<Self>,
            identifier: &NSTouchBarItemIdentifier,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSTouchBarItem")]
impl NSStepperTouchBarItem {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
