/*
 *  YASS 1.14
 *  Copyright (C) 2004-2010
 *  the YASS team
 *  Laurent Noe, Gregory Kucherov, Mikhail Roytberg, 
 *  Steven Corroy, Antoine De Monte, Christophe Valmir.
 *
 *  laurent.noe|<A>|lifl.fr
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the CeCILL License as published by
 *  the CEA-CNRS-INRIA; either version 2 of the License, or (at your
 *  option) any later version, and the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This software contains code derived from the GNU libavl library.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef __HASH_H__
#define __HASH_H__

/*
 *  Structure interne a la biliotheque
 * 
 *
 */
typedef struct _Hash_Element HashElement;
struct _Hash_Element {
  long int  diagonal;
  long int  value;

  HashElement *next;        /*Suivant dans la table de hach (evite les collitions*/
  HashElement *prev;

  HashElement *young_next;  /*Suivant dans la liste des insertions */
  HashElement *old_next;

};


typedef struct _Table_hash {
 
  long int size;
  long int mask;
  HashElement **element;
  
  HashElement *firstElement;  /*Premier element alloue (Pour liberer la memoire)*/
  HashElement *elementFree;   /*elements libres */
  HashElement *element_old;   /*premier element inserer dans la table de hash*/
  HashElement *element_young; /*dernier   element inserer dans la table */
  
}Table_hash;


/*
 *
 *  Initialisation de la table de Table
 *  de taille SIZE
 *
 *  Plus la taille est grande plus l'algorithme est
 *  rapide mais prends beaucoup de memoire.
 *
 */
Table_hash initHash(long int size,long int nbreElement);


/*
 *   Recupere la valeur d une clef
 *   Retourne:  -1 si le nombre n'existe pas (voir existHashKey)
 *              la valeur
 *
 */
long int getHashValue (Table_hash *table,long int key);

long int getHashValueMin (Table_hash *table,long int diagonal,long int valueMin);


/*
 *  Etablie l'existance de la clef
 *  Return: -1 si la clef n'existe pas
 *          1 si elle existe
 *
 */
long int existHashDiag (Table_hash *table,long int key);


/*
 * Insere rapidement une clef et sa valeur
 * Attention: Il peut y avoir des toublons
 *
 */
long int putHashValue (Table_hash *table,long int key, long int value);


/*
 * Insere une clef unique et sa valeur
 * Si jamais la clef existe la valeur sera ecrase
 *
 */
long int putHashOneDiagValue (Table_hash *table,long int key, long int value) ;

long int delHash (Table_hash *table,long int diagonal);

/*
 *
 * Affiche toutes la table de hack
 *
 */
long int hashDisplay (Table_hash *table);


/*
 * 
 * supprime la table de hash
 *
 */
long int freeHash (Table_hash *table);

/*
 * 
 * reset: enleve tous les elements de la table pour les mettre dans free
 *
 */
long int resetHash (Table_hash *table);

#endif
