#include <errno.h>
#include <stdio.h>
#include <string.h>

void opendir_errmsg(int e, const char * path) {
  fprintf(stderr, "error: a problem occurred while trying to process the directory %s\n", path);
  fprintf(stderr, "error: %s\n", strerror(e));
}

void exec_errmsg(int e, const char * progname) {
  fprintf(stderr, "error: problem occurred while trying to call %s\n", progname);
  fprintf(stderr, "error: %s\n", strerror(e));
}

void fork_errmsg(int e) {
  fprintf(stderr, "error: problem occurred while trying to fork a process");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void wait_errmsg(int e) {
  fprintf(stderr, "error: problem waiting for child process");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void fopen_errmsg(int e, char * fpath) {
  fprintf(stderr, "error: problem opening file %s\n", fpath);
  fprintf(stderr, "error: %s\n", strerror(e));
}

void mkdtemp_errmsg(int e) {
  fprintf(stderr, "error: problem creating temporary directory");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void chdir_errmsg(int e, const char * wrkdir) {
  fprintf(stderr, "error: problem changing directory to %s\n", wrkdir);
  fprintf(stderr, "error: %s\n", strerror(e));
}

void fchdir_errmsg(int e) {
  fprintf(stderr, "error: problem changing directory during fchdir call");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void close_errmsg(int e) {
  fprintf(stderr, "error: problem trying to close file stream");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void readdir_errmsg(int e) {
  fprintf(stderr, "error: a problem occurred while trying to read a directory");
  fprintf(stderr, "error: %s\n", strerror(e));
}

void stat_errmsg(int e) {
  fprintf(stderr, "error: problem getting file status information");
  fprintf(stderr, "error: %s\n", strerror(e));
}

