#ifndef UOGETOPT_H
#define UOGETOPT_H

#define UOGO_FLAG   0 /* (*var) shall be "val": this means _no_ argument */
#define UOGO_FLAGOR 1 /* (*var) shall be "(*arg)|val": this means _no_ argument */
#define UOGO_STRING 2 /* (*var) shall be pointer to argument */
#define UOGO_ULONG  4 /* (*var)=strtoul(argument) */
#define UOGO_LONG   5 /* (*var)=strtol(argument) */
#define UOGO_CALLBACK 6 /* var is function ptr: int (*fn)(struct uogetopt *, const char *) */

struct uogetopt {
	char shortname;
	const char *longname;
	int argtype; /* 0 or 1 no argument, set (*arg) from val. */
	void *var; /* mandatory */
	int val; /* val for *var in case of type 0 or 1 */
	const char *help;
	const char *paraname;
};

void uogetopt P__((
	const char *prog, const char *package, const char *version,
	int *argc, char **argv, /* note: "int *" */
	void (*out)(int iserr,const char *), 
	const char *head,
	struct uogetopt *,
	const char *tail));

void uogetopt_out P__((int iserr,const char *s));

#endif
