/* gpx-parser-xml.c generated by valac 0.20.1, the Vala compiler
 * generated from gpx-parser-xml.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2013 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "gpx.h"
#include <gio/gio.h>
#include <libxml/tree.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libxml/xmlIO.h>
#include <libxml/xmlreader.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

struct _GpxXmlFilePrivate {
	GFileInputStream* stream;
};


static gpointer gpx_xml_file_parent_class = NULL;

#define GPX_XML_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_TYPE_XML_FILE, GpxXmlFilePrivate))
enum  {
	GPX_XML_FILE_DUMMY_PROPERTY
};
static GpxTrack* gpx_xml_file_parse_track (GpxXmlFile* self, xmlNode* node);
static void gpx_xml_file_parse_waypoint (GpxXmlFile* self, xmlNode* node);
static GpxTrack* gpx_xml_file_parse_route (GpxXmlFile* self, xmlNode* node);
static gint gpx_xml_file_read_file (GpxXmlFile* self, guint8* buffer, int buffer_length1);
static gint gpx_xml_file_close_file (GpxXmlFile* self);
static void gpx_xml_file_finalize (GObject* obj);


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static GpxTrack* gpx_xml_file_parse_track (GpxXmlFile* self, xmlNode* node) {
	GpxTrack* result = NULL;
	GpxTrack* _tmp0_;
	GpxTrack* track;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* trkseg;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gpx_track_new ();
	track = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->children;
	trkseg = _tmp2_;
	while (TRUE) {
		xmlNode* _tmp3_;
		xmlNode* _tmp4_;
		const gchar* _tmp5_;
		xmlNode* _tmp78_;
		const gchar* _tmp79_;
		xmlNode* _tmp90_;
		xmlNode* _tmp91_;
		_tmp3_ = trkseg;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = trkseg;
		_tmp5_ = _tmp4_->name;
		if (g_strcmp0 (_tmp5_, "trkseg") == 0) {
			xmlNode* _tmp6_;
			xmlNode* _tmp7_;
			xmlNode* point;
			_tmp6_ = trkseg;
			_tmp7_ = _tmp6_->children;
			point = _tmp7_;
			while (TRUE) {
				xmlNode* _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				xmlNode* _tmp76_;
				xmlNode* _tmp77_;
				_tmp8_ = point;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = point;
				_tmp10_ = _tmp9_->name;
				if (g_strcmp0 (_tmp10_, "trkpt") == 0) {
					xmlNode* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* lat;
					xmlNode* _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* lon;
					gboolean _tmp15_ = FALSE;
					const gchar* _tmp16_;
					gboolean _tmp18_;
					_tmp11_ = point;
					_tmp12_ = xmlGetProp (_tmp11_, "lat");
					lat = _tmp12_;
					_tmp13_ = point;
					_tmp14_ = xmlGetProp (_tmp13_, "lon");
					lon = _tmp14_;
					_tmp16_ = lat;
					if (_tmp16_ != NULL) {
						const gchar* _tmp17_;
						_tmp17_ = lon;
						_tmp15_ = _tmp17_ != NULL;
					} else {
						_tmp15_ = FALSE;
					}
					_tmp18_ = _tmp15_;
					if (_tmp18_) {
						GpxPoint* _tmp19_;
						GpxPoint* p;
						const gchar* _tmp20_;
						gdouble _tmp21_ = 0.0;
						gdouble flat;
						const gchar* _tmp22_;
						gdouble _tmp23_ = 0.0;
						gdouble flon;
						GpxPoint* _tmp24_;
						gdouble _tmp25_;
						gdouble _tmp26_;
						xmlNode* _tmp27_;
						xmlNode* _tmp28_;
						xmlNode* info;
						GpxPoint* _tmp70_;
						const gchar* _tmp71_;
						_tmp19_ = gpx_point_new ();
						p = _tmp19_;
						_tmp20_ = lat;
						_tmp21_ = double_parse (_tmp20_);
						flat = _tmp21_;
						_tmp22_ = lon;
						_tmp23_ = double_parse (_tmp22_);
						flon = _tmp23_;
						_tmp24_ = p;
						_tmp25_ = flat;
						_tmp26_ = flon;
						gpx_point_set_position (_tmp24_, _tmp25_, _tmp26_);
						_tmp27_ = point;
						_tmp28_ = _tmp27_->children;
						info = _tmp28_;
						while (TRUE) {
							xmlNode* _tmp29_;
							xmlNode* _tmp30_;
							const gchar* _tmp31_;
							xmlNode* _tmp68_;
							xmlNode* _tmp69_;
							_tmp29_ = info;
							if (!(_tmp29_ != NULL)) {
								break;
							}
							_tmp30_ = info;
							_tmp31_ = _tmp30_->name;
							if (g_strcmp0 (_tmp31_, "ele") == 0) {
								xmlNode* _tmp32_;
								gchar* _tmp33_ = NULL;
								gchar* content;
								const gchar* _tmp34_;
								_tmp32_ = info;
								_tmp33_ = xmlNodeGetContent (_tmp32_);
								content = _tmp33_;
								_tmp34_ = content;
								if (_tmp34_ != NULL) {
									GpxPoint* _tmp35_;
									const gchar* _tmp36_;
									gdouble _tmp37_ = 0.0;
									_tmp35_ = p;
									_tmp36_ = content;
									_tmp37_ = double_parse (_tmp36_);
									_tmp35_->elevation = _tmp37_;
								}
								_g_free0 (content);
							} else {
								xmlNode* _tmp38_;
								const gchar* _tmp39_;
								_tmp38_ = info;
								_tmp39_ = _tmp38_->name;
								if (g_strcmp0 (_tmp39_, "time") == 0) {
									GpxPoint* _tmp40_;
									xmlNode* _tmp41_;
									gchar* _tmp42_ = NULL;
									_tmp40_ = p;
									_tmp41_ = info;
									_tmp42_ = xmlNodeGetContent (_tmp41_);
									_g_free0 (_tmp40_->time);
									_tmp40_->time = _tmp42_;
								} else {
									xmlNode* _tmp43_;
									const gchar* _tmp44_;
									_tmp43_ = info;
									_tmp44_ = _tmp43_->name;
									if (g_strcmp0 (_tmp44_, "extensions") == 0) {
										xmlNode* _tmp45_;
										xmlNode* _tmp46_;
										xmlNode* exts;
										_tmp45_ = info;
										_tmp46_ = _tmp45_->children;
										exts = _tmp46_;
										{
											gboolean _tmp47_;
											_tmp47_ = TRUE;
											while (TRUE) {
												gboolean _tmp48_;
												xmlNode* _tmp51_;
												xmlNode* _tmp52_;
												const gchar* _tmp53_;
												_tmp48_ = _tmp47_;
												if (!_tmp48_) {
													xmlNode* _tmp49_;
													xmlNode* _tmp50_;
													_tmp49_ = exts;
													_tmp50_ = _tmp49_->next;
													exts = _tmp50_;
												}
												_tmp47_ = FALSE;
												_tmp51_ = exts;
												if (!(_tmp51_ != NULL)) {
													break;
												}
												_tmp52_ = exts;
												_tmp53_ = _tmp52_->name;
												if (g_strcmp0 (_tmp53_, "TrackPointExtension") == 0) {
													xmlNode* _tmp54_;
													xmlNode* _tmp55_;
													xmlNode* ext;
													_tmp54_ = exts;
													_tmp55_ = _tmp54_->children;
													ext = _tmp55_;
													{
														gboolean _tmp56_;
														_tmp56_ = TRUE;
														while (TRUE) {
															gboolean _tmp57_;
															xmlNode* _tmp60_;
															xmlNode* _tmp61_;
															const gchar* _tmp62_;
															_tmp57_ = _tmp56_;
															if (!_tmp57_) {
																xmlNode* _tmp58_;
																xmlNode* _tmp59_;
																_tmp58_ = ext;
																_tmp59_ = _tmp58_->next;
																ext = _tmp59_;
															}
															_tmp56_ = FALSE;
															_tmp60_ = ext;
															if (!(_tmp60_ != NULL)) {
																break;
															}
															_tmp61_ = ext;
															_tmp62_ = _tmp61_->name;
															if (g_strcmp0 (_tmp62_, "hr") == 0) {
																xmlNode* _tmp63_;
																gchar* _tmp64_ = NULL;
																gchar* val;
																GpxPoint* _tmp65_;
																const gchar* _tmp66_;
																gint _tmp67_ = 0;
																_tmp63_ = ext;
																_tmp64_ = xmlNodeGetContent (_tmp63_);
																val = _tmp64_;
																_tmp65_ = p;
																_tmp66_ = val;
																_tmp67_ = atoi (_tmp66_);
																_tmp65_->tpe.heartrate = _tmp67_;
																_g_free0 (val);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							_tmp68_ = info;
							_tmp69_ = _tmp68_->next;
							info = _tmp69_;
						}
						_tmp70_ = p;
						_tmp71_ = _tmp70_->time;
						if (_tmp71_ != NULL) {
							GpxTrack* _tmp72_;
							GpxPoint* _tmp73_;
							_tmp72_ = track;
							_tmp73_ = p;
							gpx_track_add_point (_tmp72_, _tmp73_);
						}
						_gpx_point_unref0 (p);
					} else {
						xmlNode* _tmp74_;
						const gchar* _tmp75_;
						_tmp74_ = point;
						_tmp75_ = _tmp74_->name;
						g_message ("gpx-parser-xml.vala:94: Failed to get point: %s\n", _tmp75_);
					}
					_g_free0 (lon);
					_g_free0 (lat);
				}
				_tmp76_ = point;
				_tmp77_ = _tmp76_->next;
				point = _tmp77_;
			}
		}
		_tmp78_ = trkseg;
		_tmp79_ = _tmp78_->name;
		if (g_strcmp0 (_tmp79_, "name") == 0) {
			GpxTrack* _tmp80_;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			_tmp80_ = track;
			_tmp81_ = gpx_track_get_name (_tmp80_);
			_tmp82_ = _tmp81_;
			if (_tmp82_ == NULL) {
				GpxTrack* _tmp83_;
				xmlNode* _tmp84_;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_;
				_tmp83_ = track;
				_tmp84_ = trkseg;
				_tmp85_ = xmlNodeGetContent (_tmp84_);
				_tmp86_ = _tmp85_;
				gpx_track_set_name (_tmp83_, _tmp86_);
				_g_free0 (_tmp86_);
			} else {
				GpxTrack* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				_tmp87_ = track;
				_tmp88_ = gpx_track_get_name (_tmp87_);
				_tmp89_ = _tmp88_;
				g_warning ("gpx-parser-xml.vala:108: Track name allready set: %s\n", _tmp89_);
			}
		}
		_tmp90_ = trkseg;
		_tmp91_ = _tmp90_->next;
		trkseg = _tmp91_;
	}
	result = track;
	return result;
}


static gpointer _gpx_point_ref0 (gpointer self) {
	return self ? gpx_point_ref (self) : NULL;
}


static void gpx_xml_file_parse_waypoint (GpxXmlFile* self, xmlNode* node) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lat;
	xmlNode* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* lon;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, "lat");
	lat = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = xmlGetProp (_tmp2_, "lon");
	lon = _tmp3_;
	_tmp5_ = lat;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = lon;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GpxPoint* _tmp8_;
		GpxPoint* p;
		const gchar* _tmp9_;
		gdouble _tmp10_ = 0.0;
		gdouble flat;
		const gchar* _tmp11_;
		gdouble _tmp12_ = 0.0;
		gdouble flon;
		GpxPoint* _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		xmlNode* _tmp16_;
		xmlNode* _tmp17_;
		xmlNode* info;
		GpxPoint* _tmp33_;
		GpxPoint* _tmp34_;
		_tmp8_ = gpx_point_new ();
		p = _tmp8_;
		_tmp9_ = lat;
		_tmp10_ = double_parse (_tmp9_);
		flat = _tmp10_;
		_tmp11_ = lon;
		_tmp12_ = double_parse (_tmp11_);
		flon = _tmp12_;
		_tmp13_ = p;
		_tmp14_ = flat;
		_tmp15_ = flon;
		gpx_point_set_position (_tmp13_, _tmp14_, _tmp15_);
		_tmp16_ = node;
		_tmp17_ = _tmp16_->children;
		info = _tmp17_;
		while (TRUE) {
			xmlNode* _tmp18_;
			xmlNode* _tmp19_;
			const gchar* _tmp20_;
			xmlNode* _tmp31_;
			xmlNode* _tmp32_;
			_tmp18_ = info;
			if (!(_tmp18_ != NULL)) {
				break;
			}
			_tmp19_ = info;
			_tmp20_ = _tmp19_->name;
			if (g_strcmp0 (_tmp20_, "name") == 0) {
				GpxPoint* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = p;
				_tmp22_ = gpx_point_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == NULL) {
					GpxPoint* _tmp24_;
					xmlNode* _tmp25_;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_;
					_tmp24_ = p;
					_tmp25_ = info;
					_tmp26_ = xmlNodeGetContent (_tmp25_);
					_tmp27_ = _tmp26_;
					gpx_point_set_name (_tmp24_, _tmp27_);
					_g_free0 (_tmp27_);
				} else {
					GpxPoint* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp28_ = p;
					_tmp29_ = gpx_point_get_name (_tmp28_);
					_tmp30_ = _tmp29_;
					g_warning ("gpx-parser-xml.vala:139: Point name allready set: %s\n", _tmp30_);
				}
			}
			_tmp31_ = info;
			_tmp32_ = _tmp31_->next;
			info = _tmp32_;
		}
		_tmp33_ = p;
		_tmp34_ = _gpx_point_ref0 (_tmp33_);
		((GpxFileBase*) self)->waypoints = g_list_append (((GpxFileBase*) self)->waypoints, _tmp34_);
		_gpx_point_unref0 (p);
	}
	_g_free0 (lon);
	_g_free0 (lat);
}


static GpxTrack* gpx_xml_file_parse_route (GpxXmlFile* self, xmlNode* node) {
	GpxTrack* result = NULL;
	GpxTrack* _tmp0_;
	GpxTrack* track;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* trkseg;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gpx_track_new ();
	track = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->children;
	trkseg = _tmp2_;
	while (TRUE) {
		xmlNode* _tmp3_;
		xmlNode* _tmp4_;
		const gchar* _tmp5_;
		xmlNode* _tmp58_;
		xmlNode* _tmp59_;
		_tmp3_ = trkseg;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = trkseg;
		_tmp5_ = _tmp4_->name;
		if (g_strcmp0 (_tmp5_, "rtept") == 0) {
			xmlNode* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* lat;
			xmlNode* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* lon;
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp11_;
			gboolean _tmp13_;
			_tmp6_ = trkseg;
			_tmp7_ = xmlGetProp (_tmp6_, "lat");
			lat = _tmp7_;
			_tmp8_ = trkseg;
			_tmp9_ = xmlGetProp (_tmp8_, "lon");
			lon = _tmp9_;
			_tmp11_ = lat;
			if (_tmp11_ != NULL) {
				const gchar* _tmp12_;
				_tmp12_ = lon;
				_tmp10_ = _tmp12_ != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp13_ = _tmp10_;
			if (_tmp13_) {
				GpxPoint* _tmp14_;
				GpxPoint* p;
				const gchar* _tmp15_;
				gdouble _tmp16_ = 0.0;
				gdouble flat;
				const gchar* _tmp17_;
				gdouble _tmp18_ = 0.0;
				gdouble flon;
				GpxPoint* _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_;
				xmlNode* _tmp22_;
				xmlNode* _tmp23_;
				xmlNode* info;
				GpxPoint* _tmp40_;
				const gchar* _tmp41_;
				_tmp14_ = gpx_point_new ();
				p = _tmp14_;
				_tmp15_ = lat;
				_tmp16_ = double_parse (_tmp15_);
				flat = _tmp16_;
				_tmp17_ = lon;
				_tmp18_ = double_parse (_tmp17_);
				flon = _tmp18_;
				_tmp19_ = p;
				_tmp20_ = flat;
				_tmp21_ = flon;
				gpx_point_set_position (_tmp19_, _tmp20_, _tmp21_);
				_tmp22_ = trkseg;
				_tmp23_ = _tmp22_->children;
				info = _tmp23_;
				while (TRUE) {
					xmlNode* _tmp24_;
					xmlNode* _tmp25_;
					const gchar* _tmp26_;
					xmlNode* _tmp38_;
					xmlNode* _tmp39_;
					_tmp24_ = info;
					if (!(_tmp24_ != NULL)) {
						break;
					}
					_tmp25_ = info;
					_tmp26_ = _tmp25_->name;
					if (g_strcmp0 (_tmp26_, "ele") == 0) {
						xmlNode* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* content;
						const gchar* _tmp29_;
						_tmp27_ = info;
						_tmp28_ = xmlNodeGetContent (_tmp27_);
						content = _tmp28_;
						_tmp29_ = content;
						if (_tmp29_ != NULL) {
							GpxPoint* _tmp30_;
							const gchar* _tmp31_;
							gdouble _tmp32_ = 0.0;
							_tmp30_ = p;
							_tmp31_ = content;
							_tmp32_ = double_parse (_tmp31_);
							_tmp30_->elevation = _tmp32_;
						}
						_g_free0 (content);
					} else {
						xmlNode* _tmp33_;
						const gchar* _tmp34_;
						_tmp33_ = info;
						_tmp34_ = _tmp33_->name;
						if (g_strcmp0 (_tmp34_, "time") == 0) {
							GpxPoint* _tmp35_;
							xmlNode* _tmp36_;
							gchar* _tmp37_ = NULL;
							_tmp35_ = p;
							_tmp36_ = info;
							_tmp37_ = xmlNodeGetContent (_tmp36_);
							_g_free0 (_tmp35_->time);
							_tmp35_->time = _tmp37_;
						}
					}
					_tmp38_ = info;
					_tmp39_ = _tmp38_->next;
					info = _tmp39_;
				}
				_tmp40_ = p;
				_tmp41_ = _tmp40_->time;
				if (_tmp41_ != NULL) {
					GpxTrack* _tmp42_;
					GpxPoint* _tmp43_;
					_tmp42_ = track;
					_tmp43_ = p;
					gpx_track_add_point (_tmp42_, _tmp43_);
				}
				_gpx_point_unref0 (p);
			} else {
				xmlNode* _tmp44_;
				const gchar* _tmp45_;
				_tmp44_ = trkseg;
				_tmp45_ = _tmp44_->name;
				g_message ("gpx-parser-xml.vala:189: Failed to get trkseg: %s\n", _tmp45_);
			}
			_g_free0 (lon);
			_g_free0 (lat);
		} else {
			xmlNode* _tmp46_;
			const gchar* _tmp47_;
			_tmp46_ = trkseg;
			_tmp47_ = _tmp46_->name;
			if (g_strcmp0 (_tmp47_, "name") == 0) {
				GpxTrack* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp48_ = track;
				_tmp49_ = gpx_track_get_name (_tmp48_);
				_tmp50_ = _tmp49_;
				if (_tmp50_ == NULL) {
					GpxTrack* _tmp51_;
					xmlNode* _tmp52_;
					gchar* _tmp53_ = NULL;
					gchar* _tmp54_;
					_tmp51_ = track;
					_tmp52_ = trkseg;
					_tmp53_ = xmlNodeGetContent (_tmp52_);
					_tmp54_ = _tmp53_;
					gpx_track_set_name (_tmp51_, _tmp54_);
					_g_free0 (_tmp54_);
				} else {
					GpxTrack* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp55_ = track;
					_tmp56_ = gpx_track_get_name (_tmp55_);
					_tmp57_ = _tmp56_;
					g_warning ("gpx-parser-xml.vala:200: Track name allready set: %s\n", _tmp57_);
				}
			}
		}
		_tmp58_ = trkseg;
		_tmp59_ = _tmp58_->next;
		trkseg = _tmp59_;
	}
	result = track;
	return result;
}


static gint gpx_xml_file_read_file (GpxXmlFile* self, guint8* buffer, int buffer_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GFileInputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		gssize _tmp2_ = 0L;
		gssize value;
		_tmp0_ = self->priv->stream;
		_tmp1_ = buffer;
		_tmp1__length1 = buffer_length1;
		_tmp2_ = g_input_stream_read ((GInputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, &_inner_error_);
		value = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		result = (gint) value;
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("gpx-parser-xml.vala:223: error reading from stream: %s\n", _tmp4_);
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint gpx_xml_file_close_file (GpxXmlFile* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_log ("GPX PARSER", G_LOG_LEVEL_DEBUG, "gpx-parser-xml.vala:229: Close_file()");
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = NULL;
	result = 0;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GpxXmlFile* gpx_xml_file_construct (GType object_type, GFile* file) {
	GpxXmlFile * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GpxXmlFile*) gpx_file_base_construct (object_type);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (((GpxFileBase*) self)->file);
	((GpxFileBase*) self)->file = _tmp1_;
	{
		GFile* _tmp2_;
		GFileInputStream* _tmp3_ = NULL;
		GFileInputStream* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		xmlTextReader* _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* reader;
		xmlTextReader* _tmp10_;
		xmlTextReader* _tmp47_;
		_tmp2_ = file;
		_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_object_unref0 (self->priv->stream);
		self->priv->stream = _tmp4_;
		_tmp5_ = ((GpxFileBase*) self)->file;
		_tmp6_ = g_file_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = xmlReaderForIO ((xmlInputReadCallback) gpx_xml_file_read_file, (xmlInputCloseCallback) gpx_xml_file_close_file, self, _tmp7_, "", 0);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		reader = _tmp9_;
		_tmp10_ = reader;
		if (_tmp10_ != NULL) {
			xmlTextReader* _tmp11_;
			gint _tmp12_ = 0;
			gint doc;
			_tmp11_ = reader;
			_tmp12_ = xmlTextReaderRead (_tmp11_);
			doc = _tmp12_;
			while (TRUE) {
				gint _tmp13_;
				xmlTextReader* _tmp14_;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* name;
				const gchar* _tmp17_;
				_tmp13_ = doc;
				if (!(_tmp13_ == 1)) {
					break;
				}
				_tmp14_ = reader;
				_tmp15_ = xmlTextReaderConstName (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				name = _tmp16_;
				_tmp17_ = name;
				if (g_strcmp0 (_tmp17_, "gpx") == 0) {
					xmlTextReader* _tmp18_;
					gint _tmp19_ = 0;
					gint doc2;
					_tmp18_ = reader;
					_tmp19_ = xmlTextReaderRead (_tmp18_);
					doc2 = _tmp19_;
					while (TRUE) {
						gint _tmp20_;
						xmlTextReader* _tmp21_;
						const gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gchar* name2;
						const gchar* _tmp24_;
						xmlTextReader* _tmp43_;
						gint _tmp44_ = 0;
						_tmp20_ = doc2;
						if (!(_tmp20_ == 1)) {
							break;
						}
						_tmp21_ = reader;
						_tmp22_ = xmlTextReaderConstName (_tmp21_);
						_tmp23_ = g_strdup (_tmp22_);
						name2 = _tmp23_;
						_tmp24_ = name2;
						if (g_strcmp0 (_tmp24_, "trk") == 0) {
							xmlTextReader* _tmp25_;
							xmlNode* _tmp26_ = NULL;
							xmlNode* node;
							xmlNode* _tmp27_;
							GpxTrack* _tmp28_ = NULL;
							GpxTrack* track;
							GpxTrack* _tmp29_;
							GpxTrack* _tmp30_;
							GpxTrack* _tmp31_;
							_tmp25_ = reader;
							_tmp26_ = xmlTextReaderExpand (_tmp25_);
							node = _tmp26_;
							_tmp27_ = node;
							_tmp28_ = gpx_xml_file_parse_track (self, _tmp27_);
							track = _tmp28_;
							_tmp29_ = track;
							gpx_track_filter_points (_tmp29_);
							_tmp30_ = track;
							_tmp31_ = _g_object_ref0 (_tmp30_);
							((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp31_);
							_g_object_unref0 (track);
						} else {
							const gchar* _tmp32_;
							_tmp32_ = name2;
							if (g_strcmp0 (_tmp32_, "wpt") == 0) {
								xmlTextReader* _tmp33_;
								xmlNode* _tmp34_ = NULL;
								xmlNode* node;
								xmlNode* _tmp35_;
								_tmp33_ = reader;
								_tmp34_ = xmlTextReaderExpand (_tmp33_);
								node = _tmp34_;
								_tmp35_ = node;
								gpx_xml_file_parse_waypoint (self, _tmp35_);
							} else {
								const gchar* _tmp36_;
								_tmp36_ = name2;
								if (g_strcmp0 (_tmp36_, "rte") == 0) {
									xmlTextReader* _tmp37_;
									xmlNode* _tmp38_ = NULL;
									xmlNode* node;
									xmlNode* _tmp39_;
									GpxTrack* _tmp40_ = NULL;
									GpxTrack* track;
									GpxTrack* _tmp41_;
									GpxTrack* _tmp42_;
									_tmp37_ = reader;
									_tmp38_ = xmlTextReaderExpand (_tmp37_);
									node = _tmp38_;
									_tmp39_ = node;
									_tmp40_ = gpx_xml_file_parse_route (self, _tmp39_);
									track = _tmp40_;
									_tmp41_ = track;
									_tmp42_ = _g_object_ref0 (_tmp41_);
									((GpxFileBase*) self)->routes = g_list_append (((GpxFileBase*) self)->routes, _tmp42_);
									_g_object_unref0 (track);
								}
							}
						}
						_tmp43_ = reader;
						_tmp44_ = xmlTextReaderNext (_tmp43_);
						doc2 = _tmp44_;
						_g_free0 (name2);
					}
				} else {
					xmlTextReader* _tmp45_;
					gint _tmp46_ = 0;
					_tmp45_ = reader;
					_tmp46_ = xmlTextReaderRead (_tmp45_);
					doc = _tmp46_;
				}
				_g_free0 (name);
			}
		} else {
			g_message ("gpx-parser-xml.vala:291: Failed to open file");
		}
		_tmp47_ = reader;
		xmlTextReaderClose (_tmp47_);
		_xmlFreeTextReader0 (reader);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GFile* _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = ((GpxFileBase*) self)->file;
		_tmp49_ = g_file_get_uri (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		g_critical ("gpx-parser-xml.vala:297: failed to open file: '%s' error: %s", _tmp50_, _tmp52_);
		_g_free0 (_tmp50_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


GpxXmlFile* gpx_xml_file_new (GFile* file) {
	return gpx_xml_file_construct (GPX_TYPE_XML_FILE, file);
}


static void gpx_xml_file_class_init (GpxXmlFileClass * klass) {
	gpx_xml_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GpxXmlFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = gpx_xml_file_finalize;
}


static void gpx_xml_file_instance_init (GpxXmlFile * self) {
	self->priv = GPX_XML_FILE_GET_PRIVATE (self);
	self->priv->stream = NULL;
}


static void gpx_xml_file_finalize (GObject* obj) {
	GpxXmlFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_XML_FILE, GpxXmlFile);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (gpx_xml_file_parent_class)->finalize (obj);
}


GType gpx_xml_file_get_type (void) {
	static volatile gsize gpx_xml_file_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_xml_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxXmlFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_xml_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxXmlFile), 0, (GInstanceInitFunc) gpx_xml_file_instance_init, NULL };
		GType gpx_xml_file_type_id;
		gpx_xml_file_type_id = g_type_register_static (GPX_TYPE_FILE_BASE, "GpxXmlFile", &g_define_type_info, 0);
		g_once_init_leave (&gpx_xml_file_type_id__volatile, gpx_xml_file_type_id);
	}
	return gpx_xml_file_type_id__volatile;
}



